/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.swe.scim.spec.protocol.filter;

import edu.psu.swe.scim.spec.protocol.attribute.AttributeReference;
import edu.psu.swe.scim.spec.protocol.filter.AttributeExpression;
import edu.psu.swe.scim.spec.protocol.filter.CompareOperator;
import edu.psu.swe.scim.spec.protocol.filter.ValueFilterExpression;
import java.beans.ConstructorProperties;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;

public final class AttributeComparisonExpression
implements AttributeExpression,
ValueFilterExpression {
    private final AttributeReference attributePath;
    private final CompareOperator operation;
    private final Object compareValue;
    private static final String ISO_8601_DATE_FORMAT = "yyyy-MM-dd";
    private static final String ISO_8601_DATE_TIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SS";
    private static final String QUOTE = "\"";

    @Override
    public String toFilter() {
        String compareValueString = null;
        if (this.compareValue == null) {
            compareValueString = "null";
        } else if (this.compareValue instanceof String) {
            compareValueString = QUOTE + this.compareValue + QUOTE;
        } else if (this.compareValue instanceof Number) {
            compareValueString = this.compareValue.toString();
        } else if (this.compareValue instanceof Date) {
            compareValueString = QUOTE + AttributeComparisonExpression.toDateTimeString((Date)this.compareValue) + QUOTE;
        } else if (this.compareValue instanceof LocalDate) {
            compareValueString = QUOTE + AttributeComparisonExpression.toDateString((LocalDate)this.compareValue) + QUOTE;
        } else if (this.compareValue instanceof LocalDateTime) {
            compareValueString = QUOTE + AttributeComparisonExpression.toDateTimeString((LocalDateTime)this.compareValue) + QUOTE;
        }
        return this.attributePath.getFullyQualifiedAttributeName() + " " + (Object)((Object)this.operation) + " " + compareValueString;
    }

    public static String toDateString(Date date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(ISO_8601_DATE_FORMAT);
        return dateFormat.format(date);
    }

    public static String toDateTimeString(Date date) {
        SimpleDateFormat dateTimeFormat = new SimpleDateFormat(ISO_8601_DATE_TIME_FORMAT);
        return dateTimeFormat.format(date);
    }

    public static String toDateString(LocalDate ld) {
        return ld.format(DateTimeFormatter.ISO_DATE);
    }

    public static String toDateTimeString(LocalDateTime ldt) {
        return ldt.format(DateTimeFormatter.ISO_DATE_TIME);
    }

    @ConstructorProperties(value={"attributePath", "operation", "compareValue"})
    public AttributeComparisonExpression(AttributeReference attributePath, CompareOperator operation, Object compareValue) {
        this.attributePath = attributePath;
        this.operation = operation;
        this.compareValue = compareValue;
    }

    public AttributeReference getAttributePath() {
        return this.attributePath;
    }

    public CompareOperator getOperation() {
        return this.operation;
    }

    public Object getCompareValue() {
        return this.compareValue;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AttributeComparisonExpression)) {
            return false;
        }
        AttributeComparisonExpression other = (AttributeComparisonExpression)o;
        AttributeReference this$attributePath = this.getAttributePath();
        AttributeReference other$attributePath = other.getAttributePath();
        if (this$attributePath == null ? other$attributePath != null : !((Object)this$attributePath).equals(other$attributePath)) {
            return false;
        }
        CompareOperator this$operation = this.getOperation();
        CompareOperator other$operation = other.getOperation();
        if (this$operation == null ? other$operation != null : !((Object)((Object)this$operation)).equals((Object)other$operation)) {
            return false;
        }
        Object this$compareValue = this.getCompareValue();
        Object other$compareValue = other.getCompareValue();
        return !(this$compareValue == null ? other$compareValue != null : !this$compareValue.equals(other$compareValue));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AttributeReference $attributePath = this.getAttributePath();
        result = result * 59 + ($attributePath == null ? 43 : ((Object)$attributePath).hashCode());
        CompareOperator $operation = this.getOperation();
        result = result * 59 + ($operation == null ? 43 : ((Object)((Object)$operation)).hashCode());
        Object $compareValue = this.getCompareValue();
        result = result * 59 + ($compareValue == null ? 43 : $compareValue.hashCode());
        return result;
    }

    public String toString() {
        return "AttributeComparisonExpression(attributePath=" + this.getAttributePath() + ", operation=" + (Object)((Object)this.getOperation()) + ", compareValue=" + this.getCompareValue() + ")";
    }
}

