/*
 * Decompiled with CFR 0.152.
 */
package io.github.jeremylong.openvulnerability.client.ghsa;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.samskivert.mustache.Mustache;
import com.samskivert.mustache.Template;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.github.jeremylong.openvulnerability.client.HttpAsyncClientSupplier;
import io.github.jeremylong.openvulnerability.client.PagedDataSource;
import io.github.jeremylong.openvulnerability.client.ghsa.CWEs;
import io.github.jeremylong.openvulnerability.client.ghsa.GitHubSecurityAdvisoryException;
import io.github.jeremylong.openvulnerability.client.ghsa.GithubRateLimitedAsyncClient;
import io.github.jeremylong.openvulnerability.client.ghsa.SecurityAdvisories;
import io.github.jeremylong.openvulnerability.client.ghsa.SecurityAdvisory;
import io.github.jeremylong.openvulnerability.client.ghsa.SecurityAdvisoryResponse;
import io.github.jeremylong.openvulnerability.client.ghsa.Vulnerabilities;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.apache.hc.client5.http.async.methods.SimpleHttpResponse;
import org.apache.hc.client5.http.async.methods.SimpleRequestBuilder;
import org.apache.hc.client5.http.impl.async.CloseableHttpAsyncClient;
import org.apache.hc.core5.http.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitHubSecurityAdvisoryClient
implements PagedDataSource<SecurityAdvisory> {
    public static final String GITHUB_GRAPHQL_ENDPOINT = "https://api.github.com/graphql";
    private static final Logger LOG = LoggerFactory.getLogger(GitHubSecurityAdvisoryClient.class);
    private static final String ADVISORIES_TEMPLATE = "securityAdvisories.mustache";
    private static final String VULNERABILITIES_TEMPLATE = "securityAdvisoryVulnerabilities.mustache";
    private static final String CWES_TEMPLATE = "securityAdvisoryCwes.mustache";
    private final GithubRateLimitedAsyncClient httpClient;
    private final ObjectMapper objectMapper;
    private final Template advistoriesTemplate;
    private final Template vulnerabilitiesTemplate;
    private final Template cwesTemplate;
    private boolean firstCall = true;
    private int lastStatusCode = 200;
    private int totalCount = 0;
    private int totalAvailable = -1;
    private Future<SimpleHttpResponse> futureResponse;
    private final String endpoint;
    private final String githubToken;
    private final String userAgent;
    private String classifications;
    private String updatedSinceFilter;
    private String publishedSinceFilter;
    private ZonedDateTime lastUpdated;
    private String version = "unknown";

    public GitHubSecurityAdvisoryClient(String githubToken) {
        this(githubToken, null);
    }

    public GitHubSecurityAdvisoryClient(String githubToken, String endpoint) {
        this(githubToken, endpoint, null);
    }

    @SuppressFBWarnings(value={"CT_CONSTRUCTOR_THROW"})
    public GitHubSecurityAdvisoryClient(String githubToken, String endpoint, HttpAsyncClientSupplier httpClientSupplier) {
        this(githubToken, endpoint, httpClientSupplier, null);
    }

    @SuppressFBWarnings(value={"CT_CONSTRUCTOR_THROW"})
    public GitHubSecurityAdvisoryClient(String githubToken, String endpoint, HttpAsyncClientSupplier httpClientSupplier, String userAgent) {
        this.githubToken = githubToken;
        this.userAgent = userAgent;
        this.endpoint = endpoint != null ? endpoint : GITHUB_GRAPHQL_ENDPOINT;
        this.advistoriesTemplate = this.loadMustacheTemplate(ADVISORIES_TEMPLATE);
        this.vulnerabilitiesTemplate = this.loadMustacheTemplate(VULNERABILITIES_TEMPLATE);
        this.cwesTemplate = this.loadMustacheTemplate(CWES_TEMPLATE);
        CloseableHttpAsyncClient rawClient = httpClientSupplier == null ? (CloseableHttpAsyncClient)HttpAsyncClientSupplier.getDefault().get() : (CloseableHttpAsyncClient)httpClientSupplier.get();
        rawClient.start();
        this.httpClient = new GithubRateLimitedAsyncClient(rawClient, 5, 300, 5);
        this.objectMapper = new ObjectMapper();
        this.objectMapper.registerModule((Module)new JavaTimeModule());
        try {
            Properties props = new Properties();
            props.load(this.getClass().getClassLoader().getResourceAsStream("version.properties"));
            this.version = props.getProperty("version");
        }
        catch (IOException e) {
            LOG.debug("Error loading version.properties", (Throwable)e);
        }
    }

    private Template loadMustacheTemplate(String resourceName) {
        String template;
        try (InputStream is = this.getClass().getClassLoader().getResourceAsStream(resourceName);
             InputStreamReader isr = new InputStreamReader(is, StandardCharsets.UTF_8);
             BufferedReader reader = new BufferedReader(isr);){
            template = reader.lines().collect(Collectors.joining(System.lineSeparator()));
        }
        catch (IOException e) {
            throw new GitHubSecurityAdvisoryException(e);
        }
        return Mustache.compiler().escapeHTML(false).compile(template);
    }

    public void setClassifications(String classifications) {
        this.classifications = classifications;
    }

    public void setUpdatedSinceFilter(ZonedDateTime utcUpdatedSinceFilter) {
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern("uuuu-MM-dd'T'HH:mm:ssX");
        this.updatedSinceFilter = utcUpdatedSinceFilter.format(dtf);
    }

    public void setPublishedSinceFilter(ZonedDateTime utcPublishedSinceFilter) {
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern("uuuu-MM-dd'T'HH:mm:ssX");
        this.publishedSinceFilter = utcPublishedSinceFilter.format(dtf);
    }

    private Future<SimpleHttpResponse> query(String json) {
        String payload;
        ObjectNode jsonObj = this.objectMapper.createObjectNode();
        jsonObj.put("query", json);
        try {
            payload = this.objectMapper.writeValueAsString((Object)jsonObj);
        }
        catch (JsonProcessingException e) {
            throw new GitHubSecurityAdvisoryException("Unable to convert template to query", e);
        }
        String auth = "Bearer " + this.githubToken;
        String ua = "open-vulnerability-client/" + this.version;
        if (this.userAgent != null) {
            ua = ua + "; " + this.userAgent;
        }
        String userAgentHeader = ua;
        return this.httpClient.execute(() -> {
            SimpleRequestBuilder builder = SimpleRequestBuilder.post((String)this.endpoint);
            builder.addHeader("Authorization", auth);
            builder.addHeader("User-Agent", userAgentHeader);
            builder.setBody(payload, ContentType.APPLICATION_JSON);
            return builder.build();
        });
    }

    @Override
    public void close() throws Exception {
        this.httpClient.close();
    }

    @Override
    public int getTotalAvailable() {
        return this.totalAvailable;
    }

    @Override
    public int getLastStatusCode() {
        return this.lastStatusCode;
    }

    @Override
    public boolean hasNext() {
        if (this.lastStatusCode != 200) {
            return false;
        }
        return this.firstCall || this.futureResponse != null;
    }

    @Override
    public Collection<SecurityAdvisory> next() {
        try {
            SimpleHttpResponse response;
            Map<String, String> data = this.buildGraphQLData();
            if (this.firstCall) {
                this.firstCall = false;
                this.futureResponse = this.query(this.advistoriesTemplate.execute(data));
            }
            if ((response = this.futureResponse.get()).getCode() == 200) {
                String body = response.getBodyText();
                if (body == null) {
                    body = new String(response.getBodyBytes(), StandardCharsets.UTF_8);
                }
                SecurityAdvisories results = (SecurityAdvisories)this.objectMapper.readValue(body, SecurityAdvisories.class);
                List<SecurityAdvisory> list = results.getSecurityAdvisories();
                this.totalCount += list.size();
                this.totalAvailable = results.getTotalCount();
                if (results.getPageInfo().isHasNextPage() || this.totalCount < this.totalAvailable) {
                    data.put("after", results.getPageInfo().getEndCursor());
                    this.futureResponse = this.query(this.advistoriesTemplate.execute(data));
                } else {
                    this.futureResponse = null;
                }
                this.ensureSubPages(list);
                this.lastUpdated = this.findLastUpdated(this.lastUpdated, list);
                return list;
            }
            this.lastStatusCode = response.getCode();
            String error = new String(response.getBodyBytes(), StandardCharsets.UTF_8);
            LOG.error(error);
            throw new GitHubSecurityAdvisoryException("GitHub GraphQL Returned Status Code: " + this.lastStatusCode);
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            LOG.debug("Interrupted", (Throwable)e);
            throw new GitHubSecurityAdvisoryException(e);
        }
        catch (JsonProcessingException | ExecutionException e) {
            LOG.debug(e.getMessage(), e);
            throw new GitHubSecurityAdvisoryException(e);
        }
    }

    private Map<String, String> buildGraphQLData() {
        HashMap<String, String> data = new HashMap<String, String>();
        if (this.classifications != null) {
            data.put("classifications", this.classifications);
        }
        if (this.updatedSinceFilter != null) {
            data.put("updatedSince", this.updatedSinceFilter);
        }
        if (this.publishedSinceFilter != null) {
            data.put("publishedSince", this.publishedSinceFilter);
        }
        return data;
    }

    @Override
    public ZonedDateTime getLastUpdated() {
        return this.lastUpdated;
    }

    private ZonedDateTime findLastUpdated(ZonedDateTime lastUpdatedDate, List<SecurityAdvisory> list) {
        ZonedDateTime current = lastUpdatedDate;
        for (SecurityAdvisory adv : list) {
            if (current != null && current.compareTo(adv.getUpdatedAt()) >= 0) continue;
            current = adv.getUpdatedAt();
        }
        return current;
    }

    private void ensureSubPages(List<SecurityAdvisory> list) throws ExecutionException, InterruptedException {
        for (SecurityAdvisory sa : list) {
            Vulnerabilities vulnerability;
            SecurityAdvisoryResponse results;
            int count;
            String after;
            int max;
            if (sa.getCwes().getPageInfo().isHasNextPage() || sa.getCwes().getTotalCount() > 50) {
                CWEs cwes;
                LOG.debug("Retrieving additional CWEs for " + sa.getGhsaId());
                max = sa.getCwes().getTotalCount();
                after = sa.getCwes().getPageInfo().getEndCursor();
                for (count = 50; count < max; count += cwes.getEdges().size()) {
                    results = this.fetch(this.cwesTemplate, sa.getGhsaId(), after);
                    cwes = results.getSecurityAdvisory().getCwes();
                    max = cwes.getTotalCount();
                    after = cwes.getPageInfo().getEndCursor();
                    sa.getCwes().addAllCwes(cwes.getEdges());
                }
            }
            if (!sa.getVulnerabilities().getPageInfo().isHasNextPage() && sa.getVulnerabilities().getTotalCount() <= 100) continue;
            LOG.debug("Retrieving additional Vulnerabilities for " + sa.getGhsaId());
            max = sa.getVulnerabilities().getTotalCount();
            after = sa.getVulnerabilities().getPageInfo().getEndCursor();
            for (count = 100; count < max; count += vulnerability.getEdges().size()) {
                results = this.fetch(this.vulnerabilitiesTemplate, sa.getGhsaId(), after);
                vulnerability = results.getSecurityAdvisory().getVulnerabilities();
                max = vulnerability.getTotalCount();
                after = vulnerability.getPageInfo().getEndCursor();
                sa.getVulnerabilities().addAllVulnerabilities(vulnerability.getEdges());
            }
        }
    }

    private SecurityAdvisoryResponse fetch(Template template, String ghsaId, String after) throws InterruptedException, ExecutionException {
        SecurityAdvisoryResponse results;
        try {
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("ghsaId", ghsaId);
            data.put("after", after);
            Future<SimpleHttpResponse> future = this.query(template.execute(data));
            SimpleHttpResponse response = future.get();
            String body = response.getBodyText();
            if (body == null) {
                body = new String(response.getBodyBytes(), StandardCharsets.UTF_8);
            }
            results = (SecurityAdvisoryResponse)this.objectMapper.readValue(body, SecurityAdvisoryResponse.class);
        }
        catch (JsonProcessingException e) {
            LOG.debug("Deserialization Error", (Throwable)e);
            throw new GitHubSecurityAdvisoryException(e);
        }
        return results;
    }
}

