/*
 * Decompiled with CFR 0.152.
 */
package io.github.jeremylong.openvulnerability.client.nvd;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"sourceIdentifier", "tags"})
@NullMarked
public class CveTag
implements Serializable {
    private static final long serialVersionUID = 6119071096772721680L;
    @JsonProperty(value="sourceIdentifier")
    private @Nullable String sourceIdentifier;
    @JsonProperty(value="tags")
    private @Nullable List<TagType> tags;

    public CveTag() {
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="I prefer to suppress these FindBugs warnings")
    public CveTag(@Nullable String sourceIdentifier, @Nullable List<TagType> tags) {
        this.sourceIdentifier = sourceIdentifier;
        this.tags = tags;
    }

    @JsonProperty(value="sourceIdentifier")
    public @Nullable String getSourceIdentifier() {
        return this.sourceIdentifier;
    }

    @JsonProperty(value="tags")
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="I prefer to suppress these FindBugs warnings")
    public @Nullable List<TagType> getTags() {
        return this.tags;
    }

    public String toString() {
        return "CveTag{sourceIdentifier='" + this.sourceIdentifier + "', tags=" + String.valueOf(this.tags) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CveTag cveTag = (CveTag)o;
        return Objects.equals(this.sourceIdentifier, cveTag.sourceIdentifier) && Objects.equals(this.tags, cveTag.tags);
    }

    public int hashCode() {
        return Objects.hash(this.sourceIdentifier, this.tags);
    }

    public static enum TagType {
        UNSUPPORTED_WHEN_ASSIGNED("unsupported-when-assigned"),
        EXCLUSIVELY_HOSTED_SERVICE("exclusively-hosted-service"),
        DISPUTED("disputed");

        private static final Map<String, TagType> CONSTANTS;
        private final String value;

        private TagType(String value) {
            this.value = value;
        }

        @JsonCreator
        public static TagType fromValue(String value) {
            TagType constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        static {
            CONSTANTS = new HashMap<String, TagType>();
            for (TagType c : TagType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

