/*
 * Decompiled with CFR 0.152.
 */
package io.github.jeremylong.openvulnerability.client.nvd;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonPropertyOrder(value={"version", "vectorString", "attackVector", "attackComplexity", "privilegesRequired", "userInteraction", "scope", "confidentialityImpact", "integrityImpact", "availabilityImpact", "baseScore", "baseSeverity", "exploitCodeMaturity", "remediationLevel", "reportConfidence", "temporalScore", "temporalSeverity", "confidentialityRequirement", "integrityRequirement", "availabilityRequirement", "modifiedAttackVector", "modifiedAttackComplexity", "modifiedPrivilegesRequired", "modifiedUserInteraction", "modifiedScope", "modifiedConfidentialityImpact", "modifiedIntegrityImpact", "modifiedAvailabilityImpact", "environmentalScore", "environmentalSeverity"})
@NullMarked
public class CvssV3Data
implements Serializable {
    private static final long serialVersionUID = 8537782209754450697L;
    @JsonProperty(value="version")
    @JsonPropertyDescription(value="CVSS Version")
    private Version version;
    @JsonProperty(value="vectorString")
    private String vectorString;
    @JsonProperty(value="attackVector")
    private @Nullable AttackVectorType attackVector;
    @JsonProperty(value="attackComplexity")
    private @Nullable AttackComplexityType attackComplexity;
    @JsonProperty(value="privilegesRequired")
    private @Nullable PrivilegesRequiredType privilegesRequired;
    @JsonProperty(value="userInteraction")
    private @Nullable UserInteractionType userInteraction;
    @JsonProperty(value="scope")
    private @Nullable ScopeType scope;
    @JsonProperty(value="confidentialityImpact")
    private @Nullable CiaType confidentialityImpact;
    @JsonProperty(value="integrityImpact")
    private @Nullable CiaType integrityImpact;
    @JsonProperty(value="availabilityImpact")
    private @Nullable CiaType availabilityImpact;
    @JsonProperty(value="baseScore")
    private Double baseScore;
    @JsonProperty(value="baseSeverity")
    private SeverityType baseSeverity;
    @JsonProperty(value="exploitCodeMaturity")
    private @Nullable ExploitCodeMaturityType exploitCodeMaturity;
    @JsonProperty(value="remediationLevel")
    private @Nullable RemediationLevelType remediationLevel;
    @JsonProperty(value="reportConfidence")
    private @Nullable ConfidenceType reportConfidence;
    @JsonProperty(value="temporalScore")
    private @Nullable Double temporalScore;
    @JsonProperty(value="temporalSeverity")
    private @Nullable SeverityType temporalSeverity;
    @JsonProperty(value="confidentialityRequirement")
    private @Nullable CiaRequirementType confidentialityRequirement;
    @JsonProperty(value="integrityRequirement")
    private @Nullable CiaRequirementType integrityRequirement;
    @JsonProperty(value="availabilityRequirement")
    private @Nullable CiaRequirementType availabilityRequirement;
    @JsonProperty(value="modifiedAttackVector")
    private @Nullable ModifiedAttackVectorType modifiedAttackVector;
    @JsonProperty(value="modifiedAttackComplexity")
    private @Nullable ModifiedAttackComplexityType modifiedAttackComplexity;
    @JsonProperty(value="modifiedPrivilegesRequired")
    private @Nullable ModifiedPrivilegesRequiredType modifiedPrivilegesRequired;
    @JsonProperty(value="modifiedUserInteraction")
    private @Nullable ModifiedUserInteractionType modifiedUserInteraction;
    @JsonProperty(value="modifiedScope")
    private @Nullable ModifiedScopeType modifiedScope;
    @JsonProperty(value="modifiedConfidentialityImpact")
    private @Nullable ModifiedCiaType modifiedConfidentialityImpact;
    @JsonProperty(value="modifiedIntegrityImpact")
    private @Nullable ModifiedCiaType modifiedIntegrityImpact;
    @JsonProperty(value="modifiedAvailabilityImpact")
    private @Nullable ModifiedCiaType modifiedAvailabilityImpact;
    @JsonProperty(value="environmentalScore")
    private @Nullable Double environmentalScore;
    @JsonProperty(value="environmentalSeverity")
    private @Nullable SeverityType environmentalSeverity;

    @JsonCreator
    public CvssV3Data(@JsonProperty(value="version") Version version, @JsonProperty(value="vectorString") String vectorString, @JsonProperty(value="baseScore") Double baseScore, @JsonProperty(value="baseSeverity") SeverityType baseSeverity) {
        this.version = version;
        this.vectorString = vectorString;
        this.baseScore = baseScore;
        this.baseSeverity = baseSeverity;
    }

    public CvssV3Data(Version version, String vectorString, @Nullable AttackVectorType attackVector, @Nullable AttackComplexityType attackComplexity, @Nullable PrivilegesRequiredType privilegesRequired, @Nullable UserInteractionType userInteraction, @Nullable ScopeType scope, @Nullable CiaType confidentialityImpact, @Nullable CiaType integrityImpact, @Nullable CiaType availabilityImpact, Double baseScore, SeverityType baseSeverity, @Nullable ExploitCodeMaturityType exploitCodeMaturity, @Nullable RemediationLevelType remediationLevel, @Nullable ConfidenceType reportConfidence, @Nullable Double temporalScore, @Nullable SeverityType temporalSeverity, @Nullable CiaRequirementType confidentialityRequirement, @Nullable CiaRequirementType integrityRequirement, @Nullable CiaRequirementType availabilityRequirement, @Nullable ModifiedAttackVectorType modifiedAttackVector, @Nullable ModifiedAttackComplexityType modifiedAttackComplexity, @Nullable ModifiedPrivilegesRequiredType modifiedPrivilegesRequired, @Nullable ModifiedUserInteractionType modifiedUserInteraction, @Nullable ModifiedScopeType modifiedScope, @Nullable ModifiedCiaType modifiedConfidentialityImpact, @Nullable ModifiedCiaType modifiedIntegrityImpact, @Nullable ModifiedCiaType modifiedAvailabilityImpact, @Nullable Double environmentalScore, @Nullable SeverityType environmentalSeverity) {
        this(version, vectorString, baseScore, baseSeverity);
        this.attackVector = attackVector;
        this.attackComplexity = attackComplexity;
        this.privilegesRequired = privilegesRequired;
        this.userInteraction = userInteraction;
        this.scope = scope;
        this.confidentialityImpact = confidentialityImpact;
        this.integrityImpact = integrityImpact;
        this.availabilityImpact = availabilityImpact;
        this.exploitCodeMaturity = exploitCodeMaturity;
        this.remediationLevel = remediationLevel;
        this.reportConfidence = reportConfidence;
        this.temporalScore = temporalScore;
        this.temporalSeverity = temporalSeverity;
        this.confidentialityRequirement = confidentialityRequirement;
        this.integrityRequirement = integrityRequirement;
        this.availabilityRequirement = availabilityRequirement;
        this.modifiedAttackVector = modifiedAttackVector;
        this.modifiedAttackComplexity = modifiedAttackComplexity;
        this.modifiedPrivilegesRequired = modifiedPrivilegesRequired;
        this.modifiedUserInteraction = modifiedUserInteraction;
        this.modifiedScope = modifiedScope;
        this.modifiedConfidentialityImpact = modifiedConfidentialityImpact;
        this.modifiedIntegrityImpact = modifiedIntegrityImpact;
        this.modifiedAvailabilityImpact = modifiedAvailabilityImpact;
        this.environmentalScore = environmentalScore;
        this.environmentalSeverity = environmentalSeverity;
    }

    @JsonProperty(value="version")
    public Version getVersion() {
        return this.version;
    }

    @JsonProperty(value="vectorString")
    public String getVectorString() {
        return this.vectorString;
    }

    @JsonProperty(value="attackVector")
    public @Nullable AttackVectorType getAttackVector() {
        return this.attackVector;
    }

    @JsonProperty(value="attackComplexity")
    public @Nullable AttackComplexityType getAttackComplexity() {
        return this.attackComplexity;
    }

    @JsonProperty(value="privilegesRequired")
    public @Nullable PrivilegesRequiredType getPrivilegesRequired() {
        return this.privilegesRequired;
    }

    @JsonProperty(value="userInteraction")
    public @Nullable UserInteractionType getUserInteraction() {
        return this.userInteraction;
    }

    @JsonProperty(value="scope")
    public @Nullable ScopeType getScope() {
        return this.scope;
    }

    @JsonProperty(value="confidentialityImpact")
    public @Nullable CiaType getConfidentialityImpact() {
        return this.confidentialityImpact;
    }

    @JsonProperty(value="integrityImpact")
    public @Nullable CiaType getIntegrityImpact() {
        return this.integrityImpact;
    }

    @JsonProperty(value="availabilityImpact")
    public @Nullable CiaType getAvailabilityImpact() {
        return this.availabilityImpact;
    }

    @JsonProperty(value="baseScore")
    public Double getBaseScore() {
        return this.baseScore;
    }

    @JsonProperty(value="baseSeverity")
    public SeverityType getBaseSeverity() {
        return this.baseSeverity;
    }

    @JsonProperty(value="exploitCodeMaturity")
    public @Nullable ExploitCodeMaturityType getExploitCodeMaturity() {
        return this.exploitCodeMaturity;
    }

    @JsonProperty(value="remediationLevel")
    public @Nullable RemediationLevelType getRemediationLevel() {
        return this.remediationLevel;
    }

    @JsonProperty(value="reportConfidence")
    public @Nullable ConfidenceType getReportConfidence() {
        return this.reportConfidence;
    }

    @JsonProperty(value="temporalScore")
    public @Nullable Double getTemporalScore() {
        return this.temporalScore;
    }

    @JsonProperty(value="temporalSeverity")
    public @Nullable SeverityType getTemporalSeverity() {
        return this.temporalSeverity;
    }

    @JsonProperty(value="confidentialityRequirement")
    public @Nullable CiaRequirementType getConfidentialityRequirement() {
        return this.confidentialityRequirement;
    }

    @JsonProperty(value="integrityRequirement")
    public @Nullable CiaRequirementType getIntegrityRequirement() {
        return this.integrityRequirement;
    }

    @JsonProperty(value="availabilityRequirement")
    public @Nullable CiaRequirementType getAvailabilityRequirement() {
        return this.availabilityRequirement;
    }

    @JsonProperty(value="modifiedAttackVector")
    public @Nullable ModifiedAttackVectorType getModifiedAttackVector() {
        return this.modifiedAttackVector;
    }

    @JsonProperty(value="modifiedAttackComplexity")
    public @Nullable ModifiedAttackComplexityType getModifiedAttackComplexity() {
        return this.modifiedAttackComplexity;
    }

    @JsonProperty(value="modifiedPrivilegesRequired")
    public @Nullable ModifiedPrivilegesRequiredType getModifiedPrivilegesRequired() {
        return this.modifiedPrivilegesRequired;
    }

    @JsonProperty(value="modifiedUserInteraction")
    public @Nullable ModifiedUserInteractionType getModifiedUserInteraction() {
        return this.modifiedUserInteraction;
    }

    @JsonProperty(value="modifiedScope")
    public @Nullable ModifiedScopeType getModifiedScope() {
        return this.modifiedScope;
    }

    @JsonProperty(value="modifiedConfidentialityImpact")
    public @Nullable ModifiedCiaType getModifiedConfidentialityImpact() {
        return this.modifiedConfidentialityImpact;
    }

    @JsonProperty(value="modifiedIntegrityImpact")
    public @Nullable ModifiedCiaType getModifiedIntegrityImpact() {
        return this.modifiedIntegrityImpact;
    }

    @JsonProperty(value="modifiedAvailabilityImpact")
    public @Nullable ModifiedCiaType getModifiedAvailabilityImpact() {
        return this.modifiedAvailabilityImpact;
    }

    @JsonProperty(value="environmentalScore")
    public @Nullable Double getEnvironmentalScore() {
        return this.environmentalScore;
    }

    @JsonProperty(value="environmentalSeverity")
    public @Nullable SeverityType getEnvironmentalSeverity() {
        return this.environmentalSeverity;
    }

    public String toString() {
        return String.format("CVSS:%s/AV:%s/AC:%s/PR:%s/UI:%s/S:%s/C:%s/I:%s/A:%s", new Object[]{this.version, this.attackVector == null ? "" : this.attackVector.value().substring(0, 1), this.attackComplexity == null ? "" : this.attackComplexity.value().substring(0, 1), this.privilegesRequired == null ? "" : this.privilegesRequired.value().substring(0, 1), this.userInteraction == null ? "" : this.userInteraction.value().substring(0, 1), this.scope == null ? "" : this.scope.value().substring(0, 1), this.confidentialityImpact == null ? "" : this.confidentialityImpact.value().substring(0, 1), this.integrityImpact == null ? "" : this.integrityImpact.value().substring(0, 1), this.availabilityImpact == null ? "" : this.availabilityImpact.value().substring(0, 1)});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CvssV3Data that = (CvssV3Data)o;
        return this.version == that.version && Objects.equals(this.vectorString, that.vectorString) && this.attackVector == that.attackVector && this.attackComplexity == that.attackComplexity && this.privilegesRequired == that.privilegesRequired && this.userInteraction == that.userInteraction && this.scope == that.scope && this.confidentialityImpact == that.confidentialityImpact && this.integrityImpact == that.integrityImpact && this.availabilityImpact == that.availabilityImpact && Objects.equals(this.baseScore, that.baseScore) && this.baseSeverity == that.baseSeverity && this.exploitCodeMaturity == that.exploitCodeMaturity && this.remediationLevel == that.remediationLevel && this.reportConfidence == that.reportConfidence && Objects.equals(this.temporalScore, that.temporalScore) && this.temporalSeverity == that.temporalSeverity && this.confidentialityRequirement == that.confidentialityRequirement && this.integrityRequirement == that.integrityRequirement && this.availabilityRequirement == that.availabilityRequirement && this.modifiedAttackVector == that.modifiedAttackVector && this.modifiedAttackComplexity == that.modifiedAttackComplexity && this.modifiedPrivilegesRequired == that.modifiedPrivilegesRequired && this.modifiedUserInteraction == that.modifiedUserInteraction && this.modifiedScope == that.modifiedScope && this.modifiedConfidentialityImpact == that.modifiedConfidentialityImpact && this.modifiedIntegrityImpact == that.modifiedIntegrityImpact && this.modifiedAvailabilityImpact == that.modifiedAvailabilityImpact && Objects.equals(this.environmentalScore, that.environmentalScore) && this.environmentalSeverity == that.environmentalSeverity;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.version, this.vectorString, this.attackVector, this.attackComplexity, this.privilegesRequired, this.userInteraction, this.scope, this.confidentialityImpact, this.integrityImpact, this.availabilityImpact, this.baseScore, this.baseSeverity, this.exploitCodeMaturity, this.remediationLevel, this.reportConfidence, this.temporalScore, this.temporalSeverity, this.confidentialityRequirement, this.integrityRequirement, this.availabilityRequirement, this.modifiedAttackVector, this.modifiedAttackComplexity, this.modifiedPrivilegesRequired, this.modifiedUserInteraction, this.modifiedScope, this.modifiedConfidentialityImpact, this.modifiedIntegrityImpact, this.modifiedAvailabilityImpact, this.environmentalScore, this.environmentalSeverity});
    }

    public static enum Version {
        _3_0("3.0"),
        _3_1("3.1");

        private static final Map<String, Version> CONSTANTS;
        private final String value;

        private Version(String value) {
            this.value = value;
        }

        @JsonCreator
        public static Version fromValue(String value) {
            Version constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        static {
            CONSTANTS = new HashMap<String, Version>();
            for (Version c : Version.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum SeverityType {
        NONE("NONE"),
        LOW("LOW"),
        MEDIUM("MEDIUM"),
        HIGH("HIGH"),
        CRITICAL("CRITICAL");

        private static final Map<String, SeverityType> CONSTANTS;
        private final String value;

        private SeverityType(String value) {
            this.value = value;
        }

        @JsonCreator
        public static SeverityType fromValue(String value) {
            SeverityType constant;
            if (value.length() == 1) {
                for (SeverityType t : SeverityType.values()) {
                    if (!t.value.startsWith(value)) continue;
                    return t;
                }
            }
            if ((constant = CONSTANTS.get(value)) == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        static {
            CONSTANTS = new HashMap<String, SeverityType>();
            for (SeverityType c : SeverityType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum AttackVectorType {
        NETWORK("NETWORK"),
        ADJACENT_NETWORK("ADJACENT_NETWORK"),
        LOCAL("LOCAL"),
        PHYSICAL("PHYSICAL");

        private static final Map<String, AttackVectorType> CONSTANTS;
        private final String value;

        private AttackVectorType(String value) {
            this.value = value;
        }

        @JsonCreator
        public static AttackVectorType fromValue(String value) {
            AttackVectorType constant;
            if (value.length() == 1) {
                for (AttackVectorType t : AttackVectorType.values()) {
                    if (!t.value.startsWith(value)) continue;
                    return t;
                }
            }
            if ((constant = CONSTANTS.get(value)) == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        static {
            CONSTANTS = new HashMap<String, AttackVectorType>();
            for (AttackVectorType c : AttackVectorType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum AttackComplexityType {
        HIGH("HIGH"),
        LOW("LOW");

        private static final Map<String, AttackComplexityType> CONSTANTS;
        private final String value;

        private AttackComplexityType(String value) {
            this.value = value;
        }

        @JsonCreator
        public static AttackComplexityType fromValue(String value) {
            AttackComplexityType constant;
            if (value.length() == 1) {
                for (AttackComplexityType t : AttackComplexityType.values()) {
                    if (!t.value.startsWith(value)) continue;
                    return t;
                }
            }
            if ((constant = CONSTANTS.get(value)) == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        static {
            CONSTANTS = new HashMap<String, AttackComplexityType>();
            for (AttackComplexityType c : AttackComplexityType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum PrivilegesRequiredType {
        HIGH("HIGH"),
        LOW("LOW"),
        NONE("NONE");

        private static final Map<String, PrivilegesRequiredType> CONSTANTS;
        private final String value;

        private PrivilegesRequiredType(String value) {
            this.value = value;
        }

        @JsonCreator
        public static PrivilegesRequiredType fromValue(String value) {
            PrivilegesRequiredType constant;
            if (value.length() == 1) {
                for (PrivilegesRequiredType t : PrivilegesRequiredType.values()) {
                    if (!t.value.startsWith(value)) continue;
                    return t;
                }
            }
            if ((constant = CONSTANTS.get(value)) == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        static {
            CONSTANTS = new HashMap<String, PrivilegesRequiredType>();
            for (PrivilegesRequiredType c : PrivilegesRequiredType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum UserInteractionType {
        NONE("NONE"),
        REQUIRED("REQUIRED");

        private static final Map<String, UserInteractionType> CONSTANTS;
        private final String value;

        private UserInteractionType(String value) {
            this.value = value;
        }

        @JsonCreator
        public static UserInteractionType fromValue(String value) {
            UserInteractionType constant;
            if (value.length() == 1) {
                for (UserInteractionType t : UserInteractionType.values()) {
                    if (!t.value.startsWith(value)) continue;
                    return t;
                }
            }
            if ((constant = CONSTANTS.get(value)) == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        static {
            CONSTANTS = new HashMap<String, UserInteractionType>();
            for (UserInteractionType c : UserInteractionType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum ScopeType {
        UNCHANGED("UNCHANGED"),
        CHANGED("CHANGED");

        private static final Map<String, ScopeType> CONSTANTS;
        private final String value;

        private ScopeType(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ScopeType fromValue(String value) {
            ScopeType constant;
            if (value.length() == 1) {
                for (ScopeType t : ScopeType.values()) {
                    if (!t.value.startsWith(value)) continue;
                    return t;
                }
            }
            if ((constant = CONSTANTS.get(value)) == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        static {
            CONSTANTS = new HashMap<String, ScopeType>();
            for (ScopeType c : ScopeType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum CiaType {
        NONE("NONE"),
        LOW("LOW"),
        HIGH("HIGH");

        private static final Map<String, CiaType> CONSTANTS;
        private final String value;

        private CiaType(String value) {
            this.value = value;
        }

        @JsonCreator
        public static CiaType fromValue(String value) {
            CiaType constant;
            if (value.length() == 1) {
                for (CiaType t : CiaType.values()) {
                    if (!t.value.startsWith(value)) continue;
                    return t;
                }
            }
            if ((constant = CONSTANTS.get(value)) == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        static {
            CONSTANTS = new HashMap<String, CiaType>();
            for (CiaType c : CiaType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum ExploitCodeMaturityType {
        UNPROVEN("UNPROVEN"),
        PROOF_OF_CONCEPT("PROOF_OF_CONCEPT"),
        FUNCTIONAL("FUNCTIONAL"),
        HIGH("HIGH"),
        NOT_DEFINED("NOT_DEFINED");

        private static final Map<String, ExploitCodeMaturityType> CONSTANTS;
        private final String value;

        private ExploitCodeMaturityType(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ExploitCodeMaturityType fromValue(String value) {
            ExploitCodeMaturityType constant;
            if (value.length() == 1) {
                if ("x".equalsIgnoreCase(value)) {
                    return NOT_DEFINED;
                }
                for (ExploitCodeMaturityType t : ExploitCodeMaturityType.values()) {
                    if (!t.value.startsWith(value)) continue;
                    return t;
                }
            }
            if ((constant = CONSTANTS.get(value)) == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        static {
            CONSTANTS = new HashMap<String, ExploitCodeMaturityType>();
            for (ExploitCodeMaturityType c : ExploitCodeMaturityType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum RemediationLevelType {
        OFFICIAL_FIX("OFFICIAL_FIX"),
        TEMPORARY_FIX("TEMPORARY_FIX"),
        WORKAROUND("WORKAROUND"),
        UNAVAILABLE("UNAVAILABLE"),
        NOT_DEFINED("NOT_DEFINED");

        private static final Map<String, RemediationLevelType> CONSTANTS;
        private final String value;

        private RemediationLevelType(String value) {
            this.value = value;
        }

        @JsonCreator
        public static RemediationLevelType fromValue(String value) {
            RemediationLevelType constant;
            if (value.length() == 1) {
                if ("x".equalsIgnoreCase(value)) {
                    return NOT_DEFINED;
                }
                for (RemediationLevelType t : RemediationLevelType.values()) {
                    if (!t.value.startsWith(value)) continue;
                    return t;
                }
            }
            if ((constant = CONSTANTS.get(value)) == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        static {
            CONSTANTS = new HashMap<String, RemediationLevelType>();
            for (RemediationLevelType c : RemediationLevelType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum ConfidenceType {
        UNKNOWN("UNKNOWN"),
        REASONABLE("REASONABLE"),
        CONFIRMED("CONFIRMED"),
        NOT_DEFINED("NOT_DEFINED");

        private static final Map<String, ConfidenceType> CONSTANTS;
        private final String value;

        private ConfidenceType(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ConfidenceType fromValue(String value) {
            ConfidenceType constant;
            if (value.length() == 1) {
                if ("x".equalsIgnoreCase(value)) {
                    return NOT_DEFINED;
                }
                for (ConfidenceType t : ConfidenceType.values()) {
                    if (!t.value.startsWith(value)) continue;
                    return t;
                }
            }
            if ((constant = CONSTANTS.get(value)) == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        static {
            CONSTANTS = new HashMap<String, ConfidenceType>();
            for (ConfidenceType c : ConfidenceType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum CiaRequirementType {
        LOW("LOW"),
        MEDIUM("MEDIUM"),
        HIGH("HIGH"),
        NOT_DEFINED("NOT_DEFINED");

        private static final Map<String, CiaRequirementType> CONSTANTS;
        private final String value;

        private CiaRequirementType(String value) {
            this.value = value;
        }

        @JsonCreator
        public static CiaRequirementType fromValue(String value) {
            CiaRequirementType constant;
            if (value.length() == 1) {
                if ("x".equalsIgnoreCase(value)) {
                    return NOT_DEFINED;
                }
                for (CiaRequirementType t : CiaRequirementType.values()) {
                    if (!t.value.startsWith(value)) continue;
                    return t;
                }
            }
            if ((constant = CONSTANTS.get(value)) == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        static {
            CONSTANTS = new HashMap<String, CiaRequirementType>();
            for (CiaRequirementType c : CiaRequirementType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum ModifiedAttackVectorType {
        NETWORK("NETWORK"),
        ADJACENT_NETWORK("ADJACENT_NETWORK"),
        LOCAL("LOCAL"),
        PHYSICAL("PHYSICAL"),
        NOT_DEFINED("NOT_DEFINED");

        private static final Map<String, ModifiedAttackVectorType> CONSTANTS;
        private final String value;

        private ModifiedAttackVectorType(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ModifiedAttackVectorType fromValue(String value) {
            ModifiedAttackVectorType constant;
            if (value.length() == 1) {
                if ("x".equalsIgnoreCase(value)) {
                    return NOT_DEFINED;
                }
                for (ModifiedAttackVectorType t : ModifiedAttackVectorType.values()) {
                    if (!t.value.startsWith(value)) continue;
                    return t;
                }
            }
            if ((constant = CONSTANTS.get(value)) == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        static {
            CONSTANTS = new HashMap<String, ModifiedAttackVectorType>();
            for (ModifiedAttackVectorType c : ModifiedAttackVectorType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum ModifiedAttackComplexityType {
        HIGH("HIGH"),
        LOW("LOW"),
        NOT_DEFINED("NOT_DEFINED");

        private static final Map<String, ModifiedAttackComplexityType> CONSTANTS;
        private final String value;

        private ModifiedAttackComplexityType(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ModifiedAttackComplexityType fromValue(String value) {
            ModifiedAttackComplexityType constant;
            if (value.length() == 1) {
                if ("x".equalsIgnoreCase(value)) {
                    return NOT_DEFINED;
                }
                for (ModifiedAttackComplexityType t : ModifiedAttackComplexityType.values()) {
                    if (!t.value.startsWith(value)) continue;
                    return t;
                }
            }
            if ((constant = CONSTANTS.get(value)) == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        static {
            CONSTANTS = new HashMap<String, ModifiedAttackComplexityType>();
            for (ModifiedAttackComplexityType c : ModifiedAttackComplexityType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum ModifiedPrivilegesRequiredType {
        HIGH("HIGH"),
        LOW("LOW"),
        NONE("NONE"),
        NOT_DEFINED("NOT_DEFINED");

        private static final Map<String, ModifiedPrivilegesRequiredType> CONSTANTS;
        private final String value;

        private ModifiedPrivilegesRequiredType(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ModifiedPrivilegesRequiredType fromValue(String value) {
            ModifiedPrivilegesRequiredType constant;
            if (value.length() == 1) {
                if ("x".equalsIgnoreCase(value)) {
                    return NOT_DEFINED;
                }
                for (ModifiedPrivilegesRequiredType t : ModifiedPrivilegesRequiredType.values()) {
                    if (!t.value.startsWith(value)) continue;
                    return t;
                }
            }
            if ((constant = CONSTANTS.get(value)) == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        static {
            CONSTANTS = new HashMap<String, ModifiedPrivilegesRequiredType>();
            for (ModifiedPrivilegesRequiredType c : ModifiedPrivilegesRequiredType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum ModifiedUserInteractionType {
        NONE("NONE"),
        REQUIRED("REQUIRED"),
        NOT_DEFINED("NOT_DEFINED");

        private static final Map<String, ModifiedUserInteractionType> CONSTANTS;
        private final String value;

        private ModifiedUserInteractionType(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ModifiedUserInteractionType fromValue(String value) {
            ModifiedUserInteractionType constant;
            if (value.length() == 1) {
                if ("x".equalsIgnoreCase(value)) {
                    return NOT_DEFINED;
                }
                for (ModifiedUserInteractionType t : ModifiedUserInteractionType.values()) {
                    if (!t.value.startsWith(value)) continue;
                    return t;
                }
            }
            if ((constant = CONSTANTS.get(value)) == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        static {
            CONSTANTS = new HashMap<String, ModifiedUserInteractionType>();
            for (ModifiedUserInteractionType c : ModifiedUserInteractionType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum ModifiedScopeType {
        UNCHANGED("UNCHANGED"),
        CHANGED("CHANGED"),
        NOT_DEFINED("NOT_DEFINED");

        private static final Map<String, ModifiedScopeType> CONSTANTS;
        private final String value;

        private ModifiedScopeType(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ModifiedScopeType fromValue(String value) {
            ModifiedScopeType constant;
            if (value.length() == 1) {
                if ("x".equalsIgnoreCase(value)) {
                    return NOT_DEFINED;
                }
                for (ModifiedScopeType t : ModifiedScopeType.values()) {
                    if (!t.value.startsWith(value)) continue;
                    return t;
                }
            }
            if ((constant = CONSTANTS.get(value)) == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        static {
            CONSTANTS = new HashMap<String, ModifiedScopeType>();
            for (ModifiedScopeType c : ModifiedScopeType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum ModifiedCiaType {
        NONE("NONE"),
        LOW("LOW"),
        HIGH("HIGH"),
        NOT_DEFINED("NOT_DEFINED");

        private static final Map<String, ModifiedCiaType> CONSTANTS;
        private final String value;

        private ModifiedCiaType(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ModifiedCiaType fromValue(String value) {
            ModifiedCiaType constant;
            if (value.length() == 1) {
                if ("x".equalsIgnoreCase(value)) {
                    return NOT_DEFINED;
                }
                for (ModifiedCiaType t : ModifiedCiaType.values()) {
                    if (!t.value.startsWith(value)) continue;
                    return t;
                }
            }
            if ((constant = CONSTANTS.get(value)) == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        static {
            CONSTANTS = new HashMap<String, ModifiedCiaType>();
            for (ModifiedCiaType c : ModifiedCiaType.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

