/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.chain.impl;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.chain.Context;

public class ContextBase
extends HashMap<String, Object>
implements Context {
    private static final long serialVersionUID = -2482145117370708259L;
    private static final Object SINGLETON = new Serializable(){
        private static final long serialVersionUID = -6023767081282668587L;

        public boolean equals(Object object) {
            return false;
        }

        public int hashCode() {
            return super.hashCode();
        }
    };
    private final transient PropertyDescriptor[] pds = this.getPropertyDescriptors();
    private final transient Map<String, PropertyDescriptor> descriptors = this.getMapDescriptors();

    public ContextBase() {
    }

    public ContextBase(Map<String, Object> map) {
        super(map);
        this.putAll((Map<? extends String, ? extends Object>)map);
    }

    @Override
    public void clear() {
        if (this.descriptors == null) {
            super.clear();
        } else {
            Iterator<String> keys = this.keySet().iterator();
            while (keys.hasNext()) {
                String key = keys.next();
                if (this.descriptors.containsKey(key)) continue;
                keys.remove();
            }
        }
    }

    @Override
    public boolean containsValue(Object value) {
        boolean b = super.containsValue(value);
        if (this.descriptors == null) {
            return b;
        }
        if (b) {
            return true;
        }
        for (PropertyDescriptor pd : this.pds) {
            if (pd.getReadMethod() == null) continue;
            Object prop = this.readProperty(pd);
            if (!(value == null ? prop == null : value.equals(prop))) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return new EntrySetImpl();
    }

    @Override
    public Object get(Object key) {
        PropertyDescriptor descriptor;
        if (this.descriptors == null) {
            return super.get(key);
        }
        if (key != null && (descriptor = this.descriptors.get(key)) != null) {
            if (descriptor.getReadMethod() != null) {
                return this.readProperty(descriptor);
            }
            return null;
        }
        return super.get(key);
    }

    @Override
    public boolean isEmpty() {
        if (this.descriptors == null) {
            return super.isEmpty();
        }
        return super.size() <= this.descriptors.size();
    }

    @Override
    public Set<String> keySet() {
        return super.keySet();
    }

    @Override
    public Object put(String key, Object value) {
        PropertyDescriptor descriptor;
        if (this.descriptors == null) {
            return super.put(key, value);
        }
        if (key != null && (descriptor = this.descriptors.get(key)) != null) {
            Object previous = null;
            if (descriptor.getReadMethod() != null) {
                previous = this.readProperty(descriptor);
            }
            this.writeProperty(descriptor, value);
            return previous;
        }
        return super.put(key, value);
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> map) {
        map.forEach(this::put);
    }

    @Override
    public Object remove(Object key) {
        PropertyDescriptor descriptor;
        if (this.descriptors == null) {
            return super.remove(key);
        }
        if (key != null && (descriptor = this.descriptors.get(key)) != null) {
            throw new UnsupportedOperationException("Local property '" + key + "' cannot be removed");
        }
        return super.remove(key);
    }

    @Override
    public Collection<Object> values() {
        return new ValuesImpl();
    }

    private Iterator<Map.Entry<String, Object>> entriesIterator() {
        return new EntrySetIterator();
    }

    private Map.Entry<String, Object> entry(Object key) {
        if (this.containsKey(key)) {
            return new MapEntryImpl(key.toString(), this.get(key));
        }
        return null;
    }

    private Object readProperty(PropertyDescriptor descriptor) {
        try {
            Method method = descriptor.getReadMethod();
            if (method == null) {
                throw new UnsupportedOperationException("Property '" + descriptor.getName() + "' is not readable");
            }
            return method.invoke((Object)this, new Object[0]);
        }
        catch (Exception e) {
            throw new UnsupportedOperationException("Exception reading property '" + descriptor.getName() + "': " + e.getMessage());
        }
    }

    private boolean remove(Map.Entry<?, ?> entry) {
        Map.Entry<String, Object> actual = this.entry(entry.getKey());
        if (actual == null) {
            return false;
        }
        if (entry.equals(actual)) {
            this.remove(entry.getKey());
            return true;
        }
        return false;
    }

    private Iterator<Object> valuesIterator() {
        return new ValuesIterator();
    }

    private void writeProperty(PropertyDescriptor descriptor, Object value) {
        try {
            Method method = descriptor.getWriteMethod();
            if (method == null) {
                throw new UnsupportedOperationException("Property '" + descriptor.getName() + "' is not writeable");
            }
            method.invoke((Object)this, value);
        }
        catch (Exception e) {
            throw new UnsupportedOperationException("Exception writing property '" + descriptor.getName() + "': " + e.getMessage());
        }
    }

    private PropertyDescriptor[] getPropertyDescriptors() {
        try {
            return Introspector.getBeanInfo(this.getClass()).getPropertyDescriptors();
        }
        catch (IntrospectionException e) {
            return new PropertyDescriptor[0];
        }
    }

    private Map<String, PropertyDescriptor> getMapDescriptors() {
        HashMap<String, PropertyDescriptor> ret = new HashMap<String, PropertyDescriptor>();
        for (PropertyDescriptor pd : this.pds) {
            String name = pd.getName();
            if ("class".equals(name) || "empty".equals(name)) continue;
            ret.put(name, pd);
            super.put(name, SINGLETON);
        }
        return ret.isEmpty() ? null : ret;
    }

    private final class EntrySetImpl
    extends AbstractSet<Map.Entry<String, Object>> {
        private EntrySetImpl() {
        }

        @Override
        public void clear() {
            ContextBase.this.clear();
        }

        @Override
        public boolean contains(Object obj) {
            if (!(obj instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)obj;
            Map.Entry actual = ContextBase.this.entry(entry.getKey());
            if (actual != null) {
                return actual.equals(entry);
            }
            return false;
        }

        @Override
        public boolean isEmpty() {
            return ContextBase.this.isEmpty();
        }

        @Override
        public Iterator<Map.Entry<String, Object>> iterator() {
            return ContextBase.this.entriesIterator();
        }

        @Override
        public boolean remove(Object obj) {
            if (obj instanceof Map.Entry) {
                return ContextBase.this.remove((Map.Entry)obj);
            }
            return false;
        }

        @Override
        public int size() {
            return ContextBase.this.size();
        }
    }

    private final class ValuesImpl
    extends AbstractCollection<Object> {
        private ValuesImpl() {
        }

        @Override
        public void clear() {
            ContextBase.this.clear();
        }

        @Override
        public boolean contains(Object obj) {
            if (!(obj instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)obj;
            return ContextBase.this.containsValue(entry.getValue());
        }

        @Override
        public boolean isEmpty() {
            return ContextBase.this.isEmpty();
        }

        @Override
        public Iterator<Object> iterator() {
            return ContextBase.this.valuesIterator();
        }

        @Override
        public boolean remove(Object obj) {
            if (obj instanceof Map.Entry) {
                return ContextBase.this.remove((Map.Entry)obj);
            }
            return false;
        }

        @Override
        public int size() {
            return ContextBase.this.size();
        }
    }

    private final class EntrySetIterator
    implements Iterator<Map.Entry<String, Object>> {
        private Map.Entry<String, Object> entry = null;
        private Iterator<String> keys = ContextBase.this.keySet().iterator();

        private EntrySetIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.keys.hasNext();
        }

        @Override
        public Map.Entry<String, Object> next() {
            this.entry = ContextBase.this.entry(this.keys.next());
            return this.entry;
        }

        @Override
        public void remove() {
            ContextBase.this.remove(this.entry);
        }
    }

    private class MapEntryImpl
    implements Map.Entry<String, Object> {
        private String key;
        private Object value;

        MapEntryImpl(String key, Object value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            MapEntryImpl other = (MapEntryImpl)obj;
            if (!this.getEnclosingInstance().equals(other.getEnclosingInstance())) {
                return false;
            }
            return Objects.equals(this.key, other.key) && Objects.equals(this.value, other.value);
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        @Override
        public int hashCode() {
            return Objects.hashCode(this.key) ^ Objects.hashCode(this.value);
        }

        @Override
        public Object setValue(Object value) {
            Object previous = this.value;
            ContextBase.this.put(this.key, value);
            this.value = value;
            return previous;
        }

        public String toString() {
            return this.getKey() + "=" + this.getValue();
        }

        private ContextBase getEnclosingInstance() {
            return ContextBase.this;
        }
    }

    private final class ValuesIterator
    implements Iterator<Object> {
        private Map.Entry<String, Object> entry = null;
        private Iterator<String> keys = ContextBase.this.keySet().iterator();

        private ValuesIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.keys.hasNext();
        }

        @Override
        public Object next() {
            this.entry = ContextBase.this.entry(this.keys.next());
            return this.entry.getValue();
        }

        @Override
        public void remove() {
            ContextBase.this.remove(this.entry);
        }
    }
}

