/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.complexity;

import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Metric;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.ThresholdRule;
import io.gitlab.arturbosch.detekt.api.ThresholdedCodeSmell;
import io.gitlab.arturbosch.detekt.rules.complexity.ComplexCondition$checkIfComplex$;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiRecursiveElementVisitor;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtDoWhileExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtWhileExpression;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J\u0018\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0002J\u0010\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0019H\u0016R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001b"}, d2={"Lio/gitlab/arturbosch/detekt/rules/complexity/ComplexCondition;", "Lio/gitlab/arturbosch/detekt/api/ThresholdRule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "threshold", "", "(Lio/gitlab/arturbosch/detekt/api/Config;I)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "checkIfComplex", "", "condition", "Lorg/jetbrains/kotlin/psi/KtExpression;", "frequency", "source", "", "part", "visitDoWhileExpression", "expression", "Lorg/jetbrains/kotlin/psi/KtDoWhileExpression;", "visitIfExpression", "Lorg/jetbrains/kotlin/psi/KtIfExpression;", "visitWhileExpression", "Lorg/jetbrains/kotlin/psi/KtWhileExpression;", "Companion", "detekt-rules-complexity"})
public final class ComplexCondition
extends ThresholdRule {
    @NotNull
    private final Issue issue;
    public static final int DEFAULT_CONDITIONS_COUNT = 4;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visitIfExpression(@NotNull KtIfExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        KtExpression condition = expression.getCondition();
        this.checkIfComplex(condition);
        super.visitIfExpression(expression);
    }

    public void visitDoWhileExpression(@NotNull KtDoWhileExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        KtExpression condition = expression.getCondition();
        this.checkIfComplex(condition);
        super.visitDoWhileExpression(expression);
    }

    public void visitWhileExpression(@NotNull KtWhileExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        KtExpression condition = expression.getCondition();
        this.checkIfComplex(condition);
        super.visitWhileExpression(expression);
    }

    /*
     * WARNING - void declaration
     */
    private final void checkIfComplex(KtExpression condition) {
        void $this$forEachDescendantOfType$iv$iv$iv;
        KtExpression ktExpression = condition;
        if (ktExpression == null) {
            return;
        }
        PsiElement $this$collectDescendantsOfType$iv = (PsiElement)ktExpression;
        Function1 predicate$iv = checkIfComplex$$inlined$collectDescendantsOfType$1.INSTANCE;
        boolean $i$f$collectDescendantsOfType = false;
        PsiElement $this$collectDescendantsOfType$iv$iv = $this$collectDescendantsOfType$iv;
        boolean $i$f$collectDescendantsOfType2 = false;
        KtBinaryExpression result$iv$iv = new ArrayList();
        PsiElement psiElement = $this$collectDescendantsOfType$iv$iv;
        Function1 action$iv$iv$iv = (Function1)new Function1<KtBinaryExpression, Unit>(predicate$iv, result$iv$iv){
            final /* synthetic */ Function1 $predicate;
            final /* synthetic */ ArrayList $result;
            {
                this.$predicate = function1;
                this.$result = arrayList;
                super(1);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public final void invoke(@NotNull PsiElement it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (((Boolean)this.$predicate.invoke((Object)it)).booleanValue()) {
                    this.$result.add(it);
                }
            }
        };
        boolean $i$f$forEachDescendantOfType = false;
        $this$forEachDescendantOfType$iv$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(action$iv$iv$iv){
            final /* synthetic */ Function1 $action;
            {
                this.$action = $captured_local_variable$1;
            }

            public void visitElement(@NotNull PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                PsiElement it = element;
                boolean bl = false;
                super.visitElement(element);
                if (element instanceof KtBinaryExpression) {
                    this.$action.invoke((Object)element);
                }
            }
        });
        List binaryExpressions = (List)result$iv$iv;
        if (binaryExpressions.size() > 1) {
            String conditionString;
            Iterable $this$reduce$iv = binaryExpressions;
            boolean $i$f$reduce = false;
            Iterator iterator$iv = $this$reduce$iv.iterator();
            if (!iterator$iv.hasNext()) {
                throw (Throwable)new UnsupportedOperationException("Empty collection can't be reduced.");
            }
            Object accumulator$iv = iterator$iv.next();
            while (iterator$iv.hasNext()) {
                void binExpr;
                result$iv$iv = (KtBinaryExpression)iterator$iv.next();
                KtBinaryExpression acc = (KtBinaryExpression)accumulator$iv;
                boolean bl = false;
                accumulator$iv = binExpr.getText().length() > acc.getText().length() ? binExpr : acc;
            }
            KtBinaryExpression longestBinExpr = (KtBinaryExpression)accumulator$iv;
            String string = conditionString = longestBinExpr.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"conditionString");
            int count = this.frequency(string, "&&") + this.frequency(conditionString, "||") + 1;
            if (count >= this.getThreshold()) {
                this.report((Finding)new ThresholdedCodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)condition), (int)0, (int)2, null), new Metric("SIZE", count, this.getThreshold(), false, 0, 24, null), "This condition is too complex (" + count + "). " + "Defined complexity threshold for conditions is set to '" + this.getThreshold() + '\'', null, 16, null));
            }
        }
    }

    private final int frequency(String source, String part) {
        block4: {
            block3: {
                CharSequence charSequence = source;
                boolean bl = false;
                if (charSequence.length() == 0) break block3;
                charSequence = part;
                bl = false;
                if (!(charSequence.length() == 0)) break block4;
            }
            return 0;
        }
        int count = 0;
        int pos = StringsKt.indexOf$default((CharSequence)source, (String)part, (int)0, (boolean)false, (int)4, null);
        while (pos != -1) {
            pos += part.length();
            ++count;
            pos = StringsKt.indexOf$default((CharSequence)source, (String)part, (int)pos, (boolean)false, (int)4, null);
        }
        return count;
    }

    public ComplexCondition(@NotNull Config config, int threshold) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, threshold);
        this.issue = new Issue("ComplexCondition", Severity.Maintainability, "Complex conditions should be simplified and extracted into well-named methods if necessary.", Debt.Companion.getTWENTY_MINS());
    }

    public /* synthetic */ ComplexCondition(Config config, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        if ((n2 & 2) != 0) {
            n = 4;
        }
        this(config, n);
    }

    public ComplexCondition() {
        this(null, 0, 3, null);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/gitlab/arturbosch/detekt/rules/complexity/ComplexCondition$Companion;", "", "()V", "DEFAULT_CONDITIONS_COUNT", "", "detekt-rules-complexity"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

