/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.complexity;

import io.gitlab.arturbosch.detekt.api.AnnotationExcluder;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Metric;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.ThresholdedCodeSmell;
import io.gitlab.arturbosch.detekt.api.internal.PathFiltersKt;
import io.gitlab.arturbosch.detekt.rules.KtModifierListKt;
import io.gitlab.arturbosch.detekt.rules.complexity.LongParameterList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.KtAnnotated;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 ,2\u00020\u0001:\u0001,B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\fH\u0002J\u0014\u0010\u001a\u001a\u00020\u00152\n\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020%H\u0016J\f\u0010&\u001a\u00020\u000e*\u00020'H\u0002J\f\u0010(\u001a\u00020\u000e*\u00020)H\u0002J\f\u0010*\u001a\u00020\b*\u00020+H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006-"}, d2={"Lio/gitlab/arturbosch/detekt/rules/complexity/LongParameterList;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "annotationExcluder", "Lio/gitlab/arturbosch/detekt/api/AnnotationExcluder;", "constructorThreshold", "", "functionThreshold", "ignoreAnnotated", "", "", "ignoreDataClasses", "", "ignoreDefaultParameters", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "checkLongParameterList", "", "function", "Lorg/jetbrains/kotlin/psi/KtFunction;", "threshold", "identifier", "validateConstructor", "constructor", "Lorg/jetbrains/kotlin/psi/KtConstructor;", "visitKtFile", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "visitNamedFunction", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "visitPrimaryConstructor", "Lorg/jetbrains/kotlin/psi/KtPrimaryConstructor;", "visitSecondaryConstructor", "Lorg/jetbrains/kotlin/psi/KtSecondaryConstructor;", "isDataClassOrIgnored", "Lorg/jetbrains/kotlin/psi/KtClass;", "isIgnored", "Lorg/jetbrains/kotlin/psi/KtAnnotated;", "parameterCount", "Lorg/jetbrains/kotlin/psi/KtParameterList;", "Companion", "detekt-rules-complexity"})
public final class LongParameterList
extends Rule {
    @NotNull
    private final Issue issue;
    private final int functionThreshold;
    private final int constructorThreshold;
    private final boolean ignoreDefaultParameters;
    private final boolean ignoreDataClasses;
    private final List<String> ignoreAnnotated;
    private AnnotationExcluder annotationExcluder;
    @NotNull
    public static final String THRESHOLD = "threshold";
    @NotNull
    public static final String FUNCTION_THRESHOLD = "functionThreshold";
    @NotNull
    public static final String CONSTRUCTOR_THRESHOLD = "constructorThreshold";
    @NotNull
    public static final String IGNORE_DEFAULT_PARAMETERS = "ignoreDefaultParameters";
    @NotNull
    public static final String IGNORE_DATA_CLASSES = "ignoreDataClasses";
    @NotNull
    public static final String IGNORE_ANNOTATED = "ignoreAnnotated";
    public static final int DEFAULT_FUNCTION_THRESHOLD = 6;
    public static final int DEFAULT_CONSTRUCTOR_THRESHOLD = 7;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visitKtFile(@NotNull KtFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.annotationExcluder = new AnnotationExcluder(file, this.ignoreAnnotated);
        super.visitKtFile(file);
    }

    public void visitNamedFunction(@NotNull KtNamedFunction function) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        KtClassOrObject owner = KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)((KtDeclaration)function));
        if (owner instanceof KtClass && this.isIgnored((KtAnnotated)owner)) {
            return;
        }
        this.checkLongParameterList((KtFunction)function, this.functionThreshold, "function " + function.getNameAsSafeName());
    }

    public void visitPrimaryConstructor(@NotNull KtPrimaryConstructor constructor) {
        Intrinsics.checkNotNullParameter((Object)constructor, (String)"constructor");
        this.validateConstructor((KtConstructor)constructor);
    }

    public void visitSecondaryConstructor(@NotNull KtSecondaryConstructor constructor) {
        Intrinsics.checkNotNullParameter((Object)constructor, (String)"constructor");
        this.validateConstructor((KtConstructor)constructor);
    }

    private final boolean isIgnored(KtAnnotated $this$isIgnored) {
        AnnotationExcluder annotationExcluder = this.annotationExcluder;
        if (annotationExcluder == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"annotationExcluder");
        }
        List list = $this$isIgnored.getAnnotationEntries();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"annotationEntries");
        return annotationExcluder.shouldExclude(list);
    }

    private final void validateConstructor(KtConstructor<?> constructor) {
        KtClassOrObject owner = constructor.getContainingClassOrObject();
        if (owner instanceof KtClass && this.isDataClassOrIgnored((KtClass)owner)) {
            return;
        }
        this.checkLongParameterList((KtFunction)constructor, this.constructorThreshold, "constructor");
    }

    private final boolean isDataClassOrIgnored(KtClass $this$isDataClassOrIgnored) {
        return this.isIgnored((KtAnnotated)$this$isDataClassOrIgnored) || this.ignoreDataClasses && $this$isDataClassOrIgnored.isData();
    }

    private final void checkLongParameterList(KtFunction function, int threshold, String identifier) {
        block6: {
            block5: {
                if (KtModifierListKt.isOverride((KtModifierListOwner)((KtModifierListOwner)function)) || this.isIgnored((KtAnnotated)function)) break block5;
                KtFile ktFile = function.getContainingKtFile();
                Intrinsics.checkNotNullExpressionValue((Object)ktFile, (String)"function.containingKtFile");
                if (!this.isIgnored((KtAnnotated)ktFile)) break block6;
            }
            return;
        }
        KtParameterList ktParameterList = function.getValueParameterList();
        if (ktParameterList == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)ktParameterList, (String)"function.valueParameterList ?: return");
        KtParameterList parameterList = ktParameterList;
        int parameterNumber = this.parameterCount(parameterList);
        if (parameterNumber >= threshold) {
            List list = function.getValueParameters();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"function.valueParameters");
            String parameterPrint2 = CollectionsKt.joinToString$default((Iterable)list, (CharSequence)", ", null, null, (int)0, null, (Function1)checkLongParameterList.parameterPrint.1.INSTANCE, (int)30, null);
            this.report((Finding)new ThresholdedCodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)parameterList), (int)0, (int)2, null), new Metric("SIZE", parameterNumber, threshold, false, 0, 24, null), "The " + identifier + '(' + parameterPrint2 + ") has too many parameters. " + "The current threshold is set to " + threshold + '.', null, 16, null));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final int parameterCount(KtParameterList $this$parameterCount) {
        int n;
        if (this.ignoreDefaultParameters) {
            void $this$filterTo$iv$iv;
            List list = $this$parameterCount.getParameters();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"parameters");
            Iterable $this$filter$iv = list;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                KtParameter it = (KtParameter)element$iv$iv;
                boolean bl = false;
                if (!(!it.hasDefaultValue())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            n = ((List)destination$iv$iv).size();
        } else {
            n = $this$parameterCount.getParameters().size();
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public LongParameterList(@NotNull Config config) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        this.issue = new Issue("LongParameterList", Severity.Maintainability, "The more parameters a function has the more complex it is. Long parameter lists are often used to control complex algorithms and violate the Single Responsibility Principle. Prefer functions with short parameter lists.", Debt.Companion.getTWENTY_MINS());
        this.functionThreshold = ((Number)this.valueOrDefault(FUNCTION_THRESHOLD, this.valueOrDefault(THRESHOLD, 6))).intValue();
        this.constructorThreshold = ((Number)this.valueOrDefault(CONSTRUCTOR_THRESHOLD, this.valueOrDefault(THRESHOLD, 7))).intValue();
        this.ignoreDefaultParameters = (Boolean)this.valueOrDefault(IGNORE_DEFAULT_PARAMETERS, false);
        this.ignoreDataClasses = (Boolean)this.valueOrDefault(IGNORE_DATA_CLASSES, true);
        Iterable iterable = PathFiltersKt.valueOrDefaultCommaSeparated((Config)this, (String)IGNORE_ANNOTATED, (List)CollectionsKt.emptyList());
        LongParameterList longParameterList = this;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            String string2 = StringsKt.removeSuffix((String)StringsKt.removePrefix((String)it, (CharSequence)"*"), (CharSequence)"*");
            collection.add(string2);
        }
        collection = (List)destination$iv$iv;
        longParameterList.ignoreAnnotated = collection;
    }

    public /* synthetic */ LongParameterList(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    public LongParameterList() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lio/gitlab/arturbosch/detekt/rules/complexity/LongParameterList$Companion;", "", "()V", "CONSTRUCTOR_THRESHOLD", "", "DEFAULT_CONSTRUCTOR_THRESHOLD", "", "DEFAULT_FUNCTION_THRESHOLD", "FUNCTION_THRESHOLD", "IGNORE_ANNOTATED", "IGNORE_DATA_CLASSES", "IGNORE_DEFAULT_PARAMETERS", "THRESHOLD", "detekt-rules-complexity"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

