/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.complexity;

import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.ConfigPropertyKt;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Metric;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.ThresholdedCodeSmell;
import io.gitlab.arturbosch.detekt.api.internal.Configuration;
import io.gitlab.arturbosch.detekt.rules.JunkKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtTypeParameterListOwner;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u001f\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020!H\u0002J\u0012\u0010\"\u001a\u00020\u001a2\b\u0010#\u001a\u0004\u0018\u00010$H\u0002J\u0010\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0016R!\u0010\u0005\u001a\u00020\u00068BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u000b\u0010\f\u0012\u0004\b\u0007\u0010\b\u001a\u0004\b\t\u0010\nR!\u0010\r\u001a\u00020\u00068BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0010\u0010\f\u0012\u0004\b\u000e\u0010\b\u001a\u0004\b\u000f\u0010\nR!\u0010\u0011\u001a\u00020\u00068BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0014\u0010\f\u0012\u0004\b\u0012\u0010\b\u001a\u0004\b\u0013\u0010\nR\u0014\u0010\u0015\u001a\u00020\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R!\u0010\u0019\u001a\u00020\u001a8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u001e\u0010\f\u0012\u0004\b\u001b\u0010\b\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006)"}, d2={"Lio/gitlab/arturbosch/detekt/rules/complexity/ComplexInterface;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "ignoreOverloaded", "", "getIgnoreOverloaded$annotations", "()V", "getIgnoreOverloaded", "()Z", "ignoreOverloaded$delegate", "Lkotlin/properties/ReadOnlyProperty;", "includePrivateDeclarations", "getIncludePrivateDeclarations$annotations", "getIncludePrivateDeclarations", "includePrivateDeclarations$delegate", "includeStaticDeclarations", "getIncludeStaticDeclarations$annotations", "getIncludeStaticDeclarations", "includeStaticDeclarations$delegate", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "threshold", "", "getThreshold$annotations", "getThreshold", "()I", "threshold$delegate", "calculateMembers", "body", "Lorg/jetbrains/kotlin/psi/KtClassBody;", "countStaticDeclarations", "companionObject", "Lorg/jetbrains/kotlin/psi/KtObjectDeclaration;", "visitClass", "", "klass", "Lorg/jetbrains/kotlin/psi/KtClass;", "detekt-rules-complexity"})
@SourceDebugExtension(value={"SMAP\nComplexInterface.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComplexInterface.kt\nio/gitlab/arturbosch/detekt/rules/complexity/ComplexInterface\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,111:1\n3792#2:112\n4307#2,2:113\n1774#3,4:115\n800#3,11:119\n1655#3,8:130\n*S KotlinDebug\n*F\n+ 1 ComplexInterface.kt\nio/gitlab/arturbosch/detekt/rules/complexity/ComplexInterface\n*L\n105#1:112\n105#1:113,2\n106#1:115,4\n89#1:119,11\n91#1:130,8\n*E\n"})
public final class ComplexInterface
extends Rule {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Issue issue;
    @NotNull
    private final ReadOnlyProperty threshold$delegate;
    @NotNull
    private final ReadOnlyProperty includeStaticDeclarations$delegate;
    @NotNull
    private final ReadOnlyProperty includePrivateDeclarations$delegate;
    @NotNull
    private final ReadOnlyProperty ignoreOverloaded$delegate;

    public ComplexInterface(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"javaClass.simpleName");
        this.issue = new Issue(string, Severity.Maintainability, "An interface contains too many functions and properties. Large classes tend to handle many things at once. An interface should have one responsibility. Split up large interfaces into smaller ones that are easier to understand.", Debt.Companion.getTWENTY_MINS());
        this.threshold$delegate = ConfigPropertyKt.config((Object)10);
        this.includeStaticDeclarations$delegate = ConfigPropertyKt.config((Object)false);
        this.includePrivateDeclarations$delegate = ConfigPropertyKt.config((Object)false);
        this.ignoreOverloaded$delegate = ConfigPropertyKt.config((Object)false);
    }

    public /* synthetic */ ComplexInterface(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    private final int getThreshold() {
        return ((Number)this.threshold$delegate.getValue((Object)this, $$delegatedProperties[0])).intValue();
    }

    @Configuration(description="the amount of definitions in an interface to trigger the rule")
    private static /* synthetic */ void getThreshold$annotations() {
    }

    private final boolean getIncludeStaticDeclarations() {
        return (Boolean)this.includeStaticDeclarations$delegate.getValue((Object)this, $$delegatedProperties[1]);
    }

    @Configuration(description="whether static declarations should be included")
    private static /* synthetic */ void getIncludeStaticDeclarations$annotations() {
    }

    private final boolean getIncludePrivateDeclarations() {
        return (Boolean)this.includePrivateDeclarations$delegate.getValue((Object)this, $$delegatedProperties[2]);
    }

    @Configuration(description="whether private declarations should be included")
    private static /* synthetic */ void getIncludePrivateDeclarations$annotations() {
    }

    private final boolean getIgnoreOverloaded() {
        return (Boolean)this.ignoreOverloaded$delegate.getValue((Object)this, $$delegatedProperties[3]);
    }

    @Configuration(description="ignore overloaded methods - only count once")
    private static /* synthetic */ void getIgnoreOverloaded$annotations() {
    }

    public void visitClass(@NotNull KtClass klass) {
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        if (klass.isInterface()) {
            KtClassBody ktClassBody = klass.getBody();
            if (ktClassBody == null) {
                return;
            }
            KtClassBody body = ktClassBody;
            int size = this.calculateMembers(body);
            if (this.getIncludeStaticDeclarations()) {
                size += this.countStaticDeclarations(JunkKt.companionObject((KtClass)klass));
            }
            if (size >= this.getThreshold()) {
                this.report((Finding)new ThresholdedCodeSmell(this.getIssue(), Entity.Companion.atName((KtNamedDeclaration)klass), new Metric("SIZE: ", size, this.getThreshold(), false, 0, 24, null), "The interface " + klass.getName() + " is too complex. Consider splitting it up.", null, 16, null));
            }
        }
        super.visitClass(klass);
    }

    private final int countStaticDeclarations(KtObjectDeclaration companionObject) {
        KtClassBody body;
        KtObjectDeclaration ktObjectDeclaration = companionObject;
        KtClassBody ktClassBody = body = ktObjectDeclaration != null ? ktObjectDeclaration.getBody() : null;
        return ktClassBody != null ? this.calculateMembers(ktClassBody) : 0;
    }

    /*
     * WARNING - void declaration
     */
    private final int calculateMembers(KtClassBody body) {
        int n;
        void $this$filterTo$iv$iv;
        PsiElement[] psiElementArray = body.getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"body.children");
        Object[] $this$filter$iv = psiElementArray;
        boolean $i$f$filter = false;
        Object[] objectArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (void element$iv$iv : $this$filterTo$iv$iv) {
            PsiElement p0 = (PsiElement)element$iv$iv;
            boolean bl = false;
            if (!ComplexInterface.calculateMembers$considerPrivate(p0, this)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List psiElements = (List)destination$iv$iv;
        Iterable $this$count$iv = psiElements;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                PsiElement it = (PsiElement)element$iv;
                boolean bl = false;
                if (!(it instanceof KtProperty) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        int propertyCount = n;
        int functionCount = ComplexInterface.calculateMembers$countFunctions(this, psiElements);
        return propertyCount + functionCount;
    }

    private static final boolean calculateMembers$considerPrivate(PsiElement $this$calculateMembers_u24considerPrivate, ComplexInterface this$0) {
        return this$0.getIncludePrivateDeclarations() || $this$calculateMembers_u24considerPrivate instanceof KtTypeParameterListOwner && !KtPsiUtilKt.isPrivate((KtModifierListOwner)((KtModifierListOwner)$this$calculateMembers_u24considerPrivate));
    }

    /*
     * WARNING - void declaration
     */
    private static final int calculateMembers$countFunctions(ComplexInterface this$0, List<? extends PsiElement> psiElements) {
        int n;
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv = psiElements;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof KtNamedFunction)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List functions2 = (List)destination$iv$iv;
        if (this$0.getIgnoreOverloaded()) {
            Iterable $this$distinctBy$iv = functions2;
            boolean $i$f$distinctBy = false;
            HashSet<String> set$iv = new HashSet<String>();
            ArrayList list$iv = new ArrayList();
            for (Object e$iv : $this$distinctBy$iv) {
                KtNamedFunction function = (KtNamedFunction)e$iv;
                boolean bl = false;
                KtTypeReference receiver = function.getReceiverTypeReference();
                String string = KtPsiUtilKt.isExtensionDeclaration((PsiElement)((PsiElement)function)) && receiver != null ? receiver.getText() + '.' + function.getName() : function.getName();
                String key$iv = string;
                if (!set$iv.add(key$iv)) continue;
                list$iv.add(e$iv);
            }
            n = ((List)list$iv).size();
        } else {
            n = functions2.size();
        }
        return n;
    }

    public ComplexInterface() {
        this(null, 1, null);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(ComplexInterface.class, "threshold", "getThreshold()I", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(ComplexInterface.class, "includeStaticDeclarations", "getIncludeStaticDeclarations()Z", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(ComplexInterface.class, "includePrivateDeclarations", "getIncludePrivateDeclarations()Z", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(ComplexInterface.class, "ignoreOverloaded", "getIgnoreOverloaded()Z", 0)))};
        $$delegatedProperties = kPropertyArray;
    }
}

