/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.complexity;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.ConfigPropertyKt;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.Configuration;
import io.gitlab.arturbosch.detekt.api.internal.RequiresTypeResolution;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;

@RequiresTypeResolution
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\f\u0010\u001b\u001a\u00020\u0006*\u00020\u001aH\u0002R!\u0010\u0005\u001a\u00020\u00068BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u000b\u0010\f\u0012\u0004\b\u0007\u0010\b\u001a\u0004\b\t\u0010\nR\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R!\u0010\u0011\u001a\u00020\u00128BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0016\u0010\f\u0012\u0004\b\u0013\u0010\b\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001c"}, d2={"Lio/gitlab/arturbosch/detekt/rules/complexity/NamedArguments;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "ignoreArgumentsMatchingNames", "", "getIgnoreArgumentsMatchingNames$annotations", "()V", "getIgnoreArgumentsMatchingNames", "()Z", "ignoreArgumentsMatchingNames$delegate", "Lkotlin/properties/ReadOnlyProperty;", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "threshold", "", "getThreshold$annotations", "getThreshold", "()I", "threshold$delegate", "visitCallExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "canNameArguments", "detekt-rules-complexity"})
@SourceDebugExtension(value={"SMAP\nNamedArguments.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NamedArguments.kt\nio/gitlab/arturbosch/detekt/rules/complexity/NamedArguments\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,82:1\n819#2:83\n847#2,2:84\n1603#2,9:86\n1855#2:95\n1856#2:97\n1612#2:98\n1726#2,3:99\n1#3:96\n*S KotlinDebug\n*F\n+ 1 NamedArguments.kt\nio/gitlab/arturbosch/detekt/rules/complexity/NamedArguments\n*L\n51#1:83\n51#1:84,2\n65#1:86,9\n65#1:95\n65#1:97\n65#1:98\n77#1:99,3\n65#1:96\n*E\n"})
public final class NamedArguments
extends Rule {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Issue issue;
    @NotNull
    private final ReadOnlyProperty threshold$delegate;
    @NotNull
    private final ReadOnlyProperty ignoreArgumentsMatchingNames$delegate;

    public NamedArguments(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        this.issue = new Issue("NamedArguments", Severity.Maintainability, "Named arguments are required for function calls with many arguments.", Debt.Companion.getFIVE_MINS());
        this.threshold$delegate = ConfigPropertyKt.config((Object)3);
        this.ignoreArgumentsMatchingNames$delegate = ConfigPropertyKt.config((Object)false);
    }

    public /* synthetic */ NamedArguments(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    private final int getThreshold() {
        return ((Number)this.threshold$delegate.getValue((Object)this, $$delegatedProperties[0])).intValue();
    }

    @Configuration(description="number of arguments that triggers this inspection")
    private static /* synthetic */ void getThreshold$annotations() {
    }

    private final boolean getIgnoreArgumentsMatchingNames() {
        return (Boolean)this.ignoreArgumentsMatchingNames$delegate.getValue((Object)this, $$delegatedProperties[1]);
    }

    @Configuration(description="ignores when argument values are the same as the parameter names")
    private static /* synthetic */ void getIgnoreArgumentsMatchingNames$annotations() {
    }

    /*
     * WARNING - void declaration
     */
    public void visitCallExpression(@NotNull KtCallExpression expression) {
        void $this$filterNotTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        List list = expression.getValueArguments();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getValueArguments(...)");
        Iterable $this$filterNot$iv = list;
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            KtValueArgument it = (KtValueArgument)element$iv$iv;
            boolean bl = false;
            if (it instanceof KtLambdaArgument) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List valueArguments = (List)destination$iv$iv;
        if (valueArguments.size() > this.getThreshold() && this.canNameArguments(expression)) {
            String message = "This function call has " + valueArguments.size() + " arguments. To call a function with more than " + this.getThreshold() + " arguments you should set the name of each argument.";
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)expression), (int)0, (int)2, null), message, null, null, 24, null));
        } else {
            super.visitCallExpression(expression);
        }
    }

    /*
     * Unable to fully structure code
     */
    private final boolean canNameArguments(KtCallExpression $this$canNameArguments) {
        block9: {
            v0 = CallUtilKt.getResolvedCall((KtElement)((KtElement)$this$canNameArguments), (BindingContext)this.getBindingContext());
            if (v0 == null) {
                return false;
            }
            resolvedCall = v0;
            if (!resolvedCall.getCandidateDescriptor().hasStableParameterNames()) {
                return false;
            }
            v1 = $this$canNameArguments.getValueArguments();
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getValueArguments(...)");
            $this$mapNotNull$iv = v1;
            $i$f$mapNotNull = false;
            var6_5 = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$mapNotNullTo = false;
            $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            $i$f$forEach = false;
            var11_13 = $this$forEach$iv$iv$iv.iterator();
            while (var11_13.hasNext()) {
                block11: {
                    block12: {
                        block10: {
                            element$iv$iv = element$iv$iv$iv = var11_13.next();
                            $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = false;
                            argument = (KtValueArgument)element$iv$iv;
                            $i$a$-mapNotNull-NamedArguments$canNameArguments$unnamedArguments$1 = false;
                            if (!argument.isNamed() && !(argument instanceof KtLambdaArgument)) break block10;
                            v2 = null;
                            break block11;
                        }
                        if (CallUtilKt.getParameterForArgument((ResolvedCall)resolvedCall, (ValueArgument)((ValueArgument)argument)) != null) break block12;
                        v2 = null;
                        break block11;
                    }
                    if (!this.getIgnoreArgumentsMatchingNames()) ** GOTO lbl-1000
                    v3 = argument.getArgumentExpression();
                    if (Intrinsics.areEqual((Object)parameter.getName().asString(), (Object)(v3 != null ? v3.getText() : null))) {
                        v2 = null;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v2 = TuplesKt.to((Object)argument, (Object)parameter);
                    }
                }
                if (v2 == null) continue;
                it$iv$iv = v2;
                $i$a$-let-CollectionsKt___CollectionsKt$mapNotNullTo$1$1$iv$iv = false;
                destination$iv$iv.add(it$iv$iv);
            }
            unnamedArguments = (List)destination$iv$iv;
            if (unnamedArguments.isEmpty()) {
                return false;
            }
            $this$all$iv = unnamedArguments;
            $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                v4 = true;
            } else {
                for (E element$iv : $this$all$iv) {
                    var8_8 = (Pair)element$iv;
                    $i$a$-all-NamedArguments$canNameArguments$1 = false;
                    argument = (KtValueArgument)var8_8.component1();
                    parameter = (ValueParameterDescriptor)var8_8.component2();
                    if (argument.getSpreadElement() != null || parameter.getVarargElementType() == null) continue;
                    v4 = false;
                    break block9;
                }
                v4 = true;
            }
        }
        return v4;
    }

    public NamedArguments() {
        this(null, 1, null);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(NamedArguments.class, "threshold", "getThreshold()I", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(NamedArguments.class, "ignoreArgumentsMatchingNames", "getIgnoreArgumentsMatchingNames()Z", 0)))};
        $$delegatedProperties = kPropertyArray;
    }
}

