/*
 * Decompiled with CFR 0.152.
 */
package io.leonard.maven.plugins.jspc;

import io.leonard.maven.plugins.jspc.JspcWorker;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.jasper.JspC;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.StringUtils;
import org.eclipse.jetty.util.IO;

public class JspcMojo
extends AbstractMojo {
    private static final String WEB_XML = "web.xml";
    public static final String END_OF_WEBAPP = "</web-app>";
    private MavenProject project;
    private String webXmlFragment;
    private String insertionMarker;
    private boolean mergeFragment;
    private String generatedClasses;
    private boolean keepSources;
    private String packageRoot;
    private String webAppSourceDirectory;
    private String webXml;
    private String[] includes;
    private String[] excludes;
    private File classesDirectory;
    private boolean verbose;
    private boolean validateXml;
    private String javaEncoding;
    private boolean suppressSmap;
    private boolean ignoreJspFragmentErrors;
    private String schemaResourcePrefix;
    private boolean stopAtFirstError;
    private int threads;
    private boolean enableJspTagPooling;
    private boolean trimSpaces;
    private boolean genStringAsCharArray;
    private String compilerVersion;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.getLog().isDebugEnabled()) {
            this.getLog().info((CharSequence)("verbose=" + this.verbose));
            this.getLog().info((CharSequence)("webAppSourceDirectory=" + this.webAppSourceDirectory));
            this.getLog().info((CharSequence)("generatedClasses=" + this.generatedClasses));
            this.getLog().info((CharSequence)("webXmlFragment=" + this.webXmlFragment));
            this.getLog().info((CharSequence)("webXml=" + this.webXml));
            this.getLog().info((CharSequence)("validateXml=" + this.validateXml));
            this.getLog().info((CharSequence)("packageRoot=" + this.packageRoot));
            this.getLog().info((CharSequence)("javaEncoding=" + this.javaEncoding));
            this.getLog().info((CharSequence)("insertionMarker=" + (this.insertionMarker == null || this.insertionMarker.equals("") ? END_OF_WEBAPP : this.insertionMarker)));
            this.getLog().info((CharSequence)("keepSources=" + this.keepSources));
            this.getLog().info((CharSequence)("mergeFragment=" + this.mergeFragment));
            this.getLog().info((CharSequence)("suppressSmap=" + this.suppressSmap));
            this.getLog().info((CharSequence)("ignoreJspFragmentErrors=" + this.ignoreJspFragmentErrors));
            this.getLog().info((CharSequence)("schemaResourcePrefix=" + this.schemaResourcePrefix));
            this.getLog().info((CharSequence)("stopAtFirstError=" + this.stopAtFirstError));
            this.getLog().info((CharSequence)("threads=" + this.threads));
            this.getLog().info((CharSequence)("enableJspTagPooling=" + this.enableJspTagPooling));
            this.getLog().info((CharSequence)("trimSpaces=" + this.trimSpaces));
            this.getLog().info((CharSequence)("genStringAsCharArray=" + this.genStringAsCharArray));
            this.getLog().info((CharSequence)("compilerVersion=" + this.compilerVersion));
        }
        try {
            long start = System.currentTimeMillis();
            this.prepare();
            this.compile();
            this.cleanupSrcs();
            this.mergeWebXml();
            long finish = System.currentTimeMillis();
            long millis = finish - start;
            String time = String.format("%d min, %d sec", TimeUnit.MILLISECONDS.toMinutes(millis), TimeUnit.MILLISECONDS.toSeconds(millis) - TimeUnit.MINUTES.toSeconds(TimeUnit.MILLISECONDS.toMinutes(millis)));
            this.getLog().info((CharSequence)("Compilation completed in " + time));
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failure processing jsps", e);
        }
    }

    public void compile() throws Exception {
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        ArrayList urls = new ArrayList();
        this.setUpClassPath(urls);
        URLClassLoader ucl = new URLClassLoader(urls.toArray(new URL[0]), currentClassLoader);
        StringBuilder classpathStr = new StringBuilder();
        for (int i = 0; i < urls.size(); ++i) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("webappclassloader contains: " + urls.get(i)));
            }
            classpathStr.append(((URL)urls.get(i)).getFile());
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("added to classpath: " + ((URL)urls.get(i)).getFile()));
            }
            classpathStr.append(System.getProperty("path.separator"));
        }
        Thread.currentThread().setContextClassLoader(ucl);
        String[] jspFiles = this.getJspFiles(this.webAppSourceDirectory);
        if (this.verbose) {
            this.getLog().info((CharSequence)("Files selected to precompile: " + jspFiles));
        }
        ExecutorService executor = Executors.newFixedThreadPool(this.threads);
        List<Future<String>> results = executor.invokeAll(this.initJspcWorkers(classpathStr, jspFiles, this.initJspList(jspFiles)));
        executor.shutdown();
        this.getLog().info((CharSequence)("Number total of jsps : " + jspFiles.length));
        this.manageResults(results);
        Thread.currentThread().setContextClassLoader(currentClassLoader);
    }

    private List<String> initJspList(String[] jspFiles) {
        ArrayList<String> jspFilesList = new ArrayList<String>();
        Collections.addAll(jspFilesList, jspFiles);
        return jspFilesList;
    }

    private List<JspcWorker> initJspcWorkers(StringBuilder classpathStr, String[] jspFiles, List<String> jspFilesList) {
        ArrayList<JspcWorker> workers = new ArrayList<JspcWorker>();
        int minItem = jspFiles.length / this.threads;
        int maxItem = minItem + 1;
        int threadsWithMaxItems = jspFiles.length - this.threads * minItem;
        int start = 0;
        for (int index = 0; index < this.threads; ++index) {
            int itemsCount = index < threadsWithMaxItems ? maxItem : minItem;
            int end = start + itemsCount;
            List<String> jspFilesSubList = jspFilesList.subList(start, end);
            JspcWorker worker = new JspcWorker(this.initJspc(classpathStr, index), jspFilesSubList);
            workers.add(worker);
            start = end;
            this.getLog().info((CharSequence)("Number of jsps for thread " + (index + 1) + " : " + jspFilesSubList.size()));
        }
        return workers;
    }

    private JspC initJspc(StringBuilder classpathStr, int threadIndex) {
        JspC jspc = new JspC();
        jspc.setWebXmlFragment(this.getwebXmlFragmentFilename(threadIndex));
        jspc.setUriroot(this.webAppSourceDirectory);
        jspc.setPackage(this.packageRoot);
        jspc.setOutputDir(this.generatedClasses);
        jspc.setValidateXml(this.validateXml);
        jspc.setClassPath(classpathStr.toString());
        jspc.setCompile(true);
        jspc.setSmapSuppressed(this.suppressSmap);
        jspc.setSmapDumped(!this.suppressSmap);
        jspc.setJavaEncoding(this.javaEncoding);
        jspc.setFailOnError(this.stopAtFirstError);
        jspc.setPoolingEnabled(this.enableJspTagPooling);
        jspc.setTrimSpaces(this.trimSpaces);
        jspc.setGenStringAsCharArray(this.genStringAsCharArray);
        jspc.setCompilerSourceVM(this.compilerVersion);
        jspc.setCompilerTargetVM(this.compilerVersion);
        this.getLog().info((CharSequence)("Includes=" + StringUtils.join((Object[])this.includes, (String)",")));
        if (this.excludes != null) {
            this.getLog().info((CharSequence)("Excludes=" + StringUtils.join((Object[])this.excludes, (String)",")));
        }
        if (this.verbose) {
            jspc.setVerbose(99);
        } else {
            jspc.setVerbose(0);
        }
        return jspc;
    }

    private void manageResults(List<Future<String>> results) throws InterruptedException, ExecutionException, MojoExecutionException {
        boolean failTheBuild = false;
        for (Future<String> result : results) {
            if (result.get() == null) continue;
            this.getLog().error((CharSequence)result.get());
            failTheBuild = true;
        }
        if (failTheBuild) {
            throw new MojoExecutionException("see previous errors");
        }
    }

    private String[] getJspFiles(String webAppSourceDirectory) {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(new File(webAppSourceDirectory));
        if (this.excludes != null && this.excludes.length != 0) {
            scanner.setExcludes(this.excludes);
        }
        scanner.addDefaultExcludes();
        scanner.setIncludes(this.includes);
        scanner.setCaseSensitive(false);
        scanner.scan();
        return scanner.getIncludedFiles();
    }

    public void cleanupSrcs() {
        File generatedClassesDir;
        if (!this.keepSources && (generatedClassesDir = new File(this.generatedClasses)).exists() && generatedClassesDir.isDirectory()) {
            JspcMojo.delete(generatedClassesDir, new FileFilter(){

                @Override
                public boolean accept(File f) {
                    return f.isDirectory() || f.getName().endsWith(".java");
                }
            });
        }
    }

    static void delete(File dir, FileFilter filter) {
        File[] files = dir.listFiles(filter);
        for (int i = 0; i < files.length; ++i) {
            File f = files[i];
            if (f.isDirectory()) {
                JspcMojo.delete(f, filter);
                continue;
            }
            f.delete();
        }
    }

    public void mergeWebXml() throws IOException {
        if (this.mergeFragment) {
            File webXmlFile = this.getWebXmlFile();
            if (!webXmlFile.exists()) {
                this.getLog().info((CharSequence)(webXmlFile.toString() + " does not exist, cannot merge with generated fragment"));
                return;
            }
            File mergedWebXml = new File(new File(this.getwebXmlFragmentFilename(0)).getParentFile(), WEB_XML);
            try (BufferedReader webXmlReader = new BufferedReader(new FileReader(webXmlFile));
                 PrintWriter mergedWebXmlWriter = new PrintWriter(new FileWriter(mergedWebXml));){
                String marker = this.writeStartOfWebXmlMergedFile(webXmlReader, mergedWebXmlWriter);
                this.writeXmlFragmentsInMergedXmlFile(mergedWebXmlWriter);
                this.writeEndOfWebXmlMergedFile(webXmlReader, mergedWebXmlWriter, marker);
            }
        }
    }

    private String writeStartOfWebXmlMergedFile(BufferedReader webXmlReader, PrintWriter mergedWebXmlWriter) throws IOException {
        String marker;
        boolean atInsertPoint = false;
        boolean atEOF = false;
        String string = marker = this.insertionMarker == null || this.insertionMarker.equals("") ? END_OF_WEBAPP : this.insertionMarker;
        while (!atInsertPoint && !atEOF) {
            String line = webXmlReader.readLine();
            if (line == null) {
                atEOF = true;
                continue;
            }
            if (line.indexOf(marker) >= 0) {
                atInsertPoint = true;
                continue;
            }
            mergedWebXmlWriter.println(line);
        }
        return marker;
    }

    private void writeXmlFragmentsInMergedXmlFile(PrintWriter mergedWebXmlWriter) throws IOException {
        for (int index = 0; index < this.threads; ++index) {
            File fragmentWebXml = new File(this.getwebXmlFragmentFilename(index));
            if (!fragmentWebXml.exists()) {
                this.getLog().info((CharSequence)("No fragment web.xml file generated for thread " + index));
                continue;
            }
            try (BufferedReader fragmentWebXmlReader = new BufferedReader(new FileReader(fragmentWebXml));){
                IO.copy((Reader)fragmentWebXmlReader, (Writer)mergedWebXmlWriter);
                continue;
            }
        }
    }

    private void writeEndOfWebXmlMergedFile(BufferedReader webXmlReader, PrintWriter mergedWebXmlWriter, String marker) throws IOException {
        if (marker.equals(END_OF_WEBAPP)) {
            mergedWebXmlWriter.println(END_OF_WEBAPP);
        }
        IO.copy((Reader)webXmlReader, (Writer)mergedWebXmlWriter);
    }

    private void prepare() {
        File generatedSourceDirectoryFile = new File(this.generatedClasses);
        if (!generatedSourceDirectoryFile.exists()) {
            generatedSourceDirectoryFile.mkdirs();
        }
    }

    private void setUpClassPath(List urls) throws IOException {
        String classesDir = this.classesDirectory.getCanonicalPath();
        classesDir = classesDir + (classesDir.endsWith(File.pathSeparator) ? "" : File.separator);
        urls.add(new File(classesDir).toURI().toURL());
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Adding to classpath classes dir: " + classesDir));
        }
        for (Artifact artifact : this.project.getArtifacts()) {
            if ("test".equals(artifact.getScope())) continue;
            String filePath = artifact.getFile().getCanonicalPath();
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Adding to classpath dependency file: " + filePath));
            }
            urls.add(artifact.getFile().toURI().toURL());
        }
    }

    private File getWebXmlFile() throws IOException {
        File file = null;
        File baseDir = this.project.getBasedir().getCanonicalFile();
        File defaultWebAppSrcDir = new File(baseDir, "src/main/webapp").getCanonicalFile();
        File webAppSrcDir = new File(this.webAppSourceDirectory).getCanonicalFile();
        File defaultWebXml = new File(defaultWebAppSrcDir, WEB_XML).getCanonicalFile();
        File webXmlFile = new File(this.webXml).getCanonicalFile();
        if (webXmlFile.compareTo(defaultWebXml) != 0) {
            file = new File(this.webXml);
            return file;
        }
        file = new File(webAppSrcDir, WEB_XML);
        return file;
    }

    private String getwebXmlFragmentFilename(int threadIndex) {
        return this.threads == 1 ? this.webXmlFragment : this.webXmlFragment + "." + threadIndex;
    }
}

