/*
 * Decompiled with CFR 0.152.
 */
package io.leonard.maven.plugins.jspc;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.apache.jasper.JspC;

public class JspcWorker
implements Callable<String> {
    private static final Logger logger = Logger.getLogger(JspC.class.getName());
    private JspC jspc;
    private List<String> jspFiles;
    private List<String> errors = new ArrayList<String>();

    public JspcWorker(JspC jspc, List<String> jspFiles) {
        this.jspc = jspc;
        this.jspFiles = jspFiles;
        logger.addHandler(new TomcatLogHandler());
    }

    @Override
    public String call() throws Exception {
        this.jspc.setJspFiles(this.getAllCommaSeparatedJsp());
        try {
            this.jspc.execute();
        }
        catch (Exception e) {
            return e.getMessage();
        }
        if (!this.errors.isEmpty()) {
            return "Jspc fail with errors, see previous log";
        }
        return null;
    }

    private String getAllCommaSeparatedJsp() {
        Object allJsp = "";
        for (String fileName : this.jspFiles) {
            allJsp = (String)allJsp + fileName + ",";
        }
        return allJsp;
    }

    class TomcatLogHandler
    extends Handler {
        TomcatLogHandler() {
        }

        @Override
        public void publish(LogRecord record) {
            if (Level.SEVERE.equals(record.getLevel())) {
                JspcWorker.this.errors.add(record.getMessage());
            }
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() throws SecurityException {
        }
    }
}

