/*
 * Decompiled with CFR 0.152.
 */
package net.rootdev.javardfa;

import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLOutputFactory;
import net.rootdev.javardfa.Parser;
import net.rootdev.javardfa.Resolver;
import net.rootdev.javardfa.Setting;
import net.rootdev.javardfa.StatementSink;
import net.rootdev.javardfa.uri.IRIResolver;
import net.rootdev.javardfa.uri.URIExtractor;
import net.rootdev.javardfa.uri.URIExtractor10;
import net.rootdev.javardfa.uri.URIExtractor11;
import nu.validator.htmlparser.common.XmlViolationPolicy;
import nu.validator.htmlparser.sax.HtmlParser;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class ParserFactory {
    public static XMLReader createNonvalidatingReader() throws SAXException {
        XMLReader reader = XMLReaderFactory.createXMLReader();
        reader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        try {
            reader.setFeature("http://www.xml.org/sax/features/validation", false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return reader;
    }

    public static XMLReader createHTML5Reader() {
        HtmlParser reader = new HtmlParser();
        reader.setXmlPolicy(XmlViolationPolicy.ALLOW);
        reader.setXmlnsPolicy(XmlViolationPolicy.ALLOW);
        reader.setMappingLangToXmlLang(false);
        return reader;
    }

    public static XMLReader createReaderForFormat(StatementSink sink, Format format, Setting ... settings) throws SAXException {
        return ParserFactory.createReaderForFormat(sink, format, new IRIResolver(), settings);
    }

    public static XMLReader createReaderForFormat(StatementSink sink, Format format, Resolver resolver, Setting ... settings) throws SAXException {
        XMLReader reader = ParserFactory.getReader(format);
        boolean is11 = false;
        for (Setting setting : settings) {
            if (setting != Setting.OnePointOne) continue;
            is11 = true;
        }
        URIExtractor extractor = is11 ? new URIExtractor11(resolver) : new URIExtractor10(resolver);
        Parser parser = ParserFactory.getParser(format, sink, extractor);
        for (Setting setting : settings) {
            parser.enable(setting);
        }
        reader.setContentHandler(parser);
        reader.setErrorHandler(parser);
        return reader;
    }

    private static XMLReader getReader(Format format) throws SAXException {
        switch (format) {
            case XHTML: {
                return ParserFactory.createNonvalidatingReader();
            }
        }
        return ParserFactory.createHTML5Reader();
    }

    private static Parser getParser(Format format, StatementSink sink, URIExtractor extractor) {
        return ParserFactory.getParser(format, sink, XMLOutputFactory.newInstance(), XMLEventFactory.newInstance(), extractor);
    }

    private static Parser getParser(Format format, StatementSink sink, XMLOutputFactory outputFactory, XMLEventFactory eventFactory, URIExtractor extractor) {
        switch (format) {
            case XHTML: {
                return new Parser(sink, outputFactory, eventFactory, extractor);
            }
        }
        Parser p = new Parser(sink, outputFactory, eventFactory, extractor);
        p.enable(Setting.ManualNamespaces);
        return p;
    }

    public static enum Format {
        HTML,
        XHTML;


        public static Format lookup(String format) {
            if ("xhtml".equalsIgnoreCase(format)) {
                return XHTML;
            }
            if ("html".equalsIgnoreCase(format)) {
                return HTML;
            }
            return null;
        }
    }
}

