/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.util.List;
import java.util.ListIterator;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.ListIterator;
import net.sf.saxon.tree.iter.ReversibleIterator;
import net.sf.saxon.value.SequenceExtent;

public class Reverse
extends SystemFunction {
    @Override
    public int getSpecialProperties(Expression[] arguments) {
        int baseProps = arguments[0].getSpecialProperties();
        if ((baseProps & 0x40000) != 0) {
            return baseProps & 0xFFFBFFFF | 0x20000;
        }
        if ((baseProps & 0x20000) != 0) {
            return baseProps & 0xFFFDFFFF | 0x40000;
        }
        return baseProps;
    }

    public static SequenceIterator getReverseIterator(SequenceIterator forwards) {
        if (forwards instanceof ReversibleIterator) {
            return ((ReversibleIterator)forwards).getReverseIterator();
        }
        return SequenceExtent.from(forwards).reverseIterate();
    }

    @Override
    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        SequenceExtent.Of<Item> input = arguments[0] instanceof SequenceExtent ? (SequenceExtent.Of<Item>)arguments[0] : SequenceExtent.from(arguments[0].iterate());
        return SequenceTool.toLazySequence(((SequenceExtent)input).reverseIterate());
    }

    @Override
    public Expression makeOptimizedFunctionCall(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo, Expression ... arguments) throws XPathException {
        if (arguments[0].getCardinality() == 24576) {
            return arguments[0];
        }
        return super.makeOptimizedFunctionCall(visitor, contextInfo, arguments);
    }

    public static <T extends Item> SequenceIterator reverseIterator(List<T> list) {
        return new ReverseListIterator(list);
    }

    @Override
    public String getStreamerName() {
        return "Reverse";
    }

    public static class ReverseListIterator
    implements SequenceIterator,
    LastPositionFinder,
    ReversibleIterator {
        private final ListIterator<? extends Item> listIter;
        private final List<? extends Item> list;

        public <T extends Item> ReverseListIterator(List<T> list) {
            this.list = list;
            this.listIter = list.listIterator(list.size());
        }

        @Override
        public boolean supportsGetLength() {
            return true;
        }

        @Override
        public int getLength() {
            return this.list.size();
        }

        @Override
        public Item next() {
            return this.listIter.hasPrevious() ? this.listIter.previous() : null;
        }

        @Override
        public SequenceIterator getReverseIterator() {
            return new ListIterator.Of<Item>(this.list);
        }
    }
}

