<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:cat="http://www.saxonica.com/ns/doc/catalog"
  xmlns:fn="http://www.saxonica.com/ns/doc/functions" xmlns:xs="http://www.w3.org/2001/XMLSchema"
  xmlns:saxon="http://saxon.sf.net/" exclude-result-prefixes="cat fn xs saxon"
  default-collation="http://saxon.sf.net/collation?ignore-case=yes">

  <!--<xsl:include href="render-functions.xsl"/>-->

  <xsl:output method="xml" encoding="iso-8859-1" indent="yes"/>

  <xsl:param name="destination" select="'online'" as="xs:string"/>
  <xsl:param name="doc" />
  <!-- set this to "online" for the web site, "offline" for the document supplied in the download"-->

  <xsl:variable name="img" select="if ($destination='online') then '../img' else 'img'"/>

  <xsl:import-schema schema-location="../src/saxon-doc-schema.xsd"/>
  <xsl:import-schema namespace="http://www.saxonica.com/ns/doc/catalog"
    schema-location="../src/catalog-schema.xsd"/>
  <xsl:import-schema namespace="http://www.saxonica.com/ns/doc/functions"
    schema-location="../src/functions-schema.xsd"/>

  <xsl:variable name="sections" select="/cat:catalog/cat:section/@ref"/>

  <xsl:template match="/">
    <!-- process the catalog file -->
    <xsl:if test="not(* instance of schema-element(cat:catalog))">
      <xsl:message terminate="yes"> Input file must be a validated instance of cat:catalog
      </xsl:message>
    </xsl:if>
    <xsl:apply-templates/>
    <!--  <xsl:call-template name="generate-contents"/>
      <xsl:call-template name="generate-xml-contents"/> -->
  </xsl:template>

  <xsl:template match="cat:catalog">
    <xsl:call-template name="collections">
      <xsl:with-param name="docs" select="for $v in cat:section/@ref[.!='index-entries'] return if(matches($v,'[a-z|A-Z|0-9]')) then document(concat($v, '.xml'),/) else document(concat(replace($v, 'Θ', '398'), '.xml'),/)"></xsl:with-param>
    </xsl:call-template>
  </xsl:template>
  
  <xsl:variable name="stop-words"
    select="'a', 'the', 'to', 'and', 'is', 'with', 'of', 'on', '', 'what', 'about', 'getting', 'started', 'choosing', 'in', 'for', 'this'"/>
  
  <!-- Processing of a collection of documents -->
  <xsl:template name="collections">
    <xsl:param name="docs"></xsl:param>
    <xsl:variable name="index-entry">
      <xsl:for-each select="$docs//(title| subtitle | index)">
        <xsl:variable name="section" select="ancestor::section/@xml:id"/>
        <xsl:variable name="section-title" select="ancestor::section/title"/>
        <xsl:variable name="page" select="ancestor::page/@xml:id"/>
        <xsl:variable name="page-title" select="ancestor::page/title"/>
        <xsl:variable name="subpage" select="ancestor::subpage/@xml:id"/>
        <xsl:variable name="subpage-title" select="ancestor::subpage/title"/>
        <xsl:variable name="title" select="."/>
        <xsl:variable name="name" select="name()"/>
        <xsl:for-each select="tokenize(replace(.,'\.(\s|$)','$1'),'[\W\p{S}-[\-\.'']]+')[not(.=$stop-words)]">
          <token section="{$section}" page="{$page}" subpage="{$subpage}" title="{$title}"
            section-title="{$section-title}" page-title="{$page-title}" subpage-title="{$subpage-title}"
            value="{.}"/>
        </xsl:for-each>
      </xsl:for-each>
    </xsl:variable>
    <section xml:id="index-entries">
      <title>Alphabetical Index</title>
      <page xml:id="intro">
        <title>Introduction</title>
        <p>Click on the initial letter of the term you are looking for:</p>
        <p>
            <xsl:for-each-group select="$index-entry/token" group-by="upper-case(substring(@value, 1,1))">
                <xsl:sort select="current-grouping-key()" order="ascending"/>
                <xsl:if test="position() != 1"> | </xsl:if> 
              <xref section="index-entries" page="_{if(matches(current-grouping-key(),'[a-z|A-Z|0-9]')) then current-grouping-key() else replace(current-grouping-key(),'Θ', '398')}">                   
                    <xsl:value-of select="current-grouping-key()"/>
                </xref>
            </xsl:for-each-group>
        </p>
      </page>
      <xsl:for-each-group select="$index-entry/token" group-by="upper-case(substring(@value, 1,1))">
        <xsl:sort select="current-grouping-key()" order="ascending"/>
        <page xml:id="_{if(matches(current-grouping-key(),'[a-z|A-Z|0-9]')) then current-grouping-key() else replace(current-grouping-key(),'Θ', '398')}">
          <title>
            <xsl:value-of select="current-grouping-key()"/>
          </title>
          <xsl:for-each-group select="current-group()" group-by="@value">
            <xsl:sort select="current-grouping-key()" order="ascending"/>

            <subtitle>
              <xsl:value-of select="upper-case(current-grouping-key())"/>
            </subtitle>
            <xsl:for-each-group select="current-group()" group-by="@title">
              <xsl:sort select="@title" order="ascending"/>
              <xsl:variable name="unique" as="xs:boolean" select="count(current-group()) = 1"/>
              <xsl:for-each select="current-group()">
                <p>              
                  <xref section="{@section}">
                    <xsl:if test="@subpage!=''">
                      <xsl:attribute name="subpage" select="@subpage"></xsl:attribute>
                    </xsl:if>
                    <xsl:if test="@page!=''">
                      <xsl:attribute name="page" select="@page"></xsl:attribute>
                    </xsl:if>
                    <xsl:value-of select="@title"/>                    
                  </xref>
                  <xsl:if test="not($unique)">
                    <xsl:choose>
                      <xsl:when test="not(@subpage-title = (@title, ''))">
                        <xsl:text> in </xsl:text>
                        <xref section="{@section}" page="{@page}" subpage="{@subpage}">
                          <xsl:value-of select="@subpage-title"/>
                        </xref>
                      </xsl:when>
                      <xsl:when test="not(@page-title = (@title, ''))">
                        <xsl:text> in </xsl:text>
                        <xref section="{@section}" page="{@page}">
                          <xsl:value-of select="@page-title"/>
                        </xref>
                      </xsl:when>
                      <xsl:when test="not(@section-title = (@title, ''))">
                        <xsl:text> in </xsl:text>
                        <xref section="{@section}">
                          <xsl:value-of select="@section-title"/>
                        </xref>
                      </xsl:when>
                    </xsl:choose>
                  </xsl:if>
                </p>
              </xsl:for-each>
            </xsl:for-each-group>
          </xsl:for-each-group>
        </page>
      </xsl:for-each-group>
    </section>
  </xsl:template>

</xsl:stylesheet>
