/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to you under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: common.proto

package org.apache.calcite.avatica.proto;

@SuppressWarnings({"unused", "rawtypes"}) public final class Common {
  private Common() {}
  public static void registerAllExtensions(
      com.google.protobuf.ExtensionRegistry registry) {
  }
  /**
   * Protobuf enum {@code StatementType}
   *
   * <pre>
   * Has to be consistent with Meta.StatementType
   * </pre>
   */
  public enum StatementType
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <code>SELECT = 0;</code>
     */
    SELECT(0, 0),
    /**
     * <code>INSERT = 1;</code>
     */
    INSERT(1, 1),
    /**
     * <code>UPDATE = 2;</code>
     */
    UPDATE(2, 2),
    /**
     * <code>DELETE = 3;</code>
     */
    DELETE(3, 3),
    /**
     * <code>UPSERT = 4;</code>
     */
    UPSERT(4, 4),
    /**
     * <code>MERGE = 5;</code>
     */
    MERGE(5, 5),
    /**
     * <code>OTHER_DML = 6;</code>
     */
    OTHER_DML(6, 6),
    /**
     * <code>CREATE = 7;</code>
     */
    CREATE(7, 7),
    /**
     * <code>DROP = 8;</code>
     */
    DROP(8, 8),
    /**
     * <code>ALTER = 9;</code>
     */
    ALTER(9, 9),
    /**
     * <code>OTHER_DDL = 10;</code>
     */
    OTHER_DDL(10, 10),
    /**
     * <code>CALL = 11;</code>
     */
    CALL(11, 11),
    UNRECOGNIZED(-1, -1),
    ;

    /**
     * <code>SELECT = 0;</code>
     */
    public static final int SELECT_VALUE = 0;
    /**
     * <code>INSERT = 1;</code>
     */
    public static final int INSERT_VALUE = 1;
    /**
     * <code>UPDATE = 2;</code>
     */
    public static final int UPDATE_VALUE = 2;
    /**
     * <code>DELETE = 3;</code>
     */
    public static final int DELETE_VALUE = 3;
    /**
     * <code>UPSERT = 4;</code>
     */
    public static final int UPSERT_VALUE = 4;
    /**
     * <code>MERGE = 5;</code>
     */
    public static final int MERGE_VALUE = 5;
    /**
     * <code>OTHER_DML = 6;</code>
     */
    public static final int OTHER_DML_VALUE = 6;
    /**
     * <code>CREATE = 7;</code>
     */
    public static final int CREATE_VALUE = 7;
    /**
     * <code>DROP = 8;</code>
     */
    public static final int DROP_VALUE = 8;
    /**
     * <code>ALTER = 9;</code>
     */
    public static final int ALTER_VALUE = 9;
    /**
     * <code>OTHER_DDL = 10;</code>
     */
    public static final int OTHER_DDL_VALUE = 10;
    /**
     * <code>CALL = 11;</code>
     */
    public static final int CALL_VALUE = 11;


    public final int getNumber() {
      if (index == -1) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    public static StatementType valueOf(int value) {
      switch (value) {
        case 0: return SELECT;
        case 1: return INSERT;
        case 2: return UPDATE;
        case 3: return DELETE;
        case 4: return UPSERT;
        case 5: return MERGE;
        case 6: return OTHER_DML;
        case 7: return CREATE;
        case 8: return DROP;
        case 9: return ALTER;
        case 10: return OTHER_DDL;
        case 11: return CALL;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<StatementType>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static final com.google.protobuf.Internal.EnumLiteMap<
        StatementType> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<StatementType>() {
            public StatementType findValueByNumber(int number) {
              return StatementType.valueOf(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      return getDescriptor().getValues().get(index);
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return org.apache.calcite.avatica.proto.Common.getDescriptor().getEnumTypes().get(0);
    }

    private static final StatementType[] VALUES = values();

    public static StatementType valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int index;
    private final int value;

    private StatementType(int index, int value) {
      this.index = index;
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:StatementType)
  }

  /**
   * Protobuf enum {@code Rep}
   */
  public enum Rep
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <code>PRIMITIVE_BOOLEAN = 0;</code>
     */
    PRIMITIVE_BOOLEAN(0, 0),
    /**
     * <code>PRIMITIVE_BYTE = 1;</code>
     */
    PRIMITIVE_BYTE(1, 1),
    /**
     * <code>PRIMITIVE_CHAR = 2;</code>
     */
    PRIMITIVE_CHAR(2, 2),
    /**
     * <code>PRIMITIVE_SHORT = 3;</code>
     */
    PRIMITIVE_SHORT(3, 3),
    /**
     * <code>PRIMITIVE_INT = 4;</code>
     */
    PRIMITIVE_INT(4, 4),
    /**
     * <code>PRIMITIVE_LONG = 5;</code>
     */
    PRIMITIVE_LONG(5, 5),
    /**
     * <code>PRIMITIVE_FLOAT = 6;</code>
     */
    PRIMITIVE_FLOAT(6, 6),
    /**
     * <code>PRIMITIVE_DOUBLE = 7;</code>
     */
    PRIMITIVE_DOUBLE(7, 7),
    /**
     * <code>BOOLEAN = 8;</code>
     */
    BOOLEAN(8, 8),
    /**
     * <code>BYTE = 9;</code>
     */
    BYTE(9, 9),
    /**
     * <code>CHARACTER = 10;</code>
     */
    CHARACTER(10, 10),
    /**
     * <code>SHORT = 11;</code>
     */
    SHORT(11, 11),
    /**
     * <code>INTEGER = 12;</code>
     */
    INTEGER(12, 12),
    /**
     * <code>LONG = 13;</code>
     */
    LONG(13, 13),
    /**
     * <code>FLOAT = 14;</code>
     */
    FLOAT(14, 14),
    /**
     * <code>DOUBLE = 15;</code>
     */
    DOUBLE(15, 15),
    /**
     * <code>BIG_INTEGER = 25;</code>
     */
    BIG_INTEGER(16, 25),
    /**
     * <code>BIG_DECIMAL = 26;</code>
     */
    BIG_DECIMAL(17, 26),
    /**
     * <code>JAVA_SQL_TIME = 16;</code>
     */
    JAVA_SQL_TIME(18, 16),
    /**
     * <code>JAVA_SQL_TIMESTAMP = 17;</code>
     */
    JAVA_SQL_TIMESTAMP(19, 17),
    /**
     * <code>JAVA_SQL_DATE = 18;</code>
     */
    JAVA_SQL_DATE(20, 18),
    /**
     * <code>JAVA_UTIL_DATE = 19;</code>
     */
    JAVA_UTIL_DATE(21, 19),
    /**
     * <code>BYTE_STRING = 20;</code>
     */
    BYTE_STRING(22, 20),
    /**
     * <code>STRING = 21;</code>
     */
    STRING(23, 21),
    /**
     * <code>NUMBER = 22;</code>
     */
    NUMBER(24, 22),
    /**
     * <code>OBJECT = 23;</code>
     */
    OBJECT(25, 23),
    /**
     * <code>NULL = 24;</code>
     */
    NULL(26, 24),
    /**
     * <code>ARRAY = 27;</code>
     */
    ARRAY(27, 27),
    /**
     * <code>STRUCT = 28;</code>
     */
    STRUCT(28, 28),
    /**
     * <code>MULTISET = 29;</code>
     */
    MULTISET(29, 29),
    UNRECOGNIZED(-1, -1),
    ;

    /**
     * <code>PRIMITIVE_BOOLEAN = 0;</code>
     */
    public static final int PRIMITIVE_BOOLEAN_VALUE = 0;
    /**
     * <code>PRIMITIVE_BYTE = 1;</code>
     */
    public static final int PRIMITIVE_BYTE_VALUE = 1;
    /**
     * <code>PRIMITIVE_CHAR = 2;</code>
     */
    public static final int PRIMITIVE_CHAR_VALUE = 2;
    /**
     * <code>PRIMITIVE_SHORT = 3;</code>
     */
    public static final int PRIMITIVE_SHORT_VALUE = 3;
    /**
     * <code>PRIMITIVE_INT = 4;</code>
     */
    public static final int PRIMITIVE_INT_VALUE = 4;
    /**
     * <code>PRIMITIVE_LONG = 5;</code>
     */
    public static final int PRIMITIVE_LONG_VALUE = 5;
    /**
     * <code>PRIMITIVE_FLOAT = 6;</code>
     */
    public static final int PRIMITIVE_FLOAT_VALUE = 6;
    /**
     * <code>PRIMITIVE_DOUBLE = 7;</code>
     */
    public static final int PRIMITIVE_DOUBLE_VALUE = 7;
    /**
     * <code>BOOLEAN = 8;</code>
     */
    public static final int BOOLEAN_VALUE = 8;
    /**
     * <code>BYTE = 9;</code>
     */
    public static final int BYTE_VALUE = 9;
    /**
     * <code>CHARACTER = 10;</code>
     */
    public static final int CHARACTER_VALUE = 10;
    /**
     * <code>SHORT = 11;</code>
     */
    public static final int SHORT_VALUE = 11;
    /**
     * <code>INTEGER = 12;</code>
     */
    public static final int INTEGER_VALUE = 12;
    /**
     * <code>LONG = 13;</code>
     */
    public static final int LONG_VALUE = 13;
    /**
     * <code>FLOAT = 14;</code>
     */
    public static final int FLOAT_VALUE = 14;
    /**
     * <code>DOUBLE = 15;</code>
     */
    public static final int DOUBLE_VALUE = 15;
    /**
     * <code>BIG_INTEGER = 25;</code>
     */
    public static final int BIG_INTEGER_VALUE = 25;
    /**
     * <code>BIG_DECIMAL = 26;</code>
     */
    public static final int BIG_DECIMAL_VALUE = 26;
    /**
     * <code>JAVA_SQL_TIME = 16;</code>
     */
    public static final int JAVA_SQL_TIME_VALUE = 16;
    /**
     * <code>JAVA_SQL_TIMESTAMP = 17;</code>
     */
    public static final int JAVA_SQL_TIMESTAMP_VALUE = 17;
    /**
     * <code>JAVA_SQL_DATE = 18;</code>
     */
    public static final int JAVA_SQL_DATE_VALUE = 18;
    /**
     * <code>JAVA_UTIL_DATE = 19;</code>
     */
    public static final int JAVA_UTIL_DATE_VALUE = 19;
    /**
     * <code>BYTE_STRING = 20;</code>
     */
    public static final int BYTE_STRING_VALUE = 20;
    /**
     * <code>STRING = 21;</code>
     */
    public static final int STRING_VALUE = 21;
    /**
     * <code>NUMBER = 22;</code>
     */
    public static final int NUMBER_VALUE = 22;
    /**
     * <code>OBJECT = 23;</code>
     */
    public static final int OBJECT_VALUE = 23;
    /**
     * <code>NULL = 24;</code>
     */
    public static final int NULL_VALUE = 24;
    /**
     * <code>ARRAY = 27;</code>
     */
    public static final int ARRAY_VALUE = 27;
    /**
     * <code>STRUCT = 28;</code>
     */
    public static final int STRUCT_VALUE = 28;
    /**
     * <code>MULTISET = 29;</code>
     */
    public static final int MULTISET_VALUE = 29;


    public final int getNumber() {
      if (index == -1) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    public static Rep valueOf(int value) {
      switch (value) {
        case 0: return PRIMITIVE_BOOLEAN;
        case 1: return PRIMITIVE_BYTE;
        case 2: return PRIMITIVE_CHAR;
        case 3: return PRIMITIVE_SHORT;
        case 4: return PRIMITIVE_INT;
        case 5: return PRIMITIVE_LONG;
        case 6: return PRIMITIVE_FLOAT;
        case 7: return PRIMITIVE_DOUBLE;
        case 8: return BOOLEAN;
        case 9: return BYTE;
        case 10: return CHARACTER;
        case 11: return SHORT;
        case 12: return INTEGER;
        case 13: return LONG;
        case 14: return FLOAT;
        case 15: return DOUBLE;
        case 25: return BIG_INTEGER;
        case 26: return BIG_DECIMAL;
        case 16: return JAVA_SQL_TIME;
        case 17: return JAVA_SQL_TIMESTAMP;
        case 18: return JAVA_SQL_DATE;
        case 19: return JAVA_UTIL_DATE;
        case 20: return BYTE_STRING;
        case 21: return STRING;
        case 22: return NUMBER;
        case 23: return OBJECT;
        case 24: return NULL;
        case 27: return ARRAY;
        case 28: return STRUCT;
        case 29: return MULTISET;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Rep>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static final com.google.protobuf.Internal.EnumLiteMap<
        Rep> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<Rep>() {
            public Rep findValueByNumber(int number) {
              return Rep.valueOf(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      return getDescriptor().getValues().get(index);
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return org.apache.calcite.avatica.proto.Common.getDescriptor().getEnumTypes().get(1);
    }

    private static final Rep[] VALUES = values();

    public static Rep valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int index;
    private final int value;

    private Rep(int index, int value) {
      this.index = index;
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:Rep)
  }

  /**
   * Protobuf enum {@code Severity}
   *
   * <pre>
   * The severity of some unexpected outcome to an operation.
   * Protobuf enum values must be unique across all other enums
   * </pre>
   */
  public enum Severity
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <code>UNKNOWN_SEVERITY = 0;</code>
     */
    UNKNOWN_SEVERITY(0, 0),
    /**
     * <code>FATAL_SEVERITY = 1;</code>
     */
    FATAL_SEVERITY(1, 1),
    /**
     * <code>ERROR_SEVERITY = 2;</code>
     */
    ERROR_SEVERITY(2, 2),
    /**
     * <code>WARNING_SEVERITY = 3;</code>
     */
    WARNING_SEVERITY(3, 3),
    UNRECOGNIZED(-1, -1),
    ;

    /**
     * <code>UNKNOWN_SEVERITY = 0;</code>
     */
    public static final int UNKNOWN_SEVERITY_VALUE = 0;
    /**
     * <code>FATAL_SEVERITY = 1;</code>
     */
    public static final int FATAL_SEVERITY_VALUE = 1;
    /**
     * <code>ERROR_SEVERITY = 2;</code>
     */
    public static final int ERROR_SEVERITY_VALUE = 2;
    /**
     * <code>WARNING_SEVERITY = 3;</code>
     */
    public static final int WARNING_SEVERITY_VALUE = 3;


    public final int getNumber() {
      if (index == -1) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    public static Severity valueOf(int value) {
      switch (value) {
        case 0: return UNKNOWN_SEVERITY;
        case 1: return FATAL_SEVERITY;
        case 2: return ERROR_SEVERITY;
        case 3: return WARNING_SEVERITY;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Severity>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static final com.google.protobuf.Internal.EnumLiteMap<
        Severity> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<Severity>() {
            public Severity findValueByNumber(int number) {
              return Severity.valueOf(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      return getDescriptor().getValues().get(index);
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return org.apache.calcite.avatica.proto.Common.getDescriptor().getEnumTypes().get(2);
    }

    private static final Severity[] VALUES = values();

    public static Severity valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int index;
    private final int value;

    private Severity(int index, int value) {
      this.index = index;
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:Severity)
  }

  /**
   * Protobuf enum {@code MetaDataOperation}
   *
   * <pre>
   * Enumeration corresponding to DatabaseMetaData operations
   * </pre>
   */
  public enum MetaDataOperation
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <code>GET_ATTRIBUTES = 0;</code>
     */
    GET_ATTRIBUTES(0, 0),
    /**
     * <code>GET_BEST_ROW_IDENTIFIER = 1;</code>
     */
    GET_BEST_ROW_IDENTIFIER(1, 1),
    /**
     * <code>GET_CATALOGS = 2;</code>
     */
    GET_CATALOGS(2, 2),
    /**
     * <code>GET_CLIENT_INFO_PROPERTIES = 3;</code>
     */
    GET_CLIENT_INFO_PROPERTIES(3, 3),
    /**
     * <code>GET_COLUMN_PRIVILEGES = 4;</code>
     */
    GET_COLUMN_PRIVILEGES(4, 4),
    /**
     * <code>GET_COLUMNS = 5;</code>
     */
    GET_COLUMNS(5, 5),
    /**
     * <code>GET_CROSS_REFERENCE = 6;</code>
     */
    GET_CROSS_REFERENCE(6, 6),
    /**
     * <code>GET_EXPORTED_KEYS = 7;</code>
     */
    GET_EXPORTED_KEYS(7, 7),
    /**
     * <code>GET_FUNCTION_COLUMNS = 8;</code>
     */
    GET_FUNCTION_COLUMNS(8, 8),
    /**
     * <code>GET_FUNCTIONS = 9;</code>
     */
    GET_FUNCTIONS(9, 9),
    /**
     * <code>GET_IMPORTED_KEYS = 10;</code>
     */
    GET_IMPORTED_KEYS(10, 10),
    /**
     * <code>GET_INDEX_INFO = 11;</code>
     */
    GET_INDEX_INFO(11, 11),
    /**
     * <code>GET_PRIMARY_KEYS = 12;</code>
     */
    GET_PRIMARY_KEYS(12, 12),
    /**
     * <code>GET_PROCEDURE_COLUMNS = 13;</code>
     */
    GET_PROCEDURE_COLUMNS(13, 13),
    /**
     * <code>GET_PROCEDURES = 14;</code>
     */
    GET_PROCEDURES(14, 14),
    /**
     * <code>GET_PSEUDO_COLUMNS = 15;</code>
     */
    GET_PSEUDO_COLUMNS(15, 15),
    /**
     * <code>GET_SCHEMAS = 16;</code>
     */
    GET_SCHEMAS(16, 16),
    /**
     * <code>GET_SCHEMAS_WITH_ARGS = 17;</code>
     */
    GET_SCHEMAS_WITH_ARGS(17, 17),
    /**
     * <code>GET_SUPER_TABLES = 18;</code>
     */
    GET_SUPER_TABLES(18, 18),
    /**
     * <code>GET_SUPER_TYPES = 19;</code>
     */
    GET_SUPER_TYPES(19, 19),
    /**
     * <code>GET_TABLE_PRIVILEGES = 20;</code>
     */
    GET_TABLE_PRIVILEGES(20, 20),
    /**
     * <code>GET_TABLES = 21;</code>
     */
    GET_TABLES(21, 21),
    /**
     * <code>GET_TABLE_TYPES = 22;</code>
     */
    GET_TABLE_TYPES(22, 22),
    /**
     * <code>GET_TYPE_INFO = 23;</code>
     */
    GET_TYPE_INFO(23, 23),
    /**
     * <code>GET_UDTS = 24;</code>
     */
    GET_UDTS(24, 24),
    /**
     * <code>GET_VERSION_COLUMNS = 25;</code>
     */
    GET_VERSION_COLUMNS(25, 25),
    UNRECOGNIZED(-1, -1),
    ;

    /**
     * <code>GET_ATTRIBUTES = 0;</code>
     */
    public static final int GET_ATTRIBUTES_VALUE = 0;
    /**
     * <code>GET_BEST_ROW_IDENTIFIER = 1;</code>
     */
    public static final int GET_BEST_ROW_IDENTIFIER_VALUE = 1;
    /**
     * <code>GET_CATALOGS = 2;</code>
     */
    public static final int GET_CATALOGS_VALUE = 2;
    /**
     * <code>GET_CLIENT_INFO_PROPERTIES = 3;</code>
     */
    public static final int GET_CLIENT_INFO_PROPERTIES_VALUE = 3;
    /**
     * <code>GET_COLUMN_PRIVILEGES = 4;</code>
     */
    public static final int GET_COLUMN_PRIVILEGES_VALUE = 4;
    /**
     * <code>GET_COLUMNS = 5;</code>
     */
    public static final int GET_COLUMNS_VALUE = 5;
    /**
     * <code>GET_CROSS_REFERENCE = 6;</code>
     */
    public static final int GET_CROSS_REFERENCE_VALUE = 6;
    /**
     * <code>GET_EXPORTED_KEYS = 7;</code>
     */
    public static final int GET_EXPORTED_KEYS_VALUE = 7;
    /**
     * <code>GET_FUNCTION_COLUMNS = 8;</code>
     */
    public static final int GET_FUNCTION_COLUMNS_VALUE = 8;
    /**
     * <code>GET_FUNCTIONS = 9;</code>
     */
    public static final int GET_FUNCTIONS_VALUE = 9;
    /**
     * <code>GET_IMPORTED_KEYS = 10;</code>
     */
    public static final int GET_IMPORTED_KEYS_VALUE = 10;
    /**
     * <code>GET_INDEX_INFO = 11;</code>
     */
    public static final int GET_INDEX_INFO_VALUE = 11;
    /**
     * <code>GET_PRIMARY_KEYS = 12;</code>
     */
    public static final int GET_PRIMARY_KEYS_VALUE = 12;
    /**
     * <code>GET_PROCEDURE_COLUMNS = 13;</code>
     */
    public static final int GET_PROCEDURE_COLUMNS_VALUE = 13;
    /**
     * <code>GET_PROCEDURES = 14;</code>
     */
    public static final int GET_PROCEDURES_VALUE = 14;
    /**
     * <code>GET_PSEUDO_COLUMNS = 15;</code>
     */
    public static final int GET_PSEUDO_COLUMNS_VALUE = 15;
    /**
     * <code>GET_SCHEMAS = 16;</code>
     */
    public static final int GET_SCHEMAS_VALUE = 16;
    /**
     * <code>GET_SCHEMAS_WITH_ARGS = 17;</code>
     */
    public static final int GET_SCHEMAS_WITH_ARGS_VALUE = 17;
    /**
     * <code>GET_SUPER_TABLES = 18;</code>
     */
    public static final int GET_SUPER_TABLES_VALUE = 18;
    /**
     * <code>GET_SUPER_TYPES = 19;</code>
     */
    public static final int GET_SUPER_TYPES_VALUE = 19;
    /**
     * <code>GET_TABLE_PRIVILEGES = 20;</code>
     */
    public static final int GET_TABLE_PRIVILEGES_VALUE = 20;
    /**
     * <code>GET_TABLES = 21;</code>
     */
    public static final int GET_TABLES_VALUE = 21;
    /**
     * <code>GET_TABLE_TYPES = 22;</code>
     */
    public static final int GET_TABLE_TYPES_VALUE = 22;
    /**
     * <code>GET_TYPE_INFO = 23;</code>
     */
    public static final int GET_TYPE_INFO_VALUE = 23;
    /**
     * <code>GET_UDTS = 24;</code>
     */
    public static final int GET_UDTS_VALUE = 24;
    /**
     * <code>GET_VERSION_COLUMNS = 25;</code>
     */
    public static final int GET_VERSION_COLUMNS_VALUE = 25;


    public final int getNumber() {
      if (index == -1) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    public static MetaDataOperation valueOf(int value) {
      switch (value) {
        case 0: return GET_ATTRIBUTES;
        case 1: return GET_BEST_ROW_IDENTIFIER;
        case 2: return GET_CATALOGS;
        case 3: return GET_CLIENT_INFO_PROPERTIES;
        case 4: return GET_COLUMN_PRIVILEGES;
        case 5: return GET_COLUMNS;
        case 6: return GET_CROSS_REFERENCE;
        case 7: return GET_EXPORTED_KEYS;
        case 8: return GET_FUNCTION_COLUMNS;
        case 9: return GET_FUNCTIONS;
        case 10: return GET_IMPORTED_KEYS;
        case 11: return GET_INDEX_INFO;
        case 12: return GET_PRIMARY_KEYS;
        case 13: return GET_PROCEDURE_COLUMNS;
        case 14: return GET_PROCEDURES;
        case 15: return GET_PSEUDO_COLUMNS;
        case 16: return GET_SCHEMAS;
        case 17: return GET_SCHEMAS_WITH_ARGS;
        case 18: return GET_SUPER_TABLES;
        case 19: return GET_SUPER_TYPES;
        case 20: return GET_TABLE_PRIVILEGES;
        case 21: return GET_TABLES;
        case 22: return GET_TABLE_TYPES;
        case 23: return GET_TYPE_INFO;
        case 24: return GET_UDTS;
        case 25: return GET_VERSION_COLUMNS;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<MetaDataOperation>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static final com.google.protobuf.Internal.EnumLiteMap<
        MetaDataOperation> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<MetaDataOperation>() {
            public MetaDataOperation findValueByNumber(int number) {
              return MetaDataOperation.valueOf(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      return getDescriptor().getValues().get(index);
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return org.apache.calcite.avatica.proto.Common.getDescriptor().getEnumTypes().get(3);
    }

    private static final MetaDataOperation[] VALUES = values();

    public static MetaDataOperation valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int index;
    private final int value;

    private MetaDataOperation(int index, int value) {
      this.index = index;
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:MetaDataOperation)
  }

  /**
   * Protobuf enum {@code StateType}
   */
  public enum StateType
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <code>SQL = 0;</code>
     */
    SQL(0, 0),
    /**
     * <code>METADATA = 1;</code>
     */
    METADATA(1, 1),
    UNRECOGNIZED(-1, -1),
    ;

    /**
     * <code>SQL = 0;</code>
     */
    public static final int SQL_VALUE = 0;
    /**
     * <code>METADATA = 1;</code>
     */
    public static final int METADATA_VALUE = 1;


    public final int getNumber() {
      if (index == -1) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    public static StateType valueOf(int value) {
      switch (value) {
        case 0: return SQL;
        case 1: return METADATA;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<StateType>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static final com.google.protobuf.Internal.EnumLiteMap<
        StateType> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<StateType>() {
            public StateType findValueByNumber(int number) {
              return StateType.valueOf(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      return getDescriptor().getValues().get(index);
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return org.apache.calcite.avatica.proto.Common.getDescriptor().getEnumTypes().get(4);
    }

    private static final StateType[] VALUES = values();

    public static StateType valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int index;
    private final int value;

    private StateType(int index, int value) {
      this.index = index;
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:StateType)
  }

  public interface ConnectionPropertiesOrBuilder extends
      // @@protoc_insertion_point(interface_extends:ConnectionProperties)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>optional bool is_dirty = 1;</code>
     */
    boolean getIsDirty();

    /**
     * <code>optional bool auto_commit = 2;</code>
     */
    boolean getAutoCommit();

    /**
     * <code>optional bool has_auto_commit = 7;</code>
     *
     * <pre>
     * field is a Boolean, need to discern null and default value
     * </pre>
     */
    boolean getHasAutoCommit();

    /**
     * <code>optional bool read_only = 3;</code>
     */
    boolean getReadOnly();

    /**
     * <code>optional bool has_read_only = 8;</code>
     *
     * <pre>
     * field is a Boolean, need to discern null and default value
     * </pre>
     */
    boolean getHasReadOnly();

    /**
     * <code>optional uint32 transaction_isolation = 4;</code>
     */
    int getTransactionIsolation();

    /**
     * <code>optional string catalog = 5;</code>
     */
    java.lang.String getCatalog();
    /**
     * <code>optional string catalog = 5;</code>
     */
    com.google.protobuf.ByteString
        getCatalogBytes();

    /**
     * <code>optional string schema = 6;</code>
     */
    java.lang.String getSchema();
    /**
     * <code>optional string schema = 6;</code>
     */
    com.google.protobuf.ByteString
        getSchemaBytes();
  }
  /**
   * Protobuf type {@code ConnectionProperties}
   *
   * <pre>
   * Details about a connection
   * </pre>
   */
  public  static final class ConnectionProperties extends
      com.google.protobuf.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:ConnectionProperties)
      ConnectionPropertiesOrBuilder {
    // Use ConnectionProperties.newBuilder() to construct.
    private ConnectionProperties(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
    }
    private ConnectionProperties() {
      isDirty_ = false;
      autoCommit_ = false;
      hasAutoCommit_ = false;
      readOnly_ = false;
      hasReadOnly_ = false;
      transactionIsolation_ = 0;
      catalog_ = "";
      schema_ = "";
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return com.google.protobuf.UnknownFieldSet.getDefaultInstance();
    }
    private ConnectionProperties(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry) {
      this();
      int mutable_bitField0_ = 0;
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!input.skipField(tag)) {
                done = true;
              }
              break;
            }
            case 8: {

              isDirty_ = input.readBool();
              break;
            }
            case 16: {

              autoCommit_ = input.readBool();
              break;
            }
            case 24: {

              readOnly_ = input.readBool();
              break;
            }
            case 32: {

              transactionIsolation_ = input.readUInt32();
              break;
            }
            case 42: {
              String s = input.readStringRequireUtf8();

              catalog_ = s;
              break;
            }
            case 50: {
              String s = input.readStringRequireUtf8();

              schema_ = s;
              break;
            }
            case 56: {

              hasAutoCommit_ = input.readBool();
              break;
            }
            case 64: {

              hasReadOnly_ = input.readBool();
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw new RuntimeException(e.setUnfinishedMessage(this));
      } catch (java.io.IOException e) {
        throw new RuntimeException(
            new com.google.protobuf.InvalidProtocolBufferException(
                e.getMessage()).setUnfinishedMessage(this));
      } finally {
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.calcite.avatica.proto.Common.internal_static_ConnectionProperties_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.calcite.avatica.proto.Common.internal_static_ConnectionProperties_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.calcite.avatica.proto.Common.ConnectionProperties.class, org.apache.calcite.avatica.proto.Common.ConnectionProperties.Builder.class);
    }

    public static final int IS_DIRTY_FIELD_NUMBER = 1;
    private boolean isDirty_;
    /**
     * <code>optional bool is_dirty = 1;</code>
     */
    public boolean getIsDirty() {
      return isDirty_;
    }

    public static final int AUTO_COMMIT_FIELD_NUMBER = 2;
    private boolean autoCommit_;
    /**
     * <code>optional bool auto_commit = 2;</code>
     */
    public boolean getAutoCommit() {
      return autoCommit_;
    }

    public static final int HAS_AUTO_COMMIT_FIELD_NUMBER = 7;
    private boolean hasAutoCommit_;
    /**
     * <code>optional bool has_auto_commit = 7;</code>
     *
     * <pre>
     * field is a Boolean, need to discern null and default value
     * </pre>
     */
    public boolean getHasAutoCommit() {
      return hasAutoCommit_;
    }

    public static final int READ_ONLY_FIELD_NUMBER = 3;
    private boolean readOnly_;
    /**
     * <code>optional bool read_only = 3;</code>
     */
    public boolean getReadOnly() {
      return readOnly_;
    }

    public static final int HAS_READ_ONLY_FIELD_NUMBER = 8;
    private boolean hasReadOnly_;
    /**
     * <code>optional bool has_read_only = 8;</code>
     *
     * <pre>
     * field is a Boolean, need to discern null and default value
     * </pre>
     */
    public boolean getHasReadOnly() {
      return hasReadOnly_;
    }

    public static final int TRANSACTION_ISOLATION_FIELD_NUMBER = 4;
    private int transactionIsolation_;
    /**
     * <code>optional uint32 transaction_isolation = 4;</code>
     */
    public int getTransactionIsolation() {
      return transactionIsolation_;
    }

    public static final int CATALOG_FIELD_NUMBER = 5;
    private volatile java.lang.Object catalog_;
    /**
     * <code>optional string catalog = 5;</code>
     */
    public java.lang.String getCatalog() {
      java.lang.Object ref = catalog_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        catalog_ = s;
        return s;
      }
    }
    /**
     * <code>optional string catalog = 5;</code>
     */
    public com.google.protobuf.ByteString
        getCatalogBytes() {
      java.lang.Object ref = catalog_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        catalog_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int SCHEMA_FIELD_NUMBER = 6;
    private volatile java.lang.Object schema_;
    /**
     * <code>optional string schema = 6;</code>
     */
    public java.lang.String getSchema() {
      java.lang.Object ref = schema_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        schema_ = s;
        return s;
      }
    }
    /**
     * <code>optional string schema = 6;</code>
     */
    public com.google.protobuf.ByteString
        getSchemaBytes() {
      java.lang.Object ref = schema_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        schema_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (isDirty_ != false) {
        output.writeBool(1, isDirty_);
      }
      if (autoCommit_ != false) {
        output.writeBool(2, autoCommit_);
      }
      if (readOnly_ != false) {
        output.writeBool(3, readOnly_);
      }
      if (transactionIsolation_ != 0) {
        output.writeUInt32(4, transactionIsolation_);
      }
      if (!getCatalogBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessage.writeString(output, 5, catalog_);
      }
      if (!getSchemaBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessage.writeString(output, 6, schema_);
      }
      if (hasAutoCommit_ != false) {
        output.writeBool(7, hasAutoCommit_);
      }
      if (hasReadOnly_ != false) {
        output.writeBool(8, hasReadOnly_);
      }
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (isDirty_ != false) {
        size += com.google.protobuf.CodedOutputStream
          .computeBoolSize(1, isDirty_);
      }
      if (autoCommit_ != false) {
        size += com.google.protobuf.CodedOutputStream
          .computeBoolSize(2, autoCommit_);
      }
      if (readOnly_ != false) {
        size += com.google.protobuf.CodedOutputStream
          .computeBoolSize(3, readOnly_);
      }
      if (transactionIsolation_ != 0) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt32Size(4, transactionIsolation_);
      }
      if (!getCatalogBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessage.computeStringSize(5, catalog_);
      }
      if (!getSchemaBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessage.computeStringSize(6, schema_);
      }
      if (hasAutoCommit_ != false) {
        size += com.google.protobuf.CodedOutputStream
          .computeBoolSize(7, hasAutoCommit_);
      }
      if (hasReadOnly_ != false) {
        size += com.google.protobuf.CodedOutputStream
          .computeBoolSize(8, hasReadOnly_);
      }
      memoizedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    public static org.apache.calcite.avatica.proto.Common.ConnectionProperties parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.calcite.avatica.proto.Common.ConnectionProperties parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.calcite.avatica.proto.Common.ConnectionProperties parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.calcite.avatica.proto.Common.ConnectionProperties parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.calcite.avatica.proto.Common.ConnectionProperties parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.calcite.avatica.proto.Common.ConnectionProperties parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static org.apache.calcite.avatica.proto.Common.ConnectionProperties parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static org.apache.calcite.avatica.proto.Common.ConnectionProperties parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static org.apache.calcite.avatica.proto.Common.ConnectionProperties parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.calcite.avatica.proto.Common.ConnectionProperties parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.apache.calcite.avatica.proto.Common.ConnectionProperties prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code ConnectionProperties}
     *
     * <pre>
     * Details about a connection
     * </pre>
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:ConnectionProperties)
        org.apache.calcite.avatica.proto.Common.ConnectionPropertiesOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.calcite.avatica.proto.Common.internal_static_ConnectionProperties_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.calcite.avatica.proto.Common.internal_static_ConnectionProperties_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.calcite.avatica.proto.Common.ConnectionProperties.class, org.apache.calcite.avatica.proto.Common.ConnectionProperties.Builder.class);
      }

      // Construct using org.apache.calcite.avatica.proto.Common.ConnectionProperties.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
        }
      }
      public Builder clear() {
        super.clear();
        isDirty_ = false;

        autoCommit_ = false;

        hasAutoCommit_ = false;

        readOnly_ = false;

        hasReadOnly_ = false;

        transactionIsolation_ = 0;

        catalog_ = "";

        schema_ = "";

        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.calcite.avatica.proto.Common.internal_static_ConnectionProperties_descriptor;
      }

      public org.apache.calcite.avatica.proto.Common.ConnectionProperties getDefaultInstanceForType() {
        return org.apache.calcite.avatica.proto.Common.ConnectionProperties.getDefaultInstance();
      }

      public org.apache.calcite.avatica.proto.Common.ConnectionProperties build() {
        org.apache.calcite.avatica.proto.Common.ConnectionProperties result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public org.apache.calcite.avatica.proto.Common.ConnectionProperties buildPartial() {
        org.apache.calcite.avatica.proto.Common.ConnectionProperties result = new org.apache.calcite.avatica.proto.Common.ConnectionProperties(this);
        result.isDirty_ = isDirty_;
        result.autoCommit_ = autoCommit_;
        result.hasAutoCommit_ = hasAutoCommit_;
        result.readOnly_ = readOnly_;
        result.hasReadOnly_ = hasReadOnly_;
        result.transactionIsolation_ = transactionIsolation_;
        result.catalog_ = catalog_;
        result.schema_ = schema_;
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.apache.calcite.avatica.proto.Common.ConnectionProperties) {
          return mergeFrom((org.apache.calcite.avatica.proto.Common.ConnectionProperties)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.calcite.avatica.proto.Common.ConnectionProperties other) {
        if (other == org.apache.calcite.avatica.proto.Common.ConnectionProperties.getDefaultInstance()) return this;
        if (other.getIsDirty() != false) {
          setIsDirty(other.getIsDirty());
        }
        if (other.getAutoCommit() != false) {
          setAutoCommit(other.getAutoCommit());
        }
        if (other.getHasAutoCommit() != false) {
          setHasAutoCommit(other.getHasAutoCommit());
        }
        if (other.getReadOnly() != false) {
          setReadOnly(other.getReadOnly());
        }
        if (other.getHasReadOnly() != false) {
          setHasReadOnly(other.getHasReadOnly());
        }
        if (other.getTransactionIsolation() != 0) {
          setTransactionIsolation(other.getTransactionIsolation());
        }
        if (!other.getCatalog().isEmpty()) {
          catalog_ = other.catalog_;
          onChanged();
        }
        if (!other.getSchema().isEmpty()) {
          schema_ = other.schema_;
          onChanged();
        }
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        org.apache.calcite.avatica.proto.Common.ConnectionProperties parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (org.apache.calcite.avatica.proto.Common.ConnectionProperties) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private boolean isDirty_ ;
      /**
       * <code>optional bool is_dirty = 1;</code>
       */
      public boolean getIsDirty() {
        return isDirty_;
      }
      /**
       * <code>optional bool is_dirty = 1;</code>
       */
      public Builder setIsDirty(boolean value) {
        
        isDirty_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional bool is_dirty = 1;</code>
       */
      public Builder clearIsDirty() {
        
        isDirty_ = false;
        onChanged();
        return this;
      }

      private boolean autoCommit_ ;
      /**
       * <code>optional bool auto_commit = 2;</code>
       */
      public boolean getAutoCommit() {
        return autoCommit_;
      }
      /**
       * <code>optional bool auto_commit = 2;</code>
       */
      public Builder setAutoCommit(boolean value) {
        
        autoCommit_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional bool auto_commit = 2;</code>
       */
      public Builder clearAutoCommit() {
        
        autoCommit_ = false;
        onChanged();
        return this;
      }

      private boolean hasAutoCommit_ ;
      /**
       * <code>optional bool has_auto_commit = 7;</code>
       *
       * <pre>
       * field is a Boolean, need to discern null and default value
       * </pre>
       */
      public boolean getHasAutoCommit() {
        return hasAutoCommit_;
      }
      /**
       * <code>optional bool has_auto_commit = 7;</code>
       *
       * <pre>
       * field is a Boolean, need to discern null and default value
       * </pre>
       */
      public Builder setHasAutoCommit(boolean value) {
        
        hasAutoCommit_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional bool has_auto_commit = 7;</code>
       *
       * <pre>
       * field is a Boolean, need to discern null and default value
       * </pre>
       */
      public Builder clearHasAutoCommit() {
        
        hasAutoCommit_ = false;
        onChanged();
        return this;
      }

      private boolean readOnly_ ;
      /**
       * <code>optional bool read_only = 3;</code>
       */
      public boolean getReadOnly() {
        return readOnly_;
      }
      /**
       * <code>optional bool read_only = 3;</code>
       */
      public Builder setReadOnly(boolean value) {
        
        readOnly_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional bool read_only = 3;</code>
       */
      public Builder clearReadOnly() {
        
        readOnly_ = false;
        onChanged();
        return this;
      }

      private boolean hasReadOnly_ ;
      /**
       * <code>optional bool has_read_only = 8;</code>
       *
       * <pre>
       * field is a Boolean, need to discern null and default value
       * </pre>
       */
      public boolean getHasReadOnly() {
        return hasReadOnly_;
      }
      /**
       * <code>optional bool has_read_only = 8;</code>
       *
       * <pre>
       * field is a Boolean, need to discern null and default value
       * </pre>
       */
      public Builder setHasReadOnly(boolean value) {
        
        hasReadOnly_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional bool has_read_only = 8;</code>
       *
       * <pre>
       * field is a Boolean, need to discern null and default value
       * </pre>
       */
      public Builder clearHasReadOnly() {
        
        hasReadOnly_ = false;
        onChanged();
        return this;
      }

      private int transactionIsolation_ ;
      /**
       * <code>optional uint32 transaction_isolation = 4;</code>
       */
      public int getTransactionIsolation() {
        return transactionIsolation_;
      }
      /**
       * <code>optional uint32 transaction_isolation = 4;</code>
       */
      public Builder setTransactionIsolation(int value) {
        
        transactionIsolation_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional uint32 transaction_isolation = 4;</code>
       */
      public Builder clearTransactionIsolation() {
        
        transactionIsolation_ = 0;
        onChanged();
        return this;
      }

      private java.lang.Object catalog_ = "";
      /**
       * <code>optional string catalog = 5;</code>
       */
      public java.lang.String getCatalog() {
        java.lang.Object ref = catalog_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          catalog_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>optional string catalog = 5;</code>
       */
      public com.google.protobuf.ByteString
          getCatalogBytes() {
        java.lang.Object ref = catalog_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          catalog_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>optional string catalog = 5;</code>
       */
      public Builder setCatalog(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        catalog_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional string catalog = 5;</code>
       */
      public Builder clearCatalog() {
        
        catalog_ = getDefaultInstance().getCatalog();
        onChanged();
        return this;
      }
      /**
       * <code>optional string catalog = 5;</code>
       */
      public Builder setCatalogBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        catalog_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object schema_ = "";
      /**
       * <code>optional string schema = 6;</code>
       */
      public java.lang.String getSchema() {
        java.lang.Object ref = schema_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          schema_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>optional string schema = 6;</code>
       */
      public com.google.protobuf.ByteString
          getSchemaBytes() {
        java.lang.Object ref = schema_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          schema_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>optional string schema = 6;</code>
       */
      public Builder setSchema(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        schema_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional string schema = 6;</code>
       */
      public Builder clearSchema() {
        
        schema_ = getDefaultInstance().getSchema();
        onChanged();
        return this;
      }
      /**
       * <code>optional string schema = 6;</code>
       */
      public Builder setSchemaBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        schema_ = value;
        onChanged();
        return this;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return this;
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return this;
      }


      // @@protoc_insertion_point(builder_scope:ConnectionProperties)
    }

    // @@protoc_insertion_point(class_scope:ConnectionProperties)
    private static final org.apache.calcite.avatica.proto.Common.ConnectionProperties DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.apache.calcite.avatica.proto.Common.ConnectionProperties();
    }

    public static org.apache.calcite.avatica.proto.Common.ConnectionProperties getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ConnectionProperties>
        PARSER = new com.google.protobuf.AbstractParser<ConnectionProperties>() {
      public ConnectionProperties parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        try {
          return new ConnectionProperties(input, extensionRegistry);
        } catch (RuntimeException e) {
          if (e.getCause() instanceof
              com.google.protobuf.InvalidProtocolBufferException) {
            throw (com.google.protobuf.InvalidProtocolBufferException)
                e.getCause();
          }
          throw e;
        }
      }
    };

    public static com.google.protobuf.Parser<ConnectionProperties> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ConnectionProperties> getParserForType() {
      return PARSER;
    }

    public org.apache.calcite.avatica.proto.Common.ConnectionProperties getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface StatementHandleOrBuilder extends
      // @@protoc_insertion_point(interface_extends:StatementHandle)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>optional string connection_id = 1;</code>
     */
    java.lang.String getConnectionId();
    /**
     * <code>optional string connection_id = 1;</code>
     */
    com.google.protobuf.ByteString
        getConnectionIdBytes();

    /**
     * <code>optional uint32 id = 2;</code>
     */
    int getId();

    /**
     * <code>optional .Signature signature = 3;</code>
     */
    boolean hasSignature();
    /**
     * <code>optional .Signature signature = 3;</code>
     */
    org.apache.calcite.avatica.proto.Common.Signature getSignature();
    /**
     * <code>optional .Signature signature = 3;</code>
     */
    org.apache.calcite.avatica.proto.Common.SignatureOrBuilder getSignatureOrBuilder();
  }
  /**
   * Protobuf type {@code StatementHandle}
   *
   * <pre>
   * Statement handle
   * </pre>
   */
  public  static final class StatementHandle extends
      com.google.protobuf.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:StatementHandle)
      StatementHandleOrBuilder {
    // Use StatementHandle.newBuilder() to construct.
    private StatementHandle(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
    }
    private StatementHandle() {
      connectionId_ = "";
      id_ = 0;
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return com.google.protobuf.UnknownFieldSet.getDefaultInstance();
    }
    private StatementHandle(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry) {
      this();
      int mutable_bitField0_ = 0;
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!input.skipField(tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              String s = input.readStringRequireUtf8();

              connectionId_ = s;
              break;
            }
            case 16: {

              id_ = input.readUInt32();
              break;
            }
            case 26: {
              org.apache.calcite.avatica.proto.Common.Signature.Builder subBuilder = null;
              if (signature_ != null) {
                subBuilder = signature_.toBuilder();
              }
              signature_ = input.readMessage(org.apache.calcite.avatica.proto.Common.Signature.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(signature_);
                signature_ = subBuilder.buildPartial();
              }

              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw new RuntimeException(e.setUnfinishedMessage(this));
      } catch (java.io.IOException e) {
        throw new RuntimeException(
            new com.google.protobuf.InvalidProtocolBufferException(
                e.getMessage()).setUnfinishedMessage(this));
      } finally {
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.calcite.avatica.proto.Common.internal_static_StatementHandle_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.calcite.avatica.proto.Common.internal_static_StatementHandle_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.calcite.avatica.proto.Common.StatementHandle.class, org.apache.calcite.avatica.proto.Common.StatementHandle.Builder.class);
    }

    public static final int CONNECTION_ID_FIELD_NUMBER = 1;
    private volatile java.lang.Object connectionId_;
    /**
     * <code>optional string connection_id = 1;</code>
     */
    public java.lang.String getConnectionId() {
      java.lang.Object ref = connectionId_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        connectionId_ = s;
        return s;
      }
    }
    /**
     * <code>optional string connection_id = 1;</code>
     */
    public com.google.protobuf.ByteString
        getConnectionIdBytes() {
      java.lang.Object ref = connectionId_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        connectionId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int ID_FIELD_NUMBER = 2;
    private int id_;
    /**
     * <code>optional uint32 id = 2;</code>
     */
    public int getId() {
      return id_;
    }

    public static final int SIGNATURE_FIELD_NUMBER = 3;
    private org.apache.calcite.avatica.proto.Common.Signature signature_;
    /**
     * <code>optional .Signature signature = 3;</code>
     */
    public boolean hasSignature() {
      return signature_ != null;
    }
    /**
     * <code>optional .Signature signature = 3;</code>
     */
    public org.apache.calcite.avatica.proto.Common.Signature getSignature() {
      return signature_ == null ? org.apache.calcite.avatica.proto.Common.Signature.getDefaultInstance() : signature_;
    }
    /**
     * <code>optional .Signature signature = 3;</code>
     */
    public org.apache.calcite.avatica.proto.Common.SignatureOrBuilder getSignatureOrBuilder() {
      return getSignature();
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (!getConnectionIdBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessage.writeString(output, 1, connectionId_);
      }
      if (id_ != 0) {
        output.writeUInt32(2, id_);
      }
      if (signature_ != null) {
        output.writeMessage(3, getSignature());
      }
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!getConnectionIdBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessage.computeStringSize(1, connectionId_);
      }
      if (id_ != 0) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt32Size(2, id_);
      }
      if (signature_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(3, getSignature());
      }
      memoizedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    public static org.apache.calcite.avatica.proto.Common.StatementHandle parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.calcite.avatica.proto.Common.StatementHandle parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.calcite.avatica.proto.Common.StatementHandle parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.calcite.avatica.proto.Common.StatementHandle parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.calcite.avatica.proto.Common.StatementHandle parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.calcite.avatica.proto.Common.StatementHandle parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static org.apache.calcite.avatica.proto.Common.StatementHandle parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static org.apache.calcite.avatica.proto.Common.StatementHandle parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static org.apache.calcite.avatica.proto.Common.StatementHandle parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.calcite.avatica.proto.Common.StatementHandle parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.apache.calcite.avatica.proto.Common.StatementHandle prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code StatementHandle}
     *
     * <pre>
     * Statement handle
     * </pre>
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:StatementHandle)
        org.apache.calcite.avatica.proto.Common.StatementHandleOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.calcite.avatica.proto.Common.internal_static_StatementHandle_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.calcite.avatica.proto.Common.internal_static_StatementHandle_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.calcite.avatica.proto.Common.StatementHandle.class, org.apache.calcite.avatica.proto.Common.StatementHandle.Builder.class);
      }

      // Construct using org.apache.calcite.avatica.proto.Common.StatementHandle.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
        }
      }
      public Builder clear() {
        super.clear();
        connectionId_ = "";

        id_ = 0;

        if (signatureBuilder_ == null) {
          signature_ = null;
        } else {
          signature_ = null;
          signatureBuilder_ = null;
        }
        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.calcite.avatica.proto.Common.internal_static_StatementHandle_descriptor;
      }

      public org.apache.calcite.avatica.proto.Common.StatementHandle getDefaultInstanceForType() {
        return org.apache.calcite.avatica.proto.Common.StatementHandle.getDefaultInstance();
      }

      public org.apache.calcite.avatica.proto.Common.StatementHandle build() {
        org.apache.calcite.avatica.proto.Common.StatementHandle result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public org.apache.calcite.avatica.proto.Common.StatementHandle buildPartial() {
        org.apache.calcite.avatica.proto.Common.StatementHandle result = new org.apache.calcite.avatica.proto.Common.StatementHandle(this);
        result.connectionId_ = connectionId_;
        result.id_ = id_;
        if (signatureBuilder_ == null) {
          result.signature_ = signature_;
        } else {
          result.signature_ = signatureBuilder_.build();
        }
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.apache.calcite.avatica.proto.Common.StatementHandle) {
          return mergeFrom((org.apache.calcite.avatica.proto.Common.StatementHandle)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.calcite.avatica.proto.Common.StatementHandle other) {
        if (other == org.apache.calcite.avatica.proto.Common.StatementHandle.getDefaultInstance()) return this;
        if (!other.getConnectionId().isEmpty()) {
          connectionId_ = other.connectionId_;
          onChanged();
        }
        if (other.getId() != 0) {
          setId(other.getId());
        }
        if (other.hasSignature()) {
          mergeSignature(other.getSignature());
        }
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        org.apache.calcite.avatica.proto.Common.StatementHandle parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (org.apache.calcite.avatica.proto.Common.StatementHandle) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private java.lang.Object connectionId_ = "";
      /**
       * <code>optional string connection_id = 1;</code>
       */
      public java.lang.String getConnectionId() {
        java.lang.Object ref = connectionId_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          connectionId_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>optional string connection_id = 1;</code>
       */
      public com.google.protobuf.ByteString
          getConnectionIdBytes() {
        java.lang.Object ref = connectionId_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          connectionId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>optional string connection_id = 1;</code>
       */
      public Builder setConnectionId(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        connectionId_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional string connection_id = 1;</code>
       */
      public Builder clearConnectionId() {
        
        connectionId_ = getDefaultInstance().getConnectionId();
        onChanged();
        return this;
      }
      /**
       * <code>optional string connection_id = 1;</code>
       */
      public Builder setConnectionIdBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        connectionId_ = value;
        onChanged();
        return this;
      }

      private int id_ ;
      /**
       * <code>optional uint32 id = 2;</code>
       */
      public int getId() {
        return id_;
      }
      /**
       * <code>optional uint32 id = 2;</code>
       */
      public Builder setId(int value) {
        
        id_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional uint32 id = 2;</code>
       */
      public Builder clearId() {
        
        id_ = 0;
        onChanged();
        return this;
      }

      private org.apache.calcite.avatica.proto.Common.Signature signature_ = null;
      private com.google.protobuf.SingleFieldBuilder<
          org.apache.calcite.avatica.proto.Common.Signature, org.apache.calcite.avatica.proto.Common.Signature.Builder, org.apache.calcite.avatica.proto.Common.SignatureOrBuilder> signatureBuilder_;
      /**
       * <code>optional .Signature signature = 3;</code>
       */
      public boolean hasSignature() {
        return signatureBuilder_ != null || signature_ != null;
      }
      /**
       * <code>optional .Signature signature = 3;</code>
       */
      public org.apache.calcite.avatica.proto.Common.Signature getSignature() {
        if (signatureBuilder_ == null) {
          return signature_ == null ? org.apache.calcite.avatica.proto.Common.Signature.getDefaultInstance() : signature_;
        } else {
          return signatureBuilder_.getMessage();
        }
      }
      /**
       * <code>optional .Signature signature = 3;</code>
       */
      public Builder setSignature(org.apache.calcite.avatica.proto.Common.Signature value) {
        if (signatureBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          signature_ = value;
          onChanged();
        } else {
          signatureBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <code>optional .Signature signature = 3;</code>
       */
      public Builder setSignature(
          org.apache.calcite.avatica.proto.Common.Signature.Builder builderForValue) {
        if (signatureBuilder_ == null) {
          signature_ = builderForValue.build();
          onChanged();
        } else {
          signatureBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <code>optional .Signature signature = 3;</code>
       */
      public Builder mergeSignature(org.apache.calcite.avatica.proto.Common.Signature value) {
        if (signatureBuilder_ == null) {
          if (signature_ != null) {
            signature_ =
              org.apache.calcite.avatica.proto.Common.Signature.newBuilder(signature_).mergeFrom(value).buildPartial();
          } else {
            signature_ = value;
          }
          onChanged();
        } else {
          signatureBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <code>optional .Signature signature = 3;</code>
       */
      public Builder clearSignature() {
        if (signatureBuilder_ == null) {
          signature_ = null;
          onChanged();
        } else {
          signature_ = null;
          signatureBuilder_ = null;
        }

        return this;
      }
      /**
       * <code>optional .Signature signature = 3;</code>
       */
      public org.apache.calcite.avatica.proto.Common.Signature.Builder getSignatureBuilder() {
        
        onChanged();
        return getSignatureFieldBuilder().getBuilder();
      }
      /**
       * <code>optional .Signature signature = 3;</code>
       */
      public org.apache.calcite.avatica.proto.Common.SignatureOrBuilder getSignatureOrBuilder() {
        if (signatureBuilder_ != null) {
          return signatureBuilder_.getMessageOrBuilder();
        } else {
          return signature_ == null ?
              org.apache.calcite.avatica.proto.Common.Signature.getDefaultInstance() : signature_;
        }
      }
      /**
       * <code>optional .Signature signature = 3;</code>
       */
      private com.google.protobuf.SingleFieldBuilder<
          org.apache.calcite.avatica.proto.Common.Signature, org.apache.calcite.avatica.proto.Common.Signature.Builder, org.apache.calcite.avatica.proto.Common.SignatureOrBuilder> 
          getSignatureFieldBuilder() {
        if (signatureBuilder_ == null) {
          signatureBuilder_ = new com.google.protobuf.SingleFieldBuilder<
              org.apache.calcite.avatica.proto.Common.Signature, org.apache.calcite.avatica.proto.Common.Signature.Builder, org.apache.calcite.avatica.proto.Common.SignatureOrBuilder>(
                  getSignature(),
                  getParentForChildren(),
                  isClean());
          signature_ = null;
        }
        return signatureBuilder_;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return this;
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return this;
      }


      // @@protoc_insertion_point(builder_scope:StatementHandle)
    }

    // @@protoc_insertion_point(class_scope:StatementHandle)
    private static final org.apache.calcite.avatica.proto.Common.StatementHandle DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.apache.calcite.avatica.proto.Common.StatementHandle();
    }

    public static org.apache.calcite.avatica.proto.Common.StatementHandle getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<StatementHandle>
        PARSER = new com.google.protobuf.AbstractParser<StatementHandle>() {
      public StatementHandle parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        try {
          return new StatementHandle(input, extensionRegistry);
        } catch (RuntimeException e) {
          if (e.getCause() instanceof
              com.google.protobuf.InvalidProtocolBufferException) {
            throw (com.google.protobuf.InvalidProtocolBufferException)
                e.getCause();
          }
          throw e;
        }
      }
    };

    public static com.google.protobuf.Parser<StatementHandle> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<StatementHandle> getParserForType() {
      return PARSER;
    }

    public org.apache.calcite.avatica.proto.Common.StatementHandle getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface SignatureOrBuilder extends
      // @@protoc_insertion_point(interface_extends:Signature)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>repeated .ColumnMetaData columns = 1;</code>
     */
    java.util.List<org.apache.calcite.avatica.proto.Common.ColumnMetaData> 
        getColumnsList();
    /**
     * <code>repeated .ColumnMetaData columns = 1;</code>
     */
    org.apache.calcite.avatica.proto.Common.ColumnMetaData getColumns(int index);
    /**
     * <code>repeated .ColumnMetaData columns = 1;</code>
     */
    int getColumnsCount();
    /**
     * <code>repeated .ColumnMetaData columns = 1;</code>
     */
    java.util.List<? extends org.apache.calcite.avatica.proto.Common.ColumnMetaDataOrBuilder> 
        getColumnsOrBuilderList();
    /**
     * <code>repeated .ColumnMetaData columns = 1;</code>
     */
    org.apache.calcite.avatica.proto.Common.ColumnMetaDataOrBuilder getColumnsOrBuilder(
        int index);

    /**
     * <code>optional string sql = 2;</code>
     */
    java.lang.String getSql();
    /**
     * <code>optional string sql = 2;</code>
     */
    com.google.protobuf.ByteString
        getSqlBytes();

    /**
     * <code>repeated .AvaticaParameter parameters = 3;</code>
     */
    java.util.List<org.apache.calcite.avatica.proto.Common.AvaticaParameter> 
        getParametersList();
    /**
     * <code>repeated .AvaticaParameter parameters = 3;</code>
     */
    org.apache.calcite.avatica.proto.Common.AvaticaParameter getParameters(int index);
    /**
     * <code>repeated .AvaticaParameter parameters = 3;</code>
     */
    int getParametersCount();
    /**
     * <code>repeated .AvaticaParameter parameters = 3;</code>
     */
    java.util.List<? extends org.apache.calcite.avatica.proto.Common.AvaticaParameterOrBuilder> 
        getParametersOrBuilderList();
    /**
     * <code>repeated .AvaticaParameter parameters = 3;</code>
     */
    org.apache.calcite.avatica.proto.Common.AvaticaParameterOrBuilder getParametersOrBuilder(
        int index);

    /**
     * <code>optional .CursorFactory cursor_factory = 4;</code>
     */
    boolean hasCursorFactory();
    /**
     * <code>optional .CursorFactory cursor_factory = 4;</code>
     */
    org.apache.calcite.avatica.proto.Common.CursorFactory getCursorFactory();
    /**
     * <code>optional .CursorFactory cursor_factory = 4;</code>
     */
    org.apache.calcite.avatica.proto.Common.CursorFactoryOrBuilder getCursorFactoryOrBuilder();

    /**
     * <code>optional .StatementType statementType = 5;</code>
     */
    int getStatementTypeValue();
    /**
     * <code>optional .StatementType statementType = 5;</code>
     */
    org.apache.calcite.avatica.proto.Common.StatementType getStatementType();
  }
  /**
   * Protobuf type {@code Signature}
   *
   * <pre>
   * Results of preparing a statement
   * </pre>
   */
  public  static final class Signature extends
      com.google.protobuf.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:Signature)
      SignatureOrBuilder {
    // Use Signature.newBuilder() to construct.
    private Signature(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
    }
    private Signature() {
      columns_ = java.util.Collections.emptyList();
      sql_ = "";
      parameters_ = java.util.Collections.emptyList();
      statementType_ = 0;
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return com.google.protobuf.UnknownFieldSet.getDefaultInstance();
    }
    private Signature(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry) {
      this();
      int mutable_bitField0_ = 0;
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!input.skipField(tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              if (!((mutable_bitField0_ & 0x00000001) == 0x00000001)) {
                columns_ = new java.util.ArrayList<org.apache.calcite.avatica.proto.Common.ColumnMetaData>();
                mutable_bitField0_ |= 0x00000001;
              }
              columns_.add(input.readMessage(org.apache.calcite.avatica.proto.Common.ColumnMetaData.parser(), extensionRegistry));
              break;
            }
            case 18: {
              String s = input.readStringRequireUtf8();

              sql_ = s;
              break;
            }
            case 26: {
              if (!((mutable_bitField0_ & 0x00000004) == 0x00000004)) {
                parameters_ = new java.util.ArrayList<org.apache.calcite.avatica.proto.Common.AvaticaParameter>();
                mutable_bitField0_ |= 0x00000004;
              }
              parameters_.add(input.readMessage(org.apache.calcite.avatica.proto.Common.AvaticaParameter.parser(), extensionRegistry));
              break;
            }
            case 34: {
              org.apache.calcite.avatica.proto.Common.CursorFactory.Builder subBuilder = null;
              if (cursorFactory_ != null) {
                subBuilder = cursorFactory_.toBuilder();
              }
              cursorFactory_ = input.readMessage(org.apache.calcite.avatica.proto.Common.CursorFactory.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(cursorFactory_);
                cursorFactory_ = subBuilder.buildPartial();
              }

              break;
            }
            case 40: {
              int rawValue = input.readEnum();

              statementType_ = rawValue;
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw new RuntimeException(e.setUnfinishedMessage(this));
      } catch (java.io.IOException e) {
        throw new RuntimeException(
            new com.google.protobuf.InvalidProtocolBufferException(
                e.getMessage()).setUnfinishedMessage(this));
      } finally {
        if (((mutable_bitField0_ & 0x00000001) == 0x00000001)) {
          columns_ = java.util.Collections.unmodifiableList(columns_);
        }
        if (((mutable_bitField0_ & 0x00000004) == 0x00000004)) {
          parameters_ = java.util.Collections.unmodifiableList(parameters_);
        }
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.calcite.avatica.proto.Common.internal_static_Signature_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.calcite.avatica.proto.Common.internal_static_Signature_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.calcite.avatica.proto.Common.Signature.class, org.apache.calcite.avatica.proto.Common.Signature.Builder.class);
    }

    private int bitField0_;
    public static final int COLUMNS_FIELD_NUMBER = 1;
    private java.util.List<org.apache.calcite.avatica.proto.Common.ColumnMetaData> columns_;
    /**
     * <code>repeated .ColumnMetaData columns = 1;</code>
     */
    public java.util.List<org.apache.calcite.avatica.proto.Common.ColumnMetaData> getColumnsList() {
      return columns_;
    }
    /**
     * <code>repeated .ColumnMetaData columns = 1;</code>
     */
    public java.util.List<? extends org.apache.calcite.avatica.proto.Common.ColumnMetaDataOrBuilder> 
        getColumnsOrBuilderList() {
      return columns_;
    }
    /**
     * <code>repeated .ColumnMetaData columns = 1;</code>
     */
    public int getColumnsCount() {
      return columns_.size();
    }
    /**
     * <code>repeated .ColumnMetaData columns = 1;</code>
     */
    public org.apache.calcite.avatica.proto.Common.ColumnMetaData getColumns(int index) {
      return columns_.get(index);
    }
    /**
     * <code>repeated .ColumnMetaData columns = 1;</code>
     */
    public org.apache.calcite.avatica.proto.Common.ColumnMetaDataOrBuilder getColumnsOrBuilder(
        int index) {
      return columns_.get(index);
    }

    public static final int SQL_FIELD_NUMBER = 2;
    private volatile java.lang.Object sql_;
    /**
     * <code>optional string sql = 2;</code>
     */
    public java.lang.String getSql() {
      java.lang.Object ref = sql_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        sql_ = s;
        return s;
      }
    }
    /**
     * <code>optional string sql = 2;</code>
     */
    public com.google.protobuf.ByteString
        getSqlBytes() {
      java.lang.Object ref = sql_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        sql_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int PARAMETERS_FIELD_NUMBER = 3;
    private java.util.List<org.apache.calcite.avatica.proto.Common.AvaticaParameter> parameters_;
    /**
     * <code>repeated .AvaticaParameter parameters = 3;</code>
     */
    public java.util.List<org.apache.calcite.avatica.proto.Common.AvaticaParameter> getParametersList() {
      return parameters_;
    }
    /**
     * <code>repeated .AvaticaParameter parameters = 3;</code>
     */
    public java.util.List<? extends org.apache.calcite.avatica.proto.Common.AvaticaParameterOrBuilder> 
        getParametersOrBuilderList() {
      return parameters_;
    }
    /**
     * <code>repeated .AvaticaParameter parameters = 3;</code>
     */
    public int getParametersCount() {
      return parameters_.size();
    }
    /**
     * <code>repeated .AvaticaParameter parameters = 3;</code>
     */
    public org.apache.calcite.avatica.proto.Common.AvaticaParameter getParameters(int index) {
      return parameters_.get(index);
    }
    /**
     * <code>repeated .AvaticaParameter parameters = 3;</code>
     */
    public org.apache.calcite.avatica.proto.Common.AvaticaParameterOrBuilder getParametersOrBuilder(
        int index) {
      return parameters_.get(index);
    }

    public static final int CURSOR_FACTORY_FIELD_NUMBER = 4;
    private org.apache.calcite.avatica.proto.Common.CursorFactory cursorFactory_;
    /**
     * <code>optional .CursorFactory cursor_factory = 4;</code>
     */
    public boolean hasCursorFactory() {
      return cursorFactory_ != null;
    }
    /**
     * <code>optional .CursorFactory cursor_factory = 4;</code>
     */
    public org.apache.calcite.avatica.proto.Common.CursorFactory getCursorFactory() {
      return cursorFactory_ == null ? org.apache.calcite.avatica.proto.Common.CursorFactory.getDefaultInstance() : cursorFactory_;
    }
    /**
     * <code>optional .CursorFactory cursor_factory = 4;</code>
     */
    public org.apache.calcite.avatica.proto.Common.CursorFactoryOrBuilder getCursorFactoryOrBuilder() {
      return getCursorFactory();
    }

    public static final int STATEMENTTYPE_FIELD_NUMBER = 5;
    private int statementType_;
    /**
     * <code>optional .StatementType statementType = 5;</code>
     */
    public int getStatementTypeValue() {
      return statementType_;
    }
    /**
     * <code>optional .StatementType statementType = 5;</code>
     */
    public org.apache.calcite.avatica.proto.Common.StatementType getStatementType() {
      org.apache.calcite.avatica.proto.Common.StatementType result = org.apache.calcite.avatica.proto.Common.StatementType.valueOf(statementType_);
      return result == null ? org.apache.calcite.avatica.proto.Common.StatementType.UNRECOGNIZED : result;
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      for (int i = 0; i < columns_.size(); i++) {
        output.writeMessage(1, columns_.get(i));
      }
      if (!getSqlBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessage.writeString(output, 2, sql_);
      }
      for (int i = 0; i < parameters_.size(); i++) {
        output.writeMessage(3, parameters_.get(i));
      }
      if (cursorFactory_ != null) {
        output.writeMessage(4, getCursorFactory());
      }
      if (statementType_ != org.apache.calcite.avatica.proto.Common.StatementType.SELECT.getNumber()) {
        output.writeEnum(5, statementType_);
      }
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < columns_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(1, columns_.get(i));
      }
      if (!getSqlBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessage.computeStringSize(2, sql_);
      }
      for (int i = 0; i < parameters_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(3, parameters_.get(i));
      }
      if (cursorFactory_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(4, getCursorFactory());
      }
      if (statementType_ != org.apache.calcite.avatica.proto.Common.StatementType.SELECT.getNumber()) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(5, statementType_);
      }
      memoizedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    public static org.apache.calcite.avatica.proto.Common.Signature parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.calcite.avatica.proto.Common.Signature parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.calcite.avatica.proto.Common.Signature parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.calcite.avatica.proto.Common.Signature parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.calcite.avatica.proto.Common.Signature parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.calcite.avatica.proto.Common.Signature parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static org.apache.calcite.avatica.proto.Common.Signature parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static org.apache.calcite.avatica.proto.Common.Signature parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static org.apache.calcite.avatica.proto.Common.Signature parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.calcite.avatica.proto.Common.Signature parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.apache.calcite.avatica.proto.Common.Signature prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code Signature}
     *
     * <pre>
     * Results of preparing a statement
     * </pre>
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:Signature)
        org.apache.calcite.avatica.proto.Common.SignatureOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.calcite.avatica.proto.Common.internal_static_Signature_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.calcite.avatica.proto.Common.internal_static_Signature_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.calcite.avatica.proto.Common.Signature.class, org.apache.calcite.avatica.proto.Common.Signature.Builder.class);
      }

      // Construct using org.apache.calcite.avatica.proto.Common.Signature.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
          getColumnsFieldBuilder();
          getParametersFieldBuilder();
        }
      }
      public Builder clear() {
        super.clear();
        if (columnsBuilder_ == null) {
          columns_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
        } else {
          columnsBuilder_.clear();
        }
        sql_ = "";

        if (parametersBuilder_ == null) {
          parameters_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000004);
        } else {
          parametersBuilder_.clear();
        }
        if (cursorFactoryBuilder_ == null) {
          cursorFactory_ = null;
        } else {
          cursorFactory_ = null;
          cursorFactoryBuilder_ = null;
        }
        statementType_ = 0;

        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.calcite.avatica.proto.Common.internal_static_Signature_descriptor;
      }

      public org.apache.calcite.avatica.proto.Common.Signature getDefaultInstanceForType() {
        return org.apache.calcite.avatica.proto.Common.Signature.getDefaultInstance();
      }

      public org.apache.calcite.avatica.proto.Common.Signature build() {
        org.apache.calcite.avatica.proto.Common.Signature result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public org.apache.calcite.avatica.proto.Common.Signature buildPartial() {
        org.apache.calcite.avatica.proto.Common.Signature result = new org.apache.calcite.avatica.proto.Common.Signature(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (columnsBuilder_ == null) {
          if (((bitField0_ & 0x00000001) == 0x00000001)) {
            columns_ = java.util.Collections.unmodifiableList(columns_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.columns_ = columns_;
        } else {
          result.columns_ = columnsBuilder_.build();
        }
        result.sql_ = sql_;
        if (parametersBuilder_ == null) {
          if (((bitField0_ & 0x00000004) == 0x00000004)) {
            parameters_ = java.util.Collections.unmodifiableList(parameters_);
            bitField0_ = (bitField0_ & ~0x00000004);
          }
          result.parameters_ = parameters_;
        } else {
          result.parameters_ = parametersBuilder_.build();
        }
        if (cursorFactoryBuilder_ == null) {
          result.cursorFactory_ = cursorFactory_;
        } else {
          result.cursorFactory_ = cursorFactoryBuilder_.build();
        }
        result.statementType_ = statementType_;
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.apache.calcite.avatica.proto.Common.Signature) {
          return mergeFrom((org.apache.calcite.avatica.proto.Common.Signature)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.calcite.avatica.proto.Common.Signature other) {
        if (other == org.apache.calcite.avatica.proto.Common.Signature.getDefaultInstance()) return this;
        if (columnsBuilder_ == null) {
          if (!other.columns_.isEmpty()) {
            if (columns_.isEmpty()) {
              columns_ = other.columns_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureColumnsIsMutable();
              columns_.addAll(other.columns_);
            }
            onChanged();
          }
        } else {
          if (!other.columns_.isEmpty()) {
            if (columnsBuilder_.isEmpty()) {
              columnsBuilder_.dispose();
              columnsBuilder_ = null;
              columns_ = other.columns_;
              bitField0_ = (bitField0_ & ~0x00000001);
              columnsBuilder_ = 
                com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders ?
                   getColumnsFieldBuilder() : null;
            } else {
              columnsBuilder_.addAllMessages(other.columns_);
            }
          }
        }
        if (!other.getSql().isEmpty()) {
          sql_ = other.sql_;
          onChanged();
        }
        if (parametersBuilder_ == null) {
          if (!other.parameters_.isEmpty()) {
            if (parameters_.isEmpty()) {
              parameters_ = other.parameters_;
              bitField0_ = (bitField0_ & ~0x00000004);
            } else {
              ensureParametersIsMutable();
              parameters_.addAll(other.parameters_);
            }
            onChanged();
          }
        } else {
          if (!other.parameters_.isEmpty()) {
            if (parametersBuilder_.isEmpty()) {
              parametersBuilder_.dispose();
              parametersBuilder_ = null;
              parameters_ = other.parameters_;
              bitField0_ = (bitField0_ & ~0x00000004);
              parametersBuilder_ = 
                com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders ?
                   getParametersFieldBuilder() : null;
            } else {
              parametersBuilder_.addAllMessages(other.parameters_);
            }
          }
        }
        if (other.hasCursorFactory()) {
          mergeCursorFactory(other.getCursorFactory());
        }
        if (other.statementType_ != 0) {
          setStatementTypeValue(other.getStatementTypeValue());
        }
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        org.apache.calcite.avatica.proto.Common.Signature parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (org.apache.calcite.avatica.proto.Common.Signature) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private java.util.List<org.apache.calcite.avatica.proto.Common.ColumnMetaData> columns_ =
        java.util.Collections.emptyList();
      private void ensureColumnsIsMutable() {
        if (!((bitField0_ & 0x00000001) == 0x00000001)) {
          columns_ = new java.util.ArrayList<org.apache.calcite.avatica.proto.Common.ColumnMetaData>(columns_);
          bitField0_ |= 0x00000001;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilder<
          org.apache.calcite.avatica.proto.Common.ColumnMetaData, org.apache.calcite.avatica.proto.Common.ColumnMetaData.Builder, org.apache.calcite.avatica.proto.Common.ColumnMetaDataOrBuilder> columnsBuilder_;

      /**
       * <code>repeated .ColumnMetaData columns = 1;</code>
       */
      public java.util.List<org.apache.calcite.avatica.proto.Common.ColumnMetaData> getColumnsList() {
        if (columnsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(columns_);
        } else {
          return columnsBuilder_.getMessageList();
        }
      }
      /**
       * <code>repeated .ColumnMetaData columns = 1;</code>
       */
      public int getColumnsCount() {
        if (columnsBuilder_ == null) {
          return columns_.size();
        } else {
          return columnsBuilder_.getCount();
        }
      }
      /**
       * <code>repeated .ColumnMetaData columns = 1;</code>
       */
      public org.apache.calcite.avatica.proto.Common.ColumnMetaData getColumns(int index) {
        if (columnsBuilder_ == null) {
          return columns_.get(index);
        } else {
          return columnsBuilder_.getMessage(index);
        }
      }
      /**
       * <code>repeated .ColumnMetaData columns = 1;</code>
       */
      public Builder setColumns(
          int index, org.apache.calcite.avatica.proto.Common.ColumnMetaData value) {
        if (columnsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureColumnsIsMutable();
          columns_.set(index, value);
          onChanged();
        } else {
          columnsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .ColumnMetaData columns = 1;</code>
       */
      public Builder setColumns(
          int index, org.apache.calcite.avatica.proto.Common.ColumnMetaData.Builder builderForValue) {
        if (columnsBuilder_ == null) {
          ensureColumnsIsMutable();
          columns_.set(index, builderForValue.build());
          onChanged();
        } else {
          columnsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .ColumnMetaData columns = 1;</code>
       */
      public Builder addColumns(org.apache.calcite.avatica.proto.Common.ColumnMetaData value) {
        if (columnsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureColumnsIsMutable();
          columns_.add(value);
          onChanged();
        } else {
          columnsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <code>repeated .ColumnMetaData columns = 1;</code>
       */
      public Builder addColumns(
          int index, org.apache.calcite.avatica.proto.Common.ColumnMetaData value) {
        if (columnsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureColumnsIsMutable();
          columns_.add(index, value);
          onChanged();
        } else {
          columnsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .ColumnMetaData columns = 1;</code>
       */
      public Builder addColumns(
          org.apache.calcite.avatica.proto.Common.ColumnMetaData.Builder builderForValue) {
        if (columnsBuilder_ == null) {
          ensureColumnsIsMutable();
          columns_.add(builderForValue.build());
          onChanged();
        } else {
          columnsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .ColumnMetaData columns = 1;</code>
       */
      public Builder addColumns(
          int index, org.apache.calcite.avatica.proto.Common.ColumnMetaData.Builder builderForValue) {
        if (columnsBuilder_ == null) {
          ensureColumnsIsMutable();
          columns_.add(index, builderForValue.build());
          onChanged();
        } else {
          columnsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .ColumnMetaData columns = 1;</code>
       */
      public Builder addAllColumns(
          java.lang.Iterable<? extends org.apache.calcite.avatica.proto.Common.ColumnMetaData> values) {
        if (columnsBuilder_ == null) {
          ensureColumnsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, columns_);
          onChanged();
        } else {
          columnsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <code>repeated .ColumnMetaData columns = 1;</code>
       */
      public Builder clearColumns() {
        if (columnsBuilder_ == null) {
          columns_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          columnsBuilder_.clear();
        }
        return this;
      }
      /**
       * <code>repeated .ColumnMetaData columns = 1;</code>
       */
      public Builder removeColumns(int index) {
        if (columnsBuilder_ == null) {
          ensureColumnsIsMutable();
          columns_.remove(index);
          onChanged();
        } else {
          columnsBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <code>repeated .ColumnMetaData columns = 1;</code>
       */
      public org.apache.calcite.avatica.proto.Common.ColumnMetaData.Builder getColumnsBuilder(
          int index) {
        return getColumnsFieldBuilder().getBuilder(index);
      }
      /**
       * <code>repeated .ColumnMetaData columns = 1;</code>
       */
      public org.apache.calcite.avatica.proto.Common.ColumnMetaDataOrBuilder getColumnsOrBuilder(
          int index) {
        if (columnsBuilder_ == null) {
          return columns_.get(index);  } else {
          return columnsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <code>repeated .ColumnMetaData columns = 1;</code>
       */
      public java.util.List<? extends org.apache.calcite.avatica.proto.Common.ColumnMetaDataOrBuilder> 
           getColumnsOrBuilderList() {
        if (columnsBuilder_ != null) {
          return columnsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(columns_);
        }
      }
      /**
       * <code>repeated .ColumnMetaData columns = 1;</code>
       */
      public org.apache.calcite.avatica.proto.Common.ColumnMetaData.Builder addColumnsBuilder() {
        return getColumnsFieldBuilder().addBuilder(
            org.apache.calcite.avatica.proto.Common.ColumnMetaData.getDefaultInstance());
      }
      /**
       * <code>repeated .ColumnMetaData columns = 1;</code>
       */
      public org.apache.calcite.avatica.proto.Common.ColumnMetaData.Builder addColumnsBuilder(
          int index) {
        return getColumnsFieldBuilder().addBuilder(
            index, org.apache.calcite.avatica.proto.Common.ColumnMetaData.getDefaultInstance());
      }
      /**
       * <code>repeated .ColumnMetaData columns = 1;</code>
       */
      public java.util.List<org.apache.calcite.avatica.proto.Common.ColumnMetaData.Builder> 
           getColumnsBuilderList() {
        return getColumnsFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilder<
          org.apache.calcite.avatica.proto.Common.ColumnMetaData, org.apache.calcite.avatica.proto.Common.ColumnMetaData.Builder, org.apache.calcite.avatica.proto.Common.ColumnMetaDataOrBuilder> 
          getColumnsFieldBuilder() {
        if (columnsBuilder_ == null) {
          columnsBuilder_ = new com.google.protobuf.RepeatedFieldBuilder<
              org.apache.calcite.avatica.proto.Common.ColumnMetaData, org.apache.calcite.avatica.proto.Common.ColumnMetaData.Builder, org.apache.calcite.avatica.proto.Common.ColumnMetaDataOrBuilder>(
                  columns_,
                  ((bitField0_ & 0x00000001) == 0x00000001),
                  getParentForChildren(),
                  isClean());
          columns_ = null;
        }
        return columnsBuilder_;
      }

      private java.lang.Object sql_ = "";
      /**
       * <code>optional string sql = 2;</code>
       */
      public java.lang.String getSql() {
        java.lang.Object ref = sql_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          sql_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>optional string sql = 2;</code>
       */
      public com.google.protobuf.ByteString
          getSqlBytes() {
        java.lang.Object ref = sql_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          sql_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>optional string sql = 2;</code>
       */
      public Builder setSql(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        sql_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional string sql = 2;</code>
       */
      public Builder clearSql() {
        
        sql_ = getDefaultInstance().getSql();
        onChanged();
        return this;
      }
      /**
       * <code>optional string sql = 2;</code>
       */
      public Builder setSqlBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        sql_ = value;
        onChanged();
        return this;
      }

      private java.util.List<org.apache.calcite.avatica.proto.Common.AvaticaParameter> parameters_ =
        java.util.Collections.emptyList();
      private void ensureParametersIsMutable() {
        if (!((bitField0_ & 0x00000004) == 0x00000004)) {
          parameters_ = new java.util.ArrayList<org.apache.calcite.avatica.proto.Common.AvaticaParameter>(parameters_);
          bitField0_ |= 0x00000004;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilder<
          org.apache.calcite.avatica.proto.Common.AvaticaParameter, org.apache.calcite.avatica.proto.Common.AvaticaParameter.Builder, org.apache.calcite.avatica.proto.Common.AvaticaParameterOrBuilder> parametersBuilder_;

      /**
       * <code>repeated .AvaticaParameter parameters = 3;</code>
       */
      public java.util.List<org.apache.calcite.avatica.proto.Common.AvaticaParameter> getParametersList() {
        if (parametersBuilder_ == null) {
          return java.util.Collections.unmodifiableList(parameters_);
        } else {
          return parametersBuilder_.getMessageList();
        }
      }
      /**
       * <code>repeated .AvaticaParameter parameters = 3;</code>
       */
      public int getParametersCount() {
        if (parametersBuilder_ == null) {
          return parameters_.size();
        } else {
          return parametersBuilder_.getCount();
        }
      }
      /**
       * <code>repeated .AvaticaParameter parameters = 3;</code>
       */
      public org.apache.calcite.avatica.proto.Common.AvaticaParameter getParameters(int index) {
        if (parametersBuilder_ == null) {
          return parameters_.get(index);
        } else {
          return parametersBuilder_.getMessage(index);
        }
      }
      /**
       * <code>repeated .AvaticaParameter parameters = 3;</code>
       */
      public Builder setParameters(
          int index, org.apache.calcite.avatica.proto.Common.AvaticaParameter value) {
        if (parametersBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureParametersIsMutable();
          parameters_.set(index, value);
          onChanged();
        } else {
          parametersBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .AvaticaParameter parameters = 3;</code>
       */
      public Builder setParameters(
          int index, org.apache.calcite.avatica.proto.Common.AvaticaParameter.Builder builderForValue) {
        if (parametersBuilder_ == null) {
          ensureParametersIsMutable();
          parameters_.set(index, builderForValue.build());
          onChanged();
        } else {
          parametersBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .AvaticaParameter parameters = 3;</code>
       */
      public Builder addParameters(org.apache.calcite.avatica.proto.Common.AvaticaParameter value) {
        if (parametersBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureParametersIsMutable();
          parameters_.add(value);
          onChanged();
        } else {
          parametersBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <code>repeated .AvaticaParameter parameters = 3;</code>
       */
      public Builder addParameters(
          int index, org.apache.calcite.avatica.proto.Common.AvaticaParameter value) {
        if (parametersBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureParametersIsMutable();
          parameters_.add(index, value);
          onChanged();
        } else {
          parametersBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .AvaticaParameter parameters = 3;</code>
       */
      public Builder addParameters(
          org.apache.calcite.avatica.proto.Common.AvaticaParameter.Builder builderForValue) {
        if (parametersBuilder_ == null) {
          ensureParametersIsMutable();
          parameters_.add(builderForValue.build());
          onChanged();
        } else {
          parametersBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .AvaticaParameter parameters = 3;</code>
       */
      public Builder addParameters(
          int index, org.apache.calcite.avatica.proto.Common.AvaticaParameter.Builder builderForValue) {
        if (parametersBuilder_ == null) {
          ensureParametersIsMutable();
          parameters_.add(index, builderForValue.build());
          onChanged();
        } else {
          parametersBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .AvaticaParameter parameters = 3;</code>
       */
      public Builder addAllParameters(
          java.lang.Iterable<? extends org.apache.calcite.avatica.proto.Common.AvaticaParameter> values) {
        if (parametersBuilder_ == null) {
          ensureParametersIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, parameters_);
          onChanged();
        } else {
          parametersBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <code>repeated .AvaticaParameter parameters = 3;</code>
       */
      public Builder clearParameters() {
        if (parametersBuilder_ == null) {
          parameters_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000004);
          onChanged();
        } else {
          parametersBuilder_.clear();
        }
        return this;
      }
      /**
       * <code>repeated .AvaticaParameter parameters = 3;</code>
       */
      public Builder removeParameters(int index) {
        if (parametersBuilder_ == null) {
          ensureParametersIsMutable();
          parameters_.remove(index);
          onChanged();
        } else {
          parametersBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <code>repeated .AvaticaParameter parameters = 3;</code>
       */
      public org.apache.calcite.avatica.proto.Common.AvaticaParameter.Builder getParametersBuilder(
          int index) {
        return getParametersFieldBuilder().getBuilder(index);
      }
      /**
       * <code>repeated .AvaticaParameter parameters = 3;</code>
       */
      public org.apache.calcite.avatica.proto.Common.AvaticaParameterOrBuilder getParametersOrBuilder(
          int index) {
        if (parametersBuilder_ == null) {
          return parameters_.get(index);  } else {
          return parametersBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <code>repeated .AvaticaParameter parameters = 3;</code>
       */
      public java.util.List<? extends org.apache.calcite.avatica.proto.Common.AvaticaParameterOrBuilder> 
           getParametersOrBuilderList() {
        if (parametersBuilder_ != null) {
          return parametersBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(parameters_);
        }
      }
      /**
       * <code>repeated .AvaticaParameter parameters = 3;</code>
       */
      public org.apache.calcite.avatica.proto.Common.AvaticaParameter.Builder addParametersBuilder() {
        return getParametersFieldBuilder().addBuilder(
            org.apache.calcite.avatica.proto.Common.AvaticaParameter.getDefaultInstance());
      }
      /**
       * <code>repeated .AvaticaParameter parameters = 3;</code>
       */
      public org.apache.calcite.avatica.proto.Common.AvaticaParameter.Builder addParametersBuilder(
          int index) {
        return getParametersFieldBuilder().addBuilder(
            index, org.apache.calcite.avatica.proto.Common.AvaticaParameter.getDefaultInstance());
      }
      /**
       * <code>repeated .AvaticaParameter parameters = 3;</code>
       */
      public java.util.List<org.apache.calcite.avatica.proto.Common.AvaticaParameter.Builder> 
           getParametersBuilderList() {
        return getParametersFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilder<
          org.apache.calcite.avatica.proto.Common.AvaticaParameter, org.apache.calcite.avatica.proto.Common.AvaticaParameter.Builder, org.apache.calcite.avatica.proto.Common.AvaticaParameterOrBuilder> 
          getParametersFieldBuilder() {
        if (parametersBuilder_ == null) {
          parametersBuilder_ = new com.google.protobuf.RepeatedFieldBuilder<
              org.apache.calcite.avatica.proto.Common.AvaticaParameter, org.apache.calcite.avatica.proto.Common.AvaticaParameter.Builder, org.apache.calcite.avatica.proto.Common.AvaticaParameterOrBuilder>(
                  parameters_,
                  ((bitField0_ & 0x00000004) == 0x00000004),
                  getParentForChildren(),
                  isClean());
          parameters_ = null;
        }
        return parametersBuilder_;
      }

      private org.apache.calcite.avatica.proto.Common.CursorFactory cursorFactory_ = null;
      private com.google.protobuf.SingleFieldBuilder<
          org.apache.calcite.avatica.proto.Common.CursorFactory, org.apache.calcite.avatica.proto.Common.CursorFactory.Builder, org.apache.calcite.avatica.proto.Common.CursorFactoryOrBuilder> cursorFactoryBuilder_;
      /**
       * <code>optional .CursorFactory cursor_factory = 4;</code>
       */
      public boolean hasCursorFactory() {
        return cursorFactoryBuilder_ != null || cursorFactory_ != null;
      }
      /**
       * <code>optional .CursorFactory cursor_factory = 4;</code>
       */
      public org.apache.calcite.avatica.proto.Common.CursorFactory getCursorFactory() {
        if (cursorFactoryBuilder_ == null) {
          return cursorFactory_ == null ? org.apache.calcite.avatica.proto.Common.CursorFactory.getDefaultInstance() : cursorFactory_;
        } else {
          return cursorFactoryBuilder_.getMessage();
        }
      }
      /**
       * <code>optional .CursorFactory cursor_factory = 4;</code>
       */
      public Builder setCursorFactory(org.apache.calcite.avatica.proto.Common.CursorFactory value) {
        if (cursorFactoryBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          cursorFactory_ = value;
          onChanged();
        } else {
          cursorFactoryBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <code>optional .CursorFactory cursor_factory = 4;</code>
       */
      public Builder setCursorFactory(
          org.apache.calcite.avatica.proto.Common.CursorFactory.Builder builderForValue) {
        if (cursorFactoryBuilder_ == null) {
          cursorFactory_ = builderForValue.build();
          onChanged();
        } else {
          cursorFactoryBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <code>optional .CursorFactory cursor_factory = 4;</code>
       */
      public Builder mergeCursorFactory(org.apache.calcite.avatica.proto.Common.CursorFactory value) {
        if (cursorFactoryBuilder_ == null) {
          if (cursorFactory_ != null) {
            cursorFactory_ =
              org.apache.calcite.avatica.proto.Common.CursorFactory.newBuilder(cursorFactory_).mergeFrom(value).buildPartial();
          } else {
            cursorFactory_ = value;
          }
          onChanged();
        } else {
          cursorFactoryBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <code>optional .CursorFactory cursor_factory = 4;</code>
       */
      public Builder clearCursorFactory() {
        if (cursorFactoryBuilder_ == null) {
          cursorFactory_ = null;
          onChanged();
        } else {
          cursorFactory_ = null;
          cursorFactoryBuilder_ = null;
        }

        return this;
      }
      /**
       * <code>optional .CursorFactory cursor_factory = 4;</code>
       */
      public org.apache.calcite.avatica.proto.Common.CursorFactory.Builder getCursorFactoryBuilder() {
        
        onChanged();
        return getCursorFactoryFieldBuilder().getBuilder();
      }
      /**
       * <code>optional .CursorFactory cursor_factory = 4;</code>
       */
      public org.apache.calcite.avatica.proto.Common.CursorFactoryOrBuilder getCursorFactoryOrBuilder() {
        if (cursorFactoryBuilder_ != null) {
          return cursorFactoryBuilder_.getMessageOrBuilder();
        } else {
          return cursorFactory_ == null ?
              org.apache.calcite.avatica.proto.Common.CursorFactory.getDefaultInstance() : cursorFactory_;
        }
      }
      /**
       * <code>optional .CursorFactory cursor_factory = 4;</code>
       */
      private com.google.protobuf.SingleFieldBuilder<
          org.apache.calcite.avatica.proto.Common.CursorFactory, org.apache.calcite.avatica.proto.Common.CursorFactory.Builder, org.apache.calcite.avatica.proto.Common.CursorFactoryOrBuilder> 
          getCursorFactoryFieldBuilder() {
        if (cursorFactoryBuilder_ == null) {
          cursorFactoryBuilder_ = new com.google.protobuf.SingleFieldBuilder<
              org.apache.calcite.avatica.proto.Common.CursorFactory, org.apache.calcite.avatica.proto.Common.CursorFactory.Builder, org.apache.calcite.avatica.proto.Common.CursorFactoryOrBuilder>(
                  getCursorFactory(),
                  getParentForChildren(),
                  isClean());
          cursorFactory_ = null;
        }
        return cursorFactoryBuilder_;
      }

      private int statementType_ = 0;
      /**
       * <code>optional .StatementType statementType = 5;</code>
       */
      public int getStatementTypeValue() {
        return statementType_;
      }
      /**
       * <code>optional .StatementType statementType = 5;</code>
       */
      public Builder setStatementTypeValue(int value) {
        statementType_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional .StatementType statementType = 5;</code>
       */
      public org.apache.calcite.avatica.proto.Common.StatementType getStatementType() {
        org.apache.calcite.avatica.proto.Common.StatementType result = org.apache.calcite.avatica.proto.Common.StatementType.valueOf(statementType_);
        return result == null ? org.apache.calcite.avatica.proto.Common.StatementType.UNRECOGNIZED : result;
      }
      /**
       * <code>optional .StatementType statementType = 5;</code>
       */
      public Builder setStatementType(org.apache.calcite.avatica.proto.Common.StatementType value) {
        if (value == null) {
          throw new NullPointerException();
        }
        
        statementType_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       * <code>optional .StatementType statementType = 5;</code>
       */
      public Builder clearStatementType() {
        
        statementType_ = 0;
        onChanged();
        return this;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return this;
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return this;
      }


      // @@protoc_insertion_point(builder_scope:Signature)
    }

    // @@protoc_insertion_point(class_scope:Signature)
    private static final org.apache.calcite.avatica.proto.Common.Signature DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.apache.calcite.avatica.proto.Common.Signature();
    }

    public static org.apache.calcite.avatica.proto.Common.Signature getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Signature>
        PARSER = new com.google.protobuf.AbstractParser<Signature>() {
      public Signature parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        try {
          return new Signature(input, extensionRegistry);
        } catch (RuntimeException e) {
          if (e.getCause() instanceof
              com.google.protobuf.InvalidProtocolBufferException) {
            throw (com.google.protobuf.InvalidProtocolBufferException)
                e.getCause();
          }
          throw e;
        }
      }
    };

    public static com.google.protobuf.Parser<Signature> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Signature> getParserForType() {
      return PARSER;
    }

    public org.apache.calcite.avatica.proto.Common.Signature getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface ColumnMetaDataOrBuilder extends
      // @@protoc_insertion_point(interface_extends:ColumnMetaData)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>optional uint32 ordinal = 1;</code>
     */
    int getOrdinal();

    /**
     * <code>optional bool auto_increment = 2;</code>
     */
    boolean getAutoIncrement();

    /**
     * <code>optional bool case_sensitive = 3;</code>
     */
    boolean getCaseSensitive();

    /**
     * <code>optional bool searchable = 4;</code>
     */
    boolean getSearchable();

    /**
     * <code>optional bool currency = 5;</code>
     */
    boolean getCurrency();

    /**
     * <code>optional uint32 nullable = 6;</code>
     */
    int getNullable();

    /**
     * <code>optional bool signed = 7;</code>
     */
    boolean getSigned();

    /**
     * <code>optional uint32 display_size = 8;</code>
     */
    int getDisplaySize();

    /**
     * <code>optional string label = 9;</code>
     */
    java.lang.String getLabel();
    /**
     * <code>optional string label = 9;</code>
     */
    com.google.protobuf.ByteString
        getLabelBytes();

    /**
     * <code>optional string column_name = 10;</code>
     */
    java.lang.String getColumnName();
    /**
     * <code>optional string column_name = 10;</code>
     */
    com.google.protobuf.ByteString
        getColumnNameBytes();

    /**
     * <code>optional string schema_name = 11;</code>
     */
    java.lang.String getSchemaName();
    /**
     * <code>optional string schema_name = 11;</code>
     */
    com.google.protobuf.ByteString
        getSchemaNameBytes();

    /**
     * <code>optional uint32 precision = 12;</code>
     */
    int getPrecision();

    /**
     * <code>optional uint32 scale = 13;</code>
     */
    int getScale();

    /**
     * <code>optional string table_name = 14;</code>
     */
    java.lang.String getTableName();
    /**
     * <code>optional string table_name = 14;</code>
     */
    com.google.protobuf.ByteString
        getTableNameBytes();

    /**
     * <code>optional string catalog_name = 15;</code>
     */
    java.lang.String getCatalogName();
    /**
     * <code>optional string catalog_name = 15;</code>
     */
    com.google.protobuf.ByteString
        getCatalogNameBytes();

    /**
     * <code>optional bool read_only = 16;</code>
     */
    boolean getReadOnly();

    /**
     * <code>optional bool writable = 17;</code>
     */
    boolean getWritable();

    /**
     * <code>optional bool definitely_writable = 18;</code>
     */
    boolean getDefinitelyWritable();

    /**
     * <code>optional string column_class_name = 19;</code>
     */
    java.lang.String getColumnClassName();
    /**
     * <code>optional string column_class_name = 19;</code>
     */
    com.google.protobuf.ByteString
        getColumnClassNameBytes();

    /**
     * <code>optional .AvaticaType type = 20;</code>
     */
    boolean hasType();
    /**
     * <code>optional .AvaticaType type = 20;</code>
     */
    org.apache.calcite.avatica.proto.Common.AvaticaType getType();
    /**
     * <code>optional .AvaticaType type = 20;</code>
     */
    org.apache.calcite.avatica.proto.Common.AvaticaTypeOrBuilder getTypeOrBuilder();
  }
  /**
   * Protobuf type {@code ColumnMetaData}
   */
  public  static final class ColumnMetaData extends
      com.google.protobuf.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:ColumnMetaData)
      ColumnMetaDataOrBuilder {
    // Use ColumnMetaData.newBuilder() to construct.
    private ColumnMetaData(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
    }
    private ColumnMetaData() {
      ordinal_ = 0;
      autoIncrement_ = false;
      caseSensitive_ = false;
      searchable_ = false;
      currency_ = false;
      nullable_ = 0;
      signed_ = false;
      displaySize_ = 0;
      label_ = "";
      columnName_ = "";
      schemaName_ = "";
      precision_ = 0;
      scale_ = 0;
      tableName_ = "";
      catalogName_ = "";
      readOnly_ = false;
      writable_ = false;
      definitelyWritable_ = false;
      columnClassName_ = "";
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return com.google.protobuf.UnknownFieldSet.getDefaultInstance();
    }
    private ColumnMetaData(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry) {
      this();
      int mutable_bitField0_ = 0;
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!input.skipField(tag)) {
                done = true;
              }
              break;
            }
            case 8: {

              ordinal_ = input.readUInt32();
              break;
            }
            case 16: {

              autoIncrement_ = input.readBool();
              break;
            }
            case 24: {

              caseSensitive_ = input.readBool();
              break;
            }
            case 32: {

              searchable_ = input.readBool();
              break;
            }
            case 40: {

              currency_ = input.readBool();
              break;
            }
            case 48: {

              nullable_ = input.readUInt32();
              break;
            }
            case 56: {

              signed_ = input.readBool();
              break;
            }
            case 64: {

              displaySize_ = input.readUInt32();
              break;
            }
            case 74: {
              String s = input.readStringRequireUtf8();

              label_ = s;
              break;
            }
            case 82: {
              String s = input.readStringRequireUtf8();

              columnName_ = s;
              break;
            }
            case 90: {
              String s = input.readStringRequireUtf8();

              schemaName_ = s;
              break;
            }
            case 96: {

              precision_ = input.readUInt32();
              break;
            }
            case 104: {

              scale_ = input.readUInt32();
              break;
            }
            case 114: {
              String s = input.readStringRequireUtf8();

              tableName_ = s;
              break;
            }
            case 122: {
              String s = input.readStringRequireUtf8();

              catalogName_ = s;
              break;
            }
            case 128: {

              readOnly_ = input.readBool();
              break;
            }
            case 136: {

              writable_ = input.readBool();
              break;
            }
            case 144: {

              definitelyWritable_ = input.readBool();
              break;
            }
            case 154: {
              String s = input.readStringRequireUtf8();

              columnClassName_ = s;
              break;
            }
            case 162: {
              org.apache.calcite.avatica.proto.Common.AvaticaType.Builder subBuilder = null;
              if (type_ != null) {
                subBuilder = type_.toBuilder();
              }
              type_ = input.readMessage(org.apache.calcite.avatica.proto.Common.AvaticaType.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(type_);
                type_ = subBuilder.buildPartial();
              }

              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw new RuntimeException(e.setUnfinishedMessage(this));
      } catch (java.io.IOException e) {
        throw new RuntimeException(
            new com.google.protobuf.InvalidProtocolBufferException(
                e.getMessage()).setUnfinishedMessage(this));
      } finally {
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.calcite.avatica.proto.Common.internal_static_ColumnMetaData_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.calcite.avatica.proto.Common.internal_static_ColumnMetaData_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.calcite.avatica.proto.Common.ColumnMetaData.class, org.apache.calcite.avatica.proto.Common.ColumnMetaData.Builder.class);
    }

    public static final int ORDINAL_FIELD_NUMBER = 1;
    private int ordinal_;
    /**
     * <code>optional uint32 ordinal = 1;</code>
     */
    public int getOrdinal() {
      return ordinal_;
    }

    public static final int AUTO_INCREMENT_FIELD_NUMBER = 2;
    private boolean autoIncrement_;
    /**
     * <code>optional bool auto_increment = 2;</code>
     */
    public boolean getAutoIncrement() {
      return autoIncrement_;
    }

    public static final int CASE_SENSITIVE_FIELD_NUMBER = 3;
    private boolean caseSensitive_;
    /**
     * <code>optional bool case_sensitive = 3;</code>
     */
    public boolean getCaseSensitive() {
      return caseSensitive_;
    }

    public static final int SEARCHABLE_FIELD_NUMBER = 4;
    private boolean searchable_;
    /**
     * <code>optional bool searchable = 4;</code>
     */
    public boolean getSearchable() {
      return searchable_;
    }

    public static final int CURRENCY_FIELD_NUMBER = 5;
    private boolean currency_;
    /**
     * <code>optional bool currency = 5;</code>
     */
    public boolean getCurrency() {
      return currency_;
    }

    public static final int NULLABLE_FIELD_NUMBER = 6;
    private int nullable_;
    /**
     * <code>optional uint32 nullable = 6;</code>
     */
    public int getNullable() {
      return nullable_;
    }

    public static final int SIGNED_FIELD_NUMBER = 7;
    private boolean signed_;
    /**
     * <code>optional bool signed = 7;</code>
     */
    public boolean getSigned() {
      return signed_;
    }

    public static final int DISPLAY_SIZE_FIELD_NUMBER = 8;
    private int displaySize_;
    /**
     * <code>optional uint32 display_size = 8;</code>
     */
    public int getDisplaySize() {
      return displaySize_;
    }

    public static final int LABEL_FIELD_NUMBER = 9;
    private volatile java.lang.Object label_;
    /**
     * <code>optional string label = 9;</code>
     */
    public java.lang.String getLabel() {
      java.lang.Object ref = label_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        label_ = s;
        return s;
      }
    }
    /**
     * <code>optional string label = 9;</code>
     */
    public com.google.protobuf.ByteString
        getLabelBytes() {
      java.lang.Object ref = label_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        label_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int COLUMN_NAME_FIELD_NUMBER = 10;
    private volatile java.lang.Object columnName_;
    /**
     * <code>optional string column_name = 10;</code>
     */
    public java.lang.String getColumnName() {
      java.lang.Object ref = columnName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        columnName_ = s;
        return s;
      }
    }
    /**
     * <code>optional string column_name = 10;</code>
     */
    public com.google.protobuf.ByteString
        getColumnNameBytes() {
      java.lang.Object ref = columnName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        columnName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int SCHEMA_NAME_FIELD_NUMBER = 11;
    private volatile java.lang.Object schemaName_;
    /**
     * <code>optional string schema_name = 11;</code>
     */
    public java.lang.String getSchemaName() {
      java.lang.Object ref = schemaName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        schemaName_ = s;
        return s;
      }
    }
    /**
     * <code>optional string schema_name = 11;</code>
     */
    public com.google.protobuf.ByteString
        getSchemaNameBytes() {
      java.lang.Object ref = schemaName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        schemaName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int PRECISION_FIELD_NUMBER = 12;
    private int precision_;
    /**
     * <code>optional uint32 precision = 12;</code>
     */
    public int getPrecision() {
      return precision_;
    }

    public static final int SCALE_FIELD_NUMBER = 13;
    private int scale_;
    /**
     * <code>optional uint32 scale = 13;</code>
     */
    public int getScale() {
      return scale_;
    }

    public static final int TABLE_NAME_FIELD_NUMBER = 14;
    private volatile java.lang.Object tableName_;
    /**
     * <code>optional string table_name = 14;</code>
     */
    public java.lang.String getTableName() {
      java.lang.Object ref = tableName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        tableName_ = s;
        return s;
      }
    }
    /**
     * <code>optional string table_name = 14;</code>
     */
    public com.google.protobuf.ByteString
        getTableNameBytes() {
      java.lang.Object ref = tableName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        tableName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int CATALOG_NAME_FIELD_NUMBER = 15;
    private volatile java.lang.Object catalogName_;
    /**
     * <code>optional string catalog_name = 15;</code>
     */
    public java.lang.String getCatalogName() {
      java.lang.Object ref = catalogName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        catalogName_ = s;
        return s;
      }
    }
    /**
     * <code>optional string catalog_name = 15;</code>
     */
    public com.google.protobuf.ByteString
        getCatalogNameBytes() {
      java.lang.Object ref = catalogName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        catalogName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int READ_ONLY_FIELD_NUMBER = 16;
    private boolean readOnly_;
    /**
     * <code>optional bool read_only = 16;</code>
     */
    public boolean getReadOnly() {
      return readOnly_;
    }

    public static final int WRITABLE_FIELD_NUMBER = 17;
    private boolean writable_;
    /**
     * <code>optional bool writable = 17;</code>
     */
    public boolean getWritable() {
      return writable_;
    }

    public static final int DEFINITELY_WRITABLE_FIELD_NUMBER = 18;
    private boolean definitelyWritable_;
    /**
     * <code>optional bool definitely_writable = 18;</code>
     */
    public boolean getDefinitelyWritable() {
      return definitelyWritable_;
    }

    public static final int COLUMN_CLASS_NAME_FIELD_NUMBER = 19;
    private volatile java.lang.Object columnClassName_;
    /**
     * <code>optional string column_class_name = 19;</code>
     */
    public java.lang.String getColumnClassName() {
      java.lang.Object ref = columnClassName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        columnClassName_ = s;
        return s;
      }
    }
    /**
     * <code>optional string column_class_name = 19;</code>
     */
    public com.google.protobuf.ByteString
        getColumnClassNameBytes() {
      java.lang.Object ref = columnClassName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        columnClassName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int TYPE_FIELD_NUMBER = 20;
    private org.apache.calcite.avatica.proto.Common.AvaticaType type_;
    /**
     * <code>optional .AvaticaType type = 20;</code>
     */
    public boolean hasType() {
      return type_ != null;
    }
    /**
     * <code>optional .AvaticaType type = 20;</code>
     */
    public org.apache.calcite.avatica.proto.Common.AvaticaType getType() {
      return type_ == null ? org.apache.calcite.avatica.proto.Common.AvaticaType.getDefaultInstance() : type_;
    }
    /**
     * <code>optional .AvaticaType type = 20;</code>
     */
    public org.apache.calcite.avatica.proto.Common.AvaticaTypeOrBuilder getTypeOrBuilder() {
      return getType();
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (ordinal_ != 0) {
        output.writeUInt32(1, ordinal_);
      }
      if (autoIncrement_ != false) {
        output.writeBool(2, autoIncrement_);
      }
      if (caseSensitive_ != false) {
        output.writeBool(3, caseSensitive_);
      }
      if (searchable_ != false) {
        output.writeBool(4, searchable_);
      }
      if (currency_ != false) {
        output.writeBool(5, currency_);
      }
      if (nullable_ != 0) {
        output.writeUInt32(6, nullable_);
      }
      if (signed_ != false) {
        output.writeBool(7, signed_);
      }
      if (displaySize_ != 0) {
        output.writeUInt32(8, displaySize_);
      }
      if (!getLabelBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessage.writeString(output, 9, label_);
      }
      if (!getColumnNameBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessage.writeString(output, 10, columnName_);
      }
      if (!getSchemaNameBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessage.writeString(output, 11, schemaName_);
      }
      if (precision_ != 0) {
        output.writeUInt32(12, precision_);
      }
      if (scale_ != 0) {
        output.writeUInt32(13, scale_);
      }
      if (!getTableNameBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessage.writeString(output, 14, tableName_);
      }
      if (!getCatalogNameBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessage.writeString(output, 15, catalogName_);
      }
      if (readOnly_ != false) {
        output.writeBool(16, readOnly_);
      }
      if (writable_ != false) {
        output.writeBool(17, writable_);
      }
      if (definitelyWritable_ != false) {
        output.writeBool(18, definitelyWritable_);
      }
      if (!getColumnClassNameBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessage.writeString(output, 19, columnClassName_);
      }
      if (type_ != null) {
        output.writeMessage(20, getType());
      }
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (ordinal_ != 0) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt32Size(1, ordinal_);
      }
      if (autoIncrement_ != false) {
        size += com.google.protobuf.CodedOutputStream
          .computeBoolSize(2, autoIncrement_);
      }
      if (caseSensitive_ != false) {
        size += com.google.protobuf.CodedOutputStream
          .computeBoolSize(3, caseSensitive_);
      }
      if (searchable_ != false) {
        size += com.google.protobuf.CodedOutputStream
          .computeBoolSize(4, searchable_);
      }
      if (currency_ != false) {
        size += com.google.protobuf.CodedOutputStream
          .computeBoolSize(5, currency_);
      }
      if (nullable_ != 0) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt32Size(6, nullable_);
      }
      if (signed_ != false) {
        size += com.google.protobuf.CodedOutputStream
          .computeBoolSize(7, signed_);
      }
      if (displaySize_ != 0) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt32Size(8, displaySize_);
      }
      if (!getLabelBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessage.computeStringSize(9, label_);
      }
      if (!getColumnNameBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessage.computeStringSize(10, columnName_);
      }
      if (!getSchemaNameBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessage.computeStringSize(11, schemaName_);
      }
      if (precision_ != 0) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt32Size(12, precision_);
      }
      if (scale_ != 0) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt32Size(13, scale_);
      }
      if (!getTableNameBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessage.computeStringSize(14, tableName_);
      }
      if (!getCatalogNameBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessage.computeStringSize(15, catalogName_);
      }
      if (readOnly_ != false) {
        size += com.google.protobuf.CodedOutputStream
          .computeBoolSize(16, readOnly_);
      }
      if (writable_ != false) {
        size += com.google.protobuf.CodedOutputStream
          .computeBoolSize(17, writable_);
      }
      if (definitelyWritable_ != false) {
        size += com.google.protobuf.CodedOutputStream
          .computeBoolSize(18, definitelyWritable_);
      }
      if (!getColumnClassNameBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessage.computeStringSize(19, columnClassName_);
      }
      if (type_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(20, getType());
      }
      memoizedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    public static org.apache.calcite.avatica.proto.Common.ColumnMetaData parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.calcite.avatica.proto.Common.ColumnMetaData parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.calcite.avatica.proto.Common.ColumnMetaData parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.calcite.avatica.proto.Common.ColumnMetaData parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.calcite.avatica.proto.Common.ColumnMetaData parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.calcite.avatica.proto.Common.ColumnMetaData parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static org.apache.calcite.avatica.proto.Common.ColumnMetaData parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static org.apache.calcite.avatica.proto.Common.ColumnMetaData parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static org.apache.calcite.avatica.proto.Common.ColumnMetaData parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.calcite.avatica.proto.Common.ColumnMetaData parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.apache.calcite.avatica.proto.Common.ColumnMetaData prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code ColumnMetaData}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:ColumnMetaData)
        org.apache.calcite.avatica.proto.Common.ColumnMetaDataOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.calcite.avatica.proto.Common.internal_static_ColumnMetaData_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.calcite.avatica.proto.Common.internal_static_ColumnMetaData_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.calcite.avatica.proto.Common.ColumnMetaData.class, org.apache.calcite.avatica.proto.Common.ColumnMetaData.Builder.class);
      }

      // Construct using org.apache.calcite.avatica.proto.Common.ColumnMetaData.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
        }
      }
      public Builder clear() {
        super.clear();
        ordinal_ = 0;

        autoIncrement_ = false;

        caseSensitive_ = false;

        searchable_ = false;

        currency_ = false;

        nullable_ = 0;

        signed_ = false;

        displaySize_ = 0;

        label_ = "";

        columnName_ = "";

        schemaName_ = "";

        precision_ = 0;

        scale_ = 0;

        tableName_ = "";

        catalogName_ = "";

        readOnly_ = false;

        writable_ = false;

        definitelyWritable_ = false;

        columnClassName_ = "";

        if (typeBuilder_ == null) {
          type_ = null;
        } else {
          type_ = null;
          typeBuilder_ = null;
        }
        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.calcite.avatica.proto.Common.internal_static_ColumnMetaData_descriptor;
      }

      public org.apache.calcite.avatica.proto.Common.ColumnMetaData getDefaultInstanceForType() {
        return org.apache.calcite.avatica.proto.Common.ColumnMetaData.getDefaultInstance();
      }

      public org.apache.calcite.avatica.proto.Common.ColumnMetaData build() {
        org.apache.calcite.avatica.proto.Common.ColumnMetaData result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public org.apache.calcite.avatica.proto.Common.ColumnMetaData buildPartial() {
        org.apache.calcite.avatica.proto.Common.ColumnMetaData result = new org.apache.calcite.avatica.proto.Common.ColumnMetaData(this);
        result.ordinal_ = ordinal_;
        result.autoIncrement_ = autoIncrement_;
        result.caseSensitive_ = caseSensitive_;
        result.searchable_ = searchable_;
        result.currency_ = currency_;
        result.nullable_ = nullable_;
        result.signed_ = signed_;
        result.displaySize_ = displaySize_;
        result.label_ = label_;
        result.columnName_ = columnName_;
        result.schemaName_ = schemaName_;
        result.precision_ = precision_;
        result.scale_ = scale_;
        result.tableName_ = tableName_;
        result.catalogName_ = catalogName_;
        result.readOnly_ = readOnly_;
        result.writable_ = writable_;
        result.definitelyWritable_ = definitelyWritable_;
        result.columnClassName_ = columnClassName_;
        if (typeBuilder_ == null) {
          result.type_ = type_;
        } else {
          result.type_ = typeBuilder_.build();
        }
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.apache.calcite.avatica.proto.Common.ColumnMetaData) {
          return mergeFrom((org.apache.calcite.avatica.proto.Common.ColumnMetaData)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.calcite.avatica.proto.Common.ColumnMetaData other) {
        if (other == org.apache.calcite.avatica.proto.Common.ColumnMetaData.getDefaultInstance()) return this;
        if (other.getOrdinal() != 0) {
          setOrdinal(other.getOrdinal());
        }
        if (other.getAutoIncrement() != false) {
          setAutoIncrement(other.getAutoIncrement());
        }
        if (other.getCaseSensitive() != false) {
          setCaseSensitive(other.getCaseSensitive());
        }
        if (other.getSearchable() != false) {
          setSearchable(other.getSearchable());
        }
        if (other.getCurrency() != false) {
          setCurrency(other.getCurrency());
        }
        if (other.getNullable() != 0) {
          setNullable(other.getNullable());
        }
        if (other.getSigned() != false) {
          setSigned(other.getSigned());
        }
        if (other.getDisplaySize() != 0) {
          setDisplaySize(other.getDisplaySize());
        }
        if (!other.getLabel().isEmpty()) {
          label_ = other.label_;
          onChanged();
        }
        if (!other.getColumnName().isEmpty()) {
          columnName_ = other.columnName_;
          onChanged();
        }
        if (!other.getSchemaName().isEmpty()) {
          schemaName_ = other.schemaName_;
          onChanged();
        }
        if (other.getPrecision() != 0) {
          setPrecision(other.getPrecision());
        }
        if (other.getScale() != 0) {
          setScale(other.getScale());
        }
        if (!other.getTableName().isEmpty()) {
          tableName_ = other.tableName_;
          onChanged();
        }
        if (!other.getCatalogName().isEmpty()) {
          catalogName_ = other.catalogName_;
          onChanged();
        }
        if (other.getReadOnly() != false) {
          setReadOnly(other.getReadOnly());
        }
        if (other.getWritable() != false) {
          setWritable(other.getWritable());
        }
        if (other.getDefinitelyWritable() != false) {
          setDefinitelyWritable(other.getDefinitelyWritable());
        }
        if (!other.getColumnClassName().isEmpty()) {
          columnClassName_ = other.columnClassName_;
          onChanged();
        }
        if (other.hasType()) {
          mergeType(other.getType());
        }
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        org.apache.calcite.avatica.proto.Common.ColumnMetaData parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (org.apache.calcite.avatica.proto.Common.ColumnMetaData) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private int ordinal_ ;
      /**
       * <code>optional uint32 ordinal = 1;</code>
       */
      public int getOrdinal() {
        return ordinal_;
      }
      /**
       * <code>optional uint32 ordinal = 1;</code>
       */
      public Builder setOrdinal(int value) {
        
        ordinal_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional uint32 ordinal = 1;</code>
       */
      public Builder clearOrdinal() {
        
        ordinal_ = 0;
        onChanged();
        return this;
      }

      private boolean autoIncrement_ ;
      /**
       * <code>optional bool auto_increment = 2;</code>
       */
      public boolean getAutoIncrement() {
        return autoIncrement_;
      }
      /**
       * <code>optional bool auto_increment = 2;</code>
       */
      public Builder setAutoIncrement(boolean value) {
        
        autoIncrement_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional bool auto_increment = 2;</code>
       */
      public Builder clearAutoIncrement() {
        
        autoIncrement_ = false;
        onChanged();
        return this;
      }

      private boolean caseSensitive_ ;
      /**
       * <code>optional bool case_sensitive = 3;</code>
       */
      public boolean getCaseSensitive() {
        return caseSensitive_;
      }
      /**
       * <code>optional bool case_sensitive = 3;</code>
       */
      public Builder setCaseSensitive(boolean value) {
        
        caseSensitive_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional bool case_sensitive = 3;</code>
       */
      public Builder clearCaseSensitive() {
        
        caseSensitive_ = false;
        onChanged();
        return this;
      }

      private boolean searchable_ ;
      /**
       * <code>optional bool searchable = 4;</code>
       */
      public boolean getSearchable() {
        return searchable_;
      }
      /**
       * <code>optional bool searchable = 4;</code>
       */
      public Builder setSearchable(boolean value) {
        
        searchable_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional bool searchable = 4;</code>
       */
      public Builder clearSearchable() {
        
        searchable_ = false;
        onChanged();
        return this;
      }

      private boolean currency_ ;
      /**
       * <code>optional bool currency = 5;</code>
       */
      public boolean getCurrency() {
        return currency_;
      }
      /**
       * <code>optional bool currency = 5;</code>
       */
      public Builder setCurrency(boolean value) {
        
        currency_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional bool currency = 5;</code>
       */
      public Builder clearCurrency() {
        
        currency_ = false;
        onChanged();
        return this;
      }

      private int nullable_ ;
      /**
       * <code>optional uint32 nullable = 6;</code>
       */
      public int getNullable() {
        return nullable_;
      }
      /**
       * <code>optional uint32 nullable = 6;</code>
       */
      public Builder setNullable(int value) {
        
        nullable_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional uint32 nullable = 6;</code>
       */
      public Builder clearNullable() {
        
        nullable_ = 0;
        onChanged();
        return this;
      }

      private boolean signed_ ;
      /**
       * <code>optional bool signed = 7;</code>
       */
      public boolean getSigned() {
        return signed_;
      }
      /**
       * <code>optional bool signed = 7;</code>
       */
      public Builder setSigned(boolean value) {
        
        signed_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional bool signed = 7;</code>
       */
      public Builder clearSigned() {
        
        signed_ = false;
        onChanged();
        return this;
      }

      private int displaySize_ ;
      /**
       * <code>optional uint32 display_size = 8;</code>
       */
      public int getDisplaySize() {
        return displaySize_;
      }
      /**
       * <code>optional uint32 display_size = 8;</code>
       */
      public Builder setDisplaySize(int value) {
        
        displaySize_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional uint32 display_size = 8;</code>
       */
      public Builder clearDisplaySize() {
        
        displaySize_ = 0;
        onChanged();
        return this;
      }

      private java.lang.Object label_ = "";
      /**
       * <code>optional string label = 9;</code>
       */
      public java.lang.String getLabel() {
        java.lang.Object ref = label_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          label_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>optional string label = 9;</code>
       */
      public com.google.protobuf.ByteString
          getLabelBytes() {
        java.lang.Object ref = label_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          label_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>optional string label = 9;</code>
       */
      public Builder setLabel(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        label_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional string label = 9;</code>
       */
      public Builder clearLabel() {
        
        label_ = getDefaultInstance().getLabel();
        onChanged();
        return this;
      }
      /**
       * <code>optional string label = 9;</code>
       */
      public Builder setLabelBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        label_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object columnName_ = "";
      /**
       * <code>optional string column_name = 10;</code>
       */
      public java.lang.String getColumnName() {
        java.lang.Object ref = columnName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          columnName_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>optional string column_name = 10;</code>
       */
      public com.google.protobuf.ByteString
          getColumnNameBytes() {
        java.lang.Object ref = columnName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          columnName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>optional string column_name = 10;</code>
       */
      public Builder setColumnName(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        columnName_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional string column_name = 10;</code>
       */
      public Builder clearColumnName() {
        
        columnName_ = getDefaultInstance().getColumnName();
        onChanged();
        return this;
      }
      /**
       * <code>optional string column_name = 10;</code>
       */
      public Builder setColumnNameBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        columnName_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object schemaName_ = "";
      /**
       * <code>optional string schema_name = 11;</code>
       */
      public java.lang.String getSchemaName() {
        java.lang.Object ref = schemaName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          schemaName_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>optional string schema_name = 11;</code>
       */
      public com.google.protobuf.ByteString
          getSchemaNameBytes() {
        java.lang.Object ref = schemaName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          schemaName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>optional string schema_name = 11;</code>
       */
      public Builder setSchemaName(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        schemaName_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional string schema_name = 11;</code>
       */
      public Builder clearSchemaName() {
        
        schemaName_ = getDefaultInstance().getSchemaName();
        onChanged();
        return this;
      }
      /**
       * <code>optional string schema_name = 11;</code>
       */
      public Builder setSchemaNameBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        schemaName_ = value;
        onChanged();
        return this;
      }

      private int precision_ ;
      /**
       * <code>optional uint32 precision = 12;</code>
       */
      public int getPrecision() {
        return precision_;
      }
      /**
       * <code>optional uint32 precision = 12;</code>
       */
      public Builder setPrecision(int value) {
        
        precision_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional uint32 precision = 12;</code>
       */
      public Builder clearPrecision() {
        
        precision_ = 0;
        onChanged();
        return this;
      }

      private int scale_ ;
      /**
       * <code>optional uint32 scale = 13;</code>
       */
      public int getScale() {
        return scale_;
      }
      /**
       * <code>optional uint32 scale = 13;</code>
       */
      public Builder setScale(int value) {
        
        scale_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional uint32 scale = 13;</code>
       */
      public Builder clearScale() {
        
        scale_ = 0;
        onChanged();
        return this;
      }

      private java.lang.Object tableName_ = "";
      /**
       * <code>optional string table_name = 14;</code>
       */
      public java.lang.String getTableName() {
        java.lang.Object ref = tableName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          tableName_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>optional string table_name = 14;</code>
       */
      public com.google.protobuf.ByteString
          getTableNameBytes() {
        java.lang.Object ref = tableName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          tableName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>optional string table_name = 14;</code>
       */
      public Builder setTableName(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        tableName_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional string table_name = 14;</code>
       */
      public Builder clearTableName() {
        
        tableName_ = getDefaultInstance().getTableName();
        onChanged();
        return this;
      }
      /**
       * <code>optional string table_name = 14;</code>
       */
      public Builder setTableNameBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        tableName_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object catalogName_ = "";
      /**
       * <code>optional string catalog_name = 15;</code>
       */
      public java.lang.String getCatalogName() {
        java.lang.Object ref = catalogName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          catalogName_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>optional string catalog_name = 15;</code>
       */
      public com.google.protobuf.ByteString
          getCatalogNameBytes() {
        java.lang.Object ref = catalogName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          catalogName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>optional string catalog_name = 15;</code>
       */
      public Builder setCatalogName(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        catalogName_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional string catalog_name = 15;</code>
       */
      public Builder clearCatalogName() {
        
        catalogName_ = getDefaultInstance().getCatalogName();
        onChanged();
        return this;
      }
      /**
       * <code>optional string catalog_name = 15;</code>
       */
      public Builder setCatalogNameBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        catalogName_ = value;
        onChanged();
        return this;
      }

      private boolean readOnly_ ;
      /**
       * <code>optional bool read_only = 16;</code>
       */
      public boolean getReadOnly() {
        return readOnly_;
      }
      /**
       * <code>optional bool read_only = 16;</code>
       */
      public Builder setReadOnly(boolean value) {
        
        readOnly_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional bool read_only = 16;</code>
       */
      public Builder clearReadOnly() {
        
        readOnly_ = false;
        onChanged();
        return this;
      }

      private boolean writable_ ;
      /**
       * <code>optional bool writable = 17;</code>
       */
      public boolean getWritable() {
        return writable_;
      }
      /**
       * <code>optional bool writable = 17;</code>
       */
      public Builder setWritable(boolean value) {
        
        writable_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional bool writable = 17;</code>
       */
      public Builder clearWritable() {
        
        writable_ = false;
        onChanged();
        return this;
      }

      private boolean definitelyWritable_ ;
      /**
       * <code>optional bool definitely_writable = 18;</code>
       */
      public boolean getDefinitelyWritable() {
        return definitelyWritable_;
      }
      /**
       * <code>optional bool definitely_writable = 18;</code>
       */
      public Builder setDefinitelyWritable(boolean value) {
        
        definitelyWritable_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional bool definitely_writable = 18;</code>
       */
      public Builder clearDefinitelyWritable() {
        
        definitelyWritable_ = false;
        onChanged();
        return this;
      }

      private java.lang.Object columnClassName_ = "";
      /**
       * <code>optional string column_class_name = 19;</code>
       */
      public java.lang.String getColumnClassName() {
        java.lang.Object ref = columnClassName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          columnClassName_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>optional string column_class_name = 19;</code>
       */
      public com.google.protobuf.ByteString
          getColumnClassNameBytes() {
        java.lang.Object ref = columnClassName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          columnClassName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>optional string column_class_name = 19;</code>
       */
      public Builder setColumnClassName(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        columnClassName_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional string column_class_name = 19;</code>
       */
      public Builder clearColumnClassName() {
        
        columnClassName_ = getDefaultInstance().getColumnClassName();
        onChanged();
        return this;
      }
      /**
       * <code>optional string column_class_name = 19;</code>
       */
      public Builder setColumnClassNameBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        columnClassName_ = value;
        onChanged();
        return this;
      }

      private org.apache.calcite.avatica.proto.Common.AvaticaType type_ = null;
      private com.google.protobuf.SingleFieldBuilder<
          org.apache.calcite.avatica.proto.Common.AvaticaType, org.apache.calcite.avatica.proto.Common.AvaticaType.Builder, org.apache.calcite.avatica.proto.Common.AvaticaTypeOrBuilder> typeBuilder_;
      /**
       * <code>optional .AvaticaType type = 20;</code>
       */
      public boolean hasType() {
        return typeBuilder_ != null || type_ != null;
      }
      /**
       * <code>optional .AvaticaType type = 20;</code>
       */
      public org.apache.calcite.avatica.proto.Common.AvaticaType getType() {
        if (typeBuilder_ == null) {
          return type_ == null ? org.apache.calcite.avatica.proto.Common.AvaticaType.getDefaultInstance() : type_;
        } else {
          return typeBuilder_.getMessage();
        }
      }
      /**
       * <code>optional .AvaticaType type = 20;</code>
       */
      public Builder setType(org.apache.calcite.avatica.proto.Common.AvaticaType value) {
        if (typeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          type_ = value;
          onChanged();
        } else {
          typeBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <code>optional .AvaticaType type = 20;</code>
       */
      public Builder setType(
          org.apache.calcite.avatica.proto.Common.AvaticaType.Builder builderForValue) {
        if (typeBuilder_ == null) {
          type_ = builderForValue.build();
          onChanged();
        } else {
          typeBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <code>optional .AvaticaType type = 20;</code>
       */
      public Builder mergeType(org.apache.calcite.avatica.proto.Common.AvaticaType value) {
        if (typeBuilder_ == null) {
          if (type_ != null) {
            type_ =
              org.apache.calcite.avatica.proto.Common.AvaticaType.newBuilder(type_).mergeFrom(value).buildPartial();
          } else {
            type_ = value;
          }
          onChanged();
        } else {
          typeBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <code>optional .AvaticaType type = 20;</code>
       */
      public Builder clearType() {
        if (typeBuilder_ == null) {
          type_ = null;
          onChanged();
        } else {
          type_ = null;
          typeBuilder_ = null;
        }

        return this;
      }
      /**
       * <code>optional .AvaticaType type = 20;</code>
       */
      public org.apache.calcite.avatica.proto.Common.AvaticaType.Builder getTypeBuilder() {
        
        onChanged();
        return getTypeFieldBuilder().getBuilder();
      }
      /**
       * <code>optional .AvaticaType type = 20;</code>
       */
      public org.apache.calcite.avatica.proto.Common.AvaticaTypeOrBuilder getTypeOrBuilder() {
        if (typeBuilder_ != null) {
          return typeBuilder_.getMessageOrBuilder();
        } else {
          return type_ == null ?
              org.apache.calcite.avatica.proto.Common.AvaticaType.getDefaultInstance() : type_;
        }
      }
      /**
       * <code>optional .AvaticaType type = 20;</code>
       */
      private com.google.protobuf.SingleFieldBuilder<
          org.apache.calcite.avatica.proto.Common.AvaticaType, org.apache.calcite.avatica.proto.Common.AvaticaType.Builder, org.apache.calcite.avatica.proto.Common.AvaticaTypeOrBuilder> 
          getTypeFieldBuilder() {
        if (typeBuilder_ == null) {
          typeBuilder_ = new com.google.protobuf.SingleFieldBuilder<
              org.apache.calcite.avatica.proto.Common.AvaticaType, org.apache.calcite.avatica.proto.Common.AvaticaType.Builder, org.apache.calcite.avatica.proto.Common.AvaticaTypeOrBuilder>(
                  getType(),
                  getParentForChildren(),
                  isClean());
          type_ = null;
        }
        return typeBuilder_;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return this;
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return this;
      }


      // @@protoc_insertion_point(builder_scope:ColumnMetaData)
    }

    // @@protoc_insertion_point(class_scope:ColumnMetaData)
    private static final org.apache.calcite.avatica.proto.Common.ColumnMetaData DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.apache.calcite.avatica.proto.Common.ColumnMetaData();
    }

    public static org.apache.calcite.avatica.proto.Common.ColumnMetaData getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ColumnMetaData>
        PARSER = new com.google.protobuf.AbstractParser<ColumnMetaData>() {
      public ColumnMetaData parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        try {
          return new ColumnMetaData(input, extensionRegistry);
        } catch (RuntimeException e) {
          if (e.getCause() instanceof
              com.google.protobuf.InvalidProtocolBufferException) {
            throw (com.google.protobuf.InvalidProtocolBufferException)
                e.getCause();
          }
          throw e;
        }
      }
    };

    public static com.google.protobuf.Parser<ColumnMetaData> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ColumnMetaData> getParserForType() {
      return PARSER;
    }

    public org.apache.calcite.avatica.proto.Common.ColumnMetaData getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface AvaticaTypeOrBuilder extends
      // @@protoc_insertion_point(interface_extends:AvaticaType)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>optional uint32 id = 1;</code>
     */
    int getId();

    /**
     * <code>optional string name = 2;</code>
     */
    java.lang.String getName();
    /**
     * <code>optional string name = 2;</code>
     */
    com.google.protobuf.ByteString
        getNameBytes();

    /**
     * <code>optional .Rep rep = 3;</code>
     */
    int getRepValue();
    /**
     * <code>optional .Rep rep = 3;</code>
     */
    org.apache.calcite.avatica.proto.Common.Rep getRep();

    /**
     * <code>repeated .ColumnMetaData columns = 4;</code>
     *
     * <pre>
     * Only present when name = STRUCT
     * </pre>
     */
    java.util.List<org.apache.calcite.avatica.proto.Common.ColumnMetaData> 
        getColumnsList();
    /**
     * <code>repeated .ColumnMetaData columns = 4;</code>
     *
     * <pre>
     * Only present when name = STRUCT
     * </pre>
     */
    org.apache.calcite.avatica.proto.Common.ColumnMetaData getColumns(int index);
    /**
     * <code>repeated .ColumnMetaData columns = 4;</code>
     *
     * <pre>
     * Only present when name = STRUCT
     * </pre>
     */
    int getColumnsCount();
    /**
     * <code>repeated .ColumnMetaData columns = 4;</code>
     *
     * <pre>
     * Only present when name = STRUCT
     * </pre>
     */
    java.util.List<? extends org.apache.calcite.avatica.proto.Common.ColumnMetaDataOrBuilder> 
        getColumnsOrBuilderList();
    /**
     * <code>repeated .ColumnMetaData columns = 4;</code>
     *
     * <pre>
     * Only present when name = STRUCT
     * </pre>
     */
    org.apache.calcite.avatica.proto.Common.ColumnMetaDataOrBuilder getColumnsOrBuilder(
        int index);

    /**
     * <code>optional .AvaticaType component = 5;</code>
     *
     * <pre>
     * Only present when name = ARRAY
     * </pre>
     */
    boolean hasComponent();
    /**
     * <code>optional .AvaticaType component = 5;</code>
     *
     * <pre>
     * Only present when name = ARRAY
     * </pre>
     */
    org.apache.calcite.avatica.proto.Common.AvaticaType getComponent();
    /**
     * <code>optional .AvaticaType component = 5;</code>
     *
     * <pre>
     * Only present when name = ARRAY
     * </pre>
     */
    org.apache.calcite.avatica.proto.Common.AvaticaTypeOrBuilder getComponentOrBuilder();
  }
  /**
   * Protobuf type {@code AvaticaType}
   *
   * <pre>
   * Base class for a column type
   * </pre>
   */
  public  static final class AvaticaType extends
      com.google.protobuf.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:AvaticaType)
      AvaticaTypeOrBuilder {
    // Use AvaticaType.newBuilder() to construct.
    private AvaticaType(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
    }
    private AvaticaType() {
      id_ = 0;
      name_ = "";
      rep_ = 0;
      columns_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return com.google.protobuf.UnknownFieldSet.getDefaultInstance();
    }
    private AvaticaType(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry) {
      this();
      int mutable_bitField0_ = 0;
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!input.skipField(tag)) {
                done = true;
              }
              break;
            }
            case 8: {

              id_ = input.readUInt32();
              break;
            }
            case 18: {
              String s = input.readStringRequireUtf8();

              name_ = s;
              break;
            }
            case 24: {
              int rawValue = input.readEnum();

              rep_ = rawValue;
              break;
            }
            case 34: {
              if (!((mutable_bitField0_ & 0x00000008) == 0x00000008)) {
                columns_ = new java.util.ArrayList<org.apache.calcite.avatica.proto.Common.ColumnMetaData>();
                mutable_bitField0_ |= 0x00000008;
              }
              columns_.add(input.readMessage(org.apache.calcite.avatica.proto.Common.ColumnMetaData.parser(), extensionRegistry));
              break;
            }
            case 42: {
              org.apache.calcite.avatica.proto.Common.AvaticaType.Builder subBuilder = null;
              if (component_ != null) {
                subBuilder = component_.toBuilder();
              }
              component_ = input.readMessage(org.apache.calcite.avatica.proto.Common.AvaticaType.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(component_);
                component_ = subBuilder.buildPartial();
              }

              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw new RuntimeException(e.setUnfinishedMessage(this));
      } catch (java.io.IOException e) {
        throw new RuntimeException(
            new com.google.protobuf.InvalidProtocolBufferException(
                e.getMessage()).setUnfinishedMessage(this));
      } finally {
        if (((mutable_bitField0_ & 0x00000008) == 0x00000008)) {
          columns_ = java.util.Collections.unmodifiableList(columns_);
        }
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.calcite.avatica.proto.Common.internal_static_AvaticaType_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.calcite.avatica.proto.Common.internal_static_AvaticaType_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.calcite.avatica.proto.Common.AvaticaType.class, org.apache.calcite.avatica.proto.Common.AvaticaType.Builder.class);
    }

    private int bitField0_;
    public static final int ID_FIELD_NUMBER = 1;
    private int id_;
    /**
     * <code>optional uint32 id = 1;</code>
     */
    public int getId() {
      return id_;
    }

    public static final int NAME_FIELD_NUMBER = 2;
    private volatile java.lang.Object name_;
    /**
     * <code>optional string name = 2;</code>
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      }
    }
    /**
     * <code>optional string name = 2;</code>
     */
    public com.google.protobuf.ByteString
        getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int REP_FIELD_NUMBER = 3;
    private int rep_;
    /**
     * <code>optional .Rep rep = 3;</code>
     */
    public int getRepValue() {
      return rep_;
    }
    /**
     * <code>optional .Rep rep = 3;</code>
     */
    public org.apache.calcite.avatica.proto.Common.Rep getRep() {
      org.apache.calcite.avatica.proto.Common.Rep result = org.apache.calcite.avatica.proto.Common.Rep.valueOf(rep_);
      return result == null ? org.apache.calcite.avatica.proto.Common.Rep.UNRECOGNIZED : result;
    }

    public static final int COLUMNS_FIELD_NUMBER = 4;
    private java.util.List<org.apache.calcite.avatica.proto.Common.ColumnMetaData> columns_;
    /**
     * <code>repeated .ColumnMetaData columns = 4;</code>
     *
     * <pre>
     * Only present when name = STRUCT
     * </pre>
     */
    public java.util.List<org.apache.calcite.avatica.proto.Common.ColumnMetaData> getColumnsList() {
      return columns_;
    }
    /**
     * <code>repeated .ColumnMetaData columns = 4;</code>
     *
     * <pre>
     * Only present when name = STRUCT
     * </pre>
     */
    public java.util.List<? extends org.apache.calcite.avatica.proto.Common.ColumnMetaDataOrBuilder> 
        getColumnsOrBuilderList() {
      return columns_;
    }
    /**
     * <code>repeated .ColumnMetaData columns = 4;</code>
     *
     * <pre>
     * Only present when name = STRUCT
     * </pre>
     */
    public int getColumnsCount() {
      return columns_.size();
    }
    /**
     * <code>repeated .ColumnMetaData columns = 4;</code>
     *
     * <pre>
     * Only present when name = STRUCT
     * </pre>
     */
    public org.apache.calcite.avatica.proto.Common.ColumnMetaData getColumns(int index) {
      return columns_.get(index);
    }
    /**
     * <code>repeated .ColumnMetaData columns = 4;</code>
     *
     * <pre>
     * Only present when name = STRUCT
     * </pre>
     */
    public org.apache.calcite.avatica.proto.Common.ColumnMetaDataOrBuilder getColumnsOrBuilder(
        int index) {
      return columns_.get(index);
    }

    public static final int COMPONENT_FIELD_NUMBER = 5;
    private org.apache.calcite.avatica.proto.Common.AvaticaType component_;
    /**
     * <code>optional .AvaticaType component = 5;</code>
     *
     * <pre>
     * Only present when name = ARRAY
     * </pre>
     */
    public boolean hasComponent() {
      return component_ != null;
    }
    /**
     * <code>optional .AvaticaType component = 5;</code>
     *
     * <pre>
     * Only present when name = ARRAY
     * </pre>
     */
    public org.apache.calcite.avatica.proto.Common.AvaticaType getComponent() {
      return component_ == null ? org.apache.calcite.avatica.proto.Common.AvaticaType.getDefaultInstance() : component_;
    }
    /**
     * <code>optional .AvaticaType component = 5;</code>
     *
     * <pre>
     * Only present when name = ARRAY
     * </pre>
     */
    public org.apache.calcite.avatica.proto.Common.AvaticaTypeOrBuilder getComponentOrBuilder() {
      return getComponent();
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (id_ != 0) {
        output.writeUInt32(1, id_);
      }
      if (!getNameBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessage.writeString(output, 2, name_);
      }
      if (rep_ != org.apache.calcite.avatica.proto.Common.Rep.PRIMITIVE_BOOLEAN.getNumber()) {
        output.writeEnum(3, rep_);
      }
      for (int i = 0; i < columns_.size(); i++) {
        output.writeMessage(4, columns_.get(i));
      }
      if (component_ != null) {
        output.writeMessage(5, getComponent());
      }
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (id_ != 0) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt32Size(1, id_);
      }
      if (!getNameBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessage.computeStringSize(2, name_);
      }
      if (rep_ != org.apache.calcite.avatica.proto.Common.Rep.PRIMITIVE_BOOLEAN.getNumber()) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(3, rep_);
      }
      for (int i = 0; i < columns_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(4, columns_.get(i));
      }
      if (component_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(5, getComponent());
      }
      memoizedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    public static org.apache.calcite.avatica.proto.Common.AvaticaType parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.calcite.avatica.proto.Common.AvaticaType parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.calcite.avatica.proto.Common.AvaticaType parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.calcite.avatica.proto.Common.AvaticaType parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.calcite.avatica.proto.Common.AvaticaType parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.calcite.avatica.proto.Common.AvaticaType parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static org.apache.calcite.avatica.proto.Common.AvaticaType parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static org.apache.calcite.avatica.proto.Common.AvaticaType parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static org.apache.calcite.avatica.proto.Common.AvaticaType parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.calcite.avatica.proto.Common.AvaticaType parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.apache.calcite.avatica.proto.Common.AvaticaType prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code AvaticaType}
     *
     * <pre>
     * Base class for a column type
     * </pre>
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:AvaticaType)
        org.apache.calcite.avatica.proto.Common.AvaticaTypeOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.calcite.avatica.proto.Common.internal_static_AvaticaType_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.calcite.avatica.proto.Common.internal_static_AvaticaType_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.calcite.avatica.proto.Common.AvaticaType.class, org.apache.calcite.avatica.proto.Common.AvaticaType.Builder.class);
      }

      // Construct using org.apache.calcite.avatica.proto.Common.AvaticaType.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
          getColumnsFieldBuilder();
        }
      }
      public Builder clear() {
        super.clear();
        id_ = 0;

        name_ = "";

        rep_ = 0;

        if (columnsBuilder_ == null) {
          columns_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000008);
        } else {
          columnsBuilder_.clear();
        }
        if (componentBuilder_ == null) {
          component_ = null;
        } else {
          component_ = null;
          componentBuilder_ = null;
        }
        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.calcite.avatica.proto.Common.internal_static_AvaticaType_descriptor;
      }

      public org.apache.calcite.avatica.proto.Common.AvaticaType getDefaultInstanceForType() {
        return org.apache.calcite.avatica.proto.Common.AvaticaType.getDefaultInstance();
      }

      public org.apache.calcite.avatica.proto.Common.AvaticaType build() {
        org.apache.calcite.avatica.proto.Common.AvaticaType result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public org.apache.calcite.avatica.proto.Common.AvaticaType buildPartial() {
        org.apache.calcite.avatica.proto.Common.AvaticaType result = new org.apache.calcite.avatica.proto.Common.AvaticaType(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        result.id_ = id_;
        result.name_ = name_;
        result.rep_ = rep_;
        if (columnsBuilder_ == null) {
          if (((bitField0_ & 0x00000008) == 0x00000008)) {
            columns_ = java.util.Collections.unmodifiableList(columns_);
            bitField0_ = (bitField0_ & ~0x00000008);
          }
          result.columns_ = columns_;
        } else {
          result.columns_ = columnsBuilder_.build();
        }
        if (componentBuilder_ == null) {
          result.component_ = component_;
        } else {
          result.component_ = componentBuilder_.build();
        }
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.apache.calcite.avatica.proto.Common.AvaticaType) {
          return mergeFrom((org.apache.calcite.avatica.proto.Common.AvaticaType)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.calcite.avatica.proto.Common.AvaticaType other) {
        if (other == org.apache.calcite.avatica.proto.Common.AvaticaType.getDefaultInstance()) return this;
        if (other.getId() != 0) {
          setId(other.getId());
        }
        if (!other.getName().isEmpty()) {
          name_ = other.name_;
          onChanged();
        }
        if (other.rep_ != 0) {
          setRepValue(other.getRepValue());
        }
        if (columnsBuilder_ == null) {
          if (!other.columns_.isEmpty()) {
            if (columns_.isEmpty()) {
              columns_ = other.columns_;
              bitField0_ = (bitField0_ & ~0x00000008);
            } else {
              ensureColumnsIsMutable();
              columns_.addAll(other.columns_);
            }
            onChanged();
          }
        } else {
          if (!other.columns_.isEmpty()) {
            if (columnsBuilder_.isEmpty()) {
              columnsBuilder_.dispose();
              columnsBuilder_ = null;
              columns_ = other.columns_;
              bitField0_ = (bitField0_ & ~0x00000008);
              columnsBuilder_ = 
                com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders ?
                   getColumnsFieldBuilder() : null;
            } else {
              columnsBuilder_.addAllMessages(other.columns_);
            }
          }
        }
        if (other.hasComponent()) {
          mergeComponent(other.getComponent());
        }
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        org.apache.calcite.avatica.proto.Common.AvaticaType parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (org.apache.calcite.avatica.proto.Common.AvaticaType) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private int id_ ;
      /**
       * <code>optional uint32 id = 1;</code>
       */
      public int getId() {
        return id_;
      }
      /**
       * <code>optional uint32 id = 1;</code>
       */
      public Builder setId(int value) {
        
        id_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional uint32 id = 1;</code>
       */
      public Builder clearId() {
        
        id_ = 0;
        onChanged();
        return this;
      }

      private java.lang.Object name_ = "";
      /**
       * <code>optional string name = 2;</code>
       */
      public java.lang.String getName() {
        java.lang.Object ref = name_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          name_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>optional string name = 2;</code>
       */
      public com.google.protobuf.ByteString
          getNameBytes() {
        java.lang.Object ref = name_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          name_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>optional string name = 2;</code>
       */
      public Builder setName(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        name_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional string name = 2;</code>
       */
      public Builder clearName() {
        
        name_ = getDefaultInstance().getName();
        onChanged();
        return this;
      }
      /**
       * <code>optional string name = 2;</code>
       */
      public Builder setNameBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        name_ = value;
        onChanged();
        return this;
      }

      private int rep_ = 0;
      /**
       * <code>optional .Rep rep = 3;</code>
       */
      public int getRepValue() {
        return rep_;
      }
      /**
       * <code>optional .Rep rep = 3;</code>
       */
      public Builder setRepValue(int value) {
        rep_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional .Rep rep = 3;</code>
       */
      public org.apache.calcite.avatica.proto.Common.Rep getRep() {
        org.apache.calcite.avatica.proto.Common.Rep result = org.apache.calcite.avatica.proto.Common.Rep.valueOf(rep_);
        return result == null ? org.apache.calcite.avatica.proto.Common.Rep.UNRECOGNIZED : result;
      }
      /**
       * <code>optional .Rep rep = 3;</code>
       */
      public Builder setRep(org.apache.calcite.avatica.proto.Common.Rep value) {
        if (value == null) {
          throw new NullPointerException();
        }
        
        rep_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       * <code>optional .Rep rep = 3;</code>
       */
      public Builder clearRep() {
        
        rep_ = 0;
        onChanged();
        return this;
      }

      private java.util.List<org.apache.calcite.avatica.proto.Common.ColumnMetaData> columns_ =
        java.util.Collections.emptyList();
      private void ensureColumnsIsMutable() {
        if (!((bitField0_ & 0x00000008) == 0x00000008)) {
          columns_ = new java.util.ArrayList<org.apache.calcite.avatica.proto.Common.ColumnMetaData>(columns_);
          bitField0_ |= 0x00000008;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilder<
          org.apache.calcite.avatica.proto.Common.ColumnMetaData, org.apache.calcite.avatica.proto.Common.ColumnMetaData.Builder, org.apache.calcite.avatica.proto.Common.ColumnMetaDataOrBuilder> columnsBuilder_;

      /**
       * <code>repeated .ColumnMetaData columns = 4;</code>
       *
       * <pre>
       * Only present when name = STRUCT
       * </pre>
       */
      public java.util.List<org.apache.calcite.avatica.proto.Common.ColumnMetaData> getColumnsList() {
        if (columnsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(columns_);
        } else {
          return columnsBuilder_.getMessageList();
        }
      }
      /**
       * <code>repeated .ColumnMetaData columns = 4;</code>
       *
       * <pre>
       * Only present when name = STRUCT
       * </pre>
       */
      public int getColumnsCount() {
        if (columnsBuilder_ == null) {
          return columns_.size();
        } else {
          return columnsBuilder_.getCount();
        }
      }
      /**
       * <code>repeated .ColumnMetaData columns = 4;</code>
       *
       * <pre>
       * Only present when name = STRUCT
       * </pre>
       */
      public org.apache.calcite.avatica.proto.Common.ColumnMetaData getColumns(int index) {
        if (columnsBuilder_ == null) {
          return columns_.get(index);
        } else {
          return columnsBuilder_.getMessage(index);
        }
      }
      /**
       * <code>repeated .ColumnMetaData columns = 4;</code>
       *
       * <pre>
       * Only present when name = STRUCT
       * </pre>
       */
      public Builder setColumns(
          int index, org.apache.calcite.avatica.proto.Common.ColumnMetaData value) {
        if (columnsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureColumnsIsMutable();
          columns_.set(index, value);
          onChanged();
        } else {
          columnsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .ColumnMetaData columns = 4;</code>
       *
       * <pre>
       * Only present when name = STRUCT
       * </pre>
       */
      public Builder setColumns(
          int index, org.apache.calcite.avatica.proto.Common.ColumnMetaData.Builder builderForValue) {
        if (columnsBuilder_ == null) {
          ensureColumnsIsMutable();
          columns_.set(index, builderForValue.build());
          onChanged();
        } else {
          columnsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .ColumnMetaData columns = 4;</code>
       *
       * <pre>
       * Only present when name = STRUCT
       * </pre>
       */
      public Builder addColumns(org.apache.calcite.avatica.proto.Common.ColumnMetaData value) {
        if (columnsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureColumnsIsMutable();
          columns_.add(value);
          onChanged();
        } else {
          columnsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <code>repeated .ColumnMetaData columns = 4;</code>
       *
       * <pre>
       * Only present when name = STRUCT
       * </pre>
       */
      public Builder addColumns(
          int index, org.apache.calcite.avatica.proto.Common.ColumnMetaData value) {
        if (columnsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureColumnsIsMutable();
          columns_.add(index, value);
          onChanged();
        } else {
          columnsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .ColumnMetaData columns = 4;</code>
       *
       * <pre>
       * Only present when name = STRUCT
       * </pre>
       */
      public Builder addColumns(
          org.apache.calcite.avatica.proto.Common.ColumnMetaData.Builder builderForValue) {
        if (columnsBuilder_ == null) {
          ensureColumnsIsMutable();
          columns_.add(builderForValue.build());
          onChanged();
        } else {
          columnsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .ColumnMetaData columns = 4;</code>
       *
       * <pre>
       * Only present when name = STRUCT
       * </pre>
       */
      public Builder addColumns(
          int index, org.apache.calcite.avatica.proto.Common.ColumnMetaData.Builder builderForValue) {
        if (columnsBuilder_ == null) {
          ensureColumnsIsMutable();
          columns_.add(index, builderForValue.build());
          onChanged();
        } else {
          columnsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .ColumnMetaData columns = 4;</code>
       *
       * <pre>
       * Only present when name = STRUCT
       * </pre>
       */
      public Builder addAllColumns(
          java.lang.Iterable<? extends org.apache.calcite.avatica.proto.Common.ColumnMetaData> values) {
        if (columnsBuilder_ == null) {
          ensureColumnsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, columns_);
          onChanged();
        } else {
          columnsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <code>repeated .ColumnMetaData columns = 4;</code>
       *
       * <pre>
       * Only present when name = STRUCT
       * </pre>
       */
      public Builder clearColumns() {
        if (columnsBuilder_ == null) {
          columns_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000008);
          onChanged();
        } else {
          columnsBuilder_.clear();
        }
        return this;
      }
      /**
       * <code>repeated .ColumnMetaData columns = 4;</code>
       *
       * <pre>
       * Only present when name = STRUCT
       * </pre>
       */
      public Builder removeColumns(int index) {
        if (columnsBuilder_ == null) {
          ensureColumnsIsMutable();
          columns_.remove(index);
          onChanged();
        } else {
          columnsBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <code>repeated .ColumnMetaData columns = 4;</code>
       *
       * <pre>
       * Only present when name = STRUCT
       * </pre>
       */
      public org.apache.calcite.avatica.proto.Common.ColumnMetaData.Builder getColumnsBuilder(
          int index) {
        return getColumnsFieldBuilder().getBuilder(index);
      }
      /**
       * <code>repeated .ColumnMetaData columns = 4;</code>
       *
       * <pre>
       * Only present when name = STRUCT
       * </pre>
       */
      public org.apache.calcite.avatica.proto.Common.ColumnMetaDataOrBuilder getColumnsOrBuilder(
          int index) {
        if (columnsBuilder_ == null) {
          return columns_.get(index);  } else {
          return columnsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <code>repeated .ColumnMetaData columns = 4;</code>
       *
       * <pre>
       * Only present when name = STRUCT
       * </pre>
       */
      public java.util.List<? extends org.apache.calcite.avatica.proto.Common.ColumnMetaDataOrBuilder> 
           getColumnsOrBuilderList() {
        if (columnsBuilder_ != null) {
          return columnsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(columns_);
        }
      }
      /**
       * <code>repeated .ColumnMetaData columns = 4;</code>
       *
       * <pre>
       * Only present when name = STRUCT
       * </pre>
       */
      public org.apache.calcite.avatica.proto.Common.ColumnMetaData.Builder addColumnsBuilder() {
        return getColumnsFieldBuilder().addBuilder(
            org.apache.calcite.avatica.proto.Common.ColumnMetaData.getDefaultInstance());
      }
      /**
       * <code>repeated .ColumnMetaData columns = 4;</code>
       *
       * <pre>
       * Only present when name = STRUCT
       * </pre>
       */
      public org.apache.calcite.avatica.proto.Common.ColumnMetaData.Builder addColumnsBuilder(
          int index) {
        return getColumnsFieldBuilder().addBuilder(
            index, org.apache.calcite.avatica.proto.Common.ColumnMetaData.getDefaultInstance());
      }
      /**
       * <code>repeated .ColumnMetaData columns = 4;</code>
       *
       * <pre>
       * Only present when name = STRUCT
       * </pre>
       */
      public java.util.List<org.apache.calcite.avatica.proto.Common.ColumnMetaData.Builder> 
           getColumnsBuilderList() {
        return getColumnsFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilder<
          org.apache.calcite.avatica.proto.Common.ColumnMetaData, org.apache.calcite.avatica.proto.Common.ColumnMetaData.Builder, org.apache.calcite.avatica.proto.Common.ColumnMetaDataOrBuilder> 
          getColumnsFieldBuilder() {
        if (columnsBuilder_ == null) {
          columnsBuilder_ = new com.google.protobuf.RepeatedFieldBuilder<
              org.apache.calcite.avatica.proto.Common.ColumnMetaData, org.apache.calcite.avatica.proto.Common.ColumnMetaData.Builder, org.apache.calcite.avatica.proto.Common.ColumnMetaDataOrBuilder>(
                  columns_,
                  ((bitField0_ & 0x00000008) == 0x00000008),
                  getParentForChildren(),
                  isClean());
          columns_ = null;
        }
        return columnsBuilder_;
      }

      private org.apache.calcite.avatica.proto.Common.AvaticaType component_ = null;
      private com.google.protobuf.SingleFieldBuilder<
          org.apache.calcite.avatica.proto.Common.AvaticaType, org.apache.calcite.avatica.proto.Common.AvaticaType.Builder, org.apache.calcite.avatica.proto.Common.AvaticaTypeOrBuilder> componentBuilder_;
      /**
       * <code>optional .AvaticaType component = 5;</code>
       *
       * <pre>
       * Only present when name = ARRAY
       * </pre>
       */
      public boolean hasComponent() {
        return componentBuilder_ != null || component_ != null;
      }
      /**
       * <code>optional .AvaticaType component = 5;</code>
       *
       * <pre>
       * Only present when name = ARRAY
       * </pre>
       */
      public org.apache.calcite.avatica.proto.Common.AvaticaType getComponent() {
        if (componentBuilder_ == null) {
          return component_ == null ? org.apache.calcite.avatica.proto.Common.AvaticaType.getDefaultInstance() : component_;
        } else {
          return componentBuilder_.getMessage();
        }
      }
      /**
       * <code>optional .AvaticaType component = 5;</code>
       *
       * <pre>
       * Only present when name = ARRAY
       * </pre>
       */
      public Builder setComponent(org.apache.calcite.avatica.proto.Common.AvaticaType value) {
        if (componentBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          component_ = value;
          onChanged();
        } else {
          componentBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <code>optional .AvaticaType component = 5;</code>
       *
       * <pre>
       * Only present when name = ARRAY
       * </pre>
       */
      public Builder setComponent(
          org.apache.calcite.avatica.proto.Common.AvaticaType.Builder builderForValue) {
        if (componentBuilder_ == null) {
          component_ = builderForValue.build();
          onChanged();
        } else {
          componentBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <code>optional .AvaticaType component = 5;</code>
       *
       * <pre>
       * Only present when name = ARRAY
       * </pre>
       */
      public Builder mergeComponent(org.apache.calcite.avatica.proto.Common.AvaticaType value) {
        if (componentBuilder_ == null) {
          if (component_ != null) {
            component_ =
              org.apache.calcite.avatica.proto.Common.AvaticaType.newBuilder(component_).mergeFrom(value).buildPartial();
          } else {
            component_ = value;
          }
          onChanged();
        } else {
          componentBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <code>optional .AvaticaType component = 5;</code>
       *
       * <pre>
       * Only present when name = ARRAY
       * </pre>
       */
      public Builder clearComponent() {
        if (componentBuilder_ == null) {
          component_ = null;
          onChanged();
        } else {
          component_ = null;
          componentBuilder_ = null;
        }

        return this;
      }
      /**
       * <code>optional .AvaticaType component = 5;</code>
       *
       * <pre>
       * Only present when name = ARRAY
       * </pre>
       */
      public org.apache.calcite.avatica.proto.Common.AvaticaType.Builder getComponentBuilder() {
        
        onChanged();
        return getComponentFieldBuilder().getBuilder();
      }
      /**
       * <code>optional .AvaticaType component = 5;</code>
       *
       * <pre>
       * Only present when name = ARRAY
       * </pre>
       */
      public org.apache.calcite.avatica.proto.Common.AvaticaTypeOrBuilder getComponentOrBuilder() {
        if (componentBuilder_ != null) {
          return componentBuilder_.getMessageOrBuilder();
        } else {
          return component_ == null ?
              org.apache.calcite.avatica.proto.Common.AvaticaType.getDefaultInstance() : component_;
        }
      }
      /**
       * <code>optional .AvaticaType component = 5;</code>
       *
       * <pre>
       * Only present when name = ARRAY
       * </pre>
       */
      private com.google.protobuf.SingleFieldBuilder<
          org.apache.calcite.avatica.proto.Common.AvaticaType, org.apache.calcite.avatica.proto.Common.AvaticaType.Builder, org.apache.calcite.avatica.proto.Common.AvaticaTypeOrBuilder> 
          getComponentFieldBuilder() {
        if (componentBuilder_ == null) {
          componentBuilder_ = new com.google.protobuf.SingleFieldBuilder<
              org.apache.calcite.avatica.proto.Common.AvaticaType, org.apache.calcite.avatica.proto.Common.AvaticaType.Builder, org.apache.calcite.avatica.proto.Common.AvaticaTypeOrBuilder>(
                  getComponent(),
                  getParentForChildren(),
                  isClean());
          component_ = null;
        }
        return componentBuilder_;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return this;
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return this;
      }


      // @@protoc_insertion_point(builder_scope:AvaticaType)
    }

    // @@protoc_insertion_point(class_scope:AvaticaType)
    private static final org.apache.calcite.avatica.proto.Common.AvaticaType DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.apache.calcite.avatica.proto.Common.AvaticaType();
    }

    public static org.apache.calcite.avatica.proto.Common.AvaticaType getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<AvaticaType>
        PARSER = new com.google.protobuf.AbstractParser<AvaticaType>() {
      public AvaticaType parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        try {
          return new AvaticaType(input, extensionRegistry);
        } catch (RuntimeException e) {
          if (e.getCause() instanceof
              com.google.protobuf.InvalidProtocolBufferException) {
            throw (com.google.protobuf.InvalidProtocolBufferException)
                e.getCause();
          }
          throw e;
        }
      }
    };

    public static com.google.protobuf.Parser<AvaticaType> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<AvaticaType> getParserForType() {
      return PARSER;
    }

    public org.apache.calcite.avatica.proto.Common.AvaticaType getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface AvaticaParameterOrBuilder extends
      // @@protoc_insertion_point(interface_extends:AvaticaParameter)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>optional bool signed = 1;</code>
     */
    boolean getSigned();

    /**
     * <code>optional uint32 precision = 2;</code>
     */
    int getPrecision();

    /**
     * <code>optional uint32 scale = 3;</code>
     */
    int getScale();

    /**
     * <code>optional uint32 parameter_type = 4;</code>
     */
    int getParameterType();

    /**
     * <code>optional string type_name = 5;</code>
     */
    java.lang.String getTypeName();
    /**
     * <code>optional string type_name = 5;</code>
     */
    com.google.protobuf.ByteString
        getTypeNameBytes();

    /**
     * <code>optional string class_name = 6;</code>
     */
    java.lang.String getClassName();
    /**
     * <code>optional string class_name = 6;</code>
     */
    com.google.protobuf.ByteString
        getClassNameBytes();

    /**
     * <code>optional string name = 7;</code>
     */
    java.lang.String getName();
    /**
     * <code>optional string name = 7;</code>
     */
    com.google.protobuf.ByteString
        getNameBytes();
  }
  /**
   * Protobuf type {@code AvaticaParameter}
   *
   * <pre>
   * Metadata for a parameter
   * </pre>
   */
  public  static final class AvaticaParameter extends
      com.google.protobuf.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:AvaticaParameter)
      AvaticaParameterOrBuilder {
    // Use AvaticaParameter.newBuilder() to construct.
    private AvaticaParameter(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
    }
    private AvaticaParameter() {
      signed_ = false;
      precision_ = 0;
      scale_ = 0;
      parameterType_ = 0;
      typeName_ = "";
      className_ = "";
      name_ = "";
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return com.google.protobuf.UnknownFieldSet.getDefaultInstance();
    }
    private AvaticaParameter(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry) {
      this();
      int mutable_bitField0_ = 0;
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!input.skipField(tag)) {
                done = true;
              }
              break;
            }
            case 8: {

              signed_ = input.readBool();
              break;
            }
            case 16: {

              precision_ = input.readUInt32();
              break;
            }
            case 24: {

              scale_ = input.readUInt32();
              break;
            }
            case 32: {

              parameterType_ = input.readUInt32();
              break;
            }
            case 42: {
              String s = input.readStringRequireUtf8();

              typeName_ = s;
              break;
            }
            case 50: {
              String s = input.readStringRequireUtf8();

              className_ = s;
              break;
            }
            case 58: {
              String s = input.readStringRequireUtf8();

              name_ = s;
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw new RuntimeException(e.setUnfinishedMessage(this));
      } catch (java.io.IOException e) {
        throw new RuntimeException(
            new com.google.protobuf.InvalidProtocolBufferException(
                e.getMessage()).setUnfinishedMessage(this));
      } finally {
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.calcite.avatica.proto.Common.internal_static_AvaticaParameter_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.calcite.avatica.proto.Common.internal_static_AvaticaParameter_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.calcite.avatica.proto.Common.AvaticaParameter.class, org.apache.calcite.avatica.proto.Common.AvaticaParameter.Builder.class);
    }

    public static final int SIGNED_FIELD_NUMBER = 1;
    private boolean signed_;
    /**
     * <code>optional bool signed = 1;</code>
     */
    public boolean getSigned() {
      return signed_;
    }

    public static final int PRECISION_FIELD_NUMBER = 2;
    private int precision_;
    /**
     * <code>optional uint32 precision = 2;</code>
     */
    public int getPrecision() {
      return precision_;
    }

    public static final int SCALE_FIELD_NUMBER = 3;
    private int scale_;
    /**
     * <code>optional uint32 scale = 3;</code>
     */
    public int getScale() {
      return scale_;
    }

    public static final int PARAMETER_TYPE_FIELD_NUMBER = 4;
    private int parameterType_;
    /**
     * <code>optional uint32 parameter_type = 4;</code>
     */
    public int getParameterType() {
      return parameterType_;
    }

    public static final int TYPE_NAME_FIELD_NUMBER = 5;
    private volatile java.lang.Object typeName_;
    /**
     * <code>optional string type_name = 5;</code>
     */
    public java.lang.String getTypeName() {
      java.lang.Object ref = typeName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        typeName_ = s;
        return s;
      }
    }
    /**
     * <code>optional string type_name = 5;</code>
     */
    public com.google.protobuf.ByteString
        getTypeNameBytes() {
      java.lang.Object ref = typeName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        typeName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int CLASS_NAME_FIELD_NUMBER = 6;
    private volatile java.lang.Object className_;
    /**
     * <code>optional string class_name = 6;</code>
     */
    public java.lang.String getClassName() {
      java.lang.Object ref = className_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        className_ = s;
        return s;
      }
    }
    /**
     * <code>optional string class_name = 6;</code>
     */
    public com.google.protobuf.ByteString
        getClassNameBytes() {
      java.lang.Object ref = className_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        className_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int NAME_FIELD_NUMBER = 7;
    private volatile java.lang.Object name_;
    /**
     * <code>optional string name = 7;</code>
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      }
    }
    /**
     * <code>optional string name = 7;</code>
     */
    public com.google.protobuf.ByteString
        getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (signed_ != false) {
        output.writeBool(1, signed_);
      }
      if (precision_ != 0) {
        output.writeUInt32(2, precision_);
      }
      if (scale_ != 0) {
        output.writeUInt32(3, scale_);
      }
      if (parameterType_ != 0) {
        output.writeUInt32(4, parameterType_);
      }
      if (!getTypeNameBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessage.writeString(output, 5, typeName_);
      }
      if (!getClassNameBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessage.writeString(output, 6, className_);
      }
      if (!getNameBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessage.writeString(output, 7, name_);
      }
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (signed_ != false) {
        size += com.google.protobuf.CodedOutputStream
          .computeBoolSize(1, signed_);
      }
      if (precision_ != 0) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt32Size(2, precision_);
      }
      if (scale_ != 0) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt32Size(3, scale_);
      }
      if (parameterType_ != 0) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt32Size(4, parameterType_);
      }
      if (!getTypeNameBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessage.computeStringSize(5, typeName_);
      }
      if (!getClassNameBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessage.computeStringSize(6, className_);
      }
      if (!getNameBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessage.computeStringSize(7, name_);
      }
      memoizedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    public static org.apache.calcite.avatica.proto.Common.AvaticaParameter parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.calcite.avatica.proto.Common.AvaticaParameter parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.calcite.avatica.proto.Common.AvaticaParameter parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.calcite.avatica.proto.Common.AvaticaParameter parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.calcite.avatica.proto.Common.AvaticaParameter parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.calcite.avatica.proto.Common.AvaticaParameter parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static org.apache.calcite.avatica.proto.Common.AvaticaParameter parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static org.apache.calcite.avatica.proto.Common.AvaticaParameter parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static org.apache.calcite.avatica.proto.Common.AvaticaParameter parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.calcite.avatica.proto.Common.AvaticaParameter parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.apache.calcite.avatica.proto.Common.AvaticaParameter prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code AvaticaParameter}
     *
     * <pre>
     * Metadata for a parameter
     * </pre>
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:AvaticaParameter)
        org.apache.calcite.avatica.proto.Common.AvaticaParameterOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.calcite.avatica.proto.Common.internal_static_AvaticaParameter_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.calcite.avatica.proto.Common.internal_static_AvaticaParameter_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.calcite.avatica.proto.Common.AvaticaParameter.class, org.apache.calcite.avatica.proto.Common.AvaticaParameter.Builder.class);
      }

      // Construct using org.apache.calcite.avatica.proto.Common.AvaticaParameter.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
        }
      }
      public Builder clear() {
        super.clear();
        signed_ = false;

        precision_ = 0;

        scale_ = 0;

        parameterType_ = 0;

        typeName_ = "";

        className_ = "";

        name_ = "";

        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.calcite.avatica.proto.Common.internal_static_AvaticaParameter_descriptor;
      }

      public org.apache.calcite.avatica.proto.Common.AvaticaParameter getDefaultInstanceForType() {
        return org.apache.calcite.avatica.proto.Common.AvaticaParameter.getDefaultInstance();
      }

      public org.apache.calcite.avatica.proto.Common.AvaticaParameter build() {
        org.apache.calcite.avatica.proto.Common.AvaticaParameter result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public org.apache.calcite.avatica.proto.Common.AvaticaParameter buildPartial() {
        org.apache.calcite.avatica.proto.Common.AvaticaParameter result = new org.apache.calcite.avatica.proto.Common.AvaticaParameter(this);
        result.signed_ = signed_;
        result.precision_ = precision_;
        result.scale_ = scale_;
        result.parameterType_ = parameterType_;
        result.typeName_ = typeName_;
        result.className_ = className_;
        result.name_ = name_;
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.apache.calcite.avatica.proto.Common.AvaticaParameter) {
          return mergeFrom((org.apache.calcite.avatica.proto.Common.AvaticaParameter)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.calcite.avatica.proto.Common.AvaticaParameter other) {
        if (other == org.apache.calcite.avatica.proto.Common.AvaticaParameter.getDefaultInstance()) return this;
        if (other.getSigned() != false) {
          setSigned(other.getSigned());
        }
        if (other.getPrecision() != 0) {
          setPrecision(other.getPrecision());
        }
        if (other.getScale() != 0) {
          setScale(other.getScale());
        }
        if (other.getParameterType() != 0) {
          setParameterType(other.getParameterType());
        }
        if (!other.getTypeName().isEmpty()) {
          typeName_ = other.typeName_;
          onChanged();
        }
        if (!other.getClassName().isEmpty()) {
          className_ = other.className_;
          onChanged();
        }
        if (!other.getName().isEmpty()) {
          name_ = other.name_;
          onChanged();
        }
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        org.apache.calcite.avatica.proto.Common.AvaticaParameter parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (org.apache.calcite.avatica.proto.Common.AvaticaParameter) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private boolean signed_ ;
      /**
       * <code>optional bool signed = 1;</code>
       */
      public boolean getSigned() {
        return signed_;
      }
      /**
       * <code>optional bool signed = 1;</code>
       */
      public Builder setSigned(boolean value) {
        
        signed_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional bool signed = 1;</code>
       */
      public Builder clearSigned() {
        
        signed_ = false;
        onChanged();
        return this;
      }

      private int precision_ ;
      /**
       * <code>optional uint32 precision = 2;</code>
       */
      public int getPrecision() {
        return precision_;
      }
      /**
       * <code>optional uint32 precision = 2;</code>
       */
      public Builder setPrecision(int value) {
        
        precision_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional uint32 precision = 2;</code>
       */
      public Builder clearPrecision() {
        
        precision_ = 0;
        onChanged();
        return this;
      }

      private int scale_ ;
      /**
       * <code>optional uint32 scale = 3;</code>
       */
      public int getScale() {
        return scale_;
      }
      /**
       * <code>optional uint32 scale = 3;</code>
       */
      public Builder setScale(int value) {
        
        scale_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional uint32 scale = 3;</code>
       */
      public Builder clearScale() {
        
        scale_ = 0;
        onChanged();
        return this;
      }

      private int parameterType_ ;
      /**
       * <code>optional uint32 parameter_type = 4;</code>
       */
      public int getParameterType() {
        return parameterType_;
      }
      /**
       * <code>optional uint32 parameter_type = 4;</code>
       */
      public Builder setParameterType(int value) {
        
        parameterType_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional uint32 parameter_type = 4;</code>
       */
      public Builder clearParameterType() {
        
        parameterType_ = 0;
        onChanged();
        return this;
      }

      private java.lang.Object typeName_ = "";
      /**
       * <code>optional string type_name = 5;</code>
       */
      public java.lang.String getTypeName() {
        java.lang.Object ref = typeName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          typeName_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>optional string type_name = 5;</code>
       */
      public com.google.protobuf.ByteString
          getTypeNameBytes() {
        java.lang.Object ref = typeName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          typeName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>optional string type_name = 5;</code>
       */
      public Builder setTypeName(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        typeName_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional string type_name = 5;</code>
       */
      public Builder clearTypeName() {
        
        typeName_ = getDefaultInstance().getTypeName();
        onChanged();
        return this;
      }
      /**
       * <code>optional string type_name = 5;</code>
       */
      public Builder setTypeNameBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        typeName_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object className_ = "";
      /**
       * <code>optional string class_name = 6;</code>
       */
      public java.lang.String getClassName() {
        java.lang.Object ref = className_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          className_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>optional string class_name = 6;</code>
       */
      public com.google.protobuf.ByteString
          getClassNameBytes() {
        java.lang.Object ref = className_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          className_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>optional string class_name = 6;</code>
       */
      public Builder setClassName(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        className_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional string class_name = 6;</code>
       */
      public Builder clearClassName() {
        
        className_ = getDefaultInstance().getClassName();
        onChanged();
        return this;
      }
      /**
       * <code>optional string class_name = 6;</code>
       */
      public Builder setClassNameBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        className_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object name_ = "";
      /**
       * <code>optional string name = 7;</code>
       */
      public java.lang.String getName() {
        java.lang.Object ref = name_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          name_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>optional string name = 7;</code>
       */
      public com.google.protobuf.ByteString
          getNameBytes() {
        java.lang.Object ref = name_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          name_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>optional string name = 7;</code>
       */
      public Builder setName(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        name_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional string name = 7;</code>
       */
      public Builder clearName() {
        
        name_ = getDefaultInstance().getName();
        onChanged();
        return this;
      }
      /**
       * <code>optional string name = 7;</code>
       */
      public Builder setNameBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        name_ = value;
        onChanged();
        return this;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return this;
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return this;
      }


      // @@protoc_insertion_point(builder_scope:AvaticaParameter)
    }

    // @@protoc_insertion_point(class_scope:AvaticaParameter)
    private static final org.apache.calcite.avatica.proto.Common.AvaticaParameter DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.apache.calcite.avatica.proto.Common.AvaticaParameter();
    }

    public static org.apache.calcite.avatica.proto.Common.AvaticaParameter getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<AvaticaParameter>
        PARSER = new com.google.protobuf.AbstractParser<AvaticaParameter>() {
      public AvaticaParameter parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        try {
          return new AvaticaParameter(input, extensionRegistry);
        } catch (RuntimeException e) {
          if (e.getCause() instanceof
              com.google.protobuf.InvalidProtocolBufferException) {
            throw (com.google.protobuf.InvalidProtocolBufferException)
                e.getCause();
          }
          throw e;
        }
      }
    };

    public static com.google.protobuf.Parser<AvaticaParameter> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<AvaticaParameter> getParserForType() {
      return PARSER;
    }

    public org.apache.calcite.avatica.proto.Common.AvaticaParameter getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface CursorFactoryOrBuilder extends
      // @@protoc_insertion_point(interface_extends:CursorFactory)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>optional .CursorFactory.Style style = 1;</code>
     */
    int getStyleValue();
    /**
     * <code>optional .CursorFactory.Style style = 1;</code>
     */
    org.apache.calcite.avatica.proto.Common.CursorFactory.Style getStyle();

    /**
     * <code>optional string class_name = 2;</code>
     */
    java.lang.String getClassName();
    /**
     * <code>optional string class_name = 2;</code>
     */
    com.google.protobuf.ByteString
        getClassNameBytes();

    /**
     * <code>repeated string field_names = 3;</code>
     */
    com.google.protobuf.ProtocolStringList
        getFieldNamesList();
    /**
     * <code>repeated string field_names = 3;</code>
     */
    int getFieldNamesCount();
    /**
     * <code>repeated string field_names = 3;</code>
     */
    java.lang.String getFieldNames(int index);
    /**
     * <code>repeated string field_names = 3;</code>
     */
    com.google.protobuf.ByteString
        getFieldNamesBytes(int index);
  }
  /**
   * Protobuf type {@code CursorFactory}
   *
   * <pre>
   * Information necessary to convert an Iterable into a Calcite Cursor
   * </pre>
   */
  public  static final class CursorFactory extends
      com.google.protobuf.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:CursorFactory)
      CursorFactoryOrBuilder {
    // Use CursorFactory.newBuilder() to construct.
    private CursorFactory(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
    }
    private CursorFactory() {
      style_ = 0;
      className_ = "";
      fieldNames_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return com.google.protobuf.UnknownFieldSet.getDefaultInstance();
    }
    private CursorFactory(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry) {
      this();
      int mutable_bitField0_ = 0;
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!input.skipField(tag)) {
                done = true;
              }
              break;
            }
            case 8: {
              int rawValue = input.readEnum();

              style_ = rawValue;
              break;
            }
            case 18: {
              String s = input.readStringRequireUtf8();

              className_ = s;
              break;
            }
            case 26: {
              String s = input.readStringRequireUtf8();
              if (!((mutable_bitField0_ & 0x00000004) == 0x00000004)) {
                fieldNames_ = new com.google.protobuf.LazyStringArrayList();
                mutable_bitField0_ |= 0x00000004;
              }
              fieldNames_.add(s);
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw new RuntimeException(e.setUnfinishedMessage(this));
      } catch (java.io.IOException e) {
        throw new RuntimeException(
            new com.google.protobuf.InvalidProtocolBufferException(
                e.getMessage()).setUnfinishedMessage(this));
      } finally {
        if (((mutable_bitField0_ & 0x00000004) == 0x00000004)) {
          fieldNames_ = fieldNames_.getUnmodifiableView();
        }
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.calcite.avatica.proto.Common.internal_static_CursorFactory_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.calcite.avatica.proto.Common.internal_static_CursorFactory_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.calcite.avatica.proto.Common.CursorFactory.class, org.apache.calcite.avatica.proto.Common.CursorFactory.Builder.class);
    }

    /**
     * Protobuf enum {@code CursorFactory.Style}
     */
    public enum Style
        implements com.google.protobuf.ProtocolMessageEnum {
      /**
       * <code>OBJECT = 0;</code>
       */
      OBJECT(0, 0),
      /**
       * <code>RECORD = 1;</code>
       */
      RECORD(1, 1),
      /**
       * <code>RECORD_PROJECTION = 2;</code>
       */
      RECORD_PROJECTION(2, 2),
      /**
       * <code>ARRAY = 3;</code>
       */
      ARRAY(3, 3),
      /**
       * <code>LIST = 4;</code>
       */
      LIST(4, 4),
      /**
       * <code>MAP = 5;</code>
       */
      MAP(5, 5),
      UNRECOGNIZED(-1, -1),
      ;

      /**
       * <code>OBJECT = 0;</code>
       */
      public static final int OBJECT_VALUE = 0;
      /**
       * <code>RECORD = 1;</code>
       */
      public static final int RECORD_VALUE = 1;
      /**
       * <code>RECORD_PROJECTION = 2;</code>
       */
      public static final int RECORD_PROJECTION_VALUE = 2;
      /**
       * <code>ARRAY = 3;</code>
       */
      public static final int ARRAY_VALUE = 3;
      /**
       * <code>LIST = 4;</code>
       */
      public static final int LIST_VALUE = 4;
      /**
       * <code>MAP = 5;</code>
       */
      public static final int MAP_VALUE = 5;


      public final int getNumber() {
        if (index == -1) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      public static Style valueOf(int value) {
        switch (value) {
          case 0: return OBJECT;
          case 1: return RECORD;
          case 2: return RECORD_PROJECTION;
          case 3: return ARRAY;
          case 4: return LIST;
          case 5: return MAP;
          default: return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<Style>
          internalGetValueMap() {
        return internalValueMap;
      }
      private static final com.google.protobuf.Internal.EnumLiteMap<
          Style> internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<Style>() {
              public Style findValueByNumber(int number) {
                return Style.valueOf(number);
              }
            };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor
          getValueDescriptor() {
        return getDescriptor().getValues().get(index);
      }
      public final com.google.protobuf.Descriptors.EnumDescriptor
          getDescriptorForType() {
        return getDescriptor();
      }
      public static final com.google.protobuf.Descriptors.EnumDescriptor
          getDescriptor() {
        return org.apache.calcite.avatica.proto.Common.CursorFactory.getDescriptor().getEnumTypes().get(0);
      }

      private static final Style[] VALUES = values();

      public static Style valueOf(
          com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException(
            "EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int index;
      private final int value;

      private Style(int index, int value) {
        this.index = index;
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:CursorFactory.Style)
    }

    private int bitField0_;
    public static final int STYLE_FIELD_NUMBER = 1;
    private int style_;
    /**
     * <code>optional .CursorFactory.Style style = 1;</code>
     */
    public int getStyleValue() {
      return style_;
    }
    /**
     * <code>optional .CursorFactory.Style style = 1;</code>
     */
    public org.apache.calcite.avatica.proto.Common.CursorFactory.Style getStyle() {
      org.apache.calcite.avatica.proto.Common.CursorFactory.Style result = org.apache.calcite.avatica.proto.Common.CursorFactory.Style.valueOf(style_);
      return result == null ? org.apache.calcite.avatica.proto.Common.CursorFactory.Style.UNRECOGNIZED : result;
    }

    public static final int CLASS_NAME_FIELD_NUMBER = 2;
    private volatile java.lang.Object className_;
    /**
     * <code>optional string class_name = 2;</code>
     */
    public java.lang.String getClassName() {
      java.lang.Object ref = className_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        className_ = s;
        return s;
      }
    }
    /**
     * <code>optional string class_name = 2;</code>
     */
    public com.google.protobuf.ByteString
        getClassNameBytes() {
      java.lang.Object ref = className_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        className_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int FIELD_NAMES_FIELD_NUMBER = 3;
    private com.google.protobuf.LazyStringList fieldNames_;
    /**
     * <code>repeated string field_names = 3;</code>
     */
    public com.google.protobuf.ProtocolStringList
        getFieldNamesList() {
      return fieldNames_;
    }
    /**
     * <code>repeated string field_names = 3;</code>
     */
    public int getFieldNamesCount() {
      return fieldNames_.size();
    }
    /**
     * <code>repeated string field_names = 3;</code>
     */
    public java.lang.String getFieldNames(int index) {
      return fieldNames_.get(index);
    }
    /**
     * <code>repeated string field_names = 3;</code>
     */
    public com.google.protobuf.ByteString
        getFieldNamesBytes(int index) {
      return fieldNames_.getByteString(index);
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (style_ != org.apache.calcite.avatica.proto.Common.CursorFactory.Style.OBJECT.getNumber()) {
        output.writeEnum(1, style_);
      }
      if (!getClassNameBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessage.writeString(output, 2, className_);
      }
      for (int i = 0; i < fieldNames_.size(); i++) {
        com.google.protobuf.GeneratedMessage.writeString(output, 3, fieldNames_.getRaw(i));
      }
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (style_ != org.apache.calcite.avatica.proto.Common.CursorFactory.Style.OBJECT.getNumber()) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(1, style_);
      }
      if (!getClassNameBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessage.computeStringSize(2, className_);
      }
      {
        int dataSize = 0;
        for (int i = 0; i < fieldNames_.size(); i++) {
          dataSize += computeStringSizeNoTag(fieldNames_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getFieldNamesList().size();
      }
      memoizedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    public static org.apache.calcite.avatica.proto.Common.CursorFactory parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.calcite.avatica.proto.Common.CursorFactory parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.calcite.avatica.proto.Common.CursorFactory parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.calcite.avatica.proto.Common.CursorFactory parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.calcite.avatica.proto.Common.CursorFactory parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.calcite.avatica.proto.Common.CursorFactory parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static org.apache.calcite.avatica.proto.Common.CursorFactory parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static org.apache.calcite.avatica.proto.Common.CursorFactory parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static org.apache.calcite.avatica.proto.Common.CursorFactory parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.calcite.avatica.proto.Common.CursorFactory parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.apache.calcite.avatica.proto.Common.CursorFactory prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code CursorFactory}
     *
     * <pre>
     * Information necessary to convert an Iterable into a Calcite Cursor
     * </pre>
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:CursorFactory)
        org.apache.calcite.avatica.proto.Common.CursorFactoryOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.calcite.avatica.proto.Common.internal_static_CursorFactory_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.calcite.avatica.proto.Common.internal_static_CursorFactory_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.calcite.avatica.proto.Common.CursorFactory.class, org.apache.calcite.avatica.proto.Common.CursorFactory.Builder.class);
      }

      // Construct using org.apache.calcite.avatica.proto.Common.CursorFactory.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
        }
      }
      public Builder clear() {
        super.clear();
        style_ = 0;

        className_ = "";

        fieldNames_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000004);
        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.calcite.avatica.proto.Common.internal_static_CursorFactory_descriptor;
      }

      public org.apache.calcite.avatica.proto.Common.CursorFactory getDefaultInstanceForType() {
        return org.apache.calcite.avatica.proto.Common.CursorFactory.getDefaultInstance();
      }

      public org.apache.calcite.avatica.proto.Common.CursorFactory build() {
        org.apache.calcite.avatica.proto.Common.CursorFactory result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public org.apache.calcite.avatica.proto.Common.CursorFactory buildPartial() {
        org.apache.calcite.avatica.proto.Common.CursorFactory result = new org.apache.calcite.avatica.proto.Common.CursorFactory(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        result.style_ = style_;
        result.className_ = className_;
        if (((bitField0_ & 0x00000004) == 0x00000004)) {
          fieldNames_ = fieldNames_.getUnmodifiableView();
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.fieldNames_ = fieldNames_;
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.apache.calcite.avatica.proto.Common.CursorFactory) {
          return mergeFrom((org.apache.calcite.avatica.proto.Common.CursorFactory)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.calcite.avatica.proto.Common.CursorFactory other) {
        if (other == org.apache.calcite.avatica.proto.Common.CursorFactory.getDefaultInstance()) return this;
        if (other.style_ != 0) {
          setStyleValue(other.getStyleValue());
        }
        if (!other.getClassName().isEmpty()) {
          className_ = other.className_;
          onChanged();
        }
        if (!other.fieldNames_.isEmpty()) {
          if (fieldNames_.isEmpty()) {
            fieldNames_ = other.fieldNames_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureFieldNamesIsMutable();
            fieldNames_.addAll(other.fieldNames_);
          }
          onChanged();
        }
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        org.apache.calcite.avatica.proto.Common.CursorFactory parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (org.apache.calcite.avatica.proto.Common.CursorFactory) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private int style_ = 0;
      /**
       * <code>optional .CursorFactory.Style style = 1;</code>
       */
      public int getStyleValue() {
        return style_;
      }
      /**
       * <code>optional .CursorFactory.Style style = 1;</code>
       */
      public Builder setStyleValue(int value) {
        style_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional .CursorFactory.Style style = 1;</code>
       */
      public org.apache.calcite.avatica.proto.Common.CursorFactory.Style getStyle() {
        org.apache.calcite.avatica.proto.Common.CursorFactory.Style result = org.apache.calcite.avatica.proto.Common.CursorFactory.Style.valueOf(style_);
        return result == null ? org.apache.calcite.avatica.proto.Common.CursorFactory.Style.UNRECOGNIZED : result;
      }
      /**
       * <code>optional .CursorFactory.Style style = 1;</code>
       */
      public Builder setStyle(org.apache.calcite.avatica.proto.Common.CursorFactory.Style value) {
        if (value == null) {
          throw new NullPointerException();
        }
        
        style_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       * <code>optional .CursorFactory.Style style = 1;</code>
       */
      public Builder clearStyle() {
        
        style_ = 0;
        onChanged();
        return this;
      }

      private java.lang.Object className_ = "";
      /**
       * <code>optional string class_name = 2;</code>
       */
      public java.lang.String getClassName() {
        java.lang.Object ref = className_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          className_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>optional string class_name = 2;</code>
       */
      public com.google.protobuf.ByteString
          getClassNameBytes() {
        java.lang.Object ref = className_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          className_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>optional string class_name = 2;</code>
       */
      public Builder setClassName(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        className_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional string class_name = 2;</code>
       */
      public Builder clearClassName() {
        
        className_ = getDefaultInstance().getClassName();
        onChanged();
        return this;
      }
      /**
       * <code>optional string class_name = 2;</code>
       */
      public Builder setClassNameBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        className_ = value;
        onChanged();
        return this;
      }

      private com.google.protobuf.LazyStringList fieldNames_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      private void ensureFieldNamesIsMutable() {
        if (!((bitField0_ & 0x00000004) == 0x00000004)) {
          fieldNames_ = new com.google.protobuf.LazyStringArrayList(fieldNames_);
          bitField0_ |= 0x00000004;
         }
      }
      /**
       * <code>repeated string field_names = 3;</code>
       */
      public com.google.protobuf.ProtocolStringList
          getFieldNamesList() {
        return fieldNames_.getUnmodifiableView();
      }
      /**
       * <code>repeated string field_names = 3;</code>
       */
      public int getFieldNamesCount() {
        return fieldNames_.size();
      }
      /**
       * <code>repeated string field_names = 3;</code>
       */
      public java.lang.String getFieldNames(int index) {
        return fieldNames_.get(index);
      }
      /**
       * <code>repeated string field_names = 3;</code>
       */
      public com.google.protobuf.ByteString
          getFieldNamesBytes(int index) {
        return fieldNames_.getByteString(index);
      }
      /**
       * <code>repeated string field_names = 3;</code>
       */
      public Builder setFieldNames(
          int index, java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  ensureFieldNamesIsMutable();
        fieldNames_.set(index, value);
        onChanged();
        return this;
      }
      /**
       * <code>repeated string field_names = 3;</code>
       */
      public Builder addFieldNames(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  ensureFieldNamesIsMutable();
        fieldNames_.add(value);
        onChanged();
        return this;
      }
      /**
       * <code>repeated string field_names = 3;</code>
       */
      public Builder addAllFieldNames(
          java.lang.Iterable<java.lang.String> values) {
        ensureFieldNamesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, fieldNames_);
        onChanged();
        return this;
      }
      /**
       * <code>repeated string field_names = 3;</code>
       */
      public Builder clearFieldNames() {
        fieldNames_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }
      /**
       * <code>repeated string field_names = 3;</code>
       */
      public Builder addFieldNamesBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        ensureFieldNamesIsMutable();
        fieldNames_.add(value);
        onChanged();
        return this;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return this;
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return this;
      }


      // @@protoc_insertion_point(builder_scope:CursorFactory)
    }

    // @@protoc_insertion_point(class_scope:CursorFactory)
    private static final org.apache.calcite.avatica.proto.Common.CursorFactory DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.apache.calcite.avatica.proto.Common.CursorFactory();
    }

    public static org.apache.calcite.avatica.proto.Common.CursorFactory getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<CursorFactory>
        PARSER = new com.google.protobuf.AbstractParser<CursorFactory>() {
      public CursorFactory parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        try {
          return new CursorFactory(input, extensionRegistry);
        } catch (RuntimeException e) {
          if (e.getCause() instanceof
              com.google.protobuf.InvalidProtocolBufferException) {
            throw (com.google.protobuf.InvalidProtocolBufferException)
                e.getCause();
          }
          throw e;
        }
      }
    };

    public static com.google.protobuf.Parser<CursorFactory> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<CursorFactory> getParserForType() {
      return PARSER;
    }

    public org.apache.calcite.avatica.proto.Common.CursorFactory getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface FrameOrBuilder extends
      // @@protoc_insertion_point(interface_extends:Frame)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>optional uint64 offset = 1;</code>
     */
    long getOffset();

    /**
     * <code>optional bool done = 2;</code>
     */
    boolean getDone();

    /**
     * <code>repeated .Row rows = 3;</code>
     */
    java.util.List<org.apache.calcite.avatica.proto.Common.Row> 
        getRowsList();
    /**
     * <code>repeated .Row rows = 3;</code>
     */
    org.apache.calcite.avatica.proto.Common.Row getRows(int index);
    /**
     * <code>repeated .Row rows = 3;</code>
     */
    int getRowsCount();
    /**
     * <code>repeated .Row rows = 3;</code>
     */
    java.util.List<? extends org.apache.calcite.avatica.proto.Common.RowOrBuilder> 
        getRowsOrBuilderList();
    /**
     * <code>repeated .Row rows = 3;</code>
     */
    org.apache.calcite.avatica.proto.Common.RowOrBuilder getRowsOrBuilder(
        int index);
  }
  /**
   * Protobuf type {@code Frame}
   *
   * <pre>
   * A collection of rows
   * </pre>
   */
  public  static final class Frame extends
      com.google.protobuf.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:Frame)
      FrameOrBuilder {
    // Use Frame.newBuilder() to construct.
    private Frame(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
    }
    private Frame() {
      offset_ = 0L;
      done_ = false;
      rows_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return com.google.protobuf.UnknownFieldSet.getDefaultInstance();
    }
    private Frame(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry) {
      this();
      int mutable_bitField0_ = 0;
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!input.skipField(tag)) {
                done = true;
              }
              break;
            }
            case 8: {

              offset_ = input.readUInt64();
              break;
            }
            case 16: {

              done_ = input.readBool();
              break;
            }
            case 26: {
              if (!((mutable_bitField0_ & 0x00000004) == 0x00000004)) {
                rows_ = new java.util.ArrayList<org.apache.calcite.avatica.proto.Common.Row>();
                mutable_bitField0_ |= 0x00000004;
              }
              rows_.add(input.readMessage(org.apache.calcite.avatica.proto.Common.Row.parser(), extensionRegistry));
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw new RuntimeException(e.setUnfinishedMessage(this));
      } catch (java.io.IOException e) {
        throw new RuntimeException(
            new com.google.protobuf.InvalidProtocolBufferException(
                e.getMessage()).setUnfinishedMessage(this));
      } finally {
        if (((mutable_bitField0_ & 0x00000004) == 0x00000004)) {
          rows_ = java.util.Collections.unmodifiableList(rows_);
        }
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.calcite.avatica.proto.Common.internal_static_Frame_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.calcite.avatica.proto.Common.internal_static_Frame_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.calcite.avatica.proto.Common.Frame.class, org.apache.calcite.avatica.proto.Common.Frame.Builder.class);
    }

    private int bitField0_;
    public static final int OFFSET_FIELD_NUMBER = 1;
    private long offset_;
    /**
     * <code>optional uint64 offset = 1;</code>
     */
    public long getOffset() {
      return offset_;
    }

    public static final int DONE_FIELD_NUMBER = 2;
    private boolean done_;
    /**
     * <code>optional bool done = 2;</code>
     */
    public boolean getDone() {
      return done_;
    }

    public static final int ROWS_FIELD_NUMBER = 3;
    private java.util.List<org.apache.calcite.avatica.proto.Common.Row> rows_;
    /**
     * <code>repeated .Row rows = 3;</code>
     */
    public java.util.List<org.apache.calcite.avatica.proto.Common.Row> getRowsList() {
      return rows_;
    }
    /**
     * <code>repeated .Row rows = 3;</code>
     */
    public java.util.List<? extends org.apache.calcite.avatica.proto.Common.RowOrBuilder> 
        getRowsOrBuilderList() {
      return rows_;
    }
    /**
     * <code>repeated .Row rows = 3;</code>
     */
    public int getRowsCount() {
      return rows_.size();
    }
    /**
     * <code>repeated .Row rows = 3;</code>
     */
    public org.apache.calcite.avatica.proto.Common.Row getRows(int index) {
      return rows_.get(index);
    }
    /**
     * <code>repeated .Row rows = 3;</code>
     */
    public org.apache.calcite.avatica.proto.Common.RowOrBuilder getRowsOrBuilder(
        int index) {
      return rows_.get(index);
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (offset_ != 0L) {
        output.writeUInt64(1, offset_);
      }
      if (done_ != false) {
        output.writeBool(2, done_);
      }
      for (int i = 0; i < rows_.size(); i++) {
        output.writeMessage(3, rows_.get(i));
      }
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (offset_ != 0L) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt64Size(1, offset_);
      }
      if (done_ != false) {
        size += com.google.protobuf.CodedOutputStream
          .computeBoolSize(2, done_);
      }
      for (int i = 0; i < rows_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(3, rows_.get(i));
      }
      memoizedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    public static org.apache.calcite.avatica.proto.Common.Frame parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.calcite.avatica.proto.Common.Frame parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.calcite.avatica.proto.Common.Frame parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.calcite.avatica.proto.Common.Frame parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.calcite.avatica.proto.Common.Frame parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.calcite.avatica.proto.Common.Frame parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static org.apache.calcite.avatica.proto.Common.Frame parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static org.apache.calcite.avatica.proto.Common.Frame parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static org.apache.calcite.avatica.proto.Common.Frame parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.calcite.avatica.proto.Common.Frame parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.apache.calcite.avatica.proto.Common.Frame prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code Frame}
     *
     * <pre>
     * A collection of rows
     * </pre>
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:Frame)
        org.apache.calcite.avatica.proto.Common.FrameOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.calcite.avatica.proto.Common.internal_static_Frame_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.calcite.avatica.proto.Common.internal_static_Frame_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.calcite.avatica.proto.Common.Frame.class, org.apache.calcite.avatica.proto.Common.Frame.Builder.class);
      }

      // Construct using org.apache.calcite.avatica.proto.Common.Frame.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
          getRowsFieldBuilder();
        }
      }
      public Builder clear() {
        super.clear();
        offset_ = 0L;

        done_ = false;

        if (rowsBuilder_ == null) {
          rows_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000004);
        } else {
          rowsBuilder_.clear();
        }
        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.calcite.avatica.proto.Common.internal_static_Frame_descriptor;
      }

      public org.apache.calcite.avatica.proto.Common.Frame getDefaultInstanceForType() {
        return org.apache.calcite.avatica.proto.Common.Frame.getDefaultInstance();
      }

      public org.apache.calcite.avatica.proto.Common.Frame build() {
        org.apache.calcite.avatica.proto.Common.Frame result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public org.apache.calcite.avatica.proto.Common.Frame buildPartial() {
        org.apache.calcite.avatica.proto.Common.Frame result = new org.apache.calcite.avatica.proto.Common.Frame(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        result.offset_ = offset_;
        result.done_ = done_;
        if (rowsBuilder_ == null) {
          if (((bitField0_ & 0x00000004) == 0x00000004)) {
            rows_ = java.util.Collections.unmodifiableList(rows_);
            bitField0_ = (bitField0_ & ~0x00000004);
          }
          result.rows_ = rows_;
        } else {
          result.rows_ = rowsBuilder_.build();
        }
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.apache.calcite.avatica.proto.Common.Frame) {
          return mergeFrom((org.apache.calcite.avatica.proto.Common.Frame)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.calcite.avatica.proto.Common.Frame other) {
        if (other == org.apache.calcite.avatica.proto.Common.Frame.getDefaultInstance()) return this;
        if (other.getOffset() != 0L) {
          setOffset(other.getOffset());
        }
        if (other.getDone() != false) {
          setDone(other.getDone());
        }
        if (rowsBuilder_ == null) {
          if (!other.rows_.isEmpty()) {
            if (rows_.isEmpty()) {
              rows_ = other.rows_;
              bitField0_ = (bitField0_ & ~0x00000004);
            } else {
              ensureRowsIsMutable();
              rows_.addAll(other.rows_);
            }
            onChanged();
          }
        } else {
          if (!other.rows_.isEmpty()) {
            if (rowsBuilder_.isEmpty()) {
              rowsBuilder_.dispose();
              rowsBuilder_ = null;
              rows_ = other.rows_;
              bitField0_ = (bitField0_ & ~0x00000004);
              rowsBuilder_ = 
                com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders ?
                   getRowsFieldBuilder() : null;
            } else {
              rowsBuilder_.addAllMessages(other.rows_);
            }
          }
        }
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        org.apache.calcite.avatica.proto.Common.Frame parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (org.apache.calcite.avatica.proto.Common.Frame) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private long offset_ ;
      /**
       * <code>optional uint64 offset = 1;</code>
       */
      public long getOffset() {
        return offset_;
      }
      /**
       * <code>optional uint64 offset = 1;</code>
       */
      public Builder setOffset(long value) {
        
        offset_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional uint64 offset = 1;</code>
       */
      public Builder clearOffset() {
        
        offset_ = 0L;
        onChanged();
        return this;
      }

      private boolean done_ ;
      /**
       * <code>optional bool done = 2;</code>
       */
      public boolean getDone() {
        return done_;
      }
      /**
       * <code>optional bool done = 2;</code>
       */
      public Builder setDone(boolean value) {
        
        done_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional bool done = 2;</code>
       */
      public Builder clearDone() {
        
        done_ = false;
        onChanged();
        return this;
      }

      private java.util.List<org.apache.calcite.avatica.proto.Common.Row> rows_ =
        java.util.Collections.emptyList();
      private void ensureRowsIsMutable() {
        if (!((bitField0_ & 0x00000004) == 0x00000004)) {
          rows_ = new java.util.ArrayList<org.apache.calcite.avatica.proto.Common.Row>(rows_);
          bitField0_ |= 0x00000004;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilder<
          org.apache.calcite.avatica.proto.Common.Row, org.apache.calcite.avatica.proto.Common.Row.Builder, org.apache.calcite.avatica.proto.Common.RowOrBuilder> rowsBuilder_;

      /**
       * <code>repeated .Row rows = 3;</code>
       */
      public java.util.List<org.apache.calcite.avatica.proto.Common.Row> getRowsList() {
        if (rowsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(rows_);
        } else {
          return rowsBuilder_.getMessageList();
        }
      }
      /**
       * <code>repeated .Row rows = 3;</code>
       */
      public int getRowsCount() {
        if (rowsBuilder_ == null) {
          return rows_.size();
        } else {
          return rowsBuilder_.getCount();
        }
      }
      /**
       * <code>repeated .Row rows = 3;</code>
       */
      public org.apache.calcite.avatica.proto.Common.Row getRows(int index) {
        if (rowsBuilder_ == null) {
          return rows_.get(index);
        } else {
          return rowsBuilder_.getMessage(index);
        }
      }
      /**
       * <code>repeated .Row rows = 3;</code>
       */
      public Builder setRows(
          int index, org.apache.calcite.avatica.proto.Common.Row value) {
        if (rowsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureRowsIsMutable();
          rows_.set(index, value);
          onChanged();
        } else {
          rowsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .Row rows = 3;</code>
       */
      public Builder setRows(
          int index, org.apache.calcite.avatica.proto.Common.Row.Builder builderForValue) {
        if (rowsBuilder_ == null) {
          ensureRowsIsMutable();
          rows_.set(index, builderForValue.build());
          onChanged();
        } else {
          rowsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .Row rows = 3;</code>
       */
      public Builder addRows(org.apache.calcite.avatica.proto.Common.Row value) {
        if (rowsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureRowsIsMutable();
          rows_.add(value);
          onChanged();
        } else {
          rowsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <code>repeated .Row rows = 3;</code>
       */
      public Builder addRows(
          int index, org.apache.calcite.avatica.proto.Common.Row value) {
        if (rowsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureRowsIsMutable();
          rows_.add(index, value);
          onChanged();
        } else {
          rowsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .Row rows = 3;</code>
       */
      public Builder addRows(
          org.apache.calcite.avatica.proto.Common.Row.Builder builderForValue) {
        if (rowsBuilder_ == null) {
          ensureRowsIsMutable();
          rows_.add(builderForValue.build());
          onChanged();
        } else {
          rowsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .Row rows = 3;</code>
       */
      public Builder addRows(
          int index, org.apache.calcite.avatica.proto.Common.Row.Builder builderForValue) {
        if (rowsBuilder_ == null) {
          ensureRowsIsMutable();
          rows_.add(index, builderForValue.build());
          onChanged();
        } else {
          rowsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .Row rows = 3;</code>
       */
      public Builder addAllRows(
          java.lang.Iterable<? extends org.apache.calcite.avatica.proto.Common.Row> values) {
        if (rowsBuilder_ == null) {
          ensureRowsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, rows_);
          onChanged();
        } else {
          rowsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <code>repeated .Row rows = 3;</code>
       */
      public Builder clearRows() {
        if (rowsBuilder_ == null) {
          rows_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000004);
          onChanged();
        } else {
          rowsBuilder_.clear();
        }
        return this;
      }
      /**
       * <code>repeated .Row rows = 3;</code>
       */
      public Builder removeRows(int index) {
        if (rowsBuilder_ == null) {
          ensureRowsIsMutable();
          rows_.remove(index);
          onChanged();
        } else {
          rowsBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <code>repeated .Row rows = 3;</code>
       */
      public org.apache.calcite.avatica.proto.Common.Row.Builder getRowsBuilder(
          int index) {
        return getRowsFieldBuilder().getBuilder(index);
      }
      /**
       * <code>repeated .Row rows = 3;</code>
       */
      public org.apache.calcite.avatica.proto.Common.RowOrBuilder getRowsOrBuilder(
          int index) {
        if (rowsBuilder_ == null) {
          return rows_.get(index);  } else {
          return rowsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <code>repeated .Row rows = 3;</code>
       */
      public java.util.List<? extends org.apache.calcite.avatica.proto.Common.RowOrBuilder> 
           getRowsOrBuilderList() {
        if (rowsBuilder_ != null) {
          return rowsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(rows_);
        }
      }
      /**
       * <code>repeated .Row rows = 3;</code>
       */
      public org.apache.calcite.avatica.proto.Common.Row.Builder addRowsBuilder() {
        return getRowsFieldBuilder().addBuilder(
            org.apache.calcite.avatica.proto.Common.Row.getDefaultInstance());
      }
      /**
       * <code>repeated .Row rows = 3;</code>
       */
      public org.apache.calcite.avatica.proto.Common.Row.Builder addRowsBuilder(
          int index) {
        return getRowsFieldBuilder().addBuilder(
            index, org.apache.calcite.avatica.proto.Common.Row.getDefaultInstance());
      }
      /**
       * <code>repeated .Row rows = 3;</code>
       */
      public java.util.List<org.apache.calcite.avatica.proto.Common.Row.Builder> 
           getRowsBuilderList() {
        return getRowsFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilder<
          org.apache.calcite.avatica.proto.Common.Row, org.apache.calcite.avatica.proto.Common.Row.Builder, org.apache.calcite.avatica.proto.Common.RowOrBuilder> 
          getRowsFieldBuilder() {
        if (rowsBuilder_ == null) {
          rowsBuilder_ = new com.google.protobuf.RepeatedFieldBuilder<
              org.apache.calcite.avatica.proto.Common.Row, org.apache.calcite.avatica.proto.Common.Row.Builder, org.apache.calcite.avatica.proto.Common.RowOrBuilder>(
                  rows_,
                  ((bitField0_ & 0x00000004) == 0x00000004),
                  getParentForChildren(),
                  isClean());
          rows_ = null;
        }
        return rowsBuilder_;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return this;
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return this;
      }


      // @@protoc_insertion_point(builder_scope:Frame)
    }

    // @@protoc_insertion_point(class_scope:Frame)
    private static final org.apache.calcite.avatica.proto.Common.Frame DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.apache.calcite.avatica.proto.Common.Frame();
    }

    public static org.apache.calcite.avatica.proto.Common.Frame getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Frame>
        PARSER = new com.google.protobuf.AbstractParser<Frame>() {
      public Frame parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        try {
          return new Frame(input, extensionRegistry);
        } catch (RuntimeException e) {
          if (e.getCause() instanceof
              com.google.protobuf.InvalidProtocolBufferException) {
            throw (com.google.protobuf.InvalidProtocolBufferException)
                e.getCause();
          }
          throw e;
        }
      }
    };

    public static com.google.protobuf.Parser<Frame> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Frame> getParserForType() {
      return PARSER;
    }

    public org.apache.calcite.avatica.proto.Common.Frame getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface RowOrBuilder extends
      // @@protoc_insertion_point(interface_extends:Row)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>repeated .ColumnValue value = 1;</code>
     */
    java.util.List<org.apache.calcite.avatica.proto.Common.ColumnValue> 
        getValueList();
    /**
     * <code>repeated .ColumnValue value = 1;</code>
     */
    org.apache.calcite.avatica.proto.Common.ColumnValue getValue(int index);
    /**
     * <code>repeated .ColumnValue value = 1;</code>
     */
    int getValueCount();
    /**
     * <code>repeated .ColumnValue value = 1;</code>
     */
    java.util.List<? extends org.apache.calcite.avatica.proto.Common.ColumnValueOrBuilder> 
        getValueOrBuilderList();
    /**
     * <code>repeated .ColumnValue value = 1;</code>
     */
    org.apache.calcite.avatica.proto.Common.ColumnValueOrBuilder getValueOrBuilder(
        int index);
  }
  /**
   * Protobuf type {@code Row}
   *
   * <pre>
   * A row is a collection of values
   * </pre>
   */
  public  static final class Row extends
      com.google.protobuf.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:Row)
      RowOrBuilder {
    // Use Row.newBuilder() to construct.
    private Row(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
    }
    private Row() {
      value_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return com.google.protobuf.UnknownFieldSet.getDefaultInstance();
    }
    private Row(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry) {
      this();
      int mutable_bitField0_ = 0;
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!input.skipField(tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              if (!((mutable_bitField0_ & 0x00000001) == 0x00000001)) {
                value_ = new java.util.ArrayList<org.apache.calcite.avatica.proto.Common.ColumnValue>();
                mutable_bitField0_ |= 0x00000001;
              }
              value_.add(input.readMessage(org.apache.calcite.avatica.proto.Common.ColumnValue.parser(), extensionRegistry));
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw new RuntimeException(e.setUnfinishedMessage(this));
      } catch (java.io.IOException e) {
        throw new RuntimeException(
            new com.google.protobuf.InvalidProtocolBufferException(
                e.getMessage()).setUnfinishedMessage(this));
      } finally {
        if (((mutable_bitField0_ & 0x00000001) == 0x00000001)) {
          value_ = java.util.Collections.unmodifiableList(value_);
        }
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.calcite.avatica.proto.Common.internal_static_Row_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.calcite.avatica.proto.Common.internal_static_Row_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.calcite.avatica.proto.Common.Row.class, org.apache.calcite.avatica.proto.Common.Row.Builder.class);
    }

    public static final int VALUE_FIELD_NUMBER = 1;
    private java.util.List<org.apache.calcite.avatica.proto.Common.ColumnValue> value_;
    /**
     * <code>repeated .ColumnValue value = 1;</code>
     */
    public java.util.List<org.apache.calcite.avatica.proto.Common.ColumnValue> getValueList() {
      return value_;
    }
    /**
     * <code>repeated .ColumnValue value = 1;</code>
     */
    public java.util.List<? extends org.apache.calcite.avatica.proto.Common.ColumnValueOrBuilder> 
        getValueOrBuilderList() {
      return value_;
    }
    /**
     * <code>repeated .ColumnValue value = 1;</code>
     */
    public int getValueCount() {
      return value_.size();
    }
    /**
     * <code>repeated .ColumnValue value = 1;</code>
     */
    public org.apache.calcite.avatica.proto.Common.ColumnValue getValue(int index) {
      return value_.get(index);
    }
    /**
     * <code>repeated .ColumnValue value = 1;</code>
     */
    public org.apache.calcite.avatica.proto.Common.ColumnValueOrBuilder getValueOrBuilder(
        int index) {
      return value_.get(index);
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      for (int i = 0; i < value_.size(); i++) {
        output.writeMessage(1, value_.get(i));
      }
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < value_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(1, value_.get(i));
      }
      memoizedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    public static org.apache.calcite.avatica.proto.Common.Row parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.calcite.avatica.proto.Common.Row parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.calcite.avatica.proto.Common.Row parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.calcite.avatica.proto.Common.Row parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.calcite.avatica.proto.Common.Row parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.calcite.avatica.proto.Common.Row parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static org.apache.calcite.avatica.proto.Common.Row parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static org.apache.calcite.avatica.proto.Common.Row parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static org.apache.calcite.avatica.proto.Common.Row parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.calcite.avatica.proto.Common.Row parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.apache.calcite.avatica.proto.Common.Row prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code Row}
     *
     * <pre>
     * A row is a collection of values
     * </pre>
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:Row)
        org.apache.calcite.avatica.proto.Common.RowOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.calcite.avatica.proto.Common.internal_static_Row_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.calcite.avatica.proto.Common.internal_static_Row_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.calcite.avatica.proto.Common.Row.class, org.apache.calcite.avatica.proto.Common.Row.Builder.class);
      }

      // Construct using org.apache.calcite.avatica.proto.Common.Row.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
          getValueFieldBuilder();
        }
      }
      public Builder clear() {
        super.clear();
        if (valueBuilder_ == null) {
          value_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
        } else {
          valueBuilder_.clear();
        }
        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.calcite.avatica.proto.Common.internal_static_Row_descriptor;
      }

      public org.apache.calcite.avatica.proto.Common.Row getDefaultInstanceForType() {
        return org.apache.calcite.avatica.proto.Common.Row.getDefaultInstance();
      }

      public org.apache.calcite.avatica.proto.Common.Row build() {
        org.apache.calcite.avatica.proto.Common.Row result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public org.apache.calcite.avatica.proto.Common.Row buildPartial() {
        org.apache.calcite.avatica.proto.Common.Row result = new org.apache.calcite.avatica.proto.Common.Row(this);
        int from_bitField0_ = bitField0_;
        if (valueBuilder_ == null) {
          if (((bitField0_ & 0x00000001) == 0x00000001)) {
            value_ = java.util.Collections.unmodifiableList(value_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.value_ = value_;
        } else {
          result.value_ = valueBuilder_.build();
        }
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.apache.calcite.avatica.proto.Common.Row) {
          return mergeFrom((org.apache.calcite.avatica.proto.Common.Row)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.calcite.avatica.proto.Common.Row other) {
        if (other == org.apache.calcite.avatica.proto.Common.Row.getDefaultInstance()) return this;
        if (valueBuilder_ == null) {
          if (!other.value_.isEmpty()) {
            if (value_.isEmpty()) {
              value_ = other.value_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureValueIsMutable();
              value_.addAll(other.value_);
            }
            onChanged();
          }
        } else {
          if (!other.value_.isEmpty()) {
            if (valueBuilder_.isEmpty()) {
              valueBuilder_.dispose();
              valueBuilder_ = null;
              value_ = other.value_;
              bitField0_ = (bitField0_ & ~0x00000001);
              valueBuilder_ = 
                com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders ?
                   getValueFieldBuilder() : null;
            } else {
              valueBuilder_.addAllMessages(other.value_);
            }
          }
        }
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        org.apache.calcite.avatica.proto.Common.Row parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (org.apache.calcite.avatica.proto.Common.Row) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private java.util.List<org.apache.calcite.avatica.proto.Common.ColumnValue> value_ =
        java.util.Collections.emptyList();
      private void ensureValueIsMutable() {
        if (!((bitField0_ & 0x00000001) == 0x00000001)) {
          value_ = new java.util.ArrayList<org.apache.calcite.avatica.proto.Common.ColumnValue>(value_);
          bitField0_ |= 0x00000001;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilder<
          org.apache.calcite.avatica.proto.Common.ColumnValue, org.apache.calcite.avatica.proto.Common.ColumnValue.Builder, org.apache.calcite.avatica.proto.Common.ColumnValueOrBuilder> valueBuilder_;

      /**
       * <code>repeated .ColumnValue value = 1;</code>
       */
      public java.util.List<org.apache.calcite.avatica.proto.Common.ColumnValue> getValueList() {
        if (valueBuilder_ == null) {
          return java.util.Collections.unmodifiableList(value_);
        } else {
          return valueBuilder_.getMessageList();
        }
      }
      /**
       * <code>repeated .ColumnValue value = 1;</code>
       */
      public int getValueCount() {
        if (valueBuilder_ == null) {
          return value_.size();
        } else {
          return valueBuilder_.getCount();
        }
      }
      /**
       * <code>repeated .ColumnValue value = 1;</code>
       */
      public org.apache.calcite.avatica.proto.Common.ColumnValue getValue(int index) {
        if (valueBuilder_ == null) {
          return value_.get(index);
        } else {
          return valueBuilder_.getMessage(index);
        }
      }
      /**
       * <code>repeated .ColumnValue value = 1;</code>
       */
      public Builder setValue(
          int index, org.apache.calcite.avatica.proto.Common.ColumnValue value) {
        if (valueBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureValueIsMutable();
          value_.set(index, value);
          onChanged();
        } else {
          valueBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .ColumnValue value = 1;</code>
       */
      public Builder setValue(
          int index, org.apache.calcite.avatica.proto.Common.ColumnValue.Builder builderForValue) {
        if (valueBuilder_ == null) {
          ensureValueIsMutable();
          value_.set(index, builderForValue.build());
          onChanged();
        } else {
          valueBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .ColumnValue value = 1;</code>
       */
      public Builder addValue(org.apache.calcite.avatica.proto.Common.ColumnValue value) {
        if (valueBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureValueIsMutable();
          value_.add(value);
          onChanged();
        } else {
          valueBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <code>repeated .ColumnValue value = 1;</code>
       */
      public Builder addValue(
          int index, org.apache.calcite.avatica.proto.Common.ColumnValue value) {
        if (valueBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureValueIsMutable();
          value_.add(index, value);
          onChanged();
        } else {
          valueBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .ColumnValue value = 1;</code>
       */
      public Builder addValue(
          org.apache.calcite.avatica.proto.Common.ColumnValue.Builder builderForValue) {
        if (valueBuilder_ == null) {
          ensureValueIsMutable();
          value_.add(builderForValue.build());
          onChanged();
        } else {
          valueBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .ColumnValue value = 1;</code>
       */
      public Builder addValue(
          int index, org.apache.calcite.avatica.proto.Common.ColumnValue.Builder builderForValue) {
        if (valueBuilder_ == null) {
          ensureValueIsMutable();
          value_.add(index, builderForValue.build());
          onChanged();
        } else {
          valueBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .ColumnValue value = 1;</code>
       */
      public Builder addAllValue(
          java.lang.Iterable<? extends org.apache.calcite.avatica.proto.Common.ColumnValue> values) {
        if (valueBuilder_ == null) {
          ensureValueIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, value_);
          onChanged();
        } else {
          valueBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <code>repeated .ColumnValue value = 1;</code>
       */
      public Builder clearValue() {
        if (valueBuilder_ == null) {
          value_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          valueBuilder_.clear();
        }
        return this;
      }
      /**
       * <code>repeated .ColumnValue value = 1;</code>
       */
      public Builder removeValue(int index) {
        if (valueBuilder_ == null) {
          ensureValueIsMutable();
          value_.remove(index);
          onChanged();
        } else {
          valueBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <code>repeated .ColumnValue value = 1;</code>
       */
      public org.apache.calcite.avatica.proto.Common.ColumnValue.Builder getValueBuilder(
          int index) {
        return getValueFieldBuilder().getBuilder(index);
      }
      /**
       * <code>repeated .ColumnValue value = 1;</code>
       */
      public org.apache.calcite.avatica.proto.Common.ColumnValueOrBuilder getValueOrBuilder(
          int index) {
        if (valueBuilder_ == null) {
          return value_.get(index);  } else {
          return valueBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <code>repeated .ColumnValue value = 1;</code>
       */
      public java.util.List<? extends org.apache.calcite.avatica.proto.Common.ColumnValueOrBuilder> 
           getValueOrBuilderList() {
        if (valueBuilder_ != null) {
          return valueBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(value_);
        }
      }
      /**
       * <code>repeated .ColumnValue value = 1;</code>
       */
      public org.apache.calcite.avatica.proto.Common.ColumnValue.Builder addValueBuilder() {
        return getValueFieldBuilder().addBuilder(
            org.apache.calcite.avatica.proto.Common.ColumnValue.getDefaultInstance());
      }
      /**
       * <code>repeated .ColumnValue value = 1;</code>
       */
      public org.apache.calcite.avatica.proto.Common.ColumnValue.Builder addValueBuilder(
          int index) {
        return getValueFieldBuilder().addBuilder(
            index, org.apache.calcite.avatica.proto.Common.ColumnValue.getDefaultInstance());
      }
      /**
       * <code>repeated .ColumnValue value = 1;</code>
       */
      public java.util.List<org.apache.calcite.avatica.proto.Common.ColumnValue.Builder> 
           getValueBuilderList() {
        return getValueFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilder<
          org.apache.calcite.avatica.proto.Common.ColumnValue, org.apache.calcite.avatica.proto.Common.ColumnValue.Builder, org.apache.calcite.avatica.proto.Common.ColumnValueOrBuilder> 
          getValueFieldBuilder() {
        if (valueBuilder_ == null) {
          valueBuilder_ = new com.google.protobuf.RepeatedFieldBuilder<
              org.apache.calcite.avatica.proto.Common.ColumnValue, org.apache.calcite.avatica.proto.Common.ColumnValue.Builder, org.apache.calcite.avatica.proto.Common.ColumnValueOrBuilder>(
                  value_,
                  ((bitField0_ & 0x00000001) == 0x00000001),
                  getParentForChildren(),
                  isClean());
          value_ = null;
        }
        return valueBuilder_;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return this;
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return this;
      }


      // @@protoc_insertion_point(builder_scope:Row)
    }

    // @@protoc_insertion_point(class_scope:Row)
    private static final org.apache.calcite.avatica.proto.Common.Row DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.apache.calcite.avatica.proto.Common.Row();
    }

    public static org.apache.calcite.avatica.proto.Common.Row getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Row>
        PARSER = new com.google.protobuf.AbstractParser<Row>() {
      public Row parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        try {
          return new Row(input, extensionRegistry);
        } catch (RuntimeException e) {
          if (e.getCause() instanceof
              com.google.protobuf.InvalidProtocolBufferException) {
            throw (com.google.protobuf.InvalidProtocolBufferException)
                e.getCause();
          }
          throw e;
        }
      }
    };

    public static com.google.protobuf.Parser<Row> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Row> getParserForType() {
      return PARSER;
    }

    public org.apache.calcite.avatica.proto.Common.Row getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface DatabasePropertyOrBuilder extends
      // @@protoc_insertion_point(interface_extends:DatabaseProperty)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>optional string name = 1;</code>
     */
    java.lang.String getName();
    /**
     * <code>optional string name = 1;</code>
     */
    com.google.protobuf.ByteString
        getNameBytes();

    /**
     * <code>repeated string functions = 2;</code>
     */
    com.google.protobuf.ProtocolStringList
        getFunctionsList();
    /**
     * <code>repeated string functions = 2;</code>
     */
    int getFunctionsCount();
    /**
     * <code>repeated string functions = 2;</code>
     */
    java.lang.String getFunctions(int index);
    /**
     * <code>repeated string functions = 2;</code>
     */
    com.google.protobuf.ByteString
        getFunctionsBytes(int index);
  }
  /**
   * Protobuf type {@code DatabaseProperty}
   *
   * <pre>
   * Database property, list of functions the database provides for a certain operation
   * </pre>
   */
  public  static final class DatabaseProperty extends
      com.google.protobuf.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:DatabaseProperty)
      DatabasePropertyOrBuilder {
    // Use DatabaseProperty.newBuilder() to construct.
    private DatabaseProperty(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
    }
    private DatabaseProperty() {
      name_ = "";
      functions_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return com.google.protobuf.UnknownFieldSet.getDefaultInstance();
    }
    private DatabaseProperty(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry) {
      this();
      int mutable_bitField0_ = 0;
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!input.skipField(tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              String s = input.readStringRequireUtf8();

              name_ = s;
              break;
            }
            case 18: {
              String s = input.readStringRequireUtf8();
              if (!((mutable_bitField0_ & 0x00000002) == 0x00000002)) {
                functions_ = new com.google.protobuf.LazyStringArrayList();
                mutable_bitField0_ |= 0x00000002;
              }
              functions_.add(s);
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw new RuntimeException(e.setUnfinishedMessage(this));
      } catch (java.io.IOException e) {
        throw new RuntimeException(
            new com.google.protobuf.InvalidProtocolBufferException(
                e.getMessage()).setUnfinishedMessage(this));
      } finally {
        if (((mutable_bitField0_ & 0x00000002) == 0x00000002)) {
          functions_ = functions_.getUnmodifiableView();
        }
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.calcite.avatica.proto.Common.internal_static_DatabaseProperty_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.calcite.avatica.proto.Common.internal_static_DatabaseProperty_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.calcite.avatica.proto.Common.DatabaseProperty.class, org.apache.calcite.avatica.proto.Common.DatabaseProperty.Builder.class);
    }

    private int bitField0_;
    public static final int NAME_FIELD_NUMBER = 1;
    private volatile java.lang.Object name_;
    /**
     * <code>optional string name = 1;</code>
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      }
    }
    /**
     * <code>optional string name = 1;</code>
     */
    public com.google.protobuf.ByteString
        getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int FUNCTIONS_FIELD_NUMBER = 2;
    private com.google.protobuf.LazyStringList functions_;
    /**
     * <code>repeated string functions = 2;</code>
     */
    public com.google.protobuf.ProtocolStringList
        getFunctionsList() {
      return functions_;
    }
    /**
     * <code>repeated string functions = 2;</code>
     */
    public int getFunctionsCount() {
      return functions_.size();
    }
    /**
     * <code>repeated string functions = 2;</code>
     */
    public java.lang.String getFunctions(int index) {
      return functions_.get(index);
    }
    /**
     * <code>repeated string functions = 2;</code>
     */
    public com.google.protobuf.ByteString
        getFunctionsBytes(int index) {
      return functions_.getByteString(index);
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (!getNameBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessage.writeString(output, 1, name_);
      }
      for (int i = 0; i < functions_.size(); i++) {
        com.google.protobuf.GeneratedMessage.writeString(output, 2, functions_.getRaw(i));
      }
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!getNameBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessage.computeStringSize(1, name_);
      }
      {
        int dataSize = 0;
        for (int i = 0; i < functions_.size(); i++) {
          dataSize += computeStringSizeNoTag(functions_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getFunctionsList().size();
      }
      memoizedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    public static org.apache.calcite.avatica.proto.Common.DatabaseProperty parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.calcite.avatica.proto.Common.DatabaseProperty parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.calcite.avatica.proto.Common.DatabaseProperty parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.calcite.avatica.proto.Common.DatabaseProperty parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.calcite.avatica.proto.Common.DatabaseProperty parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.calcite.avatica.proto.Common.DatabaseProperty parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static org.apache.calcite.avatica.proto.Common.DatabaseProperty parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static org.apache.calcite.avatica.proto.Common.DatabaseProperty parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static org.apache.calcite.avatica.proto.Common.DatabaseProperty parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.calcite.avatica.proto.Common.DatabaseProperty parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.apache.calcite.avatica.proto.Common.DatabaseProperty prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code DatabaseProperty}
     *
     * <pre>
     * Database property, list of functions the database provides for a certain operation
     * </pre>
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:DatabaseProperty)
        org.apache.calcite.avatica.proto.Common.DatabasePropertyOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.calcite.avatica.proto.Common.internal_static_DatabaseProperty_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.calcite.avatica.proto.Common.internal_static_DatabaseProperty_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.calcite.avatica.proto.Common.DatabaseProperty.class, org.apache.calcite.avatica.proto.Common.DatabaseProperty.Builder.class);
      }

      // Construct using org.apache.calcite.avatica.proto.Common.DatabaseProperty.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
        }
      }
      public Builder clear() {
        super.clear();
        name_ = "";

        functions_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.calcite.avatica.proto.Common.internal_static_DatabaseProperty_descriptor;
      }

      public org.apache.calcite.avatica.proto.Common.DatabaseProperty getDefaultInstanceForType() {
        return org.apache.calcite.avatica.proto.Common.DatabaseProperty.getDefaultInstance();
      }

      public org.apache.calcite.avatica.proto.Common.DatabaseProperty build() {
        org.apache.calcite.avatica.proto.Common.DatabaseProperty result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public org.apache.calcite.avatica.proto.Common.DatabaseProperty buildPartial() {
        org.apache.calcite.avatica.proto.Common.DatabaseProperty result = new org.apache.calcite.avatica.proto.Common.DatabaseProperty(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        result.name_ = name_;
        if (((bitField0_ & 0x00000002) == 0x00000002)) {
          functions_ = functions_.getUnmodifiableView();
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.functions_ = functions_;
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.apache.calcite.avatica.proto.Common.DatabaseProperty) {
          return mergeFrom((org.apache.calcite.avatica.proto.Common.DatabaseProperty)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.calcite.avatica.proto.Common.DatabaseProperty other) {
        if (other == org.apache.calcite.avatica.proto.Common.DatabaseProperty.getDefaultInstance()) return this;
        if (!other.getName().isEmpty()) {
          name_ = other.name_;
          onChanged();
        }
        if (!other.functions_.isEmpty()) {
          if (functions_.isEmpty()) {
            functions_ = other.functions_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureFunctionsIsMutable();
            functions_.addAll(other.functions_);
          }
          onChanged();
        }
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        org.apache.calcite.avatica.proto.Common.DatabaseProperty parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (org.apache.calcite.avatica.proto.Common.DatabaseProperty) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private java.lang.Object name_ = "";
      /**
       * <code>optional string name = 1;</code>
       */
      public java.lang.String getName() {
        java.lang.Object ref = name_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          name_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>optional string name = 1;</code>
       */
      public com.google.protobuf.ByteString
          getNameBytes() {
        java.lang.Object ref = name_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          name_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>optional string name = 1;</code>
       */
      public Builder setName(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        name_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional string name = 1;</code>
       */
      public Builder clearName() {
        
        name_ = getDefaultInstance().getName();
        onChanged();
        return this;
      }
      /**
       * <code>optional string name = 1;</code>
       */
      public Builder setNameBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        name_ = value;
        onChanged();
        return this;
      }

      private com.google.protobuf.LazyStringList functions_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      private void ensureFunctionsIsMutable() {
        if (!((bitField0_ & 0x00000002) == 0x00000002)) {
          functions_ = new com.google.protobuf.LazyStringArrayList(functions_);
          bitField0_ |= 0x00000002;
         }
      }
      /**
       * <code>repeated string functions = 2;</code>
       */
      public com.google.protobuf.ProtocolStringList
          getFunctionsList() {
        return functions_.getUnmodifiableView();
      }
      /**
       * <code>repeated string functions = 2;</code>
       */
      public int getFunctionsCount() {
        return functions_.size();
      }
      /**
       * <code>repeated string functions = 2;</code>
       */
      public java.lang.String getFunctions(int index) {
        return functions_.get(index);
      }
      /**
       * <code>repeated string functions = 2;</code>
       */
      public com.google.protobuf.ByteString
          getFunctionsBytes(int index) {
        return functions_.getByteString(index);
      }
      /**
       * <code>repeated string functions = 2;</code>
       */
      public Builder setFunctions(
          int index, java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  ensureFunctionsIsMutable();
        functions_.set(index, value);
        onChanged();
        return this;
      }
      /**
       * <code>repeated string functions = 2;</code>
       */
      public Builder addFunctions(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  ensureFunctionsIsMutable();
        functions_.add(value);
        onChanged();
        return this;
      }
      /**
       * <code>repeated string functions = 2;</code>
       */
      public Builder addAllFunctions(
          java.lang.Iterable<java.lang.String> values) {
        ensureFunctionsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, functions_);
        onChanged();
        return this;
      }
      /**
       * <code>repeated string functions = 2;</code>
       */
      public Builder clearFunctions() {
        functions_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       * <code>repeated string functions = 2;</code>
       */
      public Builder addFunctionsBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        ensureFunctionsIsMutable();
        functions_.add(value);
        onChanged();
        return this;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return this;
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return this;
      }


      // @@protoc_insertion_point(builder_scope:DatabaseProperty)
    }

    // @@protoc_insertion_point(class_scope:DatabaseProperty)
    private static final org.apache.calcite.avatica.proto.Common.DatabaseProperty DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.apache.calcite.avatica.proto.Common.DatabaseProperty();
    }

    public static org.apache.calcite.avatica.proto.Common.DatabaseProperty getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<DatabaseProperty>
        PARSER = new com.google.protobuf.AbstractParser<DatabaseProperty>() {
      public DatabaseProperty parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        try {
          return new DatabaseProperty(input, extensionRegistry);
        } catch (RuntimeException e) {
          if (e.getCause() instanceof
              com.google.protobuf.InvalidProtocolBufferException) {
            throw (com.google.protobuf.InvalidProtocolBufferException)
                e.getCause();
          }
          throw e;
        }
      }
    };

    public static com.google.protobuf.Parser<DatabaseProperty> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<DatabaseProperty> getParserForType() {
      return PARSER;
    }

    public org.apache.calcite.avatica.proto.Common.DatabaseProperty getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface WireMessageOrBuilder extends
      // @@protoc_insertion_point(interface_extends:WireMessage)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>optional string name = 1;</code>
     */
    java.lang.String getName();
    /**
     * <code>optional string name = 1;</code>
     */
    com.google.protobuf.ByteString
        getNameBytes();

    /**
     * <code>optional bytes wrapped_message = 2;</code>
     */
    com.google.protobuf.ByteString getWrappedMessage();
  }
  /**
   * Protobuf type {@code WireMessage}
   *
   * <pre>
   * Message which encapsulates another message to support a single RPC endpoint
   * </pre>
   */
  public  static final class WireMessage extends
      com.google.protobuf.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:WireMessage)
      WireMessageOrBuilder {
    // Use WireMessage.newBuilder() to construct.
    private WireMessage(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
    }
    private WireMessage() {
      name_ = "";
      wrappedMessage_ = com.google.protobuf.ByteString.EMPTY;
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return com.google.protobuf.UnknownFieldSet.getDefaultInstance();
    }
    private WireMessage(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry) {
      this();
      int mutable_bitField0_ = 0;
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!input.skipField(tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              String s = input.readStringRequireUtf8();

              name_ = s;
              break;
            }
            case 18: {

              wrappedMessage_ = input.readBytes();
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw new RuntimeException(e.setUnfinishedMessage(this));
      } catch (java.io.IOException e) {
        throw new RuntimeException(
            new com.google.protobuf.InvalidProtocolBufferException(
                e.getMessage()).setUnfinishedMessage(this));
      } finally {
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.calcite.avatica.proto.Common.internal_static_WireMessage_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.calcite.avatica.proto.Common.internal_static_WireMessage_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.calcite.avatica.proto.Common.WireMessage.class, org.apache.calcite.avatica.proto.Common.WireMessage.Builder.class);
    }

    public static final int NAME_FIELD_NUMBER = 1;
    private volatile java.lang.Object name_;
    /**
     * <code>optional string name = 1;</code>
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      }
    }
    /**
     * <code>optional string name = 1;</code>
     */
    public com.google.protobuf.ByteString
        getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int WRAPPED_MESSAGE_FIELD_NUMBER = 2;
    private com.google.protobuf.ByteString wrappedMessage_;
    /**
     * <code>optional bytes wrapped_message = 2;</code>
     */
    public com.google.protobuf.ByteString getWrappedMessage() {
      return wrappedMessage_;
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (!getNameBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessage.writeString(output, 1, name_);
      }
      if (!wrappedMessage_.isEmpty()) {
        output.writeBytes(2, wrappedMessage_);
      }
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!getNameBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessage.computeStringSize(1, name_);
      }
      if (!wrappedMessage_.isEmpty()) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(2, wrappedMessage_);
      }
      memoizedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    public static org.apache.calcite.avatica.proto.Common.WireMessage parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.calcite.avatica.proto.Common.WireMessage parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.calcite.avatica.proto.Common.WireMessage parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.calcite.avatica.proto.Common.WireMessage parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.calcite.avatica.proto.Common.WireMessage parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.calcite.avatica.proto.Common.WireMessage parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static org.apache.calcite.avatica.proto.Common.WireMessage parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static org.apache.calcite.avatica.proto.Common.WireMessage parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static org.apache.calcite.avatica.proto.Common.WireMessage parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.calcite.avatica.proto.Common.WireMessage parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.apache.calcite.avatica.proto.Common.WireMessage prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code WireMessage}
     *
     * <pre>
     * Message which encapsulates another message to support a single RPC endpoint
     * </pre>
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:WireMessage)
        org.apache.calcite.avatica.proto.Common.WireMessageOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.calcite.avatica.proto.Common.internal_static_WireMessage_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.calcite.avatica.proto.Common.internal_static_WireMessage_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.calcite.avatica.proto.Common.WireMessage.class, org.apache.calcite.avatica.proto.Common.WireMessage.Builder.class);
      }

      // Construct using org.apache.calcite.avatica.proto.Common.WireMessage.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
        }
      }
      public Builder clear() {
        super.clear();
        name_ = "";

        wrappedMessage_ = com.google.protobuf.ByteString.EMPTY;

        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.calcite.avatica.proto.Common.internal_static_WireMessage_descriptor;
      }

      public org.apache.calcite.avatica.proto.Common.WireMessage getDefaultInstanceForType() {
        return org.apache.calcite.avatica.proto.Common.WireMessage.getDefaultInstance();
      }

      public org.apache.calcite.avatica.proto.Common.WireMessage build() {
        org.apache.calcite.avatica.proto.Common.WireMessage result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public org.apache.calcite.avatica.proto.Common.WireMessage buildPartial() {
        org.apache.calcite.avatica.proto.Common.WireMessage result = new org.apache.calcite.avatica.proto.Common.WireMessage(this);
        result.name_ = name_;
        result.wrappedMessage_ = wrappedMessage_;
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.apache.calcite.avatica.proto.Common.WireMessage) {
          return mergeFrom((org.apache.calcite.avatica.proto.Common.WireMessage)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.calcite.avatica.proto.Common.WireMessage other) {
        if (other == org.apache.calcite.avatica.proto.Common.WireMessage.getDefaultInstance()) return this;
        if (!other.getName().isEmpty()) {
          name_ = other.name_;
          onChanged();
        }
        if (other.getWrappedMessage() != com.google.protobuf.ByteString.EMPTY) {
          setWrappedMessage(other.getWrappedMessage());
        }
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        org.apache.calcite.avatica.proto.Common.WireMessage parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (org.apache.calcite.avatica.proto.Common.WireMessage) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private java.lang.Object name_ = "";
      /**
       * <code>optional string name = 1;</code>
       */
      public java.lang.String getName() {
        java.lang.Object ref = name_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          name_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>optional string name = 1;</code>
       */
      public com.google.protobuf.ByteString
          getNameBytes() {
        java.lang.Object ref = name_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          name_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>optional string name = 1;</code>
       */
      public Builder setName(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        name_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional string name = 1;</code>
       */
      public Builder clearName() {
        
        name_ = getDefaultInstance().getName();
        onChanged();
        return this;
      }
      /**
       * <code>optional string name = 1;</code>
       */
      public Builder setNameBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        name_ = value;
        onChanged();
        return this;
      }

      private com.google.protobuf.ByteString wrappedMessage_ = com.google.protobuf.ByteString.EMPTY;
      /**
       * <code>optional bytes wrapped_message = 2;</code>
       */
      public com.google.protobuf.ByteString getWrappedMessage() {
        return wrappedMessage_;
      }
      /**
       * <code>optional bytes wrapped_message = 2;</code>
       */
      public Builder setWrappedMessage(com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        wrappedMessage_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional bytes wrapped_message = 2;</code>
       */
      public Builder clearWrappedMessage() {
        
        wrappedMessage_ = getDefaultInstance().getWrappedMessage();
        onChanged();
        return this;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return this;
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return this;
      }


      // @@protoc_insertion_point(builder_scope:WireMessage)
    }

    // @@protoc_insertion_point(class_scope:WireMessage)
    private static final org.apache.calcite.avatica.proto.Common.WireMessage DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.apache.calcite.avatica.proto.Common.WireMessage();
    }

    public static org.apache.calcite.avatica.proto.Common.WireMessage getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<WireMessage>
        PARSER = new com.google.protobuf.AbstractParser<WireMessage>() {
      public WireMessage parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        try {
          return new WireMessage(input, extensionRegistry);
        } catch (RuntimeException e) {
          if (e.getCause() instanceof
              com.google.protobuf.InvalidProtocolBufferException) {
            throw (com.google.protobuf.InvalidProtocolBufferException)
                e.getCause();
          }
          throw e;
        }
      }
    };

    public static com.google.protobuf.Parser<WireMessage> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<WireMessage> getParserForType() {
      return PARSER;
    }

    public org.apache.calcite.avatica.proto.Common.WireMessage getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface ColumnValueOrBuilder extends
      // @@protoc_insertion_point(interface_extends:ColumnValue)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>repeated .TypedValue value = 1;</code>
     */
    java.util.List<org.apache.calcite.avatica.proto.Common.TypedValue> 
        getValueList();
    /**
     * <code>repeated .TypedValue value = 1;</code>
     */
    org.apache.calcite.avatica.proto.Common.TypedValue getValue(int index);
    /**
     * <code>repeated .TypedValue value = 1;</code>
     */
    int getValueCount();
    /**
     * <code>repeated .TypedValue value = 1;</code>
     */
    java.util.List<? extends org.apache.calcite.avatica.proto.Common.TypedValueOrBuilder> 
        getValueOrBuilderList();
    /**
     * <code>repeated .TypedValue value = 1;</code>
     */
    org.apache.calcite.avatica.proto.Common.TypedValueOrBuilder getValueOrBuilder(
        int index);
  }
  /**
   * Protobuf type {@code ColumnValue}
   *
   * <pre>
   * A value might be a TypedValue or an Array of TypedValue's
   * </pre>
   */
  public  static final class ColumnValue extends
      com.google.protobuf.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:ColumnValue)
      ColumnValueOrBuilder {
    // Use ColumnValue.newBuilder() to construct.
    private ColumnValue(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
    }
    private ColumnValue() {
      value_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return com.google.protobuf.UnknownFieldSet.getDefaultInstance();
    }
    private ColumnValue(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry) {
      this();
      int mutable_bitField0_ = 0;
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!input.skipField(tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              if (!((mutable_bitField0_ & 0x00000001) == 0x00000001)) {
                value_ = new java.util.ArrayList<org.apache.calcite.avatica.proto.Common.TypedValue>();
                mutable_bitField0_ |= 0x00000001;
              }
              value_.add(input.readMessage(org.apache.calcite.avatica.proto.Common.TypedValue.parser(), extensionRegistry));
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw new RuntimeException(e.setUnfinishedMessage(this));
      } catch (java.io.IOException e) {
        throw new RuntimeException(
            new com.google.protobuf.InvalidProtocolBufferException(
                e.getMessage()).setUnfinishedMessage(this));
      } finally {
        if (((mutable_bitField0_ & 0x00000001) == 0x00000001)) {
          value_ = java.util.Collections.unmodifiableList(value_);
        }
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.calcite.avatica.proto.Common.internal_static_ColumnValue_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.calcite.avatica.proto.Common.internal_static_ColumnValue_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.calcite.avatica.proto.Common.ColumnValue.class, org.apache.calcite.avatica.proto.Common.ColumnValue.Builder.class);
    }

    public static final int VALUE_FIELD_NUMBER = 1;
    private java.util.List<org.apache.calcite.avatica.proto.Common.TypedValue> value_;
    /**
     * <code>repeated .TypedValue value = 1;</code>
     */
    public java.util.List<org.apache.calcite.avatica.proto.Common.TypedValue> getValueList() {
      return value_;
    }
    /**
     * <code>repeated .TypedValue value = 1;</code>
     */
    public java.util.List<? extends org.apache.calcite.avatica.proto.Common.TypedValueOrBuilder> 
        getValueOrBuilderList() {
      return value_;
    }
    /**
     * <code>repeated .TypedValue value = 1;</code>
     */
    public int getValueCount() {
      return value_.size();
    }
    /**
     * <code>repeated .TypedValue value = 1;</code>
     */
    public org.apache.calcite.avatica.proto.Common.TypedValue getValue(int index) {
      return value_.get(index);
    }
    /**
     * <code>repeated .TypedValue value = 1;</code>
     */
    public org.apache.calcite.avatica.proto.Common.TypedValueOrBuilder getValueOrBuilder(
        int index) {
      return value_.get(index);
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      for (int i = 0; i < value_.size(); i++) {
        output.writeMessage(1, value_.get(i));
      }
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < value_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(1, value_.get(i));
      }
      memoizedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    public static org.apache.calcite.avatica.proto.Common.ColumnValue parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.calcite.avatica.proto.Common.ColumnValue parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.calcite.avatica.proto.Common.ColumnValue parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.calcite.avatica.proto.Common.ColumnValue parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.calcite.avatica.proto.Common.ColumnValue parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.calcite.avatica.proto.Common.ColumnValue parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static org.apache.calcite.avatica.proto.Common.ColumnValue parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static org.apache.calcite.avatica.proto.Common.ColumnValue parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static org.apache.calcite.avatica.proto.Common.ColumnValue parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.calcite.avatica.proto.Common.ColumnValue parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.apache.calcite.avatica.proto.Common.ColumnValue prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code ColumnValue}
     *
     * <pre>
     * A value might be a TypedValue or an Array of TypedValue's
     * </pre>
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:ColumnValue)
        org.apache.calcite.avatica.proto.Common.ColumnValueOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.calcite.avatica.proto.Common.internal_static_ColumnValue_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.calcite.avatica.proto.Common.internal_static_ColumnValue_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.calcite.avatica.proto.Common.ColumnValue.class, org.apache.calcite.avatica.proto.Common.ColumnValue.Builder.class);
      }

      // Construct using org.apache.calcite.avatica.proto.Common.ColumnValue.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
          getValueFieldBuilder();
        }
      }
      public Builder clear() {
        super.clear();
        if (valueBuilder_ == null) {
          value_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
        } else {
          valueBuilder_.clear();
        }
        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.calcite.avatica.proto.Common.internal_static_ColumnValue_descriptor;
      }

      public org.apache.calcite.avatica.proto.Common.ColumnValue getDefaultInstanceForType() {
        return org.apache.calcite.avatica.proto.Common.ColumnValue.getDefaultInstance();
      }

      public org.apache.calcite.avatica.proto.Common.ColumnValue build() {
        org.apache.calcite.avatica.proto.Common.ColumnValue result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public org.apache.calcite.avatica.proto.Common.ColumnValue buildPartial() {
        org.apache.calcite.avatica.proto.Common.ColumnValue result = new org.apache.calcite.avatica.proto.Common.ColumnValue(this);
        int from_bitField0_ = bitField0_;
        if (valueBuilder_ == null) {
          if (((bitField0_ & 0x00000001) == 0x00000001)) {
            value_ = java.util.Collections.unmodifiableList(value_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.value_ = value_;
        } else {
          result.value_ = valueBuilder_.build();
        }
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.apache.calcite.avatica.proto.Common.ColumnValue) {
          return mergeFrom((org.apache.calcite.avatica.proto.Common.ColumnValue)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.calcite.avatica.proto.Common.ColumnValue other) {
        if (other == org.apache.calcite.avatica.proto.Common.ColumnValue.getDefaultInstance()) return this;
        if (valueBuilder_ == null) {
          if (!other.value_.isEmpty()) {
            if (value_.isEmpty()) {
              value_ = other.value_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureValueIsMutable();
              value_.addAll(other.value_);
            }
            onChanged();
          }
        } else {
          if (!other.value_.isEmpty()) {
            if (valueBuilder_.isEmpty()) {
              valueBuilder_.dispose();
              valueBuilder_ = null;
              value_ = other.value_;
              bitField0_ = (bitField0_ & ~0x00000001);
              valueBuilder_ = 
                com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders ?
                   getValueFieldBuilder() : null;
            } else {
              valueBuilder_.addAllMessages(other.value_);
            }
          }
        }
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        org.apache.calcite.avatica.proto.Common.ColumnValue parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (org.apache.calcite.avatica.proto.Common.ColumnValue) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private java.util.List<org.apache.calcite.avatica.proto.Common.TypedValue> value_ =
        java.util.Collections.emptyList();
      private void ensureValueIsMutable() {
        if (!((bitField0_ & 0x00000001) == 0x00000001)) {
          value_ = new java.util.ArrayList<org.apache.calcite.avatica.proto.Common.TypedValue>(value_);
          bitField0_ |= 0x00000001;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilder<
          org.apache.calcite.avatica.proto.Common.TypedValue, org.apache.calcite.avatica.proto.Common.TypedValue.Builder, org.apache.calcite.avatica.proto.Common.TypedValueOrBuilder> valueBuilder_;

      /**
       * <code>repeated .TypedValue value = 1;</code>
       */
      public java.util.List<org.apache.calcite.avatica.proto.Common.TypedValue> getValueList() {
        if (valueBuilder_ == null) {
          return java.util.Collections.unmodifiableList(value_);
        } else {
          return valueBuilder_.getMessageList();
        }
      }
      /**
       * <code>repeated .TypedValue value = 1;</code>
       */
      public int getValueCount() {
        if (valueBuilder_ == null) {
          return value_.size();
        } else {
          return valueBuilder_.getCount();
        }
      }
      /**
       * <code>repeated .TypedValue value = 1;</code>
       */
      public org.apache.calcite.avatica.proto.Common.TypedValue getValue(int index) {
        if (valueBuilder_ == null) {
          return value_.get(index);
        } else {
          return valueBuilder_.getMessage(index);
        }
      }
      /**
       * <code>repeated .TypedValue value = 1;</code>
       */
      public Builder setValue(
          int index, org.apache.calcite.avatica.proto.Common.TypedValue value) {
        if (valueBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureValueIsMutable();
          value_.set(index, value);
          onChanged();
        } else {
          valueBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .TypedValue value = 1;</code>
       */
      public Builder setValue(
          int index, org.apache.calcite.avatica.proto.Common.TypedValue.Builder builderForValue) {
        if (valueBuilder_ == null) {
          ensureValueIsMutable();
          value_.set(index, builderForValue.build());
          onChanged();
        } else {
          valueBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .TypedValue value = 1;</code>
       */
      public Builder addValue(org.apache.calcite.avatica.proto.Common.TypedValue value) {
        if (valueBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureValueIsMutable();
          value_.add(value);
          onChanged();
        } else {
          valueBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <code>repeated .TypedValue value = 1;</code>
       */
      public Builder addValue(
          int index, org.apache.calcite.avatica.proto.Common.TypedValue value) {
        if (valueBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureValueIsMutable();
          value_.add(index, value);
          onChanged();
        } else {
          valueBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .TypedValue value = 1;</code>
       */
      public Builder addValue(
          org.apache.calcite.avatica.proto.Common.TypedValue.Builder builderForValue) {
        if (valueBuilder_ == null) {
          ensureValueIsMutable();
          value_.add(builderForValue.build());
          onChanged();
        } else {
          valueBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .TypedValue value = 1;</code>
       */
      public Builder addValue(
          int index, org.apache.calcite.avatica.proto.Common.TypedValue.Builder builderForValue) {
        if (valueBuilder_ == null) {
          ensureValueIsMutable();
          value_.add(index, builderForValue.build());
          onChanged();
        } else {
          valueBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .TypedValue value = 1;</code>
       */
      public Builder addAllValue(
          java.lang.Iterable<? extends org.apache.calcite.avatica.proto.Common.TypedValue> values) {
        if (valueBuilder_ == null) {
          ensureValueIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, value_);
          onChanged();
        } else {
          valueBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <code>repeated .TypedValue value = 1;</code>
       */
      public Builder clearValue() {
        if (valueBuilder_ == null) {
          value_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          valueBuilder_.clear();
        }
        return this;
      }
      /**
       * <code>repeated .TypedValue value = 1;</code>
       */
      public Builder removeValue(int index) {
        if (valueBuilder_ == null) {
          ensureValueIsMutable();
          value_.remove(index);
          onChanged();
        } else {
          valueBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <code>repeated .TypedValue value = 1;</code>
       */
      public org.apache.calcite.avatica.proto.Common.TypedValue.Builder getValueBuilder(
          int index) {
        return getValueFieldBuilder().getBuilder(index);
      }
      /**
       * <code>repeated .TypedValue value = 1;</code>
       */
      public org.apache.calcite.avatica.proto.Common.TypedValueOrBuilder getValueOrBuilder(
          int index) {
        if (valueBuilder_ == null) {
          return value_.get(index);  } else {
          return valueBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <code>repeated .TypedValue value = 1;</code>
       */
      public java.util.List<? extends org.apache.calcite.avatica.proto.Common.TypedValueOrBuilder> 
           getValueOrBuilderList() {
        if (valueBuilder_ != null) {
          return valueBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(value_);
        }
      }
      /**
       * <code>repeated .TypedValue value = 1;</code>
       */
      public org.apache.calcite.avatica.proto.Common.TypedValue.Builder addValueBuilder() {
        return getValueFieldBuilder().addBuilder(
            org.apache.calcite.avatica.proto.Common.TypedValue.getDefaultInstance());
      }
      /**
       * <code>repeated .TypedValue value = 1;</code>
       */
      public org.apache.calcite.avatica.proto.Common.TypedValue.Builder addValueBuilder(
          int index) {
        return getValueFieldBuilder().addBuilder(
            index, org.apache.calcite.avatica.proto.Common.TypedValue.getDefaultInstance());
      }
      /**
       * <code>repeated .TypedValue value = 1;</code>
       */
      public java.util.List<org.apache.calcite.avatica.proto.Common.TypedValue.Builder> 
           getValueBuilderList() {
        return getValueFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilder<
          org.apache.calcite.avatica.proto.Common.TypedValue, org.apache.calcite.avatica.proto.Common.TypedValue.Builder, org.apache.calcite.avatica.proto.Common.TypedValueOrBuilder> 
          getValueFieldBuilder() {
        if (valueBuilder_ == null) {
          valueBuilder_ = new com.google.protobuf.RepeatedFieldBuilder<
              org.apache.calcite.avatica.proto.Common.TypedValue, org.apache.calcite.avatica.proto.Common.TypedValue.Builder, org.apache.calcite.avatica.proto.Common.TypedValueOrBuilder>(
                  value_,
                  ((bitField0_ & 0x00000001) == 0x00000001),
                  getParentForChildren(),
                  isClean());
          value_ = null;
        }
        return valueBuilder_;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return this;
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return this;
      }


      // @@protoc_insertion_point(builder_scope:ColumnValue)
    }

    // @@protoc_insertion_point(class_scope:ColumnValue)
    private static final org.apache.calcite.avatica.proto.Common.ColumnValue DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.apache.calcite.avatica.proto.Common.ColumnValue();
    }

    public static org.apache.calcite.avatica.proto.Common.ColumnValue getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ColumnValue>
        PARSER = new com.google.protobuf.AbstractParser<ColumnValue>() {
      public ColumnValue parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        try {
          return new ColumnValue(input, extensionRegistry);
        } catch (RuntimeException e) {
          if (e.getCause() instanceof
              com.google.protobuf.InvalidProtocolBufferException) {
            throw (com.google.protobuf.InvalidProtocolBufferException)
                e.getCause();
          }
          throw e;
        }
      }
    };

    public static com.google.protobuf.Parser<ColumnValue> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ColumnValue> getParserForType() {
      return PARSER;
    }

    public org.apache.calcite.avatica.proto.Common.ColumnValue getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface TypedValueOrBuilder extends
      // @@protoc_insertion_point(interface_extends:TypedValue)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>optional .Rep type = 1;</code>
     *
     * <pre>
     * The actual type that was serialized in the general attribute below
     * </pre>
     */
    int getTypeValue();
    /**
     * <code>optional .Rep type = 1;</code>
     *
     * <pre>
     * The actual type that was serialized in the general attribute below
     * </pre>
     */
    org.apache.calcite.avatica.proto.Common.Rep getType();

    /**
     * <code>optional bool bool_value = 2;</code>
     *
     * <pre>
     * boolean
     * </pre>
     */
    boolean getBoolValue();

    /**
     * <code>optional string string_value = 3;</code>
     *
     * <pre>
     * char/varchar
     * </pre>
     */
    java.lang.String getStringValue();
    /**
     * <code>optional string string_value = 3;</code>
     *
     * <pre>
     * char/varchar
     * </pre>
     */
    com.google.protobuf.ByteString
        getStringValueBytes();

    /**
     * <code>optional sint64 number_value = 4;</code>
     *
     * <pre>
     * var-len encoding lets us shove anything from byte to long
     * </pre>
     */
    long getNumberValue();

    /**
     * <code>optional bytes bytes_values = 5;</code>
     *
     * <pre>
     * includes numeric types and date/time types.
     * </pre>
     */
    com.google.protobuf.ByteString getBytesValues();

    /**
     * <code>optional double double_value = 6;</code>
     *
     * <pre>
     * big numbers
     * </pre>
     */
    double getDoubleValue();

    /**
     * <code>optional bool null = 7;</code>
     *
     * <pre>
     * a null object
     * </pre>
     */
    boolean getNull();
  }
  /**
   * Protobuf type {@code TypedValue}
   *
   * <pre>
   * Generic wrapper to support any SQL type. Struct-like to work around no polymorphism construct.
   * </pre>
   */
  public  static final class TypedValue extends
      com.google.protobuf.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:TypedValue)
      TypedValueOrBuilder {
    // Use TypedValue.newBuilder() to construct.
    private TypedValue(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
    }
    private TypedValue() {
      type_ = 0;
      boolValue_ = false;
      stringValue_ = "";
      numberValue_ = 0L;
      bytesValues_ = com.google.protobuf.ByteString.EMPTY;
      doubleValue_ = 0D;
      null_ = false;
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return com.google.protobuf.UnknownFieldSet.getDefaultInstance();
    }
    private TypedValue(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry) {
      this();
      int mutable_bitField0_ = 0;
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!input.skipField(tag)) {
                done = true;
              }
              break;
            }
            case 8: {
              int rawValue = input.readEnum();

              type_ = rawValue;
              break;
            }
            case 16: {

              boolValue_ = input.readBool();
              break;
            }
            case 26: {
              String s = input.readStringRequireUtf8();

              stringValue_ = s;
              break;
            }
            case 32: {

              numberValue_ = input.readSInt64();
              break;
            }
            case 42: {

              bytesValues_ = input.readBytes();
              break;
            }
            case 49: {

              doubleValue_ = input.readDouble();
              break;
            }
            case 56: {

              null_ = input.readBool();
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw new RuntimeException(e.setUnfinishedMessage(this));
      } catch (java.io.IOException e) {
        throw new RuntimeException(
            new com.google.protobuf.InvalidProtocolBufferException(
                e.getMessage()).setUnfinishedMessage(this));
      } finally {
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.calcite.avatica.proto.Common.internal_static_TypedValue_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.calcite.avatica.proto.Common.internal_static_TypedValue_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.calcite.avatica.proto.Common.TypedValue.class, org.apache.calcite.avatica.proto.Common.TypedValue.Builder.class);
    }

    public static final int TYPE_FIELD_NUMBER = 1;
    private int type_;
    /**
     * <code>optional .Rep type = 1;</code>
     *
     * <pre>
     * The actual type that was serialized in the general attribute below
     * </pre>
     */
    public int getTypeValue() {
      return type_;
    }
    /**
     * <code>optional .Rep type = 1;</code>
     *
     * <pre>
     * The actual type that was serialized in the general attribute below
     * </pre>
     */
    public org.apache.calcite.avatica.proto.Common.Rep getType() {
      org.apache.calcite.avatica.proto.Common.Rep result = org.apache.calcite.avatica.proto.Common.Rep.valueOf(type_);
      return result == null ? org.apache.calcite.avatica.proto.Common.Rep.UNRECOGNIZED : result;
    }

    public static final int BOOL_VALUE_FIELD_NUMBER = 2;
    private boolean boolValue_;
    /**
     * <code>optional bool bool_value = 2;</code>
     *
     * <pre>
     * boolean
     * </pre>
     */
    public boolean getBoolValue() {
      return boolValue_;
    }

    public static final int STRING_VALUE_FIELD_NUMBER = 3;
    private volatile java.lang.Object stringValue_;
    /**
     * <code>optional string string_value = 3;</code>
     *
     * <pre>
     * char/varchar
     * </pre>
     */
    public java.lang.String getStringValue() {
      java.lang.Object ref = stringValue_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        stringValue_ = s;
        return s;
      }
    }
    /**
     * <code>optional string string_value = 3;</code>
     *
     * <pre>
     * char/varchar
     * </pre>
     */
    public com.google.protobuf.ByteString
        getStringValueBytes() {
      java.lang.Object ref = stringValue_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        stringValue_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int NUMBER_VALUE_FIELD_NUMBER = 4;
    private long numberValue_;
    /**
     * <code>optional sint64 number_value = 4;</code>
     *
     * <pre>
     * var-len encoding lets us shove anything from byte to long
     * </pre>
     */
    public long getNumberValue() {
      return numberValue_;
    }

    public static final int BYTES_VALUES_FIELD_NUMBER = 5;
    private com.google.protobuf.ByteString bytesValues_;
    /**
     * <code>optional bytes bytes_values = 5;</code>
     *
     * <pre>
     * includes numeric types and date/time types.
     * </pre>
     */
    public com.google.protobuf.ByteString getBytesValues() {
      return bytesValues_;
    }

    public static final int DOUBLE_VALUE_FIELD_NUMBER = 6;
    private double doubleValue_;
    /**
     * <code>optional double double_value = 6;</code>
     *
     * <pre>
     * big numbers
     * </pre>
     */
    public double getDoubleValue() {
      return doubleValue_;
    }

    public static final int NULL_FIELD_NUMBER = 7;
    private boolean null_;
    /**
     * <code>optional bool null = 7;</code>
     *
     * <pre>
     * a null object
     * </pre>
     */
    public boolean getNull() {
      return null_;
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (type_ != org.apache.calcite.avatica.proto.Common.Rep.PRIMITIVE_BOOLEAN.getNumber()) {
        output.writeEnum(1, type_);
      }
      if (boolValue_ != false) {
        output.writeBool(2, boolValue_);
      }
      if (!getStringValueBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessage.writeString(output, 3, stringValue_);
      }
      if (numberValue_ != 0L) {
        output.writeSInt64(4, numberValue_);
      }
      if (!bytesValues_.isEmpty()) {
        output.writeBytes(5, bytesValues_);
      }
      if (doubleValue_ != 0D) {
        output.writeDouble(6, doubleValue_);
      }
      if (null_ != false) {
        output.writeBool(7, null_);
      }
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (type_ != org.apache.calcite.avatica.proto.Common.Rep.PRIMITIVE_BOOLEAN.getNumber()) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(1, type_);
      }
      if (boolValue_ != false) {
        size += com.google.protobuf.CodedOutputStream
          .computeBoolSize(2, boolValue_);
      }
      if (!getStringValueBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessage.computeStringSize(3, stringValue_);
      }
      if (numberValue_ != 0L) {
        size += com.google.protobuf.CodedOutputStream
          .computeSInt64Size(4, numberValue_);
      }
      if (!bytesValues_.isEmpty()) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(5, bytesValues_);
      }
      if (doubleValue_ != 0D) {
        size += com.google.protobuf.CodedOutputStream
          .computeDoubleSize(6, doubleValue_);
      }
      if (null_ != false) {
        size += com.google.protobuf.CodedOutputStream
          .computeBoolSize(7, null_);
      }
      memoizedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    public static org.apache.calcite.avatica.proto.Common.TypedValue parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.calcite.avatica.proto.Common.TypedValue parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.calcite.avatica.proto.Common.TypedValue parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.calcite.avatica.proto.Common.TypedValue parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.calcite.avatica.proto.Common.TypedValue parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.calcite.avatica.proto.Common.TypedValue parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static org.apache.calcite.avatica.proto.Common.TypedValue parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static org.apache.calcite.avatica.proto.Common.TypedValue parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static org.apache.calcite.avatica.proto.Common.TypedValue parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.calcite.avatica.proto.Common.TypedValue parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.apache.calcite.avatica.proto.Common.TypedValue prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code TypedValue}
     *
     * <pre>
     * Generic wrapper to support any SQL type. Struct-like to work around no polymorphism construct.
     * </pre>
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:TypedValue)
        org.apache.calcite.avatica.proto.Common.TypedValueOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.calcite.avatica.proto.Common.internal_static_TypedValue_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.calcite.avatica.proto.Common.internal_static_TypedValue_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.calcite.avatica.proto.Common.TypedValue.class, org.apache.calcite.avatica.proto.Common.TypedValue.Builder.class);
      }

      // Construct using org.apache.calcite.avatica.proto.Common.TypedValue.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
        }
      }
      public Builder clear() {
        super.clear();
        type_ = 0;

        boolValue_ = false;

        stringValue_ = "";

        numberValue_ = 0L;

        bytesValues_ = com.google.protobuf.ByteString.EMPTY;

        doubleValue_ = 0D;

        null_ = false;

        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.calcite.avatica.proto.Common.internal_static_TypedValue_descriptor;
      }

      public org.apache.calcite.avatica.proto.Common.TypedValue getDefaultInstanceForType() {
        return org.apache.calcite.avatica.proto.Common.TypedValue.getDefaultInstance();
      }

      public org.apache.calcite.avatica.proto.Common.TypedValue build() {
        org.apache.calcite.avatica.proto.Common.TypedValue result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public org.apache.calcite.avatica.proto.Common.TypedValue buildPartial() {
        org.apache.calcite.avatica.proto.Common.TypedValue result = new org.apache.calcite.avatica.proto.Common.TypedValue(this);
        result.type_ = type_;
        result.boolValue_ = boolValue_;
        result.stringValue_ = stringValue_;
        result.numberValue_ = numberValue_;
        result.bytesValues_ = bytesValues_;
        result.doubleValue_ = doubleValue_;
        result.null_ = null_;
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.apache.calcite.avatica.proto.Common.TypedValue) {
          return mergeFrom((org.apache.calcite.avatica.proto.Common.TypedValue)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.calcite.avatica.proto.Common.TypedValue other) {
        if (other == org.apache.calcite.avatica.proto.Common.TypedValue.getDefaultInstance()) return this;
        if (other.type_ != 0) {
          setTypeValue(other.getTypeValue());
        }
        if (other.getBoolValue() != false) {
          setBoolValue(other.getBoolValue());
        }
        if (!other.getStringValue().isEmpty()) {
          stringValue_ = other.stringValue_;
          onChanged();
        }
        if (other.getNumberValue() != 0L) {
          setNumberValue(other.getNumberValue());
        }
        if (other.getBytesValues() != com.google.protobuf.ByteString.EMPTY) {
          setBytesValues(other.getBytesValues());
        }
        if (other.getDoubleValue() != 0D) {
          setDoubleValue(other.getDoubleValue());
        }
        if (other.getNull() != false) {
          setNull(other.getNull());
        }
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        org.apache.calcite.avatica.proto.Common.TypedValue parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (org.apache.calcite.avatica.proto.Common.TypedValue) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private int type_ = 0;
      /**
       * <code>optional .Rep type = 1;</code>
       *
       * <pre>
       * The actual type that was serialized in the general attribute below
       * </pre>
       */
      public int getTypeValue() {
        return type_;
      }
      /**
       * <code>optional .Rep type = 1;</code>
       *
       * <pre>
       * The actual type that was serialized in the general attribute below
       * </pre>
       */
      public Builder setTypeValue(int value) {
        type_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional .Rep type = 1;</code>
       *
       * <pre>
       * The actual type that was serialized in the general attribute below
       * </pre>
       */
      public org.apache.calcite.avatica.proto.Common.Rep getType() {
        org.apache.calcite.avatica.proto.Common.Rep result = org.apache.calcite.avatica.proto.Common.Rep.valueOf(type_);
        return result == null ? org.apache.calcite.avatica.proto.Common.Rep.UNRECOGNIZED : result;
      }
      /**
       * <code>optional .Rep type = 1;</code>
       *
       * <pre>
       * The actual type that was serialized in the general attribute below
       * </pre>
       */
      public Builder setType(org.apache.calcite.avatica.proto.Common.Rep value) {
        if (value == null) {
          throw new NullPointerException();
        }
        
        type_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       * <code>optional .Rep type = 1;</code>
       *
       * <pre>
       * The actual type that was serialized in the general attribute below
       * </pre>
       */
      public Builder clearType() {
        
        type_ = 0;
        onChanged();
        return this;
      }

      private boolean boolValue_ ;
      /**
       * <code>optional bool bool_value = 2;</code>
       *
       * <pre>
       * boolean
       * </pre>
       */
      public boolean getBoolValue() {
        return boolValue_;
      }
      /**
       * <code>optional bool bool_value = 2;</code>
       *
       * <pre>
       * boolean
       * </pre>
       */
      public Builder setBoolValue(boolean value) {
        
        boolValue_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional bool bool_value = 2;</code>
       *
       * <pre>
       * boolean
       * </pre>
       */
      public Builder clearBoolValue() {
        
        boolValue_ = false;
        onChanged();
        return this;
      }

      private java.lang.Object stringValue_ = "";
      /**
       * <code>optional string string_value = 3;</code>
       *
       * <pre>
       * char/varchar
       * </pre>
       */
      public java.lang.String getStringValue() {
        java.lang.Object ref = stringValue_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          stringValue_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>optional string string_value = 3;</code>
       *
       * <pre>
       * char/varchar
       * </pre>
       */
      public com.google.protobuf.ByteString
          getStringValueBytes() {
        java.lang.Object ref = stringValue_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          stringValue_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>optional string string_value = 3;</code>
       *
       * <pre>
       * char/varchar
       * </pre>
       */
      public Builder setStringValue(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        stringValue_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional string string_value = 3;</code>
       *
       * <pre>
       * char/varchar
       * </pre>
       */
      public Builder clearStringValue() {
        
        stringValue_ = getDefaultInstance().getStringValue();
        onChanged();
        return this;
      }
      /**
       * <code>optional string string_value = 3;</code>
       *
       * <pre>
       * char/varchar
       * </pre>
       */
      public Builder setStringValueBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        stringValue_ = value;
        onChanged();
        return this;
      }

      private long numberValue_ ;
      /**
       * <code>optional sint64 number_value = 4;</code>
       *
       * <pre>
       * var-len encoding lets us shove anything from byte to long
       * </pre>
       */
      public long getNumberValue() {
        return numberValue_;
      }
      /**
       * <code>optional sint64 number_value = 4;</code>
       *
       * <pre>
       * var-len encoding lets us shove anything from byte to long
       * </pre>
       */
      public Builder setNumberValue(long value) {
        
        numberValue_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional sint64 number_value = 4;</code>
       *
       * <pre>
       * var-len encoding lets us shove anything from byte to long
       * </pre>
       */
      public Builder clearNumberValue() {
        
        numberValue_ = 0L;
        onChanged();
        return this;
      }

      private com.google.protobuf.ByteString bytesValues_ = com.google.protobuf.ByteString.EMPTY;
      /**
       * <code>optional bytes bytes_values = 5;</code>
       *
       * <pre>
       * includes numeric types and date/time types.
       * </pre>
       */
      public com.google.protobuf.ByteString getBytesValues() {
        return bytesValues_;
      }
      /**
       * <code>optional bytes bytes_values = 5;</code>
       *
       * <pre>
       * includes numeric types and date/time types.
       * </pre>
       */
      public Builder setBytesValues(com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        bytesValues_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional bytes bytes_values = 5;</code>
       *
       * <pre>
       * includes numeric types and date/time types.
       * </pre>
       */
      public Builder clearBytesValues() {
        
        bytesValues_ = getDefaultInstance().getBytesValues();
        onChanged();
        return this;
      }

      private double doubleValue_ ;
      /**
       * <code>optional double double_value = 6;</code>
       *
       * <pre>
       * big numbers
       * </pre>
       */
      public double getDoubleValue() {
        return doubleValue_;
      }
      /**
       * <code>optional double double_value = 6;</code>
       *
       * <pre>
       * big numbers
       * </pre>
       */
      public Builder setDoubleValue(double value) {
        
        doubleValue_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional double double_value = 6;</code>
       *
       * <pre>
       * big numbers
       * </pre>
       */
      public Builder clearDoubleValue() {
        
        doubleValue_ = 0D;
        onChanged();
        return this;
      }

      private boolean null_ ;
      /**
       * <code>optional bool null = 7;</code>
       *
       * <pre>
       * a null object
       * </pre>
       */
      public boolean getNull() {
        return null_;
      }
      /**
       * <code>optional bool null = 7;</code>
       *
       * <pre>
       * a null object
       * </pre>
       */
      public Builder setNull(boolean value) {
        
        null_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional bool null = 7;</code>
       *
       * <pre>
       * a null object
       * </pre>
       */
      public Builder clearNull() {
        
        null_ = false;
        onChanged();
        return this;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return this;
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return this;
      }


      // @@protoc_insertion_point(builder_scope:TypedValue)
    }

    // @@protoc_insertion_point(class_scope:TypedValue)
    private static final org.apache.calcite.avatica.proto.Common.TypedValue DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.apache.calcite.avatica.proto.Common.TypedValue();
    }

    public static org.apache.calcite.avatica.proto.Common.TypedValue getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<TypedValue>
        PARSER = new com.google.protobuf.AbstractParser<TypedValue>() {
      public TypedValue parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        try {
          return new TypedValue(input, extensionRegistry);
        } catch (RuntimeException e) {
          if (e.getCause() instanceof
              com.google.protobuf.InvalidProtocolBufferException) {
            throw (com.google.protobuf.InvalidProtocolBufferException)
                e.getCause();
          }
          throw e;
        }
      }
    };

    public static com.google.protobuf.Parser<TypedValue> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<TypedValue> getParserForType() {
      return PARSER;
    }

    public org.apache.calcite.avatica.proto.Common.TypedValue getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface MetaDataOperationArgumentOrBuilder extends
      // @@protoc_insertion_point(interface_extends:MetaDataOperationArgument)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>optional string string_value = 1;</code>
     */
    java.lang.String getStringValue();
    /**
     * <code>optional string string_value = 1;</code>
     */
    com.google.protobuf.ByteString
        getStringValueBytes();

    /**
     * <code>optional bool bool_value = 2;</code>
     */
    boolean getBoolValue();

    /**
     * <code>optional sint32 int_value = 3;</code>
     */
    int getIntValue();

    /**
     * <code>repeated string string_array_values = 4;</code>
     */
    com.google.protobuf.ProtocolStringList
        getStringArrayValuesList();
    /**
     * <code>repeated string string_array_values = 4;</code>
     */
    int getStringArrayValuesCount();
    /**
     * <code>repeated string string_array_values = 4;</code>
     */
    java.lang.String getStringArrayValues(int index);
    /**
     * <code>repeated string string_array_values = 4;</code>
     */
    com.google.protobuf.ByteString
        getStringArrayValuesBytes(int index);

    /**
     * <code>repeated sint32 int_array_values = 5;</code>
     */
    java.util.List<java.lang.Integer> getIntArrayValuesList();
    /**
     * <code>repeated sint32 int_array_values = 5;</code>
     */
    int getIntArrayValuesCount();
    /**
     * <code>repeated sint32 int_array_values = 5;</code>
     */
    int getIntArrayValues(int index);

    /**
     * <code>optional .MetaDataOperationArgument.ArgumentType type = 6;</code>
     */
    int getTypeValue();
    /**
     * <code>optional .MetaDataOperationArgument.ArgumentType type = 6;</code>
     */
    org.apache.calcite.avatica.proto.Common.MetaDataOperationArgument.ArgumentType getType();
  }
  /**
   * Protobuf type {@code MetaDataOperationArgument}
   *
   * <pre>
   * Represents the breadth of arguments to DatabaseMetaData functions
   * </pre>
   */
  public  static final class MetaDataOperationArgument extends
      com.google.protobuf.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:MetaDataOperationArgument)
      MetaDataOperationArgumentOrBuilder {
    // Use MetaDataOperationArgument.newBuilder() to construct.
    private MetaDataOperationArgument(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
    }
    private MetaDataOperationArgument() {
      stringValue_ = "";
      boolValue_ = false;
      intValue_ = 0;
      stringArrayValues_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      intArrayValues_ = java.util.Collections.emptyList();
      type_ = 0;
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return com.google.protobuf.UnknownFieldSet.getDefaultInstance();
    }
    private MetaDataOperationArgument(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry) {
      this();
      int mutable_bitField0_ = 0;
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!input.skipField(tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              String s = input.readStringRequireUtf8();

              stringValue_ = s;
              break;
            }
            case 16: {

              boolValue_ = input.readBool();
              break;
            }
            case 24: {

              intValue_ = input.readSInt32();
              break;
            }
            case 34: {
              String s = input.readStringRequireUtf8();
              if (!((mutable_bitField0_ & 0x00000008) == 0x00000008)) {
                stringArrayValues_ = new com.google.protobuf.LazyStringArrayList();
                mutable_bitField0_ |= 0x00000008;
              }
              stringArrayValues_.add(s);
              break;
            }
            case 40: {
              if (!((mutable_bitField0_ & 0x00000010) == 0x00000010)) {
                intArrayValues_ = new java.util.ArrayList<java.lang.Integer>();
                mutable_bitField0_ |= 0x00000010;
              }
              intArrayValues_.add(input.readSInt32());
              break;
            }
            case 42: {
              int length = input.readRawVarint32();
              int limit = input.pushLimit(length);
              if (!((mutable_bitField0_ & 0x00000010) == 0x00000010) && input.getBytesUntilLimit() > 0) {
                intArrayValues_ = new java.util.ArrayList<java.lang.Integer>();
                mutable_bitField0_ |= 0x00000010;
              }
              while (input.getBytesUntilLimit() > 0) {
                intArrayValues_.add(input.readSInt32());
              }
              input.popLimit(limit);
              break;
            }
            case 48: {
              int rawValue = input.readEnum();

              type_ = rawValue;
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw new RuntimeException(e.setUnfinishedMessage(this));
      } catch (java.io.IOException e) {
        throw new RuntimeException(
            new com.google.protobuf.InvalidProtocolBufferException(
                e.getMessage()).setUnfinishedMessage(this));
      } finally {
        if (((mutable_bitField0_ & 0x00000008) == 0x00000008)) {
          stringArrayValues_ = stringArrayValues_.getUnmodifiableView();
        }
        if (((mutable_bitField0_ & 0x00000010) == 0x00000010)) {
          intArrayValues_ = java.util.Collections.unmodifiableList(intArrayValues_);
        }
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.calcite.avatica.proto.Common.internal_static_MetaDataOperationArgument_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.calcite.avatica.proto.Common.internal_static_MetaDataOperationArgument_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.calcite.avatica.proto.Common.MetaDataOperationArgument.class, org.apache.calcite.avatica.proto.Common.MetaDataOperationArgument.Builder.class);
    }

    /**
     * Protobuf enum {@code MetaDataOperationArgument.ArgumentType}
     */
    public enum ArgumentType
        implements com.google.protobuf.ProtocolMessageEnum {
      /**
       * <code>STRING = 0;</code>
       */
      STRING(0, 0),
      /**
       * <code>BOOL = 1;</code>
       */
      BOOL(1, 1),
      /**
       * <code>INT = 2;</code>
       */
      INT(2, 2),
      /**
       * <code>REPEATED_STRING = 3;</code>
       */
      REPEATED_STRING(3, 3),
      /**
       * <code>REPEATED_INT = 4;</code>
       */
      REPEATED_INT(4, 4),
      /**
       * <code>NULL = 5;</code>
       */
      NULL(5, 5),
      UNRECOGNIZED(-1, -1),
      ;

      /**
       * <code>STRING = 0;</code>
       */
      public static final int STRING_VALUE = 0;
      /**
       * <code>BOOL = 1;</code>
       */
      public static final int BOOL_VALUE = 1;
      /**
       * <code>INT = 2;</code>
       */
      public static final int INT_VALUE = 2;
      /**
       * <code>REPEATED_STRING = 3;</code>
       */
      public static final int REPEATED_STRING_VALUE = 3;
      /**
       * <code>REPEATED_INT = 4;</code>
       */
      public static final int REPEATED_INT_VALUE = 4;
      /**
       * <code>NULL = 5;</code>
       */
      public static final int NULL_VALUE = 5;


      public final int getNumber() {
        if (index == -1) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      public static ArgumentType valueOf(int value) {
        switch (value) {
          case 0: return STRING;
          case 1: return BOOL;
          case 2: return INT;
          case 3: return REPEATED_STRING;
          case 4: return REPEATED_INT;
          case 5: return NULL;
          default: return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<ArgumentType>
          internalGetValueMap() {
        return internalValueMap;
      }
      private static final com.google.protobuf.Internal.EnumLiteMap<
          ArgumentType> internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<ArgumentType>() {
              public ArgumentType findValueByNumber(int number) {
                return ArgumentType.valueOf(number);
              }
            };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor
          getValueDescriptor() {
        return getDescriptor().getValues().get(index);
      }
      public final com.google.protobuf.Descriptors.EnumDescriptor
          getDescriptorForType() {
        return getDescriptor();
      }
      public static final com.google.protobuf.Descriptors.EnumDescriptor
          getDescriptor() {
        return org.apache.calcite.avatica.proto.Common.MetaDataOperationArgument.getDescriptor().getEnumTypes().get(0);
      }

      private static final ArgumentType[] VALUES = values();

      public static ArgumentType valueOf(
          com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException(
            "EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int index;
      private final int value;

      private ArgumentType(int index, int value) {
        this.index = index;
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:MetaDataOperationArgument.ArgumentType)
    }

    private int bitField0_;
    public static final int STRING_VALUE_FIELD_NUMBER = 1;
    private volatile java.lang.Object stringValue_;
    /**
     * <code>optional string string_value = 1;</code>
     */
    public java.lang.String getStringValue() {
      java.lang.Object ref = stringValue_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        stringValue_ = s;
        return s;
      }
    }
    /**
     * <code>optional string string_value = 1;</code>
     */
    public com.google.protobuf.ByteString
        getStringValueBytes() {
      java.lang.Object ref = stringValue_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        stringValue_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int BOOL_VALUE_FIELD_NUMBER = 2;
    private boolean boolValue_;
    /**
     * <code>optional bool bool_value = 2;</code>
     */
    public boolean getBoolValue() {
      return boolValue_;
    }

    public static final int INT_VALUE_FIELD_NUMBER = 3;
    private int intValue_;
    /**
     * <code>optional sint32 int_value = 3;</code>
     */
    public int getIntValue() {
      return intValue_;
    }

    public static final int STRING_ARRAY_VALUES_FIELD_NUMBER = 4;
    private com.google.protobuf.LazyStringList stringArrayValues_;
    /**
     * <code>repeated string string_array_values = 4;</code>
     */
    public com.google.protobuf.ProtocolStringList
        getStringArrayValuesList() {
      return stringArrayValues_;
    }
    /**
     * <code>repeated string string_array_values = 4;</code>
     */
    public int getStringArrayValuesCount() {
      return stringArrayValues_.size();
    }
    /**
     * <code>repeated string string_array_values = 4;</code>
     */
    public java.lang.String getStringArrayValues(int index) {
      return stringArrayValues_.get(index);
    }
    /**
     * <code>repeated string string_array_values = 4;</code>
     */
    public com.google.protobuf.ByteString
        getStringArrayValuesBytes(int index) {
      return stringArrayValues_.getByteString(index);
    }

    public static final int INT_ARRAY_VALUES_FIELD_NUMBER = 5;
    private java.util.List<java.lang.Integer> intArrayValues_;
    /**
     * <code>repeated sint32 int_array_values = 5;</code>
     */
    public java.util.List<java.lang.Integer>
        getIntArrayValuesList() {
      return intArrayValues_;
    }
    /**
     * <code>repeated sint32 int_array_values = 5;</code>
     */
    public int getIntArrayValuesCount() {
      return intArrayValues_.size();
    }
    /**
     * <code>repeated sint32 int_array_values = 5;</code>
     */
    public int getIntArrayValues(int index) {
      return intArrayValues_.get(index);
    }
    private int intArrayValuesMemoizedSerializedSize = -1;

    public static final int TYPE_FIELD_NUMBER = 6;
    private int type_;
    /**
     * <code>optional .MetaDataOperationArgument.ArgumentType type = 6;</code>
     */
    public int getTypeValue() {
      return type_;
    }
    /**
     * <code>optional .MetaDataOperationArgument.ArgumentType type = 6;</code>
     */
    public org.apache.calcite.avatica.proto.Common.MetaDataOperationArgument.ArgumentType getType() {
      org.apache.calcite.avatica.proto.Common.MetaDataOperationArgument.ArgumentType result = org.apache.calcite.avatica.proto.Common.MetaDataOperationArgument.ArgumentType.valueOf(type_);
      return result == null ? org.apache.calcite.avatica.proto.Common.MetaDataOperationArgument.ArgumentType.UNRECOGNIZED : result;
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      if (!getStringValueBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessage.writeString(output, 1, stringValue_);
      }
      if (boolValue_ != false) {
        output.writeBool(2, boolValue_);
      }
      if (intValue_ != 0) {
        output.writeSInt32(3, intValue_);
      }
      for (int i = 0; i < stringArrayValues_.size(); i++) {
        com.google.protobuf.GeneratedMessage.writeString(output, 4, stringArrayValues_.getRaw(i));
      }
      if (getIntArrayValuesList().size() > 0) {
        output.writeRawVarint32(42);
        output.writeRawVarint32(intArrayValuesMemoizedSerializedSize);
      }
      for (int i = 0; i < intArrayValues_.size(); i++) {
        output.writeSInt32NoTag(intArrayValues_.get(i));
      }
      if (type_ != org.apache.calcite.avatica.proto.Common.MetaDataOperationArgument.ArgumentType.STRING.getNumber()) {
        output.writeEnum(6, type_);
      }
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!getStringValueBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessage.computeStringSize(1, stringValue_);
      }
      if (boolValue_ != false) {
        size += com.google.protobuf.CodedOutputStream
          .computeBoolSize(2, boolValue_);
      }
      if (intValue_ != 0) {
        size += com.google.protobuf.CodedOutputStream
          .computeSInt32Size(3, intValue_);
      }
      {
        int dataSize = 0;
        for (int i = 0; i < stringArrayValues_.size(); i++) {
          dataSize += computeStringSizeNoTag(stringArrayValues_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getStringArrayValuesList().size();
      }
      {
        int dataSize = 0;
        for (int i = 0; i < intArrayValues_.size(); i++) {
          dataSize += com.google.protobuf.CodedOutputStream
            .computeSInt32SizeNoTag(intArrayValues_.get(i));
        }
        size += dataSize;
        if (!getIntArrayValuesList().isEmpty()) {
          size += 1;
          size += com.google.protobuf.CodedOutputStream
              .computeInt32SizeNoTag(dataSize);
        }
        intArrayValuesMemoizedSerializedSize = dataSize;
      }
      if (type_ != org.apache.calcite.avatica.proto.Common.MetaDataOperationArgument.ArgumentType.STRING.getNumber()) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(6, type_);
      }
      memoizedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    public static org.apache.calcite.avatica.proto.Common.MetaDataOperationArgument parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.calcite.avatica.proto.Common.MetaDataOperationArgument parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.calcite.avatica.proto.Common.MetaDataOperationArgument parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.calcite.avatica.proto.Common.MetaDataOperationArgument parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.calcite.avatica.proto.Common.MetaDataOperationArgument parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.calcite.avatica.proto.Common.MetaDataOperationArgument parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static org.apache.calcite.avatica.proto.Common.MetaDataOperationArgument parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static org.apache.calcite.avatica.proto.Common.MetaDataOperationArgument parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static org.apache.calcite.avatica.proto.Common.MetaDataOperationArgument parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.calcite.avatica.proto.Common.MetaDataOperationArgument parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.apache.calcite.avatica.proto.Common.MetaDataOperationArgument prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code MetaDataOperationArgument}
     *
     * <pre>
     * Represents the breadth of arguments to DatabaseMetaData functions
     * </pre>
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:MetaDataOperationArgument)
        org.apache.calcite.avatica.proto.Common.MetaDataOperationArgumentOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.calcite.avatica.proto.Common.internal_static_MetaDataOperationArgument_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.calcite.avatica.proto.Common.internal_static_MetaDataOperationArgument_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.calcite.avatica.proto.Common.MetaDataOperationArgument.class, org.apache.calcite.avatica.proto.Common.MetaDataOperationArgument.Builder.class);
      }

      // Construct using org.apache.calcite.avatica.proto.Common.MetaDataOperationArgument.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
        }
      }
      public Builder clear() {
        super.clear();
        stringValue_ = "";

        boolValue_ = false;

        intValue_ = 0;

        stringArrayValues_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000008);
        intArrayValues_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000010);
        type_ = 0;

        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.calcite.avatica.proto.Common.internal_static_MetaDataOperationArgument_descriptor;
      }

      public org.apache.calcite.avatica.proto.Common.MetaDataOperationArgument getDefaultInstanceForType() {
        return org.apache.calcite.avatica.proto.Common.MetaDataOperationArgument.getDefaultInstance();
      }

      public org.apache.calcite.avatica.proto.Common.MetaDataOperationArgument build() {
        org.apache.calcite.avatica.proto.Common.MetaDataOperationArgument result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public org.apache.calcite.avatica.proto.Common.MetaDataOperationArgument buildPartial() {
        org.apache.calcite.avatica.proto.Common.MetaDataOperationArgument result = new org.apache.calcite.avatica.proto.Common.MetaDataOperationArgument(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        result.stringValue_ = stringValue_;
        result.boolValue_ = boolValue_;
        result.intValue_ = intValue_;
        if (((bitField0_ & 0x00000008) == 0x00000008)) {
          stringArrayValues_ = stringArrayValues_.getUnmodifiableView();
          bitField0_ = (bitField0_ & ~0x00000008);
        }
        result.stringArrayValues_ = stringArrayValues_;
        if (((bitField0_ & 0x00000010) == 0x00000010)) {
          intArrayValues_ = java.util.Collections.unmodifiableList(intArrayValues_);
          bitField0_ = (bitField0_ & ~0x00000010);
        }
        result.intArrayValues_ = intArrayValues_;
        result.type_ = type_;
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.apache.calcite.avatica.proto.Common.MetaDataOperationArgument) {
          return mergeFrom((org.apache.calcite.avatica.proto.Common.MetaDataOperationArgument)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.calcite.avatica.proto.Common.MetaDataOperationArgument other) {
        if (other == org.apache.calcite.avatica.proto.Common.MetaDataOperationArgument.getDefaultInstance()) return this;
        if (!other.getStringValue().isEmpty()) {
          stringValue_ = other.stringValue_;
          onChanged();
        }
        if (other.getBoolValue() != false) {
          setBoolValue(other.getBoolValue());
        }
        if (other.getIntValue() != 0) {
          setIntValue(other.getIntValue());
        }
        if (!other.stringArrayValues_.isEmpty()) {
          if (stringArrayValues_.isEmpty()) {
            stringArrayValues_ = other.stringArrayValues_;
            bitField0_ = (bitField0_ & ~0x00000008);
          } else {
            ensureStringArrayValuesIsMutable();
            stringArrayValues_.addAll(other.stringArrayValues_);
          }
          onChanged();
        }
        if (!other.intArrayValues_.isEmpty()) {
          if (intArrayValues_.isEmpty()) {
            intArrayValues_ = other.intArrayValues_;
            bitField0_ = (bitField0_ & ~0x00000010);
          } else {
            ensureIntArrayValuesIsMutable();
            intArrayValues_.addAll(other.intArrayValues_);
          }
          onChanged();
        }
        if (other.type_ != 0) {
          setTypeValue(other.getTypeValue());
        }
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        org.apache.calcite.avatica.proto.Common.MetaDataOperationArgument parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (org.apache.calcite.avatica.proto.Common.MetaDataOperationArgument) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private java.lang.Object stringValue_ = "";
      /**
       * <code>optional string string_value = 1;</code>
       */
      public java.lang.String getStringValue() {
        java.lang.Object ref = stringValue_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          stringValue_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>optional string string_value = 1;</code>
       */
      public com.google.protobuf.ByteString
          getStringValueBytes() {
        java.lang.Object ref = stringValue_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          stringValue_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>optional string string_value = 1;</code>
       */
      public Builder setStringValue(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        stringValue_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional string string_value = 1;</code>
       */
      public Builder clearStringValue() {
        
        stringValue_ = getDefaultInstance().getStringValue();
        onChanged();
        return this;
      }
      /**
       * <code>optional string string_value = 1;</code>
       */
      public Builder setStringValueBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        stringValue_ = value;
        onChanged();
        return this;
      }

      private boolean boolValue_ ;
      /**
       * <code>optional bool bool_value = 2;</code>
       */
      public boolean getBoolValue() {
        return boolValue_;
      }
      /**
       * <code>optional bool bool_value = 2;</code>
       */
      public Builder setBoolValue(boolean value) {
        
        boolValue_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional bool bool_value = 2;</code>
       */
      public Builder clearBoolValue() {
        
        boolValue_ = false;
        onChanged();
        return this;
      }

      private int intValue_ ;
      /**
       * <code>optional sint32 int_value = 3;</code>
       */
      public int getIntValue() {
        return intValue_;
      }
      /**
       * <code>optional sint32 int_value = 3;</code>
       */
      public Builder setIntValue(int value) {
        
        intValue_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional sint32 int_value = 3;</code>
       */
      public Builder clearIntValue() {
        
        intValue_ = 0;
        onChanged();
        return this;
      }

      private com.google.protobuf.LazyStringList stringArrayValues_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      private void ensureStringArrayValuesIsMutable() {
        if (!((bitField0_ & 0x00000008) == 0x00000008)) {
          stringArrayValues_ = new com.google.protobuf.LazyStringArrayList(stringArrayValues_);
          bitField0_ |= 0x00000008;
         }
      }
      /**
       * <code>repeated string string_array_values = 4;</code>
       */
      public com.google.protobuf.ProtocolStringList
          getStringArrayValuesList() {
        return stringArrayValues_.getUnmodifiableView();
      }
      /**
       * <code>repeated string string_array_values = 4;</code>
       */
      public int getStringArrayValuesCount() {
        return stringArrayValues_.size();
      }
      /**
       * <code>repeated string string_array_values = 4;</code>
       */
      public java.lang.String getStringArrayValues(int index) {
        return stringArrayValues_.get(index);
      }
      /**
       * <code>repeated string string_array_values = 4;</code>
       */
      public com.google.protobuf.ByteString
          getStringArrayValuesBytes(int index) {
        return stringArrayValues_.getByteString(index);
      }
      /**
       * <code>repeated string string_array_values = 4;</code>
       */
      public Builder setStringArrayValues(
          int index, java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  ensureStringArrayValuesIsMutable();
        stringArrayValues_.set(index, value);
        onChanged();
        return this;
      }
      /**
       * <code>repeated string string_array_values = 4;</code>
       */
      public Builder addStringArrayValues(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  ensureStringArrayValuesIsMutable();
        stringArrayValues_.add(value);
        onChanged();
        return this;
      }
      /**
       * <code>repeated string string_array_values = 4;</code>
       */
      public Builder addAllStringArrayValues(
          java.lang.Iterable<java.lang.String> values) {
        ensureStringArrayValuesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, stringArrayValues_);
        onChanged();
        return this;
      }
      /**
       * <code>repeated string string_array_values = 4;</code>
       */
      public Builder clearStringArrayValues() {
        stringArrayValues_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
        return this;
      }
      /**
       * <code>repeated string string_array_values = 4;</code>
       */
      public Builder addStringArrayValuesBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        ensureStringArrayValuesIsMutable();
        stringArrayValues_.add(value);
        onChanged();
        return this;
      }

      private java.util.List<java.lang.Integer> intArrayValues_ = java.util.Collections.emptyList();
      private void ensureIntArrayValuesIsMutable() {
        if (!((bitField0_ & 0x00000010) == 0x00000010)) {
          intArrayValues_ = new java.util.ArrayList<java.lang.Integer>(intArrayValues_);
          bitField0_ |= 0x00000010;
         }
      }
      /**
       * <code>repeated sint32 int_array_values = 5;</code>
       */
      public java.util.List<java.lang.Integer>
          getIntArrayValuesList() {
        return java.util.Collections.unmodifiableList(intArrayValues_);
      }
      /**
       * <code>repeated sint32 int_array_values = 5;</code>
       */
      public int getIntArrayValuesCount() {
        return intArrayValues_.size();
      }
      /**
       * <code>repeated sint32 int_array_values = 5;</code>
       */
      public int getIntArrayValues(int index) {
        return intArrayValues_.get(index);
      }
      /**
       * <code>repeated sint32 int_array_values = 5;</code>
       */
      public Builder setIntArrayValues(
          int index, int value) {
        ensureIntArrayValuesIsMutable();
        intArrayValues_.set(index, value);
        onChanged();
        return this;
      }
      /**
       * <code>repeated sint32 int_array_values = 5;</code>
       */
      public Builder addIntArrayValues(int value) {
        ensureIntArrayValuesIsMutable();
        intArrayValues_.add(value);
        onChanged();
        return this;
      }
      /**
       * <code>repeated sint32 int_array_values = 5;</code>
       */
      public Builder addAllIntArrayValues(
          java.lang.Iterable<? extends java.lang.Integer> values) {
        ensureIntArrayValuesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, intArrayValues_);
        onChanged();
        return this;
      }
      /**
       * <code>repeated sint32 int_array_values = 5;</code>
       */
      public Builder clearIntArrayValues() {
        intArrayValues_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
        return this;
      }

      private int type_ = 0;
      /**
       * <code>optional .MetaDataOperationArgument.ArgumentType type = 6;</code>
       */
      public int getTypeValue() {
        return type_;
      }
      /**
       * <code>optional .MetaDataOperationArgument.ArgumentType type = 6;</code>
       */
      public Builder setTypeValue(int value) {
        type_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional .MetaDataOperationArgument.ArgumentType type = 6;</code>
       */
      public org.apache.calcite.avatica.proto.Common.MetaDataOperationArgument.ArgumentType getType() {
        org.apache.calcite.avatica.proto.Common.MetaDataOperationArgument.ArgumentType result = org.apache.calcite.avatica.proto.Common.MetaDataOperationArgument.ArgumentType.valueOf(type_);
        return result == null ? org.apache.calcite.avatica.proto.Common.MetaDataOperationArgument.ArgumentType.UNRECOGNIZED : result;
      }
      /**
       * <code>optional .MetaDataOperationArgument.ArgumentType type = 6;</code>
       */
      public Builder setType(org.apache.calcite.avatica.proto.Common.MetaDataOperationArgument.ArgumentType value) {
        if (value == null) {
          throw new NullPointerException();
        }
        
        type_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       * <code>optional .MetaDataOperationArgument.ArgumentType type = 6;</code>
       */
      public Builder clearType() {
        
        type_ = 0;
        onChanged();
        return this;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return this;
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return this;
      }


      // @@protoc_insertion_point(builder_scope:MetaDataOperationArgument)
    }

    // @@protoc_insertion_point(class_scope:MetaDataOperationArgument)
    private static final org.apache.calcite.avatica.proto.Common.MetaDataOperationArgument DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.apache.calcite.avatica.proto.Common.MetaDataOperationArgument();
    }

    public static org.apache.calcite.avatica.proto.Common.MetaDataOperationArgument getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<MetaDataOperationArgument>
        PARSER = new com.google.protobuf.AbstractParser<MetaDataOperationArgument>() {
      public MetaDataOperationArgument parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        try {
          return new MetaDataOperationArgument(input, extensionRegistry);
        } catch (RuntimeException e) {
          if (e.getCause() instanceof
              com.google.protobuf.InvalidProtocolBufferException) {
            throw (com.google.protobuf.InvalidProtocolBufferException)
                e.getCause();
          }
          throw e;
        }
      }
    };

    public static com.google.protobuf.Parser<MetaDataOperationArgument> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<MetaDataOperationArgument> getParserForType() {
      return PARSER;
    }

    public org.apache.calcite.avatica.proto.Common.MetaDataOperationArgument getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface QueryStateOrBuilder extends
      // @@protoc_insertion_point(interface_extends:QueryState)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>optional .StateType type = 1;</code>
     */
    int getTypeValue();
    /**
     * <code>optional .StateType type = 1;</code>
     */
    org.apache.calcite.avatica.proto.Common.StateType getType();

    /**
     * <code>optional string sql = 2;</code>
     */
    java.lang.String getSql();
    /**
     * <code>optional string sql = 2;</code>
     */
    com.google.protobuf.ByteString
        getSqlBytes();

    /**
     * <code>optional .MetaDataOperation op = 3;</code>
     */
    int getOpValue();
    /**
     * <code>optional .MetaDataOperation op = 3;</code>
     */
    org.apache.calcite.avatica.proto.Common.MetaDataOperation getOp();

    /**
     * <code>repeated .MetaDataOperationArgument args = 4;</code>
     */
    java.util.List<org.apache.calcite.avatica.proto.Common.MetaDataOperationArgument> 
        getArgsList();
    /**
     * <code>repeated .MetaDataOperationArgument args = 4;</code>
     */
    org.apache.calcite.avatica.proto.Common.MetaDataOperationArgument getArgs(int index);
    /**
     * <code>repeated .MetaDataOperationArgument args = 4;</code>
     */
    int getArgsCount();
    /**
     * <code>repeated .MetaDataOperationArgument args = 4;</code>
     */
    java.util.List<? extends org.apache.calcite.avatica.proto.Common.MetaDataOperationArgumentOrBuilder> 
        getArgsOrBuilderList();
    /**
     * <code>repeated .MetaDataOperationArgument args = 4;</code>
     */
    org.apache.calcite.avatica.proto.Common.MetaDataOperationArgumentOrBuilder getArgsOrBuilder(
        int index);

    /**
     * <code>optional bool has_args = 5;</code>
     */
    boolean getHasArgs();

    /**
     * <code>optional bool has_sql = 6;</code>
     */
    boolean getHasSql();

    /**
     * <code>optional bool has_op = 7;</code>
     */
    boolean getHasOp();
  }
  /**
   * Protobuf type {@code QueryState}
   */
  public  static final class QueryState extends
      com.google.protobuf.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:QueryState)
      QueryStateOrBuilder {
    // Use QueryState.newBuilder() to construct.
    private QueryState(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
    }
    private QueryState() {
      type_ = 0;
      sql_ = "";
      op_ = 0;
      args_ = java.util.Collections.emptyList();
      hasArgs_ = false;
      hasSql_ = false;
      hasOp_ = false;
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return com.google.protobuf.UnknownFieldSet.getDefaultInstance();
    }
    private QueryState(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry) {
      this();
      int mutable_bitField0_ = 0;
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!input.skipField(tag)) {
                done = true;
              }
              break;
            }
            case 8: {
              int rawValue = input.readEnum();

              type_ = rawValue;
              break;
            }
            case 18: {
              String s = input.readStringRequireUtf8();

              sql_ = s;
              break;
            }
            case 24: {
              int rawValue = input.readEnum();

              op_ = rawValue;
              break;
            }
            case 34: {
              if (!((mutable_bitField0_ & 0x00000008) == 0x00000008)) {
                args_ = new java.util.ArrayList<org.apache.calcite.avatica.proto.Common.MetaDataOperationArgument>();
                mutable_bitField0_ |= 0x00000008;
              }
              args_.add(input.readMessage(org.apache.calcite.avatica.proto.Common.MetaDataOperationArgument.parser(), extensionRegistry));
              break;
            }
            case 40: {

              hasArgs_ = input.readBool();
              break;
            }
            case 48: {

              hasSql_ = input.readBool();
              break;
            }
            case 56: {

              hasOp_ = input.readBool();
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw new RuntimeException(e.setUnfinishedMessage(this));
      } catch (java.io.IOException e) {
        throw new RuntimeException(
            new com.google.protobuf.InvalidProtocolBufferException(
                e.getMessage()).setUnfinishedMessage(this));
      } finally {
        if (((mutable_bitField0_ & 0x00000008) == 0x00000008)) {
          args_ = java.util.Collections.unmodifiableList(args_);
        }
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.calcite.avatica.proto.Common.internal_static_QueryState_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.calcite.avatica.proto.Common.internal_static_QueryState_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.calcite.avatica.proto.Common.QueryState.class, org.apache.calcite.avatica.proto.Common.QueryState.Builder.class);
    }

    private int bitField0_;
    public static final int TYPE_FIELD_NUMBER = 1;
    private int type_;
    /**
     * <code>optional .StateType type = 1;</code>
     */
    public int getTypeValue() {
      return type_;
    }
    /**
     * <code>optional .StateType type = 1;</code>
     */
    public org.apache.calcite.avatica.proto.Common.StateType getType() {
      org.apache.calcite.avatica.proto.Common.StateType result = org.apache.calcite.avatica.proto.Common.StateType.valueOf(type_);
      return result == null ? org.apache.calcite.avatica.proto.Common.StateType.UNRECOGNIZED : result;
    }

    public static final int SQL_FIELD_NUMBER = 2;
    private volatile java.lang.Object sql_;
    /**
     * <code>optional string sql = 2;</code>
     */
    public java.lang.String getSql() {
      java.lang.Object ref = sql_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        sql_ = s;
        return s;
      }
    }
    /**
     * <code>optional string sql = 2;</code>
     */
    public com.google.protobuf.ByteString
        getSqlBytes() {
      java.lang.Object ref = sql_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        sql_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int OP_FIELD_NUMBER = 3;
    private int op_;
    /**
     * <code>optional .MetaDataOperation op = 3;</code>
     */
    public int getOpValue() {
      return op_;
    }
    /**
     * <code>optional .MetaDataOperation op = 3;</code>
     */
    public org.apache.calcite.avatica.proto.Common.MetaDataOperation getOp() {
      org.apache.calcite.avatica.proto.Common.MetaDataOperation result = org.apache.calcite.avatica.proto.Common.MetaDataOperation.valueOf(op_);
      return result == null ? org.apache.calcite.avatica.proto.Common.MetaDataOperation.UNRECOGNIZED : result;
    }

    public static final int ARGS_FIELD_NUMBER = 4;
    private java.util.List<org.apache.calcite.avatica.proto.Common.MetaDataOperationArgument> args_;
    /**
     * <code>repeated .MetaDataOperationArgument args = 4;</code>
     */
    public java.util.List<org.apache.calcite.avatica.proto.Common.MetaDataOperationArgument> getArgsList() {
      return args_;
    }
    /**
     * <code>repeated .MetaDataOperationArgument args = 4;</code>
     */
    public java.util.List<? extends org.apache.calcite.avatica.proto.Common.MetaDataOperationArgumentOrBuilder> 
        getArgsOrBuilderList() {
      return args_;
    }
    /**
     * <code>repeated .MetaDataOperationArgument args = 4;</code>
     */
    public int getArgsCount() {
      return args_.size();
    }
    /**
     * <code>repeated .MetaDataOperationArgument args = 4;</code>
     */
    public org.apache.calcite.avatica.proto.Common.MetaDataOperationArgument getArgs(int index) {
      return args_.get(index);
    }
    /**
     * <code>repeated .MetaDataOperationArgument args = 4;</code>
     */
    public org.apache.calcite.avatica.proto.Common.MetaDataOperationArgumentOrBuilder getArgsOrBuilder(
        int index) {
      return args_.get(index);
    }

    public static final int HAS_ARGS_FIELD_NUMBER = 5;
    private boolean hasArgs_;
    /**
     * <code>optional bool has_args = 5;</code>
     */
    public boolean getHasArgs() {
      return hasArgs_;
    }

    public static final int HAS_SQL_FIELD_NUMBER = 6;
    private boolean hasSql_;
    /**
     * <code>optional bool has_sql = 6;</code>
     */
    public boolean getHasSql() {
      return hasSql_;
    }

    public static final int HAS_OP_FIELD_NUMBER = 7;
    private boolean hasOp_;
    /**
     * <code>optional bool has_op = 7;</code>
     */
    public boolean getHasOp() {
      return hasOp_;
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (type_ != org.apache.calcite.avatica.proto.Common.StateType.SQL.getNumber()) {
        output.writeEnum(1, type_);
      }
      if (!getSqlBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessage.writeString(output, 2, sql_);
      }
      if (op_ != org.apache.calcite.avatica.proto.Common.MetaDataOperation.GET_ATTRIBUTES.getNumber()) {
        output.writeEnum(3, op_);
      }
      for (int i = 0; i < args_.size(); i++) {
        output.writeMessage(4, args_.get(i));
      }
      if (hasArgs_ != false) {
        output.writeBool(5, hasArgs_);
      }
      if (hasSql_ != false) {
        output.writeBool(6, hasSql_);
      }
      if (hasOp_ != false) {
        output.writeBool(7, hasOp_);
      }
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (type_ != org.apache.calcite.avatica.proto.Common.StateType.SQL.getNumber()) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(1, type_);
      }
      if (!getSqlBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessage.computeStringSize(2, sql_);
      }
      if (op_ != org.apache.calcite.avatica.proto.Common.MetaDataOperation.GET_ATTRIBUTES.getNumber()) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(3, op_);
      }
      for (int i = 0; i < args_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(4, args_.get(i));
      }
      if (hasArgs_ != false) {
        size += com.google.protobuf.CodedOutputStream
          .computeBoolSize(5, hasArgs_);
      }
      if (hasSql_ != false) {
        size += com.google.protobuf.CodedOutputStream
          .computeBoolSize(6, hasSql_);
      }
      if (hasOp_ != false) {
        size += com.google.protobuf.CodedOutputStream
          .computeBoolSize(7, hasOp_);
      }
      memoizedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    public static org.apache.calcite.avatica.proto.Common.QueryState parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.calcite.avatica.proto.Common.QueryState parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.calcite.avatica.proto.Common.QueryState parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.calcite.avatica.proto.Common.QueryState parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.calcite.avatica.proto.Common.QueryState parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.calcite.avatica.proto.Common.QueryState parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static org.apache.calcite.avatica.proto.Common.QueryState parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static org.apache.calcite.avatica.proto.Common.QueryState parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static org.apache.calcite.avatica.proto.Common.QueryState parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.calcite.avatica.proto.Common.QueryState parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.apache.calcite.avatica.proto.Common.QueryState prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code QueryState}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:QueryState)
        org.apache.calcite.avatica.proto.Common.QueryStateOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.calcite.avatica.proto.Common.internal_static_QueryState_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.calcite.avatica.proto.Common.internal_static_QueryState_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.calcite.avatica.proto.Common.QueryState.class, org.apache.calcite.avatica.proto.Common.QueryState.Builder.class);
      }

      // Construct using org.apache.calcite.avatica.proto.Common.QueryState.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
          getArgsFieldBuilder();
        }
      }
      public Builder clear() {
        super.clear();
        type_ = 0;

        sql_ = "";

        op_ = 0;

        if (argsBuilder_ == null) {
          args_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000008);
        } else {
          argsBuilder_.clear();
        }
        hasArgs_ = false;

        hasSql_ = false;

        hasOp_ = false;

        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.calcite.avatica.proto.Common.internal_static_QueryState_descriptor;
      }

      public org.apache.calcite.avatica.proto.Common.QueryState getDefaultInstanceForType() {
        return org.apache.calcite.avatica.proto.Common.QueryState.getDefaultInstance();
      }

      public org.apache.calcite.avatica.proto.Common.QueryState build() {
        org.apache.calcite.avatica.proto.Common.QueryState result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public org.apache.calcite.avatica.proto.Common.QueryState buildPartial() {
        org.apache.calcite.avatica.proto.Common.QueryState result = new org.apache.calcite.avatica.proto.Common.QueryState(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        result.type_ = type_;
        result.sql_ = sql_;
        result.op_ = op_;
        if (argsBuilder_ == null) {
          if (((bitField0_ & 0x00000008) == 0x00000008)) {
            args_ = java.util.Collections.unmodifiableList(args_);
            bitField0_ = (bitField0_ & ~0x00000008);
          }
          result.args_ = args_;
        } else {
          result.args_ = argsBuilder_.build();
        }
        result.hasArgs_ = hasArgs_;
        result.hasSql_ = hasSql_;
        result.hasOp_ = hasOp_;
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.apache.calcite.avatica.proto.Common.QueryState) {
          return mergeFrom((org.apache.calcite.avatica.proto.Common.QueryState)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.calcite.avatica.proto.Common.QueryState other) {
        if (other == org.apache.calcite.avatica.proto.Common.QueryState.getDefaultInstance()) return this;
        if (other.type_ != 0) {
          setTypeValue(other.getTypeValue());
        }
        if (!other.getSql().isEmpty()) {
          sql_ = other.sql_;
          onChanged();
        }
        if (other.op_ != 0) {
          setOpValue(other.getOpValue());
        }
        if (argsBuilder_ == null) {
          if (!other.args_.isEmpty()) {
            if (args_.isEmpty()) {
              args_ = other.args_;
              bitField0_ = (bitField0_ & ~0x00000008);
            } else {
              ensureArgsIsMutable();
              args_.addAll(other.args_);
            }
            onChanged();
          }
        } else {
          if (!other.args_.isEmpty()) {
            if (argsBuilder_.isEmpty()) {
              argsBuilder_.dispose();
              argsBuilder_ = null;
              args_ = other.args_;
              bitField0_ = (bitField0_ & ~0x00000008);
              argsBuilder_ = 
                com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders ?
                   getArgsFieldBuilder() : null;
            } else {
              argsBuilder_.addAllMessages(other.args_);
            }
          }
        }
        if (other.getHasArgs() != false) {
          setHasArgs(other.getHasArgs());
        }
        if (other.getHasSql() != false) {
          setHasSql(other.getHasSql());
        }
        if (other.getHasOp() != false) {
          setHasOp(other.getHasOp());
        }
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        org.apache.calcite.avatica.proto.Common.QueryState parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (org.apache.calcite.avatica.proto.Common.QueryState) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private int type_ = 0;
      /**
       * <code>optional .StateType type = 1;</code>
       */
      public int getTypeValue() {
        return type_;
      }
      /**
       * <code>optional .StateType type = 1;</code>
       */
      public Builder setTypeValue(int value) {
        type_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional .StateType type = 1;</code>
       */
      public org.apache.calcite.avatica.proto.Common.StateType getType() {
        org.apache.calcite.avatica.proto.Common.StateType result = org.apache.calcite.avatica.proto.Common.StateType.valueOf(type_);
        return result == null ? org.apache.calcite.avatica.proto.Common.StateType.UNRECOGNIZED : result;
      }
      /**
       * <code>optional .StateType type = 1;</code>
       */
      public Builder setType(org.apache.calcite.avatica.proto.Common.StateType value) {
        if (value == null) {
          throw new NullPointerException();
        }
        
        type_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       * <code>optional .StateType type = 1;</code>
       */
      public Builder clearType() {
        
        type_ = 0;
        onChanged();
        return this;
      }

      private java.lang.Object sql_ = "";
      /**
       * <code>optional string sql = 2;</code>
       */
      public java.lang.String getSql() {
        java.lang.Object ref = sql_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          sql_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>optional string sql = 2;</code>
       */
      public com.google.protobuf.ByteString
          getSqlBytes() {
        java.lang.Object ref = sql_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          sql_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>optional string sql = 2;</code>
       */
      public Builder setSql(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        sql_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional string sql = 2;</code>
       */
      public Builder clearSql() {
        
        sql_ = getDefaultInstance().getSql();
        onChanged();
        return this;
      }
      /**
       * <code>optional string sql = 2;</code>
       */
      public Builder setSqlBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        sql_ = value;
        onChanged();
        return this;
      }

      private int op_ = 0;
      /**
       * <code>optional .MetaDataOperation op = 3;</code>
       */
      public int getOpValue() {
        return op_;
      }
      /**
       * <code>optional .MetaDataOperation op = 3;</code>
       */
      public Builder setOpValue(int value) {
        op_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional .MetaDataOperation op = 3;</code>
       */
      public org.apache.calcite.avatica.proto.Common.MetaDataOperation getOp() {
        org.apache.calcite.avatica.proto.Common.MetaDataOperation result = org.apache.calcite.avatica.proto.Common.MetaDataOperation.valueOf(op_);
        return result == null ? org.apache.calcite.avatica.proto.Common.MetaDataOperation.UNRECOGNIZED : result;
      }
      /**
       * <code>optional .MetaDataOperation op = 3;</code>
       */
      public Builder setOp(org.apache.calcite.avatica.proto.Common.MetaDataOperation value) {
        if (value == null) {
          throw new NullPointerException();
        }
        
        op_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       * <code>optional .MetaDataOperation op = 3;</code>
       */
      public Builder clearOp() {
        
        op_ = 0;
        onChanged();
        return this;
      }

      private java.util.List<org.apache.calcite.avatica.proto.Common.MetaDataOperationArgument> args_ =
        java.util.Collections.emptyList();
      private void ensureArgsIsMutable() {
        if (!((bitField0_ & 0x00000008) == 0x00000008)) {
          args_ = new java.util.ArrayList<org.apache.calcite.avatica.proto.Common.MetaDataOperationArgument>(args_);
          bitField0_ |= 0x00000008;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilder<
          org.apache.calcite.avatica.proto.Common.MetaDataOperationArgument, org.apache.calcite.avatica.proto.Common.MetaDataOperationArgument.Builder, org.apache.calcite.avatica.proto.Common.MetaDataOperationArgumentOrBuilder> argsBuilder_;

      /**
       * <code>repeated .MetaDataOperationArgument args = 4;</code>
       */
      public java.util.List<org.apache.calcite.avatica.proto.Common.MetaDataOperationArgument> getArgsList() {
        if (argsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(args_);
        } else {
          return argsBuilder_.getMessageList();
        }
      }
      /**
       * <code>repeated .MetaDataOperationArgument args = 4;</code>
       */
      public int getArgsCount() {
        if (argsBuilder_ == null) {
          return args_.size();
        } else {
          return argsBuilder_.getCount();
        }
      }
      /**
       * <code>repeated .MetaDataOperationArgument args = 4;</code>
       */
      public org.apache.calcite.avatica.proto.Common.MetaDataOperationArgument getArgs(int index) {
        if (argsBuilder_ == null) {
          return args_.get(index);
        } else {
          return argsBuilder_.getMessage(index);
        }
      }
      /**
       * <code>repeated .MetaDataOperationArgument args = 4;</code>
       */
      public Builder setArgs(
          int index, org.apache.calcite.avatica.proto.Common.MetaDataOperationArgument value) {
        if (argsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureArgsIsMutable();
          args_.set(index, value);
          onChanged();
        } else {
          argsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .MetaDataOperationArgument args = 4;</code>
       */
      public Builder setArgs(
          int index, org.apache.calcite.avatica.proto.Common.MetaDataOperationArgument.Builder builderForValue) {
        if (argsBuilder_ == null) {
          ensureArgsIsMutable();
          args_.set(index, builderForValue.build());
          onChanged();
        } else {
          argsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .MetaDataOperationArgument args = 4;</code>
       */
      public Builder addArgs(org.apache.calcite.avatica.proto.Common.MetaDataOperationArgument value) {
        if (argsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureArgsIsMutable();
          args_.add(value);
          onChanged();
        } else {
          argsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <code>repeated .MetaDataOperationArgument args = 4;</code>
       */
      public Builder addArgs(
          int index, org.apache.calcite.avatica.proto.Common.MetaDataOperationArgument value) {
        if (argsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureArgsIsMutable();
          args_.add(index, value);
          onChanged();
        } else {
          argsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .MetaDataOperationArgument args = 4;</code>
       */
      public Builder addArgs(
          org.apache.calcite.avatica.proto.Common.MetaDataOperationArgument.Builder builderForValue) {
        if (argsBuilder_ == null) {
          ensureArgsIsMutable();
          args_.add(builderForValue.build());
          onChanged();
        } else {
          argsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .MetaDataOperationArgument args = 4;</code>
       */
      public Builder addArgs(
          int index, org.apache.calcite.avatica.proto.Common.MetaDataOperationArgument.Builder builderForValue) {
        if (argsBuilder_ == null) {
          ensureArgsIsMutable();
          args_.add(index, builderForValue.build());
          onChanged();
        } else {
          argsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .MetaDataOperationArgument args = 4;</code>
       */
      public Builder addAllArgs(
          java.lang.Iterable<? extends org.apache.calcite.avatica.proto.Common.MetaDataOperationArgument> values) {
        if (argsBuilder_ == null) {
          ensureArgsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, args_);
          onChanged();
        } else {
          argsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <code>repeated .MetaDataOperationArgument args = 4;</code>
       */
      public Builder clearArgs() {
        if (argsBuilder_ == null) {
          args_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000008);
          onChanged();
        } else {
          argsBuilder_.clear();
        }
        return this;
      }
      /**
       * <code>repeated .MetaDataOperationArgument args = 4;</code>
       */
      public Builder removeArgs(int index) {
        if (argsBuilder_ == null) {
          ensureArgsIsMutable();
          args_.remove(index);
          onChanged();
        } else {
          argsBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <code>repeated .MetaDataOperationArgument args = 4;</code>
       */
      public org.apache.calcite.avatica.proto.Common.MetaDataOperationArgument.Builder getArgsBuilder(
          int index) {
        return getArgsFieldBuilder().getBuilder(index);
      }
      /**
       * <code>repeated .MetaDataOperationArgument args = 4;</code>
       */
      public org.apache.calcite.avatica.proto.Common.MetaDataOperationArgumentOrBuilder getArgsOrBuilder(
          int index) {
        if (argsBuilder_ == null) {
          return args_.get(index);  } else {
          return argsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <code>repeated .MetaDataOperationArgument args = 4;</code>
       */
      public java.util.List<? extends org.apache.calcite.avatica.proto.Common.MetaDataOperationArgumentOrBuilder> 
           getArgsOrBuilderList() {
        if (argsBuilder_ != null) {
          return argsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(args_);
        }
      }
      /**
       * <code>repeated .MetaDataOperationArgument args = 4;</code>
       */
      public org.apache.calcite.avatica.proto.Common.MetaDataOperationArgument.Builder addArgsBuilder() {
        return getArgsFieldBuilder().addBuilder(
            org.apache.calcite.avatica.proto.Common.MetaDataOperationArgument.getDefaultInstance());
      }
      /**
       * <code>repeated .MetaDataOperationArgument args = 4;</code>
       */
      public org.apache.calcite.avatica.proto.Common.MetaDataOperationArgument.Builder addArgsBuilder(
          int index) {
        return getArgsFieldBuilder().addBuilder(
            index, org.apache.calcite.avatica.proto.Common.MetaDataOperationArgument.getDefaultInstance());
      }
      /**
       * <code>repeated .MetaDataOperationArgument args = 4;</code>
       */
      public java.util.List<org.apache.calcite.avatica.proto.Common.MetaDataOperationArgument.Builder> 
           getArgsBuilderList() {
        return getArgsFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilder<
          org.apache.calcite.avatica.proto.Common.MetaDataOperationArgument, org.apache.calcite.avatica.proto.Common.MetaDataOperationArgument.Builder, org.apache.calcite.avatica.proto.Common.MetaDataOperationArgumentOrBuilder> 
          getArgsFieldBuilder() {
        if (argsBuilder_ == null) {
          argsBuilder_ = new com.google.protobuf.RepeatedFieldBuilder<
              org.apache.calcite.avatica.proto.Common.MetaDataOperationArgument, org.apache.calcite.avatica.proto.Common.MetaDataOperationArgument.Builder, org.apache.calcite.avatica.proto.Common.MetaDataOperationArgumentOrBuilder>(
                  args_,
                  ((bitField0_ & 0x00000008) == 0x00000008),
                  getParentForChildren(),
                  isClean());
          args_ = null;
        }
        return argsBuilder_;
      }

      private boolean hasArgs_ ;
      /**
       * <code>optional bool has_args = 5;</code>
       */
      public boolean getHasArgs() {
        return hasArgs_;
      }
      /**
       * <code>optional bool has_args = 5;</code>
       */
      public Builder setHasArgs(boolean value) {
        
        hasArgs_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional bool has_args = 5;</code>
       */
      public Builder clearHasArgs() {
        
        hasArgs_ = false;
        onChanged();
        return this;
      }

      private boolean hasSql_ ;
      /**
       * <code>optional bool has_sql = 6;</code>
       */
      public boolean getHasSql() {
        return hasSql_;
      }
      /**
       * <code>optional bool has_sql = 6;</code>
       */
      public Builder setHasSql(boolean value) {
        
        hasSql_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional bool has_sql = 6;</code>
       */
      public Builder clearHasSql() {
        
        hasSql_ = false;
        onChanged();
        return this;
      }

      private boolean hasOp_ ;
      /**
       * <code>optional bool has_op = 7;</code>
       */
      public boolean getHasOp() {
        return hasOp_;
      }
      /**
       * <code>optional bool has_op = 7;</code>
       */
      public Builder setHasOp(boolean value) {
        
        hasOp_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional bool has_op = 7;</code>
       */
      public Builder clearHasOp() {
        
        hasOp_ = false;
        onChanged();
        return this;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return this;
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return this;
      }


      // @@protoc_insertion_point(builder_scope:QueryState)
    }

    // @@protoc_insertion_point(class_scope:QueryState)
    private static final org.apache.calcite.avatica.proto.Common.QueryState DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.apache.calcite.avatica.proto.Common.QueryState();
    }

    public static org.apache.calcite.avatica.proto.Common.QueryState getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<QueryState>
        PARSER = new com.google.protobuf.AbstractParser<QueryState>() {
      public QueryState parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        try {
          return new QueryState(input, extensionRegistry);
        } catch (RuntimeException e) {
          if (e.getCause() instanceof
              com.google.protobuf.InvalidProtocolBufferException) {
            throw (com.google.protobuf.InvalidProtocolBufferException)
                e.getCause();
          }
          throw e;
        }
      }
    };

    public static com.google.protobuf.Parser<QueryState> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<QueryState> getParserForType() {
      return PARSER;
    }

    public org.apache.calcite.avatica.proto.Common.QueryState getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  private static com.google.protobuf.Descriptors.Descriptor
    internal_static_ConnectionProperties_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_ConnectionProperties_fieldAccessorTable;
  private static com.google.protobuf.Descriptors.Descriptor
    internal_static_StatementHandle_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_StatementHandle_fieldAccessorTable;
  private static com.google.protobuf.Descriptors.Descriptor
    internal_static_Signature_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_Signature_fieldAccessorTable;
  private static com.google.protobuf.Descriptors.Descriptor
    internal_static_ColumnMetaData_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_ColumnMetaData_fieldAccessorTable;
  private static com.google.protobuf.Descriptors.Descriptor
    internal_static_AvaticaType_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_AvaticaType_fieldAccessorTable;
  private static com.google.protobuf.Descriptors.Descriptor
    internal_static_AvaticaParameter_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_AvaticaParameter_fieldAccessorTable;
  private static com.google.protobuf.Descriptors.Descriptor
    internal_static_CursorFactory_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_CursorFactory_fieldAccessorTable;
  private static com.google.protobuf.Descriptors.Descriptor
    internal_static_Frame_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_Frame_fieldAccessorTable;
  private static com.google.protobuf.Descriptors.Descriptor
    internal_static_Row_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_Row_fieldAccessorTable;
  private static com.google.protobuf.Descriptors.Descriptor
    internal_static_DatabaseProperty_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_DatabaseProperty_fieldAccessorTable;
  private static com.google.protobuf.Descriptors.Descriptor
    internal_static_WireMessage_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_WireMessage_fieldAccessorTable;
  private static com.google.protobuf.Descriptors.Descriptor
    internal_static_ColumnValue_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_ColumnValue_fieldAccessorTable;
  private static com.google.protobuf.Descriptors.Descriptor
    internal_static_TypedValue_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_TypedValue_fieldAccessorTable;
  private static com.google.protobuf.Descriptors.Descriptor
    internal_static_MetaDataOperationArgument_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_MetaDataOperationArgument_fieldAccessorTable;
  private static com.google.protobuf.Descriptors.Descriptor
    internal_static_QueryState_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_QueryState_fieldAccessorTable;

  public static com.google.protobuf.Descriptors.FileDescriptor
      getDescriptor() {
    return descriptor;
  }
  private static com.google.protobuf.Descriptors.FileDescriptor
      descriptor;
  static {
    java.lang.String[] descriptorData = {
      "\n\014common.proto\"\300\001\n\024ConnectionProperties\022" +
      "\020\n\010is_dirty\030\001 \001(\010\022\023\n\013auto_commit\030\002 \001(\010\022\027" +
      "\n\017has_auto_commit\030\007 \001(\010\022\021\n\tread_only\030\003 \001" +
      "(\010\022\025\n\rhas_read_only\030\010 \001(\010\022\035\n\025transaction" +
      "_isolation\030\004 \001(\r\022\017\n\007catalog\030\005 \001(\t\022\016\n\006sch" +
      "ema\030\006 \001(\t\"S\n\017StatementHandle\022\025\n\rconnecti" +
      "on_id\030\001 \001(\t\022\n\n\002id\030\002 \001(\r\022\035\n\tsignature\030\003 \001" +
      "(\0132\n.Signature\"\260\001\n\tSignature\022 \n\007columns\030" +
      "\001 \003(\0132\017.ColumnMetaData\022\013\n\003sql\030\002 \001(\t\022%\n\np" +
      "arameters\030\003 \003(\0132\021.AvaticaParameter\022&\n\016cu",
      "rsor_factory\030\004 \001(\0132\016.CursorFactory\022%\n\rst" +
      "atementType\030\005 \001(\0162\016.StatementType\"\255\003\n\016Co" +
      "lumnMetaData\022\017\n\007ordinal\030\001 \001(\r\022\026\n\016auto_in" +
      "crement\030\002 \001(\010\022\026\n\016case_sensitive\030\003 \001(\010\022\022\n" +
      "\nsearchable\030\004 \001(\010\022\020\n\010currency\030\005 \001(\010\022\020\n\010n" +
      "ullable\030\006 \001(\r\022\016\n\006signed\030\007 \001(\010\022\024\n\014display" +
      "_size\030\010 \001(\r\022\r\n\005label\030\t \001(\t\022\023\n\013column_nam" +
      "e\030\n \001(\t\022\023\n\013schema_name\030\013 \001(\t\022\021\n\tprecisio" +
      "n\030\014 \001(\r\022\r\n\005scale\030\r \001(\r\022\022\n\ntable_name\030\016 \001" +
      "(\t\022\024\n\014catalog_name\030\017 \001(\t\022\021\n\tread_only\030\020 ",
      "\001(\010\022\020\n\010writable\030\021 \001(\010\022\033\n\023definitely_writ" +
      "able\030\022 \001(\010\022\031\n\021column_class_name\030\023 \001(\t\022\032\n" +
      "\004type\030\024 \001(\0132\014.AvaticaType\"}\n\013AvaticaType" +
      "\022\n\n\002id\030\001 \001(\r\022\014\n\004name\030\002 \001(\t\022\021\n\003rep\030\003 \001(\0162" +
      "\004.Rep\022 \n\007columns\030\004 \003(\0132\017.ColumnMetaData\022" +
      "\037\n\tcomponent\030\005 \001(\0132\014.AvaticaType\"\221\001\n\020Ava" +
      "ticaParameter\022\016\n\006signed\030\001 \001(\010\022\021\n\tprecisi" +
      "on\030\002 \001(\r\022\r\n\005scale\030\003 \001(\r\022\026\n\016parameter_typ" +
      "e\030\004 \001(\r\022\021\n\ttype_name\030\005 \001(\t\022\022\n\nclass_name" +
      "\030\006 \001(\t\022\014\n\004name\030\007 \001(\t\"\263\001\n\rCursorFactory\022#",
      "\n\005style\030\001 \001(\0162\024.CursorFactory.Style\022\022\n\nc" +
      "lass_name\030\002 \001(\t\022\023\n\013field_names\030\003 \003(\t\"T\n\005" +
      "Style\022\n\n\006OBJECT\020\000\022\n\n\006RECORD\020\001\022\025\n\021RECORD_" +
      "PROJECTION\020\002\022\t\n\005ARRAY\020\003\022\010\n\004LIST\020\004\022\007\n\003MAP" +
      "\020\005\"9\n\005Frame\022\016\n\006offset\030\001 \001(\004\022\014\n\004done\030\002 \001(" +
      "\010\022\022\n\004rows\030\003 \003(\0132\004.Row\"\"\n\003Row\022\033\n\005value\030\001 " +
      "\003(\0132\014.ColumnValue\"3\n\020DatabaseProperty\022\014\n" +
      "\004name\030\001 \001(\t\022\021\n\tfunctions\030\002 \003(\t\"4\n\013WireMe" +
      "ssage\022\014\n\004name\030\001 \001(\t\022\027\n\017wrapped_message\030\002" +
      " \001(\014\")\n\013ColumnValue\022\032\n\005value\030\001 \003(\0132\013.Typ",
      "edValue\"\232\001\n\nTypedValue\022\022\n\004type\030\001 \001(\0162\004.R" +
      "ep\022\022\n\nbool_value\030\002 \001(\010\022\024\n\014string_value\030\003" +
      " \001(\t\022\024\n\014number_value\030\004 \001(\022\022\024\n\014bytes_valu" +
      "es\030\005 \001(\014\022\024\n\014double_value\030\006 \001(\001\022\014\n\004null\030\007" +
      " \001(\010\"\246\002\n\031MetaDataOperationArgument\022\024\n\014st" +
      "ring_value\030\001 \001(\t\022\022\n\nbool_value\030\002 \001(\010\022\021\n\t" +
      "int_value\030\003 \001(\021\022\033\n\023string_array_values\030\004" +
      " \003(\t\022\030\n\020int_array_values\030\005 \003(\021\0225\n\004type\030\006" +
      " \001(\0162\'.MetaDataOperationArgument.Argumen" +
      "tType\"^\n\014ArgumentType\022\n\n\006STRING\020\000\022\010\n\004BOO",
      "L\020\001\022\007\n\003INT\020\002\022\023\n\017REPEATED_STRING\020\003\022\020\n\014REP" +
      "EATED_INT\020\004\022\010\n\004NULL\020\005\"\260\001\n\nQueryState\022\030\n\004" +
      "type\030\001 \001(\0162\n.StateType\022\013\n\003sql\030\002 \001(\t\022\036\n\002o" +
      "p\030\003 \001(\0162\022.MetaDataOperation\022(\n\004args\030\004 \003(" +
      "\0132\032.MetaDataOperationArgument\022\020\n\010has_arg" +
      "s\030\005 \001(\010\022\017\n\007has_sql\030\006 \001(\010\022\016\n\006has_op\030\007 \001(\010" +
      "*\237\001\n\rStatementType\022\n\n\006SELECT\020\000\022\n\n\006INSERT" +
      "\020\001\022\n\n\006UPDATE\020\002\022\n\n\006DELETE\020\003\022\n\n\006UPSERT\020\004\022\t" +
      "\n\005MERGE\020\005\022\r\n\tOTHER_DML\020\006\022\n\n\006CREATE\020\007\022\010\n\004" +
      "DROP\020\010\022\t\n\005ALTER\020\t\022\r\n\tOTHER_DDL\020\n\022\010\n\004CALL",
      "\020\013*\342\003\n\003Rep\022\025\n\021PRIMITIVE_BOOLEAN\020\000\022\022\n\016PRI" +
      "MITIVE_BYTE\020\001\022\022\n\016PRIMITIVE_CHAR\020\002\022\023\n\017PRI" +
      "MITIVE_SHORT\020\003\022\021\n\rPRIMITIVE_INT\020\004\022\022\n\016PRI" +
      "MITIVE_LONG\020\005\022\023\n\017PRIMITIVE_FLOAT\020\006\022\024\n\020PR" +
      "IMITIVE_DOUBLE\020\007\022\013\n\007BOOLEAN\020\010\022\010\n\004BYTE\020\t\022" +
      "\r\n\tCHARACTER\020\n\022\t\n\005SHORT\020\013\022\013\n\007INTEGER\020\014\022\010" +
      "\n\004LONG\020\r\022\t\n\005FLOAT\020\016\022\n\n\006DOUBLE\020\017\022\017\n\013BIG_I" +
      "NTEGER\020\031\022\017\n\013BIG_DECIMAL\020\032\022\021\n\rJAVA_SQL_TI" +
      "ME\020\020\022\026\n\022JAVA_SQL_TIMESTAMP\020\021\022\021\n\rJAVA_SQL" +
      "_DATE\020\022\022\022\n\016JAVA_UTIL_DATE\020\023\022\017\n\013BYTE_STRI",
      "NG\020\024\022\n\n\006STRING\020\025\022\n\n\006NUMBER\020\026\022\n\n\006OBJECT\020\027" +
      "\022\010\n\004NULL\020\030\022\t\n\005ARRAY\020\033\022\n\n\006STRUCT\020\034\022\014\n\010MUL" +
      "TISET\020\035*^\n\010Severity\022\024\n\020UNKNOWN_SEVERITY\020" +
      "\000\022\022\n\016FATAL_SEVERITY\020\001\022\022\n\016ERROR_SEVERITY\020" +
      "\002\022\024\n\020WARNING_SEVERITY\020\003*\327\004\n\021MetaDataOper" +
      "ation\022\022\n\016GET_ATTRIBUTES\020\000\022\033\n\027GET_BEST_RO" +
      "W_IDENTIFIER\020\001\022\020\n\014GET_CATALOGS\020\002\022\036\n\032GET_" +
      "CLIENT_INFO_PROPERTIES\020\003\022\031\n\025GET_COLUMN_P" +
      "RIVILEGES\020\004\022\017\n\013GET_COLUMNS\020\005\022\027\n\023GET_CROS" +
      "S_REFERENCE\020\006\022\025\n\021GET_EXPORTED_KEYS\020\007\022\030\n\024",
      "GET_FUNCTION_COLUMNS\020\010\022\021\n\rGET_FUNCTIONS\020" +
      "\t\022\025\n\021GET_IMPORTED_KEYS\020\n\022\022\n\016GET_INDEX_IN" +
      "FO\020\013\022\024\n\020GET_PRIMARY_KEYS\020\014\022\031\n\025GET_PROCED" +
      "URE_COLUMNS\020\r\022\022\n\016GET_PROCEDURES\020\016\022\026\n\022GET" +
      "_PSEUDO_COLUMNS\020\017\022\017\n\013GET_SCHEMAS\020\020\022\031\n\025GE" +
      "T_SCHEMAS_WITH_ARGS\020\021\022\024\n\020GET_SUPER_TABLE" +
      "S\020\022\022\023\n\017GET_SUPER_TYPES\020\023\022\030\n\024GET_TABLE_PR" +
      "IVILEGES\020\024\022\016\n\nGET_TABLES\020\025\022\023\n\017GET_TABLE_" +
      "TYPES\020\026\022\021\n\rGET_TYPE_INFO\020\027\022\014\n\010GET_UDTS\020\030" +
      "\022\027\n\023GET_VERSION_COLUMNS\020\031*\"\n\tStateType\022\007",
      "\n\003SQL\020\000\022\014\n\010METADATA\020\001B\"\n org.apache.calc" +
      "ite.avatica.protob\006proto3"
    };
    com.google.protobuf.Descriptors.FileDescriptor.InternalDescriptorAssigner assigner =
        new com.google.protobuf.Descriptors.FileDescriptor.    InternalDescriptorAssigner() {
          public com.google.protobuf.ExtensionRegistry assignDescriptors(
              com.google.protobuf.Descriptors.FileDescriptor root) {
            descriptor = root;
            return null;
          }
        };
    com.google.protobuf.Descriptors.FileDescriptor
      .internalBuildGeneratedFileFrom(descriptorData,
        new com.google.protobuf.Descriptors.FileDescriptor[] {
        }, assigner);
    internal_static_ConnectionProperties_descriptor =
      getDescriptor().getMessageTypes().get(0);
    internal_static_ConnectionProperties_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_ConnectionProperties_descriptor,
        new java.lang.String[] { "IsDirty", "AutoCommit", "HasAutoCommit", "ReadOnly", "HasReadOnly", "TransactionIsolation", "Catalog", "Schema", });
    internal_static_StatementHandle_descriptor =
      getDescriptor().getMessageTypes().get(1);
    internal_static_StatementHandle_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_StatementHandle_descriptor,
        new java.lang.String[] { "ConnectionId", "Id", "Signature", });
    internal_static_Signature_descriptor =
      getDescriptor().getMessageTypes().get(2);
    internal_static_Signature_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_Signature_descriptor,
        new java.lang.String[] { "Columns", "Sql", "Parameters", "CursorFactory", "StatementType", });
    internal_static_ColumnMetaData_descriptor =
      getDescriptor().getMessageTypes().get(3);
    internal_static_ColumnMetaData_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_ColumnMetaData_descriptor,
        new java.lang.String[] { "Ordinal", "AutoIncrement", "CaseSensitive", "Searchable", "Currency", "Nullable", "Signed", "DisplaySize", "Label", "ColumnName", "SchemaName", "Precision", "Scale", "TableName", "CatalogName", "ReadOnly", "Writable", "DefinitelyWritable", "ColumnClassName", "Type", });
    internal_static_AvaticaType_descriptor =
      getDescriptor().getMessageTypes().get(4);
    internal_static_AvaticaType_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_AvaticaType_descriptor,
        new java.lang.String[] { "Id", "Name", "Rep", "Columns", "Component", });
    internal_static_AvaticaParameter_descriptor =
      getDescriptor().getMessageTypes().get(5);
    internal_static_AvaticaParameter_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_AvaticaParameter_descriptor,
        new java.lang.String[] { "Signed", "Precision", "Scale", "ParameterType", "TypeName", "ClassName", "Name", });
    internal_static_CursorFactory_descriptor =
      getDescriptor().getMessageTypes().get(6);
    internal_static_CursorFactory_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_CursorFactory_descriptor,
        new java.lang.String[] { "Style", "ClassName", "FieldNames", });
    internal_static_Frame_descriptor =
      getDescriptor().getMessageTypes().get(7);
    internal_static_Frame_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_Frame_descriptor,
        new java.lang.String[] { "Offset", "Done", "Rows", });
    internal_static_Row_descriptor =
      getDescriptor().getMessageTypes().get(8);
    internal_static_Row_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_Row_descriptor,
        new java.lang.String[] { "Value", });
    internal_static_DatabaseProperty_descriptor =
      getDescriptor().getMessageTypes().get(9);
    internal_static_DatabaseProperty_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_DatabaseProperty_descriptor,
        new java.lang.String[] { "Name", "Functions", });
    internal_static_WireMessage_descriptor =
      getDescriptor().getMessageTypes().get(10);
    internal_static_WireMessage_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_WireMessage_descriptor,
        new java.lang.String[] { "Name", "WrappedMessage", });
    internal_static_ColumnValue_descriptor =
      getDescriptor().getMessageTypes().get(11);
    internal_static_ColumnValue_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_ColumnValue_descriptor,
        new java.lang.String[] { "Value", });
    internal_static_TypedValue_descriptor =
      getDescriptor().getMessageTypes().get(12);
    internal_static_TypedValue_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_TypedValue_descriptor,
        new java.lang.String[] { "Type", "BoolValue", "StringValue", "NumberValue", "BytesValues", "DoubleValue", "Null", });
    internal_static_MetaDataOperationArgument_descriptor =
      getDescriptor().getMessageTypes().get(13);
    internal_static_MetaDataOperationArgument_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_MetaDataOperationArgument_descriptor,
        new java.lang.String[] { "StringValue", "BoolValue", "IntValue", "StringArrayValues", "IntArrayValues", "Type", });
    internal_static_QueryState_descriptor =
      getDescriptor().getMessageTypes().get(14);
    internal_static_QueryState_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_QueryState_descriptor,
        new java.lang.String[] { "Type", "Sql", "Op", "Args", "HasArgs", "HasSql", "HasOp", });
  }

  // @@protoc_insertion_point(outer_class_scope)
}
