/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to you under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: responses.proto

package org.apache.calcite.avatica.proto;

@SuppressWarnings({"unused", "rawtypes"}) public final class Responses {
  private Responses() {}
  public static void registerAllExtensions(
      com.google.protobuf.ExtensionRegistry registry) {
  }
  public interface ResultSetResponseOrBuilder extends
      // @@protoc_insertion_point(interface_extends:ResultSetResponse)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>optional string connection_id = 1;</code>
     */
    java.lang.String getConnectionId();
    /**
     * <code>optional string connection_id = 1;</code>
     */
    com.google.protobuf.ByteString
        getConnectionIdBytes();

    /**
     * <code>optional uint32 statement_id = 2;</code>
     */
    int getStatementId();

    /**
     * <code>optional bool own_statement = 3;</code>
     */
    boolean getOwnStatement();

    /**
     * <code>optional .Signature signature = 4;</code>
     */
    boolean hasSignature();
    /**
     * <code>optional .Signature signature = 4;</code>
     */
    org.apache.calcite.avatica.proto.Common.Signature getSignature();
    /**
     * <code>optional .Signature signature = 4;</code>
     */
    org.apache.calcite.avatica.proto.Common.SignatureOrBuilder getSignatureOrBuilder();

    /**
     * <code>optional .Frame first_frame = 5;</code>
     */
    boolean hasFirstFrame();
    /**
     * <code>optional .Frame first_frame = 5;</code>
     */
    org.apache.calcite.avatica.proto.Common.Frame getFirstFrame();
    /**
     * <code>optional .Frame first_frame = 5;</code>
     */
    org.apache.calcite.avatica.proto.Common.FrameOrBuilder getFirstFrameOrBuilder();

    /**
     * <code>optional uint64 update_count = 6;</code>
     *
     * <pre>
     * -1 for normal result sets, else this response contains a dummy result set
     * </pre>
     */
    long getUpdateCount();
  }
  /**
   * Protobuf type {@code ResultSetResponse}
   *
   * <pre>
   * Response that contains a result set.
   * </pre>
   */
  public  static final class ResultSetResponse extends
      com.google.protobuf.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:ResultSetResponse)
      ResultSetResponseOrBuilder {
    // Use ResultSetResponse.newBuilder() to construct.
    private ResultSetResponse(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
    }
    private ResultSetResponse() {
      connectionId_ = "";
      statementId_ = 0;
      ownStatement_ = false;
      updateCount_ = 0L;
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return com.google.protobuf.UnknownFieldSet.getDefaultInstance();
    }
    private ResultSetResponse(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry) {
      this();
      int mutable_bitField0_ = 0;
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!input.skipField(tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              String s = input.readStringRequireUtf8();

              connectionId_ = s;
              break;
            }
            case 16: {

              statementId_ = input.readUInt32();
              break;
            }
            case 24: {

              ownStatement_ = input.readBool();
              break;
            }
            case 34: {
              org.apache.calcite.avatica.proto.Common.Signature.Builder subBuilder = null;
              if (signature_ != null) {
                subBuilder = signature_.toBuilder();
              }
              signature_ = input.readMessage(org.apache.calcite.avatica.proto.Common.Signature.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(signature_);
                signature_ = subBuilder.buildPartial();
              }

              break;
            }
            case 42: {
              org.apache.calcite.avatica.proto.Common.Frame.Builder subBuilder = null;
              if (firstFrame_ != null) {
                subBuilder = firstFrame_.toBuilder();
              }
              firstFrame_ = input.readMessage(org.apache.calcite.avatica.proto.Common.Frame.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(firstFrame_);
                firstFrame_ = subBuilder.buildPartial();
              }

              break;
            }
            case 48: {

              updateCount_ = input.readUInt64();
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw new RuntimeException(e.setUnfinishedMessage(this));
      } catch (java.io.IOException e) {
        throw new RuntimeException(
            new com.google.protobuf.InvalidProtocolBufferException(
                e.getMessage()).setUnfinishedMessage(this));
      } finally {
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.calcite.avatica.proto.Responses.internal_static_ResultSetResponse_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.calcite.avatica.proto.Responses.internal_static_ResultSetResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.calcite.avatica.proto.Responses.ResultSetResponse.class, org.apache.calcite.avatica.proto.Responses.ResultSetResponse.Builder.class);
    }

    public static final int CONNECTION_ID_FIELD_NUMBER = 1;
    private volatile java.lang.Object connectionId_;
    /**
     * <code>optional string connection_id = 1;</code>
     */
    public java.lang.String getConnectionId() {
      java.lang.Object ref = connectionId_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        connectionId_ = s;
        return s;
      }
    }
    /**
     * <code>optional string connection_id = 1;</code>
     */
    public com.google.protobuf.ByteString
        getConnectionIdBytes() {
      java.lang.Object ref = connectionId_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        connectionId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int STATEMENT_ID_FIELD_NUMBER = 2;
    private int statementId_;
    /**
     * <code>optional uint32 statement_id = 2;</code>
     */
    public int getStatementId() {
      return statementId_;
    }

    public static final int OWN_STATEMENT_FIELD_NUMBER = 3;
    private boolean ownStatement_;
    /**
     * <code>optional bool own_statement = 3;</code>
     */
    public boolean getOwnStatement() {
      return ownStatement_;
    }

    public static final int SIGNATURE_FIELD_NUMBER = 4;
    private org.apache.calcite.avatica.proto.Common.Signature signature_;
    /**
     * <code>optional .Signature signature = 4;</code>
     */
    public boolean hasSignature() {
      return signature_ != null;
    }
    /**
     * <code>optional .Signature signature = 4;</code>
     */
    public org.apache.calcite.avatica.proto.Common.Signature getSignature() {
      return signature_ == null ? org.apache.calcite.avatica.proto.Common.Signature.getDefaultInstance() : signature_;
    }
    /**
     * <code>optional .Signature signature = 4;</code>
     */
    public org.apache.calcite.avatica.proto.Common.SignatureOrBuilder getSignatureOrBuilder() {
      return getSignature();
    }

    public static final int FIRST_FRAME_FIELD_NUMBER = 5;
    private org.apache.calcite.avatica.proto.Common.Frame firstFrame_;
    /**
     * <code>optional .Frame first_frame = 5;</code>
     */
    public boolean hasFirstFrame() {
      return firstFrame_ != null;
    }
    /**
     * <code>optional .Frame first_frame = 5;</code>
     */
    public org.apache.calcite.avatica.proto.Common.Frame getFirstFrame() {
      return firstFrame_ == null ? org.apache.calcite.avatica.proto.Common.Frame.getDefaultInstance() : firstFrame_;
    }
    /**
     * <code>optional .Frame first_frame = 5;</code>
     */
    public org.apache.calcite.avatica.proto.Common.FrameOrBuilder getFirstFrameOrBuilder() {
      return getFirstFrame();
    }

    public static final int UPDATE_COUNT_FIELD_NUMBER = 6;
    private long updateCount_;
    /**
     * <code>optional uint64 update_count = 6;</code>
     *
     * <pre>
     * -1 for normal result sets, else this response contains a dummy result set
     * </pre>
     */
    public long getUpdateCount() {
      return updateCount_;
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (!getConnectionIdBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessage.writeString(output, 1, connectionId_);
      }
      if (statementId_ != 0) {
        output.writeUInt32(2, statementId_);
      }
      if (ownStatement_ != false) {
        output.writeBool(3, ownStatement_);
      }
      if (signature_ != null) {
        output.writeMessage(4, getSignature());
      }
      if (firstFrame_ != null) {
        output.writeMessage(5, getFirstFrame());
      }
      if (updateCount_ != 0L) {
        output.writeUInt64(6, updateCount_);
      }
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!getConnectionIdBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessage.computeStringSize(1, connectionId_);
      }
      if (statementId_ != 0) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt32Size(2, statementId_);
      }
      if (ownStatement_ != false) {
        size += com.google.protobuf.CodedOutputStream
          .computeBoolSize(3, ownStatement_);
      }
      if (signature_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(4, getSignature());
      }
      if (firstFrame_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(5, getFirstFrame());
      }
      if (updateCount_ != 0L) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt64Size(6, updateCount_);
      }
      memoizedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    public static org.apache.calcite.avatica.proto.Responses.ResultSetResponse parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.calcite.avatica.proto.Responses.ResultSetResponse parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.calcite.avatica.proto.Responses.ResultSetResponse parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.calcite.avatica.proto.Responses.ResultSetResponse parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.calcite.avatica.proto.Responses.ResultSetResponse parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.calcite.avatica.proto.Responses.ResultSetResponse parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static org.apache.calcite.avatica.proto.Responses.ResultSetResponse parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static org.apache.calcite.avatica.proto.Responses.ResultSetResponse parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static org.apache.calcite.avatica.proto.Responses.ResultSetResponse parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.calcite.avatica.proto.Responses.ResultSetResponse parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.apache.calcite.avatica.proto.Responses.ResultSetResponse prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code ResultSetResponse}
     *
     * <pre>
     * Response that contains a result set.
     * </pre>
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:ResultSetResponse)
        org.apache.calcite.avatica.proto.Responses.ResultSetResponseOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.calcite.avatica.proto.Responses.internal_static_ResultSetResponse_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.calcite.avatica.proto.Responses.internal_static_ResultSetResponse_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.calcite.avatica.proto.Responses.ResultSetResponse.class, org.apache.calcite.avatica.proto.Responses.ResultSetResponse.Builder.class);
      }

      // Construct using org.apache.calcite.avatica.proto.Responses.ResultSetResponse.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
        }
      }
      public Builder clear() {
        super.clear();
        connectionId_ = "";

        statementId_ = 0;

        ownStatement_ = false;

        if (signatureBuilder_ == null) {
          signature_ = null;
        } else {
          signature_ = null;
          signatureBuilder_ = null;
        }
        if (firstFrameBuilder_ == null) {
          firstFrame_ = null;
        } else {
          firstFrame_ = null;
          firstFrameBuilder_ = null;
        }
        updateCount_ = 0L;

        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.calcite.avatica.proto.Responses.internal_static_ResultSetResponse_descriptor;
      }

      public org.apache.calcite.avatica.proto.Responses.ResultSetResponse getDefaultInstanceForType() {
        return org.apache.calcite.avatica.proto.Responses.ResultSetResponse.getDefaultInstance();
      }

      public org.apache.calcite.avatica.proto.Responses.ResultSetResponse build() {
        org.apache.calcite.avatica.proto.Responses.ResultSetResponse result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public org.apache.calcite.avatica.proto.Responses.ResultSetResponse buildPartial() {
        org.apache.calcite.avatica.proto.Responses.ResultSetResponse result = new org.apache.calcite.avatica.proto.Responses.ResultSetResponse(this);
        result.connectionId_ = connectionId_;
        result.statementId_ = statementId_;
        result.ownStatement_ = ownStatement_;
        if (signatureBuilder_ == null) {
          result.signature_ = signature_;
        } else {
          result.signature_ = signatureBuilder_.build();
        }
        if (firstFrameBuilder_ == null) {
          result.firstFrame_ = firstFrame_;
        } else {
          result.firstFrame_ = firstFrameBuilder_.build();
        }
        result.updateCount_ = updateCount_;
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.apache.calcite.avatica.proto.Responses.ResultSetResponse) {
          return mergeFrom((org.apache.calcite.avatica.proto.Responses.ResultSetResponse)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.calcite.avatica.proto.Responses.ResultSetResponse other) {
        if (other == org.apache.calcite.avatica.proto.Responses.ResultSetResponse.getDefaultInstance()) return this;
        if (!other.getConnectionId().isEmpty()) {
          connectionId_ = other.connectionId_;
          onChanged();
        }
        if (other.getStatementId() != 0) {
          setStatementId(other.getStatementId());
        }
        if (other.getOwnStatement() != false) {
          setOwnStatement(other.getOwnStatement());
        }
        if (other.hasSignature()) {
          mergeSignature(other.getSignature());
        }
        if (other.hasFirstFrame()) {
          mergeFirstFrame(other.getFirstFrame());
        }
        if (other.getUpdateCount() != 0L) {
          setUpdateCount(other.getUpdateCount());
        }
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        org.apache.calcite.avatica.proto.Responses.ResultSetResponse parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (org.apache.calcite.avatica.proto.Responses.ResultSetResponse) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private java.lang.Object connectionId_ = "";
      /**
       * <code>optional string connection_id = 1;</code>
       */
      public java.lang.String getConnectionId() {
        java.lang.Object ref = connectionId_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          connectionId_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>optional string connection_id = 1;</code>
       */
      public com.google.protobuf.ByteString
          getConnectionIdBytes() {
        java.lang.Object ref = connectionId_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          connectionId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>optional string connection_id = 1;</code>
       */
      public Builder setConnectionId(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        connectionId_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional string connection_id = 1;</code>
       */
      public Builder clearConnectionId() {
        
        connectionId_ = getDefaultInstance().getConnectionId();
        onChanged();
        return this;
      }
      /**
       * <code>optional string connection_id = 1;</code>
       */
      public Builder setConnectionIdBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        connectionId_ = value;
        onChanged();
        return this;
      }

      private int statementId_ ;
      /**
       * <code>optional uint32 statement_id = 2;</code>
       */
      public int getStatementId() {
        return statementId_;
      }
      /**
       * <code>optional uint32 statement_id = 2;</code>
       */
      public Builder setStatementId(int value) {
        
        statementId_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional uint32 statement_id = 2;</code>
       */
      public Builder clearStatementId() {
        
        statementId_ = 0;
        onChanged();
        return this;
      }

      private boolean ownStatement_ ;
      /**
       * <code>optional bool own_statement = 3;</code>
       */
      public boolean getOwnStatement() {
        return ownStatement_;
      }
      /**
       * <code>optional bool own_statement = 3;</code>
       */
      public Builder setOwnStatement(boolean value) {
        
        ownStatement_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional bool own_statement = 3;</code>
       */
      public Builder clearOwnStatement() {
        
        ownStatement_ = false;
        onChanged();
        return this;
      }

      private org.apache.calcite.avatica.proto.Common.Signature signature_ = null;
      private com.google.protobuf.SingleFieldBuilder<
          org.apache.calcite.avatica.proto.Common.Signature, org.apache.calcite.avatica.proto.Common.Signature.Builder, org.apache.calcite.avatica.proto.Common.SignatureOrBuilder> signatureBuilder_;
      /**
       * <code>optional .Signature signature = 4;</code>
       */
      public boolean hasSignature() {
        return signatureBuilder_ != null || signature_ != null;
      }
      /**
       * <code>optional .Signature signature = 4;</code>
       */
      public org.apache.calcite.avatica.proto.Common.Signature getSignature() {
        if (signatureBuilder_ == null) {
          return signature_ == null ? org.apache.calcite.avatica.proto.Common.Signature.getDefaultInstance() : signature_;
        } else {
          return signatureBuilder_.getMessage();
        }
      }
      /**
       * <code>optional .Signature signature = 4;</code>
       */
      public Builder setSignature(org.apache.calcite.avatica.proto.Common.Signature value) {
        if (signatureBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          signature_ = value;
          onChanged();
        } else {
          signatureBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <code>optional .Signature signature = 4;</code>
       */
      public Builder setSignature(
          org.apache.calcite.avatica.proto.Common.Signature.Builder builderForValue) {
        if (signatureBuilder_ == null) {
          signature_ = builderForValue.build();
          onChanged();
        } else {
          signatureBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <code>optional .Signature signature = 4;</code>
       */
      public Builder mergeSignature(org.apache.calcite.avatica.proto.Common.Signature value) {
        if (signatureBuilder_ == null) {
          if (signature_ != null) {
            signature_ =
              org.apache.calcite.avatica.proto.Common.Signature.newBuilder(signature_).mergeFrom(value).buildPartial();
          } else {
            signature_ = value;
          }
          onChanged();
        } else {
          signatureBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <code>optional .Signature signature = 4;</code>
       */
      public Builder clearSignature() {
        if (signatureBuilder_ == null) {
          signature_ = null;
          onChanged();
        } else {
          signature_ = null;
          signatureBuilder_ = null;
        }

        return this;
      }
      /**
       * <code>optional .Signature signature = 4;</code>
       */
      public org.apache.calcite.avatica.proto.Common.Signature.Builder getSignatureBuilder() {
        
        onChanged();
        return getSignatureFieldBuilder().getBuilder();
      }
      /**
       * <code>optional .Signature signature = 4;</code>
       */
      public org.apache.calcite.avatica.proto.Common.SignatureOrBuilder getSignatureOrBuilder() {
        if (signatureBuilder_ != null) {
          return signatureBuilder_.getMessageOrBuilder();
        } else {
          return signature_ == null ?
              org.apache.calcite.avatica.proto.Common.Signature.getDefaultInstance() : signature_;
        }
      }
      /**
       * <code>optional .Signature signature = 4;</code>
       */
      private com.google.protobuf.SingleFieldBuilder<
          org.apache.calcite.avatica.proto.Common.Signature, org.apache.calcite.avatica.proto.Common.Signature.Builder, org.apache.calcite.avatica.proto.Common.SignatureOrBuilder> 
          getSignatureFieldBuilder() {
        if (signatureBuilder_ == null) {
          signatureBuilder_ = new com.google.protobuf.SingleFieldBuilder<
              org.apache.calcite.avatica.proto.Common.Signature, org.apache.calcite.avatica.proto.Common.Signature.Builder, org.apache.calcite.avatica.proto.Common.SignatureOrBuilder>(
                  getSignature(),
                  getParentForChildren(),
                  isClean());
          signature_ = null;
        }
        return signatureBuilder_;
      }

      private org.apache.calcite.avatica.proto.Common.Frame firstFrame_ = null;
      private com.google.protobuf.SingleFieldBuilder<
          org.apache.calcite.avatica.proto.Common.Frame, org.apache.calcite.avatica.proto.Common.Frame.Builder, org.apache.calcite.avatica.proto.Common.FrameOrBuilder> firstFrameBuilder_;
      /**
       * <code>optional .Frame first_frame = 5;</code>
       */
      public boolean hasFirstFrame() {
        return firstFrameBuilder_ != null || firstFrame_ != null;
      }
      /**
       * <code>optional .Frame first_frame = 5;</code>
       */
      public org.apache.calcite.avatica.proto.Common.Frame getFirstFrame() {
        if (firstFrameBuilder_ == null) {
          return firstFrame_ == null ? org.apache.calcite.avatica.proto.Common.Frame.getDefaultInstance() : firstFrame_;
        } else {
          return firstFrameBuilder_.getMessage();
        }
      }
      /**
       * <code>optional .Frame first_frame = 5;</code>
       */
      public Builder setFirstFrame(org.apache.calcite.avatica.proto.Common.Frame value) {
        if (firstFrameBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          firstFrame_ = value;
          onChanged();
        } else {
          firstFrameBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <code>optional .Frame first_frame = 5;</code>
       */
      public Builder setFirstFrame(
          org.apache.calcite.avatica.proto.Common.Frame.Builder builderForValue) {
        if (firstFrameBuilder_ == null) {
          firstFrame_ = builderForValue.build();
          onChanged();
        } else {
          firstFrameBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <code>optional .Frame first_frame = 5;</code>
       */
      public Builder mergeFirstFrame(org.apache.calcite.avatica.proto.Common.Frame value) {
        if (firstFrameBuilder_ == null) {
          if (firstFrame_ != null) {
            firstFrame_ =
              org.apache.calcite.avatica.proto.Common.Frame.newBuilder(firstFrame_).mergeFrom(value).buildPartial();
          } else {
            firstFrame_ = value;
          }
          onChanged();
        } else {
          firstFrameBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <code>optional .Frame first_frame = 5;</code>
       */
      public Builder clearFirstFrame() {
        if (firstFrameBuilder_ == null) {
          firstFrame_ = null;
          onChanged();
        } else {
          firstFrame_ = null;
          firstFrameBuilder_ = null;
        }

        return this;
      }
      /**
       * <code>optional .Frame first_frame = 5;</code>
       */
      public org.apache.calcite.avatica.proto.Common.Frame.Builder getFirstFrameBuilder() {
        
        onChanged();
        return getFirstFrameFieldBuilder().getBuilder();
      }
      /**
       * <code>optional .Frame first_frame = 5;</code>
       */
      public org.apache.calcite.avatica.proto.Common.FrameOrBuilder getFirstFrameOrBuilder() {
        if (firstFrameBuilder_ != null) {
          return firstFrameBuilder_.getMessageOrBuilder();
        } else {
          return firstFrame_ == null ?
              org.apache.calcite.avatica.proto.Common.Frame.getDefaultInstance() : firstFrame_;
        }
      }
      /**
       * <code>optional .Frame first_frame = 5;</code>
       */
      private com.google.protobuf.SingleFieldBuilder<
          org.apache.calcite.avatica.proto.Common.Frame, org.apache.calcite.avatica.proto.Common.Frame.Builder, org.apache.calcite.avatica.proto.Common.FrameOrBuilder> 
          getFirstFrameFieldBuilder() {
        if (firstFrameBuilder_ == null) {
          firstFrameBuilder_ = new com.google.protobuf.SingleFieldBuilder<
              org.apache.calcite.avatica.proto.Common.Frame, org.apache.calcite.avatica.proto.Common.Frame.Builder, org.apache.calcite.avatica.proto.Common.FrameOrBuilder>(
                  getFirstFrame(),
                  getParentForChildren(),
                  isClean());
          firstFrame_ = null;
        }
        return firstFrameBuilder_;
      }

      private long updateCount_ ;
      /**
       * <code>optional uint64 update_count = 6;</code>
       *
       * <pre>
       * -1 for normal result sets, else this response contains a dummy result set
       * </pre>
       */
      public long getUpdateCount() {
        return updateCount_;
      }
      /**
       * <code>optional uint64 update_count = 6;</code>
       *
       * <pre>
       * -1 for normal result sets, else this response contains a dummy result set
       * </pre>
       */
      public Builder setUpdateCount(long value) {
        
        updateCount_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional uint64 update_count = 6;</code>
       *
       * <pre>
       * -1 for normal result sets, else this response contains a dummy result set
       * </pre>
       */
      public Builder clearUpdateCount() {
        
        updateCount_ = 0L;
        onChanged();
        return this;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return this;
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return this;
      }


      // @@protoc_insertion_point(builder_scope:ResultSetResponse)
    }

    // @@protoc_insertion_point(class_scope:ResultSetResponse)
    private static final org.apache.calcite.avatica.proto.Responses.ResultSetResponse DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.apache.calcite.avatica.proto.Responses.ResultSetResponse();
    }

    public static org.apache.calcite.avatica.proto.Responses.ResultSetResponse getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ResultSetResponse>
        PARSER = new com.google.protobuf.AbstractParser<ResultSetResponse>() {
      public ResultSetResponse parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        try {
          return new ResultSetResponse(input, extensionRegistry);
        } catch (RuntimeException e) {
          if (e.getCause() instanceof
              com.google.protobuf.InvalidProtocolBufferException) {
            throw (com.google.protobuf.InvalidProtocolBufferException)
                e.getCause();
          }
          throw e;
        }
      }
    };

    public static com.google.protobuf.Parser<ResultSetResponse> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ResultSetResponse> getParserForType() {
      return PARSER;
    }

    public org.apache.calcite.avatica.proto.Responses.ResultSetResponse getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface ExecuteResponseOrBuilder extends
      // @@protoc_insertion_point(interface_extends:ExecuteResponse)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>repeated .ResultSetResponse results = 1;</code>
     */
    java.util.List<org.apache.calcite.avatica.proto.Responses.ResultSetResponse> 
        getResultsList();
    /**
     * <code>repeated .ResultSetResponse results = 1;</code>
     */
    org.apache.calcite.avatica.proto.Responses.ResultSetResponse getResults(int index);
    /**
     * <code>repeated .ResultSetResponse results = 1;</code>
     */
    int getResultsCount();
    /**
     * <code>repeated .ResultSetResponse results = 1;</code>
     */
    java.util.List<? extends org.apache.calcite.avatica.proto.Responses.ResultSetResponseOrBuilder> 
        getResultsOrBuilderList();
    /**
     * <code>repeated .ResultSetResponse results = 1;</code>
     */
    org.apache.calcite.avatica.proto.Responses.ResultSetResponseOrBuilder getResultsOrBuilder(
        int index);

    /**
     * <code>optional bool missing_statement = 2;</code>
     *
     * <pre>
     * Did the request fail because of no-cached statement
     * </pre>
     */
    boolean getMissingStatement();
  }
  /**
   * Protobuf type {@code ExecuteResponse}
   *
   * <pre>
   * Response to PrepareAndExecuteRequest
   * </pre>
   */
  public  static final class ExecuteResponse extends
      com.google.protobuf.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:ExecuteResponse)
      ExecuteResponseOrBuilder {
    // Use ExecuteResponse.newBuilder() to construct.
    private ExecuteResponse(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
    }
    private ExecuteResponse() {
      results_ = java.util.Collections.emptyList();
      missingStatement_ = false;
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return com.google.protobuf.UnknownFieldSet.getDefaultInstance();
    }
    private ExecuteResponse(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry) {
      this();
      int mutable_bitField0_ = 0;
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!input.skipField(tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              if (!((mutable_bitField0_ & 0x00000001) == 0x00000001)) {
                results_ = new java.util.ArrayList<org.apache.calcite.avatica.proto.Responses.ResultSetResponse>();
                mutable_bitField0_ |= 0x00000001;
              }
              results_.add(input.readMessage(org.apache.calcite.avatica.proto.Responses.ResultSetResponse.parser(), extensionRegistry));
              break;
            }
            case 16: {

              missingStatement_ = input.readBool();
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw new RuntimeException(e.setUnfinishedMessage(this));
      } catch (java.io.IOException e) {
        throw new RuntimeException(
            new com.google.protobuf.InvalidProtocolBufferException(
                e.getMessage()).setUnfinishedMessage(this));
      } finally {
        if (((mutable_bitField0_ & 0x00000001) == 0x00000001)) {
          results_ = java.util.Collections.unmodifiableList(results_);
        }
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.calcite.avatica.proto.Responses.internal_static_ExecuteResponse_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.calcite.avatica.proto.Responses.internal_static_ExecuteResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.calcite.avatica.proto.Responses.ExecuteResponse.class, org.apache.calcite.avatica.proto.Responses.ExecuteResponse.Builder.class);
    }

    private int bitField0_;
    public static final int RESULTS_FIELD_NUMBER = 1;
    private java.util.List<org.apache.calcite.avatica.proto.Responses.ResultSetResponse> results_;
    /**
     * <code>repeated .ResultSetResponse results = 1;</code>
     */
    public java.util.List<org.apache.calcite.avatica.proto.Responses.ResultSetResponse> getResultsList() {
      return results_;
    }
    /**
     * <code>repeated .ResultSetResponse results = 1;</code>
     */
    public java.util.List<? extends org.apache.calcite.avatica.proto.Responses.ResultSetResponseOrBuilder> 
        getResultsOrBuilderList() {
      return results_;
    }
    /**
     * <code>repeated .ResultSetResponse results = 1;</code>
     */
    public int getResultsCount() {
      return results_.size();
    }
    /**
     * <code>repeated .ResultSetResponse results = 1;</code>
     */
    public org.apache.calcite.avatica.proto.Responses.ResultSetResponse getResults(int index) {
      return results_.get(index);
    }
    /**
     * <code>repeated .ResultSetResponse results = 1;</code>
     */
    public org.apache.calcite.avatica.proto.Responses.ResultSetResponseOrBuilder getResultsOrBuilder(
        int index) {
      return results_.get(index);
    }

    public static final int MISSING_STATEMENT_FIELD_NUMBER = 2;
    private boolean missingStatement_;
    /**
     * <code>optional bool missing_statement = 2;</code>
     *
     * <pre>
     * Did the request fail because of no-cached statement
     * </pre>
     */
    public boolean getMissingStatement() {
      return missingStatement_;
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      for (int i = 0; i < results_.size(); i++) {
        output.writeMessage(1, results_.get(i));
      }
      if (missingStatement_ != false) {
        output.writeBool(2, missingStatement_);
      }
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < results_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(1, results_.get(i));
      }
      if (missingStatement_ != false) {
        size += com.google.protobuf.CodedOutputStream
          .computeBoolSize(2, missingStatement_);
      }
      memoizedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    public static org.apache.calcite.avatica.proto.Responses.ExecuteResponse parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.calcite.avatica.proto.Responses.ExecuteResponse parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.calcite.avatica.proto.Responses.ExecuteResponse parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.calcite.avatica.proto.Responses.ExecuteResponse parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.calcite.avatica.proto.Responses.ExecuteResponse parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.calcite.avatica.proto.Responses.ExecuteResponse parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static org.apache.calcite.avatica.proto.Responses.ExecuteResponse parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static org.apache.calcite.avatica.proto.Responses.ExecuteResponse parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static org.apache.calcite.avatica.proto.Responses.ExecuteResponse parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.calcite.avatica.proto.Responses.ExecuteResponse parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.apache.calcite.avatica.proto.Responses.ExecuteResponse prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code ExecuteResponse}
     *
     * <pre>
     * Response to PrepareAndExecuteRequest
     * </pre>
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:ExecuteResponse)
        org.apache.calcite.avatica.proto.Responses.ExecuteResponseOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.calcite.avatica.proto.Responses.internal_static_ExecuteResponse_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.calcite.avatica.proto.Responses.internal_static_ExecuteResponse_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.calcite.avatica.proto.Responses.ExecuteResponse.class, org.apache.calcite.avatica.proto.Responses.ExecuteResponse.Builder.class);
      }

      // Construct using org.apache.calcite.avatica.proto.Responses.ExecuteResponse.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
          getResultsFieldBuilder();
        }
      }
      public Builder clear() {
        super.clear();
        if (resultsBuilder_ == null) {
          results_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
        } else {
          resultsBuilder_.clear();
        }
        missingStatement_ = false;

        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.calcite.avatica.proto.Responses.internal_static_ExecuteResponse_descriptor;
      }

      public org.apache.calcite.avatica.proto.Responses.ExecuteResponse getDefaultInstanceForType() {
        return org.apache.calcite.avatica.proto.Responses.ExecuteResponse.getDefaultInstance();
      }

      public org.apache.calcite.avatica.proto.Responses.ExecuteResponse build() {
        org.apache.calcite.avatica.proto.Responses.ExecuteResponse result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public org.apache.calcite.avatica.proto.Responses.ExecuteResponse buildPartial() {
        org.apache.calcite.avatica.proto.Responses.ExecuteResponse result = new org.apache.calcite.avatica.proto.Responses.ExecuteResponse(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (resultsBuilder_ == null) {
          if (((bitField0_ & 0x00000001) == 0x00000001)) {
            results_ = java.util.Collections.unmodifiableList(results_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.results_ = results_;
        } else {
          result.results_ = resultsBuilder_.build();
        }
        result.missingStatement_ = missingStatement_;
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.apache.calcite.avatica.proto.Responses.ExecuteResponse) {
          return mergeFrom((org.apache.calcite.avatica.proto.Responses.ExecuteResponse)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.calcite.avatica.proto.Responses.ExecuteResponse other) {
        if (other == org.apache.calcite.avatica.proto.Responses.ExecuteResponse.getDefaultInstance()) return this;
        if (resultsBuilder_ == null) {
          if (!other.results_.isEmpty()) {
            if (results_.isEmpty()) {
              results_ = other.results_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureResultsIsMutable();
              results_.addAll(other.results_);
            }
            onChanged();
          }
        } else {
          if (!other.results_.isEmpty()) {
            if (resultsBuilder_.isEmpty()) {
              resultsBuilder_.dispose();
              resultsBuilder_ = null;
              results_ = other.results_;
              bitField0_ = (bitField0_ & ~0x00000001);
              resultsBuilder_ = 
                com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders ?
                   getResultsFieldBuilder() : null;
            } else {
              resultsBuilder_.addAllMessages(other.results_);
            }
          }
        }
        if (other.getMissingStatement() != false) {
          setMissingStatement(other.getMissingStatement());
        }
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        org.apache.calcite.avatica.proto.Responses.ExecuteResponse parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (org.apache.calcite.avatica.proto.Responses.ExecuteResponse) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private java.util.List<org.apache.calcite.avatica.proto.Responses.ResultSetResponse> results_ =
        java.util.Collections.emptyList();
      private void ensureResultsIsMutable() {
        if (!((bitField0_ & 0x00000001) == 0x00000001)) {
          results_ = new java.util.ArrayList<org.apache.calcite.avatica.proto.Responses.ResultSetResponse>(results_);
          bitField0_ |= 0x00000001;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilder<
          org.apache.calcite.avatica.proto.Responses.ResultSetResponse, org.apache.calcite.avatica.proto.Responses.ResultSetResponse.Builder, org.apache.calcite.avatica.proto.Responses.ResultSetResponseOrBuilder> resultsBuilder_;

      /**
       * <code>repeated .ResultSetResponse results = 1;</code>
       */
      public java.util.List<org.apache.calcite.avatica.proto.Responses.ResultSetResponse> getResultsList() {
        if (resultsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(results_);
        } else {
          return resultsBuilder_.getMessageList();
        }
      }
      /**
       * <code>repeated .ResultSetResponse results = 1;</code>
       */
      public int getResultsCount() {
        if (resultsBuilder_ == null) {
          return results_.size();
        } else {
          return resultsBuilder_.getCount();
        }
      }
      /**
       * <code>repeated .ResultSetResponse results = 1;</code>
       */
      public org.apache.calcite.avatica.proto.Responses.ResultSetResponse getResults(int index) {
        if (resultsBuilder_ == null) {
          return results_.get(index);
        } else {
          return resultsBuilder_.getMessage(index);
        }
      }
      /**
       * <code>repeated .ResultSetResponse results = 1;</code>
       */
      public Builder setResults(
          int index, org.apache.calcite.avatica.proto.Responses.ResultSetResponse value) {
        if (resultsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureResultsIsMutable();
          results_.set(index, value);
          onChanged();
        } else {
          resultsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .ResultSetResponse results = 1;</code>
       */
      public Builder setResults(
          int index, org.apache.calcite.avatica.proto.Responses.ResultSetResponse.Builder builderForValue) {
        if (resultsBuilder_ == null) {
          ensureResultsIsMutable();
          results_.set(index, builderForValue.build());
          onChanged();
        } else {
          resultsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .ResultSetResponse results = 1;</code>
       */
      public Builder addResults(org.apache.calcite.avatica.proto.Responses.ResultSetResponse value) {
        if (resultsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureResultsIsMutable();
          results_.add(value);
          onChanged();
        } else {
          resultsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <code>repeated .ResultSetResponse results = 1;</code>
       */
      public Builder addResults(
          int index, org.apache.calcite.avatica.proto.Responses.ResultSetResponse value) {
        if (resultsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureResultsIsMutable();
          results_.add(index, value);
          onChanged();
        } else {
          resultsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .ResultSetResponse results = 1;</code>
       */
      public Builder addResults(
          org.apache.calcite.avatica.proto.Responses.ResultSetResponse.Builder builderForValue) {
        if (resultsBuilder_ == null) {
          ensureResultsIsMutable();
          results_.add(builderForValue.build());
          onChanged();
        } else {
          resultsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .ResultSetResponse results = 1;</code>
       */
      public Builder addResults(
          int index, org.apache.calcite.avatica.proto.Responses.ResultSetResponse.Builder builderForValue) {
        if (resultsBuilder_ == null) {
          ensureResultsIsMutable();
          results_.add(index, builderForValue.build());
          onChanged();
        } else {
          resultsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .ResultSetResponse results = 1;</code>
       */
      public Builder addAllResults(
          java.lang.Iterable<? extends org.apache.calcite.avatica.proto.Responses.ResultSetResponse> values) {
        if (resultsBuilder_ == null) {
          ensureResultsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, results_);
          onChanged();
        } else {
          resultsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <code>repeated .ResultSetResponse results = 1;</code>
       */
      public Builder clearResults() {
        if (resultsBuilder_ == null) {
          results_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          resultsBuilder_.clear();
        }
        return this;
      }
      /**
       * <code>repeated .ResultSetResponse results = 1;</code>
       */
      public Builder removeResults(int index) {
        if (resultsBuilder_ == null) {
          ensureResultsIsMutable();
          results_.remove(index);
          onChanged();
        } else {
          resultsBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <code>repeated .ResultSetResponse results = 1;</code>
       */
      public org.apache.calcite.avatica.proto.Responses.ResultSetResponse.Builder getResultsBuilder(
          int index) {
        return getResultsFieldBuilder().getBuilder(index);
      }
      /**
       * <code>repeated .ResultSetResponse results = 1;</code>
       */
      public org.apache.calcite.avatica.proto.Responses.ResultSetResponseOrBuilder getResultsOrBuilder(
          int index) {
        if (resultsBuilder_ == null) {
          return results_.get(index);  } else {
          return resultsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <code>repeated .ResultSetResponse results = 1;</code>
       */
      public java.util.List<? extends org.apache.calcite.avatica.proto.Responses.ResultSetResponseOrBuilder> 
           getResultsOrBuilderList() {
        if (resultsBuilder_ != null) {
          return resultsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(results_);
        }
      }
      /**
       * <code>repeated .ResultSetResponse results = 1;</code>
       */
      public org.apache.calcite.avatica.proto.Responses.ResultSetResponse.Builder addResultsBuilder() {
        return getResultsFieldBuilder().addBuilder(
            org.apache.calcite.avatica.proto.Responses.ResultSetResponse.getDefaultInstance());
      }
      /**
       * <code>repeated .ResultSetResponse results = 1;</code>
       */
      public org.apache.calcite.avatica.proto.Responses.ResultSetResponse.Builder addResultsBuilder(
          int index) {
        return getResultsFieldBuilder().addBuilder(
            index, org.apache.calcite.avatica.proto.Responses.ResultSetResponse.getDefaultInstance());
      }
      /**
       * <code>repeated .ResultSetResponse results = 1;</code>
       */
      public java.util.List<org.apache.calcite.avatica.proto.Responses.ResultSetResponse.Builder> 
           getResultsBuilderList() {
        return getResultsFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilder<
          org.apache.calcite.avatica.proto.Responses.ResultSetResponse, org.apache.calcite.avatica.proto.Responses.ResultSetResponse.Builder, org.apache.calcite.avatica.proto.Responses.ResultSetResponseOrBuilder> 
          getResultsFieldBuilder() {
        if (resultsBuilder_ == null) {
          resultsBuilder_ = new com.google.protobuf.RepeatedFieldBuilder<
              org.apache.calcite.avatica.proto.Responses.ResultSetResponse, org.apache.calcite.avatica.proto.Responses.ResultSetResponse.Builder, org.apache.calcite.avatica.proto.Responses.ResultSetResponseOrBuilder>(
                  results_,
                  ((bitField0_ & 0x00000001) == 0x00000001),
                  getParentForChildren(),
                  isClean());
          results_ = null;
        }
        return resultsBuilder_;
      }

      private boolean missingStatement_ ;
      /**
       * <code>optional bool missing_statement = 2;</code>
       *
       * <pre>
       * Did the request fail because of no-cached statement
       * </pre>
       */
      public boolean getMissingStatement() {
        return missingStatement_;
      }
      /**
       * <code>optional bool missing_statement = 2;</code>
       *
       * <pre>
       * Did the request fail because of no-cached statement
       * </pre>
       */
      public Builder setMissingStatement(boolean value) {
        
        missingStatement_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional bool missing_statement = 2;</code>
       *
       * <pre>
       * Did the request fail because of no-cached statement
       * </pre>
       */
      public Builder clearMissingStatement() {
        
        missingStatement_ = false;
        onChanged();
        return this;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return this;
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return this;
      }


      // @@protoc_insertion_point(builder_scope:ExecuteResponse)
    }

    // @@protoc_insertion_point(class_scope:ExecuteResponse)
    private static final org.apache.calcite.avatica.proto.Responses.ExecuteResponse DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.apache.calcite.avatica.proto.Responses.ExecuteResponse();
    }

    public static org.apache.calcite.avatica.proto.Responses.ExecuteResponse getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ExecuteResponse>
        PARSER = new com.google.protobuf.AbstractParser<ExecuteResponse>() {
      public ExecuteResponse parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        try {
          return new ExecuteResponse(input, extensionRegistry);
        } catch (RuntimeException e) {
          if (e.getCause() instanceof
              com.google.protobuf.InvalidProtocolBufferException) {
            throw (com.google.protobuf.InvalidProtocolBufferException)
                e.getCause();
          }
          throw e;
        }
      }
    };

    public static com.google.protobuf.Parser<ExecuteResponse> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ExecuteResponse> getParserForType() {
      return PARSER;
    }

    public org.apache.calcite.avatica.proto.Responses.ExecuteResponse getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface PrepareResponseOrBuilder extends
      // @@protoc_insertion_point(interface_extends:PrepareResponse)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>optional .StatementHandle statement = 1;</code>
     */
    boolean hasStatement();
    /**
     * <code>optional .StatementHandle statement = 1;</code>
     */
    org.apache.calcite.avatica.proto.Common.StatementHandle getStatement();
    /**
     * <code>optional .StatementHandle statement = 1;</code>
     */
    org.apache.calcite.avatica.proto.Common.StatementHandleOrBuilder getStatementOrBuilder();
  }
  /**
   * Protobuf type {@code PrepareResponse}
   *
   * <pre>
   * Response to PrepareRequest
   * </pre>
   */
  public  static final class PrepareResponse extends
      com.google.protobuf.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:PrepareResponse)
      PrepareResponseOrBuilder {
    // Use PrepareResponse.newBuilder() to construct.
    private PrepareResponse(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
    }
    private PrepareResponse() {
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return com.google.protobuf.UnknownFieldSet.getDefaultInstance();
    }
    private PrepareResponse(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry) {
      this();
      int mutable_bitField0_ = 0;
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!input.skipField(tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              org.apache.calcite.avatica.proto.Common.StatementHandle.Builder subBuilder = null;
              if (statement_ != null) {
                subBuilder = statement_.toBuilder();
              }
              statement_ = input.readMessage(org.apache.calcite.avatica.proto.Common.StatementHandle.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(statement_);
                statement_ = subBuilder.buildPartial();
              }

              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw new RuntimeException(e.setUnfinishedMessage(this));
      } catch (java.io.IOException e) {
        throw new RuntimeException(
            new com.google.protobuf.InvalidProtocolBufferException(
                e.getMessage()).setUnfinishedMessage(this));
      } finally {
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.calcite.avatica.proto.Responses.internal_static_PrepareResponse_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.calcite.avatica.proto.Responses.internal_static_PrepareResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.calcite.avatica.proto.Responses.PrepareResponse.class, org.apache.calcite.avatica.proto.Responses.PrepareResponse.Builder.class);
    }

    public static final int STATEMENT_FIELD_NUMBER = 1;
    private org.apache.calcite.avatica.proto.Common.StatementHandle statement_;
    /**
     * <code>optional .StatementHandle statement = 1;</code>
     */
    public boolean hasStatement() {
      return statement_ != null;
    }
    /**
     * <code>optional .StatementHandle statement = 1;</code>
     */
    public org.apache.calcite.avatica.proto.Common.StatementHandle getStatement() {
      return statement_ == null ? org.apache.calcite.avatica.proto.Common.StatementHandle.getDefaultInstance() : statement_;
    }
    /**
     * <code>optional .StatementHandle statement = 1;</code>
     */
    public org.apache.calcite.avatica.proto.Common.StatementHandleOrBuilder getStatementOrBuilder() {
      return getStatement();
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (statement_ != null) {
        output.writeMessage(1, getStatement());
      }
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (statement_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(1, getStatement());
      }
      memoizedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    public static org.apache.calcite.avatica.proto.Responses.PrepareResponse parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.calcite.avatica.proto.Responses.PrepareResponse parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.calcite.avatica.proto.Responses.PrepareResponse parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.calcite.avatica.proto.Responses.PrepareResponse parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.calcite.avatica.proto.Responses.PrepareResponse parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.calcite.avatica.proto.Responses.PrepareResponse parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static org.apache.calcite.avatica.proto.Responses.PrepareResponse parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static org.apache.calcite.avatica.proto.Responses.PrepareResponse parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static org.apache.calcite.avatica.proto.Responses.PrepareResponse parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.calcite.avatica.proto.Responses.PrepareResponse parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.apache.calcite.avatica.proto.Responses.PrepareResponse prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code PrepareResponse}
     *
     * <pre>
     * Response to PrepareRequest
     * </pre>
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:PrepareResponse)
        org.apache.calcite.avatica.proto.Responses.PrepareResponseOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.calcite.avatica.proto.Responses.internal_static_PrepareResponse_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.calcite.avatica.proto.Responses.internal_static_PrepareResponse_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.calcite.avatica.proto.Responses.PrepareResponse.class, org.apache.calcite.avatica.proto.Responses.PrepareResponse.Builder.class);
      }

      // Construct using org.apache.calcite.avatica.proto.Responses.PrepareResponse.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
        }
      }
      public Builder clear() {
        super.clear();
        if (statementBuilder_ == null) {
          statement_ = null;
        } else {
          statement_ = null;
          statementBuilder_ = null;
        }
        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.calcite.avatica.proto.Responses.internal_static_PrepareResponse_descriptor;
      }

      public org.apache.calcite.avatica.proto.Responses.PrepareResponse getDefaultInstanceForType() {
        return org.apache.calcite.avatica.proto.Responses.PrepareResponse.getDefaultInstance();
      }

      public org.apache.calcite.avatica.proto.Responses.PrepareResponse build() {
        org.apache.calcite.avatica.proto.Responses.PrepareResponse result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public org.apache.calcite.avatica.proto.Responses.PrepareResponse buildPartial() {
        org.apache.calcite.avatica.proto.Responses.PrepareResponse result = new org.apache.calcite.avatica.proto.Responses.PrepareResponse(this);
        if (statementBuilder_ == null) {
          result.statement_ = statement_;
        } else {
          result.statement_ = statementBuilder_.build();
        }
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.apache.calcite.avatica.proto.Responses.PrepareResponse) {
          return mergeFrom((org.apache.calcite.avatica.proto.Responses.PrepareResponse)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.calcite.avatica.proto.Responses.PrepareResponse other) {
        if (other == org.apache.calcite.avatica.proto.Responses.PrepareResponse.getDefaultInstance()) return this;
        if (other.hasStatement()) {
          mergeStatement(other.getStatement());
        }
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        org.apache.calcite.avatica.proto.Responses.PrepareResponse parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (org.apache.calcite.avatica.proto.Responses.PrepareResponse) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private org.apache.calcite.avatica.proto.Common.StatementHandle statement_ = null;
      private com.google.protobuf.SingleFieldBuilder<
          org.apache.calcite.avatica.proto.Common.StatementHandle, org.apache.calcite.avatica.proto.Common.StatementHandle.Builder, org.apache.calcite.avatica.proto.Common.StatementHandleOrBuilder> statementBuilder_;
      /**
       * <code>optional .StatementHandle statement = 1;</code>
       */
      public boolean hasStatement() {
        return statementBuilder_ != null || statement_ != null;
      }
      /**
       * <code>optional .StatementHandle statement = 1;</code>
       */
      public org.apache.calcite.avatica.proto.Common.StatementHandle getStatement() {
        if (statementBuilder_ == null) {
          return statement_ == null ? org.apache.calcite.avatica.proto.Common.StatementHandle.getDefaultInstance() : statement_;
        } else {
          return statementBuilder_.getMessage();
        }
      }
      /**
       * <code>optional .StatementHandle statement = 1;</code>
       */
      public Builder setStatement(org.apache.calcite.avatica.proto.Common.StatementHandle value) {
        if (statementBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          statement_ = value;
          onChanged();
        } else {
          statementBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <code>optional .StatementHandle statement = 1;</code>
       */
      public Builder setStatement(
          org.apache.calcite.avatica.proto.Common.StatementHandle.Builder builderForValue) {
        if (statementBuilder_ == null) {
          statement_ = builderForValue.build();
          onChanged();
        } else {
          statementBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <code>optional .StatementHandle statement = 1;</code>
       */
      public Builder mergeStatement(org.apache.calcite.avatica.proto.Common.StatementHandle value) {
        if (statementBuilder_ == null) {
          if (statement_ != null) {
            statement_ =
              org.apache.calcite.avatica.proto.Common.StatementHandle.newBuilder(statement_).mergeFrom(value).buildPartial();
          } else {
            statement_ = value;
          }
          onChanged();
        } else {
          statementBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <code>optional .StatementHandle statement = 1;</code>
       */
      public Builder clearStatement() {
        if (statementBuilder_ == null) {
          statement_ = null;
          onChanged();
        } else {
          statement_ = null;
          statementBuilder_ = null;
        }

        return this;
      }
      /**
       * <code>optional .StatementHandle statement = 1;</code>
       */
      public org.apache.calcite.avatica.proto.Common.StatementHandle.Builder getStatementBuilder() {
        
        onChanged();
        return getStatementFieldBuilder().getBuilder();
      }
      /**
       * <code>optional .StatementHandle statement = 1;</code>
       */
      public org.apache.calcite.avatica.proto.Common.StatementHandleOrBuilder getStatementOrBuilder() {
        if (statementBuilder_ != null) {
          return statementBuilder_.getMessageOrBuilder();
        } else {
          return statement_ == null ?
              org.apache.calcite.avatica.proto.Common.StatementHandle.getDefaultInstance() : statement_;
        }
      }
      /**
       * <code>optional .StatementHandle statement = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilder<
          org.apache.calcite.avatica.proto.Common.StatementHandle, org.apache.calcite.avatica.proto.Common.StatementHandle.Builder, org.apache.calcite.avatica.proto.Common.StatementHandleOrBuilder> 
          getStatementFieldBuilder() {
        if (statementBuilder_ == null) {
          statementBuilder_ = new com.google.protobuf.SingleFieldBuilder<
              org.apache.calcite.avatica.proto.Common.StatementHandle, org.apache.calcite.avatica.proto.Common.StatementHandle.Builder, org.apache.calcite.avatica.proto.Common.StatementHandleOrBuilder>(
                  getStatement(),
                  getParentForChildren(),
                  isClean());
          statement_ = null;
        }
        return statementBuilder_;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return this;
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return this;
      }


      // @@protoc_insertion_point(builder_scope:PrepareResponse)
    }

    // @@protoc_insertion_point(class_scope:PrepareResponse)
    private static final org.apache.calcite.avatica.proto.Responses.PrepareResponse DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.apache.calcite.avatica.proto.Responses.PrepareResponse();
    }

    public static org.apache.calcite.avatica.proto.Responses.PrepareResponse getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<PrepareResponse>
        PARSER = new com.google.protobuf.AbstractParser<PrepareResponse>() {
      public PrepareResponse parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        try {
          return new PrepareResponse(input, extensionRegistry);
        } catch (RuntimeException e) {
          if (e.getCause() instanceof
              com.google.protobuf.InvalidProtocolBufferException) {
            throw (com.google.protobuf.InvalidProtocolBufferException)
                e.getCause();
          }
          throw e;
        }
      }
    };

    public static com.google.protobuf.Parser<PrepareResponse> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<PrepareResponse> getParserForType() {
      return PARSER;
    }

    public org.apache.calcite.avatica.proto.Responses.PrepareResponse getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface FetchResponseOrBuilder extends
      // @@protoc_insertion_point(interface_extends:FetchResponse)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>optional .Frame frame = 1;</code>
     */
    boolean hasFrame();
    /**
     * <code>optional .Frame frame = 1;</code>
     */
    org.apache.calcite.avatica.proto.Common.Frame getFrame();
    /**
     * <code>optional .Frame frame = 1;</code>
     */
    org.apache.calcite.avatica.proto.Common.FrameOrBuilder getFrameOrBuilder();

    /**
     * <code>optional bool missing_statement = 2;</code>
     *
     * <pre>
     * Did the request fail because of no-cached statement
     * </pre>
     */
    boolean getMissingStatement();

    /**
     * <code>optional bool missing_results = 3;</code>
     *
     * <pre>
     * Did the request fail because of a cached-statement w/o ResultSet
     * </pre>
     */
    boolean getMissingResults();
  }
  /**
   * Protobuf type {@code FetchResponse}
   *
   * <pre>
   * Response to FetchRequest
   * </pre>
   */
  public  static final class FetchResponse extends
      com.google.protobuf.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:FetchResponse)
      FetchResponseOrBuilder {
    // Use FetchResponse.newBuilder() to construct.
    private FetchResponse(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
    }
    private FetchResponse() {
      missingStatement_ = false;
      missingResults_ = false;
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return com.google.protobuf.UnknownFieldSet.getDefaultInstance();
    }
    private FetchResponse(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry) {
      this();
      int mutable_bitField0_ = 0;
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!input.skipField(tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              org.apache.calcite.avatica.proto.Common.Frame.Builder subBuilder = null;
              if (frame_ != null) {
                subBuilder = frame_.toBuilder();
              }
              frame_ = input.readMessage(org.apache.calcite.avatica.proto.Common.Frame.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(frame_);
                frame_ = subBuilder.buildPartial();
              }

              break;
            }
            case 16: {

              missingStatement_ = input.readBool();
              break;
            }
            case 24: {

              missingResults_ = input.readBool();
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw new RuntimeException(e.setUnfinishedMessage(this));
      } catch (java.io.IOException e) {
        throw new RuntimeException(
            new com.google.protobuf.InvalidProtocolBufferException(
                e.getMessage()).setUnfinishedMessage(this));
      } finally {
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.calcite.avatica.proto.Responses.internal_static_FetchResponse_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.calcite.avatica.proto.Responses.internal_static_FetchResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.calcite.avatica.proto.Responses.FetchResponse.class, org.apache.calcite.avatica.proto.Responses.FetchResponse.Builder.class);
    }

    public static final int FRAME_FIELD_NUMBER = 1;
    private org.apache.calcite.avatica.proto.Common.Frame frame_;
    /**
     * <code>optional .Frame frame = 1;</code>
     */
    public boolean hasFrame() {
      return frame_ != null;
    }
    /**
     * <code>optional .Frame frame = 1;</code>
     */
    public org.apache.calcite.avatica.proto.Common.Frame getFrame() {
      return frame_ == null ? org.apache.calcite.avatica.proto.Common.Frame.getDefaultInstance() : frame_;
    }
    /**
     * <code>optional .Frame frame = 1;</code>
     */
    public org.apache.calcite.avatica.proto.Common.FrameOrBuilder getFrameOrBuilder() {
      return getFrame();
    }

    public static final int MISSING_STATEMENT_FIELD_NUMBER = 2;
    private boolean missingStatement_;
    /**
     * <code>optional bool missing_statement = 2;</code>
     *
     * <pre>
     * Did the request fail because of no-cached statement
     * </pre>
     */
    public boolean getMissingStatement() {
      return missingStatement_;
    }

    public static final int MISSING_RESULTS_FIELD_NUMBER = 3;
    private boolean missingResults_;
    /**
     * <code>optional bool missing_results = 3;</code>
     *
     * <pre>
     * Did the request fail because of a cached-statement w/o ResultSet
     * </pre>
     */
    public boolean getMissingResults() {
      return missingResults_;
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (frame_ != null) {
        output.writeMessage(1, getFrame());
      }
      if (missingStatement_ != false) {
        output.writeBool(2, missingStatement_);
      }
      if (missingResults_ != false) {
        output.writeBool(3, missingResults_);
      }
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (frame_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(1, getFrame());
      }
      if (missingStatement_ != false) {
        size += com.google.protobuf.CodedOutputStream
          .computeBoolSize(2, missingStatement_);
      }
      if (missingResults_ != false) {
        size += com.google.protobuf.CodedOutputStream
          .computeBoolSize(3, missingResults_);
      }
      memoizedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    public static org.apache.calcite.avatica.proto.Responses.FetchResponse parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.calcite.avatica.proto.Responses.FetchResponse parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.calcite.avatica.proto.Responses.FetchResponse parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.calcite.avatica.proto.Responses.FetchResponse parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.calcite.avatica.proto.Responses.FetchResponse parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.calcite.avatica.proto.Responses.FetchResponse parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static org.apache.calcite.avatica.proto.Responses.FetchResponse parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static org.apache.calcite.avatica.proto.Responses.FetchResponse parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static org.apache.calcite.avatica.proto.Responses.FetchResponse parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.calcite.avatica.proto.Responses.FetchResponse parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.apache.calcite.avatica.proto.Responses.FetchResponse prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code FetchResponse}
     *
     * <pre>
     * Response to FetchRequest
     * </pre>
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:FetchResponse)
        org.apache.calcite.avatica.proto.Responses.FetchResponseOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.calcite.avatica.proto.Responses.internal_static_FetchResponse_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.calcite.avatica.proto.Responses.internal_static_FetchResponse_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.calcite.avatica.proto.Responses.FetchResponse.class, org.apache.calcite.avatica.proto.Responses.FetchResponse.Builder.class);
      }

      // Construct using org.apache.calcite.avatica.proto.Responses.FetchResponse.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
        }
      }
      public Builder clear() {
        super.clear();
        if (frameBuilder_ == null) {
          frame_ = null;
        } else {
          frame_ = null;
          frameBuilder_ = null;
        }
        missingStatement_ = false;

        missingResults_ = false;

        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.calcite.avatica.proto.Responses.internal_static_FetchResponse_descriptor;
      }

      public org.apache.calcite.avatica.proto.Responses.FetchResponse getDefaultInstanceForType() {
        return org.apache.calcite.avatica.proto.Responses.FetchResponse.getDefaultInstance();
      }

      public org.apache.calcite.avatica.proto.Responses.FetchResponse build() {
        org.apache.calcite.avatica.proto.Responses.FetchResponse result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public org.apache.calcite.avatica.proto.Responses.FetchResponse buildPartial() {
        org.apache.calcite.avatica.proto.Responses.FetchResponse result = new org.apache.calcite.avatica.proto.Responses.FetchResponse(this);
        if (frameBuilder_ == null) {
          result.frame_ = frame_;
        } else {
          result.frame_ = frameBuilder_.build();
        }
        result.missingStatement_ = missingStatement_;
        result.missingResults_ = missingResults_;
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.apache.calcite.avatica.proto.Responses.FetchResponse) {
          return mergeFrom((org.apache.calcite.avatica.proto.Responses.FetchResponse)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.calcite.avatica.proto.Responses.FetchResponse other) {
        if (other == org.apache.calcite.avatica.proto.Responses.FetchResponse.getDefaultInstance()) return this;
        if (other.hasFrame()) {
          mergeFrame(other.getFrame());
        }
        if (other.getMissingStatement() != false) {
          setMissingStatement(other.getMissingStatement());
        }
        if (other.getMissingResults() != false) {
          setMissingResults(other.getMissingResults());
        }
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        org.apache.calcite.avatica.proto.Responses.FetchResponse parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (org.apache.calcite.avatica.proto.Responses.FetchResponse) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private org.apache.calcite.avatica.proto.Common.Frame frame_ = null;
      private com.google.protobuf.SingleFieldBuilder<
          org.apache.calcite.avatica.proto.Common.Frame, org.apache.calcite.avatica.proto.Common.Frame.Builder, org.apache.calcite.avatica.proto.Common.FrameOrBuilder> frameBuilder_;
      /**
       * <code>optional .Frame frame = 1;</code>
       */
      public boolean hasFrame() {
        return frameBuilder_ != null || frame_ != null;
      }
      /**
       * <code>optional .Frame frame = 1;</code>
       */
      public org.apache.calcite.avatica.proto.Common.Frame getFrame() {
        if (frameBuilder_ == null) {
          return frame_ == null ? org.apache.calcite.avatica.proto.Common.Frame.getDefaultInstance() : frame_;
        } else {
          return frameBuilder_.getMessage();
        }
      }
      /**
       * <code>optional .Frame frame = 1;</code>
       */
      public Builder setFrame(org.apache.calcite.avatica.proto.Common.Frame value) {
        if (frameBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          frame_ = value;
          onChanged();
        } else {
          frameBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <code>optional .Frame frame = 1;</code>
       */
      public Builder setFrame(
          org.apache.calcite.avatica.proto.Common.Frame.Builder builderForValue) {
        if (frameBuilder_ == null) {
          frame_ = builderForValue.build();
          onChanged();
        } else {
          frameBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <code>optional .Frame frame = 1;</code>
       */
      public Builder mergeFrame(org.apache.calcite.avatica.proto.Common.Frame value) {
        if (frameBuilder_ == null) {
          if (frame_ != null) {
            frame_ =
              org.apache.calcite.avatica.proto.Common.Frame.newBuilder(frame_).mergeFrom(value).buildPartial();
          } else {
            frame_ = value;
          }
          onChanged();
        } else {
          frameBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <code>optional .Frame frame = 1;</code>
       */
      public Builder clearFrame() {
        if (frameBuilder_ == null) {
          frame_ = null;
          onChanged();
        } else {
          frame_ = null;
          frameBuilder_ = null;
        }

        return this;
      }
      /**
       * <code>optional .Frame frame = 1;</code>
       */
      public org.apache.calcite.avatica.proto.Common.Frame.Builder getFrameBuilder() {
        
        onChanged();
        return getFrameFieldBuilder().getBuilder();
      }
      /**
       * <code>optional .Frame frame = 1;</code>
       */
      public org.apache.calcite.avatica.proto.Common.FrameOrBuilder getFrameOrBuilder() {
        if (frameBuilder_ != null) {
          return frameBuilder_.getMessageOrBuilder();
        } else {
          return frame_ == null ?
              org.apache.calcite.avatica.proto.Common.Frame.getDefaultInstance() : frame_;
        }
      }
      /**
       * <code>optional .Frame frame = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilder<
          org.apache.calcite.avatica.proto.Common.Frame, org.apache.calcite.avatica.proto.Common.Frame.Builder, org.apache.calcite.avatica.proto.Common.FrameOrBuilder> 
          getFrameFieldBuilder() {
        if (frameBuilder_ == null) {
          frameBuilder_ = new com.google.protobuf.SingleFieldBuilder<
              org.apache.calcite.avatica.proto.Common.Frame, org.apache.calcite.avatica.proto.Common.Frame.Builder, org.apache.calcite.avatica.proto.Common.FrameOrBuilder>(
                  getFrame(),
                  getParentForChildren(),
                  isClean());
          frame_ = null;
        }
        return frameBuilder_;
      }

      private boolean missingStatement_ ;
      /**
       * <code>optional bool missing_statement = 2;</code>
       *
       * <pre>
       * Did the request fail because of no-cached statement
       * </pre>
       */
      public boolean getMissingStatement() {
        return missingStatement_;
      }
      /**
       * <code>optional bool missing_statement = 2;</code>
       *
       * <pre>
       * Did the request fail because of no-cached statement
       * </pre>
       */
      public Builder setMissingStatement(boolean value) {
        
        missingStatement_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional bool missing_statement = 2;</code>
       *
       * <pre>
       * Did the request fail because of no-cached statement
       * </pre>
       */
      public Builder clearMissingStatement() {
        
        missingStatement_ = false;
        onChanged();
        return this;
      }

      private boolean missingResults_ ;
      /**
       * <code>optional bool missing_results = 3;</code>
       *
       * <pre>
       * Did the request fail because of a cached-statement w/o ResultSet
       * </pre>
       */
      public boolean getMissingResults() {
        return missingResults_;
      }
      /**
       * <code>optional bool missing_results = 3;</code>
       *
       * <pre>
       * Did the request fail because of a cached-statement w/o ResultSet
       * </pre>
       */
      public Builder setMissingResults(boolean value) {
        
        missingResults_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional bool missing_results = 3;</code>
       *
       * <pre>
       * Did the request fail because of a cached-statement w/o ResultSet
       * </pre>
       */
      public Builder clearMissingResults() {
        
        missingResults_ = false;
        onChanged();
        return this;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return this;
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return this;
      }


      // @@protoc_insertion_point(builder_scope:FetchResponse)
    }

    // @@protoc_insertion_point(class_scope:FetchResponse)
    private static final org.apache.calcite.avatica.proto.Responses.FetchResponse DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.apache.calcite.avatica.proto.Responses.FetchResponse();
    }

    public static org.apache.calcite.avatica.proto.Responses.FetchResponse getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<FetchResponse>
        PARSER = new com.google.protobuf.AbstractParser<FetchResponse>() {
      public FetchResponse parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        try {
          return new FetchResponse(input, extensionRegistry);
        } catch (RuntimeException e) {
          if (e.getCause() instanceof
              com.google.protobuf.InvalidProtocolBufferException) {
            throw (com.google.protobuf.InvalidProtocolBufferException)
                e.getCause();
          }
          throw e;
        }
      }
    };

    public static com.google.protobuf.Parser<FetchResponse> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<FetchResponse> getParserForType() {
      return PARSER;
    }

    public org.apache.calcite.avatica.proto.Responses.FetchResponse getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface CreateStatementResponseOrBuilder extends
      // @@protoc_insertion_point(interface_extends:CreateStatementResponse)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>optional string connection_id = 1;</code>
     */
    java.lang.String getConnectionId();
    /**
     * <code>optional string connection_id = 1;</code>
     */
    com.google.protobuf.ByteString
        getConnectionIdBytes();

    /**
     * <code>optional uint32 statement_id = 2;</code>
     */
    int getStatementId();
  }
  /**
   * Protobuf type {@code CreateStatementResponse}
   *
   * <pre>
   * Response to CreateStatementRequest
   * </pre>
   */
  public  static final class CreateStatementResponse extends
      com.google.protobuf.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:CreateStatementResponse)
      CreateStatementResponseOrBuilder {
    // Use CreateStatementResponse.newBuilder() to construct.
    private CreateStatementResponse(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
    }
    private CreateStatementResponse() {
      connectionId_ = "";
      statementId_ = 0;
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return com.google.protobuf.UnknownFieldSet.getDefaultInstance();
    }
    private CreateStatementResponse(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry) {
      this();
      int mutable_bitField0_ = 0;
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!input.skipField(tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              String s = input.readStringRequireUtf8();

              connectionId_ = s;
              break;
            }
            case 16: {

              statementId_ = input.readUInt32();
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw new RuntimeException(e.setUnfinishedMessage(this));
      } catch (java.io.IOException e) {
        throw new RuntimeException(
            new com.google.protobuf.InvalidProtocolBufferException(
                e.getMessage()).setUnfinishedMessage(this));
      } finally {
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.calcite.avatica.proto.Responses.internal_static_CreateStatementResponse_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.calcite.avatica.proto.Responses.internal_static_CreateStatementResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.calcite.avatica.proto.Responses.CreateStatementResponse.class, org.apache.calcite.avatica.proto.Responses.CreateStatementResponse.Builder.class);
    }

    public static final int CONNECTION_ID_FIELD_NUMBER = 1;
    private volatile java.lang.Object connectionId_;
    /**
     * <code>optional string connection_id = 1;</code>
     */
    public java.lang.String getConnectionId() {
      java.lang.Object ref = connectionId_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        connectionId_ = s;
        return s;
      }
    }
    /**
     * <code>optional string connection_id = 1;</code>
     */
    public com.google.protobuf.ByteString
        getConnectionIdBytes() {
      java.lang.Object ref = connectionId_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        connectionId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int STATEMENT_ID_FIELD_NUMBER = 2;
    private int statementId_;
    /**
     * <code>optional uint32 statement_id = 2;</code>
     */
    public int getStatementId() {
      return statementId_;
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (!getConnectionIdBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessage.writeString(output, 1, connectionId_);
      }
      if (statementId_ != 0) {
        output.writeUInt32(2, statementId_);
      }
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!getConnectionIdBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessage.computeStringSize(1, connectionId_);
      }
      if (statementId_ != 0) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt32Size(2, statementId_);
      }
      memoizedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    public static org.apache.calcite.avatica.proto.Responses.CreateStatementResponse parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.calcite.avatica.proto.Responses.CreateStatementResponse parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.calcite.avatica.proto.Responses.CreateStatementResponse parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.calcite.avatica.proto.Responses.CreateStatementResponse parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.calcite.avatica.proto.Responses.CreateStatementResponse parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.calcite.avatica.proto.Responses.CreateStatementResponse parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static org.apache.calcite.avatica.proto.Responses.CreateStatementResponse parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static org.apache.calcite.avatica.proto.Responses.CreateStatementResponse parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static org.apache.calcite.avatica.proto.Responses.CreateStatementResponse parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.calcite.avatica.proto.Responses.CreateStatementResponse parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.apache.calcite.avatica.proto.Responses.CreateStatementResponse prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code CreateStatementResponse}
     *
     * <pre>
     * Response to CreateStatementRequest
     * </pre>
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:CreateStatementResponse)
        org.apache.calcite.avatica.proto.Responses.CreateStatementResponseOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.calcite.avatica.proto.Responses.internal_static_CreateStatementResponse_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.calcite.avatica.proto.Responses.internal_static_CreateStatementResponse_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.calcite.avatica.proto.Responses.CreateStatementResponse.class, org.apache.calcite.avatica.proto.Responses.CreateStatementResponse.Builder.class);
      }

      // Construct using org.apache.calcite.avatica.proto.Responses.CreateStatementResponse.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
        }
      }
      public Builder clear() {
        super.clear();
        connectionId_ = "";

        statementId_ = 0;

        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.calcite.avatica.proto.Responses.internal_static_CreateStatementResponse_descriptor;
      }

      public org.apache.calcite.avatica.proto.Responses.CreateStatementResponse getDefaultInstanceForType() {
        return org.apache.calcite.avatica.proto.Responses.CreateStatementResponse.getDefaultInstance();
      }

      public org.apache.calcite.avatica.proto.Responses.CreateStatementResponse build() {
        org.apache.calcite.avatica.proto.Responses.CreateStatementResponse result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public org.apache.calcite.avatica.proto.Responses.CreateStatementResponse buildPartial() {
        org.apache.calcite.avatica.proto.Responses.CreateStatementResponse result = new org.apache.calcite.avatica.proto.Responses.CreateStatementResponse(this);
        result.connectionId_ = connectionId_;
        result.statementId_ = statementId_;
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.apache.calcite.avatica.proto.Responses.CreateStatementResponse) {
          return mergeFrom((org.apache.calcite.avatica.proto.Responses.CreateStatementResponse)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.calcite.avatica.proto.Responses.CreateStatementResponse other) {
        if (other == org.apache.calcite.avatica.proto.Responses.CreateStatementResponse.getDefaultInstance()) return this;
        if (!other.getConnectionId().isEmpty()) {
          connectionId_ = other.connectionId_;
          onChanged();
        }
        if (other.getStatementId() != 0) {
          setStatementId(other.getStatementId());
        }
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        org.apache.calcite.avatica.proto.Responses.CreateStatementResponse parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (org.apache.calcite.avatica.proto.Responses.CreateStatementResponse) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private java.lang.Object connectionId_ = "";
      /**
       * <code>optional string connection_id = 1;</code>
       */
      public java.lang.String getConnectionId() {
        java.lang.Object ref = connectionId_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          connectionId_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>optional string connection_id = 1;</code>
       */
      public com.google.protobuf.ByteString
          getConnectionIdBytes() {
        java.lang.Object ref = connectionId_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          connectionId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>optional string connection_id = 1;</code>
       */
      public Builder setConnectionId(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        connectionId_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional string connection_id = 1;</code>
       */
      public Builder clearConnectionId() {
        
        connectionId_ = getDefaultInstance().getConnectionId();
        onChanged();
        return this;
      }
      /**
       * <code>optional string connection_id = 1;</code>
       */
      public Builder setConnectionIdBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        connectionId_ = value;
        onChanged();
        return this;
      }

      private int statementId_ ;
      /**
       * <code>optional uint32 statement_id = 2;</code>
       */
      public int getStatementId() {
        return statementId_;
      }
      /**
       * <code>optional uint32 statement_id = 2;</code>
       */
      public Builder setStatementId(int value) {
        
        statementId_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional uint32 statement_id = 2;</code>
       */
      public Builder clearStatementId() {
        
        statementId_ = 0;
        onChanged();
        return this;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return this;
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return this;
      }


      // @@protoc_insertion_point(builder_scope:CreateStatementResponse)
    }

    // @@protoc_insertion_point(class_scope:CreateStatementResponse)
    private static final org.apache.calcite.avatica.proto.Responses.CreateStatementResponse DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.apache.calcite.avatica.proto.Responses.CreateStatementResponse();
    }

    public static org.apache.calcite.avatica.proto.Responses.CreateStatementResponse getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<CreateStatementResponse>
        PARSER = new com.google.protobuf.AbstractParser<CreateStatementResponse>() {
      public CreateStatementResponse parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        try {
          return new CreateStatementResponse(input, extensionRegistry);
        } catch (RuntimeException e) {
          if (e.getCause() instanceof
              com.google.protobuf.InvalidProtocolBufferException) {
            throw (com.google.protobuf.InvalidProtocolBufferException)
                e.getCause();
          }
          throw e;
        }
      }
    };

    public static com.google.protobuf.Parser<CreateStatementResponse> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<CreateStatementResponse> getParserForType() {
      return PARSER;
    }

    public org.apache.calcite.avatica.proto.Responses.CreateStatementResponse getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface CloseStatementResponseOrBuilder extends
      // @@protoc_insertion_point(interface_extends:CloseStatementResponse)
      com.google.protobuf.MessageOrBuilder {
  }
  /**
   * Protobuf type {@code CloseStatementResponse}
   *
   * <pre>
   * Response to CloseStatementRequest
   * </pre>
   */
  public  static final class CloseStatementResponse extends
      com.google.protobuf.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:CloseStatementResponse)
      CloseStatementResponseOrBuilder {
    // Use CloseStatementResponse.newBuilder() to construct.
    private CloseStatementResponse(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
    }
    private CloseStatementResponse() {
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return com.google.protobuf.UnknownFieldSet.getDefaultInstance();
    }
    private CloseStatementResponse(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry) {
      this();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!input.skipField(tag)) {
                done = true;
              }
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw new RuntimeException(e.setUnfinishedMessage(this));
      } catch (java.io.IOException e) {
        throw new RuntimeException(
            new com.google.protobuf.InvalidProtocolBufferException(
                e.getMessage()).setUnfinishedMessage(this));
      } finally {
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.calcite.avatica.proto.Responses.internal_static_CloseStatementResponse_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.calcite.avatica.proto.Responses.internal_static_CloseStatementResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.calcite.avatica.proto.Responses.CloseStatementResponse.class, org.apache.calcite.avatica.proto.Responses.CloseStatementResponse.Builder.class);
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      memoizedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    public static org.apache.calcite.avatica.proto.Responses.CloseStatementResponse parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.calcite.avatica.proto.Responses.CloseStatementResponse parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.calcite.avatica.proto.Responses.CloseStatementResponse parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.calcite.avatica.proto.Responses.CloseStatementResponse parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.calcite.avatica.proto.Responses.CloseStatementResponse parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.calcite.avatica.proto.Responses.CloseStatementResponse parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static org.apache.calcite.avatica.proto.Responses.CloseStatementResponse parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static org.apache.calcite.avatica.proto.Responses.CloseStatementResponse parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static org.apache.calcite.avatica.proto.Responses.CloseStatementResponse parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.calcite.avatica.proto.Responses.CloseStatementResponse parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.apache.calcite.avatica.proto.Responses.CloseStatementResponse prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code CloseStatementResponse}
     *
     * <pre>
     * Response to CloseStatementRequest
     * </pre>
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:CloseStatementResponse)
        org.apache.calcite.avatica.proto.Responses.CloseStatementResponseOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.calcite.avatica.proto.Responses.internal_static_CloseStatementResponse_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.calcite.avatica.proto.Responses.internal_static_CloseStatementResponse_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.calcite.avatica.proto.Responses.CloseStatementResponse.class, org.apache.calcite.avatica.proto.Responses.CloseStatementResponse.Builder.class);
      }

      // Construct using org.apache.calcite.avatica.proto.Responses.CloseStatementResponse.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
        }
      }
      public Builder clear() {
        super.clear();
        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.calcite.avatica.proto.Responses.internal_static_CloseStatementResponse_descriptor;
      }

      public org.apache.calcite.avatica.proto.Responses.CloseStatementResponse getDefaultInstanceForType() {
        return org.apache.calcite.avatica.proto.Responses.CloseStatementResponse.getDefaultInstance();
      }

      public org.apache.calcite.avatica.proto.Responses.CloseStatementResponse build() {
        org.apache.calcite.avatica.proto.Responses.CloseStatementResponse result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public org.apache.calcite.avatica.proto.Responses.CloseStatementResponse buildPartial() {
        org.apache.calcite.avatica.proto.Responses.CloseStatementResponse result = new org.apache.calcite.avatica.proto.Responses.CloseStatementResponse(this);
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.apache.calcite.avatica.proto.Responses.CloseStatementResponse) {
          return mergeFrom((org.apache.calcite.avatica.proto.Responses.CloseStatementResponse)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.calcite.avatica.proto.Responses.CloseStatementResponse other) {
        if (other == org.apache.calcite.avatica.proto.Responses.CloseStatementResponse.getDefaultInstance()) return this;
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        org.apache.calcite.avatica.proto.Responses.CloseStatementResponse parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (org.apache.calcite.avatica.proto.Responses.CloseStatementResponse) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return this;
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return this;
      }


      // @@protoc_insertion_point(builder_scope:CloseStatementResponse)
    }

    // @@protoc_insertion_point(class_scope:CloseStatementResponse)
    private static final org.apache.calcite.avatica.proto.Responses.CloseStatementResponse DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.apache.calcite.avatica.proto.Responses.CloseStatementResponse();
    }

    public static org.apache.calcite.avatica.proto.Responses.CloseStatementResponse getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<CloseStatementResponse>
        PARSER = new com.google.protobuf.AbstractParser<CloseStatementResponse>() {
      public CloseStatementResponse parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        try {
          return new CloseStatementResponse(input, extensionRegistry);
        } catch (RuntimeException e) {
          if (e.getCause() instanceof
              com.google.protobuf.InvalidProtocolBufferException) {
            throw (com.google.protobuf.InvalidProtocolBufferException)
                e.getCause();
          }
          throw e;
        }
      }
    };

    public static com.google.protobuf.Parser<CloseStatementResponse> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<CloseStatementResponse> getParserForType() {
      return PARSER;
    }

    public org.apache.calcite.avatica.proto.Responses.CloseStatementResponse getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface OpenConnectionResponseOrBuilder extends
      // @@protoc_insertion_point(interface_extends:OpenConnectionResponse)
      com.google.protobuf.MessageOrBuilder {
  }
  /**
   * Protobuf type {@code OpenConnectionResponse}
   *
   * <pre>
   * Response to OpenConnectionRequest {
   * </pre>
   */
  public  static final class OpenConnectionResponse extends
      com.google.protobuf.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:OpenConnectionResponse)
      OpenConnectionResponseOrBuilder {
    // Use OpenConnectionResponse.newBuilder() to construct.
    private OpenConnectionResponse(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
    }
    private OpenConnectionResponse() {
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return com.google.protobuf.UnknownFieldSet.getDefaultInstance();
    }
    private OpenConnectionResponse(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry) {
      this();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!input.skipField(tag)) {
                done = true;
              }
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw new RuntimeException(e.setUnfinishedMessage(this));
      } catch (java.io.IOException e) {
        throw new RuntimeException(
            new com.google.protobuf.InvalidProtocolBufferException(
                e.getMessage()).setUnfinishedMessage(this));
      } finally {
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.calcite.avatica.proto.Responses.internal_static_OpenConnectionResponse_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.calcite.avatica.proto.Responses.internal_static_OpenConnectionResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.calcite.avatica.proto.Responses.OpenConnectionResponse.class, org.apache.calcite.avatica.proto.Responses.OpenConnectionResponse.Builder.class);
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      memoizedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    public static org.apache.calcite.avatica.proto.Responses.OpenConnectionResponse parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.calcite.avatica.proto.Responses.OpenConnectionResponse parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.calcite.avatica.proto.Responses.OpenConnectionResponse parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.calcite.avatica.proto.Responses.OpenConnectionResponse parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.calcite.avatica.proto.Responses.OpenConnectionResponse parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.calcite.avatica.proto.Responses.OpenConnectionResponse parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static org.apache.calcite.avatica.proto.Responses.OpenConnectionResponse parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static org.apache.calcite.avatica.proto.Responses.OpenConnectionResponse parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static org.apache.calcite.avatica.proto.Responses.OpenConnectionResponse parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.calcite.avatica.proto.Responses.OpenConnectionResponse parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.apache.calcite.avatica.proto.Responses.OpenConnectionResponse prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code OpenConnectionResponse}
     *
     * <pre>
     * Response to OpenConnectionRequest {
     * </pre>
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:OpenConnectionResponse)
        org.apache.calcite.avatica.proto.Responses.OpenConnectionResponseOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.calcite.avatica.proto.Responses.internal_static_OpenConnectionResponse_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.calcite.avatica.proto.Responses.internal_static_OpenConnectionResponse_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.calcite.avatica.proto.Responses.OpenConnectionResponse.class, org.apache.calcite.avatica.proto.Responses.OpenConnectionResponse.Builder.class);
      }

      // Construct using org.apache.calcite.avatica.proto.Responses.OpenConnectionResponse.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
        }
      }
      public Builder clear() {
        super.clear();
        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.calcite.avatica.proto.Responses.internal_static_OpenConnectionResponse_descriptor;
      }

      public org.apache.calcite.avatica.proto.Responses.OpenConnectionResponse getDefaultInstanceForType() {
        return org.apache.calcite.avatica.proto.Responses.OpenConnectionResponse.getDefaultInstance();
      }

      public org.apache.calcite.avatica.proto.Responses.OpenConnectionResponse build() {
        org.apache.calcite.avatica.proto.Responses.OpenConnectionResponse result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public org.apache.calcite.avatica.proto.Responses.OpenConnectionResponse buildPartial() {
        org.apache.calcite.avatica.proto.Responses.OpenConnectionResponse result = new org.apache.calcite.avatica.proto.Responses.OpenConnectionResponse(this);
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.apache.calcite.avatica.proto.Responses.OpenConnectionResponse) {
          return mergeFrom((org.apache.calcite.avatica.proto.Responses.OpenConnectionResponse)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.calcite.avatica.proto.Responses.OpenConnectionResponse other) {
        if (other == org.apache.calcite.avatica.proto.Responses.OpenConnectionResponse.getDefaultInstance()) return this;
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        org.apache.calcite.avatica.proto.Responses.OpenConnectionResponse parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (org.apache.calcite.avatica.proto.Responses.OpenConnectionResponse) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return this;
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return this;
      }


      // @@protoc_insertion_point(builder_scope:OpenConnectionResponse)
    }

    // @@protoc_insertion_point(class_scope:OpenConnectionResponse)
    private static final org.apache.calcite.avatica.proto.Responses.OpenConnectionResponse DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.apache.calcite.avatica.proto.Responses.OpenConnectionResponse();
    }

    public static org.apache.calcite.avatica.proto.Responses.OpenConnectionResponse getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<OpenConnectionResponse>
        PARSER = new com.google.protobuf.AbstractParser<OpenConnectionResponse>() {
      public OpenConnectionResponse parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        try {
          return new OpenConnectionResponse(input, extensionRegistry);
        } catch (RuntimeException e) {
          if (e.getCause() instanceof
              com.google.protobuf.InvalidProtocolBufferException) {
            throw (com.google.protobuf.InvalidProtocolBufferException)
                e.getCause();
          }
          throw e;
        }
      }
    };

    public static com.google.protobuf.Parser<OpenConnectionResponse> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<OpenConnectionResponse> getParserForType() {
      return PARSER;
    }

    public org.apache.calcite.avatica.proto.Responses.OpenConnectionResponse getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface CloseConnectionResponseOrBuilder extends
      // @@protoc_insertion_point(interface_extends:CloseConnectionResponse)
      com.google.protobuf.MessageOrBuilder {
  }
  /**
   * Protobuf type {@code CloseConnectionResponse}
   *
   * <pre>
   * Response to CloseConnectionRequest {
   * </pre>
   */
  public  static final class CloseConnectionResponse extends
      com.google.protobuf.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:CloseConnectionResponse)
      CloseConnectionResponseOrBuilder {
    // Use CloseConnectionResponse.newBuilder() to construct.
    private CloseConnectionResponse(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
    }
    private CloseConnectionResponse() {
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return com.google.protobuf.UnknownFieldSet.getDefaultInstance();
    }
    private CloseConnectionResponse(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry) {
      this();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!input.skipField(tag)) {
                done = true;
              }
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw new RuntimeException(e.setUnfinishedMessage(this));
      } catch (java.io.IOException e) {
        throw new RuntimeException(
            new com.google.protobuf.InvalidProtocolBufferException(
                e.getMessage()).setUnfinishedMessage(this));
      } finally {
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.calcite.avatica.proto.Responses.internal_static_CloseConnectionResponse_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.calcite.avatica.proto.Responses.internal_static_CloseConnectionResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.calcite.avatica.proto.Responses.CloseConnectionResponse.class, org.apache.calcite.avatica.proto.Responses.CloseConnectionResponse.Builder.class);
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      memoizedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    public static org.apache.calcite.avatica.proto.Responses.CloseConnectionResponse parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.calcite.avatica.proto.Responses.CloseConnectionResponse parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.calcite.avatica.proto.Responses.CloseConnectionResponse parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.calcite.avatica.proto.Responses.CloseConnectionResponse parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.calcite.avatica.proto.Responses.CloseConnectionResponse parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.calcite.avatica.proto.Responses.CloseConnectionResponse parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static org.apache.calcite.avatica.proto.Responses.CloseConnectionResponse parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static org.apache.calcite.avatica.proto.Responses.CloseConnectionResponse parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static org.apache.calcite.avatica.proto.Responses.CloseConnectionResponse parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.calcite.avatica.proto.Responses.CloseConnectionResponse parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.apache.calcite.avatica.proto.Responses.CloseConnectionResponse prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code CloseConnectionResponse}
     *
     * <pre>
     * Response to CloseConnectionRequest {
     * </pre>
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:CloseConnectionResponse)
        org.apache.calcite.avatica.proto.Responses.CloseConnectionResponseOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.calcite.avatica.proto.Responses.internal_static_CloseConnectionResponse_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.calcite.avatica.proto.Responses.internal_static_CloseConnectionResponse_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.calcite.avatica.proto.Responses.CloseConnectionResponse.class, org.apache.calcite.avatica.proto.Responses.CloseConnectionResponse.Builder.class);
      }

      // Construct using org.apache.calcite.avatica.proto.Responses.CloseConnectionResponse.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
        }
      }
      public Builder clear() {
        super.clear();
        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.calcite.avatica.proto.Responses.internal_static_CloseConnectionResponse_descriptor;
      }

      public org.apache.calcite.avatica.proto.Responses.CloseConnectionResponse getDefaultInstanceForType() {
        return org.apache.calcite.avatica.proto.Responses.CloseConnectionResponse.getDefaultInstance();
      }

      public org.apache.calcite.avatica.proto.Responses.CloseConnectionResponse build() {
        org.apache.calcite.avatica.proto.Responses.CloseConnectionResponse result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public org.apache.calcite.avatica.proto.Responses.CloseConnectionResponse buildPartial() {
        org.apache.calcite.avatica.proto.Responses.CloseConnectionResponse result = new org.apache.calcite.avatica.proto.Responses.CloseConnectionResponse(this);
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.apache.calcite.avatica.proto.Responses.CloseConnectionResponse) {
          return mergeFrom((org.apache.calcite.avatica.proto.Responses.CloseConnectionResponse)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.calcite.avatica.proto.Responses.CloseConnectionResponse other) {
        if (other == org.apache.calcite.avatica.proto.Responses.CloseConnectionResponse.getDefaultInstance()) return this;
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        org.apache.calcite.avatica.proto.Responses.CloseConnectionResponse parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (org.apache.calcite.avatica.proto.Responses.CloseConnectionResponse) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return this;
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return this;
      }


      // @@protoc_insertion_point(builder_scope:CloseConnectionResponse)
    }

    // @@protoc_insertion_point(class_scope:CloseConnectionResponse)
    private static final org.apache.calcite.avatica.proto.Responses.CloseConnectionResponse DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.apache.calcite.avatica.proto.Responses.CloseConnectionResponse();
    }

    public static org.apache.calcite.avatica.proto.Responses.CloseConnectionResponse getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<CloseConnectionResponse>
        PARSER = new com.google.protobuf.AbstractParser<CloseConnectionResponse>() {
      public CloseConnectionResponse parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        try {
          return new CloseConnectionResponse(input, extensionRegistry);
        } catch (RuntimeException e) {
          if (e.getCause() instanceof
              com.google.protobuf.InvalidProtocolBufferException) {
            throw (com.google.protobuf.InvalidProtocolBufferException)
                e.getCause();
          }
          throw e;
        }
      }
    };

    public static com.google.protobuf.Parser<CloseConnectionResponse> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<CloseConnectionResponse> getParserForType() {
      return PARSER;
    }

    public org.apache.calcite.avatica.proto.Responses.CloseConnectionResponse getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface ConnectionSyncResponseOrBuilder extends
      // @@protoc_insertion_point(interface_extends:ConnectionSyncResponse)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>optional .ConnectionProperties conn_props = 1;</code>
     */
    boolean hasConnProps();
    /**
     * <code>optional .ConnectionProperties conn_props = 1;</code>
     */
    org.apache.calcite.avatica.proto.Common.ConnectionProperties getConnProps();
    /**
     * <code>optional .ConnectionProperties conn_props = 1;</code>
     */
    org.apache.calcite.avatica.proto.Common.ConnectionPropertiesOrBuilder getConnPropsOrBuilder();
  }
  /**
   * Protobuf type {@code ConnectionSyncResponse}
   *
   * <pre>
   * Response to ConnectionSyncRequest
   * </pre>
   */
  public  static final class ConnectionSyncResponse extends
      com.google.protobuf.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:ConnectionSyncResponse)
      ConnectionSyncResponseOrBuilder {
    // Use ConnectionSyncResponse.newBuilder() to construct.
    private ConnectionSyncResponse(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
    }
    private ConnectionSyncResponse() {
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return com.google.protobuf.UnknownFieldSet.getDefaultInstance();
    }
    private ConnectionSyncResponse(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry) {
      this();
      int mutable_bitField0_ = 0;
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!input.skipField(tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              org.apache.calcite.avatica.proto.Common.ConnectionProperties.Builder subBuilder = null;
              if (connProps_ != null) {
                subBuilder = connProps_.toBuilder();
              }
              connProps_ = input.readMessage(org.apache.calcite.avatica.proto.Common.ConnectionProperties.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(connProps_);
                connProps_ = subBuilder.buildPartial();
              }

              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw new RuntimeException(e.setUnfinishedMessage(this));
      } catch (java.io.IOException e) {
        throw new RuntimeException(
            new com.google.protobuf.InvalidProtocolBufferException(
                e.getMessage()).setUnfinishedMessage(this));
      } finally {
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.calcite.avatica.proto.Responses.internal_static_ConnectionSyncResponse_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.calcite.avatica.proto.Responses.internal_static_ConnectionSyncResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.calcite.avatica.proto.Responses.ConnectionSyncResponse.class, org.apache.calcite.avatica.proto.Responses.ConnectionSyncResponse.Builder.class);
    }

    public static final int CONN_PROPS_FIELD_NUMBER = 1;
    private org.apache.calcite.avatica.proto.Common.ConnectionProperties connProps_;
    /**
     * <code>optional .ConnectionProperties conn_props = 1;</code>
     */
    public boolean hasConnProps() {
      return connProps_ != null;
    }
    /**
     * <code>optional .ConnectionProperties conn_props = 1;</code>
     */
    public org.apache.calcite.avatica.proto.Common.ConnectionProperties getConnProps() {
      return connProps_ == null ? org.apache.calcite.avatica.proto.Common.ConnectionProperties.getDefaultInstance() : connProps_;
    }
    /**
     * <code>optional .ConnectionProperties conn_props = 1;</code>
     */
    public org.apache.calcite.avatica.proto.Common.ConnectionPropertiesOrBuilder getConnPropsOrBuilder() {
      return getConnProps();
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (connProps_ != null) {
        output.writeMessage(1, getConnProps());
      }
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (connProps_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(1, getConnProps());
      }
      memoizedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    public static org.apache.calcite.avatica.proto.Responses.ConnectionSyncResponse parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.calcite.avatica.proto.Responses.ConnectionSyncResponse parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.calcite.avatica.proto.Responses.ConnectionSyncResponse parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.calcite.avatica.proto.Responses.ConnectionSyncResponse parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.calcite.avatica.proto.Responses.ConnectionSyncResponse parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.calcite.avatica.proto.Responses.ConnectionSyncResponse parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static org.apache.calcite.avatica.proto.Responses.ConnectionSyncResponse parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static org.apache.calcite.avatica.proto.Responses.ConnectionSyncResponse parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static org.apache.calcite.avatica.proto.Responses.ConnectionSyncResponse parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.calcite.avatica.proto.Responses.ConnectionSyncResponse parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.apache.calcite.avatica.proto.Responses.ConnectionSyncResponse prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code ConnectionSyncResponse}
     *
     * <pre>
     * Response to ConnectionSyncRequest
     * </pre>
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:ConnectionSyncResponse)
        org.apache.calcite.avatica.proto.Responses.ConnectionSyncResponseOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.calcite.avatica.proto.Responses.internal_static_ConnectionSyncResponse_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.calcite.avatica.proto.Responses.internal_static_ConnectionSyncResponse_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.calcite.avatica.proto.Responses.ConnectionSyncResponse.class, org.apache.calcite.avatica.proto.Responses.ConnectionSyncResponse.Builder.class);
      }

      // Construct using org.apache.calcite.avatica.proto.Responses.ConnectionSyncResponse.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
        }
      }
      public Builder clear() {
        super.clear();
        if (connPropsBuilder_ == null) {
          connProps_ = null;
        } else {
          connProps_ = null;
          connPropsBuilder_ = null;
        }
        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.calcite.avatica.proto.Responses.internal_static_ConnectionSyncResponse_descriptor;
      }

      public org.apache.calcite.avatica.proto.Responses.ConnectionSyncResponse getDefaultInstanceForType() {
        return org.apache.calcite.avatica.proto.Responses.ConnectionSyncResponse.getDefaultInstance();
      }

      public org.apache.calcite.avatica.proto.Responses.ConnectionSyncResponse build() {
        org.apache.calcite.avatica.proto.Responses.ConnectionSyncResponse result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public org.apache.calcite.avatica.proto.Responses.ConnectionSyncResponse buildPartial() {
        org.apache.calcite.avatica.proto.Responses.ConnectionSyncResponse result = new org.apache.calcite.avatica.proto.Responses.ConnectionSyncResponse(this);
        if (connPropsBuilder_ == null) {
          result.connProps_ = connProps_;
        } else {
          result.connProps_ = connPropsBuilder_.build();
        }
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.apache.calcite.avatica.proto.Responses.ConnectionSyncResponse) {
          return mergeFrom((org.apache.calcite.avatica.proto.Responses.ConnectionSyncResponse)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.calcite.avatica.proto.Responses.ConnectionSyncResponse other) {
        if (other == org.apache.calcite.avatica.proto.Responses.ConnectionSyncResponse.getDefaultInstance()) return this;
        if (other.hasConnProps()) {
          mergeConnProps(other.getConnProps());
        }
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        org.apache.calcite.avatica.proto.Responses.ConnectionSyncResponse parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (org.apache.calcite.avatica.proto.Responses.ConnectionSyncResponse) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private org.apache.calcite.avatica.proto.Common.ConnectionProperties connProps_ = null;
      private com.google.protobuf.SingleFieldBuilder<
          org.apache.calcite.avatica.proto.Common.ConnectionProperties, org.apache.calcite.avatica.proto.Common.ConnectionProperties.Builder, org.apache.calcite.avatica.proto.Common.ConnectionPropertiesOrBuilder> connPropsBuilder_;
      /**
       * <code>optional .ConnectionProperties conn_props = 1;</code>
       */
      public boolean hasConnProps() {
        return connPropsBuilder_ != null || connProps_ != null;
      }
      /**
       * <code>optional .ConnectionProperties conn_props = 1;</code>
       */
      public org.apache.calcite.avatica.proto.Common.ConnectionProperties getConnProps() {
        if (connPropsBuilder_ == null) {
          return connProps_ == null ? org.apache.calcite.avatica.proto.Common.ConnectionProperties.getDefaultInstance() : connProps_;
        } else {
          return connPropsBuilder_.getMessage();
        }
      }
      /**
       * <code>optional .ConnectionProperties conn_props = 1;</code>
       */
      public Builder setConnProps(org.apache.calcite.avatica.proto.Common.ConnectionProperties value) {
        if (connPropsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          connProps_ = value;
          onChanged();
        } else {
          connPropsBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <code>optional .ConnectionProperties conn_props = 1;</code>
       */
      public Builder setConnProps(
          org.apache.calcite.avatica.proto.Common.ConnectionProperties.Builder builderForValue) {
        if (connPropsBuilder_ == null) {
          connProps_ = builderForValue.build();
          onChanged();
        } else {
          connPropsBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <code>optional .ConnectionProperties conn_props = 1;</code>
       */
      public Builder mergeConnProps(org.apache.calcite.avatica.proto.Common.ConnectionProperties value) {
        if (connPropsBuilder_ == null) {
          if (connProps_ != null) {
            connProps_ =
              org.apache.calcite.avatica.proto.Common.ConnectionProperties.newBuilder(connProps_).mergeFrom(value).buildPartial();
          } else {
            connProps_ = value;
          }
          onChanged();
        } else {
          connPropsBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <code>optional .ConnectionProperties conn_props = 1;</code>
       */
      public Builder clearConnProps() {
        if (connPropsBuilder_ == null) {
          connProps_ = null;
          onChanged();
        } else {
          connProps_ = null;
          connPropsBuilder_ = null;
        }

        return this;
      }
      /**
       * <code>optional .ConnectionProperties conn_props = 1;</code>
       */
      public org.apache.calcite.avatica.proto.Common.ConnectionProperties.Builder getConnPropsBuilder() {
        
        onChanged();
        return getConnPropsFieldBuilder().getBuilder();
      }
      /**
       * <code>optional .ConnectionProperties conn_props = 1;</code>
       */
      public org.apache.calcite.avatica.proto.Common.ConnectionPropertiesOrBuilder getConnPropsOrBuilder() {
        if (connPropsBuilder_ != null) {
          return connPropsBuilder_.getMessageOrBuilder();
        } else {
          return connProps_ == null ?
              org.apache.calcite.avatica.proto.Common.ConnectionProperties.getDefaultInstance() : connProps_;
        }
      }
      /**
       * <code>optional .ConnectionProperties conn_props = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilder<
          org.apache.calcite.avatica.proto.Common.ConnectionProperties, org.apache.calcite.avatica.proto.Common.ConnectionProperties.Builder, org.apache.calcite.avatica.proto.Common.ConnectionPropertiesOrBuilder> 
          getConnPropsFieldBuilder() {
        if (connPropsBuilder_ == null) {
          connPropsBuilder_ = new com.google.protobuf.SingleFieldBuilder<
              org.apache.calcite.avatica.proto.Common.ConnectionProperties, org.apache.calcite.avatica.proto.Common.ConnectionProperties.Builder, org.apache.calcite.avatica.proto.Common.ConnectionPropertiesOrBuilder>(
                  getConnProps(),
                  getParentForChildren(),
                  isClean());
          connProps_ = null;
        }
        return connPropsBuilder_;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return this;
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return this;
      }


      // @@protoc_insertion_point(builder_scope:ConnectionSyncResponse)
    }

    // @@protoc_insertion_point(class_scope:ConnectionSyncResponse)
    private static final org.apache.calcite.avatica.proto.Responses.ConnectionSyncResponse DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.apache.calcite.avatica.proto.Responses.ConnectionSyncResponse();
    }

    public static org.apache.calcite.avatica.proto.Responses.ConnectionSyncResponse getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ConnectionSyncResponse>
        PARSER = new com.google.protobuf.AbstractParser<ConnectionSyncResponse>() {
      public ConnectionSyncResponse parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        try {
          return new ConnectionSyncResponse(input, extensionRegistry);
        } catch (RuntimeException e) {
          if (e.getCause() instanceof
              com.google.protobuf.InvalidProtocolBufferException) {
            throw (com.google.protobuf.InvalidProtocolBufferException)
                e.getCause();
          }
          throw e;
        }
      }
    };

    public static com.google.protobuf.Parser<ConnectionSyncResponse> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ConnectionSyncResponse> getParserForType() {
      return PARSER;
    }

    public org.apache.calcite.avatica.proto.Responses.ConnectionSyncResponse getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface DatabasePropertyElementOrBuilder extends
      // @@protoc_insertion_point(interface_extends:DatabasePropertyElement)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>optional .DatabaseProperty key = 1;</code>
     */
    boolean hasKey();
    /**
     * <code>optional .DatabaseProperty key = 1;</code>
     */
    org.apache.calcite.avatica.proto.Common.DatabaseProperty getKey();
    /**
     * <code>optional .DatabaseProperty key = 1;</code>
     */
    org.apache.calcite.avatica.proto.Common.DatabasePropertyOrBuilder getKeyOrBuilder();

    /**
     * <code>optional .TypedValue value = 2;</code>
     */
    boolean hasValue();
    /**
     * <code>optional .TypedValue value = 2;</code>
     */
    org.apache.calcite.avatica.proto.Common.TypedValue getValue();
    /**
     * <code>optional .TypedValue value = 2;</code>
     */
    org.apache.calcite.avatica.proto.Common.TypedValueOrBuilder getValueOrBuilder();
  }
  /**
   * Protobuf type {@code DatabasePropertyElement}
   */
  public  static final class DatabasePropertyElement extends
      com.google.protobuf.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:DatabasePropertyElement)
      DatabasePropertyElementOrBuilder {
    // Use DatabasePropertyElement.newBuilder() to construct.
    private DatabasePropertyElement(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
    }
    private DatabasePropertyElement() {
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return com.google.protobuf.UnknownFieldSet.getDefaultInstance();
    }
    private DatabasePropertyElement(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry) {
      this();
      int mutable_bitField0_ = 0;
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!input.skipField(tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              org.apache.calcite.avatica.proto.Common.DatabaseProperty.Builder subBuilder = null;
              if (key_ != null) {
                subBuilder = key_.toBuilder();
              }
              key_ = input.readMessage(org.apache.calcite.avatica.proto.Common.DatabaseProperty.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(key_);
                key_ = subBuilder.buildPartial();
              }

              break;
            }
            case 18: {
              org.apache.calcite.avatica.proto.Common.TypedValue.Builder subBuilder = null;
              if (value_ != null) {
                subBuilder = value_.toBuilder();
              }
              value_ = input.readMessage(org.apache.calcite.avatica.proto.Common.TypedValue.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(value_);
                value_ = subBuilder.buildPartial();
              }

              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw new RuntimeException(e.setUnfinishedMessage(this));
      } catch (java.io.IOException e) {
        throw new RuntimeException(
            new com.google.protobuf.InvalidProtocolBufferException(
                e.getMessage()).setUnfinishedMessage(this));
      } finally {
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.calcite.avatica.proto.Responses.internal_static_DatabasePropertyElement_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.calcite.avatica.proto.Responses.internal_static_DatabasePropertyElement_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.calcite.avatica.proto.Responses.DatabasePropertyElement.class, org.apache.calcite.avatica.proto.Responses.DatabasePropertyElement.Builder.class);
    }

    public static final int KEY_FIELD_NUMBER = 1;
    private org.apache.calcite.avatica.proto.Common.DatabaseProperty key_;
    /**
     * <code>optional .DatabaseProperty key = 1;</code>
     */
    public boolean hasKey() {
      return key_ != null;
    }
    /**
     * <code>optional .DatabaseProperty key = 1;</code>
     */
    public org.apache.calcite.avatica.proto.Common.DatabaseProperty getKey() {
      return key_ == null ? org.apache.calcite.avatica.proto.Common.DatabaseProperty.getDefaultInstance() : key_;
    }
    /**
     * <code>optional .DatabaseProperty key = 1;</code>
     */
    public org.apache.calcite.avatica.proto.Common.DatabasePropertyOrBuilder getKeyOrBuilder() {
      return getKey();
    }

    public static final int VALUE_FIELD_NUMBER = 2;
    private org.apache.calcite.avatica.proto.Common.TypedValue value_;
    /**
     * <code>optional .TypedValue value = 2;</code>
     */
    public boolean hasValue() {
      return value_ != null;
    }
    /**
     * <code>optional .TypedValue value = 2;</code>
     */
    public org.apache.calcite.avatica.proto.Common.TypedValue getValue() {
      return value_ == null ? org.apache.calcite.avatica.proto.Common.TypedValue.getDefaultInstance() : value_;
    }
    /**
     * <code>optional .TypedValue value = 2;</code>
     */
    public org.apache.calcite.avatica.proto.Common.TypedValueOrBuilder getValueOrBuilder() {
      return getValue();
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (key_ != null) {
        output.writeMessage(1, getKey());
      }
      if (value_ != null) {
        output.writeMessage(2, getValue());
      }
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (key_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(1, getKey());
      }
      if (value_ != null) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(2, getValue());
      }
      memoizedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    public static org.apache.calcite.avatica.proto.Responses.DatabasePropertyElement parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.calcite.avatica.proto.Responses.DatabasePropertyElement parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.calcite.avatica.proto.Responses.DatabasePropertyElement parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.calcite.avatica.proto.Responses.DatabasePropertyElement parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.calcite.avatica.proto.Responses.DatabasePropertyElement parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.calcite.avatica.proto.Responses.DatabasePropertyElement parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static org.apache.calcite.avatica.proto.Responses.DatabasePropertyElement parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static org.apache.calcite.avatica.proto.Responses.DatabasePropertyElement parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static org.apache.calcite.avatica.proto.Responses.DatabasePropertyElement parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.calcite.avatica.proto.Responses.DatabasePropertyElement parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.apache.calcite.avatica.proto.Responses.DatabasePropertyElement prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code DatabasePropertyElement}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:DatabasePropertyElement)
        org.apache.calcite.avatica.proto.Responses.DatabasePropertyElementOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.calcite.avatica.proto.Responses.internal_static_DatabasePropertyElement_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.calcite.avatica.proto.Responses.internal_static_DatabasePropertyElement_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.calcite.avatica.proto.Responses.DatabasePropertyElement.class, org.apache.calcite.avatica.proto.Responses.DatabasePropertyElement.Builder.class);
      }

      // Construct using org.apache.calcite.avatica.proto.Responses.DatabasePropertyElement.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
        }
      }
      public Builder clear() {
        super.clear();
        if (keyBuilder_ == null) {
          key_ = null;
        } else {
          key_ = null;
          keyBuilder_ = null;
        }
        if (valueBuilder_ == null) {
          value_ = null;
        } else {
          value_ = null;
          valueBuilder_ = null;
        }
        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.calcite.avatica.proto.Responses.internal_static_DatabasePropertyElement_descriptor;
      }

      public org.apache.calcite.avatica.proto.Responses.DatabasePropertyElement getDefaultInstanceForType() {
        return org.apache.calcite.avatica.proto.Responses.DatabasePropertyElement.getDefaultInstance();
      }

      public org.apache.calcite.avatica.proto.Responses.DatabasePropertyElement build() {
        org.apache.calcite.avatica.proto.Responses.DatabasePropertyElement result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public org.apache.calcite.avatica.proto.Responses.DatabasePropertyElement buildPartial() {
        org.apache.calcite.avatica.proto.Responses.DatabasePropertyElement result = new org.apache.calcite.avatica.proto.Responses.DatabasePropertyElement(this);
        if (keyBuilder_ == null) {
          result.key_ = key_;
        } else {
          result.key_ = keyBuilder_.build();
        }
        if (valueBuilder_ == null) {
          result.value_ = value_;
        } else {
          result.value_ = valueBuilder_.build();
        }
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.apache.calcite.avatica.proto.Responses.DatabasePropertyElement) {
          return mergeFrom((org.apache.calcite.avatica.proto.Responses.DatabasePropertyElement)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.calcite.avatica.proto.Responses.DatabasePropertyElement other) {
        if (other == org.apache.calcite.avatica.proto.Responses.DatabasePropertyElement.getDefaultInstance()) return this;
        if (other.hasKey()) {
          mergeKey(other.getKey());
        }
        if (other.hasValue()) {
          mergeValue(other.getValue());
        }
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        org.apache.calcite.avatica.proto.Responses.DatabasePropertyElement parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (org.apache.calcite.avatica.proto.Responses.DatabasePropertyElement) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private org.apache.calcite.avatica.proto.Common.DatabaseProperty key_ = null;
      private com.google.protobuf.SingleFieldBuilder<
          org.apache.calcite.avatica.proto.Common.DatabaseProperty, org.apache.calcite.avatica.proto.Common.DatabaseProperty.Builder, org.apache.calcite.avatica.proto.Common.DatabasePropertyOrBuilder> keyBuilder_;
      /**
       * <code>optional .DatabaseProperty key = 1;</code>
       */
      public boolean hasKey() {
        return keyBuilder_ != null || key_ != null;
      }
      /**
       * <code>optional .DatabaseProperty key = 1;</code>
       */
      public org.apache.calcite.avatica.proto.Common.DatabaseProperty getKey() {
        if (keyBuilder_ == null) {
          return key_ == null ? org.apache.calcite.avatica.proto.Common.DatabaseProperty.getDefaultInstance() : key_;
        } else {
          return keyBuilder_.getMessage();
        }
      }
      /**
       * <code>optional .DatabaseProperty key = 1;</code>
       */
      public Builder setKey(org.apache.calcite.avatica.proto.Common.DatabaseProperty value) {
        if (keyBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          key_ = value;
          onChanged();
        } else {
          keyBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <code>optional .DatabaseProperty key = 1;</code>
       */
      public Builder setKey(
          org.apache.calcite.avatica.proto.Common.DatabaseProperty.Builder builderForValue) {
        if (keyBuilder_ == null) {
          key_ = builderForValue.build();
          onChanged();
        } else {
          keyBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <code>optional .DatabaseProperty key = 1;</code>
       */
      public Builder mergeKey(org.apache.calcite.avatica.proto.Common.DatabaseProperty value) {
        if (keyBuilder_ == null) {
          if (key_ != null) {
            key_ =
              org.apache.calcite.avatica.proto.Common.DatabaseProperty.newBuilder(key_).mergeFrom(value).buildPartial();
          } else {
            key_ = value;
          }
          onChanged();
        } else {
          keyBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <code>optional .DatabaseProperty key = 1;</code>
       */
      public Builder clearKey() {
        if (keyBuilder_ == null) {
          key_ = null;
          onChanged();
        } else {
          key_ = null;
          keyBuilder_ = null;
        }

        return this;
      }
      /**
       * <code>optional .DatabaseProperty key = 1;</code>
       */
      public org.apache.calcite.avatica.proto.Common.DatabaseProperty.Builder getKeyBuilder() {
        
        onChanged();
        return getKeyFieldBuilder().getBuilder();
      }
      /**
       * <code>optional .DatabaseProperty key = 1;</code>
       */
      public org.apache.calcite.avatica.proto.Common.DatabasePropertyOrBuilder getKeyOrBuilder() {
        if (keyBuilder_ != null) {
          return keyBuilder_.getMessageOrBuilder();
        } else {
          return key_ == null ?
              org.apache.calcite.avatica.proto.Common.DatabaseProperty.getDefaultInstance() : key_;
        }
      }
      /**
       * <code>optional .DatabaseProperty key = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilder<
          org.apache.calcite.avatica.proto.Common.DatabaseProperty, org.apache.calcite.avatica.proto.Common.DatabaseProperty.Builder, org.apache.calcite.avatica.proto.Common.DatabasePropertyOrBuilder> 
          getKeyFieldBuilder() {
        if (keyBuilder_ == null) {
          keyBuilder_ = new com.google.protobuf.SingleFieldBuilder<
              org.apache.calcite.avatica.proto.Common.DatabaseProperty, org.apache.calcite.avatica.proto.Common.DatabaseProperty.Builder, org.apache.calcite.avatica.proto.Common.DatabasePropertyOrBuilder>(
                  getKey(),
                  getParentForChildren(),
                  isClean());
          key_ = null;
        }
        return keyBuilder_;
      }

      private org.apache.calcite.avatica.proto.Common.TypedValue value_ = null;
      private com.google.protobuf.SingleFieldBuilder<
          org.apache.calcite.avatica.proto.Common.TypedValue, org.apache.calcite.avatica.proto.Common.TypedValue.Builder, org.apache.calcite.avatica.proto.Common.TypedValueOrBuilder> valueBuilder_;
      /**
       * <code>optional .TypedValue value = 2;</code>
       */
      public boolean hasValue() {
        return valueBuilder_ != null || value_ != null;
      }
      /**
       * <code>optional .TypedValue value = 2;</code>
       */
      public org.apache.calcite.avatica.proto.Common.TypedValue getValue() {
        if (valueBuilder_ == null) {
          return value_ == null ? org.apache.calcite.avatica.proto.Common.TypedValue.getDefaultInstance() : value_;
        } else {
          return valueBuilder_.getMessage();
        }
      }
      /**
       * <code>optional .TypedValue value = 2;</code>
       */
      public Builder setValue(org.apache.calcite.avatica.proto.Common.TypedValue value) {
        if (valueBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          value_ = value;
          onChanged();
        } else {
          valueBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       * <code>optional .TypedValue value = 2;</code>
       */
      public Builder setValue(
          org.apache.calcite.avatica.proto.Common.TypedValue.Builder builderForValue) {
        if (valueBuilder_ == null) {
          value_ = builderForValue.build();
          onChanged();
        } else {
          valueBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       * <code>optional .TypedValue value = 2;</code>
       */
      public Builder mergeValue(org.apache.calcite.avatica.proto.Common.TypedValue value) {
        if (valueBuilder_ == null) {
          if (value_ != null) {
            value_ =
              org.apache.calcite.avatica.proto.Common.TypedValue.newBuilder(value_).mergeFrom(value).buildPartial();
          } else {
            value_ = value;
          }
          onChanged();
        } else {
          valueBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       * <code>optional .TypedValue value = 2;</code>
       */
      public Builder clearValue() {
        if (valueBuilder_ == null) {
          value_ = null;
          onChanged();
        } else {
          value_ = null;
          valueBuilder_ = null;
        }

        return this;
      }
      /**
       * <code>optional .TypedValue value = 2;</code>
       */
      public org.apache.calcite.avatica.proto.Common.TypedValue.Builder getValueBuilder() {
        
        onChanged();
        return getValueFieldBuilder().getBuilder();
      }
      /**
       * <code>optional .TypedValue value = 2;</code>
       */
      public org.apache.calcite.avatica.proto.Common.TypedValueOrBuilder getValueOrBuilder() {
        if (valueBuilder_ != null) {
          return valueBuilder_.getMessageOrBuilder();
        } else {
          return value_ == null ?
              org.apache.calcite.avatica.proto.Common.TypedValue.getDefaultInstance() : value_;
        }
      }
      /**
       * <code>optional .TypedValue value = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilder<
          org.apache.calcite.avatica.proto.Common.TypedValue, org.apache.calcite.avatica.proto.Common.TypedValue.Builder, org.apache.calcite.avatica.proto.Common.TypedValueOrBuilder> 
          getValueFieldBuilder() {
        if (valueBuilder_ == null) {
          valueBuilder_ = new com.google.protobuf.SingleFieldBuilder<
              org.apache.calcite.avatica.proto.Common.TypedValue, org.apache.calcite.avatica.proto.Common.TypedValue.Builder, org.apache.calcite.avatica.proto.Common.TypedValueOrBuilder>(
                  getValue(),
                  getParentForChildren(),
                  isClean());
          value_ = null;
        }
        return valueBuilder_;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return this;
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return this;
      }


      // @@protoc_insertion_point(builder_scope:DatabasePropertyElement)
    }

    // @@protoc_insertion_point(class_scope:DatabasePropertyElement)
    private static final org.apache.calcite.avatica.proto.Responses.DatabasePropertyElement DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.apache.calcite.avatica.proto.Responses.DatabasePropertyElement();
    }

    public static org.apache.calcite.avatica.proto.Responses.DatabasePropertyElement getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<DatabasePropertyElement>
        PARSER = new com.google.protobuf.AbstractParser<DatabasePropertyElement>() {
      public DatabasePropertyElement parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        try {
          return new DatabasePropertyElement(input, extensionRegistry);
        } catch (RuntimeException e) {
          if (e.getCause() instanceof
              com.google.protobuf.InvalidProtocolBufferException) {
            throw (com.google.protobuf.InvalidProtocolBufferException)
                e.getCause();
          }
          throw e;
        }
      }
    };

    public static com.google.protobuf.Parser<DatabasePropertyElement> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<DatabasePropertyElement> getParserForType() {
      return PARSER;
    }

    public org.apache.calcite.avatica.proto.Responses.DatabasePropertyElement getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface DatabasePropertyResponseOrBuilder extends
      // @@protoc_insertion_point(interface_extends:DatabasePropertyResponse)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>repeated .DatabasePropertyElement props = 1;</code>
     */
    java.util.List<org.apache.calcite.avatica.proto.Responses.DatabasePropertyElement> 
        getPropsList();
    /**
     * <code>repeated .DatabasePropertyElement props = 1;</code>
     */
    org.apache.calcite.avatica.proto.Responses.DatabasePropertyElement getProps(int index);
    /**
     * <code>repeated .DatabasePropertyElement props = 1;</code>
     */
    int getPropsCount();
    /**
     * <code>repeated .DatabasePropertyElement props = 1;</code>
     */
    java.util.List<? extends org.apache.calcite.avatica.proto.Responses.DatabasePropertyElementOrBuilder> 
        getPropsOrBuilderList();
    /**
     * <code>repeated .DatabasePropertyElement props = 1;</code>
     */
    org.apache.calcite.avatica.proto.Responses.DatabasePropertyElementOrBuilder getPropsOrBuilder(
        int index);
  }
  /**
   * Protobuf type {@code DatabasePropertyResponse}
   *
   * <pre>
   * Response for Meta#getDatabaseProperties()
   * </pre>
   */
  public  static final class DatabasePropertyResponse extends
      com.google.protobuf.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:DatabasePropertyResponse)
      DatabasePropertyResponseOrBuilder {
    // Use DatabasePropertyResponse.newBuilder() to construct.
    private DatabasePropertyResponse(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
    }
    private DatabasePropertyResponse() {
      props_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return com.google.protobuf.UnknownFieldSet.getDefaultInstance();
    }
    private DatabasePropertyResponse(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry) {
      this();
      int mutable_bitField0_ = 0;
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!input.skipField(tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              if (!((mutable_bitField0_ & 0x00000001) == 0x00000001)) {
                props_ = new java.util.ArrayList<org.apache.calcite.avatica.proto.Responses.DatabasePropertyElement>();
                mutable_bitField0_ |= 0x00000001;
              }
              props_.add(input.readMessage(org.apache.calcite.avatica.proto.Responses.DatabasePropertyElement.parser(), extensionRegistry));
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw new RuntimeException(e.setUnfinishedMessage(this));
      } catch (java.io.IOException e) {
        throw new RuntimeException(
            new com.google.protobuf.InvalidProtocolBufferException(
                e.getMessage()).setUnfinishedMessage(this));
      } finally {
        if (((mutable_bitField0_ & 0x00000001) == 0x00000001)) {
          props_ = java.util.Collections.unmodifiableList(props_);
        }
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.calcite.avatica.proto.Responses.internal_static_DatabasePropertyResponse_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.calcite.avatica.proto.Responses.internal_static_DatabasePropertyResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.calcite.avatica.proto.Responses.DatabasePropertyResponse.class, org.apache.calcite.avatica.proto.Responses.DatabasePropertyResponse.Builder.class);
    }

    public static final int PROPS_FIELD_NUMBER = 1;
    private java.util.List<org.apache.calcite.avatica.proto.Responses.DatabasePropertyElement> props_;
    /**
     * <code>repeated .DatabasePropertyElement props = 1;</code>
     */
    public java.util.List<org.apache.calcite.avatica.proto.Responses.DatabasePropertyElement> getPropsList() {
      return props_;
    }
    /**
     * <code>repeated .DatabasePropertyElement props = 1;</code>
     */
    public java.util.List<? extends org.apache.calcite.avatica.proto.Responses.DatabasePropertyElementOrBuilder> 
        getPropsOrBuilderList() {
      return props_;
    }
    /**
     * <code>repeated .DatabasePropertyElement props = 1;</code>
     */
    public int getPropsCount() {
      return props_.size();
    }
    /**
     * <code>repeated .DatabasePropertyElement props = 1;</code>
     */
    public org.apache.calcite.avatica.proto.Responses.DatabasePropertyElement getProps(int index) {
      return props_.get(index);
    }
    /**
     * <code>repeated .DatabasePropertyElement props = 1;</code>
     */
    public org.apache.calcite.avatica.proto.Responses.DatabasePropertyElementOrBuilder getPropsOrBuilder(
        int index) {
      return props_.get(index);
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      for (int i = 0; i < props_.size(); i++) {
        output.writeMessage(1, props_.get(i));
      }
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < props_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(1, props_.get(i));
      }
      memoizedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    public static org.apache.calcite.avatica.proto.Responses.DatabasePropertyResponse parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.calcite.avatica.proto.Responses.DatabasePropertyResponse parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.calcite.avatica.proto.Responses.DatabasePropertyResponse parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.calcite.avatica.proto.Responses.DatabasePropertyResponse parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.calcite.avatica.proto.Responses.DatabasePropertyResponse parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.calcite.avatica.proto.Responses.DatabasePropertyResponse parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static org.apache.calcite.avatica.proto.Responses.DatabasePropertyResponse parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static org.apache.calcite.avatica.proto.Responses.DatabasePropertyResponse parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static org.apache.calcite.avatica.proto.Responses.DatabasePropertyResponse parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.calcite.avatica.proto.Responses.DatabasePropertyResponse parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.apache.calcite.avatica.proto.Responses.DatabasePropertyResponse prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code DatabasePropertyResponse}
     *
     * <pre>
     * Response for Meta#getDatabaseProperties()
     * </pre>
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:DatabasePropertyResponse)
        org.apache.calcite.avatica.proto.Responses.DatabasePropertyResponseOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.calcite.avatica.proto.Responses.internal_static_DatabasePropertyResponse_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.calcite.avatica.proto.Responses.internal_static_DatabasePropertyResponse_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.calcite.avatica.proto.Responses.DatabasePropertyResponse.class, org.apache.calcite.avatica.proto.Responses.DatabasePropertyResponse.Builder.class);
      }

      // Construct using org.apache.calcite.avatica.proto.Responses.DatabasePropertyResponse.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
          getPropsFieldBuilder();
        }
      }
      public Builder clear() {
        super.clear();
        if (propsBuilder_ == null) {
          props_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
        } else {
          propsBuilder_.clear();
        }
        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.calcite.avatica.proto.Responses.internal_static_DatabasePropertyResponse_descriptor;
      }

      public org.apache.calcite.avatica.proto.Responses.DatabasePropertyResponse getDefaultInstanceForType() {
        return org.apache.calcite.avatica.proto.Responses.DatabasePropertyResponse.getDefaultInstance();
      }

      public org.apache.calcite.avatica.proto.Responses.DatabasePropertyResponse build() {
        org.apache.calcite.avatica.proto.Responses.DatabasePropertyResponse result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public org.apache.calcite.avatica.proto.Responses.DatabasePropertyResponse buildPartial() {
        org.apache.calcite.avatica.proto.Responses.DatabasePropertyResponse result = new org.apache.calcite.avatica.proto.Responses.DatabasePropertyResponse(this);
        int from_bitField0_ = bitField0_;
        if (propsBuilder_ == null) {
          if (((bitField0_ & 0x00000001) == 0x00000001)) {
            props_ = java.util.Collections.unmodifiableList(props_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.props_ = props_;
        } else {
          result.props_ = propsBuilder_.build();
        }
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.apache.calcite.avatica.proto.Responses.DatabasePropertyResponse) {
          return mergeFrom((org.apache.calcite.avatica.proto.Responses.DatabasePropertyResponse)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.calcite.avatica.proto.Responses.DatabasePropertyResponse other) {
        if (other == org.apache.calcite.avatica.proto.Responses.DatabasePropertyResponse.getDefaultInstance()) return this;
        if (propsBuilder_ == null) {
          if (!other.props_.isEmpty()) {
            if (props_.isEmpty()) {
              props_ = other.props_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensurePropsIsMutable();
              props_.addAll(other.props_);
            }
            onChanged();
          }
        } else {
          if (!other.props_.isEmpty()) {
            if (propsBuilder_.isEmpty()) {
              propsBuilder_.dispose();
              propsBuilder_ = null;
              props_ = other.props_;
              bitField0_ = (bitField0_ & ~0x00000001);
              propsBuilder_ = 
                com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders ?
                   getPropsFieldBuilder() : null;
            } else {
              propsBuilder_.addAllMessages(other.props_);
            }
          }
        }
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        org.apache.calcite.avatica.proto.Responses.DatabasePropertyResponse parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (org.apache.calcite.avatica.proto.Responses.DatabasePropertyResponse) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private java.util.List<org.apache.calcite.avatica.proto.Responses.DatabasePropertyElement> props_ =
        java.util.Collections.emptyList();
      private void ensurePropsIsMutable() {
        if (!((bitField0_ & 0x00000001) == 0x00000001)) {
          props_ = new java.util.ArrayList<org.apache.calcite.avatica.proto.Responses.DatabasePropertyElement>(props_);
          bitField0_ |= 0x00000001;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilder<
          org.apache.calcite.avatica.proto.Responses.DatabasePropertyElement, org.apache.calcite.avatica.proto.Responses.DatabasePropertyElement.Builder, org.apache.calcite.avatica.proto.Responses.DatabasePropertyElementOrBuilder> propsBuilder_;

      /**
       * <code>repeated .DatabasePropertyElement props = 1;</code>
       */
      public java.util.List<org.apache.calcite.avatica.proto.Responses.DatabasePropertyElement> getPropsList() {
        if (propsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(props_);
        } else {
          return propsBuilder_.getMessageList();
        }
      }
      /**
       * <code>repeated .DatabasePropertyElement props = 1;</code>
       */
      public int getPropsCount() {
        if (propsBuilder_ == null) {
          return props_.size();
        } else {
          return propsBuilder_.getCount();
        }
      }
      /**
       * <code>repeated .DatabasePropertyElement props = 1;</code>
       */
      public org.apache.calcite.avatica.proto.Responses.DatabasePropertyElement getProps(int index) {
        if (propsBuilder_ == null) {
          return props_.get(index);
        } else {
          return propsBuilder_.getMessage(index);
        }
      }
      /**
       * <code>repeated .DatabasePropertyElement props = 1;</code>
       */
      public Builder setProps(
          int index, org.apache.calcite.avatica.proto.Responses.DatabasePropertyElement value) {
        if (propsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensurePropsIsMutable();
          props_.set(index, value);
          onChanged();
        } else {
          propsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .DatabasePropertyElement props = 1;</code>
       */
      public Builder setProps(
          int index, org.apache.calcite.avatica.proto.Responses.DatabasePropertyElement.Builder builderForValue) {
        if (propsBuilder_ == null) {
          ensurePropsIsMutable();
          props_.set(index, builderForValue.build());
          onChanged();
        } else {
          propsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .DatabasePropertyElement props = 1;</code>
       */
      public Builder addProps(org.apache.calcite.avatica.proto.Responses.DatabasePropertyElement value) {
        if (propsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensurePropsIsMutable();
          props_.add(value);
          onChanged();
        } else {
          propsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <code>repeated .DatabasePropertyElement props = 1;</code>
       */
      public Builder addProps(
          int index, org.apache.calcite.avatica.proto.Responses.DatabasePropertyElement value) {
        if (propsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensurePropsIsMutable();
          props_.add(index, value);
          onChanged();
        } else {
          propsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .DatabasePropertyElement props = 1;</code>
       */
      public Builder addProps(
          org.apache.calcite.avatica.proto.Responses.DatabasePropertyElement.Builder builderForValue) {
        if (propsBuilder_ == null) {
          ensurePropsIsMutable();
          props_.add(builderForValue.build());
          onChanged();
        } else {
          propsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .DatabasePropertyElement props = 1;</code>
       */
      public Builder addProps(
          int index, org.apache.calcite.avatica.proto.Responses.DatabasePropertyElement.Builder builderForValue) {
        if (propsBuilder_ == null) {
          ensurePropsIsMutable();
          props_.add(index, builderForValue.build());
          onChanged();
        } else {
          propsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .DatabasePropertyElement props = 1;</code>
       */
      public Builder addAllProps(
          java.lang.Iterable<? extends org.apache.calcite.avatica.proto.Responses.DatabasePropertyElement> values) {
        if (propsBuilder_ == null) {
          ensurePropsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, props_);
          onChanged();
        } else {
          propsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <code>repeated .DatabasePropertyElement props = 1;</code>
       */
      public Builder clearProps() {
        if (propsBuilder_ == null) {
          props_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          propsBuilder_.clear();
        }
        return this;
      }
      /**
       * <code>repeated .DatabasePropertyElement props = 1;</code>
       */
      public Builder removeProps(int index) {
        if (propsBuilder_ == null) {
          ensurePropsIsMutable();
          props_.remove(index);
          onChanged();
        } else {
          propsBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <code>repeated .DatabasePropertyElement props = 1;</code>
       */
      public org.apache.calcite.avatica.proto.Responses.DatabasePropertyElement.Builder getPropsBuilder(
          int index) {
        return getPropsFieldBuilder().getBuilder(index);
      }
      /**
       * <code>repeated .DatabasePropertyElement props = 1;</code>
       */
      public org.apache.calcite.avatica.proto.Responses.DatabasePropertyElementOrBuilder getPropsOrBuilder(
          int index) {
        if (propsBuilder_ == null) {
          return props_.get(index);  } else {
          return propsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <code>repeated .DatabasePropertyElement props = 1;</code>
       */
      public java.util.List<? extends org.apache.calcite.avatica.proto.Responses.DatabasePropertyElementOrBuilder> 
           getPropsOrBuilderList() {
        if (propsBuilder_ != null) {
          return propsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(props_);
        }
      }
      /**
       * <code>repeated .DatabasePropertyElement props = 1;</code>
       */
      public org.apache.calcite.avatica.proto.Responses.DatabasePropertyElement.Builder addPropsBuilder() {
        return getPropsFieldBuilder().addBuilder(
            org.apache.calcite.avatica.proto.Responses.DatabasePropertyElement.getDefaultInstance());
      }
      /**
       * <code>repeated .DatabasePropertyElement props = 1;</code>
       */
      public org.apache.calcite.avatica.proto.Responses.DatabasePropertyElement.Builder addPropsBuilder(
          int index) {
        return getPropsFieldBuilder().addBuilder(
            index, org.apache.calcite.avatica.proto.Responses.DatabasePropertyElement.getDefaultInstance());
      }
      /**
       * <code>repeated .DatabasePropertyElement props = 1;</code>
       */
      public java.util.List<org.apache.calcite.avatica.proto.Responses.DatabasePropertyElement.Builder> 
           getPropsBuilderList() {
        return getPropsFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilder<
          org.apache.calcite.avatica.proto.Responses.DatabasePropertyElement, org.apache.calcite.avatica.proto.Responses.DatabasePropertyElement.Builder, org.apache.calcite.avatica.proto.Responses.DatabasePropertyElementOrBuilder> 
          getPropsFieldBuilder() {
        if (propsBuilder_ == null) {
          propsBuilder_ = new com.google.protobuf.RepeatedFieldBuilder<
              org.apache.calcite.avatica.proto.Responses.DatabasePropertyElement, org.apache.calcite.avatica.proto.Responses.DatabasePropertyElement.Builder, org.apache.calcite.avatica.proto.Responses.DatabasePropertyElementOrBuilder>(
                  props_,
                  ((bitField0_ & 0x00000001) == 0x00000001),
                  getParentForChildren(),
                  isClean());
          props_ = null;
        }
        return propsBuilder_;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return this;
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return this;
      }


      // @@protoc_insertion_point(builder_scope:DatabasePropertyResponse)
    }

    // @@protoc_insertion_point(class_scope:DatabasePropertyResponse)
    private static final org.apache.calcite.avatica.proto.Responses.DatabasePropertyResponse DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.apache.calcite.avatica.proto.Responses.DatabasePropertyResponse();
    }

    public static org.apache.calcite.avatica.proto.Responses.DatabasePropertyResponse getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<DatabasePropertyResponse>
        PARSER = new com.google.protobuf.AbstractParser<DatabasePropertyResponse>() {
      public DatabasePropertyResponse parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        try {
          return new DatabasePropertyResponse(input, extensionRegistry);
        } catch (RuntimeException e) {
          if (e.getCause() instanceof
              com.google.protobuf.InvalidProtocolBufferException) {
            throw (com.google.protobuf.InvalidProtocolBufferException)
                e.getCause();
          }
          throw e;
        }
      }
    };

    public static com.google.protobuf.Parser<DatabasePropertyResponse> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<DatabasePropertyResponse> getParserForType() {
      return PARSER;
    }

    public org.apache.calcite.avatica.proto.Responses.DatabasePropertyResponse getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface ErrorResponseOrBuilder extends
      // @@protoc_insertion_point(interface_extends:ErrorResponse)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>repeated string exceptions = 1;</code>
     *
     * <pre>
     * exception stacktraces, many for linked exceptions.
     * </pre>
     */
    com.google.protobuf.ProtocolStringList
        getExceptionsList();
    /**
     * <code>repeated string exceptions = 1;</code>
     *
     * <pre>
     * exception stacktraces, many for linked exceptions.
     * </pre>
     */
    int getExceptionsCount();
    /**
     * <code>repeated string exceptions = 1;</code>
     *
     * <pre>
     * exception stacktraces, many for linked exceptions.
     * </pre>
     */
    java.lang.String getExceptions(int index);
    /**
     * <code>repeated string exceptions = 1;</code>
     *
     * <pre>
     * exception stacktraces, many for linked exceptions.
     * </pre>
     */
    com.google.protobuf.ByteString
        getExceptionsBytes(int index);

    /**
     * <code>optional string error_message = 2;</code>
     *
     * <pre>
     * human readable description
     * </pre>
     */
    java.lang.String getErrorMessage();
    /**
     * <code>optional string error_message = 2;</code>
     *
     * <pre>
     * human readable description
     * </pre>
     */
    com.google.protobuf.ByteString
        getErrorMessageBytes();

    /**
     * <code>optional .Severity severity = 3;</code>
     */
    int getSeverityValue();
    /**
     * <code>optional .Severity severity = 3;</code>
     */
    org.apache.calcite.avatica.proto.Common.Severity getSeverity();

    /**
     * <code>optional uint32 error_code = 4;</code>
     *
     * <pre>
     * numeric identifier for error
     * </pre>
     */
    int getErrorCode();

    /**
     * <code>optional string sql_state = 5;</code>
     *
     * <pre>
     * five-character standard-defined value
     * </pre>
     */
    java.lang.String getSqlState();
    /**
     * <code>optional string sql_state = 5;</code>
     *
     * <pre>
     * five-character standard-defined value
     * </pre>
     */
    com.google.protobuf.ByteString
        getSqlStateBytes();
  }
  /**
   * Protobuf type {@code ErrorResponse}
   *
   * <pre>
   * Send contextual information about some error over the wire from the server.
   * </pre>
   */
  public  static final class ErrorResponse extends
      com.google.protobuf.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:ErrorResponse)
      ErrorResponseOrBuilder {
    // Use ErrorResponse.newBuilder() to construct.
    private ErrorResponse(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
    }
    private ErrorResponse() {
      exceptions_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      errorMessage_ = "";
      severity_ = 0;
      errorCode_ = 0;
      sqlState_ = "";
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return com.google.protobuf.UnknownFieldSet.getDefaultInstance();
    }
    private ErrorResponse(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry) {
      this();
      int mutable_bitField0_ = 0;
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!input.skipField(tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              String s = input.readStringRequireUtf8();
              if (!((mutable_bitField0_ & 0x00000001) == 0x00000001)) {
                exceptions_ = new com.google.protobuf.LazyStringArrayList();
                mutable_bitField0_ |= 0x00000001;
              }
              exceptions_.add(s);
              break;
            }
            case 18: {
              String s = input.readStringRequireUtf8();

              errorMessage_ = s;
              break;
            }
            case 24: {
              int rawValue = input.readEnum();

              severity_ = rawValue;
              break;
            }
            case 32: {

              errorCode_ = input.readUInt32();
              break;
            }
            case 42: {
              String s = input.readStringRequireUtf8();

              sqlState_ = s;
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw new RuntimeException(e.setUnfinishedMessage(this));
      } catch (java.io.IOException e) {
        throw new RuntimeException(
            new com.google.protobuf.InvalidProtocolBufferException(
                e.getMessage()).setUnfinishedMessage(this));
      } finally {
        if (((mutable_bitField0_ & 0x00000001) == 0x00000001)) {
          exceptions_ = exceptions_.getUnmodifiableView();
        }
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.calcite.avatica.proto.Responses.internal_static_ErrorResponse_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.calcite.avatica.proto.Responses.internal_static_ErrorResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.calcite.avatica.proto.Responses.ErrorResponse.class, org.apache.calcite.avatica.proto.Responses.ErrorResponse.Builder.class);
    }

    private int bitField0_;
    public static final int EXCEPTIONS_FIELD_NUMBER = 1;
    private com.google.protobuf.LazyStringList exceptions_;
    /**
     * <code>repeated string exceptions = 1;</code>
     *
     * <pre>
     * exception stacktraces, many for linked exceptions.
     * </pre>
     */
    public com.google.protobuf.ProtocolStringList
        getExceptionsList() {
      return exceptions_;
    }
    /**
     * <code>repeated string exceptions = 1;</code>
     *
     * <pre>
     * exception stacktraces, many for linked exceptions.
     * </pre>
     */
    public int getExceptionsCount() {
      return exceptions_.size();
    }
    /**
     * <code>repeated string exceptions = 1;</code>
     *
     * <pre>
     * exception stacktraces, many for linked exceptions.
     * </pre>
     */
    public java.lang.String getExceptions(int index) {
      return exceptions_.get(index);
    }
    /**
     * <code>repeated string exceptions = 1;</code>
     *
     * <pre>
     * exception stacktraces, many for linked exceptions.
     * </pre>
     */
    public com.google.protobuf.ByteString
        getExceptionsBytes(int index) {
      return exceptions_.getByteString(index);
    }

    public static final int ERROR_MESSAGE_FIELD_NUMBER = 2;
    private volatile java.lang.Object errorMessage_;
    /**
     * <code>optional string error_message = 2;</code>
     *
     * <pre>
     * human readable description
     * </pre>
     */
    public java.lang.String getErrorMessage() {
      java.lang.Object ref = errorMessage_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        errorMessage_ = s;
        return s;
      }
    }
    /**
     * <code>optional string error_message = 2;</code>
     *
     * <pre>
     * human readable description
     * </pre>
     */
    public com.google.protobuf.ByteString
        getErrorMessageBytes() {
      java.lang.Object ref = errorMessage_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        errorMessage_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int SEVERITY_FIELD_NUMBER = 3;
    private int severity_;
    /**
     * <code>optional .Severity severity = 3;</code>
     */
    public int getSeverityValue() {
      return severity_;
    }
    /**
     * <code>optional .Severity severity = 3;</code>
     */
    public org.apache.calcite.avatica.proto.Common.Severity getSeverity() {
      org.apache.calcite.avatica.proto.Common.Severity result = org.apache.calcite.avatica.proto.Common.Severity.valueOf(severity_);
      return result == null ? org.apache.calcite.avatica.proto.Common.Severity.UNRECOGNIZED : result;
    }

    public static final int ERROR_CODE_FIELD_NUMBER = 4;
    private int errorCode_;
    /**
     * <code>optional uint32 error_code = 4;</code>
     *
     * <pre>
     * numeric identifier for error
     * </pre>
     */
    public int getErrorCode() {
      return errorCode_;
    }

    public static final int SQL_STATE_FIELD_NUMBER = 5;
    private volatile java.lang.Object sqlState_;
    /**
     * <code>optional string sql_state = 5;</code>
     *
     * <pre>
     * five-character standard-defined value
     * </pre>
     */
    public java.lang.String getSqlState() {
      java.lang.Object ref = sqlState_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        sqlState_ = s;
        return s;
      }
    }
    /**
     * <code>optional string sql_state = 5;</code>
     *
     * <pre>
     * five-character standard-defined value
     * </pre>
     */
    public com.google.protobuf.ByteString
        getSqlStateBytes() {
      java.lang.Object ref = sqlState_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        sqlState_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      for (int i = 0; i < exceptions_.size(); i++) {
        com.google.protobuf.GeneratedMessage.writeString(output, 1, exceptions_.getRaw(i));
      }
      if (!getErrorMessageBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessage.writeString(output, 2, errorMessage_);
      }
      if (severity_ != org.apache.calcite.avatica.proto.Common.Severity.UNKNOWN_SEVERITY.getNumber()) {
        output.writeEnum(3, severity_);
      }
      if (errorCode_ != 0) {
        output.writeUInt32(4, errorCode_);
      }
      if (!getSqlStateBytes().isEmpty()) {
        com.google.protobuf.GeneratedMessage.writeString(output, 5, sqlState_);
      }
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      {
        int dataSize = 0;
        for (int i = 0; i < exceptions_.size(); i++) {
          dataSize += computeStringSizeNoTag(exceptions_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getExceptionsList().size();
      }
      if (!getErrorMessageBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessage.computeStringSize(2, errorMessage_);
      }
      if (severity_ != org.apache.calcite.avatica.proto.Common.Severity.UNKNOWN_SEVERITY.getNumber()) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(3, severity_);
      }
      if (errorCode_ != 0) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt32Size(4, errorCode_);
      }
      if (!getSqlStateBytes().isEmpty()) {
        size += com.google.protobuf.GeneratedMessage.computeStringSize(5, sqlState_);
      }
      memoizedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    public static org.apache.calcite.avatica.proto.Responses.ErrorResponse parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.calcite.avatica.proto.Responses.ErrorResponse parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.calcite.avatica.proto.Responses.ErrorResponse parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.calcite.avatica.proto.Responses.ErrorResponse parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.calcite.avatica.proto.Responses.ErrorResponse parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.calcite.avatica.proto.Responses.ErrorResponse parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static org.apache.calcite.avatica.proto.Responses.ErrorResponse parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static org.apache.calcite.avatica.proto.Responses.ErrorResponse parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static org.apache.calcite.avatica.proto.Responses.ErrorResponse parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.calcite.avatica.proto.Responses.ErrorResponse parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.apache.calcite.avatica.proto.Responses.ErrorResponse prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code ErrorResponse}
     *
     * <pre>
     * Send contextual information about some error over the wire from the server.
     * </pre>
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:ErrorResponse)
        org.apache.calcite.avatica.proto.Responses.ErrorResponseOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.calcite.avatica.proto.Responses.internal_static_ErrorResponse_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.calcite.avatica.proto.Responses.internal_static_ErrorResponse_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.calcite.avatica.proto.Responses.ErrorResponse.class, org.apache.calcite.avatica.proto.Responses.ErrorResponse.Builder.class);
      }

      // Construct using org.apache.calcite.avatica.proto.Responses.ErrorResponse.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
        }
      }
      public Builder clear() {
        super.clear();
        exceptions_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000001);
        errorMessage_ = "";

        severity_ = 0;

        errorCode_ = 0;

        sqlState_ = "";

        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.calcite.avatica.proto.Responses.internal_static_ErrorResponse_descriptor;
      }

      public org.apache.calcite.avatica.proto.Responses.ErrorResponse getDefaultInstanceForType() {
        return org.apache.calcite.avatica.proto.Responses.ErrorResponse.getDefaultInstance();
      }

      public org.apache.calcite.avatica.proto.Responses.ErrorResponse build() {
        org.apache.calcite.avatica.proto.Responses.ErrorResponse result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public org.apache.calcite.avatica.proto.Responses.ErrorResponse buildPartial() {
        org.apache.calcite.avatica.proto.Responses.ErrorResponse result = new org.apache.calcite.avatica.proto.Responses.ErrorResponse(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((bitField0_ & 0x00000001) == 0x00000001)) {
          exceptions_ = exceptions_.getUnmodifiableView();
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.exceptions_ = exceptions_;
        result.errorMessage_ = errorMessage_;
        result.severity_ = severity_;
        result.errorCode_ = errorCode_;
        result.sqlState_ = sqlState_;
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.apache.calcite.avatica.proto.Responses.ErrorResponse) {
          return mergeFrom((org.apache.calcite.avatica.proto.Responses.ErrorResponse)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.calcite.avatica.proto.Responses.ErrorResponse other) {
        if (other == org.apache.calcite.avatica.proto.Responses.ErrorResponse.getDefaultInstance()) return this;
        if (!other.exceptions_.isEmpty()) {
          if (exceptions_.isEmpty()) {
            exceptions_ = other.exceptions_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureExceptionsIsMutable();
            exceptions_.addAll(other.exceptions_);
          }
          onChanged();
        }
        if (!other.getErrorMessage().isEmpty()) {
          errorMessage_ = other.errorMessage_;
          onChanged();
        }
        if (other.severity_ != 0) {
          setSeverityValue(other.getSeverityValue());
        }
        if (other.getErrorCode() != 0) {
          setErrorCode(other.getErrorCode());
        }
        if (!other.getSqlState().isEmpty()) {
          sqlState_ = other.sqlState_;
          onChanged();
        }
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        org.apache.calcite.avatica.proto.Responses.ErrorResponse parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (org.apache.calcite.avatica.proto.Responses.ErrorResponse) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private com.google.protobuf.LazyStringList exceptions_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      private void ensureExceptionsIsMutable() {
        if (!((bitField0_ & 0x00000001) == 0x00000001)) {
          exceptions_ = new com.google.protobuf.LazyStringArrayList(exceptions_);
          bitField0_ |= 0x00000001;
         }
      }
      /**
       * <code>repeated string exceptions = 1;</code>
       *
       * <pre>
       * exception stacktraces, many for linked exceptions.
       * </pre>
       */
      public com.google.protobuf.ProtocolStringList
          getExceptionsList() {
        return exceptions_.getUnmodifiableView();
      }
      /**
       * <code>repeated string exceptions = 1;</code>
       *
       * <pre>
       * exception stacktraces, many for linked exceptions.
       * </pre>
       */
      public int getExceptionsCount() {
        return exceptions_.size();
      }
      /**
       * <code>repeated string exceptions = 1;</code>
       *
       * <pre>
       * exception stacktraces, many for linked exceptions.
       * </pre>
       */
      public java.lang.String getExceptions(int index) {
        return exceptions_.get(index);
      }
      /**
       * <code>repeated string exceptions = 1;</code>
       *
       * <pre>
       * exception stacktraces, many for linked exceptions.
       * </pre>
       */
      public com.google.protobuf.ByteString
          getExceptionsBytes(int index) {
        return exceptions_.getByteString(index);
      }
      /**
       * <code>repeated string exceptions = 1;</code>
       *
       * <pre>
       * exception stacktraces, many for linked exceptions.
       * </pre>
       */
      public Builder setExceptions(
          int index, java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  ensureExceptionsIsMutable();
        exceptions_.set(index, value);
        onChanged();
        return this;
      }
      /**
       * <code>repeated string exceptions = 1;</code>
       *
       * <pre>
       * exception stacktraces, many for linked exceptions.
       * </pre>
       */
      public Builder addExceptions(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  ensureExceptionsIsMutable();
        exceptions_.add(value);
        onChanged();
        return this;
      }
      /**
       * <code>repeated string exceptions = 1;</code>
       *
       * <pre>
       * exception stacktraces, many for linked exceptions.
       * </pre>
       */
      public Builder addAllExceptions(
          java.lang.Iterable<java.lang.String> values) {
        ensureExceptionsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, exceptions_);
        onChanged();
        return this;
      }
      /**
       * <code>repeated string exceptions = 1;</code>
       *
       * <pre>
       * exception stacktraces, many for linked exceptions.
       * </pre>
       */
      public Builder clearExceptions() {
        exceptions_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       * <code>repeated string exceptions = 1;</code>
       *
       * <pre>
       * exception stacktraces, many for linked exceptions.
       * </pre>
       */
      public Builder addExceptionsBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        ensureExceptionsIsMutable();
        exceptions_.add(value);
        onChanged();
        return this;
      }

      private java.lang.Object errorMessage_ = "";
      /**
       * <code>optional string error_message = 2;</code>
       *
       * <pre>
       * human readable description
       * </pre>
       */
      public java.lang.String getErrorMessage() {
        java.lang.Object ref = errorMessage_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          errorMessage_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>optional string error_message = 2;</code>
       *
       * <pre>
       * human readable description
       * </pre>
       */
      public com.google.protobuf.ByteString
          getErrorMessageBytes() {
        java.lang.Object ref = errorMessage_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          errorMessage_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>optional string error_message = 2;</code>
       *
       * <pre>
       * human readable description
       * </pre>
       */
      public Builder setErrorMessage(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        errorMessage_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional string error_message = 2;</code>
       *
       * <pre>
       * human readable description
       * </pre>
       */
      public Builder clearErrorMessage() {
        
        errorMessage_ = getDefaultInstance().getErrorMessage();
        onChanged();
        return this;
      }
      /**
       * <code>optional string error_message = 2;</code>
       *
       * <pre>
       * human readable description
       * </pre>
       */
      public Builder setErrorMessageBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        errorMessage_ = value;
        onChanged();
        return this;
      }

      private int severity_ = 0;
      /**
       * <code>optional .Severity severity = 3;</code>
       */
      public int getSeverityValue() {
        return severity_;
      }
      /**
       * <code>optional .Severity severity = 3;</code>
       */
      public Builder setSeverityValue(int value) {
        severity_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional .Severity severity = 3;</code>
       */
      public org.apache.calcite.avatica.proto.Common.Severity getSeverity() {
        org.apache.calcite.avatica.proto.Common.Severity result = org.apache.calcite.avatica.proto.Common.Severity.valueOf(severity_);
        return result == null ? org.apache.calcite.avatica.proto.Common.Severity.UNRECOGNIZED : result;
      }
      /**
       * <code>optional .Severity severity = 3;</code>
       */
      public Builder setSeverity(org.apache.calcite.avatica.proto.Common.Severity value) {
        if (value == null) {
          throw new NullPointerException();
        }
        
        severity_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       * <code>optional .Severity severity = 3;</code>
       */
      public Builder clearSeverity() {
        
        severity_ = 0;
        onChanged();
        return this;
      }

      private int errorCode_ ;
      /**
       * <code>optional uint32 error_code = 4;</code>
       *
       * <pre>
       * numeric identifier for error
       * </pre>
       */
      public int getErrorCode() {
        return errorCode_;
      }
      /**
       * <code>optional uint32 error_code = 4;</code>
       *
       * <pre>
       * numeric identifier for error
       * </pre>
       */
      public Builder setErrorCode(int value) {
        
        errorCode_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional uint32 error_code = 4;</code>
       *
       * <pre>
       * numeric identifier for error
       * </pre>
       */
      public Builder clearErrorCode() {
        
        errorCode_ = 0;
        onChanged();
        return this;
      }

      private java.lang.Object sqlState_ = "";
      /**
       * <code>optional string sql_state = 5;</code>
       *
       * <pre>
       * five-character standard-defined value
       * </pre>
       */
      public java.lang.String getSqlState() {
        java.lang.Object ref = sqlState_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          sqlState_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>optional string sql_state = 5;</code>
       *
       * <pre>
       * five-character standard-defined value
       * </pre>
       */
      public com.google.protobuf.ByteString
          getSqlStateBytes() {
        java.lang.Object ref = sqlState_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          sqlState_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>optional string sql_state = 5;</code>
       *
       * <pre>
       * five-character standard-defined value
       * </pre>
       */
      public Builder setSqlState(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  
        sqlState_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional string sql_state = 5;</code>
       *
       * <pre>
       * five-character standard-defined value
       * </pre>
       */
      public Builder clearSqlState() {
        
        sqlState_ = getDefaultInstance().getSqlState();
        onChanged();
        return this;
      }
      /**
       * <code>optional string sql_state = 5;</code>
       *
       * <pre>
       * five-character standard-defined value
       * </pre>
       */
      public Builder setSqlStateBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
        
        sqlState_ = value;
        onChanged();
        return this;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return this;
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return this;
      }


      // @@protoc_insertion_point(builder_scope:ErrorResponse)
    }

    // @@protoc_insertion_point(class_scope:ErrorResponse)
    private static final org.apache.calcite.avatica.proto.Responses.ErrorResponse DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.apache.calcite.avatica.proto.Responses.ErrorResponse();
    }

    public static org.apache.calcite.avatica.proto.Responses.ErrorResponse getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ErrorResponse>
        PARSER = new com.google.protobuf.AbstractParser<ErrorResponse>() {
      public ErrorResponse parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        try {
          return new ErrorResponse(input, extensionRegistry);
        } catch (RuntimeException e) {
          if (e.getCause() instanceof
              com.google.protobuf.InvalidProtocolBufferException) {
            throw (com.google.protobuf.InvalidProtocolBufferException)
                e.getCause();
          }
          throw e;
        }
      }
    };

    public static com.google.protobuf.Parser<ErrorResponse> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ErrorResponse> getParserForType() {
      return PARSER;
    }

    public org.apache.calcite.avatica.proto.Responses.ErrorResponse getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface SyncResultsResponseOrBuilder extends
      // @@protoc_insertion_point(interface_extends:SyncResultsResponse)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>optional bool missing_statement = 1;</code>
     *
     * <pre>
     * Server doesn't have the statement with the ID from the request
     * </pre>
     */
    boolean getMissingStatement();

    /**
     * <code>optional bool more_results = 2;</code>
     *
     * <pre>
     * Should the client fetch() to get more results
     * </pre>
     */
    boolean getMoreResults();
  }
  /**
   * Protobuf type {@code SyncResultsResponse}
   */
  public  static final class SyncResultsResponse extends
      com.google.protobuf.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:SyncResultsResponse)
      SyncResultsResponseOrBuilder {
    // Use SyncResultsResponse.newBuilder() to construct.
    private SyncResultsResponse(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
    }
    private SyncResultsResponse() {
      missingStatement_ = false;
      moreResults_ = false;
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
    getUnknownFields() {
      return com.google.protobuf.UnknownFieldSet.getDefaultInstance();
    }
    private SyncResultsResponse(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry) {
      this();
      int mutable_bitField0_ = 0;
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!input.skipField(tag)) {
                done = true;
              }
              break;
            }
            case 8: {

              missingStatement_ = input.readBool();
              break;
            }
            case 16: {

              moreResults_ = input.readBool();
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw new RuntimeException(e.setUnfinishedMessage(this));
      } catch (java.io.IOException e) {
        throw new RuntimeException(
            new com.google.protobuf.InvalidProtocolBufferException(
                e.getMessage()).setUnfinishedMessage(this));
      } finally {
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return org.apache.calcite.avatica.proto.Responses.internal_static_SyncResultsResponse_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return org.apache.calcite.avatica.proto.Responses.internal_static_SyncResultsResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              org.apache.calcite.avatica.proto.Responses.SyncResultsResponse.class, org.apache.calcite.avatica.proto.Responses.SyncResultsResponse.Builder.class);
    }

    public static final int MISSING_STATEMENT_FIELD_NUMBER = 1;
    private boolean missingStatement_;
    /**
     * <code>optional bool missing_statement = 1;</code>
     *
     * <pre>
     * Server doesn't have the statement with the ID from the request
     * </pre>
     */
    public boolean getMissingStatement() {
      return missingStatement_;
    }

    public static final int MORE_RESULTS_FIELD_NUMBER = 2;
    private boolean moreResults_;
    /**
     * <code>optional bool more_results = 2;</code>
     *
     * <pre>
     * Should the client fetch() to get more results
     * </pre>
     */
    public boolean getMoreResults() {
      return moreResults_;
    }

    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (missingStatement_ != false) {
        output.writeBool(1, missingStatement_);
      }
      if (moreResults_ != false) {
        output.writeBool(2, moreResults_);
      }
    }

    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (missingStatement_ != false) {
        size += com.google.protobuf.CodedOutputStream
          .computeBoolSize(1, missingStatement_);
      }
      if (moreResults_ != false) {
        size += com.google.protobuf.CodedOutputStream
          .computeBoolSize(2, moreResults_);
      }
      memoizedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    public static org.apache.calcite.avatica.proto.Responses.SyncResultsResponse parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.calcite.avatica.proto.Responses.SyncResultsResponse parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.calcite.avatica.proto.Responses.SyncResultsResponse parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static org.apache.calcite.avatica.proto.Responses.SyncResultsResponse parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static org.apache.calcite.avatica.proto.Responses.SyncResultsResponse parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.calcite.avatica.proto.Responses.SyncResultsResponse parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static org.apache.calcite.avatica.proto.Responses.SyncResultsResponse parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static org.apache.calcite.avatica.proto.Responses.SyncResultsResponse parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static org.apache.calcite.avatica.proto.Responses.SyncResultsResponse parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static org.apache.calcite.avatica.proto.Responses.SyncResultsResponse parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(org.apache.calcite.avatica.proto.Responses.SyncResultsResponse prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code SyncResultsResponse}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:SyncResultsResponse)
        org.apache.calcite.avatica.proto.Responses.SyncResultsResponseOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return org.apache.calcite.avatica.proto.Responses.internal_static_SyncResultsResponse_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return org.apache.calcite.avatica.proto.Responses.internal_static_SyncResultsResponse_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                org.apache.calcite.avatica.proto.Responses.SyncResultsResponse.class, org.apache.calcite.avatica.proto.Responses.SyncResultsResponse.Builder.class);
      }

      // Construct using org.apache.calcite.avatica.proto.Responses.SyncResultsResponse.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
        }
      }
      public Builder clear() {
        super.clear();
        missingStatement_ = false;

        moreResults_ = false;

        return this;
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return org.apache.calcite.avatica.proto.Responses.internal_static_SyncResultsResponse_descriptor;
      }

      public org.apache.calcite.avatica.proto.Responses.SyncResultsResponse getDefaultInstanceForType() {
        return org.apache.calcite.avatica.proto.Responses.SyncResultsResponse.getDefaultInstance();
      }

      public org.apache.calcite.avatica.proto.Responses.SyncResultsResponse build() {
        org.apache.calcite.avatica.proto.Responses.SyncResultsResponse result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public org.apache.calcite.avatica.proto.Responses.SyncResultsResponse buildPartial() {
        org.apache.calcite.avatica.proto.Responses.SyncResultsResponse result = new org.apache.calcite.avatica.proto.Responses.SyncResultsResponse(this);
        result.missingStatement_ = missingStatement_;
        result.moreResults_ = moreResults_;
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof org.apache.calcite.avatica.proto.Responses.SyncResultsResponse) {
          return mergeFrom((org.apache.calcite.avatica.proto.Responses.SyncResultsResponse)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(org.apache.calcite.avatica.proto.Responses.SyncResultsResponse other) {
        if (other == org.apache.calcite.avatica.proto.Responses.SyncResultsResponse.getDefaultInstance()) return this;
        if (other.getMissingStatement() != false) {
          setMissingStatement(other.getMissingStatement());
        }
        if (other.getMoreResults() != false) {
          setMoreResults(other.getMoreResults());
        }
        onChanged();
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        org.apache.calcite.avatica.proto.Responses.SyncResultsResponse parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (org.apache.calcite.avatica.proto.Responses.SyncResultsResponse) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private boolean missingStatement_ ;
      /**
       * <code>optional bool missing_statement = 1;</code>
       *
       * <pre>
       * Server doesn't have the statement with the ID from the request
       * </pre>
       */
      public boolean getMissingStatement() {
        return missingStatement_;
      }
      /**
       * <code>optional bool missing_statement = 1;</code>
       *
       * <pre>
       * Server doesn't have the statement with the ID from the request
       * </pre>
       */
      public Builder setMissingStatement(boolean value) {
        
        missingStatement_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional bool missing_statement = 1;</code>
       *
       * <pre>
       * Server doesn't have the statement with the ID from the request
       * </pre>
       */
      public Builder clearMissingStatement() {
        
        missingStatement_ = false;
        onChanged();
        return this;
      }

      private boolean moreResults_ ;
      /**
       * <code>optional bool more_results = 2;</code>
       *
       * <pre>
       * Should the client fetch() to get more results
       * </pre>
       */
      public boolean getMoreResults() {
        return moreResults_;
      }
      /**
       * <code>optional bool more_results = 2;</code>
       *
       * <pre>
       * Should the client fetch() to get more results
       * </pre>
       */
      public Builder setMoreResults(boolean value) {
        
        moreResults_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional bool more_results = 2;</code>
       *
       * <pre>
       * Should the client fetch() to get more results
       * </pre>
       */
      public Builder clearMoreResults() {
        
        moreResults_ = false;
        onChanged();
        return this;
      }
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return this;
      }

      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return this;
      }


      // @@protoc_insertion_point(builder_scope:SyncResultsResponse)
    }

    // @@protoc_insertion_point(class_scope:SyncResultsResponse)
    private static final org.apache.calcite.avatica.proto.Responses.SyncResultsResponse DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new org.apache.calcite.avatica.proto.Responses.SyncResultsResponse();
    }

    public static org.apache.calcite.avatica.proto.Responses.SyncResultsResponse getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<SyncResultsResponse>
        PARSER = new com.google.protobuf.AbstractParser<SyncResultsResponse>() {
      public SyncResultsResponse parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        try {
          return new SyncResultsResponse(input, extensionRegistry);
        } catch (RuntimeException e) {
          if (e.getCause() instanceof
              com.google.protobuf.InvalidProtocolBufferException) {
            throw (com.google.protobuf.InvalidProtocolBufferException)
                e.getCause();
          }
          throw e;
        }
      }
    };

    public static com.google.protobuf.Parser<SyncResultsResponse> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<SyncResultsResponse> getParserForType() {
      return PARSER;
    }

    public org.apache.calcite.avatica.proto.Responses.SyncResultsResponse getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  private static com.google.protobuf.Descriptors.Descriptor
    internal_static_ResultSetResponse_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_ResultSetResponse_fieldAccessorTable;
  private static com.google.protobuf.Descriptors.Descriptor
    internal_static_ExecuteResponse_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_ExecuteResponse_fieldAccessorTable;
  private static com.google.protobuf.Descriptors.Descriptor
    internal_static_PrepareResponse_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_PrepareResponse_fieldAccessorTable;
  private static com.google.protobuf.Descriptors.Descriptor
    internal_static_FetchResponse_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_FetchResponse_fieldAccessorTable;
  private static com.google.protobuf.Descriptors.Descriptor
    internal_static_CreateStatementResponse_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_CreateStatementResponse_fieldAccessorTable;
  private static com.google.protobuf.Descriptors.Descriptor
    internal_static_CloseStatementResponse_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_CloseStatementResponse_fieldAccessorTable;
  private static com.google.protobuf.Descriptors.Descriptor
    internal_static_OpenConnectionResponse_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_OpenConnectionResponse_fieldAccessorTable;
  private static com.google.protobuf.Descriptors.Descriptor
    internal_static_CloseConnectionResponse_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_CloseConnectionResponse_fieldAccessorTable;
  private static com.google.protobuf.Descriptors.Descriptor
    internal_static_ConnectionSyncResponse_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_ConnectionSyncResponse_fieldAccessorTable;
  private static com.google.protobuf.Descriptors.Descriptor
    internal_static_DatabasePropertyElement_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_DatabasePropertyElement_fieldAccessorTable;
  private static com.google.protobuf.Descriptors.Descriptor
    internal_static_DatabasePropertyResponse_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_DatabasePropertyResponse_fieldAccessorTable;
  private static com.google.protobuf.Descriptors.Descriptor
    internal_static_ErrorResponse_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_ErrorResponse_fieldAccessorTable;
  private static com.google.protobuf.Descriptors.Descriptor
    internal_static_SyncResultsResponse_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_SyncResultsResponse_fieldAccessorTable;

  public static com.google.protobuf.Descriptors.FileDescriptor
      getDescriptor() {
    return descriptor;
  }
  private static com.google.protobuf.Descriptors.FileDescriptor
      descriptor;
  static {
    java.lang.String[] descriptorData = {
      "\n\017responses.proto\032\014common.proto\"\251\001\n\021Resu" +
      "ltSetResponse\022\025\n\rconnection_id\030\001 \001(\t\022\024\n\014" +
      "statement_id\030\002 \001(\r\022\025\n\rown_statement\030\003 \001(" +
      "\010\022\035\n\tsignature\030\004 \001(\0132\n.Signature\022\033\n\013firs" +
      "t_frame\030\005 \001(\0132\006.Frame\022\024\n\014update_count\030\006 " +
      "\001(\004\"Q\n\017ExecuteResponse\022#\n\007results\030\001 \003(\0132" +
      "\022.ResultSetResponse\022\031\n\021missing_statement" +
      "\030\002 \001(\010\"6\n\017PrepareResponse\022#\n\tstatement\030\001" +
      " \001(\0132\020.StatementHandle\"Z\n\rFetchResponse\022" +
      "\025\n\005frame\030\001 \001(\0132\006.Frame\022\031\n\021missing_statem",
      "ent\030\002 \001(\010\022\027\n\017missing_results\030\003 \001(\010\"F\n\027Cr" +
      "eateStatementResponse\022\025\n\rconnection_id\030\001" +
      " \001(\t\022\024\n\014statement_id\030\002 \001(\r\"\030\n\026CloseState" +
      "mentResponse\"\030\n\026OpenConnectionResponse\"\031" +
      "\n\027CloseConnectionResponse\"C\n\026ConnectionS" +
      "yncResponse\022)\n\nconn_props\030\001 \001(\0132\025.Connec" +
      "tionProperties\"U\n\027DatabasePropertyElemen" +
      "t\022\036\n\003key\030\001 \001(\0132\021.DatabaseProperty\022\032\n\005val" +
      "ue\030\002 \001(\0132\013.TypedValue\"C\n\030DatabasePropert" +
      "yResponse\022\'\n\005props\030\001 \003(\0132\030.DatabasePrope",
      "rtyElement\"~\n\rErrorResponse\022\022\n\nexception" +
      "s\030\001 \003(\t\022\025\n\rerror_message\030\002 \001(\t\022\033\n\010severi" +
      "ty\030\003 \001(\0162\t.Severity\022\022\n\nerror_code\030\004 \001(\r\022" +
      "\021\n\tsql_state\030\005 \001(\t\"F\n\023SyncResultsRespons" +
      "e\022\031\n\021missing_statement\030\001 \001(\010\022\024\n\014more_res" +
      "ults\030\002 \001(\010B\"\n org.apache.calcite.avatica" +
      ".protob\006proto3"
    };
    com.google.protobuf.Descriptors.FileDescriptor.InternalDescriptorAssigner assigner =
        new com.google.protobuf.Descriptors.FileDescriptor.    InternalDescriptorAssigner() {
          public com.google.protobuf.ExtensionRegistry assignDescriptors(
              com.google.protobuf.Descriptors.FileDescriptor root) {
            descriptor = root;
            return null;
          }
        };
    com.google.protobuf.Descriptors.FileDescriptor
      .internalBuildGeneratedFileFrom(descriptorData,
        new com.google.protobuf.Descriptors.FileDescriptor[] {
          org.apache.calcite.avatica.proto.Common.getDescriptor(),
        }, assigner);
    internal_static_ResultSetResponse_descriptor =
      getDescriptor().getMessageTypes().get(0);
    internal_static_ResultSetResponse_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_ResultSetResponse_descriptor,
        new java.lang.String[] { "ConnectionId", "StatementId", "OwnStatement", "Signature", "FirstFrame", "UpdateCount", });
    internal_static_ExecuteResponse_descriptor =
      getDescriptor().getMessageTypes().get(1);
    internal_static_ExecuteResponse_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_ExecuteResponse_descriptor,
        new java.lang.String[] { "Results", "MissingStatement", });
    internal_static_PrepareResponse_descriptor =
      getDescriptor().getMessageTypes().get(2);
    internal_static_PrepareResponse_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_PrepareResponse_descriptor,
        new java.lang.String[] { "Statement", });
    internal_static_FetchResponse_descriptor =
      getDescriptor().getMessageTypes().get(3);
    internal_static_FetchResponse_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_FetchResponse_descriptor,
        new java.lang.String[] { "Frame", "MissingStatement", "MissingResults", });
    internal_static_CreateStatementResponse_descriptor =
      getDescriptor().getMessageTypes().get(4);
    internal_static_CreateStatementResponse_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_CreateStatementResponse_descriptor,
        new java.lang.String[] { "ConnectionId", "StatementId", });
    internal_static_CloseStatementResponse_descriptor =
      getDescriptor().getMessageTypes().get(5);
    internal_static_CloseStatementResponse_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_CloseStatementResponse_descriptor,
        new java.lang.String[] { });
    internal_static_OpenConnectionResponse_descriptor =
      getDescriptor().getMessageTypes().get(6);
    internal_static_OpenConnectionResponse_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_OpenConnectionResponse_descriptor,
        new java.lang.String[] { });
    internal_static_CloseConnectionResponse_descriptor =
      getDescriptor().getMessageTypes().get(7);
    internal_static_CloseConnectionResponse_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_CloseConnectionResponse_descriptor,
        new java.lang.String[] { });
    internal_static_ConnectionSyncResponse_descriptor =
      getDescriptor().getMessageTypes().get(8);
    internal_static_ConnectionSyncResponse_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_ConnectionSyncResponse_descriptor,
        new java.lang.String[] { "ConnProps", });
    internal_static_DatabasePropertyElement_descriptor =
      getDescriptor().getMessageTypes().get(9);
    internal_static_DatabasePropertyElement_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_DatabasePropertyElement_descriptor,
        new java.lang.String[] { "Key", "Value", });
    internal_static_DatabasePropertyResponse_descriptor =
      getDescriptor().getMessageTypes().get(10);
    internal_static_DatabasePropertyResponse_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_DatabasePropertyResponse_descriptor,
        new java.lang.String[] { "Props", });
    internal_static_ErrorResponse_descriptor =
      getDescriptor().getMessageTypes().get(11);
    internal_static_ErrorResponse_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_ErrorResponse_descriptor,
        new java.lang.String[] { "Exceptions", "ErrorMessage", "Severity", "ErrorCode", "SqlState", });
    internal_static_SyncResultsResponse_descriptor =
      getDescriptor().getMessageTypes().get(12);
    internal_static_SyncResultsResponse_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_SyncResultsResponse_descriptor,
        new java.lang.String[] { "MissingStatement", "MoreResults", });
    org.apache.calcite.avatica.proto.Common.getDescriptor();
  }

  // @@protoc_insertion_point(outer_class_scope)
}
