/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.schema.registries;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.NamingException;
import org.apache.directory.server.schema.registries.NormalizerRegistry;
import org.apache.directory.shared.asn1.primitives.OID;
import org.apache.directory.shared.ldap.schema.Normalizer;
import org.apache.directory.shared.ldap.schema.parsers.NormalizerDescription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultNormalizerRegistry
implements NormalizerRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultNormalizerRegistry.class);
    private static final boolean DEBUG = LOG.isDebugEnabled();
    private final Map<String, Normalizer> byOidNormalizer = new ConcurrentHashMap<String, Normalizer>();
    private final Map<String, NormalizerDescription> oidToDescription = new ConcurrentHashMap<String, NormalizerDescription>();

    @Override
    public void register(NormalizerDescription description, Normalizer normalizer) throws NamingException {
        String oid = description.getNumericOid();
        if (this.byOidNormalizer.containsKey(oid)) {
            String msg = "Normalizer already registered for OID " + oid;
            LOG.warn(msg);
            throw new NamingException(msg);
        }
        this.oidToDescription.put(oid, description);
        this.byOidNormalizer.put(oid, normalizer);
        if (DEBUG) {
            LOG.debug("registered normalizer with oid: {}", (Object)oid);
        }
    }

    @Override
    public Normalizer lookup(String oid) throws NamingException {
        if (!this.byOidNormalizer.containsKey(oid)) {
            String msg = "Normalizer for OID " + oid + " does not exist!";
            LOG.debug(msg);
            throw new NamingException(msg);
        }
        Normalizer normalizer = this.byOidNormalizer.get(oid);
        if (DEBUG) {
            LOG.debug("registered normalizer with oid: {}", (Object)oid);
        }
        return normalizer;
    }

    @Override
    public boolean hasNormalizer(String oid) {
        return this.byOidNormalizer.containsKey(oid);
    }

    @Override
    public String getSchemaName(String oid) throws NamingException {
        if (!OID.isOID((String)oid)) {
            String msg = "OID " + oid + " is not a numeric OID";
            LOG.error(msg);
            throw new NamingException(msg);
        }
        NormalizerDescription description = this.oidToDescription.get(oid);
        if (description != null) {
            return DefaultNormalizerRegistry.getSchema(description);
        }
        String msg = "OID " + oid + " not found in oid to schema name map!";
        LOG.error(msg);
        throw new NamingException(msg);
    }

    private static String getSchema(NormalizerDescription desc) {
        List values = (List)desc.getExtensions().get("X-SCHEMA");
        if (values == null || values.size() == 0) {
            return "other";
        }
        return (String)values.get(0);
    }

    @Override
    public Iterator<String> iterator() {
        return this.byOidNormalizer.keySet().iterator();
    }

    @Override
    public void unregister(String oid) throws NamingException {
        if (!OID.isOID((String)oid)) {
            String msg = "OID " + oid + " is not a numeric OID";
            LOG.error(msg);
            throw new NamingException(msg);
        }
        this.byOidNormalizer.remove(oid);
        this.oidToDescription.remove(oid);
    }

    @Override
    public void unregisterSchemaElements(String schemaName) {
        ArrayList<String> oids = new ArrayList<String>(this.byOidNormalizer.keySet());
        for (String oid : oids) {
            NormalizerDescription description = this.oidToDescription.get(oid);
            String schemaNameForOid = DefaultNormalizerRegistry.getSchema(description);
            if (!schemaNameForOid.equalsIgnoreCase(schemaName)) continue;
            this.byOidNormalizer.remove(oid);
            this.oidToDescription.remove(oid);
        }
    }

    @Override
    public void renameSchema(String originalSchemaName, String newSchemaName) {
        ArrayList<String> oids = new ArrayList<String>(this.byOidNormalizer.keySet());
        for (String oid : oids) {
            NormalizerDescription description = this.oidToDescription.get(oid);
            String schemaNameForOid = DefaultNormalizerRegistry.getSchema(description);
            if (!schemaNameForOid.equalsIgnoreCase(originalSchemaName)) continue;
            List schemaExt = (List)description.getExtensions().get("X-SCHEMA");
            schemaExt.clear();
            schemaExt.add(newSchemaName);
        }
    }

    @Override
    public Iterator<NormalizerDescription> normalizerDescriptionIterator() {
        return this.oidToDescription.values().iterator();
    }
}

