/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.function.library;

import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import org.apache.jena.atlas.lib.DateTimeUtils;
import org.apache.jena.atlas.lib.InternalErrorException;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.ARQConstants;
import org.apache.jena.sparql.SystemARQ;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.expr.nodevalue.XSDFuncOp;
import org.apache.jena.sparql.function.FunctionBase0;
import org.apache.jena.sparql.function.FunctionEnv;
import org.apache.jena.sparql.function.library.SystemVar;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.Symbol;

public class nowtz
extends FunctionBase0 {
    public static Symbol symNowTz = SystemARQ.allocSymbol("nowtz");
    private static DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSxxxxx");
    private static ZoneId zoneIdUTC = ZoneOffset.UTC;

    @Override
    public NodeValue exec() {
        throw new InternalErrorException("nowtz: exec() Should not have been called");
    }

    @Override
    public NodeValue exec(List<NodeValue> args, FunctionEnv functionEnv) {
        Context cxt = functionEnv.getContext();
        if (cxt.isDefined(symNowTz)) {
            NodeValue nvx = (NodeValue)cxt.get(symNowTz);
            return nvx;
        }
        NodeValue nvx = this.execAdjust(functionEnv);
        cxt.set(symNowTz, nvx);
        return nvx;
    }

    private NodeValue execAdjust(FunctionEnv functionEnv) {
        NodeValue nv = SystemVar.get(ARQConstants.sysCurrentTime, functionEnv);
        NodeValue nvTz = XSDFuncOp.localTimezone();
        return XSDFuncOp.adjustDatetimeToTimezone(nv, nvTz);
    }

    private static String fromQueryTime(Context cxt) {
        Node n = (Node)cxt.get(ARQConstants.sysCurrentTime);
        String x = n == null ? DateTimeUtils.nowAsXSDDateTimeString() : n.getLiteralLexicalForm();
        ZonedDateTime zdt = dtf.parse((CharSequence)x, ZonedDateTime::from);
        ZonedDateTime zdtLocal = !zoneIdUTC.equals(ZoneId.systemDefault()) ? zdt.withZoneSameInstant(ZoneId.systemDefault()) : zdt;
        return dtf.format(zdtLocal);
    }
}

