/*
 * $Id$
 */

package org.apache.maven.mercury.repository.metadata;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * Class Metadata.
 * 
 * @version $Revision$ $Date$
 */
public class Metadata implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * The groupId that is directory represents, if any.
     */
    private String groupId;

    /**
     * The artifactId that is directory represents, if any.
     */
    private String artifactId;

    /**
     * The version that is directory represents, if any.
     */
    private String version;

    /**
     * Versioning information for the artifact.
     */
    private Versioning versioning;

    /**
     * Field plugins.
     */
    private java.util.List plugins;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addPlugin.
     * 
     * @param plugin
     */
    public void addPlugin(Plugin plugin)
    {
        if ( !(plugin instanceof Plugin) )
        {
            throw new ClassCastException( "Metadata.addPlugins(plugin) parameter must be instanceof " + Plugin.class.getName() );
        }
        getPlugins().add( plugin );
    } //-- void addPlugin(Plugin) 

    /**
     * Get the artifactId that is directory represents, if any.
     * 
     * @return String
     */
    public String getArtifactId()
    {
        return this.artifactId;
    } //-- String getArtifactId() 

    /**
     * Get the groupId that is directory represents, if any.
     * 
     * @return String
     */
    public String getGroupId()
    {
        return this.groupId;
    } //-- String getGroupId() 

    /**
     * Method getPlugins.
     * 
     * @return java.util.List
     */
    public java.util.List getPlugins()
    {
        if ( this.plugins == null )
        {
            this.plugins = new java.util.ArrayList();
        }
        
        return this.plugins;
    } //-- java.util.List getPlugins() 

    /**
     * Get the version that is directory represents, if any.
     * 
     * @return String
     */
    public String getVersion()
    {
        return this.version;
    } //-- String getVersion() 

    /**
     * Get versioning information for the artifact.
     * 
     * @return Versioning
     */
    public Versioning getVersioning()
    {
        return this.versioning;
    } //-- Versioning getVersioning() 

    /**
     * Method removePlugin.
     * 
     * @param plugin
     */
    public void removePlugin(Plugin plugin)
    {
        if ( !(plugin instanceof Plugin) )
        {
            throw new ClassCastException( "Metadata.removePlugins(plugin) parameter must be instanceof " + Plugin.class.getName() );
        }
        getPlugins().remove( plugin );
    } //-- void removePlugin(Plugin) 

    /**
     * Set the artifactId that is directory represents, if any.
     * 
     * @param artifactId
     */
    public void setArtifactId(String artifactId)
    {
        this.artifactId = artifactId;
    } //-- void setArtifactId(String) 

    /**
     * Set the groupId that is directory represents, if any.
     * 
     * @param groupId
     */
    public void setGroupId(String groupId)
    {
        this.groupId = groupId;
    } //-- void setGroupId(String) 

    /**
     * Set the set of plugin mappings for the group.
     * 
     * @param plugins
     */
    public void setPlugins(java.util.List plugins)
    {
        this.plugins = plugins;
    } //-- void setPlugins(java.util.List) 

    /**
     * Set the version that is directory represents, if any.
     * 
     * @param version
     */
    public void setVersion(String version)
    {
        this.version = version;
    } //-- void setVersion(String) 

    /**
     * Set versioning information for the artifact.
     * 
     * @param versioning
     */
    public void setVersioning(Versioning versioning)
    {
        this.versioning = versioning;
    } //-- void setVersioning(Versioning) 


    private String modelEncoding = "UTF-8";

    /**
     * Set an encoding used for reading/writing the model.
     *
     * @param modelEncoding the encoding used when reading/writing the model.
     */
    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    /**
     * @return the current encoding used when reading/writing this model.
     */
    public String getModelEncoding()
    {
        return modelEncoding;
    }
}
