/*
 * $Id$
 */

package org.apache.maven.mercury.repository.metadata;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * Mapping information for a single plugin within this group.
 * 
 * @version $Revision$ $Date$
 */
public class Plugin implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Display name for the plugin.
     */
    private String name;

    /**
     * The plugin invocation prefix (i.e. eclipse for
     * eclipse:eclipse).
     */
    private String prefix;

    /**
     * The plugin artifactId.
     */
    private String artifactId;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Get the plugin artifactId.
     * 
     * @return String
     */
    public String getArtifactId()
    {
        return this.artifactId;
    } //-- String getArtifactId() 

    /**
     * Get display name for the plugin.
     * 
     * @return String
     */
    public String getName()
    {
        return this.name;
    } //-- String getName() 

    /**
     * Get the plugin invocation prefix (i.e. eclipse for
     * eclipse:eclipse).
     * 
     * @return String
     */
    public String getPrefix()
    {
        return this.prefix;
    } //-- String getPrefix() 

    /**
     * Set the plugin artifactId.
     * 
     * @param artifactId
     */
    public void setArtifactId(String artifactId)
    {
        this.artifactId = artifactId;
    } //-- void setArtifactId(String) 

    /**
     * Set display name for the plugin.
     * 
     * @param name
     */
    public void setName(String name)
    {
        this.name = name;
    } //-- void setName(String) 

    /**
     * Set the plugin invocation prefix (i.e. eclipse for
     * eclipse:eclipse).
     * 
     * @param prefix
     */
    public void setPrefix(String prefix)
    {
        this.prefix = prefix;
    } //-- void setPrefix(String) 


    private String modelEncoding = "UTF-8";

    /**
     * Set an encoding used for reading/writing the model.
     *
     * @param modelEncoding the encoding used when reading/writing the model.
     */
    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    /**
     * @return the current encoding used when reading/writing this model.
     */
    public String getModelEncoding()
    {
        return modelEncoding;
    }
}
