/*
 * $Id$
 */

package org.apache.maven.mercury.repository.metadata;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * Snapshot data for the current version.
 * 
 * @version $Revision$ $Date$
 */
public class Snapshot implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * The time it was deployed.
     */
    private String timestamp;

    /**
     * The incremental build number.
     */
    private int buildNumber = 0;

    /**
     * Whether to use a local copy instead (with filename that
     * includes the base version).
     */
    private boolean localCopy = false;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Get the incremental build number.
     * 
     * @return int
     */
    public int getBuildNumber()
    {
        return this.buildNumber;
    } //-- int getBuildNumber() 

    /**
     * Get the time it was deployed.
     * 
     * @return String
     */
    public String getTimestamp()
    {
        return this.timestamp;
    } //-- String getTimestamp() 

    /**
     * Get whether to use a local copy instead (with filename that
     * includes the base version).
     * 
     * @return boolean
     */
    public boolean isLocalCopy()
    {
        return this.localCopy;
    } //-- boolean isLocalCopy() 

    /**
     * Set the incremental build number.
     * 
     * @param buildNumber
     */
    public void setBuildNumber(int buildNumber)
    {
        this.buildNumber = buildNumber;
    } //-- void setBuildNumber(int) 

    /**
     * Set whether to use a local copy instead (with filename that
     * includes the base version).
     * 
     * @param localCopy
     */
    public void setLocalCopy(boolean localCopy)
    {
        this.localCopy = localCopy;
    } //-- void setLocalCopy(boolean) 

    /**
     * Set the time it was deployed.
     * 
     * @param timestamp
     */
    public void setTimestamp(String timestamp)
    {
        this.timestamp = timestamp;
    } //-- void setTimestamp(String) 


    private String modelEncoding = "UTF-8";

    /**
     * Set an encoding used for reading/writing the model.
     *
     * @param modelEncoding the encoding used when reading/writing the model.
     */
    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    /**
     * @return the current encoding used when reading/writing this model.
     */
    public String getModelEncoding()
    {
        return modelEncoding;
    }
}
