/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.compiler;

import java.io.IOException;
import java.io.InputStream;
import java.lang.module.ModuleDescriptor;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Stream;
import javax.lang.model.SourceVersion;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileObject;
import javax.tools.OptionChecker;
import org.apache.maven.api.JavaPathType;
import org.apache.maven.api.PathScope;
import org.apache.maven.api.PathType;
import org.apache.maven.api.ProducedArtifact;
import org.apache.maven.api.SourceRoot;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.Nullable;
import org.apache.maven.api.plugin.MojoException;
import org.apache.maven.api.plugin.annotations.Mojo;
import org.apache.maven.api.plugin.annotations.Parameter;
import org.apache.maven.plugin.compiler.AbstractCompilerMojo;
import org.apache.maven.plugin.compiler.CompilationFailureException;
import org.apache.maven.plugin.compiler.DirectoryHierarchy;
import org.apache.maven.plugin.compiler.ModuleDirectoryRemover;
import org.apache.maven.plugin.compiler.Options;
import org.apache.maven.plugin.compiler.SourceDirectory;
import org.apache.maven.plugin.compiler.ToolExecutor;

@Mojo(name="compile", defaultPhase="compile")
public class CompilerMojo
extends AbstractCompilerMojo {
    @Parameter(property="maven.main.skip")
    protected boolean skipMain;
    @Parameter(defaultValue="${project.build.directory}/generated-sources/annotations")
    protected Path generatedSourcesDirectory;
    @Parameter
    protected Set<String> includes;
    @Parameter
    protected Set<String> excludes;
    @Parameter
    protected Set<String> incrementalExcludes;
    @Parameter(defaultValue="${project.build.outputDirectory}", required=true, readonly=true)
    protected Path outputDirectory;
    @Parameter(defaultValue="${project.mainArtifact}", readonly=true, required=true)
    protected ProducedArtifact projectArtifact;
    @Parameter
    @Deprecated(since="4.0.0")
    protected boolean multiReleaseOutput;
    @Parameter(defaultValue="javac.args")
    protected String debugFileName;
    @Deprecated(since="4.0.0")
    private ModuleDirectoryRemover directoryLevelToRemove;

    public CompilerMojo() {
        super(PathScope.MAIN_COMPILE);
    }

    @Override
    public void execute() throws MojoException {
        if (this.skipMain) {
            this.logger.info((CharSequence)"Not compiling main sources");
            return;
        }
        try {
            super.execute();
        }
        finally {
            try {
                ModuleDirectoryRemover r = this.directoryLevelToRemove;
                if (r != null) {
                    r.close();
                }
            }
            catch (IOException e) {
                throw new CompilationFailureException("I/O error while organizing multi-release classes.", e);
            }
        }
        Path outputDirectory = this.getOutputDirectory();
        if (Files.isDirectory(outputDirectory, new LinkOption[0]) && this.projectArtifact != null) {
            this.artifactManager.setPath(this.projectArtifact, outputDirectory);
        }
    }

    @Override
    public Options parseParameters(OptionChecker compiler) {
        Options configuration = super.parseParameters(compiler);
        configuration.addUnchecked(this.compilerArgs);
        configuration.addUnchecked(this.compilerArgument);
        return configuration;
    }

    @Override
    @Nullable
    protected Path getGeneratedSourcesDirectory() {
        return this.generatedSourcesDirectory;
    }

    @Override
    protected Set<String> getIncludes() {
        return this.includes != null ? this.includes : Set.of();
    }

    @Override
    protected Set<String> getExcludes() {
        return this.excludes != null ? this.excludes : Set.of();
    }

    @Override
    protected Set<String> getIncrementalExcludes() {
        return this.incrementalExcludes != null ? this.incrementalExcludes : Set.of();
    }

    @Override
    @Nonnull
    protected Path getOutputDirectory() {
        if (this.multiReleaseOutput && this.release != null) {
            return DirectoryHierarchy.PACKAGE.outputDirectoryForReleases(this.outputDirectory).resolve(this.release);
        }
        return this.outputDirectory;
    }

    @Override
    @Nullable
    protected String getDebugFileName() {
        return this.debugFileName;
    }

    @Override
    public ToolExecutor createExecutor(DiagnosticListener<? super JavaFileObject> listener) throws IOException {
        ToolExecutor executor = super.createExecutor(listener);
        if (this.multiReleaseOutput) {
            this.addImplicitDependencies(executor);
        }
        return executor;
    }

    @Override
    @Deprecated(since="4.0.0")
    final boolean hasModuleDeclaration(List<SourceDirectory> roots) throws IOException {
        String type;
        boolean hasModuleDeclaration = super.hasModuleDeclaration(roots);
        if (!hasModuleDeclaration && this.multiReleaseOutput && !"classpath-jar".equals(type = this.project.getPackaging().type().id())) {
            for (Path p : this.getOutputDirectoryPerVersion().values()) {
                if (!Files.exists(p = p.resolve("module-info.class"), new LinkOption[0])) continue;
                return true;
            }
        }
        return hasModuleDeclaration;
    }

    @Deprecated(since="4.0.0")
    private TreeMap<SourceVersion, Path> getOutputDirectoryPerVersion() throws IOException {
        Path root = DirectoryHierarchy.PACKAGE.outputDirectoryForReleases(this.outputDirectory);
        if (Files.notExists(root, new LinkOption[0])) {
            return null;
        }
        TreeMap<SourceVersion, Path> paths = new TreeMap<SourceVersion, Path>();
        Files.walk(root, 1, new FileVisitOption[0]).forEach(path -> {
            SourceVersion version;
            if (path.equals(root)) {
                path = this.outputDirectory;
                version = SourceVersion.RELEASE_0;
            } else {
                try {
                    version = SourceVersion.valueOf("RELEASE_" + String.valueOf(path.getFileName()));
                }
                catch (IllegalArgumentException e) {
                    throw new CompilationFailureException("Invalid version number for " + String.valueOf(path), e);
                }
            }
            if (paths.put(version, (Path)path) != null) {
                throw new CompilationFailureException("Duplicated version number for " + String.valueOf(path));
            }
        });
        return paths;
    }

    @Deprecated(since="4.0.0")
    private String addImplicitDependencies(ToolExecutor executor) throws IOException {
        TreeMap<SourceVersion, Path> paths = this.getOutputDirectoryPerVersion();
        String moduleName = null;
        for (Path path : paths.values()) {
            if (!Files.exists(path = path.resolve("module-info.class"), new LinkOption[0])) continue;
            try (InputStream in = Files.newInputStream(path, new OpenOption[0]);){
                moduleName = ModuleDescriptor.read(in).name();
                break;
            }
        }
        if (moduleName == null) {
            Path root;
            Stream<Path> sourceDirectories = executor != null ? executor.sourceDirectories.stream().map(dir -> dir.root) : (CompilerMojo.isAbsent(this.compileSourceRoots) ? this.getSourceRoots(this.compileScope.projectScope()).map(SourceRoot::directory) : this.compileSourceRoots.stream().map(x$0 -> Path.of(x$0, new String[0])));
            Iterator<Path> iterator = sourceDirectories.toList().iterator();
            while (iterator.hasNext() && (moduleName = this.parseModuleInfoName((root = iterator.next()).resolve("module-info.java"))) == null) {
            }
        }
        if (executor != null) {
            JavaPathType type = JavaPathType.CLASSES;
            if (moduleName != null) {
                type = JavaPathType.patchModule(moduleName);
                this.directoryLevelToRemove = ModuleDirectoryRemover.create(executor.outputDirectory, moduleName);
            }
            if (!paths.isEmpty()) {
                executor.dependencies((PathType)type).addAll(paths.descendingMap().values());
            }
        }
        return moduleName;
    }

    @Override
    @Deprecated(since="4.0.0")
    final String moduleOfPreviousExecution() throws IOException {
        if (this.multiReleaseOutput) {
            return this.addImplicitDependencies(null);
        }
        return super.moduleOfPreviousExecution();
    }
}

