/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.compiler;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.lang.module.ModuleDescriptor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.stream.Stream;
import javax.lang.model.SourceVersion;
import javax.tools.DiagnosticListener;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import org.apache.maven.plugin.compiler.AbstractCompilerMojo;
import org.apache.maven.plugin.compiler.CompilationFailureException;
import org.apache.maven.plugin.compiler.DirectoryHierarchy;
import org.apache.maven.plugin.compiler.ModuleDirectoryRemover;
import org.apache.maven.plugin.compiler.ModuleInfoPatch;
import org.apache.maven.plugin.compiler.ModuleInfoPatchException;
import org.apache.maven.plugin.compiler.Options;
import org.apache.maven.plugin.compiler.SourceDirectory;
import org.apache.maven.plugin.compiler.TestCompilerMojo;
import org.apache.maven.plugin.compiler.ToolExecutor;
import org.apache.maven.plugin.compiler.UnsupportedVersionException;

class ToolExecutorForTest
extends ToolExecutor {
    private final Path mainOutputDirectory;
    private final Map<String, Path> mainOutputDirectoryForModules;
    @Deprecated(since="4.0.0")
    private final boolean useModulePath;
    @Deprecated(since="4.0.0")
    private final boolean hasTestModuleInfo;
    @Deprecated(since="4.0.0")
    private String moduleNameFromPackageHierarchy;
    private boolean addedModuleOptions;
    @Deprecated(since="4.0.0")
    private String directoryLevelToRemove;

    ToolExecutorForTest(TestCompilerMojo mojo, DiagnosticListener<? super JavaFileObject> listener, Path mainModulePath) throws IOException {
        super(mojo, listener);
        String testModuleName;
        this.useModulePath = mojo.useModulePath;
        this.hasTestModuleInfo = mojo.hasTestModuleInfo;
        this.mainOutputDirectory = mojo.mainOutputDirectory;
        this.mainOutputDirectoryForModules = new HashMap<String, Path>();
        if (Files.notExists(this.mainOutputDirectory, new LinkOption[0])) {
            return;
        }
        if (mainModulePath != null) {
            try (InputStream in = Files.newInputStream(mainModulePath, new OpenOption[0]);){
                this.moduleNameFromPackageHierarchy = ModuleDescriptor.read(in).name();
            }
        }
        if ((testModuleName = mojo.moduleNameFromPackageHierarchy(this.sourceDirectories)) != null) {
            this.moduleNameFromPackageHierarchy = testModuleName;
        }
        LinkedHashMap<String, NavigableMap<SourceVersion, Path>> patchedModules = new LinkedHashMap<String, NavigableMap<SourceVersion, Path>>();
        for (SourceDirectory dir : this.sourceDirectories) {
            String moduleToPatch2 = dir.moduleName;
            if (moduleToPatch2 == null) {
                moduleToPatch2 = this.moduleNameFromPackageHierarchy;
                if (moduleToPatch2 == null) continue;
                this.directoryLevelToRemove = moduleToPatch2;
            }
            if (testModuleName != null && !moduleToPatch2.equals(testModuleName)) {
                throw new CompilationFailureException("The \"" + testModuleName + "\" module must be declared in a <module> element of <sources>.");
            }
            patchedModules.put(moduleToPatch2, new TreeMap());
        }
        if (patchedModules.isEmpty()) {
            return;
        }
        ToolExecutorForTest.addDirectoryIfModule(this.mainOutputDirectory, this.moduleNameFromPackageHierarchy, SourceVersion.RELEASE_0, patchedModules);
        this.addModuleDirectories(this.mainOutputDirectory, SourceVersion.RELEASE_0, patchedModules);
        Path versionsDirectory = DirectoryHierarchy.MODULE_SOURCE.outputDirectoryForReleases(this.mainOutputDirectory);
        if (Files.exists(versionsDirectory, new LinkOption[0])) {
            List<Path> asList;
            try (Stream<Path> paths = Files.list(versionsDirectory);){
                asList = paths.toList();
            }
            for (Path path : asList) {
                SourceVersion version;
                try {
                    version = SourceDirectory.parse(path.getFileName().toString());
                }
                catch (UnsupportedVersionException e) {
                    this.logger.debug((Throwable)((Object)e));
                    continue;
                }
                this.addModuleDirectories(path, version, patchedModules);
            }
        }
        patchedModules.forEach((moduleToPatch, directories) -> {
            Map.Entry base = directories.firstEntry();
            if (base != null) {
                this.mainOutputDirectoryForModules.putIfAbsent((String)moduleToPatch, (Path)base.getValue());
            }
        });
    }

    private void addModuleDirectories(Path directory, SourceVersion version, Map<String, NavigableMap<SourceVersion, Path>> addTo) throws IOException {
        try (Stream<Path> paths = Files.list(directory);){
            paths.forEach(path -> ToolExecutorForTest.addDirectoryIfModule(path, path.getFileName().toString(), version, addTo));
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
    }

    private static void addDirectoryIfModule(Path directory, String moduleName, SourceVersion version, Map<String, NavigableMap<SourceVersion, Path>> addTo) {
        NavigableMap<SourceVersion, Path> versions = addTo.get(moduleName);
        if (versions != null && Files.isRegularFile(directory.resolve("module-info.class"), new LinkOption[0])) {
            versions.putIfAbsent(version, directory);
        }
    }

    private void addModuleOptions(Options configuration) throws IOException {
        if (this.addedModuleOptions) {
            return;
        }
        this.addedModuleOptions = true;
        ModuleInfoPatch info = null;
        ModuleInfoPatch defaultInfo = null;
        LinkedHashMap<String, ModuleInfoPatch> patches = new LinkedHashMap<String, ModuleInfoPatch>();
        for (SourceDirectory sourceDirectory : this.sourceDirectories) {
            String moduleName;
            Path file = sourceDirectory.root.resolve("module-info-patch.maven");
            if (Files.notExists(file, new LinkOption[0])) {
                if (this.useModulePath && this.hasTestModuleInfo && this.hasModuleDeclaration || (moduleName = sourceDirectory.moduleName) == null && (moduleName = this.moduleNameFromPackageHierarchy) == null) continue;
                if (defaultInfo != null) {
                    patches.putIfAbsent(moduleName, null);
                    continue;
                }
                defaultInfo = new ModuleInfoPatch(moduleName, info);
                defaultInfo.setToDefaults();
                info = defaultInfo;
            } else {
                info = new ModuleInfoPatch(this.moduleNameFromPackageHierarchy, info);
                try (BufferedReader reader = Files.newBufferedReader(file);){
                    info.load(reader);
                }
                moduleName = info.getModuleName();
            }
            if (patches.put(moduleName, info) == null) continue;
            throw new ModuleInfoPatchException("\"module-info-patch " + moduleName + "\" is defined more than once.");
        }
        for (Map.Entry entry : patches.entrySet()) {
            info = (ModuleInfoPatch)entry.getValue();
            if (info != null) {
                info.replaceProjectModules(this.sourceDirectories);
                info.replaceTestModulePath(this.dependencyResolution);
                continue;
            }
            entry.setValue(defaultInfo.patchWithSameReads((String)entry.getKey()));
        }
        if (!patches.isEmpty()) {
            Path directory = Files.createDirectories(this.outputDirectory.resolve("META-INF").resolve("maven"), new FileAttribute[0]);
            try (BufferedWriter bufferedWriter = Files.newBufferedWriter(directory.resolve("module-info-patch.args"), new OpenOption[0]);){
                for (ModuleInfoPatch m : patches.values()) {
                    m.writeTo(configuration, bufferedWriter);
                }
            }
        }
    }

    @Override
    public boolean applyIncrementalBuild(AbstractCompilerMojo mojo, Options configuration) throws IOException {
        this.addModuleOptions(configuration);
        return super.applyIncrementalBuild(mojo, configuration);
    }

    @Override
    public boolean compile(JavaCompiler compiler, Options configuration, Writer otherOutput) throws IOException {
        this.addModuleOptions(configuration);
        try (ModuleDirectoryRemover r = ModuleDirectoryRemover.create(this.outputDirectory, this.directoryLevelToRemove);){
            boolean bl = super.compile(compiler, configuration, otherOutput);
            return bl;
        }
    }

    @Override
    Path getOutputDirectoryOfPreviousPhase() {
        return this.mainOutputDirectory;
    }

    @Override
    Path resolveModuleOutputDirectory(Path outputDirectory, String moduleName) {
        Path path;
        if (outputDirectory.equals(this.mainOutputDirectory) && (path = this.mainOutputDirectoryForModules.get(moduleName)) != null) {
            return path;
        }
        return super.resolveModuleOutputDirectory(outputDirectory, moduleName);
    }

    @Override
    @Deprecated(since="4.0.0")
    final String moduleNameFromPackageHierarchy() {
        return this.moduleNameFromPackageHierarchy;
    }
}

