/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.dependency.resolvers;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.model.Plugin;
import org.apache.maven.project.MavenProject;

class PluginsReactorExcludeFilter
implements Predicate<Plugin> {
    private final Set<String> reactorArtifactKeys;

    PluginsReactorExcludeFilter(List<MavenProject> reactorProjects) {
        this.reactorArtifactKeys = new LinkedHashSet<String>(reactorProjects.size());
        for (MavenProject project : reactorProjects) {
            this.reactorArtifactKeys.add(ArtifactUtils.key((Artifact)project.getArtifact()));
        }
    }

    @Override
    public boolean test(Plugin plugin) {
        String pluginKey = ArtifactUtils.key((String)plugin.getGroupId(), (String)plugin.getArtifactId(), (String)plugin.getVersion());
        return !this.reactorArtifactKeys.contains(pluginKey);
    }
}

