/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.pmd.exec;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugins.pmd.exec.CpdExecutor;
import org.apache.maven.plugins.pmd.exec.CpdRequest;
import org.apache.maven.plugins.pmd.exec.CpdResult;
import org.apache.maven.plugins.pmd.exec.ServiceExecutor;
import org.apache.maven.reporting.MavenReportException;
import org.apache.maven.toolchain.ToolchainManager;

@Named
@Singleton
public class CpdServiceExecutor
extends ServiceExecutor {
    @Inject
    public CpdServiceExecutor(ToolchainManager toolchainManager, Provider<MavenSession> sessionProvider) {
        super(toolchainManager, sessionProvider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CpdResult execute(CpdRequest request) throws MavenReportException {
        ClassLoader origLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(CpdExecutor.class.getClassLoader());
            CpdExecutor executor = new CpdExecutor(request);
            String javaExecutable = this.getJavaExecutable(request.getJdkToolchain());
            if (javaExecutable != null) {
                CpdResult cpdResult = executor.fork(javaExecutable);
                return cpdResult;
            }
            CpdResult cpdResult = executor.run();
            return cpdResult;
        }
        finally {
            Thread.currentThread().setContextClassLoader(origLoader);
        }
    }
}

