/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.fips;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.crypto.fips.DsaKCalculator;
import org.bouncycastle.crypto.fips.RandomDsaKCalculator;
import org.bouncycastle.crypto.internal.CipherParameters;
import org.bouncycastle.crypto.internal.DSA;
import org.bouncycastle.crypto.internal.params.DsaKeyParameters;
import org.bouncycastle.crypto.internal.params.DsaParameters;
import org.bouncycastle.crypto.internal.params.DsaPrivateKeyParameters;
import org.bouncycastle.crypto.internal.params.DsaPublicKeyParameters;
import org.bouncycastle.crypto.internal.params.ParametersWithRandom;

class DsaSigner
implements DSA {
    private final DsaKCalculator kCalculator;
    private DsaKeyParameters key;
    private SecureRandom random;

    public DsaSigner() {
        this.kCalculator = new RandomDsaKCalculator();
    }

    public DsaSigner(DsaKCalculator dsaKCalculator) {
        this.kCalculator = dsaKCalculator;
    }

    public void init(boolean bl, CipherParameters cipherParameters) {
        if (bl) {
            if (cipherParameters instanceof ParametersWithRandom) {
                ParametersWithRandom parametersWithRandom = (ParametersWithRandom)cipherParameters;
                this.random = parametersWithRandom.getRandom();
                this.key = (DsaPrivateKeyParameters)parametersWithRandom.getParameters();
            } else if (this.kCalculator instanceof RandomDsaKCalculator) {
                throw new IllegalArgumentException("No random provided where one required.");
            }
        } else {
            this.key = (DsaPublicKeyParameters)cipherParameters;
        }
    }

    public BigInteger[] generateSignature(byte[] byArray) {
        DsaParameters dsaParameters = this.key.getParameters();
        BigInteger bigInteger = this.calculateE(dsaParameters.getQ(), byArray);
        if (this.kCalculator.isDeterministic()) {
            this.kCalculator.init(dsaParameters.getQ(), ((DsaPrivateKeyParameters)this.key).getX(), byArray);
        } else {
            this.kCalculator.init(dsaParameters.getQ(), this.random);
        }
        BigInteger bigInteger2 = this.kCalculator.nextK();
        BigInteger bigInteger3 = dsaParameters.getG().modPow(bigInteger2, dsaParameters.getP()).mod(dsaParameters.getQ());
        bigInteger2 = bigInteger2.modInverse(dsaParameters.getQ()).multiply(bigInteger.add(((DsaPrivateKeyParameters)this.key).getX().multiply(bigInteger3)));
        BigInteger bigInteger4 = bigInteger2.mod(dsaParameters.getQ());
        BigInteger[] bigIntegerArray = new BigInteger[]{bigInteger3, bigInteger4};
        return bigIntegerArray;
    }

    public boolean verifySignature(byte[] byArray, BigInteger bigInteger, BigInteger bigInteger2) {
        DsaParameters dsaParameters = this.key.getParameters();
        BigInteger bigInteger3 = this.calculateE(dsaParameters.getQ(), byArray);
        BigInteger bigInteger4 = BigInteger.valueOf(0L);
        if (bigInteger4.compareTo(bigInteger) >= 0 || dsaParameters.getQ().compareTo(bigInteger) <= 0) {
            return false;
        }
        if (bigInteger4.compareTo(bigInteger2) >= 0 || dsaParameters.getQ().compareTo(bigInteger2) <= 0) {
            return false;
        }
        BigInteger bigInteger5 = bigInteger2.modInverse(dsaParameters.getQ());
        BigInteger bigInteger6 = bigInteger3.multiply(bigInteger5).mod(dsaParameters.getQ());
        BigInteger bigInteger7 = bigInteger.multiply(bigInteger5).mod(dsaParameters.getQ());
        bigInteger6 = dsaParameters.getG().modPow(bigInteger6, dsaParameters.getP());
        bigInteger7 = ((DsaPublicKeyParameters)this.key).getY().modPow(bigInteger7, dsaParameters.getP());
        BigInteger bigInteger8 = bigInteger6.multiply(bigInteger7).mod(dsaParameters.getP()).mod(dsaParameters.getQ());
        return bigInteger8.equals(bigInteger);
    }

    private BigInteger calculateE(BigInteger bigInteger, byte[] byArray) {
        if (bigInteger.bitLength() >= byArray.length * 8) {
            return new BigInteger(1, byArray);
        }
        byte[] byArray2 = new byte[bigInteger.bitLength() / 8];
        System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
        return new BigInteger(1, byArray2);
    }
}

