/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.fips;

import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.crypto.AuthenticationParameters;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.IllegalKeyException;
import org.bouncycastle.crypto.SymmetricKey;
import org.bouncycastle.crypto.SymmetricSecretKey;
import org.bouncycastle.crypto.UpdateOutputStream;
import org.bouncycastle.crypto.fips.FipsAlgorithm;
import org.bouncycastle.crypto.fips.FipsDigestAlgorithm;
import org.bouncycastle.crypto.fips.FipsDigestOperatorFactory;
import org.bouncycastle.crypto.fips.FipsEngineProvider;
import org.bouncycastle.crypto.fips.FipsMACOperatorFactory;
import org.bouncycastle.crypto.fips.FipsOutputDigestCalculator;
import org.bouncycastle.crypto.fips.FipsOutputXOFCalculator;
import org.bouncycastle.crypto.fips.FipsParameters;
import org.bouncycastle.crypto.fips.FipsSymmetricKeyGenerator;
import org.bouncycastle.crypto.fips.FipsXOFOperatorFactory;
import org.bouncycastle.crypto.fips.PrivilegedUtils;
import org.bouncycastle.crypto.fips.SHA1Digest;
import org.bouncycastle.crypto.fips.SHA224Digest;
import org.bouncycastle.crypto.fips.SHA256Digest;
import org.bouncycastle.crypto.fips.SHA384Digest;
import org.bouncycastle.crypto.fips.SHA3Digest;
import org.bouncycastle.crypto.fips.SHA512Digest;
import org.bouncycastle.crypto.fips.SHA512tDigest;
import org.bouncycastle.crypto.fips.SHAKEDigest;
import org.bouncycastle.crypto.fips.SelfTestExecutor;
import org.bouncycastle.crypto.fips.Utils;
import org.bouncycastle.crypto.general.FipsRegister;
import org.bouncycastle.crypto.internal.CipherKeyGenerator;
import org.bouncycastle.crypto.internal.Digest;
import org.bouncycastle.crypto.internal.ExtendedDigest;
import org.bouncycastle.crypto.internal.KeyGenerationParameters;
import org.bouncycastle.crypto.internal.Mac;
import org.bouncycastle.crypto.internal.ValidatedSymmetricKey;
import org.bouncycastle.crypto.internal.Xof;
import org.bouncycastle.crypto.internal.io.DigestOutputStream;
import org.bouncycastle.crypto.internal.io.XofOutputStream;
import org.bouncycastle.crypto.internal.macs.HMac;
import org.bouncycastle.crypto.internal.macs.TruncatingMac;
import org.bouncycastle.crypto.internal.params.KeyParameter;
import org.bouncycastle.crypto.internal.params.KeyParameterImpl;
import org.bouncycastle.crypto.internal.test.BasicKatTest;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Strings;
import org.bouncycastle.util.encoders.Hex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FipsSHS {
    private static final int MIN_APPROVED_KEY_SIZE = 112;
    private static final Map<FipsAlgorithm, Integer> defaultMacSize = new HashMap<FipsAlgorithm, Integer>();
    private static Map<FipsAlgorithm, FipsEngineProvider<Digest>> digests = new HashMap<FipsAlgorithm, FipsEngineProvider<Digest>>();
    private static Map<FipsAlgorithm, FipsEngineProvider<Mac>> hMacs = new HashMap<FipsAlgorithm, FipsEngineProvider<Mac>>();
    public static final Parameters SHA1;
    public static final AuthParameters SHA1_HMAC;
    public static final Parameters SHA224;
    public static final AuthParameters SHA224_HMAC;
    public static final Parameters SHA256;
    public static final AuthParameters SHA256_HMAC;
    public static final Parameters SHA384;
    public static final AuthParameters SHA384_HMAC;
    public static final Parameters SHA512;
    public static final AuthParameters SHA512_HMAC;
    public static final Parameters SHA512_224;
    public static final AuthParameters SHA512_224_HMAC;
    public static final Parameters SHA512_256;
    public static final AuthParameters SHA512_256_HMAC;
    public static final Parameters SHA3_224;
    public static final Parameters SHA3_256;
    public static final Parameters SHA3_384;
    public static final Parameters SHA3_512;
    public static final Parameters SHAKE128;
    public static final Parameters SHAKE256;

    private FipsSHS() {
    }

    static DigestCloner<ExtendedDigest> createCloner(FipsAlgorithm fipsAlgorithm) {
        switch ((Variations)fipsAlgorithm.basicVariation()) {
            case SHA1: {
                return new DigestCloner<ExtendedDigest>(){

                    @Override
                    public ExtendedDigest makeDigest(ExtendedDigest extendedDigest) {
                        if (extendedDigest != null) {
                            return new SHA1Digest((SHA1Digest)extendedDigest);
                        }
                        return new SHA1Digest();
                    }
                };
            }
            case SHA224: {
                return new DigestCloner<ExtendedDigest>(){

                    @Override
                    public ExtendedDigest makeDigest(ExtendedDigest extendedDigest) {
                        if (extendedDigest != null) {
                            return new SHA224Digest((SHA224Digest)extendedDigest);
                        }
                        return new SHA224Digest();
                    }
                };
            }
            case SHA256: {
                return new DigestCloner<ExtendedDigest>(){

                    @Override
                    public ExtendedDigest makeDigest(ExtendedDigest extendedDigest) {
                        if (extendedDigest != null) {
                            return new SHA256Digest((SHA256Digest)extendedDigest);
                        }
                        return new SHA256Digest();
                    }
                };
            }
            case SHA384: {
                return new DigestCloner<ExtendedDigest>(){

                    @Override
                    public ExtendedDigest makeDigest(ExtendedDigest extendedDigest) {
                        if (extendedDigest != null) {
                            return new SHA384Digest((SHA384Digest)extendedDigest);
                        }
                        return new SHA384Digest();
                    }
                };
            }
            case SHA512: {
                return new DigestCloner<ExtendedDigest>(){

                    @Override
                    public ExtendedDigest makeDigest(ExtendedDigest extendedDigest) {
                        if (extendedDigest != null) {
                            return new SHA512Digest((SHA512Digest)extendedDigest);
                        }
                        return new SHA512Digest();
                    }
                };
            }
            case SHA512_224: {
                return new DigestCloner<ExtendedDigest>(){

                    @Override
                    public ExtendedDigest makeDigest(ExtendedDigest extendedDigest) {
                        if (extendedDigest != null) {
                            return new SHA512tDigest((SHA512tDigest)extendedDigest);
                        }
                        return new SHA512tDigest(224);
                    }
                };
            }
            case SHA512_256: {
                return new DigestCloner<ExtendedDigest>(){

                    @Override
                    public ExtendedDigest makeDigest(ExtendedDigest extendedDigest) {
                        if (extendedDigest != null) {
                            return new SHA512tDigest((SHA512tDigest)extendedDigest);
                        }
                        return new SHA512tDigest(256);
                    }
                };
            }
            case SHA3_224: {
                return new DigestCloner<ExtendedDigest>(){

                    @Override
                    public ExtendedDigest makeDigest(ExtendedDigest extendedDigest) {
                        if (extendedDigest != null) {
                            return new SHA3Digest((SHA3Digest)extendedDigest);
                        }
                        return new SHA3Digest(224);
                    }
                };
            }
            case SHA3_256: {
                return new DigestCloner<ExtendedDigest>(){

                    @Override
                    public ExtendedDigest makeDigest(ExtendedDigest extendedDigest) {
                        if (extendedDigest != null) {
                            return new SHA3Digest((SHA3Digest)extendedDigest);
                        }
                        return new SHA3Digest(256);
                    }
                };
            }
            case SHA3_384: {
                return new DigestCloner<ExtendedDigest>(){

                    @Override
                    public ExtendedDigest makeDigest(ExtendedDigest extendedDigest) {
                        if (extendedDigest != null) {
                            return new SHA3Digest((SHA3Digest)extendedDigest);
                        }
                        return new SHA3Digest(384);
                    }
                };
            }
            case SHA3_512: {
                return new DigestCloner<ExtendedDigest>(){

                    @Override
                    public ExtendedDigest makeDigest(ExtendedDigest extendedDigest) {
                        if (extendedDigest != null) {
                            return new SHA3Digest((SHA3Digest)extendedDigest);
                        }
                        return new SHA3Digest(512);
                    }
                };
            }
        }
        throw new IllegalArgumentException("Unknown algorithm passed to FipsSHS.OperatorFactory.createOutputDigestCalculator: " + fipsAlgorithm.getName());
    }

    private static Digest makeValidatedDigest(FipsAlgorithm fipsAlgorithm, BasicKatTest<Digest> basicKatTest) {
        return SelfTestExecutor.validate(fipsAlgorithm, FipsSHS.createCloner(fipsAlgorithm).makeDigest(null), basicKatTest);
    }

    private static Xof makeValidatedXof(FipsAlgorithm fipsAlgorithm) {
        if (fipsAlgorithm == Algorithm.SHAKE128) {
            return SelfTestExecutor.validate(fipsAlgorithm, new SHAKEDigest(128), new ShaKatTest(Hex.decode("5881092dd818bf5cf8a3ddb793fbcba7")));
        }
        if (fipsAlgorithm == Algorithm.SHAKE256) {
            return SelfTestExecutor.validate(fipsAlgorithm, new SHAKEDigest(256), new ShaKatTest(Hex.decode("483366601360a8771c6863080cc4114d8db44530f8f1e1ee4f94ea37e78b5739")));
        }
        throw new IllegalArgumentException("Unknown extendable output function requested: " + fipsAlgorithm.getName());
    }

    static Digest createDigest(FipsAlgorithm fipsAlgorithm) {
        return (Digest)digests.get(fipsAlgorithm).createEngine();
    }

    private static Mac makeValidatedHMac(FipsAlgorithm fipsAlgorithm, BasicKatTest<Mac> basicKatTest) {
        HMac hMac;
        switch ((Variations)fipsAlgorithm.basicVariation()) {
            case SHA1_HMAC: {
                hMac = new HMac(new SHA1Digest());
                break;
            }
            case SHA224_HMAC: {
                hMac = new HMac(new SHA224Digest());
                break;
            }
            case SHA256_HMAC: {
                hMac = new HMac(new SHA256Digest());
                break;
            }
            case SHA384_HMAC: {
                hMac = new HMac(new SHA384Digest());
                break;
            }
            case SHA512_HMAC: {
                hMac = new HMac(new SHA512Digest());
                break;
            }
            case SHA512_224_HMAC: {
                hMac = new HMac(new SHA512tDigest(224));
                break;
            }
            case SHA512_256_HMAC: {
                hMac = new HMac(new SHA512tDigest(256));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown algorithm passed to FipsSHS.OperatorFactory.createOutputMACCalculator: " + fipsAlgorithm.getName());
            }
        }
        return SelfTestExecutor.validate(fipsAlgorithm, hMac, basicKatTest);
    }

    static FipsEngineProvider<Mac> getMacProvider(FipsAlgorithm fipsAlgorithm) {
        return hMacs.get(fipsAlgorithm);
    }

    static Mac createHMac(FipsAlgorithm fipsAlgorithm) {
        return (Mac)FipsSHS.getMacProvider(fipsAlgorithm).createEngine();
    }

    static {
        defaultMacSize.put(Algorithm.SHA1_HMAC, 160);
        defaultMacSize.put(Algorithm.SHA224_HMAC, 224);
        defaultMacSize.put(Algorithm.SHA256_HMAC, 256);
        defaultMacSize.put(Algorithm.SHA384_HMAC, 384);
        defaultMacSize.put(Algorithm.SHA512_HMAC, 512);
        defaultMacSize.put(Algorithm.SHA512_224_HMAC, 224);
        defaultMacSize.put(Algorithm.SHA512_256_HMAC, 256);
        digests.put(Algorithm.SHA1, new FipsEngineProvider<Digest>(){

            @Override
            public Digest createEngine() {
                return FipsSHS.makeValidatedDigest(Algorithm.SHA1, new ShaKatTest(Hex.decode("a9993e364706816aba3e25717850c26c9cd0d89d")));
            }
        });
        digests.put(Algorithm.SHA224, new FipsEngineProvider<Digest>(){

            @Override
            public Digest createEngine() {
                return FipsSHS.makeValidatedDigest(Algorithm.SHA224, new ShaKatTest(Hex.decode("23097d223405d8228642a477bda255b32aadbce4bda0b3f7e36c9da7")));
            }
        });
        digests.put(Algorithm.SHA256, new FipsEngineProvider<Digest>(){

            @Override
            public Digest createEngine() {
                return FipsSHS.makeValidatedDigest(Algorithm.SHA256, new ShaKatTest(Hex.decode("ba7816bf8f01cfea414140de5dae2223b00361a396177a9cb410ff61f20015ad")));
            }
        });
        digests.put(Algorithm.SHA384, new FipsEngineProvider<Digest>(){

            @Override
            public Digest createEngine() {
                return FipsSHS.makeValidatedDigest(Algorithm.SHA384, new ShaKatTest(Hex.decode("cb00753f45a35e8bb5a03d699ac65007272c32ab0eded1631a8b605a43ff5bed8086072ba1e7cc2358baeca134c825a7")));
            }
        });
        digests.put(Algorithm.SHA512, new FipsEngineProvider<Digest>(){

            @Override
            public Digest createEngine() {
                return FipsSHS.makeValidatedDigest(Algorithm.SHA512, new ShaKatTest(Hex.decode("ddaf35a193617abacc417349ae20413112e6fa4e89a97ea20a9eeee64b55d39a2192992a274fc1a836ba3c23a3feebbd454d4423643ce80e2a9ac94fa54ca49f")));
            }
        });
        digests.put(Algorithm.SHA512_224, new FipsEngineProvider<Digest>(){

            @Override
            public Digest createEngine() {
                return FipsSHS.makeValidatedDigest(Algorithm.SHA512_224, new ShaKatTest(Hex.decode("4634270F707B6A54DAAE7530460842E20E37ED265CEEE9A43E8924AA")));
            }
        });
        digests.put(Algorithm.SHA512_256, new FipsEngineProvider<Digest>(){

            @Override
            public Digest createEngine() {
                return FipsSHS.makeValidatedDigest(Algorithm.SHA512_256, new ShaKatTest(Hex.decode("53048E2681941EF99B2E29B76B4C7DABE4C2D0C634FC6D46E0E2F13107E7AF23")));
            }
        });
        digests.put(Algorithm.SHA3_224, new FipsEngineProvider<Digest>(){

            @Override
            public Digest createEngine() {
                return FipsSHS.makeValidatedDigest(Algorithm.SHA3_224, new ShaKatTest(Hex.decode("e642824c3f8cf24ad09234ee7d3c766fc9a3a5168d0c94ad73b46fdf")));
            }
        });
        digests.put(Algorithm.SHA3_256, new FipsEngineProvider<Digest>(){

            @Override
            public Digest createEngine() {
                return FipsSHS.makeValidatedDigest(Algorithm.SHA3_256, new ShaKatTest(Hex.decode("3a985da74fe225b2045c172d6bd390bd855f086e3e9d525b46bfe24511431532")));
            }
        });
        digests.put(Algorithm.SHA3_384, new FipsEngineProvider<Digest>(){

            @Override
            public Digest createEngine() {
                return FipsSHS.makeValidatedDigest(Algorithm.SHA3_384, new ShaKatTest(Hex.decode("ec01498288516fc926459f58e2c6ad8df9b473cb0fc08c2596da7cf0e49be4b298d88cea927ac7f539f1edf228376d25")));
            }
        });
        digests.put(Algorithm.SHA3_512, new FipsEngineProvider<Digest>(){

            @Override
            public Digest createEngine() {
                return FipsSHS.makeValidatedDigest(Algorithm.SHA3_512, new ShaKatTest(Hex.decode("b751850b1a57168a5693cd924b6b096e08f621827444f70d884f5d0240d2712e10e116e9192af3c91a7ec57647e3934057340b4cf408d5a56592f8274eec53f0")));
            }
        });
        hMacs.put(Algorithm.SHA1_HMAC, new FipsEngineProvider<Mac>(){

            @Override
            public Mac createEngine() {
                return FipsSHS.makeValidatedHMac(Algorithm.SHA1_HMAC, new HMacKatTest(Hex.decode("effcdf6ae5eb2fa2d27416d5f184df9c259a7c79")));
            }
        });
        hMacs.put(Algorithm.SHA224_HMAC, new FipsEngineProvider<Mac>(){

            @Override
            public Mac createEngine() {
                return FipsSHS.makeValidatedHMac(Algorithm.SHA224_HMAC, new HMacKatTest(Hex.decode("a30e01098bc6dbbf45690f3a7e9e6d0f8bbea2a39e6148008fd05e44")));
            }
        });
        hMacs.put(Algorithm.SHA256_HMAC, new FipsEngineProvider<Mac>(){

            @Override
            public Mac createEngine() {
                return FipsSHS.makeValidatedHMac(Algorithm.SHA256_HMAC, new HMacKatTest(Hex.decode("5bdcc146bf60754e6a042426089575c75a003f089d2739839dec58b964ec3843")));
            }
        });
        hMacs.put(Algorithm.SHA384_HMAC, new FipsEngineProvider<Mac>(){

            @Override
            public Mac createEngine() {
                return FipsSHS.makeValidatedHMac(Algorithm.SHA384_HMAC, new HMacKatTest(Hex.decode("af45d2e376484031617f78d2b58a6b1b9c7ef464f5a01b47e42ec3736322445e8e2240ca5e69e2c78b3239ecfab21649")));
            }
        });
        hMacs.put(Algorithm.SHA512_HMAC, new FipsEngineProvider<Mac>(){

            @Override
            public Mac createEngine() {
                return FipsSHS.makeValidatedHMac(Algorithm.SHA512_HMAC, new HMacKatTest(Hex.decode("164b7a7bfcf819e2e395fbe73b56e0a387bd64222e831fd610270cd7ea2505549758bf75c05a994a6d034f65f8f0e6fdcaeab1a34d4a6b4b636e070a38bce737")));
            }
        });
        hMacs.put(Algorithm.SHA512_224_HMAC, new FipsEngineProvider<Mac>(){

            @Override
            public Mac createEngine() {
                return FipsSHS.makeValidatedHMac(Algorithm.SHA512_224_HMAC, new HMacKatTest(Hex.decode("4a530b31a79ebcce36916546317c45f247d83241dfb818fd37254bde")));
            }
        });
        hMacs.put(Algorithm.SHA512_256_HMAC, new FipsEngineProvider<Mac>(){

            @Override
            public Mac createEngine() {
                return FipsSHS.makeValidatedHMac(Algorithm.SHA512_256_HMAC, new HMacKatTest(Hex.decode("6df7b24630d5ccb2ee335407081a87188c221489768fa2020513b2d593359456")));
            }
        });
        for (FipsAlgorithm fipsAlgorithm : digests.keySet()) {
            digests.get(fipsAlgorithm).createEngine();
        }
        for (FipsAlgorithm fipsAlgorithm : hMacs.keySet()) {
            hMacs.get(fipsAlgorithm).createEngine();
        }
        FipsSHS.makeValidatedXof(Algorithm.SHAKE128);
        FipsSHS.makeValidatedXof(Algorithm.SHAKE256);
        for (FipsAlgorithm fipsAlgorithm : digests.keySet()) {
            FipsRegister.registerEngineProvider(fipsAlgorithm, digests.get(fipsAlgorithm));
        }
        for (FipsAlgorithm fipsAlgorithm : hMacs.keySet()) {
            FipsRegister.registerEngineProvider(fipsAlgorithm, hMacs.get(fipsAlgorithm));
        }
        SHA1 = new Parameters(Algorithm.SHA1);
        SHA1_HMAC = new AuthParameters(Algorithm.SHA1_HMAC);
        SHA224 = new Parameters(Algorithm.SHA224);
        SHA224_HMAC = new AuthParameters(Algorithm.SHA224_HMAC);
        SHA256 = new Parameters(Algorithm.SHA256);
        SHA256_HMAC = new AuthParameters(Algorithm.SHA256_HMAC);
        SHA384 = new Parameters(Algorithm.SHA384);
        SHA384_HMAC = new AuthParameters(Algorithm.SHA384_HMAC);
        SHA512 = new Parameters(Algorithm.SHA512);
        SHA512_HMAC = new AuthParameters(Algorithm.SHA512_HMAC);
        SHA512_224 = new Parameters(Algorithm.SHA512_224);
        SHA512_224_HMAC = new AuthParameters(Algorithm.SHA512_224_HMAC);
        SHA512_256 = new Parameters(Algorithm.SHA512_256);
        SHA512_256_HMAC = new AuthParameters(Algorithm.SHA512_256_HMAC);
        SHA3_224 = new Parameters(Algorithm.SHA3_224);
        SHA3_256 = new Parameters(Algorithm.SHA3_256);
        SHA3_384 = new Parameters(Algorithm.SHA3_384);
        SHA3_512 = new Parameters(Algorithm.SHA3_512);
        SHAKE128 = new Parameters(Algorithm.SHAKE128);
        SHAKE256 = new Parameters(Algorithm.SHAKE256);
    }

    public static final class Algorithm {
        public static final FipsDigestAlgorithm SHA1 = new FipsDigestAlgorithm("SHA-1", (Enum)Variations.SHA1);
        public static final FipsDigestAlgorithm SHA1_HMAC = new FipsDigestAlgorithm("SHA-1/HMAC", (Enum)Variations.SHA1_HMAC);
        public static final FipsDigestAlgorithm SHA224 = new FipsDigestAlgorithm("SHA-224", (Enum)Variations.SHA224);
        public static final FipsDigestAlgorithm SHA224_HMAC = new FipsDigestAlgorithm("SHA-224/HMAC", (Enum)Variations.SHA224_HMAC);
        public static final FipsDigestAlgorithm SHA256 = new FipsDigestAlgorithm("SHA-256", (Enum)Variations.SHA256);
        public static final FipsDigestAlgorithm SHA256_HMAC = new FipsDigestAlgorithm("SHA-256/HMAC", (Enum)Variations.SHA256_HMAC);
        public static final FipsDigestAlgorithm SHA384 = new FipsDigestAlgorithm("SHA-384", (Enum)Variations.SHA384);
        public static final FipsDigestAlgorithm SHA384_HMAC = new FipsDigestAlgorithm("SHA-384/HMAC", (Enum)Variations.SHA384_HMAC);
        public static final FipsDigestAlgorithm SHA512 = new FipsDigestAlgorithm("SHA-512", (Enum)Variations.SHA512);
        public static final FipsDigestAlgorithm SHA512_HMAC = new FipsDigestAlgorithm("SHA-512/HMAC", (Enum)Variations.SHA512_HMAC);
        public static final FipsDigestAlgorithm SHA512_224 = new FipsDigestAlgorithm("SHA-512(224)", (Enum)Variations.SHA512_224);
        public static final FipsDigestAlgorithm SHA512_224_HMAC = new FipsDigestAlgorithm("SHA-512(224)/HMAC", (Enum)Variations.SHA512_224_HMAC);
        public static final FipsDigestAlgorithm SHA512_256 = new FipsDigestAlgorithm("SHA-512(256)", (Enum)Variations.SHA512_256);
        public static final FipsDigestAlgorithm SHA512_256_HMAC = new FipsDigestAlgorithm("SHA-512(256)/HMAC", (Enum)Variations.SHA512_256_HMAC);
        public static final FipsDigestAlgorithm SHA3_224 = new FipsDigestAlgorithm("SHA3-224", (Enum)Variations.SHA3_224);
        public static final FipsDigestAlgorithm SHA3_256 = new FipsDigestAlgorithm("SHA3-256", (Enum)Variations.SHA3_256);
        public static final FipsDigestAlgorithm SHA3_384 = new FipsDigestAlgorithm("SHA3-384", (Enum)Variations.SHA3_384);
        public static final FipsDigestAlgorithm SHA3_512 = new FipsDigestAlgorithm("SHA3-512", (Enum)Variations.SHA3_512);
        public static final FipsAlgorithm SHAKE128 = new FipsAlgorithm("SHAKE128");
        public static final FipsAlgorithm SHAKE256 = new FipsAlgorithm("SHAKE256");

        private Algorithm() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class AuthParameters
    extends FipsParameters
    implements AuthenticationParameters<AuthParameters> {
        private final int macSizeInBits;

        private AuthParameters(FipsAlgorithm fipsAlgorithm, int n) {
            super(fipsAlgorithm);
            this.macSizeInBits = n;
        }

        AuthParameters(FipsAlgorithm fipsAlgorithm) {
            this(fipsAlgorithm, (Integer)defaultMacSize.get(fipsAlgorithm));
        }

        @Override
        public int getMACSizeInBits() {
            return this.macSizeInBits;
        }

        @Override
        public AuthParameters withMACSize(int n) {
            return new AuthParameters(this.getAlgorithm(), n);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface DigestCloner<D extends ExtendedDigest> {
        public D makeDigest(D var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class HMacKatTest
    implements BasicKatTest<Mac> {
        private static final byte[] stdHMacVector = Strings.toByteArray("what do ya want for nothing?");
        private static final byte[] key = Hex.decode("4a656665");
        private final byte[] kat;

        HMacKatTest(byte[] byArray) {
            this.kat = byArray;
        }

        @Override
        public boolean hasTestPassed(Mac mac) {
            mac.init(new KeyParameterImpl(Arrays.clone(key)));
            mac.update(stdHMacVector, 0, stdHMacVector.length);
            byte[] byArray = new byte[mac.getMacSize()];
            mac.doFinal(byArray, 0);
            return Arrays.areEqual(byArray, this.kat);
        }
    }

    public static final class KeyGenerator
    extends FipsSymmetricKeyGenerator {
        private final FipsAlgorithm algorithm;
        private final int keySizeInBits;
        private final SecureRandom random;

        public KeyGenerator(FipsAlgorithm fipsAlgorithm, int n, SecureRandom secureRandom) {
            if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
                if (n < 112) {
                    throw new IllegalArgumentException("Key size for HMAC must be at least 112 bits in approved mode: " + fipsAlgorithm.getName());
                }
                Utils.validateKeyGenRandom(secureRandom, 112, fipsAlgorithm);
            }
            this.algorithm = fipsAlgorithm;
            this.keySizeInBits = n;
            this.random = secureRandom;
        }

        public SymmetricKey generateKey() {
            CipherKeyGenerator cipherKeyGenerator = new CipherKeyGenerator();
            cipherKeyGenerator.init(new KeyGenerationParameters(this.random, this.keySizeInBits));
            return new SymmetricSecretKey(this.algorithm, cipherKeyGenerator.generateKey());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LocalFipsOutputDigestCalculator<T extends Parameters>
    extends FipsOutputDigestCalculator<T>
    implements Cloneable {
        private final ExtendedDigest digest;
        private final T parameter;
        private final DigestCloner<ExtendedDigest> cloner;

        private LocalFipsOutputDigestCalculator(T t, DigestCloner<ExtendedDigest> digestCloner) {
            this(t, null, digestCloner);
        }

        private LocalFipsOutputDigestCalculator(T t, ExtendedDigest extendedDigest, DigestCloner<ExtendedDigest> digestCloner) {
            this.digest = digestCloner.makeDigest(extendedDigest);
            this.parameter = t;
            this.cloner = digestCloner;
        }

        @Override
        public T getParameters() {
            return this.parameter;
        }

        @Override
        public int getDigestSize() {
            return this.digest.getDigestSize();
        }

        @Override
        public int getDigestBlockSize() {
            return this.digest.getByteLength();
        }

        @Override
        public UpdateOutputStream getDigestStream() {
            return new DigestOutputStream(this.digest);
        }

        @Override
        public int getDigest(byte[] byArray, int n) {
            return this.digest.doFinal(byArray, n);
        }

        @Override
        public void reset() {
            this.digest.reset();
        }

        @Override
        public FipsOutputDigestCalculator<T> clone() throws CloneNotSupportedException {
            return new LocalFipsOutputDigestCalculator<T>(this.parameter, this.digest, this.cloner);
        }

        /* synthetic */ LocalFipsOutputDigestCalculator(Parameters parameters, DigestCloner digestCloner, 1 var3_3) {
            this(parameters, digestCloner);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class MACOperatorFactory
    extends FipsMACOperatorFactory<AuthParameters> {
        @Override
        protected int calculateMACSize(AuthParameters authParameters) {
            return authParameters.getMACSizeInBits() / 8;
        }

        @Override
        protected Mac createMAC(SymmetricKey symmetricKey, AuthParameters authParameters) {
            ValidatedSymmetricKey validatedSymmetricKey = PrivilegedUtils.getValidatedKey(symmetricKey);
            Mac mac = FipsSHS.createHMac(authParameters.getAlgorithm());
            if (mac.getMacSize() != (authParameters.getMACSizeInBits() + 7) / 8) {
                mac = new TruncatingMac(mac, authParameters.macSizeInBits);
            }
            KeyParameter keyParameter = Utils.getKeyParameter(validatedSymmetricKey);
            if (CryptoServicesRegistrar.isInApprovedOnlyMode() && keyParameter.getKey().length * 8 < 112) {
                throw new IllegalKeyException("Key size for HMAC must be at least 112 bits in approved mode: " + authParameters.getAlgorithm().getName());
            }
            mac.init(keyParameter);
            return mac;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class OperatorFactory<T extends Parameters>
    extends FipsDigestOperatorFactory<T> {
        @Override
        public FipsOutputDigestCalculator<T> createOutputDigestCalculator(T t) {
            return new LocalFipsOutputDigestCalculator((Parameters)t, FipsSHS.createCloner(((FipsParameters)t).getAlgorithm()), null);
        }
    }

    public static final class Parameters
    extends FipsParameters {
        Parameters(FipsAlgorithm fipsAlgorithm) {
            super(fipsAlgorithm);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ShaKatTest<T extends Digest>
    implements BasicKatTest<T> {
        private static final byte[] stdShaVector = Strings.toByteArray("abc");
        private final byte[] kat;

        ShaKatTest(byte[] byArray) {
            this.kat = byArray;
        }

        @Override
        public boolean hasTestPassed(Digest digest) {
            digest.update(stdShaVector, 0, stdShaVector.length);
            byte[] byArray = new byte[digest.getDigestSize()];
            digest.doFinal(byArray, 0);
            digest.reset();
            return Arrays.areEqual(byArray, this.kat);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Variations {
        SHA1,
        SHA1_HMAC,
        SHA224,
        SHA224_HMAC,
        SHA256,
        SHA256_HMAC,
        SHA384,
        SHA384_HMAC,
        SHA512,
        SHA512_HMAC,
        SHA512_224,
        SHA512_224_HMAC,
        SHA512_256,
        SHA512_256_HMAC,
        SHA3_224,
        SHA3_256,
        SHA3_384,
        SHA3_512;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class XOFOperatorFactory<T extends Parameters>
    extends FipsXOFOperatorFactory<T> {
        @Override
        public FipsOutputXOFCalculator<T> createOutputXOFCalculator(T t) {
            return new LocalFipsOutputXOFCalculator(this, t, FipsSHS.makeValidatedXof(((FipsParameters)t).getAlgorithm()));
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class LocalFipsOutputXOFCalculator<T extends Parameters>
        extends FipsOutputXOFCalculator {
            private final T parameters;
            private final XofOutputStream xofStream;
            private boolean isOutputing;
            final /* synthetic */ XOFOperatorFactory this$0;

            public LocalFipsOutputXOFCalculator(T t, Xof xof) {
                this.this$0 = var1_1;
                this.parameters = t;
                this.xofStream = new XofOutputStream(xof);
            }

            @Override
            public T getParameters() {
                return this.parameters;
            }

            @Override
            public UpdateOutputStream getFunctionStream() {
                if (this.isOutputing) {
                    this.isOutputing = false;
                    this.xofStream.reset();
                }
                return this.xofStream;
            }

            @Override
            public int getFunctionOutput(byte[] byArray, int n, int n2) {
                this.isOutputing = true;
                return this.xofStream.getOutput(byArray, n, n2);
            }

            @Override
            public void reset() {
                this.xofStream.reset();
            }
        }
    }
}

