/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.MacSpi;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.MACOperatorFactory;
import org.bouncycastle.crypto.OutputMACCalculator;
import org.bouncycastle.crypto.Parameters;
import org.bouncycastle.crypto.SymmetricKey;
import org.bouncycastle.crypto.UpdateOutputStream;
import org.bouncycastle.jcajce.provider.MacParametersCreator;
import org.bouncycastle.jcajce.provider.Utils;

class BaseMac
extends MacSpi {
    private final Algorithm algorithm;
    private final MACOperatorFactory factory;
    private final MacParametersCreator parametersCreator;
    private final int keySizeInBits;
    private OutputMACCalculator macCalculator;
    private UpdateOutputStream macStream;

    protected BaseMac(Algorithm algorithm, MACOperatorFactory mACOperatorFactory, MacParametersCreator macParametersCreator) {
        this(algorithm, mACOperatorFactory, macParametersCreator, 0);
    }

    protected BaseMac(Parameters parameters, MACOperatorFactory mACOperatorFactory, MacParametersCreator macParametersCreator) {
        this(parameters.getAlgorithm(), mACOperatorFactory, macParametersCreator, 0);
    }

    protected BaseMac(Parameters parameters, MACOperatorFactory mACOperatorFactory, MacParametersCreator macParametersCreator, int n) {
        this(parameters.getAlgorithm(), mACOperatorFactory, macParametersCreator, n);
    }

    protected BaseMac(Algorithm algorithm, MACOperatorFactory mACOperatorFactory, MacParametersCreator macParametersCreator, int n) {
        this.algorithm = algorithm;
        this.factory = mACOperatorFactory;
        this.parametersCreator = macParametersCreator;
        this.keySizeInBits = n;
    }

    protected void engineInit(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
        SymmetricKey symmetricKey = Utils.convertKey(this.algorithm, key);
        if (this.keySizeInBits != 0 && Utils.keyNotLength(symmetricKey, this.keySizeInBits)) {
            throw new InvalidKeyException("MAC requires key of size " + this.keySizeInBits + " bits");
        }
        try {
            this.macCalculator = this.factory.createOutputMACCalculator(symmetricKey, this.parametersCreator.createParameters(false, algorithmParameterSpec, null));
            this.macStream = this.macCalculator.getMACStream();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidAlgorithmParameterException(illegalArgumentException.getMessage(), illegalArgumentException.getCause());
        }
    }

    protected int engineGetMacLength() {
        return (this.parametersCreator.getBaseParameters().getMACSizeInBits() + 7) / 8;
    }

    protected void engineReset() {
        this.macCalculator.reset();
    }

    protected void engineUpdate(byte by) {
        this.macStream.update(by);
    }

    protected void engineUpdate(byte[] byArray, int n, int n2) {
        this.macStream.update(byArray, n, n2);
    }

    protected byte[] engineDoFinal() {
        return this.macCalculator.getMAC();
    }
}

