/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.gmavenplus.mojo;

import java.io.File;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.toolchain.Toolchain;
import org.apache.maven.toolchain.ToolchainManager;
import org.codehaus.gmavenplus.model.GroovyCompileConfiguration;
import org.codehaus.gmavenplus.model.IncludeClasspath;
import org.codehaus.gmavenplus.mojo.AbstractGroovySourcesMojo;
import org.codehaus.gmavenplus.util.ForkedGroovyCompiler;
import org.codehaus.gmavenplus.util.GroovyCompiler;

public abstract class AbstractCompileMojo
extends AbstractGroovySourcesMojo {
    @Parameter(defaultValue="${project.build.sourceEncoding}")
    protected String sourceEncoding;
    @Parameter(property="maven.compiler.target", defaultValue="1.8")
    protected String targetBytecode;
    @Parameter(property="skipBytecodeCheck", defaultValue="false")
    protected boolean skipBytecodeCheck;
    @Parameter(defaultValue="false")
    protected boolean debug;
    @Parameter(defaultValue="false")
    protected boolean verbose;
    @Parameter(defaultValue="1")
    protected int warningLevel;
    @Parameter(defaultValue="0")
    protected int tolerance;
    @Parameter(defaultValue="false")
    protected boolean invokeDynamic;
    @Parameter
    protected Boolean parallelParsing = null;
    @Parameter
    protected File configScript;
    @Parameter(defaultValue="false")
    protected boolean parameters;
    @Parameter(defaultValue="PROJECT_ONLY")
    protected IncludeClasspath includeClasspath;
    @Parameter(defaultValue="false")
    protected boolean previewFeatures;
    @Component
    protected ToolchainManager toolchainManager;
    @Parameter(defaultValue="false")
    protected boolean fork;

    protected synchronized void doCompile(Set<File> sources, List classpath, File compileOutputDirectory) throws ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException, MalformedURLException {
        if (sources == null || sources.isEmpty()) {
            this.getLog().info((CharSequence)"No sources specified for compilation. Skipping.");
            return;
        }
        GroovyCompileConfiguration configuration = new GroovyCompileConfiguration(sources, classpath, compileOutputDirectory);
        configuration.setIncludeClasspath(this.includeClasspath);
        configuration.setSkipBytecodeCheck(this.skipBytecodeCheck);
        configuration.setDebug(this.debug);
        configuration.setVerbose(this.verbose);
        configuration.setWarningLevel(this.warningLevel);
        configuration.setTolerance(this.tolerance);
        configuration.setInvokeDynamic(this.invokeDynamic);
        configuration.setParallelParsing(this.parallelParsing);
        configuration.setConfigScript(this.configScript);
        configuration.setParameters(this.parameters);
        configuration.setPreviewFeatures(this.previewFeatures);
        configuration.setSourceEncoding(this.sourceEncoding);
        configuration.setTargetBytecode(this.targetBytecode);
        Toolchain toolchain = this.toolchainManager.getToolchainFromBuildContext("jdk", this.session);
        if (toolchain != null) {
            this.getLog().info((CharSequence)("Toolchain in gmavenplus-plugin: " + toolchain));
            this.performForkedCompilation(configuration, toolchain.findTool("java"));
        } else if (this.fork) {
            String javaExecutable = this.getJavaExecutable();
            this.getLog().info((CharSequence)("Forking compilation using " + javaExecutable));
            this.performForkedCompilation(configuration, javaExecutable);
        } else {
            this.getLog().info((CharSequence)"Performing in-process compilation");
            this.performInProcessCompilation(configuration, classpath);
        }
    }

    protected void performInProcessCompilation(GroovyCompileConfiguration configuration, List<?> classpath) throws MalformedURLException, ClassNotFoundException, InvocationTargetException, InstantiationException, IllegalAccessException {
        this.setupClassWrangler(classpath, this.includeClasspath);
        this.logPluginClasspath();
        this.classWrangler.logGroovyVersion(this.mojoExecution.getMojoDescriptor().getGoal());
        if (!this.groovyVersionSupportsAction()) {
            this.getLog().error((CharSequence)("Your Groovy version (" + this.classWrangler.getGroovyVersionString() + ") doesn't support compilation. The minimum version of Groovy required is " + this.minGroovyVersion + ". Skipping compiling."));
            return;
        }
        GroovyCompiler compiler = new GroovyCompiler(this.classWrangler, this.getLog());
        compiler.compile(configuration);
    }

    protected void performForkedCompilation(GroovyCompileConfiguration configuration, String javaExecutable) {
        if (javaExecutable == null) {
            this.getLog().warn((CharSequence)"Unable to find 'java' executable for toolchain. Falling back to in-process compilation.");
            try {
                this.performInProcessCompilation(configuration, configuration.getClasspath());
            }
            catch (Exception e) {
                throw new RuntimeException("Compilation failed", e);
            }
            return;
        }
        try {
            File configFile = File.createTempFile("gmavenplus-compile-config", ".ser");
            configFile.deleteOnExit();
            try (ObjectOutputStream oos = new ObjectOutputStream(Files.newOutputStream(configFile.toPath(), new OpenOption[0]));){
                oos.writeObject(configuration);
            }
            ArrayList<String> command = new ArrayList<String>();
            command.add(javaExecutable);
            command.add("-cp");
            command.add(this.buildForkClasspath());
            command.add(ForkedGroovyCompiler.class.getName());
            command.add(configFile.getAbsolutePath());
            this.getLog().info((CharSequence)("Forking compilation using " + javaExecutable));
            this.getLog().debug((CharSequence)("Command: " + command));
            ProcessBuilder pb = new ProcessBuilder(command);
            pb.inheritIO();
            Process process = pb.start();
            int exitCode = process.waitFor();
            if (exitCode != 0) {
                throw new RuntimeException("Groovy compilation failed with exit code " + exitCode);
            }
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException("Unable to fork compilation", e);
        }
    }

    protected String buildForkClasspath() {
        StringBuilder cp = new StringBuilder();
        cp.append(this.pluginDescriptor.getPluginArtifact().getFile().getAbsolutePath());
        for (Artifact artifact : this.pluginDescriptor.getArtifacts()) {
            cp.append(File.pathSeparator);
            cp.append(artifact.getFile().getAbsolutePath());
        }
        try {
            Class<Log> logClass = Log.class;
            CodeSource codeSource = logClass.getProtectionDomain().getCodeSource();
            if (codeSource != null) {
                String logJar = new File(codeSource.getLocation().toURI()).getAbsolutePath();
                cp.append(File.pathSeparator).append(logJar);
            }
        }
        catch (Exception e) {
            this.getLog().warn((CharSequence)"Could not find maven-plugin-api jar to add to fork classpath", (Throwable)e);
        }
        return cp.toString();
    }
}

