/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.buildhelper;

import java.io.File;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="add-source", defaultPhase=LifecyclePhase.GENERATE_SOURCES, threadSafe=true)
public class AddSourceMojo
extends AbstractMojo {
    @Parameter(property="sources", required=true)
    private File[] sources;
    @Parameter(readonly=true, defaultValue="${project}")
    private MavenProject project;
    @Parameter(property="buildhelper.addsource.skip", defaultValue="false")
    private boolean skipAddSource;
    @Parameter(property="buildhelper.addsource.skipIfMissing", defaultValue="false")
    private boolean skipAddSourceIfMissing;

    public void execute() {
        if (this.skipAddSource) {
            if (this.getLog().isInfoEnabled()) {
                this.getLog().info((CharSequence)"Skipping plugin execution!");
            }
            return;
        }
        for (File source : this.sources) {
            if (this.skipAddSourceIfMissing && !source.exists()) {
                if (!this.getLog().isDebugEnabled()) continue;
                this.getLog().debug((CharSequence)("Skipping directory: " + source + ", because it does not exist."));
                continue;
            }
            this.project.addCompileSourceRoot(source.getAbsolutePath());
            if (!this.getLog().isInfoEnabled()) continue;
            this.getLog().info((CharSequence)("Source directory: " + source + " added."));
        }
    }
}

