/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.build;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.command.info.InfoItem;
import org.apache.maven.scm.command.info.InfoScmResult;
import org.apache.maven.scm.command.status.StatusScmResult;
import org.apache.maven.scm.command.update.UpdateScmResult;
import org.apache.maven.scm.command.update.UpdateScmResultWithRevision;
import org.apache.maven.scm.manager.ScmManager;
import org.apache.maven.scm.provider.ScmProvider;
import org.apache.maven.scm.provider.git.gitexe.command.branch.GitBranchCommand;
import org.apache.maven.scm.provider.git.repository.GitScmProviderRepository;
import org.apache.maven.scm.provider.hg.HgScmProvider;
import org.apache.maven.scm.provider.hg.HgUtils;
import org.apache.maven.scm.provider.hg.command.HgConsumer;
import org.apache.maven.scm.repository.ScmRepository;
import org.codehaus.mojo.build.AbstractScmMojo;
import org.codehaus.mojo.build.HgOutputConsumer;
import org.codehaus.mojo.build.Utils;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="create", defaultPhase=LifecyclePhase.INITIALIZE, requiresProject=true, threadSafe=true)
public class CreateMojo
extends AbstractScmMojo {
    private static final String DEFAULT_BRANCH_NAME = "UNKNOWN_BRANCH";
    @Parameter(property="maven.buildNumber.buildNumberPropertyName", defaultValue="buildNumber")
    private String buildNumberPropertyName;
    @Parameter(property="maven.buildNumber.timestampPropertyName", defaultValue="timestamp")
    private String timestampPropertyName;
    @Parameter(property="maven.buildNumber.doCheck", defaultValue="false")
    private boolean doCheck;
    @Parameter(property="maven.buildNumber.failTheBuild", defaultValue="true")
    private boolean failTheBuild;
    @Parameter(property="maven.buildNumber.buildTaintedPropertyName", defaultValue="buildIsTainted")
    private String buildTaintedPropertyName;
    @Parameter(property="maven.buildNumber.doUpdate", defaultValue="false")
    private boolean doUpdate;
    @Parameter(property="maven.buildNumber.format")
    private String format;
    @Parameter(defaultValue="${basedir}/buildNumber.properties")
    private File buildNumberPropertiesFileLocation;
    @Parameter
    private List<?> items;
    @Parameter(property="maven.buildNumber.locale")
    private String locale;
    @Parameter(property="maven.buildNumber.timestampFormat")
    private String timestampFormat;
    @Parameter(property="maven.buildNumber.timestampTimeZone", defaultValue="")
    private String timezone;
    @Parameter
    private Map<String, String> providerImplementations;
    @Parameter(property="maven.buildNumber.getRevisionOnlyOnce", defaultValue="false")
    private boolean getRevisionOnlyOnce;
    @Parameter(property="maven.buildNumber.scmBranchPropertyName", defaultValue="scmBranch")
    private String scmBranchPropertyName;
    @Parameter(defaultValue="${reactorProjects}", readonly=true, required=true)
    private List<MavenProject> reactorProjects;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession session;
    private String revision;
    private boolean useScm;

    public void execute() throws MojoExecutionException, MojoFailureException {
        String buildIsTainted = "ok";
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping execution.");
            return;
        }
        if (this.providerImplementations != null) {
            this.changeProviderImplementation();
        }
        Date now = Calendar.getInstance().getTime();
        if (this.format != null) {
            if (this.items == null) {
                throw new MojoExecutionException(" if you set a format, you must provide at least one item, please check documentation ");
            }
            Object[] itemAry = this.handleItems(now);
            this.revision = this.format(itemAry);
        } else {
            this.revision = this.project.getProperties().getProperty(this.buildNumberPropertyName);
            if (this.getRevisionOnlyOnce && this.revision != null) {
                this.getLog().debug((CharSequence)"Revision available from previous execution");
                return;
            }
            if (this.doCheck) {
                StringBuilder message = new StringBuilder();
                if (this.doLocalModificationExist(message)) {
                    buildIsTainted = "tainted";
                    if (this.failTheBuild) {
                        throw new MojoExecutionException("Cannot create the build number because you have local modifications : \n" + message);
                    }
                }
            } else {
                this.getLog().debug((CharSequence)"Checking for local modifications: skipped.");
            }
            if (this.session.getSettings().isOffline()) {
                this.getLog().info((CharSequence)"maven is executed in offline mode, Updating project files from SCM: skipped.");
            } else if (this.doUpdate) {
                List<ScmFile> changedFiles = this.update();
                for (ScmFile file : changedFiles) {
                    this.getLog().debug((CharSequence)("Updated: " + file));
                }
                if (changedFiles.size() == 0) {
                    this.getLog().debug((CharSequence)"No files needed updating.");
                }
            } else {
                this.getLog().debug((CharSequence)"Updating project files from SCM: skipped.");
            }
            this.revision = this.getRevision();
        }
        if (this.project != null) {
            this.buildNumberAndTimeStampForReactorProjects(now, buildIsTainted);
        }
    }

    private Object[] handleItems(Date now) throws MojoExecutionException {
        Object[] itemAry = new Object[this.items.size()];
        for (int i = 0; i < this.items.size(); ++i) {
            Object item = this.items.get(i);
            if (item instanceof String) {
                String s = (String)item;
                if (s.equals("timestamp")) {
                    itemAry[i] = now;
                    continue;
                }
                if (s.startsWith("scmVersion")) {
                    this.useScm = true;
                    itemAry[i] = this.getRevision();
                    continue;
                }
                if (s.startsWith("buildNumber")) {
                    File propertiesFile = this.buildNumberPropertiesFileLocation;
                    this.createPropertiesFileIfNotExists(propertiesFile);
                    Properties properties = new Properties();
                    String buildNumberString = null;
                    try (FileInputStream inputStream = new FileInputStream(propertiesFile);){
                        properties.load(inputStream);
                        buildNumberString = properties.getProperty(s);
                        if (buildNumberString == null) {
                            buildNumberString = "0";
                        }
                        int buildNumber = Integer.parseInt(buildNumberString);
                        properties.setProperty(s, String.valueOf(++buildNumber));
                        try (FileOutputStream outputStream = new FileOutputStream(propertiesFile);){
                            properties.store(outputStream, "maven.buildNumber.plugin properties file");
                        }
                        itemAry[i] = buildNumber;
                        continue;
                    }
                    catch (NumberFormatException e) {
                        throw new MojoExecutionException("Couldn't parse buildNumber in properties file to an Integer: " + buildNumberString);
                    }
                    catch (IOException e) {
                        throw new MojoExecutionException("Couldn't load properties file: " + propertiesFile, (Exception)e);
                    }
                }
                itemAry[i] = item;
                continue;
            }
            itemAry[i] = item;
        }
        return itemAry;
    }

    private void createPropertiesFileIfNotExists(File propertiesFile) throws MojoExecutionException {
        if (!propertiesFile.exists()) {
            try {
                if (!propertiesFile.getParentFile().exists()) {
                    propertiesFile.getParentFile().mkdirs();
                }
                propertiesFile.createNewFile();
            }
            catch (IOException e) {
                throw new MojoExecutionException("Couldn't create properties file: " + propertiesFile, (Exception)e);
            }
        }
    }

    private void buildNumberAndTimeStampForReactorProjects(Date now, String taintedValue) throws MojoExecutionException {
        String timestamp = String.valueOf(now.getTime());
        if (this.timestampFormat != null) {
            if (this.timestampFormat.matches("\\{0,date,[^\\}]+\\}")) {
                this.getLog().warn((CharSequence)"The timestampFormat parameter now uses java.text.SimpleDateFormat.");
                this.getLog().warn((CharSequence)"Please update your POM as support for java.text.MessageFormat may be removed.");
                timestamp = Utils.createTimestamp(this.timestampFormat.replaceFirst("\\{0,date,([^\\}]+)\\}", "$1"), this.timezone, now);
            } else {
                timestamp = Utils.createTimestamp(this.timestampFormat, this.timezone, now);
            }
        }
        this.getLog().info((CharSequence)MessageFormat.format("Storing buildNumber: {0} at timestamp: {1}", this.revision, timestamp));
        if (this.revision != null) {
            this.project.getProperties().put(this.buildNumberPropertyName, this.revision);
        }
        this.project.getProperties().put(this.timestampPropertyName, timestamp);
        String scmBranch = this.getScmBranch();
        this.getLog().info((CharSequence)("Storing scmBranch: " + scmBranch));
        this.project.getProperties().put(this.scmBranchPropertyName, scmBranch);
        if (this.getRevisionOnlyOnce && this.reactorProjects != null) {
            for (MavenProject nextProj : this.reactorProjects) {
                if (this.revision != null) {
                    nextProj.getProperties().put(this.buildNumberPropertyName, this.revision);
                }
                nextProj.getProperties().put(this.timestampPropertyName, timestamp);
                nextProj.getProperties().put(this.scmBranchPropertyName, scmBranch);
                nextProj.getProperties().put(this.buildTaintedPropertyName, taintedValue);
            }
        }
    }

    private void changeProviderImplementation() {
        for (Map.Entry<String, String> entry : this.providerImplementations.entrySet()) {
            String providerType = entry.getKey();
            String providerImplementation = entry.getValue();
            this.getLog().info((CharSequence)("Change the default '" + providerType + "' provider implementation to '" + providerImplementation + "'."));
            this.scmManager.setScmProviderImplementation(providerType, providerImplementation);
        }
    }

    private String format(Object[] arguments) {
        Locale l = Locale.getDefault();
        if (this.locale != null) {
            String[] parts = this.locale.split("_", 3);
            l = parts.length <= 1 ? new Locale(this.locale) : (parts.length == 2 ? new Locale(parts[0], parts[1]) : new Locale(parts[0], parts[1], parts[2]));
        }
        return new MessageFormat(this.format, l).format(arguments);
    }

    private boolean doLocalModificationExist(StringBuilder message) throws MojoExecutionException {
        List<ScmFile> changedFiles;
        boolean result = false;
        this.getLog().debug((CharSequence)"Verifying there are no local modifications ...");
        try {
            changedFiles = this.getStatus();
        }
        catch (ScmException e) {
            throw new MojoExecutionException("An error has occurred while checking scm status.", (Exception)((Object)e));
        }
        if (!changedFiles.isEmpty()) {
            for (ScmFile file : changedFiles) {
                message.append(file.toString());
                message.append(System.lineSeparator());
            }
            result = true;
        }
        return result;
    }

    public List<ScmFile> update() throws MojoExecutionException {
        try {
            ScmRepository repository = this.getScmRepository();
            ScmProvider scmProvider = this.scmManager.getProviderByRepository(repository);
            UpdateScmResult result = scmProvider.update(repository, new ScmFileSet(this.scmDirectory));
            if (result == null) {
                return Collections.emptyList();
            }
            this.checkResult((ScmResult)result);
            if (result instanceof UpdateScmResultWithRevision) {
                String revision = ((UpdateScmResultWithRevision)result).getRevision();
                this.getLog().info((CharSequence)("Got a revision during update: " + revision));
                this.revision = revision;
            }
            return result.getUpdatedFiles();
        }
        catch (ScmException e) {
            throw new MojoExecutionException("Couldn't update project. " + e.getMessage(), (Exception)((Object)e));
        }
    }

    public List<ScmFile> getStatus() throws ScmException {
        ScmRepository repository = this.getScmRepository();
        ScmProvider scmProvider = this.scmManager.getProviderByRepository(repository);
        StatusScmResult result = scmProvider.status(repository, new ScmFileSet(this.scmDirectory));
        if (result == null) {
            return Collections.emptyList();
        }
        this.checkResult((ScmResult)result);
        return result.getChangedFiles();
    }

    public String getScmBranch() throws MojoExecutionException {
        try {
            ScmRepository repository = this.getScmRepository();
            ScmProvider provider = this.scmManager.getProviderByRepository(repository);
            if ("git".equals(provider.getScmType())) {
                ScmFileSet fileSet = new ScmFileSet(this.scmDirectory);
                return GitBranchCommand.getCurrentBranch((GitScmProviderRepository)((GitScmProviderRepository)repository.getProviderRepository()), (ScmFileSet)fileSet);
            }
            if (provider instanceof HgScmProvider) {
                HgOutputConsumer consumer = new HgOutputConsumer();
                ScmResult result = HgUtils.execute((HgConsumer)consumer, (File)this.scmDirectory, (String[])new String[]{"id", "-b"});
                this.checkResult(result);
                if (StringUtils.isNotEmpty((String)consumer.getOutput())) {
                    return consumer.getOutput();
                }
            }
        }
        catch (ScmException e) {
            this.getLog().warn((CharSequence)("Cannot get the branch information from the git repository: \n" + e.getLocalizedMessage()));
        }
        return this.getScmBranchFromUrl();
    }

    private String getScmBranchFromUrl() throws MojoExecutionException {
        String scmUrl = null;
        try {
            ScmRepository repository = this.getScmRepository();
            InfoScmResult scmResult = this.info(repository, new ScmFileSet(this.scmDirectory));
            if (scmResult == null || !scmResult.isSuccess()) {
                this.getLog().debug((CharSequence)("Cannot get the branch information from the scm repository : " + (scmResult == null ? "" : scmResult.getCommandOutput())));
                return DEFAULT_BRANCH_NAME;
            }
            if (scmResult.getInfoItems().isEmpty() && !StringUtils.isEmpty((String)this.revisionOnScmFailure)) {
                this.setDoCheck(false);
                this.setDoUpdate(false);
                return DEFAULT_BRANCH_NAME;
            }
            if (!scmResult.getInfoItems().isEmpty()) {
                InfoItem info = (InfoItem)scmResult.getInfoItems().get(0);
                scmUrl = info.getURL();
            }
        }
        catch (ScmException e) {
            if (!StringUtils.isEmpty((String)this.revisionOnScmFailure)) {
                this.getLog().warn((CharSequence)("Cannot get the branch information from the scm repository, proceeding with UNKNOWN_BRANCH : \n" + e.getLocalizedMessage()));
                this.setDoCheck(false);
                this.setDoUpdate(false);
                return DEFAULT_BRANCH_NAME;
            }
            throw new MojoExecutionException("Cannot get the branch information from the scm repository : \n" + e.getLocalizedMessage(), (Exception)((Object)e));
        }
        return this.filterBranchFromScmUrl(scmUrl);
    }

    protected String filterBranchFromScmUrl(String scmUrl) {
        String scmBranch = "UNKNOWN";
        if (StringUtils.contains((String)scmUrl, (String)"/trunk")) {
            scmBranch = "trunk";
        } else if (StringUtils.contains((String)scmUrl, (String)"/branches") || StringUtils.contains((String)scmUrl, (String)"/tags")) {
            scmBranch = scmUrl.replaceFirst(".*((branches|tags)/[^/]*).*", "$1");
        }
        return scmBranch;
    }

    public String getRevision() throws MojoExecutionException {
        if (this.format != null && !this.useScm) {
            return this.revision;
        }
        this.useScm = false;
        try {
            return this.getScmRevision();
        }
        catch (ScmException e) {
            String warnMessage = "Cannot get the revision information from the scm repository";
            if (!StringUtils.isEmpty((String)this.revisionOnScmFailure)) {
                this.getLog().warn((CharSequence)(warnMessage + ", proceeding with revision of " + this.revisionOnScmFailure + " : \n" + e.getLocalizedMessage()));
                this.setDoCheck(false);
                this.setDoUpdate(false);
                return this.revisionOnScmFailure;
            }
            if (!this.failTheBuild) {
                this.getLog().warn((CharSequence)warnMessage, (Throwable)e);
                return "";
            }
            throw new MojoExecutionException(warnMessage + " : \n" + e.getLocalizedMessage(), (Exception)((Object)e));
        }
    }

    public void setScmManager(ScmManager scmManager) {
        this.scmManager = scmManager;
    }

    public void setUrlScm(String urlScm) {
        this.scmConnectionUrl = urlScm;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setDoCheck(boolean doCheck) {
        this.doCheck = this.getBooleanProperty("maven.buildNumber.doCheck", doCheck);
    }

    public void setDoUpdate(boolean doUpdate) {
        this.doUpdate = this.getBooleanProperty("maven.buildNumber.doUpdate", doUpdate);
    }

    private boolean getBooleanProperty(String key, boolean defaultValue) {
        String systemProperty = System.getProperty(key);
        if (systemProperty == null) {
            return defaultValue;
        }
        return Boolean.parseBoolean(systemProperty);
    }

    void setFormat(String format) {
        this.format = format;
    }

    void setLocale(String locale) {
        this.locale = locale;
    }

    void setItems(List<?> items) {
        this.items = items;
    }

    public void setBuildNumberPropertiesFileLocation(File buildNumberPropertiesFileLocation) {
        this.buildNumberPropertiesFileLocation = buildNumberPropertiesFileLocation;
    }

    public void setScmDirectory(File scmDirectory) {
        this.scmDirectory = scmDirectory;
    }

    public void setRevisionOnScmFailure(String revisionOnScmFailure) {
        this.revisionOnScmFailure = revisionOnScmFailure;
    }

    public void setShortRevisionLength(int shortRevision) {
        this.shortRevisionLength = shortRevision;
    }

    public void setFailTheBuild(boolean failTheBuild) {
        this.failTheBuild = failTheBuild;
    }
}

