/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.license;

import java.io.File;
import javax.inject.Inject;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.mojo.license.AbstractLicenseMojo;

@Mojo(name="check-project-license", threadSafe=true)
public class CheckProjectLicenseMojo
extends AbstractLicenseMojo {
    @Parameter(property="license.licenceFile", defaultValue="LICENSE.txt")
    private File licenseFile;
    @Parameter(property="license.failOnMissingLicense", defaultValue="false")
    private boolean failOnMissingLicense;
    @Parameter(property="license.skipCheckLicense", defaultValue="false")
    private boolean skipCheckLicense;

    @Inject
    public CheckProjectLicenseMojo(MavenProjectHelper projectHelper) {
        super(projectHelper);
    }

    @Override
    public boolean isSkip() {
        return this.skipCheckLicense;
    }

    @Override
    protected void init() throws Exception {
    }

    @Override
    protected void doAction() throws Exception {
        if (!this.licenseFile.exists()) {
            String message = "There is module without license " + this.licenseFile.getAbsolutePath() + ". Use license:update-project-license goal to generate";
            if (this.failOnMissingLicense) {
                throw new MojoFailureException(message);
            }
            this.getLog().warn((CharSequence)message);
        }
    }
}

