/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.convert;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.money.CurrencyUnit;
import javax.money.NumberValue;
import javax.money.convert.ConversionContext;
import javax.money.convert.ExchangeRate;
import org.javamoney.moneta.convert.ExchangeRateBuilder;

class DefaultExchangeRate
implements ExchangeRate,
Serializable,
Comparable<ExchangeRate> {
    private static final long serialVersionUID = 5077295306570465837L;
    private final CurrencyUnit base;
    private final CurrencyUnit term;
    private final NumberValue factor;
    private final ConversionContext conversionContext;
    private final List<ExchangeRate> chain = new ArrayList<ExchangeRate>();

    DefaultExchangeRate(ExchangeRateBuilder builder) {
        Objects.requireNonNull(builder.base, "base may not be null.");
        Objects.requireNonNull(builder.term, "term may not be null.");
        Objects.requireNonNull(builder.factor, "factor may not be null.");
        Objects.requireNonNull(builder.conversionContext, "exchangeRateType may not be null.");
        this.base = builder.base;
        this.term = builder.term;
        this.factor = builder.factor;
        this.conversionContext = builder.conversionContext;
        this.setExchangeRateChain(builder.rateChain);
    }

    private void setExchangeRateChain(List<ExchangeRate> chain) {
        this.chain.clear();
        if (Objects.isNull(chain) || chain.isEmpty()) {
            this.chain.add(this);
        } else {
            for (ExchangeRate rate : chain) {
                if (!Objects.isNull(rate)) continue;
                throw new IllegalArgumentException("Rate Chain element can not be null.");
            }
            this.chain.addAll(chain);
        }
    }

    public final ConversionContext getContext() {
        return this.conversionContext;
    }

    public final CurrencyUnit getBaseCurrency() {
        return this.base;
    }

    public final CurrencyUnit getCurrency() {
        return this.term;
    }

    public final NumberValue getFactor() {
        return this.factor;
    }

    public final List<ExchangeRate> getExchangeRateChain() {
        return this.chain;
    }

    public final boolean isDerived() {
        return this.chain.size() > 1;
    }

    @Override
    public int compareTo(ExchangeRate o) {
        Objects.requireNonNull(o);
        int compare = this.getBaseCurrency().getCurrencyCode().compareTo(o.getBaseCurrency().getCurrencyCode());
        if (compare == 0) {
            compare = this.getCurrency().getCurrencyCode().compareTo(o.getCurrency().getCurrencyCode());
        }
        if (compare == 0) {
            compare = this.getContext().getProviderName().compareTo(o.getContext().getProviderName());
        }
        return compare;
    }

    public String toString() {
        return "ExchangeRate [base=" + this.base + ", term=" + this.term + ", factor=" + this.factor + ", conversionContext=" + this.conversionContext + ']';
    }

    public int hashCode() {
        BigDecimal normalizedFactor = ((BigDecimal)this.factor.numberValue(BigDecimal.class)).stripTrailingZeros();
        int chainHash = 0;
        for (ExchangeRate chainedRate : this.chain) {
            if (chainedRate == this) {
                chainHash = Objects.hash(chainHash, "this");
                continue;
            }
            chainHash = Objects.hash(chainHash, chainedRate);
        }
        return Objects.hash(this.base, this.conversionContext, normalizedFactor, this.term, chainHash);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof DefaultExchangeRate) {
            DefaultExchangeRate other = (DefaultExchangeRate)obj;
            return Objects.equals(this.base, other.base) && Objects.equals(this.conversionContext, other.conversionContext) && this.factor.compareTo(other.factor) == 0 && Objects.equals(this.term, other.term);
        }
        return false;
    }

    public ExchangeRateBuilder toBuilder() {
        return new ExchangeRateBuilder(this.getContext()).setBase(this.getBaseCurrency()).setTerm(this.getCurrency()).setFactor(this.getFactor()).setRateChain(this.getExchangeRateChain());
    }
}

