/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.text;

import com.intellij.openapi.util.text.CharSequenceWithStringHash;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.text.ByteArrayCharSequence;
import com.intellij.util.text.CharArrayCharSequence;
import com.intellij.util.text.CharArrayExternalizable;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.text.CharSequenceSubSequence;
import com.intellij.util.text.ImmutableCharSequence;
import com.intellij.util.text.MergingCharSequence;
import com.intellij.util.text.StringFactory;
import org.jetbrains.annotations.NotNull;

final class ImmutableText
extends ImmutableCharSequence
implements CharSequenceWithStringHash,
CharArrayExternalizable {
    private final Node myNode;
    private static final LeafNode EMPTY_NODE = new Leaf8BitNode(ArrayUtil.EMPTY_BYTE_ARRAY);
    private static final ImmutableText EMPTY = new ImmutableText(EMPTY_NODE);
    private transient int hash;
    private InnerLeaf myLastLeaf;

    private ImmutableText(Node node) {
        this.myNode = node;
    }

    static ImmutableText valueOf(@NotNull Object obj) {
        if (obj == null) {
            ImmutableText.$$$reportNull$$$0(0);
        }
        if (obj instanceof ImmutableText) {
            return (ImmutableText)obj;
        }
        if (obj instanceof CharSequence) {
            return ((CharSequence)obj).length() == 0 ? EMPTY : ImmutableText.valueOf((CharSequence)obj);
        }
        return ImmutableText.valueOf(String.valueOf(obj));
    }

    private static ImmutableText valueOf(@NotNull CharSequence str) {
        if (str == null) {
            ImmutableText.$$$reportNull$$$0(1);
        }
        return new ImmutableText(ImmutableText.createLeafNode(str));
    }

    private static LeafNode createLeafNode(@NotNull CharSequence str) {
        byte[] bytes;
        if (str == null) {
            ImmutableText.$$$reportNull$$$0(2);
        }
        if ((bytes = ByteArrayCharSequence.toBytesIfPossible(str)) != null) {
            return new Leaf8BitNode(bytes);
        }
        char[] chars = new char[str.length()];
        CharArrayUtil.getChars(str, chars, 0, 0, str.length());
        return new WideLeafNode(chars);
    }

    private ImmutableText ensureChunked() {
        if (this.length() > 64 && this.myNode instanceof LeafNode) {
            return new ImmutableText(ImmutableText.nodeOf((LeafNode)this.myNode, 0, this.length()));
        }
        return this;
    }

    private static Node nodeOf(@NotNull LeafNode node, int offset2, int length) {
        if (node == null) {
            ImmutableText.$$$reportNull$$$0(3);
        }
        if (length <= 64) {
            return node.subNode(offset2, offset2 + length);
        }
        int half = length + 64 >> 1 & 0xFFFFFFC0;
        return new CompositeNode(ImmutableText.nodeOf(node, offset2, half), ImmutableText.nodeOf(node, offset2 + half, length - half));
    }

    @Override
    public int length() {
        return this.myNode.length();
    }

    private ImmutableText concat(ImmutableText that) {
        return that.length() == 0 ? this : (this.length() == 0 ? that : new ImmutableText(ImmutableText.concatNodes(this.ensureChunked().myNode, that.ensureChunked().myNode)));
    }

    private ImmutableText subtext(int start) {
        return this.subtext(start, this.length());
    }

    @Override
    public ImmutableText insert(int index2, @NotNull CharSequence seq) {
        if (seq == null) {
            ImmutableText.$$$reportNull$$$0(5);
        }
        if (seq.length() == 0) {
            return this;
        }
        return this.subtext(0, index2).concat(ImmutableText.valueOf(seq)).concat(this.subtext(index2));
    }

    @Override
    public ImmutableText delete(int start, int end) {
        if (start == end) {
            return this;
        }
        if (start > end) {
            throw new IndexOutOfBoundsException();
        }
        return this.ensureChunked().subtext(0, start).concat(this.subtext(end));
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        if (start == 0 && end == this.length()) {
            return this;
        }
        return new CharSequenceSubSequence(this, start, end);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ImmutableText)) {
            return false;
        }
        return CharArrayUtil.regionMatches(this, 0, (ImmutableText)obj);
    }

    public int hashCode() {
        int h = this.hash;
        if (h == 0) {
            this.hash = h = StringUtil.stringHashCode(this, 0, this.length());
        }
        return h;
    }

    @Override
    public char charAt(int index2) {
        InnerLeaf leaf = this.myLastLeaf;
        if (leaf == null || index2 < leaf.offset || index2 >= leaf.end) {
            this.myLastLeaf = leaf = this.findLeaf(index2);
        }
        return leaf.leafNode.charAt(index2 - leaf.offset);
    }

    private InnerLeaf findLeaf(int index2) {
        Node node = this.myNode;
        if (index2 < 0 || index2 >= node.length()) {
            throw new IndexOutOfBoundsException("Index out of range: " + index2);
        }
        int offset2 = 0;
        while (true) {
            if (index2 >= node.length()) {
                throw new IndexOutOfBoundsException();
            }
            if (node instanceof LeafNode) {
                return new InnerLeaf((LeafNode)node, offset2);
            }
            CompositeNode composite = (CompositeNode)node;
            if (index2 < composite.head.length()) {
                node = composite.head;
                continue;
            }
            offset2 += composite.head.length();
            index2 -= composite.head.length();
            node = composite.tail;
        }
    }

    @Override
    public ImmutableText subtext(int start, int end) {
        if (start < 0 || start > end || end > this.length()) {
            throw new IndexOutOfBoundsException();
        }
        if (start == 0 && end == this.length()) {
            return this;
        }
        if (start == end) {
            return EMPTY;
        }
        return new ImmutableText(this.myNode.subNode(start, end));
    }

    @Override
    public void getChars(int start, int end, @NotNull char[] dest, int destPos) {
        if (dest == null) {
            ImmutableText.$$$reportNull$$$0(6);
        }
        this.myNode.getChars(start, end, dest, destPos);
    }

    @Override
    @NotNull
    public String toString() {
        String string = this.myNode.toString();
        if (string == null) {
            ImmutableText.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    private static Node concatNodes(@NotNull Node node1, @NotNull Node node2) {
        int length;
        if (node1 == null) {
            ImmutableText.$$$reportNull$$$0(8);
        }
        if (node2 == null) {
            ImmutableText.$$$reportNull$$$0(9);
        }
        if ((length = node1.length() + node2.length()) <= 64) {
            LeafNode leafNode = ImmutableText.createLeafNode(new MergingCharSequence(node1, node2));
            if (leafNode == null) {
                ImmutableText.$$$reportNull$$$0(10);
            }
            return leafNode;
        }
        Node head = node1;
        Node tail = node2;
        if (head.length() << 1 < tail.length() && tail instanceof CompositeNode) {
            if (((CompositeNode)tail).head.length() > ((CompositeNode)tail).tail.length()) {
                tail = ((CompositeNode)tail).rightRotation();
            }
            head = ImmutableText.concatNodes(head, ((CompositeNode)tail).head);
            tail = ((CompositeNode)tail).tail;
        } else if (tail.length() << 1 < head.length() && head instanceof CompositeNode) {
            if (((CompositeNode)head).tail.length() > ((CompositeNode)head).head.length()) {
                head = ((CompositeNode)head).leftRotation();
            }
            tail = ImmutableText.concatNodes(((CompositeNode)head).tail, tail);
            head = ((CompositeNode)head).head;
        }
        CompositeNode compositeNode = new CompositeNode(head, tail);
        if (compositeNode == null) {
            ImmutableText.$$$reportNull$$$0(11);
        }
        return compositeNode;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "obj";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequence";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "seq";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dest";
                break;
            }
            case 7: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/text/ImmutableText";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node1";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node2";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/text/ImmutableText";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "concatNodes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "valueOf";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createLeafNode";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "nodeOf";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "concat";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "insert";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getChars";
                break;
            }
            case 7: 
            case 10: 
            case 11: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "concatNodes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CompositeNode
    extends Node {
        final int count;
        final Node head;
        final Node tail;

        CompositeNode(Node head, Node tail) {
            this.count = head.length() + tail.length();
            this.head = head;
            this.tail = tail;
        }

        @Override
        public int length() {
            return this.count;
        }

        @Override
        public char charAt(int index2) {
            int headLength = this.head.length();
            return index2 < headLength ? this.head.charAt(index2) : this.tail.charAt(index2 - headLength);
        }

        Node rightRotation() {
            Node P3 = this.head;
            if (!(P3 instanceof CompositeNode)) {
                return this;
            }
            Node A = ((CompositeNode)P3).head;
            Node B = ((CompositeNode)P3).tail;
            Node C = this.tail;
            return new CompositeNode(A, new CompositeNode(B, C));
        }

        Node leftRotation() {
            Node Q = this.tail;
            if (!(Q instanceof CompositeNode)) {
                return this;
            }
            Node B = ((CompositeNode)Q).head;
            Node C = ((CompositeNode)Q).tail;
            Node A = this.head;
            return new CompositeNode(new CompositeNode(A, B), C);
        }

        @Override
        void getChars(int start, int end, @NotNull char[] dest, int destPos) {
            int cesure;
            if (dest == null) {
                CompositeNode.$$$reportNull$$$0(0);
            }
            if (end <= (cesure = this.head.length())) {
                this.head.getChars(start, end, dest, destPos);
            } else if (start >= cesure) {
                this.tail.getChars(start - cesure, end - cesure, dest, destPos);
            } else {
                this.head.getChars(start, cesure, dest, destPos);
                this.tail.getChars(0, end - cesure, dest, destPos + cesure - start);
            }
        }

        @Override
        Node subNode(int start, int end) {
            int cesure = this.head.length();
            if (end <= cesure) {
                return this.head.subNode(start, end);
            }
            if (start >= cesure) {
                return this.tail.subNode(start - cesure, end - cesure);
            }
            if (start == 0 && end == this.count) {
                return this;
            }
            return ImmutableText.concatNodes(this.head.subNode(start, cesure), this.tail.subNode(0, end - cesure));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dest", "com/intellij/util/text/ImmutableText$CompositeNode", "getChars"));
        }
    }

    private static class Leaf8BitNode
    extends LeafNode {
        private final byte[] data;

        Leaf8BitNode(@NotNull byte[] data) {
            if (data == null) {
                Leaf8BitNode.$$$reportNull$$$0(0);
            }
            this.data = data;
        }

        @Override
        public int length() {
            return this.data.length;
        }

        @Override
        void getChars(int start, int end, @NotNull char[] dest, int destPos) {
            if (dest == null) {
                Leaf8BitNode.$$$reportNull$$$0(1);
            }
            if (start < 0 || end > this.length() || start > end) {
                throw new IndexOutOfBoundsException();
            }
            for (int i = start; i < end; ++i) {
                dest[destPos++] = Leaf8BitNode.byteToChar(this.data[i]);
            }
        }

        @Override
        LeafNode subNode(int start, int end) {
            if (start == 0 && end == this.length()) {
                return this;
            }
            int length = end - start;
            byte[] chars = new byte[length];
            System.arraycopy(this.data, start, chars, 0, length);
            return new Leaf8BitNode(chars);
        }

        @Override
        public char charAt(int index2) {
            return Leaf8BitNode.byteToChar(this.data[index2]);
        }

        private static char byteToChar(byte b) {
            return (char)(b & 0xFF);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dest";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/util/text/ImmutableText$Leaf8BitNode";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getChars";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class WideLeafNode
    extends LeafNode {
        private final char[] data;

        WideLeafNode(@NotNull char[] data) {
            if (data == null) {
                WideLeafNode.$$$reportNull$$$0(0);
            }
            this.data = data;
        }

        @Override
        public int length() {
            return this.data.length;
        }

        @Override
        void getChars(int start, int end, @NotNull char[] dest, int destPos) {
            if (dest == null) {
                WideLeafNode.$$$reportNull$$$0(1);
            }
            if (start < 0 || end > this.length() || start > end) {
                throw new IndexOutOfBoundsException();
            }
            System.arraycopy(this.data, start, dest, destPos, end - start);
        }

        @Override
        Node subNode(int start, int end) {
            if (start == 0 && end == this.length()) {
                return this;
            }
            return ImmutableText.createLeafNode(new CharArrayCharSequence(this.data, start, end));
        }

        @Override
        @NotNull
        public String toString() {
            String string = StringFactory.createShared(this.data);
            if (string == null) {
                WideLeafNode.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        public char charAt(int index2) {
            return this.data[index2];
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dest";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/text/ImmutableText$WideLeafNode";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/text/ImmutableText$WideLeafNode";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toString";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getChars";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static abstract class LeafNode
    extends Node {
        private LeafNode() {
        }
    }

    private static abstract class Node
    implements CharSequence {
        private Node() {
        }

        abstract void getChars(int var1, int var2, @NotNull char[] var3, int var4);

        abstract Node subNode(int var1, int var2);

        @Override
        @NotNull
        public String toString() {
            int len = this.length();
            char[] data = new char[len];
            this.getChars(0, len, data, 0);
            String string = StringFactory.createShared(data);
            if (string == null) {
                Node.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return this.subNode(start, end);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/text/ImmutableText$Node", "toString"));
        }
    }

    private static class InnerLeaf {
        final LeafNode leafNode;
        final int offset;
        final int end;

        private InnerLeaf(@NotNull LeafNode leafNode, int offset2) {
            if (leafNode == null) {
                InnerLeaf.$$$reportNull$$$0(0);
            }
            this.leafNode = leafNode;
            this.offset = offset2;
            this.end = offset2 + leafNode.length();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "leafNode", "com/intellij/util/text/ImmutableText$InnerLeaf", "<init>"));
        }
    }
}

