/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.cfa;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.collections.immutable.ImmutableCollection;
import kotlinx.collections.immutable.ImmutableSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.contracts.description.EventOccurrencesRange;
import org.jetbrains.kotlin.contracts.description.EventOccurrencesRangeKt;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.analysis.cfa.AbstractFirPropertyInitializationChecker;
import org.jetbrains.kotlin.fir.analysis.cfa.CfgTraverserKt;
import org.jetbrains.kotlin.fir.analysis.cfa.PathAwarePropertyInitializationInfo;
import org.jetbrains.kotlin.fir.analysis.cfa.PropertyInitializationInfo;
import org.jetbrains.kotlin.fir.analysis.cfa.TraverseDirection;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirDiagnostic;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccess;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.CFGNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.ControlFlowGraph;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.ControlFlowGraphVisitorVoid;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.EdgeLabel;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.QualifiedAccessNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.VariableAssignmentNode;
import org.jetbrains.kotlin.fir.symbols.AbstractFirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0012B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JF\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0016\u0010\t\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b\u0012\u0004\u0012\u00020\f0\n2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/cfa/FirPropertyInitializationAnalyzer;", "Lorg/jetbrains/kotlin/fir/analysis/cfa/AbstractFirPropertyInitializationChecker;", "()V", "analyze", "", "graph", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraph;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "data", "", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/CFGNode;", "Lorg/jetbrains/kotlin/fir/analysis/cfa/PathAwarePropertyInitializationInfo;", "properties", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "PropertyReporter", "checkers"})
public final class FirPropertyInitializationAnalyzer
extends AbstractFirPropertyInitializationChecker {
    @NotNull
    public static final FirPropertyInitializationAnalyzer INSTANCE = new FirPropertyInitializationAnalyzer();

    private FirPropertyInitializationAnalyzer() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void analyze(@NotNull ControlFlowGraph graph2, @NotNull DiagnosticReporter reporter, @NotNull Map<CFGNode<?>, PathAwarePropertyInitializationInfo> data, @NotNull Set<? extends FirPropertySymbol> properties2, @NotNull CheckerContext context2) {
        void $this$filterTo$iv$iv;
        void $this$filterTo$iv$iv2;
        Intrinsics.checkNotNullParameter((Object)graph2, (String)"graph");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter(data, (String)"data");
        Intrinsics.checkNotNullParameter(properties2, (String)"properties");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Map<CFGNode<?>, PathAwarePropertyInitializationInfo> $this$filter$iv = data;
        boolean $i$f$filter = false;
        Map<CFGNode<?>, PathAwarePropertyInitializationInfo> map = $this$filter$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        void var12_14 = $this$filterTo$iv$iv2;
        boolean bl = false;
        Iterator iterator2 = var12_14.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator2.next();
            boolean bl2 = false;
            Object e = ((CFGNode)it.getKey()).getFir();
            FirVariableSymbol firVariableSymbol = e instanceof FirVariableSymbol ? (FirVariableSymbol)e : null;
            FirVariable symbolFir = firVariableSymbol == null ? null : (FirVariable)firVariableSymbol.getFir();
            if (!(symbolFir == null || symbolFir.getInitializer() == null && symbolFir.getDelegate() == null)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map localData = destination$iv$iv;
        Iterable $this$filter$iv2 = properties2;
        boolean $i$f$filter2 = false;
        destination$iv$iv = $this$filter$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            FirPropertySymbol it = (FirPropertySymbol)element$iv$iv;
            boolean bl3 = false;
            if (!(((FirProperty)it.getFir()).getInitializer() == null && ((FirProperty)it.getFir()).getDelegate() == null)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        Set localProperties = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
        PropertyReporter reporterVisitor = new PropertyReporter(localData, localProperties, reporter, context2);
        CfgTraverserKt.traverse(graph2, TraverseDirection.Forward, reporterVisitor);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B;\u0012\u0016\u0010\u0002\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0016\u0010\u0016\u001a\u0004\u0018\u00010\b2\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u0004H\u0002J \u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u001dH\u0002J \u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u001fH\u0002J\u0014\u0010 \u001a\u00020!2\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u0004H\u0016J\u0010\u0010\"\u001a\u00020!2\u0006\u0010\u0017\u001a\u00020\u001dH\u0016J\u0010\u0010#\u001a\u00020!2\u0006\u0010\u0017\u001a\u00020\u001fH\u0016R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR!\u0010\u0002\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/cfa/FirPropertyInitializationAnalyzer$PropertyReporter;", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraphVisitorVoid;", "data", "", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/CFGNode;", "Lorg/jetbrains/kotlin/fir/analysis/cfa/PathAwarePropertyInitializationInfo;", "localProperties", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "(Ljava/util/Map;Ljava/util/Set;Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;)V", "getContext", "()Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "getData", "()Ljava/util/Map;", "getLocalProperties", "()Ljava/util/Set;", "getReporter", "()Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "getPropertySymbol", "node", "investigateVariableAccess", "", "info", "Lorg/jetbrains/kotlin/fir/analysis/cfa/PropertyInitializationInfo;", "symbol", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/QualifiedAccessNode;", "investigateVariableAssignment", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/VariableAssignmentNode;", "visitNode", "", "visitQualifiedAccessNode", "visitVariableAssignmentNode", "checkers"})
    private static final class PropertyReporter
    extends ControlFlowGraphVisitorVoid {
        @NotNull
        private final Map<CFGNode<?>, PathAwarePropertyInitializationInfo> data;
        @NotNull
        private final Set<FirPropertySymbol> localProperties;
        @NotNull
        private final DiagnosticReporter reporter;
        @NotNull
        private final CheckerContext context;

        public PropertyReporter(@NotNull Map<CFGNode<?>, PathAwarePropertyInitializationInfo> data, @NotNull Set<? extends FirPropertySymbol> localProperties, @NotNull DiagnosticReporter reporter, @NotNull CheckerContext context2) {
            Intrinsics.checkNotNullParameter(data, (String)"data");
            Intrinsics.checkNotNullParameter(localProperties, (String)"localProperties");
            Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            this.data = data;
            this.localProperties = localProperties;
            this.reporter = reporter;
            this.context = context2;
        }

        @NotNull
        public final Map<CFGNode<?>, PathAwarePropertyInitializationInfo> getData() {
            return this.data;
        }

        @NotNull
        public final Set<FirPropertySymbol> getLocalProperties() {
            return this.localProperties;
        }

        @NotNull
        public final DiagnosticReporter getReporter() {
            return this.reporter;
        }

        @NotNull
        public final CheckerContext getContext() {
            return this.context;
        }

        @Override
        public void visitNode(@NotNull CFGNode<?> node) {
            Intrinsics.checkNotNullParameter(node, (String)"node");
        }

        private final FirPropertySymbol getPropertySymbol(CFGNode<?> node) {
            Object object;
            Object obj = node.getFir();
            FirQualifiedAccess firQualifiedAccess = obj instanceof FirQualifiedAccess ? (FirQualifiedAccess)obj : null;
            FirReference firReference = firQualifiedAccess == null ? null : firQualifiedAccess.getCalleeReference();
            Object object2 = object = firReference instanceof FirResolvedNamedReference ? (FirResolvedNamedReference)firReference : null;
            if (object == null) {
                return null;
            }
            Object reference = object;
            return (object = ((FirResolvedNamedReference)reference).getResolvedSymbol()) instanceof FirPropertySymbol ? (FirPropertySymbol)object : null;
        }

        @Override
        public void visitVariableAssignmentNode(@NotNull VariableAssignmentNode node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            FirPropertySymbol firPropertySymbol = this.getPropertySymbol(node);
            if (firPropertySymbol == null) {
                return;
            }
            FirPropertySymbol symbol2 = firPropertySymbol;
            PathAwarePropertyInitializationInfo pathAwareInfo = (PathAwarePropertyInitializationInfo)MapsKt.getValue(this.data, (Object)node);
            for (EdgeLabel label : (ImmutableSet)pathAwareInfo.keySet()) {
                PropertyInitializationInfo propertyInitializationInfo = (PropertyInitializationInfo)pathAwareInfo.get((Object)label);
                Intrinsics.checkNotNull((Object)propertyInitializationInfo);
                if (!this.investigateVariableAssignment(propertyInitializationInfo, symbol2, node)) continue;
                break;
            }
        }

        private final boolean investigateVariableAssignment(PropertyInitializationInfo info, FirPropertySymbol symbol2, VariableAssignmentNode node) {
            EventOccurrencesRange kind;
            Object object = (EventOccurrencesRange)((Object)info.get(symbol2));
            EventOccurrencesRange eventOccurrencesRange = kind = object == null ? EventOccurrencesRange.ZERO : object;
            if (((FirProperty)symbol2.getFir()).isVal() && EventOccurrencesRangeKt.canBeRevisited(kind) && (object = node.getFir().getLValue().getSource()) != null) {
                Object object2 = object;
                boolean bl = false;
                boolean bl2 = false;
                Object it = object2;
                boolean bl3 = false;
                this.getReporter().report((FirDiagnostic)FirErrors.INSTANCE.getVAL_REASSIGNMENT().on((FirSourceElement)it, symbol2), this.getContext());
                return true;
            }
            return false;
        }

        @Override
        public void visitQualifiedAccessNode(@NotNull QualifiedAccessNode node) {
            PropertyInitializationInfo info;
            FirResolvedNamedReference firResolvedNamedReference;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Object object = node.getFir().getCalleeReference();
            FirResolvedNamedReference firResolvedNamedReference2 = firResolvedNamedReference = object instanceof FirResolvedNamedReference ? (FirResolvedNamedReference)object : null;
            if (firResolvedNamedReference == null) {
                return;
            }
            FirResolvedNamedReference reference = firResolvedNamedReference;
            AbstractFirBasedSymbol<?> abstractFirBasedSymbol = reference.getResolvedSymbol();
            Object object2 = object = abstractFirBasedSymbol instanceof FirPropertySymbol ? (FirPropertySymbol)abstractFirBasedSymbol : null;
            if (object == null) {
                return;
            }
            Object symbol2 = object;
            if (!this.localProperties.contains(symbol2)) {
                return;
            }
            FirMemberDeclaration $this$isLateInit$iv = (FirMemberDeclaration)((AbstractFirBasedSymbol)symbol2).getFir();
            boolean $i$f$isLateInit = false;
            if ($this$isLateInit$iv.getStatus().isLateInit()) {
                return;
            }
            PathAwarePropertyInitializationInfo pathAwareInfo = (PathAwarePropertyInitializationInfo)MapsKt.getValue(this.data, (Object)node);
            Iterator iterator2 = ((ImmutableCollection)pathAwareInfo.values()).iterator();
            while (iterator2.hasNext() && !this.investigateVariableAccess(info = (PropertyInitializationInfo)iterator2.next(), (FirPropertySymbol)symbol2, node)) {
            }
        }

        private final boolean investigateVariableAccess(PropertyInitializationInfo info, FirPropertySymbol symbol2, QualifiedAccessNode node) {
            EventOccurrencesRange kind;
            Object object = (EventOccurrencesRange)((Object)info.get(symbol2));
            EventOccurrencesRange eventOccurrencesRange = kind = object == null ? EventOccurrencesRange.ZERO : object;
            if (!EventOccurrencesRangeKt.isDefinitelyVisited(kind) && (object = node.getFir().getSource()) != null) {
                Object object2 = object;
                boolean bl = false;
                boolean bl2 = false;
                Object it = object2;
                boolean bl3 = false;
                this.getReporter().report((FirDiagnostic)FirErrors.INSTANCE.getUNINITIALIZED_VARIABLE().on((FirSourceElement)it, symbol2), this.getContext());
                return true;
            }
            return false;
        }
    }
}

