---
-- #%L
-- %%
-- Copyright (C) 2005 - 2020 Kuali, Inc. - All Rights Reserved
-- %%
-- You may use and modify this code under the terms of the Kuali, Inc.
-- Pre-Release License Agreement. You may not distribute it.
-- 
-- You should have received a copy of the Kuali, Inc. Pre-Release License
-- Agreement with this file. If not, please write to license@kuali.co.
-- #L%
---


CREATE SEQUENCE SEQ_S2S_OPPORTUNITY_CFDA_ID INCREMENT BY 1 START WITH 1 NOCACHE;

CREATE TABLE S2S_OPPORTUNITY_CFDA (
  S2S_OPPORTUNITY_CFDA_ID NUMBER(12,0) NOT NULL,
  PROPOSAL_NUMBER VARCHAR2(8) NOT NULL,
  CFDA_NUMBER VARCHAR2(7),
  CFDA_DESCRIPTION VARCHAR2(255),
  UPDATE_TIMESTAMP DATE NOT NULL,
  UPDATE_USER VARCHAR2(60) NOT NULL,
  VER_NBR NUMBER(8, 0) DEFAULT 1 NOT NULL,
  OBJ_ID VARCHAR2(36) NOT NULL
);

ALTER TABLE S2S_OPPORTUNITY_CFDA
  ADD CONSTRAINT PK_S2S_OPPORTUNITY_CFDA
PRIMARY KEY (S2S_OPPORTUNITY_CFDA_ID);

ALTER TABLE S2S_OPPORTUNITY_CFDA
  ADD CONSTRAINT FK_S2S_OPPORTUNITY_CFDA
FOREIGN KEY (PROPOSAL_NUMBER) REFERENCES S2S_OPPORTUNITY (PROPOSAL_NUMBER);

ALTER TABLE S2S_OPPORTUNITY_CFDA
  ADD CONSTRAINT UQ_S2S_OPPORTUNITY_CFDA
UNIQUE (OBJ_ID);

DECLARE

  CURSOR CFDA_CUR IS
    select PROPOSAL_NUMBER, CFDA_NUMBER, CFDA_DESCRIPTION, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID
    from S2S_OPPORTUNITY
    where CFDA_NUMBER is not null;

BEGIN

  FOR CFDA_REC in CFDA_CUR
  LOOP

    INSERT INTO S2S_OPPORTUNITY_CFDA (S2S_OPPORTUNITY_CFDA_ID, PROPOSAL_NUMBER, CFDA_NUMBER, CFDA_DESCRIPTION, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
    VALUES (SEQ_S2S_OPPORTUNITY_CFDA_ID.NEXTVAL, CFDA_REC.PROPOSAL_NUMBER, CFDA_REC.CFDA_NUMBER, CFDA_REC.CFDA_DESCRIPTION, CFDA_REC.UPDATE_TIMESTAMP, CFDA_REC.UPDATE_USER, CFDA_REC.VER_NBR, CFDA_REC.OBJ_ID);

  END LOOP;

END;
/

-- update in a later script
-- update S2S_OPPORTUNITY set CFDA_NUMBER = null, CFDA_DESCRIPTION = null;


CREATE SEQUENCE SEQ_EPS_PROP_CFDA_ID INCREMENT BY 1 START WITH 1 NOCACHE;

CREATE TABLE EPS_PROP_CFDA (
  EPS_PROP_CFDA_ID NUMBER(12,0) NOT NULL,
  PROPOSAL_NUMBER VARCHAR2(8) NOT NULL,
  CFDA_NUMBER VARCHAR2(7) NOT NULL,
  CFDA_DESCRIPTION VARCHAR2(255),
  UPDATE_TIMESTAMP DATE NOT NULL,
  UPDATE_USER VARCHAR2(60) NOT NULL,
  VER_NBR NUMBER(8, 0) DEFAULT 1 NOT NULL,
  OBJ_ID VARCHAR2(36) NOT NULL
);

ALTER TABLE EPS_PROP_CFDA
  ADD CONSTRAINT PK_EPS_PROP_CFDA
PRIMARY KEY (EPS_PROP_CFDA_ID);

ALTER TABLE EPS_PROP_CFDA
  ADD CONSTRAINT FK_EPS_PROP_CFDA
FOREIGN KEY (PROPOSAL_NUMBER) REFERENCES EPS_PROPOSAL (PROPOSAL_NUMBER);

ALTER TABLE EPS_PROP_CFDA
  ADD CONSTRAINT UQ_EPS_PROP_CFDA
UNIQUE (OBJ_ID);

DECLARE

  CURSOR CFDA_CUR IS
    select PROPOSAL_NUMBER, CFDA_NUMBER, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID
    from EPS_PROPOSAL
    where CFDA_NUMBER is not null;

BEGIN

  FOR CFDA_REC in CFDA_CUR
  LOOP

    INSERT INTO EPS_PROP_CFDA (EPS_PROP_CFDA_ID, PROPOSAL_NUMBER, CFDA_NUMBER, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
    VALUES (SEQ_EPS_PROP_CFDA_ID.NEXTVAL, CFDA_REC.PROPOSAL_NUMBER, CFDA_REC.CFDA_NUMBER, CFDA_REC.UPDATE_TIMESTAMP, CFDA_REC.UPDATE_USER, CFDA_REC.VER_NBR, CFDA_REC.OBJ_ID);

  END LOOP;

END;
/

-- update in a later script
-- update EPS_PROPOSAL set CFDA_NUMBER = null;


CREATE SEQUENCE SEQ_PROPOSAL_CFDA_ID INCREMENT BY 1 START WITH 1 NOCACHE;

CREATE TABLE PROPOSAL_CFDA (
  PROPOSAL_CFDA_ID NUMBER(12,0) NOT NULL,
  PROPOSAL_ID NUMBER(12,0) NOT NULL,
  PROPOSAL_NUMBER VARCHAR2(8) NOT NULL,
  SEQUENCE_NUMBER NUMBER(4,0) NOT NULL,
  CFDA_NUMBER VARCHAR2(7) NOT NULL,
  CFDA_DESCRIPTION VARCHAR2(255),
  UPDATE_TIMESTAMP DATE NOT NULL,
  UPDATE_USER VARCHAR2(60) NOT NULL,
  VER_NBR NUMBER(8, 0) DEFAULT 1 NOT NULL,
  OBJ_ID VARCHAR2(36) NOT NULL
);

ALTER TABLE PROPOSAL_CFDA
  ADD CONSTRAINT PK_PROPOSAL_CFDA
PRIMARY KEY (PROPOSAL_CFDA_ID);

ALTER TABLE PROPOSAL_CFDA
  ADD CONSTRAINT UQ_PROPOSAL_CFDA
UNIQUE (OBJ_ID);

ALTER TABLE PROPOSAL_CFDA
  ADD CONSTRAINT FK_PROPOSAL_CFDA
FOREIGN KEY (PROPOSAL_ID) REFERENCES PROPOSAL (PROPOSAL_ID);

DECLARE

  CURSOR CFDA_CUR IS
    SELECT PROPOSAL_ID, PROPOSAL_NUMBER, SEQUENCE_NUMBER, CFDA_NUMBER, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID
    FROM PROPOSAL
    WHERE CFDA_NUMBER IS NOT NULL;

BEGIN

  FOR CFDA_REC in CFDA_CUR
  LOOP

    INSERT INTO PROPOSAL_CFDA (PROPOSAL_CFDA_ID, PROPOSAL_ID, PROPOSAL_NUMBER, SEQUENCE_NUMBER, CFDA_NUMBER, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
    VALUES (SEQ_PROPOSAL_CFDA_ID.NEXTVAL, CFDA_REC.PROPOSAL_ID, CFDA_REC.PROPOSAL_NUMBER, CFDA_REC.SEQUENCE_NUMBER, CFDA_REC.CFDA_NUMBER, CFDA_REC.UPDATE_TIMESTAMP, CFDA_REC.UPDATE_USER, CFDA_REC.VER_NBR, CFDA_REC.OBJ_ID);

  END LOOP;

END;
/

-- update in a later script
-- update PROPOSAL set CFDA_NUMBER = null;


CREATE SEQUENCE SEQ_AWARD_CFDA_ID INCREMENT BY 1 START WITH 1 NOCACHE;

CREATE TABLE AWARD_CFDA (
  AWARD_CFDA_ID NUMBER(12,0) NOT NULL,
  AWARD_ID NUMBER(22,0) NOT NULL,
  AWARD_NUMBER VARCHAR2(12) NOT NULL,
  SEQUENCE_NUMBER NUMBER(8,0) NOT NULL,
  CFDA_NUMBER VARCHAR2(7) NOT NULL,
  CFDA_DESCRIPTION VARCHAR2(255),
  UPDATE_TIMESTAMP DATE NOT NULL,
  UPDATE_USER VARCHAR2(60) NOT NULL,
  VER_NBR NUMBER(8, 0) DEFAULT 1 NOT NULL,
  OBJ_ID VARCHAR2(36) NOT NULL
);

ALTER TABLE AWARD_CFDA
  ADD CONSTRAINT PK_AWARD_CFDA
PRIMARY KEY (AWARD_CFDA_ID);

ALTER TABLE AWARD_CFDA
  ADD CONSTRAINT UQ_AWARD_CFDA
UNIQUE (OBJ_ID);

ALTER TABLE AWARD_CFDA
  ADD CONSTRAINT FK_AWARD_CFDA
FOREIGN KEY (AWARD_ID) REFERENCES AWARD (AWARD_ID);

DECLARE

  CURSOR CFDA_CUR IS
    SELECT AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER, CFDA_NUMBER, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID
    FROM AWARD
    WHERE CFDA_NUMBER IS NOT NULL;

BEGIN

  FOR CFDA_REC in CFDA_CUR
  LOOP

    INSERT INTO AWARD_CFDA (AWARD_CFDA_ID, AWARD_ID, AWARD_NUMBER, SEQUENCE_NUMBER, CFDA_NUMBER, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
    VALUES (SEQ_AWARD_CFDA_ID.NEXTVAL, CFDA_REC.AWARD_ID, CFDA_REC.AWARD_NUMBER, CFDA_REC.SEQUENCE_NUMBER, CFDA_REC.CFDA_NUMBER, CFDA_REC.UPDATE_TIMESTAMP, CFDA_REC.UPDATE_USER, CFDA_REC.VER_NBR, CFDA_REC.OBJ_ID);

  END LOOP;

END;
/

-- update in a later script
-- update AWARD set CFDA_NUMBER = null;
