---
-- #%L
-- %%
-- Copyright (C) 2005 - 2020 Kuali, Inc. - All Rights Reserved
-- %%
-- You may use and modify this code under the terms of the Kuali, Inc.
-- Pre-Release License Agreement. You may not distribute it.
-- 
-- You should have received a copy of the Kuali, Inc. Pre-Release License
-- Agreement with this file. If not, please write to license@kuali.co.
-- #L%
---


-- Repair sequence
DECLARE
  seq_forms_xml_reorder_inc NUMBER;
  seq_next_val NUMBER;
BEGIN
  SELECT seq_forms_xml_reorder.nextval INTO seq_next_val FROM dual;
  SELECT max(id) - seq_next_val INTO seq_forms_xml_reorder_inc FROM forms_xml_reorder;
  IF seq_forms_xml_reorder_inc > 0 THEN
    EXECUTE IMMEDIATE 'alter sequence seq_forms_xml_reorder increment by ' || seq_forms_xml_reorder_inc;
    EXECUTE IMMEDIATE 'SELECT seq_forms_xml_reorder.nextval FROM dual' INTO seq_forms_xml_reorder_inc;
    EXECUTE IMMEDIATE 'ALTER SEQUENCE seq_forms_xml_reorder INCREMENT BY 1';
	END IF;
END;
/

-- Convert numeric ID column to varchar by adding new column and then removing old
ALTER TABLE forms_xml_reorder DROP CONSTRAINT ID_PK;
ALTER TABLE forms_xml_reorder RENAME COLUMN ID TO ID_OLD;
ALTER TABLE forms_xml_reorder ADD ID VARCHAR2(30);
UPDATE forms_xml_reorder SET ID = TO_CHAR(ID_OLD);
ALTER TABLE forms_xml_reorder ADD CONSTRAINT ID_PK PRIMARY KEY(ID);
ALTER TABLE forms_xml_reorder DROP COLUMN ID_OLD;

INSERT INTO forms_xml_reorder (ID, NODE_TO_MOVE, TARGET_NODE, MOVE_AFTER, UPDATE_USER, UPDATE_TIMESTAMP, VER_NBR, OBJ_ID)
VALUES ('RESBOOT-1000', 'SF424_2_1:Title', 'SF424_2_1:Applicant', 'Y', 'admin', SYSDATE, '1', SYS_GUID());

INSERT INTO forms_xml_reorder (ID, NODE_TO_MOVE, TARGET_NODE, MOVE_AFTER, UPDATE_USER, UPDATE_TIMESTAMP, VER_NBR, OBJ_ID)
VALUES ('RESBOOT-1001', 'SF424_2_1:Title', 'SF424_2_1:DepartmentName', 'Y', 'admin', SYSDATE, '1', SYS_GUID());

INSERT INTO forms_xml_reorder (ID, NODE_TO_MOVE, TARGET_NODE, MOVE_AFTER, UPDATE_USER, UPDATE_TIMESTAMP, VER_NBR, OBJ_ID)
VALUES ('RESBOOT-1002', 'SF424_2_1:Title', 'SF424_2_1:DivisionName', 'Y', 'admin', SYSDATE, '1', SYS_GUID());

INSERT INTO forms_xml_reorder (ID, NODE_TO_MOVE, TARGET_NODE, MOVE_AFTER, UPDATE_USER, UPDATE_TIMESTAMP, VER_NBR, OBJ_ID)
VALUES ('RESBOOT-1003', 'SF424_2_1:Title', 'SF424_2_1:ContactPerson', 'Y', 'admin', SYSDATE, '1', SYS_GUID());

INSERT INTO forms_xml_reorder (ID, NODE_TO_MOVE, TARGET_NODE, MOVE_AFTER, UPDATE_USER, UPDATE_TIMESTAMP, VER_NBR, OBJ_ID)
VALUES ('RESBOOT-1004', 'SF424_2_1:OrganizationAffiliation', 'SF424_2_1:Applicant', 'Y', 'admin', SYSDATE, '1', SYS_GUID());

INSERT INTO forms_xml_reorder (ID, NODE_TO_MOVE, TARGET_NODE, MOVE_AFTER, UPDATE_USER, UPDATE_TIMESTAMP, VER_NBR, OBJ_ID)
VALUES ('RESBOOT-1005', 'SF424_2_1:OrganizationAffiliation', 'SF424_2_1:DepartmentName', 'Y', 'admin', SYSDATE, '1', SYS_GUID());

INSERT INTO forms_xml_reorder (ID, NODE_TO_MOVE, TARGET_NODE, MOVE_AFTER, UPDATE_USER, UPDATE_TIMESTAMP, VER_NBR, OBJ_ID)
VALUES ('RESBOOT-1006', 'SF424_2_1:OrganizationAffiliation', 'SF424_2_1:DivisionName', 'Y', 'admin', SYSDATE, '1', SYS_GUID());

INSERT INTO forms_xml_reorder (ID, NODE_TO_MOVE, TARGET_NODE, MOVE_AFTER, UPDATE_USER, UPDATE_TIMESTAMP, VER_NBR, OBJ_ID)
VALUES ('RESBOOT-1007', 'SF424_2_1:OrganizationAffiliation', 'SF424_2_1:ContactPerson', 'Y', 'admin', SYSDATE, '1', SYS_GUID());

INSERT INTO forms_xml_reorder (ID, NODE_TO_MOVE, TARGET_NODE, MOVE_AFTER, UPDATE_USER, UPDATE_TIMESTAMP, VER_NBR, OBJ_ID)
VALUES ('RESBOOT-1008', 'SF424_2_1:OrganizationAffiliation', 'SF424_2_1:Title', 'Y', 'admin', SYSDATE, '1', SYS_GUID());
