---
-- #%L
-- %%
-- Copyright (C) 2005 - 2020 Kuali, Inc. - All Rights Reserved
-- %%
-- You may use and modify this code under the terms of the Kuali, Inc.
-- Pre-Release License Agreement. You may not distribute it.
-- 
-- You should have received a copy of the Kuali, Inc. Pre-Release License
-- Agreement with this file. If not, please write to license@kuali.co.
-- #L%
---


-- Narratives
INSERT INTO VALID_NARR_FORMS (VALID_NARR_FORMS_ID, FORM_NAME, NARRATIVE_TYPE_CODE, MANDATORY, UPDATE_USER, UPDATE_TIMESTAMP, OBJ_ID)
VALUES (SEQ_VALID_NARR_FORMS_ID.NEXTVAL, 'ED_SF424_Supplement_2_0-V2.0', (SELECT NARRATIVE_TYPE_CODE FROM NARRATIVE_TYPE WHERE DESCRIPTION = 'ED_SF424_Supplement_Attachment'), 'N', 'admin', sysdate, sys_guid());

-- Errors
INSERT INTO S2S_ERROR (S2S_ERROR_ID, MESSAGE_KEY, MESSAGE, FIX_LINK, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
VALUES (SEQ_S2S_ERROR_ID.NEXTVAL, '/GrantApplication/Forms/ED_SF424_Supplement_2_0/IsNoviceApplicant', 'Please answer all the questions for the form "ED_SF424_Supplement_2_0-V2.0" within the Questions tab.', 'questions', sysdate, 'admin', 1, sys_guid());

-- Questionnaire
INSERT INTO QUESTIONNAIRE (QUESTIONNAIRE_REF_ID, QUESTIONNAIRE_ID, SEQUENCE_NUMBER, NAME, DESCRIPTION, UPDATE_TIMESTAMP, UPDATE_USER, IS_FINAL, VER_NBR, OBJ_ID)
VALUES(SEQ_QUESTIONNAIRE_REF_ID.NEXTVAL, -9, 1, 'EDSF424 Supplement 2.0 Questions', 'These questions support EDSF424 Supplement 2.0 Grants.gov forms.', sysdate, 'admin', 'Y', 1, sys_guid());

INSERT INTO S2S_FORM_TO_QUESTIONNAIRE (S2S_FORM_TO_QUESTIONNAIRE_ID, OPP_NAME_SPACE, FORM_NAME, QUESTIONNAIRE_ID, UPDATE_TIMESTAMP, UPDATE_USER, OBJ_ID, VER_NBR)
VALUES (SEQ_QUESTIONNAIRE_REF_ID.NEXTVAL, 'http://apply.grants.gov/forms/ED_SF424_Supplement_2_0-V2.0', 'ED_SF424_Supplement_2_0-V2.0', '-9', sysdate, 'admin', sys_guid(), 1);

INSERT INTO QUESTIONNAIRE_QUESTIONS (QUESTIONNAIRE_QUESTIONS_ID, QUESTIONNAIRE_REF_ID_FK, QUESTION_REF_ID_FK, QUESTION_NUMBER, PARENT_QUESTION_NUMBER, QUESTION_SEQ_NUMBER, CONDITION_FLAG, CONDITION_TYPE, CONDITION_VALUE, UPDATE_USER, UPDATE_TIMESTAMP, OBJ_ID, VER_NBR, RULE_ID)
VALUES (SEQ_QUESTIONNAIRE_REF_ID.NEXTVAL, (SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE QUESTIONNAIRE_ID = -9),
        (SELECT QUESTION_REF_ID FROM QUESTION WHERE QUESTION_ID=133 AND SEQUENCE_NUMBER=(select max(SEQUENCE_NUMBER) from QUESTION WHERE QUESTION_ID = 133)),
        1, 0, 1, 'N', null, 'null', 'admin', sysdate, sys_guid(), 1, null);

INSERT INTO QUESTIONNAIRE_USAGE (QUESTIONNAIRE_USAGE_ID, MODULE_ITEM_CODE, MODULE_SUB_ITEM_CODE, QUESTIONNAIRE_REF_ID_FK, QUESTIONNAIRE_SEQUENCE_NUMBER, RULE_ID, QUESTIONNAIRE_LABEL, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID, IS_MANDATORY)
VALUES (SEQ_QUESTIONNAIRE_REF_ID.NEXTVAL, 3, 2, (SELECT QUESTIONNAIRE_REF_ID FROM QUESTIONNAIRE WHERE QUESTIONNAIRE_ID = -9 AND SEQUENCE_NUMBER = 1), 1, null,'EDSF424 Supplement 2.0 Questions', sysdate, 'admin', 1, sys_guid(), 'N');

