---
-- #%L
-- %%
-- Copyright (C) 2005 - 2020 Kuali, Inc. - All Rights Reserved
-- %%
-- You may use and modify this code under the terms of the Kuali, Inc.
-- Pre-Release License Agreement. You may not distribute it.
-- 
-- You should have received a copy of the Kuali, Inc. Pre-Release License
-- Agreement with this file. If not, please write to license@kuali.co.
-- #L%
---


UPDATE EXCON_PROJECT_ASSOC_DOC_TYPE
SET ASSOC_DOC_TYPE_CLASS_NAME = 'org.kuali.coeus.propdev.impl.core.LookupableDevelopmentProposal'
WHERE ASSOC_DOC_TYPE_CODE = 'DEVPROP';

ALTER TABLE SPECIAL_REVIEW
    MODIFY SPECIAL_REVIEW_CODE VARCHAR(30);

INSERT INTO SPECIAL_REVIEW (SPECIAL_REVIEW_CODE, DESCRIPTION, UPDATE_USER, UPDATE_TIMESTAMP, OBJ_ID, VER_NBR, SORT_ID)
VALUES ('RESBOOT-1000', 'Export Control', 'admin', SYSDATE, SYS_GUID(), 1, 13);

ALTER TABLE SPECIAL_REVIEW_USAGE
    MODIFY SPECIAL_REVIEW_CODE VARCHAR(30);

ALTER TABLE award_special_review ADD (special_review_code_varchar varchar2(30));

UPDATE award_special_review SET special_review_code_varchar = TO_CHAR(special_review_code);

ALTER TABLE award_special_review DROP (special_review_code);

ALTER TABLE award_special_review RENAME COLUMN special_review_code_varchar TO special_review_code;

ALTER TABLE AWARD_SPECIAL_REVIEW
    MODIFY APPROVAL_TYPE_CODE VARCHAR(30);
    
ALTER TABLE SP_REV_APPROVAL_TYPE
    MODIFY APPROVAL_TYPE_CODE VARCHAR(30);

ALTER TABLE PROPOSAL_SPECIAL_REVIEW
    MODIFY SPECIAL_REVIEW_CODE VARCHAR(30);

ALTER TABLE PROPOSAL_SPECIAL_REVIEW
    MODIFY APPROVAL_TYPE_CODE VARCHAR(30);

ALTER TABLE EPS_PROP_SPECIAL_REVIEW
    MODIFY SPECIAL_REVIEW_CODE VARCHAR(30);

ALTER TABLE EPS_PROP_SPECIAL_REVIEW
    MODIFY APPROVAL_TYPE_CODE VARCHAR(30);

INSERT INTO SP_REV_APPROVAL_TYPE (APPROVAL_TYPE_CODE, DESCRIPTION, UPDATE_TIMESTAMP, UPDATE_USER, VER_NBR, OBJ_ID)
VALUES ('RESBOOT-1000', 'Link to EXCON', SYSDATE, 'admin', 1, SYS_GUID());

-- Usages
CREATE SEQUENCE SEQ_SPECIAL_REVIEW_USAGE_ID INCREMENT BY 1 START WITH 10000 NOCACHE;

-- Award
INSERT INTO SPECIAL_REVIEW_USAGE (SPECIAL_REVIEW_USAGE_ID, SPECIAL_REVIEW_CODE, MODULE_CODE, ACTIVE_FLAG, UPDATE_TIMESTAMP, UPDATE_USER, OBJ_ID, GLOBAL_FLAG)
VALUES (SEQ_SPECIAL_REVIEW_USAGE_ID.NEXTVAL, 'RESBOOT-1000', 1, 'Y', SYSDATE, 'admin', SYS_GUID(), 'Y');

-- IP
INSERT INTO SPECIAL_REVIEW_USAGE (SPECIAL_REVIEW_USAGE_ID, SPECIAL_REVIEW_CODE, MODULE_CODE, ACTIVE_FLAG, UPDATE_TIMESTAMP, UPDATE_USER, OBJ_ID, GLOBAL_FLAG)
VALUES (SEQ_SPECIAL_REVIEW_USAGE_ID.NEXTVAL, 'RESBOOT-1000', 2, 'Y', SYSDATE, 'admin', SYS_GUID(), 'Y');

-- PD
INSERT INTO SPECIAL_REVIEW_USAGE (SPECIAL_REVIEW_USAGE_ID, SPECIAL_REVIEW_CODE, MODULE_CODE, ACTIVE_FLAG, UPDATE_TIMESTAMP, UPDATE_USER, OBJ_ID, GLOBAL_FLAG)
VALUES (SEQ_SPECIAL_REVIEW_USAGE_ID.NEXTVAL, 'RESBOOT-1000', 3, 'Y', SYSDATE, 'admin', SYS_GUID(), 'Y');
