---
-- #%L
-- %%
-- Copyright (C) 2005 - 2021 Kuali, Inc. - All Rights Reserved
-- %%
-- You may use and modify this code under the terms of the Kuali, Inc.
-- Pre-Release License Agreement. You may not distribute it.
-- 
-- You should have received a copy of the Kuali, Inc. Pre-Release License
-- Agreement with this file. If not, please write to license@kuali.co.
-- #L%
---
CREATE TABLE ORGANIZATION_AUDIT_ACC_TYPE (
  CODE VARCHAR2(3) NOT NULL,
  DESCRIPTION VARCHAR2(200) NOT NULL,
  ACTIVE_FLAG CHAR(1) NOT NULL,
  UPDATE_TIMESTAMP DATE NOT NULL,
  UPDATE_USER VARCHAR2(60) NOT NULL,
  VER_NBR NUMBER(8,0) DEFAULT 1 NOT NULL,
  OBJ_ID VARCHAR2(36) NOT NULL);

ALTER TABLE ORGANIZATION_AUDIT_ACC_TYPE
ADD CONSTRAINT PK_ORGANIZATION_AUDIT_ACC_TYPE
PRIMARY KEY (CODE);

ALTER TABLE ORGANIZATION_AUDIT_ACC_TYPE
ADD CONSTRAINT UQ_ORGANIZATION_AUDIT_ACC_TYPE
UNIQUE (OBJ_ID);

INSERT INTO ORGANIZATION_AUDIT_ACC_TYPE (CODE,DESCRIPTION,ACTIVE_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR)
VALUES (1,'Accepted','Y','admin',SYSDATE,SYS_GUID(),1);

INSERT INTO ORGANIZATION_AUDIT_ACC_TYPE (CODE,DESCRIPTION,ACTIVE_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR)
VALUES (2,'Rejected','Y','admin',SYSDATE,SYS_GUID(),1);

INSERT INTO ORGANIZATION_AUDIT_ACC_TYPE (CODE,DESCRIPTION,ACTIVE_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR)
VALUES (3,'Requested','Y','admin',SYSDATE,SYS_GUID(),1);

INSERT INTO ORGANIZATION_AUDIT_ACC_TYPE (CODE,DESCRIPTION,ACTIVE_FLAG,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR)
VALUES (4,'Reviewed','Y','admin',SYSDATE,SYS_GUID(),1);


ALTER TABLE ORGANIZATION_AUDIT MODIFY AUDIT_ACCEPTED VARCHAR2(3);

UPDATE ORGANIZATION_AUDIT SET AUDIT_ACCEPTED = '1' WHERE AUDIT_ACCEPTED = 'Y';
UPDATE ORGANIZATION_AUDIT SET AUDIT_ACCEPTED = '2' WHERE AUDIT_ACCEPTED = 'N';

ALTER TABLE ORGANIZATION_AUDIT
ADD CONSTRAINT FK_ORGANIZATION_AUDIT_ACC
FOREIGN KEY (AUDIT_ACCEPTED)
REFERENCES ORGANIZATION_AUDIT_ACC_TYPE (CODE);
