---
-- #%L
-- %%
-- Copyright (C) 2005 - 2021 Kuali, Inc. - All Rights Reserved
-- %%
-- You may use and modify this code under the terms of the Kuali, Inc.
-- Pre-Release License Agreement. You may not distribute it.
-- 
-- You should have received a copy of the Kuali, Inc. Pre-Release License
-- Agreement with this file. If not, please write to license@kuali.co.
-- #L%
---


DECLARE
  tmp_proposal_number varchar2(8);

  CURSOR CUR IS SELECT proposal_number FROM proposal GROUP BY proposal_number, sequence_number HAVING COUNT(*) > 1;

BEGIN

  OPEN CUR;

  LOOP
    FETCH CUR INTO tmp_proposal_number;
    EXIT WHEN CUR%NOTFOUND;

    UPDATE proposal
    SET sequence_number = (
      SELECT c.correct_seq
      FROM (
       SELECT ROWNUM AS correct_seq, proposal_id, proposal_number, sequence_number
        FROM proposal
        WHERE proposal_number = tmp_proposal_number
        ORDER BY proposal_id
      ) c
      WHERE proposal.proposal_id = c.proposal_id
    )
    WHERE proposal_number = tmp_proposal_number;

  END LOOP;

  CLOSE CUR;
END;
