---
-- #%L
-- %%
-- Copyright (C) 2005 - 2021 Kuali, Inc. - All Rights Reserved
-- %%
-- You may use and modify this code under the terms of the Kuali, Inc.
-- Pre-Release License Agreement. You may not distribute it.
-- 
-- You should have received a copy of the Kuali, Inc. Pre-Release License
-- Agreement with this file. If not, please write to license@kuali.co.
-- #L%
---


alter table award_report_tracking add award_id number(22);

update award_report_tracking art
SET (art.award_id, art.award_report_term_id) = (
	SELECT award_id, award_report_terms_id
	from award_report_terms
	where award_id in (
		select award_id from award
		where award_sequence_status in ('PENDING', 'ACTIVE'))
	and art.award_number = award_number
	and art.report_class_code = report_class_code
	and art.report_code = report_code
	and art.frequency_code = frequency_code
	and (art.frequency_base_code = frequency_base_code or
		(art.frequency_base_code is null and frequency_base_code is null))
	and (art.osp_distribution_code = osp_distribution_code or
		(art.osp_distribution_code is null and osp_distribution_code is null))
	and (art.due_date = due_date or frequency_base_code in ('1', '2', '3', '4', '5')));
