---
-- #%L
-- %%
-- Copyright (C) 2005 - 2021 Kuali, Inc. - All Rights Reserved
-- %%
-- You may use and modify this code under the terms of the Kuali, Inc.
-- Pre-Release License Agreement. You may not distribute it.
-- 
-- You should have received a copy of the Kuali, Inc. Pre-Release License
-- Agreement with this file. If not, please write to license@kuali.co.
-- #L%
---


INSERT INTO PROTO_CORRESP_TEMPL (PROTO_CORRESP_TEMPL_ID,PROTO_CORRESP_TYPE_CODE,COMMITTEE_ID,FILE_NAME,CORRESPONDENCE_TEMPLATE,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR)
    VALUES (SEQ_PROTO_CORRESP_TEMPL.NEXTVAL,(SELECT PROTO_CORRESP_TYPE_CODE FROM PROTO_CORRESP_TYPE WHERE DESCRIPTION = 'Committee Roster Report'),'DEFAULT','DEFAULT-15-CommitteeRosterReport.xsl',EMPTY_CLOB(),'admin',SYSDATE,SYS_GUID(),1);
DECLARE    data CLOB; buffer VARCHAR2(32000);
BEGIN
SELECT CORRESPONDENCE_TEMPLATE INTO data FROM PROTO_CORRESP_TEMPL WHERE PROTO_CORRESP_TYPE_CODE = (SELECT PROTO_CORRESP_TYPE_CODE FROM PROTO_CORRESP_TYPE WHERE DESCRIPTION = 'Committee Roster Report') AND COMMITTEE_ID = 'DEFAULT' FOR UPDATE;
buffer := '<?xml version="1.0" encoding="UTF-8"?>
<!--Designed and generated by Altova StyleVision Enterprise Edition 2008 rel. 2 - see http://www.altova.com/stylevision for more information.-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fn="http://www.w3.org/2005/xpath-functions" xmlns:n1="http://irb.mit.edu/irbnamespace" xmlns:xdt="http://www.w3.org/2005/xpath-datatypes" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:fo="http://www.w3.org/1999/XSL/Format">
    <xsl:output version="1.0" method="xml" encoding="UTF-8" indent="no"/>
    <xsl:param name="SV_OutputFormat" select="''PDF''"/>
    <xsl:variable name="XML" select="/"/>
    <xsl:variable name="fo:layout-master-set">
        <fo:layout-master-set>
            <fo:simple-page-master master-name="default-page" page-height="11in" page-width="8.5in" margin-left="0.6in" margin-right="0.6in">
                <fo:region-body margin-top="0.89in" margin-bottom="0.79in"/>
            </fo:simple-page-master>
        </fo:layout-master-set>
    </xsl:variable>
    <xsl:template match="/">
        <fo:root>
            <xsl:copy-of select="$fo:layout-master-set"/>
            <fo:page-sequence master-reference="default-page" initial-page-number="1" format="1">
                <fo:flow flow-name="xsl-region-body">
                    <fo:block>
                        <xsl:for-each select="$XML">
                            <fo:inline-container>
                                <fo:block>
                                    <xsl:text>&#x2029;</xsl:text>
                                </fo:block>
                            </fo:inline-container>
                            <fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
                                <fo:table-column column-width="proportional-column-width(1)"/>
                                <fo:table-body start-indent="0pt">
                                    <fo:table-row>
                                        <fo:table-cell border="solid 1pt gray" padding="2pt" text-align="center" display-align="center">
                                            <fo:block>
                                                <xsl:for-each select="n1:Committee">
                                                    <xsl:for-each select="n1:CommitteeMasterData">
                                                        <xsl:for-each select="n1:CommitteeName">
                                                            <xsl:variable name="value-of-template">
                                                                <xsl:apply-templates/>
                                                            </xsl:variable>
                                                            <xsl:choose>
                                                                <xsl:when test="contains(string($value-of-template),''&#x2029;'')">
                                                                    <fo:block font-weight="bold">
                                                                        <xsl:copy-of select="$value-of-template"/>
                                                                    </fo:block>
                                                                </xsl:when>
                                                                <xsl:otherwise>
                                                                    <fo:inline font-weight="bold">
                                                                        <xsl:copy-of select="$value-of-template"/>
                                                                    </fo:inline>
                                                                </xsl:otherwise>
                                                            </xsl:choose>
                                                        </xsl:for-each>
                                                    </xs';
    DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE    data CLOB; buffer VARCHAR2(32000);
BEGIN
SELECT CORRESPONDENCE_TEMPLATE INTO data FROM PROTO_CORRESP_TEMPL WHERE PROTO_CORRESP_TYPE_CODE = (SELECT PROTO_CORRESP_TYPE_CODE FROM PROTO_CORRESP_TYPE WHERE DESCRIPTION = 'Committee Roster Report') AND COMMITTEE_ID = 'DEFAULT' FOR UPDATE;
buffer := 'l:for-each>
                                                </xsl:for-each>
                                            </fo:block>
                                        </fo:table-cell>
                                    </fo:table-row>
                                </fo:table-body>
                            </fo:table>
                            <fo:block>
                                <fo:leader leader-pattern="space"/>
                            </fo:block>
                            <fo:inline-container>
                                <fo:block>
                                    <xsl:text>&#x2029;</xsl:text>
                                </fo:block>
                            </fo:inline-container>
                            <fo:block margin="0pt">
                                <fo:block>
                                    <fo:inline-container>
                                        <fo:block>
                                            <xsl:text>&#x2029;</xsl:text>
                                        </fo:block>
                                    </fo:inline-container>
                                    <fo:table table-layout="fixed" width="100%" border-spacing="2pt">
                                        <fo:table-column column-width="141"/>
                                        <fo:table-column column-width="proportional-column-width(1)"/>
                                        <fo:table-body start-indent="0pt">
                                            <fo:table-row>
                                                <fo:table-cell padding="2pt" display-align="center">
                                                    <fo:block>
                                                        <fo:inline font-weight="bold">
                                                            <xsl:text>Home Unit</xsl:text>
                                                        </fo:inline>
                                                    </fo:block>
                                                </fo:table-cell>
                                                <fo:table-cell padding="2pt" display-align="center">
                                                    <fo:block>
                                                        <xsl:for-each select="n1:Committee">
                                                         <xsl:for-each select="n1:CommitteeMasterData">
                                                                <xsl:for-each select="n1:HomeUnitName">
                                                                    <xsl:variable name="value-of-template">
                                                                        <xsl:apply-templates/>
                                                                    </xsl:variable>
                                                                    <xsl:choose>
                                                                        <xsl:when test="contains(string($value-of-template),''&#x2029;'')">
                                                                            <fo:block>
                                                                                <xsl:copy-of select="$value-of-template"/>
                                                                            </fo:block>
                                                                        </xsl:when>
                                                                        <xsl:otherwise>
                                                                            <fo:inline>
                                                                                <xsl:copy-of select="$value-of-template"/>
                                                                            </fo:inline>
                                                                        </xsl:otherwise>
                                                                    </xsl:choose>
           ';
    DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE    data CLOB; buffer VARCHAR2(32000);
BEGIN
SELECT CORRESPONDENCE_TEMPLATE INTO data FROM PROTO_CORRESP_TEMPL WHERE PROTO_CORRESP_TYPE_CODE = (SELECT PROTO_CORRESP_TYPE_CODE FROM PROTO_CORRESP_TYPE WHERE DESCRIPTION = 'Committee Roster Report') AND COMMITTEE_ID = 'DEFAULT' FOR UPDATE;
buffer := '                                                     </xsl:for-each>
                                                            </xsl:for-each>
                                                        </xsl:for-each>
                                                    </fo:block>
                                                </fo:table-cell>
                                            </fo:table-row>
                                            <fo:table-row>
                                                <fo:table-cell padding="2pt" display-align="center">
                                                    <fo:block>
                                                        <fo:inline font-weight="bold">
                                                            <xsl:text>Research Area</xsl:text>
                                                        </fo:inline>
                                                    </fo:block>
                                                </fo:table-cell>
                                                <fo:table-cell padding="2pt" display-align="center">
                                                    <fo:block>
                                                        <xsl:for-each select="n1:Committee">
                                                            <xsl:for-each select="n1:ResearchArea">
                                                                <xsl:for-each select="n1:ResearchAreaDescription">
                                                                    <xsl:variable name="value-of-template">
                                                                        <xsl:apply-templates/>
                                                                    </xsl:variable>
                                                                    <xsl:choose>
                                                                        <xsl:when test="contains(string($value-of-template),''&#x2029;'')">
                                                                            <fo:block>
                                                                                <xsl:copy-of select="$value-of-template"/>
                                                                            </fo:block>
                                                                        </xsl:when>
                                                                        <xsl:otherwise>
                                                                            <fo:inline>
                                                                                <xsl:copy-of select="$value-of-template"/>
                                                                            </fo:inline>
                                                                        </xsl:otherwise>
                                                                    </xsl:choose>
                                                                </xsl:for-each>
                                                            </xsl:for-each>
                                                        </xsl:for-each>
                                                    </fo:block>
                                                </fo:table-cell>
                                            </fo:table-row>
                                        </fo:table-body>
                                    </fo:table>
                                    <fo:block>
                                        <fo:leader leader-pattern="space"/>
                                    </fo:block>
                                    <fo:inline-container>
                                        <fo:block>
                                            <xsl:text>&#x2029;</xsl:text>
                                        </fo:block>
                                    </fo:inline-container>
                                    <fo:block margin="0pt">
                         ';
    DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE    data CLOB; buffer VARCHAR2(32000);
BEGIN
SELECT CORRESPONDENCE_TEMPLATE INTO data FROM PROTO_CORRESP_TEMPL WHERE PROTO_CORRESP_TYPE_CODE = (SELECT PROTO_CORRESP_TYPE_CODE FROM PROTO_CORRESP_TYPE WHERE DESCRIPTION = 'Committee Roster Report') AND COMMITTEE_ID = 'DEFAULT' FOR UPDATE;
buffer := '               <fo:block>
                                            <fo:block>
                                                <fo:leader leader-pattern="space"/>
                                            </fo:block>
                                            <fo:inline-container>
                                                <fo:block>
                                                    <xsl:text>&#x2029;</xsl:text>
                                                </fo:block>
                                            </fo:inline-container>
                                            <fo:block margin="0pt">
                                                <fo:block>
                                                    <fo:block>
                                                        <fo:leader leader-pattern="space"/>
                                                    </fo:block>
                                                    <fo:inline-container>
                                                        <fo:block>
                                                            <xsl:text>&#x2029;</xsl:text>
                                                        </fo:block>
                                                    </fo:inline-container>
                                                    <fo:block margin="0pt">
                                                        <fo:block>
                                                            <fo:block>
                                                                <fo:leader leader-pattern="space"/>
                                                            </fo:block>
                                                            <fo:inline-container>
                                                                <fo:block>
                                                                    <xsl:text>&#x2029;</xsl:text>
                                                                </fo:block>
                                                            </fo:inline-container>
                                                            <fo:block margin="0pt">
                                                                <fo:block>
                                                                    <fo:block>
                                                                        <fo:leader leader-pattern="space"/>
                                                                    </fo:block>
                                                                    <fo:inline-container>
                                                                        <fo:block>
                                                                            <xsl:text>&#x2029;</xsl:text>
                                                                        </fo:block>
                                                                    </fo:inline-container>
                                                                 <fo:block margin="0pt">
                                                                        <fo:block>
                                                                            <fo:block>
                                                                                <fo:leader leader-pattern="space"/>
                                                                            </fo:block>
                                                                            <fo:inline-container>
                                                                                <fo:block>
                                                                                    <xsl:text>&#x2029;</xsl:text>
                                                                                </fo:block>
                                                                            </fo:inline-container>
                                                                            <fo:block ma';
    DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE    data CLOB; buffer VARCHAR2(32000);
BEGIN
SELECT CORRESPONDENCE_TEMPLATE INTO data FROM PROTO_CORRESP_TEMPL WHERE PROTO_CORRESP_TYPE_CODE = (SELECT PROTO_CORRESP_TYPE_CODE FROM PROTO_CORRESP_TYPE WHERE DESCRIPTION = 'Committee Roster Report') AND COMMITTEE_ID = 'DEFAULT' FOR UPDATE;
buffer := 'rgin="0pt">
                                                                                <fo:block>
                                                                                    <fo:inline font-weight="bold" text-decoration="underline">
                                                                                        <xsl:text>Active Committee Members</xsl:text>
                                                                                    </fo:inline>
                                                                                </fo:block>
                                                                            </fo:block>
                                                                        </fo:block>
                                                                    </fo:block>
                                                                    <fo:block>
                                                                        <fo:leader leader-pattern="space"/>
                                                                    </fo:block>
                                                                    <fo:inline-container>
                                                                        <fo:block>
                                                                            <xsl:text>&#x2029;</xsl:text>
                                                                        </fo:block>
                                                                    </fo:inline-container>
                                                                    <fo:block margin="0pt">
                                                                        <fo:block>
                                                                            <xsl:for-each select="n1:Committee">
                                                                                <xsl:for-each select="n1:CommitteeMember">
                                                                                    <fo:inline-container>
                                                                                        <fo:block>
                                                                                            <xsl:text>&#x2029;</xsl:text>
                                                                                        </fo:block>
                                                                                    </fo:inline-container>
                                                                                    <fo:table table-layout="fixed" width="100%" border-spacing="2pt">
                                                                                        <fo:table-column column-width="proportional-column-width(1)"/>
                                                                                        <fo:table-body start-indent="0pt">
                                                                                            <fo:table-row>
                                                                                                <fo:table-cell padding="2pt" display-align="center">
                                                                                                    <fo:block>
                                                                                                        <xsl:for-each select="n1:Person">
                                                                                                            <xsl:for-each select="n1:Fullname">
                                                                                                                <xsl:variable name="value-of-template">
                                                                                                                    <xsl:apply-templates/>
                                                                                                                </xsl:variable>
                     ';
    DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE    data CLOB; buffer VARCHAR2(32000);
BEGIN
SELECT CORRESPONDENCE_TEMPLATE INTO data FROM PROTO_CORRESP_TEMPL WHERE PROTO_CORRESP_TYPE_CODE = (SELECT PROTO_CORRESP_TYPE_CODE FROM PROTO_CORRESP_TYPE WHERE DESCRIPTION = 'Committee Roster Report') AND COMMITTEE_ID = 'DEFAULT' FOR UPDATE;
buffer := '                                                                                           <xsl:choose>
                                                                                                                    <xsl:when test="contains(string($value-of-template),''&#x2029;'')">
                                                                                                                        <fo:block font-weight="bold">
                                                                                                                            <xsl:copy-of select="$value-of-template"/>
                                                                                                                        </fo:block>
                                                                                                                    </xsl:when>
                                                                                                                    <xsl:otherwise>
                                                                                                                        <fo:inline font-weight="bold">
                                                                                                                            <xsl:copy-of select="$value-of-template"/>
                                                                                                                        </fo:inline>
                                                                                                                    </xsl:otherwise>
                                                                                                                </xsl:choose>
                                                                                                            </xsl:for-each>
                                                                                                        </xsl:for-each>
                                                                                                    </fo:block>
                                                                                                </fo:table-cell>
                                                                                            </fo:table-row>
                                                                                            <fo:table-row>
                                                                                                <fo:table-cell padding="2pt" display-align="center">
                                                                                                    <fo:block>
                                                                                                        <xsl:for-each select="n1:Person">
                                                                                                            <xsl:for-each select="n1:DirectoryTitle">
                                                                                                                <xsl:variable name="value-of-template">
                                                                                                                    <xsl:apply-templates/>
                                                                                                                </xsl:variable>
                                                                                                                <xsl:choose>
                                                                                                                    <xsl:when test="contains(string($value-of-template),''&#x2029;'')">
                                                                                                                        <fo:block>
                                                                                                                            <xsl:copy-of select="$value-of-template"/>
                                       ';
    DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE    data CLOB; buffer VARCHAR2(32000);
BEGIN
SELECT CORRESPONDENCE_TEMPLATE INTO data FROM PROTO_CORRESP_TEMPL WHERE PROTO_CORRESP_TYPE_CODE = (SELECT PROTO_CORRESP_TYPE_CODE FROM PROTO_CORRESP_TYPE WHERE DESCRIPTION = 'Committee Roster Report') AND COMMITTEE_ID = 'DEFAULT' FOR UPDATE;
buffer := '                                                                                 </fo:block>
                                                                                                                    </xsl:when>
                                                                                                                    <xsl:otherwise>
                                                                                                                        <fo:inline>
                                                                                                                            <xsl:copy-of select="$value-of-template"/>
                                                                                                                        </fo:inline>
                                                                                                                    </xsl:otherwise>
                                                                                                                </xsl:choose>
                                                                                                            </xsl:for-each>
                                                                                                        </xsl:for-each>
                                                                                                    </fo:block>
                                                                                                </fo:table-cell>
                                                                                            </fo:table-row>
                                                                                            <fo:table-row>
                                                                                                <fo:table-cell padding="2pt" display-align="center">
                                                                                                    <fo:block>
                                                                                                        <xsl:for-each select="n1:MemberType">
                                                                                                            <xsl:variable name="value-of-template">
                                                                                                                <xsl:apply-templates/>
                                                                                                            </xsl:variable>
                                                                                                            <xsl:choose>
                                                                                                                <xsl:when test="contains(string($value-of-template),''&#x2029;'')">
                                                                                                                    <fo:block>
                                                                                                                        <xsl:copy-of select="$value-of-template"/>
                                                                                                                    </fo:block>
                                                                                                                </xsl:when>
                                                                                                                <xsl:otherwise>
                                                                                                                    <fo:inline>
                                                                                                                        <xsl:copy-of select="$value-of-template"/>
                                                                                                                    </fo:inline>
                                                                          ';
    DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE    data CLOB; buffer VARCHAR2(32000);
BEGIN
SELECT CORRESPONDENCE_TEMPLATE INTO data FROM PROTO_CORRESP_TEMPL WHERE PROTO_CORRESP_TYPE_CODE = (SELECT PROTO_CORRESP_TYPE_CODE FROM PROTO_CORRESP_TYPE WHERE DESCRIPTION = 'Committee Roster Report') AND COMMITTEE_ID = 'DEFAULT' FOR UPDATE;
buffer := '                                      </xsl:otherwise>
                                                                                                            </xsl:choose>
                                                                                                        </xsl:for-each>
                                                                                                    </fo:block>
                                                                                                </fo:table-cell>
                                                                                            </fo:table-row>
                                                                                            <fo:table-row>
                                                                                                <fo:table-cell padding="2pt" display-align="center">
                                                                                                    <fo:block>
                                                                                                        <xsl:for-each select="n1:CommitteeMemberRole">
                                                                                                            <xsl:for-each select="n1:MemberRoleDesc">
                                                                                                                <xsl:variable name="value-of-template">
                                                                                                                    <xsl:apply-templates/>
                                                                                                                </xsl:variable>
                                                                                                                <xsl:choose>
                                                                                                                    <xsl:when test="contains(string($value-of-template),''&#x2029;'')">
                                                                                                                        <fo:block>
                                                                                                                            <xsl:copy-of select="$value-of-template"/>
                                                                                                                        </fo:block>
                                                                                                                    </xsl:when>
                                                                                                                    <xsl:otherwise>
                                                                                                                        <fo:inline>
                                                                                                                            <xsl:copy-of select="$value-of-template"/>
                                                                                                                        </fo:inline>
                                                                                                                    </xsl:otherwise>
                                                                                                                </xsl:choose>
                                                                                                            </xsl:for-each>
                                                                                                        </xsl:for-each>
                                                                                                    </fo:block>
                                                                                                </fo:table-cell>
                                                                                            </fo:table-row>
                  ';
    DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE    data CLOB; buffer VARCHAR2(32000);
BEGIN
SELECT CORRESPONDENCE_TEMPLATE INTO data FROM PROTO_CORRESP_TEMPL WHERE PROTO_CORRESP_TYPE_CODE = (SELECT PROTO_CORRESP_TYPE_CODE FROM PROTO_CORRESP_TYPE WHERE DESCRIPTION = 'Committee Roster Report') AND COMMITTEE_ID = 'DEFAULT' FOR UPDATE;
buffer := '                                                                      </fo:table-body>
                                                                                    </fo:table>
                                                                                </xsl:for-each>
                                                                            </xsl:for-each>
                                                                        </fo:block>
                                                                    </fo:block>
                                                                </fo:block>
                                                            </fo:block>
                                                            <fo:block>
                                                                <fo:leader leader-pattern="space"/>
                                                            </fo:block>
                                                            <fo:inline-container>
                                                                <fo:block>
                                                                    <xsl:text>&#x2029;</xsl:text>
                                                                </fo:block>
                                                            </fo:inline-container>
                                                            <fo:block margin="0pt">
                                                                <fo:block>
                                                                    <fo:block>
                                                                        <fo:leader leader-pattern="space"/>
                                                                    </fo:block>
                                                                    <fo:inline-container>
                                                                        <fo:block>
                                                                            <xsl:text>&#x2029;</xsl:text>
                                                                        </fo:block>
                                                                    </fo:inline-container>
                                                                    <fo:block margin-left="(100% - 100%) div 2" margin-right="(100% - 100%) div 2" margin="0pt">
                                                                        <fo:block>
                                                                            <fo:inline-container>
                                                                                <fo:block>
                                                                                 <xsl:text>&#x2029;</xsl:text>
                                                                                </fo:block>
                                                                            </fo:inline-container>
                                                                            <fo:table table-layout="fixed" width="100%" border="solid 1pt gray" border-spacing="2pt">
                                                                                <fo:table-column column-width="proportional-column-width(1)"/>
                                                                                <fo:table-body start-indent="0pt">
                                                                                    <fo:table-row>
                                                                                        <fo:table-cell border="solid 1pt gray" padding="2pt" text-align="left" display-align="center">
                                                                                            <fo:block>
                                                                                                <fo:inline font-weight="bold">
                                                                                                    <xsl:text';
    DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE    data CLOB; buffer VARCHAR2(32000);
BEGIN
SELECT CORRESPONDENCE_TEMPLATE INTO data FROM PROTO_CORRESP_TEMPL WHERE PROTO_CORRESP_TYPE_CODE = (SELECT PROTO_CORRESP_TYPE_CODE FROM PROTO_CORRESP_TYPE WHERE DESCRIPTION = 'Committee Roster Report') AND COMMITTEE_ID = 'DEFAULT' FOR UPDATE;
buffer := '>Committee Schedule</xsl:text>
                                                                                                </fo:inline>
                                                                                            </fo:block>
                                                                                        </fo:table-cell>
                                                                                    </fo:table-row>
                                                                                    <fo:table-row>
                                                                                        <fo:table-cell border="solid 1pt gray" padding="2pt" display-align="center">
                                                                                            <fo:block>
                                                                                                <xsl:for-each select="n1:Committee">
                                                                                                    <xsl:for-each select="n1:Schedule">
                                                                                                        <xsl:for-each select="n1:ScheduleMasterData">
                                                                                                            <fo:inline-container>
                                                                                                                <fo:block>
                                                                                                                    <xsl:text>&#x2029;</xsl:text>
                                                                                                                </fo:block>
                                                                                                            </fo:inline-container>
                                                                                                            <fo:table table-layout="fixed" width="100%" border-spacing="2pt">
                                                                                                                <fo:table-column column-width="proportional-column-width(1)"/>
                                                                                                                <fo:table-column column-width="proportional-column-width(1)"/>
                                                                                                                <fo:table-body start-indent="0pt">
                                                                                                                    <fo:table-row>
                                                                                                                        <fo:table-cell padding="2pt" display-align="center">
                                                                                                                            <fo:block>
                                                                                                                                <xsl:for-each select="n1:Place">
                                                                                                                                    <xsl:variable name="value-of-template">
                                                                                                                                        <xsl:apply-templates/>
                                                                                                                                    </xsl:variable>
                                                                                                                                    <xsl:choose>
                                                                                                                                        <xsl:when test="contains(string($value-of-template),''&#x2029;'')">
              ';
    DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE    data CLOB; buffer VARCHAR2(32000);
BEGIN
SELECT CORRESPONDENCE_TEMPLATE INTO data FROM PROTO_CORRESP_TEMPL WHERE PROTO_CORRESP_TYPE_CODE = (SELECT PROTO_CORRESP_TYPE_CODE FROM PROTO_CORRESP_TYPE WHERE DESCRIPTION = 'Committee Roster Report') AND COMMITTEE_ID = 'DEFAULT' FOR UPDATE;
buffer := '                                                                                                                              <fo:block>
                                                                                                                                                <xsl:copy-of select="$value-of-template"/>
                                                                                                                                            </fo:block>
                                                                                                                                        </xsl:when>
                                                                                                                                        <xsl:otherwise>
                                                                                                                                            <fo:inline>
                                                                                                                                                <xsl:copy-of select="$value-of-template"/>
                                                                                                                                            </fo:inline>
                                                                                                                                        </xsl:otherwise>
                                                                                                                                    </xsl:choose>
                                                                                                                                </xsl:for-each>
                                                                                                                            </fo:block>
                                                                                                                        </fo:table-cell>
                                                                                                                        <fo:table-cell padding="2pt" display-align="center">
                                                                                                                            <fo:block>
                                                                                                                                <xsl:for-each select="n1:ScheduledDate">
                                                                                                                                    <fo:inline>
                                                                                                                                        <xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), ''00'')"/>
                                                                                                                                        <xsl:text>/</xsl:text>
                                                                                                                                        <xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), ''00'')"/>
                                                                                                                                        <xsl:text>/</xsl:text>
                                                                                                                                        <xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), ''0000'')"/>
                                                                                                                                    </fo:inline>
                                                                                                                                </xsl:for-each>
                                                                                                       ';
    DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE    data CLOB; buffer VARCHAR2(32000);
BEGIN
SELECT CORRESPONDENCE_TEMPLATE INTO data FROM PROTO_CORRESP_TEMPL WHERE PROTO_CORRESP_TYPE_CODE = (SELECT PROTO_CORRESP_TYPE_CODE FROM PROTO_CORRESP_TYPE WHERE DESCRIPTION = 'Committee Roster Report') AND COMMITTEE_ID = 'DEFAULT' FOR UPDATE;
buffer := '                         <fo:inline>
                                                                                                                                    <xsl:text>&#160;</xsl:text>
                                                                                                                             </fo:inline>
                                                                                                                                <xsl:for-each select="n1:ScheduledTime">
                                                                                                                                    <fo:inline>
                                                                                                                                        <xsl:value-of select="format-number(number(substring(string(string(.)), 1, 2)), ''00'')"/>
                                                                                                                                        <xsl:text>:</xsl:text>
                                                                                                                                        <xsl:value-of select="format-number(number(substring(string(string(.)), 4, 2)), ''00'')"/>
                                                                                                                                    </fo:inline>
                                                                                                                                </xsl:for-each>
                                                                                                                            </fo:block>
                                                                                                                        </fo:table-cell>
                                                                                                                    </fo:table-row>
                                                                                                                </fo:table-body>
                                                                                                            </fo:table>
                                                                                                        </xsl:for-each>
                                                                                                    </xsl:for-each>
                                                                                                </xsl:for-each>
                                                                                            </fo:block>
                                                                                        </fo:table-cell>
                                                                                    </fo:table-row>
                                                                                </fo:table-body>
                                                                            </fo:table>
                                                                        </fo:block>
                                                                    </fo:block>
                                                                </fo:block>
                                                            </fo:block>
                                                        </fo:block>
                                                    </fo:block>
                                                </fo:block>
                                            </fo:block>
                                        </fo:block>
                                    </fo:block>
                                </fo:block>
                            </fo:block>
                        </xsl:for-each>
                    </fo:block>
                    <fo:block id="SV_RefID_PageTotal"/>
                </fo:flow>
            </fo:page-sequence>
        </fo:root>
    </xs';
    DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE    data CLOB; buffer VARCHAR2(32000);
BEGIN
SELECT CORRESPONDENCE_TEMPLATE INTO data FROM PROTO_CORRESP_TEMPL WHERE PROTO_CORRESP_TYPE_CODE = (SELECT PROTO_CORRESP_TYPE_CODE FROM PROTO_CORRESP_TYPE WHERE DESCRIPTION = 'Committee Roster Report') AND COMMITTEE_ID = 'DEFAULT' FOR UPDATE;
buffer := 'l:template>
    <xsl:template match="n1:Committee">
        <xsl:for-each select="n1:CommitteeMasterData">
            <fo:inline>
                <xsl:text>Committee Id: </xsl:text>
            </fo:inline>
            <xsl:for-each select="n1:CommitteeId">
                <xsl:variable name="value-of-template">
                    <xsl:apply-templates/>
                </xsl:variable>
                <xsl:choose>
                    <xsl:when test="contains(string($value-of-template),''&#x2029;'')">
                        <fo:block>
                            <xsl:copy-of select="$value-of-template"/>
                        </fo:block>
                    </xsl:when>
                    <xsl:otherwise>
                        <fo:inline>
                            <xsl:copy-of select="$value-of-template"/>
                        </fo:inline>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:for-each>
            <fo:block>
                <fo:leader leader-pattern="space"/>
            </fo:block>
            <fo:inline-container>
                <fo:block>
                    <xsl:text>&#x2029;</xsl:text>
                </fo:block>
            </fo:inline-container>
            <fo:block margin="0pt">
                <fo:block>
                    <fo:inline>
                        <xsl:text>Committee Name: </xsl:text>
                    </fo:inline>
                    <xsl:for-each select="n1:CommitteeName">
                        <xsl:variable name="value-of-template">
                            <xsl:apply-templates/>
                        </xsl:variable>
                        <xsl:choose>
                            <xsl:when test="contains(string($value-of-template),''&#x2029;'')">
                                <fo:block>
                                    <xsl:copy-of select="$value-of-template"/>
                                </fo:block>
                            </xsl:when>
                            <xsl:otherwise>
                                <fo:inline>
                                    <xsl:copy-of select="$value-of-template"/>
                                </fo:inline>
                            </xsl:otherwise>
                        </xsl:choose>
                    </xsl:for-each>
                </fo:block>
            </fo:block>
        </xsl:for-each>
    </xsl:template>
    <xsl:template name="double-backslash">
        <xsl:param name="text"/>
        <xsl:param name="text-length"/>
        <xsl:variable name="text-after-bs" select="substring-after($text, ''\'')"/>
        <xsl:variable name="text-after-bs-length" select="string-length($text-after-bs)"/>
        <xsl:choose>
            <xsl:when test="$text-after-bs-length = 0">
                <xsl:choose>
                    <xsl:when test="substring($text, $text-length) = ''\''">
                        <xsl:value-of select="concat(substring($text,1,$text-length - 1), ''\\'')"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:value-of select="$text"/>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="concat(substring($text,1,$text-length - $text-after-bs-length - 1), ''\\'')"/>
                <xsl:call-template name="double-backslash">
                    <xsl:with-param name="text" select="$text-after-bs"/>
                    <xsl:with-param name="text-length" select="$text-after-bs-length"/>
                </xsl:call-template>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
</xsl:stylesheet>
';
    DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
