---
-- #%L
-- %%
-- Copyright (C) 2005 - 2021 Kuali, Inc. - All Rights Reserved
-- %%
-- You may use and modify this code under the terms of the Kuali, Inc.
-- Pre-Release License Agreement. You may not distribute it.
-- 
-- You should have received a copy of the Kuali, Inc. Pre-Release License
-- Agreement with this file. If not, please write to license@kuali.co.
-- #L%
---


DELETE FROM PROTO_CORRESP_TEMPL WHERE PROTO_CORRESP_TYPE_CODE = (SELECT PROTO_CORRESP_TYPE_CODE FROM PROTO_CORRESP_TYPE WHERE DESCRIPTION = 'Approval Letter')  AND  COMMITTEE_ID =  'DEFAULT' ;
commit;
INSERT INTO PROTO_CORRESP_TEMPL(PROTO_CORRESP_TEMPL_ID,PROTO_CORRESP_TYPE_CODE,COMMITTEE_ID,FILE_NAME,CORRESPONDENCE_TEMPLATE,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) values (SEQ_PROTO_CORRESP_TEMPL.NEXTVAL,(SELECT PROTO_CORRESP_TYPE_CODE FROM PROTO_CORRESP_TYPE WHERE DESCRIPTION = 'Approval Letter'),'DEFAULT','DEFAULT-1-ApprovalLetter.xsl',EMPTY_CLOB(),'admin',SYSDATE,SYS_GUID(),1);
DECLARE    data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT CORRESPONDENCE_TEMPLATE INTO data FROM PROTO_CORRESP_TEMPL
WHERE
PROTO_CORRESP_TYPE_CODE=(SELECT PROTO_CORRESP_TYPE_CODE FROM PROTO_CORRESP_TYPE WHERE DESCRIPTION = 'Approval Letter')  AND  COMMITTEE_ID =  'DEFAULT' FOR UPDATE;
buffer := '<?xml version="1.0" encoding="UTF-8"?>
<!--Designed and generated by Altova StyleVision Enterprise Edition 2008 rel. 2 - see http://www.altova.com/stylevision for more information.-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fn="http://www.w3.org/2005/xpath-functions" xmlns:n1="http://irb.mit.edu/irbnamespace" xmlns:xdt="http://www.w3.org/2005/xpath-datatypes" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:fo="http://www.w3.org/1999/XSL/Format">
    <xsl:output version="1.0" method="xml" encoding="UTF-8" indent="no"/>
    <xsl:param name="SV_OutputFormat" select="''PDF''"/>
    <xsl:variable name="XML" select="/"/>
    <xsl:variable name="fo:layout-master-set">
        <fo:layout-master-set>
            <fo:simple-page-master master-name="default-page" page-height="11in" page-width="8.5in" margin-left="0.6in" margin-right="1.0in">
                <fo:region-body margin-top="0.79in" margin-bottom="0.79in"/>
                <fo:region-before extent="0.79in"/>
            </fo:simple-page-master>
        </fo:layout-master-set>
    </xsl:variable>
    <xsl:template match="/">
        <fo:root>
            <xsl:copy-of select="$fo:layout-master-set"/>
            <fo:page-sequence master-reference="default-page" initial-page-number="1" format="1">
                <xsl:call-template name="headerall"/>
                <fo:flow flow-name="xsl-region-body">
                    <fo:block>
                        <xsl:for-each select="$XML">
                            <fo:external-graphic>
                                <xsl:attribute name="src">
                                    <xsl:text>url(</xsl:text>
                                    <xsl:call-template name="double-backslash">
                                        <xsl:with-param name="text">
                                            <xsl:value-of select="string(&apos;/export/home/www/https/tomcat5.0.25/webapps/coeus/images/couhes_byline2.gif&apos;)"/>
                                        </xsl:with-param>
                                        <xsl:with-param name="text-length">
                                            <xsl:value-of select="string-length(string(&apos;/export/home/www/https/tomcat5.0.25/webapps/coeus/images/couhes_byline2.gif&apos;))"/>
                                        </xsl:with-param>
                                    </xsl:call-template>
                                    <xsl:text>)</xsl:text>
                                </xsl:attribute>
                            </fo:external-graphic>
                            <fo:block text-align="center">
                                <fo:leader leader-pattern="rule" rule-thickness="1" leader-length="100%" color="black"/>
                            </fo:block>
                            <fo:block/>
                            <xsl:for-each select="n1:Correspondence">
                                <fo:inline-container>
                                    <fo:block>
                                        <xsl:text>&#x2029;</xsl:text>
                                    </fo:block>
                                </fo:inline-container>
                                <fo:block font-family="Arial" font-size="10pt" margin="0pt">
                                    <fo:block>
                                        <fo:inline-container>
                                            <fo:block>
                                                <xsl:text>&#x2029;</xsl:text>
                                            </fo:block>
                                        </fo:inline-container>
                                        <fo:table table-layout="fixed" width="100%" border-spacing="2pt">
                                            <fo:table-column column-width="25%"/>
                                            <fo:table-column column-w';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE    data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT CORRESPONDENCE_TEMPLATE INTO data FROM PROTO_CORRESP_TEMPL
WHERE
PROTO_CORRESP_TYPE_CODE=(SELECT PROTO_CORRESP_TYPE_CODE FROM PROTO_CORRESP_TYPE WHERE DESCRIPTION = 'Approval Letter')  AND  COMMITTEE_ID =  'DEFAULT' FOR UPDATE;
buffer := 'idth="75%"/>
                                            <fo:table-body start-indent="0pt">
                                                <fo:table-row>
                                                    <fo:table-cell padding="2pt" display-align="before">
                                                        <fo:block>
                                                            <fo:inline font-size="10pt" font-weight="bold">
                                                                <xsl:text>To:</xsl:text>
                                                            </fo:inline>
                                                            <fo:inline font-size="10pt">
                                                                <xsl:text>&#160;&#160;&#160;&#160;&#160; </xsl:text>
                                                            </fo:inline>
                                                        </fo:block>
                                                    </fo:table-cell>
                                                    <fo:table-cell padding="2pt" display-align="center">
                                                        <fo:block>
                                                            <xsl:for-each select="n1:Protocol">
                                                                <xsl:for-each select="n1:Investigator">
                                                                    <xsl:if test="n1:PI_flag = &apos;true&apos;">
                                                                        <xsl:for-each select="n1:Person">
                                                                            <xsl:for-each select="n1:Firstname">
                                                                                <xsl:variable name="value-of-template">
                                                                                    <xsl:apply-templates/>
                                                                                </xsl:variable>
                                                                                <xsl:choose>
                                                                                 <xsl:when test="contains(string($value-of-template),''&#x2029;'')">
                                                                                        <fo:block font-size="10pt">
                                                                                            <xsl:copy-of select="$value-of-template"/>
                                                                                        </fo:block>
                                                                                    </xsl:when>
                                                                                    <xsl:otherwise>
                                                                                        <fo:inline font-size="10pt">
                                                                                            <xsl:copy-of select="$value-of-template"/>
                                                                                        </fo:inline>
                                                                                    </xsl:otherwise>
                                                                                </xsl:choose>
                                                                            </xsl:for-each>
                                                                            <fo:inline font-size="10pt">
                                                                                <xsl:text>&#160; </xsl:text>
                                                                            </fo:inline>
                                                                            <xsl:for-each select="n1:LastName">
                                                                           ';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE    data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT CORRESPONDENCE_TEMPLATE INTO data FROM PROTO_CORRESP_TEMPL
WHERE
PROTO_CORRESP_TYPE_CODE=(SELECT PROTO_CORRESP_TYPE_CODE FROM PROTO_CORRESP_TYPE WHERE DESCRIPTION = 'Approval Letter')  AND  COMMITTEE_ID =  'DEFAULT' FOR UPDATE;
buffer := '     <xsl:variable name="value-of-template">
                                                                                    <xsl:apply-templates/>
                                                                                </xsl:variable>
                                                                                <xsl:choose>
                                                                                    <xsl:when test="contains(string($value-of-template),''&#x2029;'')">
                                                                                        <fo:block font-size="10pt">
                                                                                            <xsl:copy-of select="$value-of-template"/>
                                                                                        </fo:block>
                                                                                    </xsl:when>
                                                                                    <xsl:otherwise>
                                                                                        <fo:inline font-size="10pt">
                                                                                            <xsl:copy-of select="$value-of-template"/>
                                                                                        </fo:inline>
                                                                                    </xsl:otherwise>
                                                                                </xsl:choose>
                                                                            </xsl:for-each>
                                                                            <fo:inline-container>
                                                                                <fo:block>
                                                                                    <xsl:text>&#x2029;</xsl:text>
                                                                                </fo:block>
                                                                            </fo:inline-container>
                                                                            <fo:block white-space="pre" white-space-collapse="false" margin="0pt">
                                                                                <fo:block>
                                                                                    <xsl:for-each select="n1:OfficeLocation">
                                                                                        <xsl:variable name="value-of-template">
                                                                                            <xsl:apply-templates/>
                                                                                        </xsl:variable>
                                                                                        <xsl:choose>
                                                                                            <xsl:when test="contains(string($value-of-template),''&#x2029;'')">
                                                                                                <fo:block font-family="Arial" font-size="10pt">
                                                                                                    <xsl:copy-of select="$value-of-template"/>
                                                                                                </fo:block>
                                                                                            </xsl:when>
                                                                                            <xsl:otherwise>
                                                                                                <fo:inline font-family="Arial" font-size="10pt">
                                                                   ';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE    data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT CORRESPONDENCE_TEMPLATE INTO data FROM PROTO_CORRESP_TEMPL
WHERE
PROTO_CORRESP_TYPE_CODE=(SELECT PROTO_CORRESP_TYPE_CODE FROM PROTO_CORRESP_TYPE WHERE DESCRIPTION = 'Approval Letter')  AND  COMMITTEE_ID =  'DEFAULT' FOR UPDATE;
buffer := '                                 <xsl:copy-of select="$value-of-template"/>
                                                                                                </fo:inline>
                                                                                            </xsl:otherwise>
                                                                                        </xsl:choose>
                                                                                    </xsl:for-each>
                                                                                </fo:block>
                                                                            </fo:block>
                                                                        </xsl:for-each>
                                                                    </xsl:if>
                                                                </xsl:for-each>
                                                            </xsl:for-each>
                                                        </fo:block>
                                                    </fo:table-cell>
                                                </fo:table-row>
                                                <fo:table-row>
                                                    <fo:table-cell padding="2pt" display-align="before">
                                                        <fo:block>
                                                            <fo:inline font-size="10pt" font-weight="bold">
                                                                <xsl:text>From:</xsl:text>
                                                            </fo:inline>
                                                        </fo:block>
                                                    </fo:table-cell>
                                                    <fo:table-cell padding="2pt" display-align="center">
                                                        <fo:block>
                                                            <xsl:for-each select="n1:Protocol">
                                                                <xsl:for-each select="n1:Submissions">
                                                                    <xsl:for-each select="n1:CommitteeMember">
                                                                        <xsl:if test="n1:CommitteeMemberRole/n1:MemberRoleDesc = &apos;Chair&apos;">
                                                                            <xsl:for-each select="n1:Person">
                                                                                <xsl:for-each select="n1:Firstname">
                                                                                    <xsl:if test="../../../n1:CurrentSubmissionFlag =&apos;No&apos;">
                                                                                        <xsl:variable name="value-of-template">
                                                                                            <xsl:apply-templates/>
                                                                                     </xsl:variable>
                                                                                        <xsl:choose>
                                                                                            <xsl:when test="contains(string($value-of-template),''&#x2029;'')">
                                                                                                <fo:block font-size="10pt">
                                                                                                    <xsl:copy-of select="$value-of-template"/>
                                                                                                </fo:block>
                                                                                            </xsl:when>
                         ';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE    data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT CORRESPONDENCE_TEMPLATE INTO data FROM PROTO_CORRESP_TEMPL
WHERE
PROTO_CORRESP_TYPE_CODE=(SELECT PROTO_CORRESP_TYPE_CODE FROM PROTO_CORRESP_TYPE WHERE DESCRIPTION = 'Approval Letter')  AND  COMMITTEE_ID =  'DEFAULT' FOR UPDATE;
buffer := '                                                                   <xsl:otherwise>
                                                                                                <fo:inline font-size="10pt">
                                                                                                    <xsl:copy-of select="$value-of-template"/>
                                                                                                </fo:inline>
                                                                                            </xsl:otherwise>
                                                                                        </xsl:choose>
                                                                                    </xsl:if>
                                                                                </xsl:for-each>
                                                                                <fo:inline>
                                                                                    <xsl:text>&#160;</xsl:text>
                                                                                </fo:inline>
                                                                                <xsl:for-each select="n1:LastName">
                                                                                    <xsl:if test="../../../n1:CurrentSubmissionFlag =&apos;No&apos;">
                                                                                        <xsl:variable name="value-of-template">
                                                                                            <xsl:apply-templates/>
                                                                                        </xsl:variable>
                                                                                        <xsl:choose>
                                                                                            <xsl:when test="contains(string($value-of-template),''&#x2029;'')">
                                                                                                <fo:block font-size="10pt">
                                                                                                    <xsl:copy-of select="$value-of-template"/>
                                                                                                </fo:block>
                                                                                            </xsl:when>
                                                                                            <xsl:otherwise>
                                                                                                <fo:inline font-size="10pt">
                                                                                                    <xsl:copy-of select="$value-of-template"/>
                                                                                                </fo:inline>
                                                                                            </xsl:otherwise>
                                                                                        </xsl:choose>
                                                                                    </xsl:if>
                                                                                </xsl:for-each>
                                                                            </xsl:for-each>
                                                                        </xsl:if>
                                                                    </xsl:for-each>
                                                                </xsl:for-each>
                                                            </xsl:for-each>
                                                            <fo:inline font-size="10pt">
                                                                ';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE    data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT CORRESPONDENCE_TEMPLATE INTO data FROM PROTO_CORRESP_TEMPL
WHERE
PROTO_CORRESP_TYPE_CODE=(SELECT PROTO_CORRESP_TYPE_CODE FROM PROTO_CORRESP_TYPE WHERE DESCRIPTION = 'Approval Letter')  AND  COMMITTEE_ID =  'DEFAULT' FOR UPDATE;
buffer := '<xsl:text>, Chair </xsl:text>
                                                            </fo:inline>
                                                            <fo:block>
                                                                <fo:leader leader-pattern="space"/>
                                                            </fo:block>
                                                            <fo:inline-container>
                                                                <fo:block>
                                                                    <xsl:text>&#x2029;</xsl:text>
                                                                </fo:block>
                                                            </fo:inline-container>
                                                            <fo:block margin="0pt">
                                                                <fo:block>
                                                                    <xsl:for-each select="n1:Protocol">
                                                                        <xsl:for-each select="n1:Submissions">
                                                                            <xsl:for-each select="n1:CommitteeMasterData">
                                                                                <xsl:for-each select="n1:CommitteeName">
                                                                                    <xsl:if test="../../n1:CurrentSubmissionFlag =&apos;No&apos;">
                                                                                        <xsl:variable name="value-of-template">
                                                                                            <xsl:apply-templates/>
                                                                                        </xsl:variable>
                                                                                        <xsl:choose>
                                                                                            <xsl:when test="contains(string($value-of-template),''&#x2029;'')">
                                                                                                <fo:block font-size="10pt">
                                                                                                    <xsl:copy-of select="$value-of-template"/>
                                                                                                </fo:block>
                                                                                            </xsl:when>
                                                                                            <xsl:otherwise>
                                                                                                <fo:inline font-size="10pt">
                                                                                                    <xsl:copy-of select="$value-of-template"/>
                                                                                                </fo:inline>
                                                                                            </xsl:otherwise>
                                                                                        </xsl:choose>
                                                                                    </xsl:if>
                                                                                </xsl:for-each>
                                                                            </xsl:for-each>
                                                                        </xsl:for-each>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:block>
                                                   ';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE    data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT CORRESPONDENCE_TEMPLATE INTO data FROM PROTO_CORRESP_TEMPL
WHERE
PROTO_CORRESP_TYPE_CODE=(SELECT PROTO_CORRESP_TYPE_CODE FROM PROTO_CORRESP_TYPE WHERE DESCRIPTION = 'Approval Letter')  AND  COMMITTEE_ID =  'DEFAULT' FOR UPDATE;
buffer := '     </fo:block>
                                                    </fo:table-cell>
                                                </fo:table-row>
                                                <fo:table-row>
                                                    <fo:table-cell padding="2pt" display-align="before">
                                                        <fo:block>
                                                            <fo:inline font-size="10pt" font-weight="bold">
                                                                <xsl:text>Date:</xsl:text>
                                                            </fo:inline>
                                                        </fo:block>
                                                    </fo:table-cell>
                                                    <fo:table-cell padding="2pt" display-align="center">
                                                        <fo:block>
                                                            <xsl:for-each select="n1:CurrentDate">
                                                                <fo:inline font-size="10pt">
                                                                    <xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), ''00'')"/>
                                                                    <xsl:text>/</xsl:text>
                                                                    <xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), ''00'')"/>
                                                                    <xsl:text>/</xsl:text>
                                                                    <xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), ''0000'')"/>
                                                                </fo:inline>
                                                            </xsl:for-each>
                                                        </fo:block>
                                                    </fo:table-cell>
                                                </fo:table-row>
                                                <fo:table-row>
                                                    <fo:table-cell padding="2pt" height="21" display-align="before">
                                                        <fo:block>
                                                            <fo:inline font-size="10pt" font-weight="bold">
                                                                <xsl:text>Committee Action:</xsl:text>
                                                            </fo:inline>
                                                        </fo:block>
                                                    </fo:table-cell>
                                                    <fo:table-cell padding="2pt" height="21" display-align="center">
                                                        <fo:block>
                                                            <xsl:choose>
                                                                <xsl:when test="n1:Protocol/n1:Submissions/n1:SubmissionDetails/n1:SubmissionTypeCode = 102">
                                                                    <fo:inline font-size="10pt" font-weight="bold">
                                                                        <xsl:text>Amendment to Approved Protocol</xsl:text>
                                                                    </fo:inline>
                                                                </xsl:when>
                                                                <xsl:when test="n1:Protocol/n1:Submissions/n1:SubmissionDetails/n1:SubmissionTypeCode = 101">
                                                                    <fo:inline font-size="10pt" font-weight="bold">
                      ';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE    data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT CORRESPONDENCE_TEMPLATE INTO data FROM PROTO_CORRESP_TEMPL
WHERE
PROTO_CORRESP_TYPE_CODE=(SELECT PROTO_CORRESP_TYPE_CODE FROM PROTO_CORRESP_TYPE WHERE DESCRIPTION = 'Approval Letter')  AND  COMMITTEE_ID =  'DEFAULT' FOR UPDATE;
buffer := '                                                  <xsl:text>Renewal</xsl:text>
                                                                    </fo:inline>
                                                                </xsl:when>
                                                                <xsl:otherwise>
                                                                    <fo:inline font-size="10pt" font-weight="bold">
                                                                        <xsl:text>Approval</xsl:text>
                                                                    </fo:inline>
                                                                </xsl:otherwise>
                                                            </xsl:choose>
                                                        </fo:block>
                                                    </fo:table-cell>
                                                </fo:table-row>
                                                <fo:table-row>
                                                    <fo:table-cell padding="2pt" display-align="before">
                                                        <fo:block>
                                                            <fo:inline font-size="10pt" font-weight="bold">
                                                                <xsl:text>Committee Action Date</xsl:text>
                                                            </fo:inline>
                                                        </fo:block>
                                                    </fo:table-cell>
                                                    <fo:table-cell padding="2pt" height="29" display-align="before">
                                                        <fo:block>
                                                            <xsl:for-each select="n1:Protocol">
                                                                <xsl:for-each select="n1:Submissions">
                                                                    <xsl:for-each select="n1:SubmissionDetails">
                                                                        <xsl:for-each select="n1:ActionType">
                                                                            <xsl:for-each select="n1:ActionDate">
                                                                                <xsl:if test="../../../n1:CurrentSubmissionFlag =&apos;No&apos;">
                                                                                    <fo:inline>
                                                                                        <xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), ''00'')"/>
                                                                                        <xsl:text>/</xsl:text>
                                                                                        <xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), ''00'')"/>
                                                                                        <xsl:text>/</xsl:text>
                                                                                        <xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), ''0000'')"/>
                                                                                    </fo:inline>
                                                                                </xsl:if>
                                                                            </xsl:for-each>
                                                                        </xsl:for-each>
                                                                    </xsl:for-each>
                                                                </xsl:for-each>
                                                            </xsl:f';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE    data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT CORRESPONDENCE_TEMPLATE INTO data FROM PROTO_CORRESP_TEMPL
WHERE
PROTO_CORRESP_TYPE_CODE=(SELECT PROTO_CORRESP_TYPE_CODE FROM PROTO_CORRESP_TYPE WHERE DESCRIPTION = 'Approval Letter')  AND  COMMITTEE_ID =  'DEFAULT' FOR UPDATE;
buffer := 'or-each>
                                                        </fo:block>
                                                    </fo:table-cell>
                                                </fo:table-row>
                                            </fo:table-body>
                                        </fo:table>
                                        <fo:inline-container>
                                         <fo:block>
                                                <xsl:text>&#x2029;</xsl:text>
                                            </fo:block>
                                        </fo:inline-container>
                                        <fo:block margin="0pt">
                                            <fo:block>
                                                <fo:inline-container>
                                                    <fo:block>
                                                        <xsl:text>&#x2029;</xsl:text>
                                                    </fo:block>
                                                </fo:inline-container>
                                                <fo:table table-layout="fixed" width="100%" border-spacing="2pt">
                                                    <fo:table-column column-width="25%"/>
                                                    <fo:table-column column-width="75%"/>
                                                    <fo:table-body start-indent="0pt">
                                                        <fo:table-row>
                                                            <fo:table-cell padding="2pt" display-align="before">
                                                                <fo:block>
                                                                    <fo:inline font-size="10pt" font-weight="bold">
                                                                        <xsl:text>COUHES Protocol # </xsl:text>
                                                                    </fo:inline>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                            <fo:table-cell padding="2pt" display-align="before">
                                                                <fo:block>
                                                                    <xsl:for-each select="n1:Protocol">
                                                                        <xsl:for-each select="n1:ProtocolMasterData">
                                                                            <xsl:for-each select="n1:ProtocolNumber">
                                                                                <xsl:variable name="value-of-template">
                                                                                    <xsl:apply-templates/>
                                                                                </xsl:variable>
                                                                                <xsl:choose>
                                                                                    <xsl:when test="contains(string($value-of-template),''&#x2029;'')">
                                                                                        <fo:block font-size="10pt">
                                                                                            <xsl:copy-of select="$value-of-template"/>
                                                                                        </fo:block>
                                                                                    </xsl:when>
                                                                                    <xsl:otherwise>
                                                                                        <fo:inline font';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE    data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT CORRESPONDENCE_TEMPLATE INTO data FROM PROTO_CORRESP_TEMPL
WHERE
PROTO_CORRESP_TYPE_CODE=(SELECT PROTO_CORRESP_TYPE_CODE FROM PROTO_CORRESP_TYPE WHERE DESCRIPTION = 'Approval Letter')  AND  COMMITTEE_ID =  'DEFAULT' FOR UPDATE;
buffer := '-size="10pt">
                                                                                            <xsl:copy-of select="$value-of-template"/>
                                                                                        </fo:inline>
                                                                                    </xsl:otherwise>
                                                                                </xsl:choose>
                                                                            </xsl:for-each>
                                                                        </xsl:for-each>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                        </fo:table-row>
                                                        <fo:table-row>
                                                            <fo:table-cell padding="2pt" display-align="before">
                                                                <fo:block>
                                                                    <fo:inline font-size="10pt" font-weight="bold">
                                                                        <xsl:text>Study Title </xsl:text>
                                                                    </fo:inline>
                                                                    <fo:inline font-size="10pt">
                                                                        <xsl:text>&#160;&#160;&#160; </xsl:text>
                                                                    </fo:inline>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                            <fo:table-cell padding="2pt" display-align="before">
                                                                <fo:block>
                                                                    <xsl:for-each select="n1:Protocol">
                                                                        <xsl:for-each select="n1:ProtocolMasterData">
                                                                            <xsl:for-each select="n1:ProtocolTitle">
                                                                                <xsl:variable name="value-of-template">
                                                                                    <xsl:apply-templates/>
                                                                                </xsl:variable>
                                                                                <xsl:choose>
                                                                                    <xsl:when test="contains(string($value-of-template),''&#x2029;'')">
                                                                                        <fo:block font-size="10pt">
                                                                                            <xsl:copy-of select="$value-of-template"/>
                                                                                        </fo:block>
                                                                                    </xsl:when>
                                                                                    <xsl:otherwise>
                                                                                        <fo:inline font-size="10pt">
                                                                                            <xsl:copy-of select="$value-of-template"/>
                                                                                        </fo:inline>
                         ';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE    data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT CORRESPONDENCE_TEMPLATE INTO data FROM PROTO_CORRESP_TEMPL
WHERE
PROTO_CORRESP_TYPE_CODE=(SELECT PROTO_CORRESP_TYPE_CODE FROM PROTO_CORRESP_TYPE WHERE DESCRIPTION = 'Approval Letter')  AND  COMMITTEE_ID =  'DEFAULT' FOR UPDATE;
buffer := '                                                           </xsl:otherwise>
                                                                                </xsl:choose>
                                                                            </xsl:for-each>
                                                                        </xsl:for-each>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                        </fo:table-row>
                                                        <fo:table-row>
                                                            <fo:table-cell padding="2pt" display-align="before">
                                                                <fo:block>
                                                                    <fo:inline font-size="10pt" font-weight="bold">
                                                                     <xsl:text>Expiration Date </xsl:text>
                                                                    </fo:inline>
                                                                    <fo:inline font-size="10pt">
                                                                        <xsl:text>&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160; </xsl:text>
                                                                    </fo:inline>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                            <fo:table-cell padding="2pt" display-align="before">
                                                                <fo:block>
                                                                    <xsl:for-each select="n1:Protocol">
                                                                        <xsl:for-each select="n1:ProtocolMasterData">
                                                                            <xsl:for-each select="n1:ExpirationDate">
                                                                                <fo:inline>
                                                                                    <xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), ''00'')"/>
                                                                                    <xsl:text>/</xsl:text>
                                                                                    <xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), ''00'')"/>
                                                                                    <xsl:text>/</xsl:text>
                                                                                    <xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), ''0000'')"/>
                                                                                </fo:inline>
                                                                            </xsl:for-each>
                                                                        </xsl:for-each>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
															</fo:table-row>
															<fo:table-row>
                                                            <fo:table-cell padding="2pt" display-align="before">
                                                                <fo:block>
                                                                    <fo:inline font-size="10pt" font-weight="bol';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE    data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT CORRESPONDENCE_TEMPLATE INTO data FROM PROTO_CORRESP_TEMPL
WHERE
PROTO_CORRESP_TYPE_CODE=(SELECT PROTO_CORRESP_TYPE_CODE FROM PROTO_CORRESP_TYPE WHERE DESCRIPTION = 'Approval Letter')  AND  COMMITTEE_ID =  'DEFAULT' FOR UPDATE;
buffer := 'd">
                                                                     <xsl:text>Last Approval Date </xsl:text>
                                                                    </fo:inline>
                                                                    <fo:inline font-size="10pt">
                                                                        <xsl:text>&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160; </xsl:text>
                                                                    </fo:inline>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                            <fo:table-cell padding="2pt" display-align="before">
                                                                <fo:block>
                                                                    <xsl:for-each select="n1:Protocol">
                                                                        <xsl:for-each select="n1:ProtocolMasterData">
                                                                            <xsl:for-each select="n1:LastApprovalDate">
                                                                                <fo:inline>
                                                                                    <xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), ''00'')"/>
                                                                                    <xsl:text>/</xsl:text>
                                                                                    <xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), ''00'')"/>
                                                                                    <xsl:text>/</xsl:text>
                                                                                    <xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), ''0000'')"/>
                                                                                </fo:inline>
                                                                            </xsl:for-each>
                                                                        </xsl:for-each>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                        </fo:table-row>
                                                    </fo:table-body>
                                                </fo:table>
                                            </fo:block>
                                        </fo:block>
                                    </fo:block>
                                </fo:block>
                                <xsl:choose>
                                    <xsl:when test="n1:Protocol/n1:Submissions/n1:CurrentSubmissionFlag = &apos;No&apos; and  n1:Protocol/n1:Submissions/n1:SubmissionDetails/n1:SubmissionTypeCode = 102">
                                        <fo:inline font-family="Arial" font-size="10pt">
                                            <xsl:text>The amendment to the above-referenced protocol has been APPROVED following full board review by the Committee on the Use of Humans as Experimental Subjects (COUHES).</xsl:text>
                                        </fo:inline>
                                        <fo:block/>
                                        <fo:inline font-family="Arial" font-size="10pt">
                                            <xsl:text>If the research involves collaboration with another institution then the research cannot commence until COUHES receives written notification of approval from the collabo';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE    data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT CORRESPONDENCE_TEMPLATE INTO data FROM PROTO_CORRESP_TEMPL
WHERE
PROTO_CORRESP_TYPE_CODE=(SELECT PROTO_CORRESP_TYPE_CODE FROM PROTO_CORRESP_TYPE WHERE DESCRIPTION = 'Approval Letter')  AND  COMMITTEE_ID =  'DEFAULT' FOR UPDATE;
buffer := 'rating institution&apos;s IRB</xsl:text>
                                        </fo:inline>
                                        <fo:inline font-family="Arial" font-size="10pt">
                                            <xsl:text>.</xsl:text>
                                        </fo:inline>
                                        <fo:block/>
                                        <fo:inline font-family="Arial" font-size="10pt">
                                            <xsl:text>It is the Principal Investigator&apos;s responsibility to obtain review and continued approval before the expiration date.&#160; Please allow sufficient time for continued approval.&#160; You may not continue any research activity beyond the expiration date without COUHES approval.&#160; Failure to receive approval for continuation before the expiration date will result in the automatic suspension of the approval of this protocol.&#160; Information collected following suspension is unapproved research and cannot be reported or published as research data.&#160; If you do not wish continued approval, please notify the Committee of the study termination.</xsl:text>
                                        </fo:inline>
                                    </xsl:when>
                                    <xsl:when test="n1:Protocol/n1:Submissions/n1:CurrentSubmissionFlag = &apos;No&apos; and  n1:Protocol/n1:Submissions/n1:SubmissionDetails/n1:SubmissionTypeCode = 101">
                                        <fo:inline font-family="Arial" font-size="10pt">
                                            <xsl:text>The above-referenced protocol was given renewed approval following full board review by the Committee on the Use of Humans as Experimental Subjects (COUHES).</xsl:text>
                                        </fo:inline>
                                        <fo:block>
                                            <fo:leader leader-pattern="space"/>
                                        </fo:block>
                                        <fo:inline-container>
                                            <fo:block>
                                                <xsl:text>&#x2029;</xsl:text>
                                            </fo:block>
                                        </fo:inline-container>
                                        <fo:block font-family="Arial" font-size="10pt" margin="0pt">
                                            <fo:block>
                                                <fo:inline font-family="Arial" font-size="10pt">
                                                    <xsl:text>If the research involves collaboration with another institution then the research cannot commence until COUHES receives written notification of approval from the collaborating institution&apos;s IRB.</xsl:text>
                                                </fo:inline>
                                                <fo:block/>
                                                <fo:inline font-family="Arial" font-size="10pt">
                                                    <xsl:text>It is the Principal Investigator&apos;s responsibility to obtain review and continued approval before the expiration date.&#160; You may not continue any research activity beyond the expiration date without approval by COUHES.&#160; Failure to renew your study before the expiration date will result in termination of the study and suspension of related research grants.</xsl:text>
                                                </fo:inline>
                                            </fo:block>
                                        </fo:block>
                                    </xsl:when>
                                    <xsl:otherwise>
                                        <fo:inline font-family="Arial" font-size="10pt">
                                            <xsl:text>T</xsl:text>
              ';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE    data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT CORRESPONDENCE_TEMPLATE INTO data FROM PROTO_CORRESP_TEMPL
WHERE
PROTO_CORRESP_TYPE_CODE=(SELECT PROTO_CORRESP_TYPE_CODE FROM PROTO_CORRESP_TYPE WHERE DESCRIPTION = 'Approval Letter')  AND  COMMITTEE_ID =  'DEFAULT' FOR UPDATE;
buffer := '                          </fo:inline>
                                        <fo:inline font-family="Arial" font-size="10pt">
                                            <xsl:text>he above-referenced protocol has been APPROVED following Full Board Review by the Committee on the Use of Humans as Experimental Subjects (COUHES).&#160; </xsl:text>
                                        </fo:inline>
                                        <fo:block/>
                                        <fo:inline font-family="Arial" font-size="10pt">
                                            <xsl:text>If the research involves collaboration with another institution then the research cannot commence until COUHES receives written notification of approval from the collaborating institution&apos;s IRB</xsl:text>
                                        </fo:inline>
                                        <fo:inline font-family="Arial" font-size="10pt">
                                            <xsl:text>.</xsl:text>
                                        </fo:inline>
                                        <fo:block/>
                                        <fo:inline font-family="Arial" font-size="10pt">
                                            <xsl:text>It is the Principal Investigator&apos;s responsibility to obtain review and continued approval before the expiration date.&#160; Please allow sufficient time for continued approval.&#160; You may not continue any research activity beyond the expiration date without COUHES approval.&#160; Failure to receive approval for continuation before the expiration date will result in the automatic suspension of the approval of this protocol.&#160; Information</xsl:text>
                                        </fo:inline>
                                        <fo:inline font-family="Arial" font-size="10pt" font-weight="bold">
                                            <xsl:text>&#160;</xsl:text>
                                        </fo:inline>
                                        <fo:inline font-family="Arial" font-size="10pt">
                                            <xsl:text>collected following suspension is unapproved research and cannot be reported or published as research data.&#160; If you do not wish continued approval, please notify the Committee of the study termination.</xsl:text>
                                        </fo:inline>
                                    </xsl:otherwise>
                                </xsl:choose>
                                <fo:block/>
                                <fo:block>
                                    <fo:leader leader-pattern="space"/>
                                </fo:block>
                                <fo:inline-container>
                                    <fo:block>
                                        <xsl:text>&#x2029;</xsl:text>
                                    </fo:block>
                                </fo:inline-container>
                                <fo:block margin="0pt">
                                    <fo:block>
                                        <fo:inline font-family="Arial" font-size="10pt">
                                            <xsl:text>Adverse Events:&#160; Any serious or unexpected adverse event must be reported to COUHES within 48 hours.&#160; All other adverse events should be reported in writing within 10 working days. </xsl:text>
                                        </fo:inline>
                                    </fo:block>
                                </fo:block>
                                <fo:block/>
                                <fo:inline font-family="Arial" font-size="10pt">
                                    <xsl:text>Amendments:&#160; Any changes to the protocol that impact human subjects, including changes in experimental design, equipment, personnel or funding, must be approved by COUHES before they can';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE    data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT CORRESPONDENCE_TEMPLATE INTO data FROM PROTO_CORRESP_TEMPL
WHERE
PROTO_CORRESP_TYPE_CODE=(SELECT PROTO_CORRESP_TYPE_CODE FROM PROTO_CORRESP_TYPE WHERE DESCRIPTION = 'Approval Letter')  AND  COMMITTEE_ID =  'DEFAULT' FOR UPDATE;
buffer := ' be initiated. </xsl:text>
                                </fo:inline>
                                <fo:block/>
                                <fo:inline font-family="Arial" font-size="10pt">
                                    <xsl:text>Prospective new study personnel must, where applicable, complete training in human subjects research and in the HIPAA Privacy Rule before participating in the study.</xsl:text>
                                </fo:inline>
                                <fo:block/>
                                <fo:inline font-family="Arial" font-size="10pt">
                                    <xsl:text>You must maintain a research file for at least 3 years after completion of the study.&#160; This file should include all correspondence with COUHES, original signed consent forms, and study data.</xsl:text>
                                </fo:inline>
                                <fo:block>
                                    <fo:leader leader-pattern="space"/>
                                </fo:block>
                                <fo:inline-container>
                                    <fo:block>
                                        <xsl:text>&#x2029;</xsl:text>
                                    </fo:block>
                                </fo:inline-container>
                                <fo:block margin="0pt">
                                    <fo:block>
                                        <fo:block>
                                            <fo:leader leader-pattern="space"/>
                                        </fo:block>
                                        <fo:inline-container>
                                            <fo:block>
                                                <xsl:text>&#x2029;</xsl:text>
                                            </fo:block>
                                        </fo:inline-container>
                                        <fo:block margin="0pt">
                                            <fo:block>
                                                <fo:block>
                                                    <fo:leader leader-pattern="space"/>
                                                </fo:block>
                                                <fo:inline-container>
                                                    <fo:block>
                                                        <xsl:text>&#x2029;</xsl:text>
                                                    </fo:block>
                                                </fo:inline-container>
                                                <fo:block margin="0pt">
                                                    <fo:block>
                                                        <fo:block>
                                                            <fo:leader leader-pattern="space"/>
                                                        </fo:block>
                                                        <fo:inline-container>
                                                            <fo:block>
                                                                <xsl:text>&#x2029;</xsl:text>
                                                            </fo:block>
                                                        </fo:inline-container>
                                                        <fo:block margin="0pt">
                                                            <fo:block>
                                                                <fo:block>
                                                                    <fo:leader leader-pattern="space"/>
                                                                </fo:block>
                                                                <fo:inline-container>
                                                                    <fo:block>
             ';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE    data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT CORRESPONDENCE_TEMPLATE INTO data FROM PROTO_CORRESP_TEMPL
WHERE
PROTO_CORRESP_TYPE_CODE=(SELECT PROTO_CORRESP_TYPE_CODE FROM PROTO_CORRESP_TYPE WHERE DESCRIPTION = 'Approval Letter')  AND  COMMITTEE_ID =  'DEFAULT' FOR UPDATE;
buffer := '                                                           <xsl:text>&#x2029;</xsl:text>
                                                                    </fo:block>
                                                                </fo:inline-container>
                                                                <fo:block margin="0pt">
                                                                    <fo:block>
                                                                        <fo:block>
                                                                            <fo:leader leader-pattern="space"/>
                                                                        </fo:block>
                                                                        <fo:inline-container>
                                                                            <fo:block>
                                                                                <xsl:text>&#x2029;</xsl:text>
                                                                            </fo:block>
                                                                        </fo:inline-container>
                                                                        <fo:block margin="0pt">
                                                                            <fo:block>
                                                                                <fo:block>
                                                                                    <fo:leader leader-pattern="space"/>
                                                                                </fo:block>
                                                                                <fo:inline-container>
                                                                                    <fo:block>
                                                                                        <xsl:text>&#x2029;</xsl:text>
                                                                                    </fo:block>
                                                                                </fo:inline-container>
                                                                                <fo:block margin="0pt">
                                                                                    <fo:block>
                                                                                        <fo:block>
                                                                                            <fo:leader leader-pattern="space"/>
                                                                                        </fo:block>
                                                                                        <fo:inline-container>
                                                                                            <fo:block>
                                                                                                <xsl:text>&#x2029;</xsl:text>
                                                                                            </fo:block>
                                                                                        </fo:inline-container>
                                                                                        <fo:block margin="0pt">
                                                                                            <fo:block>
                                                                                                <fo:block>
                                                                                                    <fo:leader leader-pattern="space"/>
                                                                                                </fo:block>
                                                                                                <fo:inline-container>
                     ';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE    data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT CORRESPONDENCE_TEMPLATE INTO data FROM PROTO_CORRESP_TEMPL
WHERE
PROTO_CORRESP_TYPE_CODE=(SELECT PROTO_CORRESP_TYPE_CODE FROM PROTO_CORRESP_TYPE WHERE DESCRIPTION = 'Approval Letter')  AND  COMMITTEE_ID =  'DEFAULT' FOR UPDATE;
buffer := '                                                                               <fo:block>
                                                                                                        <xsl:text>&#x2029;</xsl:text>
                                                                                                    </fo:block>
                                                                                                </fo:inline-container>
                                                                                                <fo:block margin="0pt">
                                                                                                    <fo:block>
                                                                                                        <fo:inline-container>
                                                                                                            <fo:block>
                                                                                                                <xsl:text>&#x2029;</xsl:text>
                                                                                                         </fo:block>
                                                                                                        </fo:inline-container>
                                                                                                        <fo:block margin="0pt">
                                                                                                            <fo:block>
                                                                                                                <fo:inline-container>
                                                                                                                    <fo:block>
                                                                                                                        <xsl:text>&#x2029;</xsl:text>
                                                                                                                    </fo:block>
                                                                                                                </fo:inline-container>
                                                                                                                <fo:table table-layout="fixed" width="100%" border-spacing="2pt">
                                                                                                                    <fo:table-column column-width="31"/>
                                                                                                                    <fo:table-column column-width="proportional-column-width(1)"/>
                                                                                                                    <fo:table-body start-indent="0pt">
                                                                                                                        <fo:table-row>
                                                                                                                            <fo:table-cell padding="2pt" display-align="before">
                                                                                                                                <fo:block>
                                                                                                                                    <fo:inline font-family="Arial" font-size="10pt">
                                                                                                                                        <xsl:text>cc:</xsl:text>
                                                                                                                                    </fo:inline>
                                                                                                                                </fo:bl';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE    data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT CORRESPONDENCE_TEMPLATE INTO data FROM PROTO_CORRESP_TEMPL
WHERE
PROTO_CORRESP_TYPE_CODE=(SELECT PROTO_CORRESP_TYPE_CODE FROM PROTO_CORRESP_TYPE WHERE DESCRIPTION = 'Approval Letter')  AND  COMMITTEE_ID =  'DEFAULT' FOR UPDATE;
buffer := 'ock>
                                                                                                                            </fo:table-cell>
                                                                                                                            <fo:table-cell padding="2pt" display-align="center">
                                                                                                                                <fo:block>
                                                                                                                                    <fo:block>
                                                                                                                                        <fo:leader leader-pattern="space"/>
                                                                                                                                    </fo:block>
                                                                                                                                    <fo:inline-container>
                                                                                                                                        <fo:block>
                                                                                                                                            <xsl:text>&#x2029;</xsl:text>
                                                                                                                                        </fo:block>
                                                                                                                                    </fo:inline-container>
                                                                                                                                    <fo:block margin="0pt">
                                                                                                                                        <fo:block>
                                                                                                                                            <fo:inline font-family="Arial" font-size="10pt">
                                                                                                                                                <xsl:text>Tom Duff</xsl:text>
                                                                                                                                            </fo:inline>
                                                                                                                                        </fo:block>
                                                                                                                                    </fo:block>
                                                                                                                                    <xsl:for-each select="n1:Protocol">
                                                                                                                                        <xsl:for-each select="n1:Correspondent">
                                                                                                                                            <xsl:if test="n1:TypeOfCorrespondent = &apos;CRC&apos;">
                                                                                                                                                <xsl:for-each select="n1:Person">
                                                                                                                                                    <xsl:for-each select="n1:Fullname">
                                                                                                                                                        <xsl:variable name="value-of-template">
                                                                         ';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE    data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT CORRESPONDENCE_TEMPLATE INTO data FROM PROTO_CORRESP_TEMPL
WHERE
PROTO_CORRESP_TYPE_CODE=(SELECT PROTO_CORRESP_TYPE_CODE FROM PROTO_CORRESP_TYPE WHERE DESCRIPTION = 'Approval Letter')  AND  COMMITTEE_ID =  'DEFAULT' FOR UPDATE;
buffer := '                                                                                   <xsl:apply-templates/>
                                                                                                                                                        </xsl:variable>
                                                                                                                                                        <xsl:choose>
                                                                                                                                                            <xsl:when test="contains(string($value-of-template),''&#x2029;'')">
                                                                                                                                                                <fo:block font-family="Arial" font-size="10pt">
                                                                                                                                                                    <xsl:copy-of select="$value-of-template"/>
                                                                                                                                                                </fo:block>
                                                                                                                                                            </xsl:when>
                                                                                                                                                            <xsl:otherwise>
                                                                                                                                                                <fo:inline font-family="Arial" font-size="10pt">
                                                                                                                                                                    <xsl:copy-of select="$value-of-template"/>
                                                                                                                                                                </fo:inline>
                                                                                                                                                            </xsl:otherwise>
                                                                                                                                                        </xsl:choose>
                                                                                                                                                    </xsl:for-each>
                                                                                                                                                </xsl:for-each>
                                                                                                                                            </xsl:if>
                                                                                                                                        </xsl:for-each>
                                                                                                                                    </xsl:for-each>
                                                                                                                                </fo:block>
                                                                                                                            </fo:table-cell>
                                                                                                                        </fo:table-row>
                                                                                                                    </fo:table-body>
                                                                                                                </fo:table>
          ';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE    data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT CORRESPONDENCE_TEMPLATE INTO data FROM PROTO_CORRESP_TEMPL
WHERE
PROTO_CORRESP_TYPE_CODE=(SELECT PROTO_CORRESP_TYPE_CODE FROM PROTO_CORRESP_TYPE WHERE DESCRIPTION = 'Approval Letter')  AND  COMMITTEE_ID =  'DEFAULT' FOR UPDATE;
buffer := '                                                                                                  </fo:block>
                                                                                                        </fo:block>
                                                                                                        <fo:block>
                                                                                                            <fo:leader leader-pattern="space"/>
                                                                                                        </fo:block>
                                                                                                        <fo:inline-container>
                                                                                                            <fo:block>
                                                                                                                <xsl:text>&#x2029;</xsl:text>
                                                                                                            </fo:block>
                                                                                                        </fo:inline-container>
                                                                                                        <fo:block margin="0pt">
                                                                                                            <fo:block>
                                                                                                                <fo:block>
                                                                                                                    <fo:leader leader-pattern="space"/>
                                                                                                                </fo:block>
                                                                                                                <fo:inline-container>
                                                                                                                    <fo:block>
                                                                                                                        <xsl:text>&#x2029;</xsl:text>
                                                                                                                    </fo:block>
                                                                                                                </fo:inline-container>
                                                                                                                <fo:block margin="0pt">
                                                                                                                    <fo:block>
                                                                                                                        <fo:inline font-size="10pt">
                                                                                                                            <xsl:text>
</xsl:text>
                                                                                                                        </fo:inline>
                                                                                                                    </fo:block>
                                                                                                                </fo:block>
                                                                                                            </fo:block>
                                                                                                        </fo:block>
                                                                                                    </fo:block>
                                                                                                </fo:block>
             ';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE    data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT CORRESPONDENCE_TEMPLATE INTO data FROM PROTO_CORRESP_TEMPL
WHERE
PROTO_CORRESP_TYPE_CODE=(SELECT PROTO_CORRESP_TYPE_CODE FROM PROTO_CORRESP_TYPE WHERE DESCRIPTION = 'Approval Letter')  AND  COMMITTEE_ID =  'DEFAULT' FOR UPDATE;
buffer := '                                                                               </fo:block>
                                                                                        </fo:block>
                                                                                    </fo:block>
                                                                                </fo:block>
                                                                            </fo:block>
                                                                        </fo:block>
                                                                    </fo:block>
                                                                </fo:block>
                                                            </fo:block>
                                                        </fo:block>
                                                    </fo:block>
                                                </fo:block>
                                            </fo:block>
                                        </fo:block>
                                    </fo:block>
                                </fo:block>
                            </xsl:for-each>
                            <fo:block>
                                <fo:leader leader-pattern="space"/>
                            </fo:block>
                            <fo:inline-container>
                                <fo:block>
                                    <xsl:text>&#x2029;</xsl:text>
                                </fo:block>
                            </fo:inline-container>
                            <fo:block margin="0pt">
                                <fo:block>
                                    <fo:block>
                                        <fo:leader leader-pattern="space"/>
                                    </fo:block>
                                    <fo:inline-container>
                                        <fo:block>
                                            <xsl:text>&#x2029;</xsl:text>
                                        </fo:block>
                                    </fo:inline-container>
                                    <fo:block margin="0pt">
                                        <fo:block>
                                            <fo:block>
                                                <fo:leader leader-pattern="space"/>
                                            </fo:block>
                                            <fo:inline-container>
                                                <fo:block>
                                                    <xsl:text>&#x2029;</xsl:text>
                                                </fo:block>
                                            </fo:inline-container>
                                            <fo:block margin="0pt">
                                                <fo:block>
                                                    <fo:block>
                                                        <fo:leader leader-pattern="space"/>
                                                    </fo:block>
                                                    <fo:inline-container>
                                                        <fo:block>
                                                            <xsl:text>&#x2029;</xsl:text>
                                                        </fo:block>
                                                    </fo:inline-container>
                                                    <fo:block margin="0pt">
                                                        <fo:block>
                                                            <fo:block>
                                                                <fo:leader leader-pattern="space"/>
                                                            </fo:block>
                  ';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE    data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT CORRESPONDENCE_TEMPLATE INTO data FROM PROTO_CORRESP_TEMPL
WHERE
PROTO_CORRESP_TYPE_CODE=(SELECT PROTO_CORRESP_TYPE_CODE FROM PROTO_CORRESP_TYPE WHERE DESCRIPTION = 'Approval Letter')  AND  COMMITTEE_ID =  'DEFAULT' FOR UPDATE;
buffer := '                                          <fo:inline-container>
                                                                <fo:block>
                                                                    <xsl:text>&#x2029;</xsl:text>
                                                                </fo:block>
                                                            </fo:inline-container>
                                                            <fo:block margin="0pt">
                                                                <fo:block>
                                                                    <fo:block>
                                                                        <fo:leader leader-pattern="space"/>
                                                                    </fo:block>
                                                                    <fo:inline-container>
                                                                        <fo:block>
                                                                            <xsl:text>&#x2029;</xsl:text>
                                                                        </fo:block>
                                                                    </fo:inline-container>
                                                                    <fo:block margin="0pt">
                                                                        <fo:block>
                                                                            <fo:block>
                                                                                <fo:leader leader-pattern="space"/>
                                                                            </fo:block>
                                                                            <fo:inline-container>
                                                                                <fo:block>
                                                                                    <xsl:text>&#x2029;</xsl:text>
                                                                                </fo:block>
                                                                            </fo:inline-container>
                                                                            <fo:block margin="0pt">
                                                                                <fo:block>
                                                                                    <fo:block>
                                                                                        <fo:leader leader-pattern="space"/>
                                                                                    </fo:block>
                                                                                    <fo:inline-container>
                                                                                        <fo:block>
                                                                                            <xsl:text>&#x2029;</xsl:text>
                                                                                        </fo:block>
                                                                                    </fo:inline-container>
                                                                                    <fo:block margin="0pt">
                                                                                        <fo:block>
                                                                                            <fo:block>
                                                                                                <fo:leader leader-pattern="space"/>
                                                                                            </fo:block>
                                                                                            <fo:inline-container>
                       ';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE    data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT CORRESPONDENCE_TEMPLATE INTO data FROM PROTO_CORRESP_TEMPL
WHERE
PROTO_CORRESP_TYPE_CODE=(SELECT PROTO_CORRESP_TYPE_CODE FROM PROTO_CORRESP_TYPE WHERE DESCRIPTION = 'Approval Letter')  AND  COMMITTEE_ID =  'DEFAULT' FOR UPDATE;
buffer := '                                                                         <fo:block>
                                                                                                    <xsl:text>&#x2029;</xsl:text>
                                                                                                </fo:block>
                                                                                            </fo:inline-container>
                                                                                            <fo:block margin="0pt">
                                                                                                <fo:block>
                                                                                                    <fo:block>
                                                                                                        <fo:leader leader-pattern="space"/>
                                                                                                    </fo:block>
                                                                                                    <fo:inline-container>
                                                                                                        <fo:block>
                                                                                                            <xsl:text>&#x2029;</xsl:text>
                                                                                                        </fo:block>
                                                                                                    </fo:inline-container>
                                                                                                    <fo:block margin="0pt">
                                                                                                        <fo:block>
                                                                                                            <fo:block>
                                                                                                                <fo:leader leader-pattern="space"/>
                                                                                                            </fo:block>
                                                                                                            <fo:inline-container>
                                                                                                                <fo:block>
                                                                                                                    <xsl:text>&#x2029;</xsl:text>
                                                                                                                </fo:block>
                                                                                                            </fo:inline-container>
                                                                                                            <fo:block margin="0pt">
                                                                                                                <fo:block/>
                                                                                                            </fo:block>
                                                                                                        </fo:block>
                                                                                                    </fo:block>
                                                                                                </fo:block>
                                                                                            </fo:block>
                                                                                        </fo:block>
                                                                                    </fo:block>
                                      ';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE    data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT CORRESPONDENCE_TEMPLATE INTO data FROM PROTO_CORRESP_TEMPL
WHERE
PROTO_CORRESP_TYPE_CODE=(SELECT PROTO_CORRESP_TYPE_CODE FROM PROTO_CORRESP_TYPE WHERE DESCRIPTION = 'Approval Letter')  AND  COMMITTEE_ID =  'DEFAULT' FOR UPDATE;
buffer := '                                          </fo:block>
                                                                            </fo:block>
                                                                        </fo:block>
                                                                    </fo:block>
                                                                </fo:block>
                                                            </fo:block>
                                                        </fo:block>
                                                    </fo:block>
                                                </fo:block>
                                            </fo:block>
                                        </fo:block>
                                    </fo:block>
                                </fo:block>
                            </fo:block>
                        </xsl:for-each>
                    </fo:block>
                    <fo:block id="SV_RefID_PageTotal"/>
                </fo:flow>
            </fo:page-sequence>
        </fo:root>
    </xsl:template>
    <xsl:template name="headerall">
        <fo:static-content flow-name="xsl-region-before">
            <fo:block>
                <xsl:for-each select="$XML">
                    <fo:inline-container>
                        <fo:block>
                            <xsl:text>&#x2029;</xsl:text>
                        </fo:block>
                    </fo:inline-container>
                    <fo:table table-layout="fixed" width="100%" border-spacing="2pt">
                        <fo:table-column column-width="proportional-column-width(1)"/>
                        <fo:table-column column-width="150"/>
                        <fo:table-body start-indent="0pt">
                            <fo:table-row>
                                <fo:table-cell padding="0" number-columns-spanned="2" height="30" display-align="center">
                                    <fo:block/>
                                </fo:table-cell>
                            </fo:table-row>
                            <fo:table-row>
                                <fo:table-cell font-size="smaller" padding="0" text-align="left" display-align="center">
                                    <fo:block/>
                                </fo:table-cell>
                                <fo:table-cell font-size="smaller" padding="0" text-align="right" display-align="center">
                                    <fo:block/>
                                </fo:table-cell>
                            </fo:table-row>
                            <fo:table-row>
                                <fo:table-cell padding="0" number-columns-spanned="2" display-align="center">
                                    <fo:block/>
                                </fo:table-cell>
                            </fo:table-row>
                        </fo:table-body>
                    </fo:table>
                </xsl:for-each>
            </fo:block>
        </fo:static-content>
    </xsl:template>
    <xsl:template name="double-backslash">
        <xsl:param name="text"/>
        <xsl:param name="text-length"/>
        <xsl:variable name="text-after-bs" select="substring-after($text, ''\'')"/>
        <xsl:variable name="text-after-bs-length" select="string-length($text-after-bs)"/>
        <xsl:choose>
            <xsl:when test="$text-after-bs-length = 0">
                <xsl:choose>
                    <xsl:when test="substring($text, $text-length) = ''\''">
                        <xsl:value-of select="concat(substring($text,1,$text-length - 1), ''\\'')"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:value-of select="$text"/>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            <xsl:otherwise>
                <xsl:val';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE    data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT CORRESPONDENCE_TEMPLATE INTO data FROM PROTO_CORRESP_TEMPL
WHERE
PROTO_CORRESP_TYPE_CODE=(SELECT PROTO_CORRESP_TYPE_CODE FROM PROTO_CORRESP_TYPE WHERE DESCRIPTION = 'Approval Letter')  AND  COMMITTEE_ID =  'DEFAULT' FOR UPDATE;
buffer := 'ue-of select="concat(substring($text,1,$text-length - $text-after-bs-length - 1), ''\\'')"/>
                <xsl:call-template name="double-backslash">
                    <xsl:with-param name="text" select="$text-after-bs"/>
                    <xsl:with-param name="text-length" select="$text-after-bs-length"/>
                </xsl:call-template>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
</xsl:stylesheet>';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
commit;
