---
-- #%L
-- %%
-- Copyright (C) 2005 - 2021 Kuali, Inc. - All Rights Reserved
-- %%
-- You may use and modify this code under the terms of the Kuali, Inc.
-- Pre-Release License Agreement. You may not distribute it.
-- 
-- You should have received a copy of the Kuali, Inc. Pre-Release License
-- Agreement with this file. If not, please write to license@kuali.co.
-- #L%
---
CREATE TABLE KC_ACTIVEMQ_ACKS  (
  CONTAINER    	VARCHAR2(250) NOT NULL,
  SUB_DEST     	VARCHAR2(250) NULL,
  CLIENT_ID    	VARCHAR2(250) NOT NULL,
  SUB_NAME     	VARCHAR2(250) NOT NULL,
  SELECTOR     	VARCHAR2(250) NULL,
  LAST_ACKED_ID	NUMBER NULL,
  PRIORITY     	NUMBER DEFAULT 5 NOT NULL,
  XID          	VARCHAR2(250) NULL,
  PRIMARY KEY(CONTAINER,CLIENT_ID,SUB_NAME,PRIORITY)
);

CREATE INDEX KC_ACTIVEMQ_ACKS_XIDX
ON KC_ACTIVEMQ_ACKS(XID);

CREATE TABLE KC_ACTIVEMQ_LOCK  (
  ID         	NUMBER NOT NULL,
  TIME       	NUMBER NULL,
  BROKER_NAME	VARCHAR2(250) NULL,
  PRIMARY KEY(ID)
);

CREATE TABLE KC_ACTIVEMQ_MSGS  (
  ID        	NUMBER NOT NULL,
  CONTAINER 	VARCHAR2(250) NULL,
  MSGID_PROD	VARCHAR2(250) NULL,
  MSGID_SEQ 	NUMBER NULL,
  EXPIRATION	NUMBER NULL,
  MSG       	BLOB NULL,
  PRIORITY  	NUMBER NULL,
  XID       	VARCHAR2(250) NULL,
  PRIMARY KEY(ID)
);

CREATE INDEX KC_ACTIVEMQ_MSGS_CIDX
ON KC_ACTIVEMQ_MSGS(CONTAINER);

CREATE INDEX KC_ACTIVEMQ_MSGS_EIDX
ON KC_ACTIVEMQ_MSGS(EXPIRATION);

CREATE INDEX KC_ACTIVEMQ_MSGS_MIDX
ON KC_ACTIVEMQ_MSGS(MSGID_PROD, MSGID_SEQ);

CREATE INDEX KC_ACTIVEMQ_MSGS_PIDX
ON KC_ACTIVEMQ_MSGS(PRIORITY);

CREATE INDEX KC_ACTIVEMQ_MSGS_XIDX
ON KC_ACTIVEMQ_MSGS(XID);
