---
-- #%L
-- %%
-- Copyright (C) 2005 - 2021 Kuali, Inc. - All Rights Reserved
-- %%
-- You may use and modify this code under the terms of the Kuali, Inc.
-- Pre-Release License Agreement. You may not distribute it.
-- 
-- You should have received a copy of the Kuali, Inc. Pre-Release License
-- Agreement with this file. If not, please write to license@kuali.co.
-- #L%
---


DECLARE
  COUNTER PLS_INTEGER;
  CURSOR MAIN_CUR IS
    select subaward_code, sequence_number, subaward_id
    from subaward
    where subaward_sequence_status in ('ACTIVE', 'PENDING', 'ARCHIVED')
    order by subaward_code, sequence_number;
BEGIN
  BEGIN
    EXECUTE IMMEDIATE 'DROP TABLE subaward_amount_info_new';
  EXCEPTION
    WHEN OTHERS THEN IF SQLCODE != -942 THEN RAISE; END IF;
  END;
  EXECUTE IMMEDIATE 'CREATE TABLE subaward_amount_info_new AS (SELECT * FROM subaward_amount_info)';
  EXECUTE IMMEDIATE 'DELETE FROM subaward_amount_info_new';

  BEGIN
      EXECUTE IMMEDIATE 'DROP TABLE subaward_ffata_repor_v1905_006';
  EXCEPTION
      WHEN OTHERS THEN IF SQLCODE != -942 THEN RAISE; END IF;
  END;
  EXECUTE IMMEDIATE 'CREATE TABLE subaward_ffata_repor_v1905_006 AS (SELECT * FROM subaward_ffata_reporting)';

  EXECUTE IMMEDIATE 'alter table SUBAWARD_FFATA_REPORTING drop constraint FK2_SUBAWARD_FFATA_REPORTING';

  FOR SUBAWARD in MAIN_CUR
    LOOP
      DECLARE
        CURSOR TOINSERT_CUR IS
          select SUBAWARD_AMOUNT_INFO_ID,
                 OBLIGATED_AMOUNT,
                 OBLIGATED_CHANGE,
                 ANTICIPATED_AMOUNT,
                 ANTICIPATED_CHANGE,
                 EFFECTIVE_DATE,
                 COMMENTS,
                 UPDATE_TIMESTAMP,
                 UPDATE_USER,
                 FILE_NAME,
                 MIME_TYPE,
                 VER_NBR,
                 MODIFICATION_EFFECTIVE_DATE,
                 MODIFICATION_NUMBER,
                 PERFORMANCE_START_DATE,
                 PERFORMANCE_END_DATE,
                 FILE_DATA_ID,
                 MODIFICATION_TYPE_CODE,
                 OBLIGATED_CHANGE_DIRECT,
                 OBLIGATED_CHANGE_INDIRECT,
                 ANTICIPATED_CHANGE_DIRECT,
                 ANTICIPATED_CHANGE_INDIRECT,
                 RATE
          from subaward_amount_info
          where subaward_id in (
            select subaward_id
            from subaward
            where subaward_sequence_status in ('ACTIVE', 'PENDING', 'ARCHIVED')
              and subaward_code = SUBAWARD.SUBAWARD_CODE
              and sequence_number <= SUBAWARD.SEQUENCE_NUMBER)
          order by SUBAWARD_AMOUNT_INFO_ID;
      BEGIN
        FOR AINFO in TOINSERT_CUR
          LOOP
            EXECUTE IMMEDIATE 'INSERT INTO subaward_amount_info_new values (
			  SUBAWARD_AMT_INFO_ID_S.NEXTVAL,
			  :a,
			  :b,
			  :c,
			  :d,
			  :e,
			  :f,
			  :g,
			  :h,
			  :i,
			  :j,
			  :q,
			  :l,
			  SYS_GUID(),
			  :m,
			  :n,
			  :o,
			  :p,
			  :q,
			  :r,
			  :s,
			  :t,
			  :u,
			  :v,
			  :w,
			  :x,
			  :y
			)' USING SUBAWARD.SUBAWARD_ID,
              AINFO.OBLIGATED_AMOUNT,
              AINFO.OBLIGATED_CHANGE,
              AINFO.ANTICIPATED_AMOUNT,
              AINFO.ANTICIPATED_CHANGE,
              AINFO.EFFECTIVE_DATE,
              AINFO.COMMENTS,
              AINFO.UPDATE_TIMESTAMP,
              AINFO.UPDATE_USER,
              AINFO.FILE_NAME,
              AINFO.MIME_TYPE,
              AINFO.VER_NBR,
              SUBAWARD.SEQUENCE_NUMBER,
              SUBAWARD.SUBAWARD_CODE,
              AINFO.MODIFICATION_EFFECTIVE_DATE,
              AINFO.MODIFICATION_NUMBER,
              AINFO.PERFORMANCE_START_DATE,
              AINFO.PERFORMANCE_END_DATE,
              AINFO.FILE_DATA_ID,
              AINFO.MODIFICATION_TYPE_CODE,
              AINFO.OBLIGATED_CHANGE_DIRECT,
              AINFO.OBLIGATED_CHANGE_INDIRECT,
              AINFO.ANTICIPATED_CHANGE_DIRECT,
              AINFO.ANTICIPATED_CHANGE_INDIRECT,
              AINFO.RATE;

            EXECUTE IMMEDIATE 'UPDATE subaward_ffata_reporting SET subaward_amount_info_id = :a WHERE subaward_id = :b AND subaward_amount_info_id = :c' USING SUBAWARD_AMT_INFO_ID_S.CURRVAL, SUBAWARD.SUBAWARD_ID, AINFO.SUBAWARD_AMOUNT_INFO_ID;

            IF COUNTER >= 500
            THEN
              COMMIT;
              COUNTER := 1;
            ELSE
              COUNTER := COUNTER + 1;
            END IF;
          END LOOP;
      END;
    END LOOP;

  COMMIT;

  EXECUTE IMMEDIATE 'RENAME subaward_amount_info TO subaward_amount_info_v1905_006';
  EXECUTE IMMEDIATE 'RENAME subaward_amount_info_new TO subaward_amount_info';

  EXECUTE IMMEDIATE 'ALTER TABLE subaward_amount_info_v1905_006 DROP CONSTRAINT PK_SUBAWARD_AMOUNT_INFO';
  EXECUTE IMMEDIATE 'ALTER TABLE subaward_amount_info_v1905_006 DROP CONSTRAINT FK_SUBAWARD_AMOUNT_INFO';
  EXECUTE IMMEDIATE 'ALTER TABLE subaward_amount_info_v1905_006 DROP CONSTRAINT FK2_SUBAWARD_AMOUNT_INFO';
  EXECUTE IMMEDIATE 'ALTER TABLE subaward_amount_info_v1905_006 DROP CONSTRAINT FK3_SUBAWARD_AMOUNT_INFO';

  EXECUTE IMMEDIATE 'ALTER TABLE SUBAWARD_AMOUNT_INFO ADD CONSTRAINT PK_SUBAWARD_AMOUNT_INFO
      PRIMARY KEY (SUBAWARD_AMOUNT_INFO_ID)';

  EXECUTE IMMEDIATE 'ALTER TABLE SUBAWARD_AMOUNT_INFO ADD CONSTRAINT FK_SUBAWARD_AMOUNT_INFO
      FOREIGN KEY (SUBAWARD_ID) REFERENCES SUBAWARD (SUBAWARD_ID)';

  EXECUTE IMMEDIATE 'alter table SUBAWARD_AMOUNT_INFO add constraint FK2_SUBAWARD_AMOUNT_INFO
      foreign key (FILE_DATA_ID) references FILE_DATA (ID)';

  EXECUTE IMMEDIATE 'alter table SUBAWARD_AMOUNT_INFO add constraint FK3_SUBAWARD_AMOUNT_INFO
      foreign key (MODIFICATION_TYPE_CODE) REFERENCES SUBAWARD_MODIFICATION_TYPE (CODE)';

  EXECUTE IMMEDIATE 'alter table SUBAWARD_FFATA_REPORTING add constraint FK2_SUBAWARD_FFATA_REPORTING
      foreign key (SUBAWARD_AMOUNT_INFO_ID) REFERENCES SUBAWARD_AMOUNT_INFO (SUBAWARD_AMOUNT_INFO_ID)';

END;
