---
-- #%L
-- %%
-- Copyright (C) 2005 - 2021 Kuali, Inc. - All Rights Reserved
-- %%
-- You may use and modify this code under the terms of the Kuali, Inc.
-- Pre-Release License Agreement. You may not distribute it.
-- 
-- You should have received a copy of the Kuali, Inc. Pre-Release License
-- Agreement with this file. If not, please write to license@kuali.co.
-- #L%
---
CREATE OR REPLACE FUNCTION clob_to_blob(p_clob IN CLOB) RETURN BLOB IS
  v_blob BLOB;
  v_offset NUMBER DEFAULT 1;
  v_amount NUMBER DEFAULT 4096;
  v_offsetwrite NUMBER DEFAULT 1;
  v_amountwrite NUMBER;
  v_buffer VARCHAR2(4096 CHAR);
BEGIN
  dbms_lob.createtemporary(v_blob, TRUE);

  Begin
    LOOP
      dbms_lob.READ (lob_loc => p_clob,
                     amount  => v_amount,
                     offset  => v_offset,
                     buffer  => v_buffer);

      v_amountwrite := utl_raw.length (r => utl_raw.cast_to_raw(c => v_buffer));

      dbms_lob.WRITE (lob_loc => v_blob,
                      amount  => v_amountwrite,
                      offset  => v_offsetwrite,
                      buffer  => utl_raw.cast_to_raw(v_buffer));

      v_offsetwrite := v_offsetwrite + v_amountwrite;

      v_offset := v_offset + v_amount;
      v_amount := 4096;

    END LOOP;
  EXCEPTION
    WHEN no_data_found THEN
      NULL;
  End;
  RETURN v_blob;
END clob_to_blob;
/

ALTER TABLE BUDGET_SUB_AWARDS ADD FILE_DATA_ID VARCHAR2(36);

ALTER TABLE BUDGET_SUB_AWARDS ADD XML_DATA_ID VARCHAR2(36);

UPDATE BUDGET_SUB_AWARDS SET FILE_DATA_ID = SYS_GUID() WHERE SUB_AWARD_XFD_FILE IS NOT NULL;

UPDATE BUDGET_SUB_AWARDS SET XML_DATA_ID = SYS_GUID() WHERE SUB_AWARD_XML_FILE IS NOT NULL;

INSERT INTO FILE_DATA (SELECT FILE_DATA_ID, SUB_AWARD_XFD_FILE FROM BUDGET_SUB_AWARDS WHERE FILE_DATA_ID IS NOT NULL);

ALTER TABLE BUDGET_SUB_AWARDS
    ADD CONSTRAINT FK2_BUDGET_SUB_AWARDS
    FOREIGN KEY (FILE_DATA_ID)
    REFERENCES FILE_DATA (ID);


DECLARE
    CURSOR cur IS SELECT XML_DATA_ID, SUB_AWARD_NUMBER FROM BUDGET_SUB_AWARDS where XML_DATA_ID is not null;
    content CLOB;
BEGIN
    FOR rec IN cur
    LOOP
        EXECUTE IMMEDIATE 'SELECT SUB_AWARD_XML_FILE FROM BUDGET_SUB_AWARDS where sub_award_number = ' || rec.sub_award_number || ' and xml_data_id = ''' || rec.xml_data_id || ''' ' INTO content;
    IF content IS NOT NULL THEN
EXECUTE IMMEDIATE 'INSERT INTO FILE_DATA (SELECT XML_DATA_ID, clob_to_blob(SUB_AWARD_XML_FILE) FROM BUDGET_SUB_AWARDS where sub_award_number = ' || rec.sub_award_number || ' and xml_data_id = ''' || rec.xml_data_id || ''')';
    END IF;
    END LOOP;
end;
/

ALTER TABLE BUDGET_SUB_AWARDS
    ADD CONSTRAINT FK3_BUDGET_SUB_AWARDS
    FOREIGN KEY (XML_DATA_ID)
    REFERENCES FILE_DATA (ID);

ALTER TABLE BUDGET_SUB_AWARDS DROP COLUMN SUB_AWARD_XFD_FILE;

ALTER TABLE BUDGET_SUB_AWARDS DROP COLUMN SUB_AWARD_XML_FILE;
