---
-- #%L
-- %%
-- Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
-- %%
-- You may use and modify this code under the terms of the Kuali, Inc.
-- Pre-Release License Agreement. You may not distribute it.
-- 
-- You should have received a copy of the Kuali, Inc. Pre-Release License
-- Agreement with this file. If not, please write to license@kuali.co.
-- #L%
---


CREATE SEQUENCE  SUBAWARD_FFATA_REPORTING_ID_S
MINVALUE 1 MAXVALUE 999999999999999999999999999 INCREMENT BY 1 START WITH 1 NOCACHE  ORDER  NOCYCLE;

CREATE TABLE SUBAWARD_FFATA_REPORTING (
  SUBAWARD_FFATA_REPORTING_ID number(12,0) PRIMARY KEY,
  SUBAWARD_ID number(12,0) NOT NULL,
  SUBAWARD_AMOUNT_INFO_ID number(12,0),
  OTHER_TRANS_DESC varchar2(100),
  DATE_SUBMITTED DATE NOT NULL,
  SUBMITTER_ID VARCHAR2(40) NOT NULL,
  COMMENTS CLOB,
  FILE_DATA_ID varchar2(36),
  FILE_NAME varchar2(150),
  MIME_TYPE varchar2(100),
  UPDATE_USER VARCHAR2(60) NOT NULL,
  UPDATE_TIMESTAMP DATE NOT NULL,
  VER_NBR number (8,0) DEFAULT 1 NOT NULL,
  OBJ_ID VARCHAR2(36) NOT NULL);


alter table SUBAWARD_FFATA_REPORTING add constraint FK1_SUBAWARD_FFATA_REPORTING foreign key (SUBAWARD_ID)
REFERENCES SUBAWARD (SUBAWARD_ID);

alter table SUBAWARD_FFATA_REPORTING add constraint FK2_SUBAWARD_FFATA_REPORTING foreign key (SUBAWARD_AMOUNT_INFO_ID)
REFERENCES SUBAWARD_AMOUNT_INFO (SUBAWARD_AMOUNT_INFO_ID);

alter table SUBAWARD_FFATA_REPORTING add constraint FK3_SUBAWARD_FFATA_REPORTING foreign key (FILE_DATA_ID)
REFERENCES FILE_DATA (ID);
