---
-- #%L
-- %%
-- Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
-- %%
-- You may use and modify this code under the terms of the Kuali, Inc.
-- Pre-Release License Agreement. You may not distribute it.
-- 
-- You should have received a copy of the Kuali, Inc. Pre-Release License
-- Agreement with this file. If not, please write to license@kuali.co.
-- #L%
---

CREATE TABLE GRANT_FORWARD_RECORD
(
    ID VARCHAR2(25) NOT NULL,
    PROPOSAL_NUMBER VARCHAR2(12) NULL,
    GRANT_ID NUMBER NOT NULL,
    URL VARCHAR2(2048),
    MODIFIED_DATE VARCHAR2(25),
    AMOUNT_INFO clob,
    SITE_GRANT_TYPE VARCHAR2(100),
    APPLICATION_URL VARCHAR2(2048),
    TITLE VARCHAR2(500),
    EXT_GRANT_ID VARCHAR2(100),
    ALL_TITLES VARCHAR2(2000),
    SUBMISSION_INFO clob,
    ALL_GRANT_SOURCE_URLS clob,
    STATUS VARCHAR2(25),
    DESCRIPTION clob,
    ELIGIBILITY clob,
    CATEGORIES_DISPLAY clob,
    LIMITED_GRANT_INFO clob,
    REPLACES VARCHAR2(250),
    USER_CATEGORIES clob,
    SUBMIT_DATE VARCHAR2(25),
    IS_LIMITED NUMBER,
    SITE_CATEGORIES clob,
    COST_SHARING clob,
    GRANT_SOURCE_URL VARCHAR2(2048),
    ALL_TYPES VARCHAR2(250),
    ALL_APPLICANT_TYPES VARCHAR2(250),
    UPDATE_TIMESTAMP DATE NOT NULL,
    UPDATE_USER VARCHAR2(60) NOT NULL,
    OBJ_ID VARCHAR2(36) NOT NULL,
    VER_NBR NUMBER default 1 NOT NULL
);

ALTER TABLE GRANT_FORWARD_RECORD
    ADD CONSTRAINT GRANT_FORWARD_RECORDP1
        PRIMARY KEY (ID);

ALTER TABLE GRANT_FORWARD_RECORD
    ADD CONSTRAINT GRANT_FORWARD_RECORDUQ1
        UNIQUE(OBJ_ID);

ALTER TABLE GRANT_FORWARD_RECORD
    ADD CONSTRAINT GRANT_FORWARD_RECORDUQ2
        UNIQUE(PROPOSAL_NUMBER);

ALTER TABLE GRANT_FORWARD_RECORD
    ADD CONSTRAINT GRANT_FORWARD_RECORDFK1
        FOREIGN KEY (PROPOSAL_NUMBER)
            REFERENCES EPS_PROPOSAL (PROPOSAL_NUMBER);

CREATE SEQUENCE SEQ_GF_RECORD_ID INCREMENT BY 1 START WITH 1 NOCACHE;

CREATE TABLE GRANT_FORWARD_AMOUNT
(
    ID VARCHAR2(25) NOT NULL,
    RECORD_ID VARCHAR2(25) NOT NULL,
    CONFIRMED VARCHAR2(1) NOT NULL,
    CURRENCY VARCHAR2(10) NOT NULL,
    TYPE VARCHAR2(25) NOT NULL,
    AMOUNT NUMBER(19, 2) NOT NULL,
    UPDATE_TIMESTAMP DATE NOT NULL,
    UPDATE_USER VARCHAR2(60) NOT NULL,
    OBJ_ID VARCHAR2(36) NOT NULL,
    VER_NBR NUMBER default 1 NOT NULL
);

ALTER TABLE GRANT_FORWARD_AMOUNT
    ADD CONSTRAINT GRANT_FORWARD_AMOUNTP1
        PRIMARY KEY (ID);

ALTER TABLE GRANT_FORWARD_AMOUNT
    ADD CONSTRAINT GRANT_FORWARD_AMOUNTUQ1
        UNIQUE(OBJ_ID);

ALTER TABLE GRANT_FORWARD_AMOUNT
    ADD CONSTRAINT GRANT_FORWARD_AMOUNTFK1
        FOREIGN KEY (RECORD_ID)
            REFERENCES GRANT_FORWARD_RECORD (ID);

CREATE SEQUENCE SEQ_GF_AMOUNT_ID INCREMENT BY 1 START WITH 1 NOCACHE;

CREATE TABLE GRANT_FORWARD_DEADLINE
(
    ID VARCHAR2(25) NOT NULL,
    RECORD_ID VARCHAR2(25) NOT NULL,
    TYPE VARCHAR2(25) NOT NULL,
    DEADLINE VARCHAR2(25) NOT NULL,
    UPDATE_TIMESTAMP DATE NOT NULL,
    UPDATE_USER VARCHAR2(60) NOT NULL,
    OBJ_ID VARCHAR2(36) NOT NULL,
    VER_NBR NUMBER default 1 NOT NULL
);

ALTER TABLE GRANT_FORWARD_DEADLINE
    ADD CONSTRAINT GRANT_FORWARD_DEADLINEP1
        PRIMARY KEY (ID);

ALTER TABLE GRANT_FORWARD_DEADLINE
    ADD CONSTRAINT GRANT_FORWARD_DEADLINEUQ1
        UNIQUE(OBJ_ID);

ALTER TABLE GRANT_FORWARD_DEADLINE
    ADD CONSTRAINT GRANT_FORWARD_DEADLINEFK1
        FOREIGN KEY (RECORD_ID)
            REFERENCES GRANT_FORWARD_RECORD (ID);

CREATE SEQUENCE SEQ_GF_DEADLINE_ID INCREMENT BY 1 START WITH 1 NOCACHE;

CREATE TABLE GRANT_FORWARD_LOCATION
(
    ID VARCHAR2(25) NOT NULL,
    RECORD_ID VARCHAR2(25) NOT NULL,
    IS_EXCLUDE NUMBER,
    IS_PRIMARY NUMBER,
    TYPE VARCHAR2(25) NOT NULL,
    LOCATION VARCHAR2(150) NOT NULL,
    UPDATE_TIMESTAMP DATE NOT NULL,
    UPDATE_USER VARCHAR2(60) NOT NULL,
    OBJ_ID VARCHAR2(36) NOT NULL,
    VER_NBR NUMBER default 1 NOT NULL
);

ALTER TABLE GRANT_FORWARD_LOCATION
    ADD CONSTRAINT GRANT_FORWARD_LOCATIONP1
        PRIMARY KEY (ID);

ALTER TABLE GRANT_FORWARD_LOCATION
    ADD CONSTRAINT GRANT_FORWARD_LOCATIONUQ1
        UNIQUE(OBJ_ID);

ALTER TABLE GRANT_FORWARD_LOCATION
    ADD CONSTRAINT GRANT_FORWARD_LOCATIONFK1
        FOREIGN KEY (RECORD_ID)
            REFERENCES GRANT_FORWARD_RECORD (ID);

CREATE SEQUENCE SEQ_GF_LOCATION_ID INCREMENT BY 1 START WITH 1 NOCACHE;

CREATE TABLE GRANT_FORWARD_SPONSOR
(
    ID VARCHAR2(25) NOT NULL,
    RECORD_ID VARCHAR2(25) NOT NULL,
    SPONSOR_ID NUMBER NOT NULL,
    SPONSOR VARCHAR2(200) NOT NULL,
    UPDATE_TIMESTAMP DATE NOT NULL,
    UPDATE_USER VARCHAR2(60) NOT NULL,
    OBJ_ID VARCHAR2(36) NOT NULL,
    VER_NBR NUMBER default 1 NOT NULL
);

ALTER TABLE GRANT_FORWARD_SPONSOR
    ADD CONSTRAINT GRANT_FORWARD_SPONSORP1
        PRIMARY KEY (ID);

ALTER TABLE GRANT_FORWARD_SPONSOR
    ADD CONSTRAINT GRANT_FORWARD_SPONSORUQ1
        UNIQUE(OBJ_ID);

ALTER TABLE GRANT_FORWARD_SPONSOR
    ADD CONSTRAINT GRANT_FORWARD_SPONSORFK1
        FOREIGN KEY (RECORD_ID)
            REFERENCES GRANT_FORWARD_RECORD (ID);

CREATE SEQUENCE SEQ_GF_SPONSOR_ID INCREMENT BY 1 START WITH 1 NOCACHE;
