---
-- #%L
-- %%
-- Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
-- %%
-- You may use and modify this code under the terms of the Kuali, Inc.
-- Pre-Release License Agreement. You may not distribute it.
-- 
-- You should have received a copy of the Kuali, Inc. Pre-Release License
-- Agreement with this file. If not, please write to license@kuali.co.
-- #L%
---

DELETE FROM PROTO_CORRESP_TEMPL WHERE PROTO_CORRESP_TYPE_CODE = 5  AND  COMMITTEE_ID =  'DEFAULT' ;
commit;
INSERT INTO PROTO_CORRESP_TEMPL(PROTO_CORRESP_TEMPL_ID,PROTO_CORRESP_TYPE_CODE,COMMITTEE_ID,FILE_NAME,CORRESPONDENCE_TEMPLATE,UPDATE_USER,UPDATE_TIMESTAMP,OBJ_ID,VER_NBR) values (SEQ_PROTO_CORRESP_TEMPL.NEXTVAL,5,'DEFAULT','DEFAULT-5-ExpeditedApprovalLetter.xsl',EMPTY_CLOB(),'admin',SYSDATE,SYS_GUID(),1);
DECLARE    data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT CORRESPONDENCE_TEMPLATE INTO data FROM PROTO_CORRESP_TEMPL
WHERE
PROTO_CORRESP_TYPE_CODE=5  AND  COMMITTEE_ID =  'DEFAULT' FOR UPDATE; 
buffer := '<?xml version="1.0" encoding="UTF-8"?>
<!--Designed and generated by Altova StyleVision Enterprise Edition 2008 rel. 2 - see http://www.altova.com/stylevision for more information.-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fn="http://www.w3.org/2005/xpath-functions" xmlns:n1="http://irb.mit.edu/irbnamespace" xmlns:xdt="http://www.w3.org/2005/xpath-datatypes" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:fo="http://www.w3.org/1999/XSL/Format">
    <xsl:output version="1.0" method="xml" encoding="UTF-8" indent="no"/>
    <xsl:param name="SV_OutputFormat" select="''PDF''"/>
    <xsl:variable name="XML" select="/"/>
    <xsl:variable name="fo:layout-master-set">
        <fo:layout-master-set>
            <fo:simple-page-master master-name="default-page" page-height="11in" page-width="8.5in" margin-left="0.6in" margin-right="1.0in">
                <fo:region-body margin-top="0.79in" margin-bottom="0.79in"/>
                <fo:region-before extent="0.79in"/>
            </fo:simple-page-master>
        </fo:layout-master-set>
    </xsl:variable>
    <xsl:template match="/">
        <fo:root>
            <xsl:copy-of select="$fo:layout-master-set"/>
            <fo:page-sequence master-reference="default-page" initial-page-number="1" format="1">
                <xsl:call-template name="headerall"/>
                <fo:flow flow-name="xsl-region-body">
                    <fo:block>
                        <xsl:for-each select="$XML">
                            <fo:external-graphic>
                                <xsl:attribute name="src">
                                    <xsl:text>url(</xsl:text>
                                    <xsl:call-template name="double-backslash">
                                        <xsl:with-param name="text">
                                            <xsl:value-of select="string(&apos;http://localhost:8080/CoeusApplet/images/couhes_byline2.gif&apos;)"/>
                                        </xsl:with-param>
                                        <xsl:with-param name="text-length">
                                            <xsl:value-of select="string-length(string(&apos;http://localhost:8080/CoeusApplet/images/couhes_byline2.gif&apos;))"/>
                                        </xsl:with-param>
                                    </xsl:call-template>
                                    <xsl:text>)</xsl:text>
                                </xsl:attribute>
                            </fo:external-graphic>
                            <fo:block/>
                            <xsl:for-each select="n1:Correspondence">
                                <fo:inline-container>
                                    <fo:block>
                                        <xsl:text>&#x2029;</xsl:text>
                                    </fo:block>
                                </fo:inline-container>
                                <fo:block font-size="10pt" font-style="normal" margin="0pt">
                                    <fo:block>
                                        <fo:inline-container>
                                            <fo:block>
                                                <xsl:text>&#x2029;</xsl:text>
                                            </fo:block>
                                        </fo:inline-container>
                                        <fo:table table-layout="fixed" width="100%" border-spacing="2pt">
                                            <fo:table-column column-width="127"/>
                                            <fo:table-column column-width="388"/>
                                            <fo:table-body start-indent="0pt">
                                                <fo:table-row>
                                                    <fo:table-cell padding="2pt" display-align="b';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE    data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT CORRESPONDENCE_TEMPLATE INTO data FROM PROTO_CORRESP_TEMPL
WHERE
PROTO_CORRESP_TYPE_CODE=5  AND  COMMITTEE_ID =  'DEFAULT' FOR UPDATE;
buffer := 'efore">
                                                        <fo:block>
                                                            <fo:inline font-size="10pt" font-weight="bold">
                                                                <xsl:text>To:</xsl:text>
                                                            </fo:inline>
                                                            <fo:inline font-size="10pt">
                                                                <xsl:text>&#160;&#160;&#160;&#160;&#160; </xsl:text>
                                                            </fo:inline>
                                                        </fo:block>
                                                    </fo:table-cell>
                                                    <fo:table-cell padding="2pt" display-align="center">
                                                        <fo:block>
                                                            <xsl:for-each select="n1:Protocol">
                                                                <xsl:for-each select="n1:Investigator">
                                                                    <xsl:if test="n1:PI_flag = &apos;true&apos;">
                                                                        <xsl:for-each select="n1:Person">
                                                                            <xsl:for-each select="n1:Firstname">
                                                                                <xsl:variable name="value-of-template">
                                                                                    <xsl:apply-templates/>
                                                                                </xsl:variable>
                                                                                <xsl:choose>
                                                                                    <xsl:when test="contains(string($value-of-template),''&#x2029;'')">
                                                                                        <fo:block font-size="10pt">
                                                                                            <xsl:copy-of select="$value-of-template"/>
                                                                                        </fo:block>
                                                                                    </xsl:when>
                                                                                    <xsl:otherwise>
                                                                                        <fo:inline font-size="10pt">
                                                                                            <xsl:copy-of select="$value-of-template"/>
                                                                                        </fo:inline>
                                                                                    </xsl:otherwise>
                                                                                </xsl:choose>
                                                                            </xsl:for-each>
                                                                            <fo:inline font-size="10pt">
                                                                                <xsl:text>&#160;</xsl:text>
                                                                            </fo:inline>
                                                                            <xsl:for-each select="n1:LastName">
                                                                                <xsl:variable name="value-of-template">
                                                                                    <xsl:apply-templates/>
                                                                                </xsl:variable>
  ';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE    data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT CORRESPONDENCE_TEMPLATE INTO data FROM PROTO_CORRESP_TEMPL
WHERE
PROTO_CORRESP_TYPE_CODE=5  AND  COMMITTEE_ID =  'DEFAULT' FOR UPDATE;
buffer := '                                                                              <xsl:choose>
                                                                                    <xsl:when test="contains(string($value-of-template),''&#x2029;'')">
                                                                                        <fo:block font-size="10pt">
                                                                                            <xsl:copy-of select="$value-of-template"/>
                                                                                        </fo:block>
                                                                                    </xsl:when>
                                                                                    <xsl:otherwise>
                                                                                        <fo:inline font-size="10pt">
                                                                                            <xsl:copy-of select="$value-of-template"/>
                                                                                        </fo:inline>
                                                                                    </xsl:otherwise>
                                                                                </xsl:choose>
                                                                            </xsl:for-each>
                                                                            <fo:block>
                                                                                <fo:leader leader-pattern="space"/>
                                                                            </fo:block>
                                                                            <fo:inline-container>
                                                                                <fo:block>
                                                                                    <xsl:text>&#x2029;</xsl:text>
                                                                                </fo:block>
                                                                            </fo:inline-container>
                                                                            <fo:block margin="0pt">
                                                                                <fo:block>
                                                                                    <fo:block>
                                                                                        <fo:leader leader-pattern="space"/>
                                                                                    </fo:block>
                                                                                    <fo:inline-container>
                                                                                        <fo:block>
                                                                                            <xsl:text>&#x2029;</xsl:text>
                                                                                        </fo:block>
                                                                                    </fo:inline-container>
                                                                                    <fo:block margin="0pt">
                                                                                        <fo:block>
                                                                                            <fo:inline-container>
                                                                                                <fo:block>
                                                                                                    <xsl:text>&#x2029;</xsl:text>
                                                                                                </fo:block>
                                          ';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE    data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT CORRESPONDENCE_TEMPLATE INTO data FROM PROTO_CORRESP_TEMPL
WHERE
PROTO_CORRESP_TYPE_CODE=5  AND  COMMITTEE_ID =  'DEFAULT' FOR UPDATE;
buffer := '                                                  </fo:inline-container>
                                                                                            <fo:block white-space="pre" white-space-collapse="false" margin="0pt">
                                                                                                <fo:block>
                                                                                                    <xsl:for-each select="n1:OfficeLocation">
                                                                                                        <xsl:variable name="value-of-template">
                                                                                                            <xsl:apply-templates/>
                                                                                                        </xsl:variable>
                                                                                                        <xsl:choose>
                                                                                                            <xsl:when test="contains(string($value-of-template),''&#x2029;'')">
                                                                                                                <fo:block font-size="10pt">
                                                                                                                    <xsl:copy-of select="$value-of-template"/>
                                                                                                                </fo:block>
                                                                                                            </xsl:when>
                                                                                                            <xsl:otherwise>
                                                                                                                <fo:inline font-size="10pt">
                                                                                                                    <xsl:copy-of select="$value-of-template"/>
                                                                                                                </fo:inline>
                                                                                                            </xsl:otherwise>
                                                                                                        </xsl:choose>
                                                                                                    </xsl:for-each>
                                                                                                </fo:block>
                                                                                            </fo:block>
                                                                                        </fo:block>
                                                                                    </fo:block>
                                                                                </fo:block>
                                                                            </fo:block>
                                                                        </xsl:for-each>
                                                                    </xsl:if>
                                                                </xsl:for-each>
                                                            </xsl:for-each>
                                                        </fo:block>
                                                    </fo:table-cell>
                                                </fo:table-row>
                                                <fo:table-row>
                                                    <fo:table-cell padding="2pt" display-align="before">
                                                        <fo:bl';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE    data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT CORRESPONDENCE_TEMPLATE INTO data FROM PROTO_CORRESP_TEMPL
WHERE
PROTO_CORRESP_TYPE_CODE=5  AND  COMMITTEE_ID =  'DEFAULT' FOR UPDATE;
buffer := 'ock>
                                                            <fo:block>
                                                                <fo:leader leader-pattern="space"/>
                                                            </fo:block>
                                                            <fo:inline-container>
                                                                <fo:block>
                                                                    <xsl:text>&#x2029;</xsl:text>
                                                                </fo:block>
                                                            </fo:inline-container>
                                                            <fo:block margin="0pt">
                                                                <fo:block>
                                                                    <fo:inline font-size="10pt" font-weight="bold">
                                                                        <xsl:text>From:</xsl:text>
                                                                    </fo:inline>
                                                                </fo:block>
                                                            </fo:block>
                                                        </fo:block>
                                                    </fo:table-cell>
                                                    <fo:table-cell padding="2pt" display-align="center">
                                                        <fo:block>
                                                            <fo:block>
                                                                <fo:leader leader-pattern="space"/>
                                                            </fo:block>
                                                            <fo:inline-container>
                                                                <fo:block>
                                                                    <xsl:text>&#x2029;</xsl:text>
                                                                </fo:block>
                                                            </fo:inline-container>
                                                            <fo:block margin="0pt">
                                                                <fo:block>
                                                                    <xsl:for-each select="n1:Protocol">
                                                                        <xsl:if test="n1:Submissions/n1:CurrentSubmissionFlag =&apos;No&apos;">
                                                                            <xsl:for-each select="n1:Submissions">
                                                                                <xsl:for-each select="n1:CommitteeMember">
                                                                                    <xsl:if test="n1:CommitteeMemberRole/n1:MemberRoleDesc = &apos;Chair&apos;">
                                                                                        <xsl:for-each select="n1:Person">
                                                                                            <xsl:for-each select="n1:Firstname">
                                                                                                <xsl:if test="../../../n1:CurrentSubmissionFlag =&apos;No&apos;">
                                                                                                    <xsl:variable name="value-of-template">
                                                                                                        <xsl:apply-templates/>
                                                                                                    </xsl:variable>
                                                                                                    <xsl:choose>
            ';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE    data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT CORRESPONDENCE_TEMPLATE INTO data FROM PROTO_CORRESP_TEMPL
WHERE
PROTO_CORRESP_TYPE_CODE=5  AND  COMMITTEE_ID =  'DEFAULT' FOR UPDATE;
buffer := '                                                                                            <xsl:when test="contains(string($value-of-template),''&#x2029;'')">
                                                                                                            <fo:block font-size="10pt">
                                                                                                                <xsl:copy-of select="$value-of-template"/>
                                                                                                            </fo:block>
                                                                                                        </xsl:when>
                                                                                                        <xsl:otherwise>
                                                                                                            <fo:inline font-size="10pt">
                                                                                                                <xsl:copy-of select="$value-of-template"/>
                                                                                                            </fo:inline>
                                                                                                        </xsl:otherwise>
                                                                                                    </xsl:choose>
                                                                                                </xsl:if>
                                                                                            </xsl:for-each>
                                                                                            <fo:inline font-size="10pt">
                                                                                                <xsl:text>&#160;</xsl:text>
                                                                                            </fo:inline>
                                                                                            <xsl:for-each select="n1:LastName">
                                                                                                <xsl:if test="../../../n1:CurrentSubmissionFlag =&apos;No&apos;">
                                                                                                    <xsl:variable name="value-of-template">
                                                                                                        <xsl:apply-templates/>
                                                                                                    </xsl:variable>
                                                                                                    <xsl:choose>
                                                                                                        <xsl:when test="contains(string($value-of-template),''&#x2029;'')">
                                                                                                            <fo:block font-size="10pt">
                                                                                                                <xsl:copy-of select="$value-of-template"/>
                                                                                                            </fo:block>
                                                                                                        </xsl:when>
                                                                                                        <xsl:otherwise>
                                                                                                            <fo:inline font-size="10pt">
                                                                                                                <xsl:copy-of select="$value-of-template"/>
                                                      ';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE    data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT CORRESPONDENCE_TEMPLATE INTO data FROM PROTO_CORRESP_TEMPL
WHERE
PROTO_CORRESP_TYPE_CODE=5  AND  COMMITTEE_ID =  'DEFAULT' FOR UPDATE;
buffer := '                                                      </fo:inline>
                                                                                                        </xsl:otherwise>
                                                                                                    </xsl:choose>
                                                                                                </xsl:if>
                                                                                            </xsl:for-each>
                                                                                        </xsl:for-each>
                                                                                    </xsl:if>
                                                                                </xsl:for-each>
                                                                            </xsl:for-each>
                                                                        </xsl:if>
                                                                    </xsl:for-each>
                                                                    <fo:inline font-size="10pt">
                                                                        <xsl:text>, Chair </xsl:text>
                                                                    </fo:inline>
                                                                    <fo:block>
                                                                     <fo:leader leader-pattern="space"/>
                                                                    </fo:block>
                                                                    <fo:inline-container>
                                                                        <fo:block>
                                                                            <xsl:text>&#x2029;</xsl:text>
                                                                        </fo:block>
                                                                    </fo:inline-container>
                                                                    <fo:block margin="0pt">
                                                                        <fo:block>
                                                                            <xsl:for-each select="n1:Protocol">
                                                                                <xsl:if test="n1:Submissions/n1:CurrentSubmissionFlag =&apos;No&apos;">
                                                                                    <xsl:for-each select="n1:Submissions">
                                                                                        <xsl:for-each select="n1:CommitteeMasterData">
                                                                                            <xsl:for-each select="n1:CommitteeName">
                                                                                                <xsl:if test="../../n1:CurrentSubmissionFlag =&apos;No&apos;">
                                                                                                    <xsl:variable name="value-of-template">
                                                                                                        <xsl:apply-templates/>
                                                                                                    </xsl:variable>
                                                                                                    <xsl:choose>
                                                                                                        <xsl:when test="contains(string($value-of-template),''&#x2029;'')">
                                                                                                            <fo:block font-size="10pt">
                                                                                                         ';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE    data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT CORRESPONDENCE_TEMPLATE INTO data FROM PROTO_CORRESP_TEMPL
WHERE
PROTO_CORRESP_TYPE_CODE=5  AND  COMMITTEE_ID =  'DEFAULT' FOR UPDATE;
buffer := '       <xsl:copy-of select="$value-of-template"/>
                                                                                                            </fo:block>
                                                                                                        </xsl:when>
                                                                                                        <xsl:otherwise>
                                                                                                            <fo:inline font-size="10pt">
                                                                                                                <xsl:copy-of select="$value-of-template"/>
                                                                                                            </fo:inline>
                                                                                                        </xsl:otherwise>
                                                                                                    </xsl:choose>
                                                                                                </xsl:if>
                                                                                            </xsl:for-each>
                                                                                        </xsl:for-each>
                                                                                    </xsl:for-each>
                                                                                </xsl:if>
                                                                            </xsl:for-each>
                                                                        </fo:block>
                                                                    </fo:block>
                                                                </fo:block>
                                                            </fo:block>
                                                        </fo:block>
                                                    </fo:table-cell>
                                                </fo:table-row>
                                                <fo:table-row>
                                                    <fo:table-cell padding="2pt" display-align="before">
                                                        <fo:block>
                                                            <fo:block>
                                                                <fo:leader leader-pattern="space"/>
                                                            </fo:block>
                                                            <fo:inline-container>
                                                                <fo:block>
                                                                    <xsl:text>&#x2029;</xsl:text>
                                                                </fo:block>
                                                            </fo:inline-container>
                                                            <fo:block margin="0pt">
                                                                <fo:block>
                                                                    <fo:inline font-size="10pt" font-weight="bold">
                                                                        <xsl:text>Date:</xsl:text>
                                                                    </fo:inline>
                                                                </fo:block>
                                                            </fo:block>
                                                        </fo:block>
                                                    </fo:table-cell>
                                                    <fo:table-cell padding="2pt" display-align="center">
                                                     ';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE    data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT CORRESPONDENCE_TEMPLATE INTO data FROM PROTO_CORRESP_TEMPL
WHERE
PROTO_CORRESP_TYPE_CODE=5  AND  COMMITTEE_ID =  'DEFAULT' FOR UPDATE;
buffer := '   <fo:block>
                                                            <fo:block>
                                                                <fo:leader leader-pattern="space"/>
                                                            </fo:block>
                                                            <fo:inline-container>
                                                                <fo:block>
                                                                    <xsl:text>&#x2029;</xsl:text>
                                                                </fo:block>
                                                            </fo:inline-container>
                                                            <fo:block margin="0pt">
                                                                <fo:block>
                                                                    <xsl:for-each select="n1:CurrentDate">
                                                                        <fo:inline font-size="10pt">
                                                                            <xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), ''00'')"/>
                                                                            <xsl:text>/</xsl:text>
                                                                            <xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), ''00'')"/>
                                                                            <xsl:text>/</xsl:text>
                                                                            <xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), ''0000'')"/>
                                                                        </fo:inline>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:block>
                                                        </fo:block>
                                                    </fo:table-cell>
                                                </fo:table-row>
                                                <fo:table-row>
                                                    <fo:table-cell padding="2pt" display-align="before">
                                                        <fo:block>
                                                            <fo:block>
                                                                <fo:leader leader-pattern="space"/>
                                                            </fo:block>
                                                            <fo:inline-container>
                                                                <fo:block>
                                                                    <xsl:text>&#x2029;</xsl:text>
                                                                </fo:block>
                                                            </fo:inline-container>
                                                            <fo:block margin="0pt">
                                                                <fo:block>
                                                                    <fo:inline font-size="10pt" font-weight="bold">
                                                                        <xsl:text>Committee Action:</xsl:text>
                                                                    </fo:inline>
                                                                </fo:block>
                                                            </fo:block>
                                                        </fo:block>
                                                    </fo:table-cell>
                                              ';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE    data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT CORRESPONDENCE_TEMPLATE INTO data FROM PROTO_CORRESP_TEMPL
WHERE
PROTO_CORRESP_TYPE_CODE=5  AND  COMMITTEE_ID =  'DEFAULT' FOR UPDATE;
buffer := '      <fo:table-cell padding="2pt" display-align="center">
                                                        <fo:block>
                                                            <fo:block>
                                                                <fo:leader leader-pattern="space"/>
                                                            </fo:block>
                                                            <fo:inline-container>
                                                                <fo:block>
                                                                    <xsl:text>&#x2029;</xsl:text>
                                                                </fo:block>
                                                            </fo:inline-container>
                                                            <fo:block margin="0pt">
                                                                <fo:block>
                                                                    <xsl:choose>
                                                                        <xsl:when test="n1:Protocol/n1:Submissions/n1:CurrentSubmissionFlag =&apos;No&apos; and   n1:Protocol/n1:Submissions/n1:SubmissionDetails/n1:ProtocolReviewTypeCode  = 1">
                                                                            <fo:inline font-size="10pt" font-weight="bold">
                                                                                <xsl:text>Approval</xsl:text>
                                                                            </fo:inline>
                                                                        </xsl:when>
                                                                        <xsl:when test="n1:Protocol/n1:Submissions/n1:CurrentSubmissionFlag =&apos;No&apos; and  n1:Protocol/n1:Submissions/n1:SubmissionDetails/n1:SubmissionTypeCode = 102 or n1:Protocol/n1:Submissions/n1:SubmissionDetails/n1:IsAmendment = ''true''">
                                                                            <fo:inline font-weight="bold">
                                                                                <xsl:text>Amendment to Approved Protocol</xsl:text>
                                                                            </fo:inline>
                                                                        </xsl:when>
                                                                        <xsl:when test="n1:Protocol/n1:Submissions/n1:CurrentSubmissionFlag =&apos;No&apos; and  n1:Protocol/n1:Submissions/n1:SubmissionDetails/n1:SubmissionTypeCode = 101 or n1:Protocol/n1:Submissions/n1:SubmissionDetails/n1:IsRenewal = ''true''">
                                                                            <fo:inline font-weight="bold">
                                                                                <xsl:text>Renewal</xsl:text>
                                                                            </fo:inline>
                                                                        </xsl:when>
                                                                        <xsl:otherwise>
                                                                            <fo:inline font-weight="bold">
                                                                                <xsl:text>Expedited Approval</xsl:text>
                                                                            </fo:inline>
                                                                        </xsl:otherwise>
                                                                    </xsl:choose>
                                                                </fo:block>
                                                            </fo:block>
                                                        </fo:block>
                                                    </fo:table-cell>
                                                </fo:table-row>
                                            </fo:table-body>
                       ';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE    data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT CORRESPONDENCE_TEMPLATE INTO data FROM PROTO_CORRESP_TEMPL
WHERE
PROTO_CORRESP_TYPE_CODE=5  AND  COMMITTEE_ID =  'DEFAULT' FOR UPDATE;
buffer := '                 </fo:table>
                                        <fo:inline-container>
                                            <fo:block>
                                                <xsl:text>&#x2029;</xsl:text>
                                            </fo:block>
                                        </fo:inline-container>
                                        <fo:table table-layout="fixed" width="100%" border-spacing="2pt">
                                            <fo:table-column column-width="127"/>
                                            <fo:table-column column-width="380"/>
                                            <fo:table-body start-indent="0pt">
                                                <fo:table-row>
                                                    <fo:table-cell padding="2pt" display-align="before">
                                                        <fo:block>
                                                            <fo:inline font-size="10pt" font-weight="bold">
                                                                <xsl:text>Approval Date: </xsl:text>
                                                            </fo:inline>
                                                            <fo:inline font-size="10pt">
                                                                <xsl:text>&#160;&#160;&#160;&#160; </xsl:text>
                                                            </fo:inline>
                                                        </fo:block>
                                                    </fo:table-cell>
                                                    <fo:table-cell padding="2pt" display-align="before">
                                                        <fo:block>
                                                            <xsl:for-each select="n1:Protocol">
                                                                <xsl:for-each select="n1:ProtocolMasterData">
                                                                    <xsl:for-each select="n1:ApprovalDate">
                                                                        <fo:inline>
                                                                            <xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), ''00'')"/>
                                                                            <xsl:text>/</xsl:text>
                                                                         <xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), ''00'')"/>
                                                                            <xsl:text>/</xsl:text>
                                                                            <xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), ''0000'')"/>
                                                                        </fo:inline>
                                                                    </xsl:for-each>
                                                                </xsl:for-each>
                                                            </xsl:for-each>
                                                        </fo:block>
                                                    </fo:table-cell>
                                                </fo:table-row>
                                                <fo:table-row>
                                                    <fo:table-cell padding="2pt" display-align="center">
                                                        <fo:block>
                                                            <fo:inline font-size="10pt" font-weight="bold">
                                                                <xsl:text>IRB Protocol #:</xsl:text>
                                                            </fo:inline>
                 ';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE    data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT CORRESPONDENCE_TEMPLATE INTO data FROM PROTO_CORRESP_TEMPL
WHERE
PROTO_CORRESP_TYPE_CODE=5  AND  COMMITTEE_ID =  'DEFAULT' FOR UPDATE;
buffer := '                                           <fo:inline font-size="10pt">
                                                                <xsl:text>&#160;&#160;&#160; </xsl:text>
                                                            </fo:inline>
                                                        </fo:block>
                                                    </fo:table-cell>
                                                    <fo:table-cell padding="2pt" display-align="before">
                                                        <fo:block>
                                                            <xsl:for-each select="n1:Protocol">
                                                                <xsl:for-each select="n1:ProtocolMasterData">
                                                                    <xsl:for-each select="n1:ProtocolNumber">
                                                                        <xsl:variable name="value-of-template">
                                                                            <xsl:apply-templates/>
                                                                        </xsl:variable>
                                                                        <xsl:choose>
                                                                            <xsl:when test="contains(string($value-of-template),''&#x2029;'')">
                                                                                <fo:block font-size="10pt">
                                                                                    <xsl:copy-of select="$value-of-template"/>
                                                                                </fo:block>
                                                                            </xsl:when>
                                                                            <xsl:otherwise>
                                                                                <fo:inline font-size="10pt">
                                                                                    <xsl:copy-of select="$value-of-template"/>
                                                                                </fo:inline>
                                                                            </xsl:otherwise>
                                                                        </xsl:choose>
                                                                    </xsl:for-each>
                                                                </xsl:for-each>
                                                            </xsl:for-each>
                                                        </fo:block>
                                                    </fo:table-cell>
                                                </fo:table-row>
                                                <fo:table-row>
                                                    <fo:table-cell padding="2pt" display-align="center">
                                                        <fo:block>
                                                            <fo:inline font-size="10pt" font-weight="bold">
                                                                <xsl:text>Study Title: </xsl:text>
                                                            </fo:inline>
                                                            <fo:inline font-size="10pt">
                                                                <xsl:text>&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160; </xsl:text>
                                                            </fo:inline>
                                                        </fo:block>
                                                    </fo:table-cell>
                                                    <fo:table-cell padding="2pt" display-align="before">
                    ';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE    data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT CORRESPONDENCE_TEMPLATE INTO data FROM PROTO_CORRESP_TEMPL
WHERE
PROTO_CORRESP_TYPE_CODE=5  AND  COMMITTEE_ID =  'DEFAULT' FOR UPDATE;
buffer := '                                    <fo:block>
                                                            <xsl:for-each select="n1:Protocol">
                                                                <xsl:for-each select="n1:ProtocolMasterData">
                                                                    <xsl:for-each select="n1:ProtocolTitle">
                                                                        <xsl:variable name="value-of-template">
                                                                            <xsl:apply-templates/>
                                                                        </xsl:variable>
                                                                        <xsl:choose>
                                                                            <xsl:when test="contains(string($value-of-template),''&#x2029;'')">
                                                                                <fo:block font-size="10pt">
                                                                                    <xsl:copy-of select="$value-of-template"/>
                                                                                </fo:block>
                                                                            </xsl:when>
                                                                            <xsl:otherwise>
                                                                                <fo:inline font-size="10pt">
                                                                                    <xsl:copy-of select="$value-of-template"/>
                                                                                </fo:inline>
                                                                            </xsl:otherwise>
                                                                        </xsl:choose>
                                                                    </xsl:for-each>
                                                                </xsl:for-each>
                                                            </xsl:for-each>
                                                        </fo:block>
                                                    </fo:table-cell>
                                                </fo:table-row>
                                                <fo:table-row>
                                                    <fo:table-cell padding="2pt" display-align="center">
                                                        <fo:block>
                                                            <fo:inline font-weight="bold">
                                                                <xsl:text>Expiration Date:</xsl:text>
                                                            </fo:inline>

                                                        </fo:block>
                                                    </fo:table-cell>
                                                    <fo:table-cell padding="2pt" display-align="before">
                                                        <fo:block>
                                                            <xsl:for-each select="n1:Protocol">
                                                                <xsl:for-each select="n1:ProtocolMasterData">
                                                                    <xsl:for-each select="n1:ExpirationDate">
                                                                        <fo:inline>
                                                                            <xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), ''00'')"/>
                                                                            <xsl:text>/</xsl:text>
                                                                            <xsl:value-of select="format-number(number(substring(string';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE    data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT CORRESPONDENCE_TEMPLATE INTO data FROM PROTO_CORRESP_TEMPL
WHERE
PROTO_CORRESP_TYPE_CODE=5  AND  COMMITTEE_ID =  'DEFAULT' FOR UPDATE;
buffer := '(string(.)), 9, 2)), ''00'')"/>
                                                                            <xsl:text>/</xsl:text>
                                                                            <xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), ''0000'')"/>
                                                                        </fo:inline>
                                                                    </xsl:for-each>
                                                                </xsl:for-each>
                                                            </xsl:for-each>
                                                        </fo:block>
                                                    </fo:table-cell>
                                                </fo:table-row>
												<fo:table-row>
                                                            <fo:table-cell padding="2pt" display-align="before">
                                                                <fo:block>
                                                                    <fo:inline font-size="10pt" font-weight="bold">
                                                                     <xsl:text>Last Approval Date </xsl:text>
                                                                    </fo:inline>
                                                                    <fo:inline font-size="10pt">
                                                                        <xsl:text>&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160;&#160; </xsl:text>
                                                                    </fo:inline>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                            <fo:table-cell padding="2pt" display-align="before">
                                                                <fo:block>
                                                                    <xsl:for-each select="n1:Protocol">
                                                                        <xsl:for-each select="n1:ProtocolMasterData">
                                                                            <xsl:for-each select="n1:LastApprovalDate">
                                                                                <fo:inline>
                                                                                    <xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), ''00'')"/>
                                                                                    <xsl:text>/</xsl:text>
                                                                                    <xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), ''00'')"/>
                                                                                    <xsl:text>/</xsl:text>
                                                                                    <xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), ''0000'')"/>
                                                                                </fo:inline>
                                                                            </xsl:for-each>
                                                                        </xsl:for-each>
                                                                    </xsl:for-each>
                                                                </fo:block>
                                                            </fo:table-cell>
                                                        </fo:table-row>
                                            </fo:table-body>
                                        </fo:table>
                                    </f';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE    data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT CORRESPONDENCE_TEMPLATE INTO data FROM PROTO_CORRESP_TEMPL
WHERE
PROTO_CORRESP_TYPE_CODE=5  AND  COMMITTEE_ID =  'DEFAULT' FOR UPDATE;
buffer := 'o:block>
                                </fo:block>
                                <fo:block>
                                    <fo:leader leader-pattern="space"/>
                                </fo:block>
                                <fo:inline-container>
                                    <fo:block>
                                        <xsl:text>&#x2029;</xsl:text>
                                    </fo:block>
                                </fo:inline-container>
                                <fo:block margin="0pt">
                                    <fo:block>
                                        <xsl:choose>
                                            <xsl:when test="n1:Protocol/n1:Submissions/n1:CurrentSubmissionFlag =&apos;No&apos; and   n1:Protocol/n1:Submissions/n1:SubmissionDetails/n1:ProtocolReviewTypeCode  = 1">
                                                <fo:inline font-family="Arial" font-size="10pt">
                                                    <xsl:text>T</xsl:text>
                                                </fo:inline>
                                                <fo:inline font-family="Arial" font-size="10pt">
                                                    <xsl:text>he above-referenced protocol has been APPROVED following Full Board Review by the Institutional Review Board for the period of </xsl:text>
                                                </fo:inline>
                                                <xsl:for-each select="n1:Protocol">
                                                    <xsl:for-each select="n1:ProtocolMasterData">
                                                        <xsl:for-each select="n1:ApprovalDate">
                                                            <fo:inline font-family="Arial" font-size="10pt">
                                                                <xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), ''00'')"/>
                                                                <xsl:text>/</xsl:text>
                                                                <xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), ''00'')"/>
                                                                <xsl:text>/</xsl:text>
                                                                <xsl:value-of select="format-number(number(substring(string(string(string(.))), 1, 4)), ''0000'')"/>
                                                            </fo:inline>
                                                        </xsl:for-each>
                                                    </xsl:for-each>
                                                </xsl:for-each>
                                                <fo:inline font-family="Arial" font-size="10pt">
                                                    <xsl:text> through </xsl:text>
                                                </fo:inline>
                                                <xsl:for-each select="n1:Protocol">
                                                    <xsl:for-each select="n1:ProtocolMasterData">
                                                        <xsl:for-each select="n1:ExpirationDate">
                                                            <fo:inline font-family="Arial" font-size="10pt">
                                                                <xsl:value-of select="format-number(number(substring(string(string(.)), 6, 2)), ''00'')"/>
                                                                <xsl:text>/</xsl:text>
                                                                <xsl:value-of select="format-number(number(substring(string(string(.)), 9, 2)), ''00'')"/>
                                                                <xsl:text>/</xsl:text>
                                                                <xsl:value-of se';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE    data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT CORRESPONDENCE_TEMPLATE INTO data FROM PROTO_CORRESP_TEMPL
WHERE
PROTO_CORRESP_TYPE_CODE=5  AND  COMMITTEE_ID =  'DEFAULT' FOR UPDATE;
buffer := 'lect="format-number(number(substring(string(string(string(.))), 1, 4)), ''0000'')"/>
                                                            </fo:inline>
                                                        </xsl:for-each>
                                                    </xsl:for-each>
                                                </xsl:for-each>
                                                <fo:inline font-family="Arial" font-size="10pt">
                                                    <xsl:text>.&#160; This approval does not replace any departmental or other approvals that may be required.&#160; It is the Principal Investigator&apos;s responsibility to obtain review and continued approval of ongoing research before the expiration date noted above.&#160; Please allow sufficient time for reapproval.&#160; Research activity of any sort may not continue beyond the expiration date without committee approval.&#160; Failure to receive approval for continuation before the expiration date will result in the automatic suspension of the approval of this protocol on the expiration date.&#160; Information</xsl:text>
                                                </fo:inline>
                                                <fo:inline font-family="Arial" font-size="10pt" font-weight="bold">
                                                    <xsl:text>&#160;</xsl:text>
                                                </fo:inline>
                                                <fo:inline font-family="Arial" font-size="10pt">
                                                    <xsl:text>collected following suspension is unapproved research and cannot be reported or published as research data.&#160; </xsl:text>
                                                </fo:inline>
                                                <fo:block/>
                                                <fo:block>
                                                    <fo:leader leader-pattern="space"/>
                                                </fo:block>
                                                <fo:inline-container>
                                                    <fo:block>
                                                        <xsl:text>&#x2029;</xsl:text>
                                                    </fo:block>
                                                </fo:inline-container>
                                                <fo:block margin="0pt">
                                                    <fo:block>
                                                        <fo:inline font-family="Arial" font-size="10pt">
                                                            <xsl:text>If you do not wish continued approval, please notify the Committee of the study termination.</xsl:text>
                                                        </fo:inline>
                                                        <fo:inline font-family="Arial" font-size="10pt">
                                                            <xsl:text>This approval by the </xsl:text>
                                                        </fo:inline>
                                                        <xsl:for-each select="n1:Protocol">
                                                            <xsl:if test="n1:Submissions/n1:CurrentSubmissionFlag =&apos;No&apos;">
                                                                <xsl:for-each select="n1:Submissions">
                                                                    <xsl:for-each select="n1:CommitteeMasterData">
                                                                        <xsl:for-each select="n1:CommitteeName">
                                                                            <xsl:if test="../../n1:CurrentSubmissionFlag =&apos;No&apos;">
                                                                                <x';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE    data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT CORRESPONDENCE_TEMPLATE INTO data FROM PROTO_CORRESP_TEMPL
WHERE
PROTO_CORRESP_TYPE_CODE=5  AND  COMMITTEE_ID =  'DEFAULT' FOR UPDATE;
buffer := 'sl:variable name="value-of-template">
                                                                                    <xsl:apply-templates/>
                                                                                </xsl:variable>
                                                                                <xsl:choose>
                                                                                    <xsl:when test="contains(string($value-of-template),''&#x2029;'')">
                                                                                        <fo:block font-family="Arial" font-size="10pt">
                                                                                            <xsl:copy-of select="$value-of-template"/>
                                                                                        </fo:block>
                                                                                    </xsl:when>
                                                                                    <xsl:otherwise>
                                                                                        <fo:inline font-family="Arial" font-size="10pt">
                                                                                            <xsl:copy-of select="$value-of-template"/>
                                                                                        </fo:inline>
                                                                                    </xsl:otherwise>
                                                                                </xsl:choose>
                                                                            </xsl:if>
                                                                        </xsl:for-each>
                                                                    </xsl:for-each>
                                                                </xsl:for-each>
                                                            </xsl:if>
                                                        </xsl:for-each>
                                                        <fo:inline font-family="Arial" font-size="10pt">
                                                            <xsl:text> does not replace or supersede any departmental or oversight committee review that may be required by institutional policy.</xsl:text>
                                                        </fo:inline>
                                                    </fo:block>
                                                </fo:block>
                                            </xsl:when>
                                            <xsl:when test="n1:Protocol/n1:Submissions/n1:CurrentSubmissionFlag =&apos;No&apos; and  n1:Protocol/n1:Submissions/n1:SubmissionDetails/n1:SubmissionTypeCode = 102 or n1:Protocol/n1:Submissions/n1:SubmissionDetails/n1:IsAmendment = ''true''">
                                                <fo:inline font-family="Arial" font-size="10pt">
                                                    <xsl:text>The amendment to the above-referenced protocol has been APPROVED following Expedited Review by the Institutional Review Board.</xsl:text>
                                                </fo:inline>
                                                <fo:inline font-family="Arial" font-size="10pt">
                                                    <xsl:text>&#160;</xsl:text>
                                                </fo:inline>
                                                <fo:inline font-family="Arial" font-size="10pt">
                                                    <xsl:text> This approval does not replace any departmental or other approvals that may be required.&#160; It is the Principal Investigator&apos;s responsibility to obtain review and continued approval of ongoing research before the expiration noted above.&#160; Please allow sufficient time for reapproval.&#160; Research activity of any sort may no';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE    data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT CORRESPONDENCE_TEMPLATE INTO data FROM PROTO_CORRESP_TEMPL
WHERE
PROTO_CORRESP_TYPE_CODE=5  AND  COMMITTEE_ID =  'DEFAULT' FOR UPDATE;
buffer := 't continue beyond the expiration date without committee approval.&#160; Failure to receive approval for continuation before the expiration date will result in the automatic suspension of the approval of this protocol on the expiration date.&#160; Information</xsl:text>
                                                </fo:inline>
                                                <fo:inline font-family="Arial" font-size="10pt" font-weight="bold">
                                                    <xsl:text>&#160;</xsl:text>
                                                </fo:inline>
                                                <fo:inline font-family="Arial" font-size="10pt">
                                                    <xsl:text>collected following suspension is unapproved research and cannot be reported or published as research data.&#160; If you do not wish continued approval, please notify the Committee of the study termination.</xsl:text>
                                                </fo:inline>
                                                <fo:block/>
                                                <fo:inline font-family="Arial" font-size="10pt">
                                                    <xsl:text>This approval by the </xsl:text>
                                                </fo:inline>
                                                <xsl:for-each select="n1:Protocol">
                                                    <xsl:for-each select="n1:Submissions">
                                                        <xsl:for-each select="n1:CommitteeMasterData">
                                                            <xsl:for-each select="n1:CommitteeName">
                                                                <xsl:if test="../../n1:CurrentSubmissionFlag =&apos;No&apos;">
                                                                    <xsl:variable name="value-of-template">
                                                                        <xsl:apply-templates/>
                                                                    </xsl:variable>
                                                                    <xsl:choose>
                                                                        <xsl:when test="contains(string($value-of-template),''&#x2029;'')">
                                                                            <fo:block font-family="Arial" font-size="10pt">
                                                                                <xsl:copy-of select="$value-of-template"/>
                                                                            </fo:block>
                                                                        </xsl:when>
                                                                        <xsl:otherwise>
                                                                            <fo:inline font-family="Arial" font-size="10pt">
                                                                                <xsl:copy-of select="$value-of-template"/>
                                                                            </fo:inline>
                                                                        </xsl:otherwise>
                                                                    </xsl:choose>
                                                                </xsl:if>
                                                            </xsl:for-each>
                                                        </xsl:for-each>
                                                    </xsl:for-each>
                                                </xsl:for-each>
                                                <fo:inline font-family="Arial" font-size="10pt">
                                                    <xsl:text> does not replace or supersede any departmental or oversight committee review tha';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE    data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT CORRESPONDENCE_TEMPLATE INTO data FROM PROTO_CORRESP_TEMPL
WHERE
PROTO_CORRESP_TYPE_CODE=5  AND  COMMITTEE_ID =  'DEFAULT' FOR UPDATE;
buffer := 't may be required by institutional policy.</xsl:text>
                                                </fo:inline>
                                            </xsl:when>
                                            <xsl:when test="n1:Protocol/n1:Submissions/n1:CurrentSubmissionFlag =&apos;No&apos; and n1:Protocol/n1:Submissions/n1:SubmissionDetails/n1:SubmissionTypeCode = 101 or n1:Protocol/n1:Submissions/n1:SubmissionDetails/n1:IsRenewal = ''true''">
                                                <fo:inline font-family="Arial" font-size="10pt">
                                                    <xsl:text>The above-referenced protocol was given renewed approval following Expedited Review by the Institutional Review Board.&#160; </xsl:text>
                                                </fo:inline>
                                                <fo:block/>
                                                <fo:inline font-family="Arial" font-size="10pt">
                                                    <xsl:text>It is the Principal Investigator&apos;s responsibility to obtain review and continued approval of ongoing research before the expiration noted above.&#160; Please allow sufficient time for reapproval.&#160; Research activity of any sort may not continue beyond the expiration date without committee approval.&#160; Failure to receive approval for continuation before the expiration date will result in the automatic suspension of the approval of this protocol on the expiration date.&#160; Information</xsl:text>
                                                </fo:inline>
                                                <fo:inline font-family="Arial" font-size="10pt" font-weight="bold">
                                                    <xsl:text>&#160;</xsl:text>
                                                </fo:inline>
                                                <fo:inline font-family="Arial" font-size="10pt">
                                                    <xsl:text>collected following suspension is unapproved research and cannot be reported or published as research data.&#160; If you do not wish continued approval, please notify the Committee of the study termination.</xsl:text>
                                                </fo:inline>
                                                <fo:block/>
                                                <fo:inline font-family="Arial" font-size="10pt">
                                                    <xsl:text>This approval by the </xsl:text>
                                                </fo:inline>
                                                <xsl:for-each select="n1:Protocol">
                                                    <xsl:for-each select="n1:Submissions">
                                                        <xsl:for-each select="n1:CommitteeMasterData">
                                                            <xsl:for-each select="n1:CommitteeName">
                                                                <xsl:if test="../../n1:CurrentSubmissionFlag =&apos;No&apos;">
                                                                    <xsl:variable name="value-of-template">
                                                                        <xsl:apply-templates/>
                                                                    </xsl:variable>
                                                                    <xsl:choose>
                                                                        <xsl:when test="contains(string($value-of-template),''&#x2029;'')">
                                                                            <fo:block font-family="Arial" font-size="10pt">
                                                                                <xsl:copy-of select="$value-of-template"/>
                                                                            </fo:block>
                                                                        </xsl:';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE    data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT CORRESPONDENCE_TEMPLATE INTO data FROM PROTO_CORRESP_TEMPL
WHERE
PROTO_CORRESP_TYPE_CODE=5  AND  COMMITTEE_ID =  'DEFAULT' FOR UPDATE;
buffer := 'when>
                                                                        <xsl:otherwise>
                                                                            <fo:inline font-family="Arial" font-size="10pt">
                                                                                <xsl:copy-of select="$value-of-template"/>
                                                                            </fo:inline>
                                                                        </xsl:otherwise>
                                                                    </xsl:choose>
                                                                </xsl:if>
                                                            </xsl:for-each>
                                                        </xsl:for-each>
                                                    </xsl:for-each>
                                                </xsl:for-each>
                                                <fo:inline font-family="Arial" font-size="10pt">
                                                    <xsl:text> does not replace or supersede any departmental or oversight committee review that may be required by institutional policy.</xsl:text>
                                                </fo:inline>
                                            </xsl:when>
                                            <xsl:otherwise>
                                                <fo:inline font-size="10pt">
                                                    <xsl:text>The above-referenced protocol was approved following expedited review by the Institutional Review Board.</xsl:text>
                                                </fo:inline>
                                                <fo:block/>
                                                <fo:inline font-size="10pt">
                                                    <xsl:text>It is the Principal Investigator&apos;s responsibility to obtain review and continued approval before the expiration date.&#160; You may not continue any research activity beyond the expiration date without approval by the Institutional Review Board.</xsl:text>
                                                </fo:inline>
                                            </xsl:otherwise>
                                        </xsl:choose>
                                        <fo:block/>
                                        <fo:inline font-family="Arial" font-size="10pt">
                                            <xsl:text>Adverse Reactions:&#160; If any untoward incidents or severe reactions should develop as a result of this study, you are required to notify the&#160; </xsl:text>
                                        </fo:inline>
                                        <xsl:for-each select="n1:Protocol">
                                            <xsl:if test="n1:Submissions/n1:CurrentSubmissionFlag =&apos;No&apos;">
                                                <xsl:for-each select="n1:Submissions">
                                                    <xsl:for-each select="n1:CommitteeMasterData">
                                                        <xsl:for-each select="n1:CommitteeName">
                                                            <xsl:if test="../../n1:CurrentSubmissionFlag =&apos;No&apos;">
                                                                <xsl:variable name="value-of-template">
                                                                    <xsl:apply-templates/>
                                                                </xsl:variable>
                                                                <xsl:choose>
                                                                    <xsl:when test="contains(string($value-of-template),''&#x2029;'')">
                                                                        <fo:block f';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE    data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT CORRESPONDENCE_TEMPLATE INTO data FROM PROTO_CORRESP_TEMPL
WHERE
PROTO_CORRESP_TYPE_CODE=5  AND  COMMITTEE_ID =  'DEFAULT' FOR UPDATE;
buffer := 'ont-family="Arial" font-size="10pt">
                                                                            <xsl:copy-of select="$value-of-template"/>
                                                                        </fo:block>
                                                                    </xsl:when>
                                                                    <xsl:otherwise>
                                                                        <fo:inline font-family="Arial" font-size="10pt">
                                                                            <xsl:copy-of select="$value-of-template"/>
                                                                        </fo:inline>
                                                                    </xsl:otherwise>
                                                                </xsl:choose>
                                                            </xsl:if>
                                                        </xsl:for-each>
                                                    </xsl:for-each>
                                                </xsl:for-each>
                                            </xsl:if>
                                        </xsl:for-each>
                                        <fo:inline font-size="10pt">
                                            <xsl:text>&#160;</xsl:text>
                                        </fo:inline>
                                        <fo:inline font-family="Arial" font-size="10pt">
                                            <xsl:text>i</xsl:text>
                                        </fo:inline>
                                        <fo:inline font-family="Arial" font-size="10pt">
                                            <xsl:text>mmediately.&#160; If necessary a member of the IRB will be assigned to look into the matter.&#160; If the problem is serious, approval may be withdrawn pending IRB review.</xsl:text>
                                        </fo:inline>
                                        <fo:block/>
                                        <fo:inline font-family="Arial" font-size="10pt">
                                            <xsl:text>Amendments: If you wish to change any aspect of this study, such as the procedures, the consent forms, or the investigators, please communicate your requested changes to the</xsl:text>
                                        </fo:inline>
                                        <fo:inline font-size="10pt">
                                            <xsl:text>&#160;</xsl:text>
                                        </fo:inline>
                                        <xsl:for-each select="n1:Protocol">
                                            <xsl:if test="n1:Submissions/n1:CurrentSubmissionFlag =&apos;No&apos;">
                                                <xsl:for-each select="n1:Submissions">
                                                    <xsl:for-each select="n1:CommitteeMasterData">
                                                        <xsl:for-each select="n1:CommitteeName">
                                                            <xsl:if test="../../n1:CurrentSubmissionFlag =&apos;No&apos;">
                                                                <xsl:variable name="value-of-template">
                                                                    <xsl:apply-templates/>
                                                                </xsl:variable>
                                                                <xsl:choose>
                                                                    <xsl:when test="contains(string($value-of-template),''&#x2029;'')">
                                                                        <fo:block font-family="Arial" font-size="10pt">
                                                                 ';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE    data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT CORRESPONDENCE_TEMPLATE INTO data FROM PROTO_CORRESP_TEMPL
WHERE
PROTO_CORRESP_TYPE_CODE=5  AND  COMMITTEE_ID =  'DEFAULT' FOR UPDATE;
buffer := '           <xsl:copy-of select="$value-of-template"/>
                                                                        </fo:block>
                                                                    </xsl:when>
                                                                    <xsl:otherwise>
                                                                        <fo:inline font-family="Arial" font-size="10pt">
                                                                            <xsl:copy-of select="$value-of-template"/>
                                                                        </fo:inline>
                                                                    </xsl:otherwise>
                                                                </xsl:choose>
                                                            </xsl:if>
                                                        </xsl:for-each>
                                                    </xsl:for-each>
                                                </xsl:for-each>
                                            </xsl:if>
                                        </xsl:for-each>
                                        <fo:inline font-size="10pt">
                                            <xsl:text>.&#160; </xsl:text>
                                        </fo:inline>
                                        <fo:inline font-family="Arial" font-size="10pt">
                                            <xsl:text>The new procedure is not to be initiated until the IRB approval has been given.</xsl:text>
                                        </fo:inline>
                                        <fo:block/>
                                        <fo:inline font-family="Arial" font-size="10pt">
                                            <xsl:text>Please retain a copy of this letter with your approved protocol.</xsl:text>
                                        </fo:inline>
                                        <fo:block/>
                                        <fo:inline>
                                            <xsl:text>
</xsl:text>
                                        </fo:inline>
                                        <fo:inline>
                                            <xsl:text>
</xsl:text>
                                        </fo:inline>
                                        <fo:inline-container>
                                            <fo:block>
                                                <xsl:text>&#x2029;</xsl:text>
                                            </fo:block>
                                        </fo:inline-container>
                                        <fo:table page-break-before="auto" table-layout="auto" width="100%" border-spacing="2pt">
                                            <fo:table-column column-width="25"/>
                                            <fo:table-column column-width="proportional-column-width(1)"/>
                                            <fo:table-body start-indent="0pt">
                                                <fo:table-row>
                                                    <fo:table-cell padding="2pt" display-align="before">
                                                        <fo:block>
                                                            <xsl:if test="(n1:Protocol/n1:KeyStudyPerson/n1:Person/n1:PersonID != &apos;null&apos;)  and  (n1:Protocol/n1:Correspondent/n1:Person/n1:PersonID != &apos;null&apos;)">
                                                                <fo:inline font-size="10pt">
                                                                    <xsl:text>cc:</xsl:text>
                                                                </fo:inline>
                                                            </xsl:if>
                                                        </fo:blo';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE    data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT CORRESPONDENCE_TEMPLATE INTO data FROM PROTO_CORRESP_TEMPL
WHERE
PROTO_CORRESP_TYPE_CODE=5  AND  COMMITTEE_ID =  'DEFAULT' FOR UPDATE;
buffer := 'ck>
                                                    </fo:table-cell>
                                                    <fo:table-cell padding="2pt" display-align="center">
                                                        <fo:block>
                                                            <xsl:for-each select="n1:Protocol">
                                                                <xsl:for-each select="n1:KeyStudyPerson">
                                                                    <xsl:for-each select="n1:Person">
                                                                        <xsl:for-each select="n1:Fullname">
                                                                         <xsl:variable name="value-of-template">
                                                                                <xsl:apply-templates/>
                                                                            </xsl:variable>
                                                                            <xsl:choose>
                                                                                <xsl:when test="contains(string($value-of-template),''&#x2029;'')">
                                                                                    <fo:block font-size="10pt">
                                                                                        <xsl:copy-of select="$value-of-template"/>
                                                                                    </fo:block>
                                                                                </xsl:when>
                                                                                <xsl:otherwise>
                                                                                    <fo:inline font-size="10pt">
                                                                                        <xsl:copy-of select="$value-of-template"/>
                                                                                    </fo:inline>
                                                                                </xsl:otherwise>
                                                                            </xsl:choose>
                                                                        </xsl:for-each>
                                                                    </xsl:for-each>
                                                                </xsl:for-each>
                                                                <xsl:for-each select="n1:Correspondent">
                                                                    <xsl:if test="n1:TypeOfCorrespondent  = &apos;Protocol level&apos;">
                                                                        <xsl:for-each select="n1:Person">
                                                                            <xsl:for-each select="n1:Fullname">
                                                                                <xsl:variable name="value-of-template">
                                                                                    <xsl:apply-templates/>
                                                                                </xsl:variable>
                                                                                <xsl:choose>
                                                                                    <xsl:when test="contains(string($value-of-template),''&#x2029;'')">
                                                                                        <fo:block font-size="10pt">
                                                                                            <xsl:copy-of select="$value-of-template"/>
                                                                                        </fo:block>
                                                                          ';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE    data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT CORRESPONDENCE_TEMPLATE INTO data FROM PROTO_CORRESP_TEMPL
WHERE
PROTO_CORRESP_TYPE_CODE=5  AND  COMMITTEE_ID =  'DEFAULT' FOR UPDATE;
buffer := '          </xsl:when>
                                                                                    <xsl:otherwise>
                                                                                        <fo:inline font-size="10pt">
                                                                                            <xsl:copy-of select="$value-of-template"/>
                                                                                        </fo:inline>
                                                                                    </xsl:otherwise>
                                                                                </xsl:choose>
                                                                            </xsl:for-each>
                                                                        </xsl:for-each>
                                                                    </xsl:if>
                                                                </xsl:for-each>
                                                            </xsl:for-each>
                                                        </fo:block>
                                                    </fo:table-cell>
                                                </fo:table-row>
                                            </fo:table-body>
                                        </fo:table>
                                        <fo:block/>
                                        <fo:inline font-size="10pt">
                                            <xsl:text>
</xsl:text>
                                        </fo:inline>
                                    </fo:block>
                                </fo:block>
                            </xsl:for-each>
                        </xsl:for-each>
                    </fo:block>
                    <fo:block id="SV_RefID_PageTotal"/>
                </fo:flow>
            </fo:page-sequence>
        </fo:root>
    </xsl:template>
    <xsl:template name="headerall">
        <fo:static-content flow-name="xsl-region-before">
            <fo:block>
                <xsl:for-each select="$XML">
                    <fo:inline-container>
                        <fo:block>
                            <xsl:text>&#x2029;</xsl:text>
                        </fo:block>
                    </fo:inline-container>
                    <fo:table table-layout="fixed" width="100%" border-spacing="2pt">
                        <fo:table-column column-width="proportional-column-width(1)"/>
                        <fo:table-column column-width="150"/>
                        <fo:table-body start-indent="0pt">
                            <fo:table-row>
                                <fo:table-cell padding="0" number-columns-spanned="2" height="30" display-align="center">
                                    <fo:block/>
                                </fo:table-cell>
                            </fo:table-row>
                            <fo:table-row>
                                <fo:table-cell font-size="smaller" padding="0" text-align="left" display-align="center">
                                    <fo:block/>
                                </fo:table-cell>
                                <fo:table-cell font-size="smaller" padding="0" text-align="right" display-align="center">
                                    <fo:block/>
                                </fo:table-cell>
                            </fo:table-row>
                            <fo:table-row>
                                <fo:table-cell padding="0" number-columns-spanned="2" display-align="center">
                                    <fo:block/>
                                </fo:table-cell>
                            </fo:table-row>
                        </fo:table-body>
                    </fo:table>
                </xsl:for-each>
            </fo:block>
        <';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
DECLARE    data CLOB; buffer VARCHAR2(30000);
BEGIN
SELECT CORRESPONDENCE_TEMPLATE INTO data FROM PROTO_CORRESP_TEMPL
WHERE
PROTO_CORRESP_TYPE_CODE=5  AND  COMMITTEE_ID =  'DEFAULT' FOR UPDATE;
buffer := '/fo:static-content>
    </xsl:template>
    <xsl:template name="double-backslash">
        <xsl:param name="text"/>
        <xsl:param name="text-length"/>
        <xsl:variable name="text-after-bs" select="substring-after($text, ''\'')"/>
        <xsl:variable name="text-after-bs-length" select="string-length($text-after-bs)"/>
        <xsl:choose>
            <xsl:when test="$text-after-bs-length = 0">
                <xsl:choose>
                    <xsl:when test="substring($text, $text-length) = ''\''">
                        <xsl:value-of select="concat(substring($text,1,$text-length - 1), ''\\'')"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:value-of select="$text"/>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="concat(substring($text,1,$text-length - $text-after-bs-length - 1), ''\\'')"/>
                <xsl:call-template name="double-backslash">
                    <xsl:with-param name="text" select="$text-after-bs"/>
                    <xsl:with-param name="text-length" select="$text-after-bs-length"/>
                </xsl:call-template>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
</xsl:stylesheet>';
DBMS_LOB.writeappend(data,LENGTH(buffer),buffer);
end;
/
commit;
